// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"./assert.js";const WRAPPER_CSS_CLASS="search-highlight-wrapper";const ORIGINAL_CONTENT_CSS_CLASS="search-highlight-original-content";const HIT_CSS_CLASS="search-highlight-hit";const SEARCH_BUBBLE_CSS_CLASS="search-bubble";export function removeHighlights(wrappers){for(const wrapper of wrappers){if(!wrapper.parentElement){continue}const originalContent=wrapper.querySelector(`.${ORIGINAL_CONTENT_CSS_CLASS}`);assert(originalContent);const textNode=originalContent.firstChild;assert(textNode);wrapper.parentElement.replaceChild(textNode,wrapper)}}export function findAndRemoveHighlights(node){const wrappers=Array.from(node.querySelectorAll(`.${WRAPPER_CSS_CLASS}`));assert(wrappers.length===1);removeHighlights(wrappers)}export function highlight(node,ranges){assert(ranges.length>0);const wrapper=document.createElement("span");wrapper.classList.add(WRAPPER_CSS_CLASS);assert(node.parentNode);node.parentNode.replaceChild(wrapper,node);const span=document.createElement("span");span.classList.add(ORIGINAL_CONTENT_CSS_CLASS);span.style.display="none";span.appendChild(node);wrapper.appendChild(span);const text=node.textContent;const tokens=[];for(let i=0;i<ranges.length;++i){const range=ranges[i];const prev=ranges[i-1]||{start:0,length:0};const start=prev.start+prev.length;const length=range.start-start;tokens.push(text.substr(start,length));tokens.push(text.substr(range.start,range.length))}const last=ranges.slice(-1)[0];tokens.push(text.substr(last.start+last.length));for(let i=0;i<tokens.length;++i){if(i%2===0){wrapper.appendChild(document.createTextNode(tokens[i]))}else{const hitSpan=document.createElement("span");hitSpan.classList.add(HIT_CSS_CLASS);hitSpan.style.backgroundColor="var(--search-highlight-hit-background-color, #ffeb3b)";hitSpan.style.color="var(--search-highlight-hit-color, #202124)";hitSpan.textContent=tokens[i];wrapper.appendChild(hitSpan)}}return wrapper}export function createEmptySearchBubble(node,horizontallyCenter){let anchor=node;if(node.nodeName==="SELECT"){anchor=node.parentNode}if(anchor instanceof ShadowRoot){anchor=anchor.host.parentNode}let searchBubble=anchor.querySelector(`.${SEARCH_BUBBLE_CSS_CLASS}`);if(searchBubble){return searchBubble}searchBubble=document.createElement("div");searchBubble.classList.add(SEARCH_BUBBLE_CSS_CLASS);const innards=document.createElement("div");innards.classList.add("search-bubble-innards");innards.textContent=" ";searchBubble.appendChild(innards);anchor.appendChild(searchBubble);const updatePosition=function(){const nodeEl=node;assert(searchBubble);assert(typeof nodeEl.offsetTop==="number");searchBubble.style.top=nodeEl.offsetTop+(innards.classList.contains("above")?-searchBubble.offsetHeight:nodeEl.offsetHeight)+"px";if(horizontallyCenter){const width=nodeEl.offsetWidth-searchBubble.offsetWidth;searchBubble.style.left=nodeEl.offsetLeft+width/2+"px"}};updatePosition();searchBubble.addEventListener("mouseover",(function(){innards.classList.toggle("above");updatePosition()}));return searchBubble}export function stripDiacritics(text){return text.normalize("NFD").replace(/[\u0300-\u036f]/g,"")}