// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";export class CrSplitterElement extends HTMLElement{static get is(){return"cr-splitter"}handlers_=null;startX_=0;startWidth_=-1;resizeNextElement=false;constructor(){super();this.addEventListener("mousedown",(e=>this.onMouseDown_(e)));this.addEventListener("touchstart",(e=>this.onTouchStart_(e)))}connectedCallback(){this.handlers_=new Map}disconnectedCallback(){this.removeAllHandlers_();this.handlers_=null}startDrag(clientX,isTouchEvent){assert(!!this.handlers_);if(this.handlers_.size>0){this.endDrag_()}if(isTouchEvent){const endDragBound=this.endDrag_.bind(this);this.handlers_.set("touchmove",this.handleTouchMove_.bind(this));this.handlers_.set("touchend",endDragBound);this.handlers_.set("touchcancel",endDragBound);this.handlers_.set("touchstart",endDragBound)}else{this.handlers_.set("mousemove",this.handleMouseMove_.bind(this));this.handlers_.set("mouseup",this.handleMouseUp_.bind(this))}const doc=this.ownerDocument;for(const[eventType,handler]of this.handlers_){doc.addEventListener(eventType,handler,true)}this.startX_=clientX;this.handleSplitterDragStart_()}removeAllHandlers_(){const doc=this.ownerDocument;assert(!!this.handlers_);for(const[eventType,handler]of this.handlers_){doc.removeEventListener(eventType,handler,true)}this.handlers_.clear()}endDrag_(){this.removeAllHandlers_();this.handleSplitterDragEnd_()}getResizeTarget_(){const target=this.resizeNextElement?this.nextElementSibling:this.previousElementSibling;return target}calcDeltaX_(deltaX){return this.resizeNextElement?-deltaX:deltaX}onMouseDown_(e){if(e.button){return}this.startDrag(e.clientX,false);e.preventDefault()}onTouchStart_(e){if(e.touches.length===1){this.startDrag(e.touches[0].clientX,true);e.preventDefault()}}handleMouseMove_(e){this.handleMove_(e.clientX)}handleTouchMove_(e){if(e.touches.length===1){this.handleMove_(e.touches[0].clientX)}}handleMove_(clientX){const deltaX=this.matches(":host-context([dir=rtl]) cr-splitter")?this.startX_-clientX:clientX-this.startX_;this.handleSplitterDragMove_(deltaX)}handleMouseUp_(_e){this.endDrag_()}handleSplitterDragStart_(){const targetElement=this.getResizeTarget_();const doc=targetElement.ownerDocument;this.startWidth_=parseFloat(doc.defaultView.getComputedStyle(targetElement).width)+targetElement.offsetWidth-targetElement.clientWidth;this.classList.add("splitter-active")}handleSplitterDragMove_(deltaX){const targetElement=this.getResizeTarget_();const newWidth=this.startWidth_+this.calcDeltaX_(deltaX);targetElement.style.width=newWidth+"px";this.dispatchEvent(new CustomEvent("dragmove"))}handleSplitterDragEnd_(){const targetElement=this.getResizeTarget_();const doc=targetElement.ownerDocument;const computedWidth=parseFloat(doc.defaultView.getComputedStyle(targetElement).width);if(this.startWidth_!==computedWidth){this.dispatchEvent(new CustomEvent("resize"))}this.classList.remove("splitter-active")}}customElements.define(CrSplitterElement.is,CrSplitterElement);