// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import"../cr_button/cr_button.js";import"../cr_grid/cr_grid.js";import"../cr_icon/cr_icon.js";import"../cr_tooltip/cr_tooltip.js";import"../icons.html.js";import{assert}from"//resources/js/assert.js";import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./cr_profile_avatar_selector.css.js";import{getHtml}from"./cr_profile_avatar_selector.html.js";export class CrProfileAvatarSelectorElement extends CrLitElement{static get is(){return"cr-profile-avatar-selector"}static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{avatars:{type:Array},selectedAvatar:{type:Object,notify:true},ignoreModifiedKeyEvents:{type:Boolean},tabFocusableAvatar_:{type:Number},columns:{type:Number}}}#avatars_accessor_storage=[];get avatars(){return this.#avatars_accessor_storage}set avatars(value){this.#avatars_accessor_storage=value}#selectedAvatar_accessor_storage=null;get selectedAvatar(){return this.#selectedAvatar_accessor_storage}set selectedAvatar(value){this.#selectedAvatar_accessor_storage=value}#ignoreModifiedKeyEvents_accessor_storage=false;get ignoreModifiedKeyEvents(){return this.#ignoreModifiedKeyEvents_accessor_storage}set ignoreModifiedKeyEvents(value){this.#ignoreModifiedKeyEvents_accessor_storage=value}#columns_accessor_storage=6;get columns(){return this.#columns_accessor_storage}set columns(value){this.#columns_accessor_storage=value}#tabFocusableAvatar__accessor_storage=-1;get tabFocusableAvatar_(){return this.#tabFocusableAvatar__accessor_storage}set tabFocusableAvatar_(value){this.#tabFocusableAvatar__accessor_storage=value}willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("avatars")||changedProperties.has("selectedAvatar")){const selectedAvatar=this.avatars.find((avatar=>this.isAvatarSelected_(avatar)));this.tabFocusableAvatar_=selectedAvatar?selectedAvatar.index:-1}}getAvatarId_(index){return"avatarId"+index}getTabIndex_(index,item){if(item.index===this.tabFocusableAvatar_){return"0"}if(this.tabFocusableAvatar_===-1&&index===0){return"0"}return"-1"}getSelectedClass_(avatarItem){return this.isAvatarSelected_(avatarItem)?"iron-selected":""}isAvatarSelected_(avatarItem){return avatarItem.selected||!!this.selectedAvatar&&this.selectedAvatar.index===avatarItem.index}onAvatarClick_(e){const target=e.currentTarget;const index=Number(target.dataset["index"]);this.selectedAvatar=this.avatars[index];const avatarList=this.shadowRoot.querySelectorAll(".avatar-container");assert(avatarList.length>0);const selectedAvatarElement=avatarList[index];selectedAvatarElement.scrollIntoViewIfNeeded()}}customElements.define(CrProfileAvatarSelectorElement.is,CrProfileAvatarSelectorElement);