// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{assert}from"//resources/js/assert.js";import{getDeepActiveElement}from"//resources/js/util.js";import{CrLitElement,html,render}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./cr_lazy_list.css.js";export class CrLazyListElement extends CrLitElement{static get is(){return"cr-lazy-list"}static get styles(){return getCss()}render(){const host=this.listItemHost===undefined?this.getRootNode().host:this.listItemHost;if(this.chunkSize===0){render(this.items.slice(0,this.numItemsDisplayed_).map(((item,index)=>this.template(item,index))),this,{host:host})}else{const chunks=Math.ceil(this.numItemsDisplayed_/this.chunkSize);const chunkArray=new Array(chunks).fill(0);render(chunkArray.map(((_item,index)=>html`<div id="chunk-${index}" class="chunk">
                                     </div>`)),this,{host:host});for(let chunkIndex=0;chunkIndex<chunks;chunkIndex++){const start=chunkIndex*this.chunkSize;const end=Math.min(this.numItemsDisplayed_,(chunkIndex+1)*this.chunkSize);const chunk=this.querySelector(`#chunk-${chunkIndex}`);assert(chunk);render(this.items.slice(start,end).map(((item,index)=>this.template(item,start+index))),chunk,{host:host})}}return html`<div id="container"><slot id="slot"></slot></div>`}static get properties(){return{chunkSize:{type:Number,reflect:true},items:{type:Array},itemSize:{type:Number},listItemHost:{type:Object},minViewportHeight:{type:Number},scrollOffset:{type:Number},scrollTarget:{type:Object},restoreFocusElement:{type:Object},template:{type:Object},numItemsDisplayed_:{state:true,type:Number}}}#items_accessor_storage=[];get items(){return this.#items_accessor_storage}set items(value){this.#items_accessor_storage=value}#itemSize_accessor_storage=undefined;get itemSize(){return this.#itemSize_accessor_storage}set itemSize(value){this.#itemSize_accessor_storage=value}#listItemHost_accessor_storage;get listItemHost(){return this.#listItemHost_accessor_storage}set listItemHost(value){this.#listItemHost_accessor_storage=value}#minViewportHeight_accessor_storage;get minViewportHeight(){return this.#minViewportHeight_accessor_storage}set minViewportHeight(value){this.#minViewportHeight_accessor_storage=value}#scrollOffset_accessor_storage=0;get scrollOffset(){return this.#scrollOffset_accessor_storage}set scrollOffset(value){this.#scrollOffset_accessor_storage=value}#scrollTarget_accessor_storage=document.documentElement;get scrollTarget(){return this.#scrollTarget_accessor_storage}set scrollTarget(value){this.#scrollTarget_accessor_storage=value}#restoreFocusElement_accessor_storage=null;get restoreFocusElement(){return this.#restoreFocusElement_accessor_storage}set restoreFocusElement(value){this.#restoreFocusElement_accessor_storage=value}#template_accessor_storage=()=>html``;get template(){return this.#template_accessor_storage}set template(value){this.#template_accessor_storage=value}#chunkSize_accessor_storage=0;get chunkSize(){return this.#chunkSize_accessor_storage}set chunkSize(value){this.#chunkSize_accessor_storage=value}#numItemsDisplayed__accessor_storage=0;get numItemsDisplayed_(){return this.#numItemsDisplayed__accessor_storage}set numItemsDisplayed_(value){this.#numItemsDisplayed__accessor_storage=value}lastItemsLength_=0;lastRenderedHeight_=0;resizeObserver_=null;scrollListener_=()=>this.onScroll_();willUpdate(changedProperties){super.willUpdate(changedProperties);if(changedProperties.has("items")){this.lastItemsLength_=this.items.length;this.numItemsDisplayed_=this.items.length===0?0:Math.min(this.numItemsDisplayed_,this.items.length)}else{assert(this.items.length===this.lastItemsLength_,"Items array changed in place; rendered result may be incorrect.")}if(changedProperties.has("itemSize")){this.style.setProperty("--list-item-size",`${this.itemSize}px`)}if(changedProperties.has("chunkSize")){this.style.setProperty("--chunk-size",`${this.chunkSize}`)}}updated(changedProperties){super.updated(changedProperties);let itemsChanged=false;if(changedProperties.has("items")||changedProperties.has("minViewportHeight")||changedProperties.has("scrollOffset")){const previous=changedProperties.get("items");if(previous!==undefined||this.items.length!==0){this.onItemsChanged_();itemsChanged=true}}if(changedProperties.has("scrollTarget")){this.addRemoveScrollTargetListeners_(changedProperties.get("scrollTarget")||null);if(this.scrollTarget&&this.items.length>0&&!itemsChanged){this.fillCurrentViewport()}}}fillCurrentViewport(){if(this.items.length===0){return Promise.resolve()}return this.update_(this.$.container.style.height==="0px")}async ensureItemRendered(index){if(index<this.numItemsDisplayed_){return this.domItems()[index]}assert(index<this.items.length);await this.updateNumItemsDisplayed_(index+1);return this.domItems()[index]}addRemoveScrollTargetListeners_(oldTarget){if(oldTarget){const target=oldTarget===document.documentElement?window:oldTarget;target.removeEventListener("scroll",this.scrollListener_);assert(this.resizeObserver_);this.resizeObserver_.disconnect()}if(this.scrollTarget){const target=this.scrollTarget===document.documentElement?window:this.scrollTarget;target.addEventListener("scroll",this.scrollListener_);this.resizeObserver_=new ResizeObserver((()=>{requestAnimationFrame((()=>{const newHeight=this.getViewHeight_();if(newHeight>0&&newHeight!==this.lastRenderedHeight_){this.fillCurrentViewport()}}))}));this.resizeObserver_.observe(this.scrollTarget)}}shouldRestoreFocus_(){if(!this.restoreFocusElement){return false}const active=getDeepActiveElement();return this.restoreFocusElement===active||!!this.restoreFocusElement.shadowRoot&&this.restoreFocusElement.shadowRoot.activeElement===active}async onItemsChanged_(){if(this.items.length>0){const restoreFocus=this.shouldRestoreFocus_();await this.update_(true);if(restoreFocus){setTimeout((()=>{if(!this.restoreFocusElement){return}this.restoreFocusElement.focus();this.fire("focus-restored-for-test")}),0)}}else{this.$.container.style.height="0px";this.fire("items-rendered");this.fire("viewport-filled")}}getScrollTop_(){return this.scrollTarget===document.documentElement?window.pageYOffset:this.scrollTarget.scrollTop}getViewHeight_(){const offsetHeight=this.scrollTarget===document.documentElement?window.innerHeight:this.scrollTarget.offsetHeight;return this.getScrollTop_()-this.scrollOffset+Math.max(this.minViewportHeight||0,offsetHeight)}async update_(forceUpdateHeight){if(!this.scrollTarget){return}const height=this.getViewHeight_();if(height<=0){return}const added=await this.fillViewHeight_(height);this.fire("items-rendered");if(added||forceUpdateHeight){await this.updateHeight_();this.fire("viewport-filled")}}async fillViewHeight_(height){this.fire("fill-height-start");this.lastRenderedHeight_=height;assert(this.items.length);const initialDomItemCount=this.domItems().length;if(initialDomItemCount===0){await this.updateNumItemsDisplayed_(1)}const itemHeight=this.domItemAverageHeight_();if(itemHeight===0){this.lastRenderedHeight_=0;return false}const desiredDomItemCount=Math.min(Math.ceil(height/itemHeight),this.items.length);if(desiredDomItemCount>this.numItemsDisplayed_){await this.updateNumItemsDisplayed_(desiredDomItemCount)}const added=initialDomItemCount!==desiredDomItemCount;if(added){this.fire("fill-height-end")}return added}async updateNumItemsDisplayed_(itemsToDisplay){this.numItemsDisplayed_=itemsToDisplay;if(this.numItemsDisplayed_>200&&this.chunkSize<2){console.warn(`cr-lazy-list: ${this.numItemsDisplayed_} list items rendered. `+"If this is expected, consider chunking mode (chunkSize > 1) "+"to improve scrolling performance.")}await this.updateComplete}domItems(){return this.chunkSize===0?this.$.slot.assignedElements():Array.from(this.querySelectorAll(".chunk > *"))}domItemAverageHeight_(){assert(this.items.length>0);const domItems=this.domItems();assert(domItems.length>0);const firstDomItem=domItems.at(0);const lastDomItem=domItems.at(-1);const lastDomItemHeight=lastDomItem.offsetHeight;if(firstDomItem===lastDomItem&&lastDomItemHeight===0){return 0}else if(this.itemSize){return this.itemSize}let totalHeight=lastDomItem.offsetTop+lastDomItemHeight;if(this.chunkSize>0){totalHeight+=lastDomItem.offsetParent.offsetTop-firstDomItem.offsetParent.offsetTop}else{totalHeight-=firstDomItem.offsetTop}return totalHeight/domItems.length}async updateHeight_(){await new Promise((resolve=>setTimeout(resolve,0)));const estScrollHeight=this.items.length>0?this.items.length*this.domItemAverageHeight_():0;this.$.container.style.height=estScrollHeight+"px"}async onScroll_(){const scrollTop=this.getScrollTop_();if(scrollTop<=0||this.numItemsDisplayed_===this.items.length){return}await this.fillCurrentViewport()}}customElements.define(CrLazyListElement.is,CrLazyListElement);