// ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_THEME_COLOR_PICKER_THEME_COLOR_PICKER_MOJOM_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_THEME_COLOR_PICKER_THEME_COLOR_PICKER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom-features.h"  // IWYU pragma: export
#include "ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom-shared.h"  // IWYU pragma: export
#include "ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom-forward.h"  // IWYU pragma: export
#include "skia/public/mojom/skcolor.mojom.h"
#include "ui/base/mojom/themes.mojom-forward.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace theme_color_picker::mojom {

class ThemeColorPickerHandlerFactoryProxy;

template <typename ImplRefTraits>
class ThemeColorPickerHandlerFactoryStub;

class ThemeColorPickerHandlerFactoryRequestValidator;


class ThemeColorPickerHandlerFactory
    : public ThemeColorPickerHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "theme_color_picker.mojom.ThemeColorPickerHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ThemeColorPickerHandlerFactoryInterfaceBase;
  using Proxy_ = ThemeColorPickerHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = ThemeColorPickerHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = ThemeColorPickerHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreateThemeColorPickerHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateThemeColorPickerHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ThemeColorPickerHandlerFactory() = default;

  virtual void CreateThemeColorPickerHandler(::mojo::PendingReceiver<ThemeColorPickerHandler> handler, ::mojo::PendingRemote<ThemeColorPickerClient> client) = 0;
};

class ThemeColorPickerHandlerProxy;

template <typename ImplRefTraits>
class ThemeColorPickerHandlerStub;

class ThemeColorPickerHandlerRequestValidator;
class ThemeColorPickerHandlerResponseValidator;


class ThemeColorPickerHandler
    : public ThemeColorPickerHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "theme_color_picker.mojom.ThemeColorPickerHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ThemeColorPickerHandlerInterfaceBase;
  using Proxy_ = ThemeColorPickerHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = ThemeColorPickerHandlerStub<ImplRefTraits>;

  using RequestValidator_ = ThemeColorPickerHandlerRequestValidator;
  using ResponseValidator_ = ThemeColorPickerHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGetChromeColorsMinVersion = 0,
    kUpdateThemeMinVersion = 0,
    kSetDefaultColorMinVersion = 0,
    kSetGreyDefaultColorMinVersion = 0,
    kSetSeedColorMinVersion = 0,
    kSetSeedColorFromHueMinVersion = 0,
    kRemoveBackgroundImageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct GetChromeColors_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateTheme_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetDefaultColor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetGreyDefaultColor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSeedColor_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetSeedColorFromHue_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveBackgroundImage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ThemeColorPickerHandler() = default;

  using GetChromeColorsCallback = base::OnceCallback<void(std::vector<ChromeColorPtr>)>;
  using GetChromeColorsMojoCallback = base::OnceCallback<void(std::vector<ChromeColorPtr>)>;

  virtual void GetChromeColors(bool is_dark_mode, GetChromeColorsCallback callback) = 0;

  virtual void UpdateTheme() = 0;

  virtual void SetDefaultColor() = 0;

  virtual void SetGreyDefaultColor() = 0;

  virtual void SetSeedColor(::SkColor seed_color, ::ui::mojom::BrowserColorVariant variant) = 0;

  virtual void SetSeedColorFromHue(float hue) = 0;

  virtual void RemoveBackgroundImage() = 0;
};

class ThemeColorPickerClientProxy;

template <typename ImplRefTraits>
class ThemeColorPickerClientStub;

class ThemeColorPickerClientRequestValidator;


class ThemeColorPickerClient
    : public ThemeColorPickerClientInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "theme_color_picker.mojom.ThemeColorPickerClient";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = ThemeColorPickerClientInterfaceBase;
  using Proxy_ = ThemeColorPickerClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = ThemeColorPickerClientStub<ImplRefTraits>;

  using RequestValidator_ = ThemeColorPickerClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetThemeMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetTheme_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~ThemeColorPickerClient() = default;

  virtual void SetTheme(ThemePtr theme) = 0;
};



class  ThemeColorPickerHandlerFactoryProxy
    : public ThemeColorPickerHandlerFactory {
 public:
  using InterfaceType = ThemeColorPickerHandlerFactory;

  explicit ThemeColorPickerHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateThemeColorPickerHandler(::mojo::PendingReceiver<ThemeColorPickerHandler> handler, ::mojo::PendingRemote<ThemeColorPickerClient> client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ThemeColorPickerHandlerProxy
    : public ThemeColorPickerHandler {
 public:
  using InterfaceType = ThemeColorPickerHandler;

  explicit ThemeColorPickerHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void GetChromeColors(bool is_dark_mode, GetChromeColorsCallback callback) final;
  
  void UpdateTheme() final;
  
  void SetDefaultColor() final;
  
  void SetGreyDefaultColor() final;
  
  void SetSeedColor(::SkColor seed_color, ::ui::mojom::BrowserColorVariant variant) final;
  
  void SetSeedColorFromHue(float hue) final;
  
  void RemoveBackgroundImage() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ThemeColorPickerClientProxy
    : public ThemeColorPickerClient {
 public:
  using InterfaceType = ThemeColorPickerClient;

  explicit ThemeColorPickerClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetTheme(ThemePtr theme) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  ThemeColorPickerHandlerFactoryStubDispatch {
 public:
  static bool Accept(ThemeColorPickerHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ThemeColorPickerHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ThemeColorPickerHandlerFactory>>
class ThemeColorPickerHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ThemeColorPickerHandlerFactoryStub() = default;
  ~ThemeColorPickerHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ThemeColorPickerHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ThemeColorPickerHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ThemeColorPickerHandlerStubDispatch {
 public:
  static bool Accept(ThemeColorPickerHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ThemeColorPickerHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ThemeColorPickerHandler>>
class ThemeColorPickerHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ThemeColorPickerHandlerStub() = default;
  ~ThemeColorPickerHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ThemeColorPickerHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ThemeColorPickerHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ThemeColorPickerClientStubDispatch {
 public:
  static bool Accept(ThemeColorPickerClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ThemeColorPickerClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ThemeColorPickerClient>>
class ThemeColorPickerClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ThemeColorPickerClientStub() = default;
  ~ThemeColorPickerClientStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ThemeColorPickerClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ThemeColorPickerClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ThemeColorPickerHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ThemeColorPickerHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ThemeColorPickerClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ThemeColorPickerHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  Theme {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Theme, T>::value>;
  using DataView = ThemeDataView;
  using Data_ = internal::Theme_Data;

  template <typename... Args>
  static ThemePtr New(Args&&... args) {
    return ThemePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ThemePtr From(const U& u) {
    return mojo::TypeConverter<ThemePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Theme>::Convert(*this);
  }


  Theme();

  Theme(
      bool has_background_image,
      bool has_third_party_theme,
      std::optional<::SkColor> background_image_main_color,
      bool is_dark_mode,
      ::SkColor seed_color,
      float seed_color_hue,
      ::SkColor background_color,
      std::optional<::SkColor> foreground_color,
      ::SkColor color_picker_icon_color,
      bool colors_managed_by_policy,
      bool is_grey_baseline,
      ::ui::mojom::BrowserColorVariant browser_color_variant,
      bool follow_device_theme);


  ~Theme();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ThemePtr>
  ThemePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Theme::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Theme::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Theme::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Theme::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Theme::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Theme::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Theme_UnserializedMessageContext<
            UserType, Theme::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Theme::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Theme::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Theme_UnserializedMessageContext<
            UserType, Theme::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Theme::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool has_background_image;
  
  bool has_third_party_theme;
  
  std::optional<::SkColor> background_image_main_color;
  
  bool is_dark_mode;
  
  ::SkColor seed_color;
  
  float seed_color_hue;
  
  ::SkColor background_color;
  
  std::optional<::SkColor> foreground_color;
  
  ::SkColor color_picker_icon_color;
  
  bool colors_managed_by_policy;
  
  bool is_grey_baseline;
  
  ::ui::mojom::BrowserColorVariant browser_color_variant;
  
  bool follow_device_theme;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Theme::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ChromeColor {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ChromeColor, T>::value>;
  using DataView = ChromeColorDataView;
  using Data_ = internal::ChromeColor_Data;

  template <typename... Args>
  static ChromeColorPtr New(Args&&... args) {
    return ChromeColorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ChromeColorPtr From(const U& u) {
    return mojo::TypeConverter<ChromeColorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ChromeColor>::Convert(*this);
  }


  ChromeColor();

  ChromeColor(
      const std::string& name,
      ::SkColor seed,
      ::SkColor background,
      ::SkColor foreground,
      ::SkColor base,
      ::ui::mojom::BrowserColorVariant variant);


  ~ChromeColor();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ChromeColorPtr>
  ChromeColorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ChromeColor::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ChromeColor::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ChromeColor::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChromeColor::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ChromeColor::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ChromeColor::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ChromeColor_UnserializedMessageContext<
            UserType, ChromeColor::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ChromeColor::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ChromeColor::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ChromeColor_UnserializedMessageContext<
            UserType, ChromeColor::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ChromeColor::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string name;
  
  ::SkColor seed;
  
  ::SkColor background;
  
  ::SkColor foreground;
  
  ::SkColor base;
  
  ::ui::mojom::BrowserColorVariant variant;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ChromeColor::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ChromeColor::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ChromeColor::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ChromeColor::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ThemePtr Theme::Clone() const {
  return New(
      mojo::Clone(has_background_image),
      mojo::Clone(has_third_party_theme),
      mojo::Clone(background_image_main_color),
      mojo::Clone(is_dark_mode),
      mojo::Clone(seed_color),
      mojo::Clone(seed_color_hue),
      mojo::Clone(background_color),
      mojo::Clone(foreground_color),
      mojo::Clone(color_picker_icon_color),
      mojo::Clone(colors_managed_by_policy),
      mojo::Clone(is_grey_baseline),
      mojo::Clone(browser_color_variant),
      mojo::Clone(follow_device_theme)
  );
}

template <typename T, Theme::EnableIfSame<T>*>
bool Theme::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->has_background_image, other_struct.has_background_image))
    return false;
  if (!mojo::Equals(this->has_third_party_theme, other_struct.has_third_party_theme))
    return false;
  if (!mojo::Equals(this->background_image_main_color, other_struct.background_image_main_color))
    return false;
  if (!mojo::Equals(this->is_dark_mode, other_struct.is_dark_mode))
    return false;
  if (!mojo::Equals(this->seed_color, other_struct.seed_color))
    return false;
  if (!mojo::Equals(this->seed_color_hue, other_struct.seed_color_hue))
    return false;
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->foreground_color, other_struct.foreground_color))
    return false;
  if (!mojo::Equals(this->color_picker_icon_color, other_struct.color_picker_icon_color))
    return false;
  if (!mojo::Equals(this->colors_managed_by_policy, other_struct.colors_managed_by_policy))
    return false;
  if (!mojo::Equals(this->is_grey_baseline, other_struct.is_grey_baseline))
    return false;
  if (!mojo::Equals(this->browser_color_variant, other_struct.browser_color_variant))
    return false;
  if (!mojo::Equals(this->follow_device_theme, other_struct.follow_device_theme))
    return false;
  return true;
}

template <typename T, Theme::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.has_background_image < rhs.has_background_image)
    return true;
  if (rhs.has_background_image < lhs.has_background_image)
    return false;
  if (lhs.has_third_party_theme < rhs.has_third_party_theme)
    return true;
  if (rhs.has_third_party_theme < lhs.has_third_party_theme)
    return false;
  if (lhs.background_image_main_color < rhs.background_image_main_color)
    return true;
  if (rhs.background_image_main_color < lhs.background_image_main_color)
    return false;
  if (lhs.is_dark_mode < rhs.is_dark_mode)
    return true;
  if (rhs.is_dark_mode < lhs.is_dark_mode)
    return false;
  if (lhs.seed_color < rhs.seed_color)
    return true;
  if (rhs.seed_color < lhs.seed_color)
    return false;
  if (lhs.seed_color_hue < rhs.seed_color_hue)
    return true;
  if (rhs.seed_color_hue < lhs.seed_color_hue)
    return false;
  if (lhs.background_color < rhs.background_color)
    return true;
  if (rhs.background_color < lhs.background_color)
    return false;
  if (lhs.foreground_color < rhs.foreground_color)
    return true;
  if (rhs.foreground_color < lhs.foreground_color)
    return false;
  if (lhs.color_picker_icon_color < rhs.color_picker_icon_color)
    return true;
  if (rhs.color_picker_icon_color < lhs.color_picker_icon_color)
    return false;
  if (lhs.colors_managed_by_policy < rhs.colors_managed_by_policy)
    return true;
  if (rhs.colors_managed_by_policy < lhs.colors_managed_by_policy)
    return false;
  if (lhs.is_grey_baseline < rhs.is_grey_baseline)
    return true;
  if (rhs.is_grey_baseline < lhs.is_grey_baseline)
    return false;
  if (lhs.browser_color_variant < rhs.browser_color_variant)
    return true;
  if (rhs.browser_color_variant < lhs.browser_color_variant)
    return false;
  if (lhs.follow_device_theme < rhs.follow_device_theme)
    return true;
  if (rhs.follow_device_theme < lhs.follow_device_theme)
    return false;
  return false;
}
template <typename StructPtrType>
ChromeColorPtr ChromeColor::Clone() const {
  return New(
      mojo::Clone(name),
      mojo::Clone(seed),
      mojo::Clone(background),
      mojo::Clone(foreground),
      mojo::Clone(base),
      mojo::Clone(variant)
  );
}

template <typename T, ChromeColor::EnableIfSame<T>*>
bool ChromeColor::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->name, other_struct.name))
    return false;
  if (!mojo::Equals(this->seed, other_struct.seed))
    return false;
  if (!mojo::Equals(this->background, other_struct.background))
    return false;
  if (!mojo::Equals(this->foreground, other_struct.foreground))
    return false;
  if (!mojo::Equals(this->base, other_struct.base))
    return false;
  if (!mojo::Equals(this->variant, other_struct.variant))
    return false;
  return true;
}

template <typename T, ChromeColor::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.name < rhs.name)
    return true;
  if (rhs.name < lhs.name)
    return false;
  if (lhs.seed < rhs.seed)
    return true;
  if (rhs.seed < lhs.seed)
    return false;
  if (lhs.background < rhs.background)
    return true;
  if (rhs.background < lhs.background)
    return false;
  if (lhs.foreground < rhs.foreground)
    return true;
  if (rhs.foreground < lhs.foreground)
    return false;
  if (lhs.base < rhs.base)
    return true;
  if (rhs.base < lhs.base)
    return false;
  if (lhs.variant < rhs.variant)
    return true;
  if (rhs.variant < lhs.variant)
    return false;
  return false;
}


}  // theme_color_picker::mojom

namespace mojo {


template <>
struct  StructTraits<::theme_color_picker::mojom::Theme::DataView,
                                         ::theme_color_picker::mojom::ThemePtr> {
  static bool IsNull(const ::theme_color_picker::mojom::ThemePtr& input) { return !input; }
  static void SetToNull(::theme_color_picker::mojom::ThemePtr* output) { output->reset(); }

  static decltype(::theme_color_picker::mojom::Theme::has_background_image) has_background_image(
      const ::theme_color_picker::mojom::ThemePtr& input) {
    return input->has_background_image;
  }

  static decltype(::theme_color_picker::mojom::Theme::has_third_party_theme) has_third_party_theme(
      const ::theme_color_picker::mojom::ThemePtr& input) {
    return input->has_third_party_theme;
  }

  static const decltype(::theme_color_picker::mojom::Theme::background_image_main_color)& background_image_main_color(
      const ::theme_color_picker::mojom::ThemePtr& input) {
    return input->background_image_main_color;
  }

  static decltype(::theme_color_picker::mojom::Theme::is_dark_mode) is_dark_mode(
      const ::theme_color_picker::mojom::ThemePtr& input) {
    return input->is_dark_mode;
  }

  static const decltype(::theme_color_picker::mojom::Theme::seed_color)& seed_color(
      const ::theme_color_picker::mojom::ThemePtr& input) {
    return input->seed_color;
  }

  static decltype(::theme_color_picker::mojom::Theme::seed_color_hue) seed_color_hue(
      const ::theme_color_picker::mojom::ThemePtr& input) {
    return input->seed_color_hue;
  }

  static const decltype(::theme_color_picker::mojom::Theme::background_color)& background_color(
      const ::theme_color_picker::mojom::ThemePtr& input) {
    return input->background_color;
  }

  static const decltype(::theme_color_picker::mojom::Theme::foreground_color)& foreground_color(
      const ::theme_color_picker::mojom::ThemePtr& input) {
    return input->foreground_color;
  }

  static const decltype(::theme_color_picker::mojom::Theme::color_picker_icon_color)& color_picker_icon_color(
      const ::theme_color_picker::mojom::ThemePtr& input) {
    return input->color_picker_icon_color;
  }

  static decltype(::theme_color_picker::mojom::Theme::colors_managed_by_policy) colors_managed_by_policy(
      const ::theme_color_picker::mojom::ThemePtr& input) {
    return input->colors_managed_by_policy;
  }

  static decltype(::theme_color_picker::mojom::Theme::is_grey_baseline) is_grey_baseline(
      const ::theme_color_picker::mojom::ThemePtr& input) {
    return input->is_grey_baseline;
  }

  static decltype(::theme_color_picker::mojom::Theme::browser_color_variant) browser_color_variant(
      const ::theme_color_picker::mojom::ThemePtr& input) {
    return input->browser_color_variant;
  }

  static decltype(::theme_color_picker::mojom::Theme::follow_device_theme) follow_device_theme(
      const ::theme_color_picker::mojom::ThemePtr& input) {
    return input->follow_device_theme;
  }

  static bool Read(::theme_color_picker::mojom::Theme::DataView input, ::theme_color_picker::mojom::ThemePtr* output);
};


template <>
struct  StructTraits<::theme_color_picker::mojom::ChromeColor::DataView,
                                         ::theme_color_picker::mojom::ChromeColorPtr> {
  static bool IsNull(const ::theme_color_picker::mojom::ChromeColorPtr& input) { return !input; }
  static void SetToNull(::theme_color_picker::mojom::ChromeColorPtr* output) { output->reset(); }

  static const decltype(::theme_color_picker::mojom::ChromeColor::name)& name(
      const ::theme_color_picker::mojom::ChromeColorPtr& input) {
    return input->name;
  }

  static const decltype(::theme_color_picker::mojom::ChromeColor::seed)& seed(
      const ::theme_color_picker::mojom::ChromeColorPtr& input) {
    return input->seed;
  }

  static const decltype(::theme_color_picker::mojom::ChromeColor::background)& background(
      const ::theme_color_picker::mojom::ChromeColorPtr& input) {
    return input->background;
  }

  static const decltype(::theme_color_picker::mojom::ChromeColor::foreground)& foreground(
      const ::theme_color_picker::mojom::ChromeColorPtr& input) {
    return input->foreground;
  }

  static const decltype(::theme_color_picker::mojom::ChromeColor::base)& base(
      const ::theme_color_picker::mojom::ChromeColorPtr& input) {
    return input->base;
  }

  static decltype(::theme_color_picker::mojom::ChromeColor::variant) variant(
      const ::theme_color_picker::mojom::ChromeColorPtr& input) {
    return input->variant;
  }

  static bool Read(::theme_color_picker::mojom::ChromeColor::DataView input, ::theme_color_picker::mojom::ChromeColorPtr* output);
};

}  // namespace mojo

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_THEME_COLOR_PICKER_THEME_COLOR_PICKER_MOJOM_H_