// ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom-params-data.h"
#include "ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom-shared-message-ids.h"

#include "ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom-import-headers.h"
#include "ui/webui/resources/cr_components/theme_color_picker/theme_color_picker.mojom-test-utils.h"


namespace theme_color_picker::mojom {
Theme::Theme()
    : has_background_image(),
      has_third_party_theme(),
      background_image_main_color(),
      is_dark_mode(),
      seed_color(),
      seed_color_hue(),
      background_color(),
      foreground_color(),
      color_picker_icon_color(),
      colors_managed_by_policy(),
      is_grey_baseline(),
      browser_color_variant(),
      follow_device_theme() {}

Theme::Theme(
    bool has_background_image_in,
    bool has_third_party_theme_in,
    std::optional<::SkColor> background_image_main_color_in,
    bool is_dark_mode_in,
    ::SkColor seed_color_in,
    float seed_color_hue_in,
    ::SkColor background_color_in,
    std::optional<::SkColor> foreground_color_in,
    ::SkColor color_picker_icon_color_in,
    bool colors_managed_by_policy_in,
    bool is_grey_baseline_in,
    ::ui::mojom::BrowserColorVariant browser_color_variant_in,
    bool follow_device_theme_in)
    : has_background_image(std::move(has_background_image_in)),
      has_third_party_theme(std::move(has_third_party_theme_in)),
      background_image_main_color(std::move(background_image_main_color_in)),
      is_dark_mode(std::move(is_dark_mode_in)),
      seed_color(std::move(seed_color_in)),
      seed_color_hue(std::move(seed_color_hue_in)),
      background_color(std::move(background_color_in)),
      foreground_color(std::move(foreground_color_in)),
      color_picker_icon_color(std::move(color_picker_icon_color_in)),
      colors_managed_by_policy(std::move(colors_managed_by_policy_in)),
      is_grey_baseline(std::move(is_grey_baseline_in)),
      browser_color_variant(std::move(browser_color_variant_in)),
      follow_device_theme(std::move(follow_device_theme_in)) {}

Theme::~Theme() = default;

void Theme::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_background_image"), this->has_background_image,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_third_party_theme"), this->has_third_party_theme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_image_main_color"), this->background_image_main_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::SkColor>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_dark_mode"), this->is_dark_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seed_color"), this->seed_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seed_color_hue"), this->seed_color_hue,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type float>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background_color"), this->background_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "foreground_color"), this->foreground_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type std::optional<::SkColor>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "color_picker_icon_color"), this->color_picker_icon_color,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "colors_managed_by_policy"), this->colors_managed_by_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_grey_baseline"), this->is_grey_baseline,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "browser_color_variant"), this->browser_color_variant,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::mojom::BrowserColorVariant>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "follow_device_theme"), this->follow_device_theme,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool Theme::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ChromeColor::ChromeColor()
    : name(),
      seed(),
      background(),
      foreground(),
      base(),
      variant() {}

ChromeColor::ChromeColor(
    const std::string& name_in,
    ::SkColor seed_in,
    ::SkColor background_in,
    ::SkColor foreground_in,
    ::SkColor base_in,
    ::ui::mojom::BrowserColorVariant variant_in)
    : name(std::move(name_in)),
      seed(std::move(seed_in)),
      background(std::move(background_in)),
      foreground(std::move(foreground_in)),
      base(std::move(base_in)),
      variant(std::move(variant_in)) {}

ChromeColor::~ChromeColor() = default;

void ChromeColor::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "name"), this->name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::string&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "seed"), this->seed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "background"), this->background,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "foreground"), this->foreground,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "base"), this->base,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::SkColor>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "variant"), this->variant,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::mojom::BrowserColorVariant>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ChromeColor::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.

ThemeColorPickerHandlerFactory::IPCStableHashFunction ThemeColorPickerHandlerFactory::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ThemeColorPickerHandlerFactory>(message.name())) {
    case messages::ThemeColorPickerHandlerFactory::kCreateThemeColorPickerHandler: {
      return &ThemeColorPickerHandlerFactory::CreateThemeColorPickerHandler_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ThemeColorPickerHandlerFactory::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ThemeColorPickerHandlerFactory>(message.name())) {
      case messages::ThemeColorPickerHandlerFactory::kCreateThemeColorPickerHandler:
            return "Receive theme_color_picker::mojom::ThemeColorPickerHandlerFactory::CreateThemeColorPickerHandler";
    }
  } else {
    switch (static_cast<messages::ThemeColorPickerHandlerFactory>(message.name())) {
      case messages::ThemeColorPickerHandlerFactory::kCreateThemeColorPickerHandler:
            return "Receive reply theme_color_picker::mojom::ThemeColorPickerHandlerFactory::CreateThemeColorPickerHandler";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ThemeColorPickerHandlerFactory::CreateThemeColorPickerHandler_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x0a000a8a;  // IPCStableHash for theme_color_picker::mojom::ThemeColorPickerHandlerFactory::CreateThemeColorPickerHandler
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ThemeColorPickerHandlerFactoryProxy::ThemeColorPickerHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ThemeColorPickerHandlerFactoryProxy::CreateThemeColorPickerHandler(
    ::mojo::PendingReceiver<ThemeColorPickerHandler> in_handler, ::mojo::PendingRemote<ThemeColorPickerClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send theme_color_picker::mojom::ThemeColorPickerHandlerFactory::CreateThemeColorPickerHandler", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("handler"), in_handler,
                        "<value of type ::mojo::PendingReceiver<ThemeColorPickerHandler>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingRemote<ThemeColorPickerClient>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ThemeColorPickerHandlerFactory::kCreateThemeColorPickerHandler), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::theme_color_picker::mojom::internal::ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::theme_color_picker::mojom::ThemeColorPickerHandlerInterfaceBase>>(
    in_handler,
    &params->handler,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->handler)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid handler in ThemeColorPickerHandlerFactory.CreateThemeColorPickerHandler request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::theme_color_picker::mojom::ThemeColorPickerClientInterfaceBase>>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid client in ThemeColorPickerHandlerFactory.CreateThemeColorPickerHandler request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ThemeColorPickerHandlerFactory::Name_);
  message.set_method_name("CreateThemeColorPickerHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ThemeColorPickerHandlerFactoryStubDispatch::Accept(
    ThemeColorPickerHandlerFactory* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ThemeColorPickerHandlerFactory>(message->header()->name)) {
    case messages::ThemeColorPickerHandlerFactory::kCreateThemeColorPickerHandler: {
      DCHECK(message->is_serialized());
      internal::ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_Params_Data* params =
          reinterpret_cast<internal::ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ThemeColorPickerHandlerFactory.0
      bool success = true;
      ::mojo::PendingReceiver<ThemeColorPickerHandler> p_handler{};
      ::mojo::PendingRemote<ThemeColorPickerClient> p_client{};
      ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_handler =
            input_data_view.TakeHandler<decltype(p_handler)>();
      }
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ThemeColorPickerHandlerFactory::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateThemeColorPickerHandler(        
        std::move(p_handler), 
        std::move(p_client));
      return true;
    }
  }
  return false;
}

// static
bool ThemeColorPickerHandlerFactoryStubDispatch::AcceptWithResponder(
    ThemeColorPickerHandlerFactory* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ThemeColorPickerHandlerFactory>(message->header()->name)) {
    case messages::ThemeColorPickerHandlerFactory::kCreateThemeColorPickerHandler: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kThemeColorPickerHandlerFactoryValidationInfo[] = {
    { &internal::ThemeColorPickerHandlerFactory_CreateThemeColorPickerHandler_Params_Data::Validate,
     nullptr /* no response */},
};

bool ThemeColorPickerHandlerFactoryRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::theme_color_picker::mojom::ThemeColorPickerHandlerFactory::Name_,
    kThemeColorPickerHandlerFactoryValidationInfo);
}

// The declaration includes the definition on other builds.

ThemeColorPickerHandler::IPCStableHashFunction ThemeColorPickerHandler::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ThemeColorPickerHandler>(message.name())) {
    case messages::ThemeColorPickerHandler::kGetChromeColors: {
      return &ThemeColorPickerHandler::GetChromeColors_Sym::IPCStableHash;
    }
    case messages::ThemeColorPickerHandler::kUpdateTheme: {
      return &ThemeColorPickerHandler::UpdateTheme_Sym::IPCStableHash;
    }
    case messages::ThemeColorPickerHandler::kSetDefaultColor: {
      return &ThemeColorPickerHandler::SetDefaultColor_Sym::IPCStableHash;
    }
    case messages::ThemeColorPickerHandler::kSetGreyDefaultColor: {
      return &ThemeColorPickerHandler::SetGreyDefaultColor_Sym::IPCStableHash;
    }
    case messages::ThemeColorPickerHandler::kSetSeedColor: {
      return &ThemeColorPickerHandler::SetSeedColor_Sym::IPCStableHash;
    }
    case messages::ThemeColorPickerHandler::kSetSeedColorFromHue: {
      return &ThemeColorPickerHandler::SetSeedColorFromHue_Sym::IPCStableHash;
    }
    case messages::ThemeColorPickerHandler::kRemoveBackgroundImage: {
      return &ThemeColorPickerHandler::RemoveBackgroundImage_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ThemeColorPickerHandler::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ThemeColorPickerHandler>(message.name())) {
      case messages::ThemeColorPickerHandler::kGetChromeColors:
            return "Receive theme_color_picker::mojom::ThemeColorPickerHandler::GetChromeColors";
      case messages::ThemeColorPickerHandler::kUpdateTheme:
            return "Receive theme_color_picker::mojom::ThemeColorPickerHandler::UpdateTheme";
      case messages::ThemeColorPickerHandler::kSetDefaultColor:
            return "Receive theme_color_picker::mojom::ThemeColorPickerHandler::SetDefaultColor";
      case messages::ThemeColorPickerHandler::kSetGreyDefaultColor:
            return "Receive theme_color_picker::mojom::ThemeColorPickerHandler::SetGreyDefaultColor";
      case messages::ThemeColorPickerHandler::kSetSeedColor:
            return "Receive theme_color_picker::mojom::ThemeColorPickerHandler::SetSeedColor";
      case messages::ThemeColorPickerHandler::kSetSeedColorFromHue:
            return "Receive theme_color_picker::mojom::ThemeColorPickerHandler::SetSeedColorFromHue";
      case messages::ThemeColorPickerHandler::kRemoveBackgroundImage:
            return "Receive theme_color_picker::mojom::ThemeColorPickerHandler::RemoveBackgroundImage";
    }
  } else {
    switch (static_cast<messages::ThemeColorPickerHandler>(message.name())) {
      case messages::ThemeColorPickerHandler::kGetChromeColors:
            return "Receive reply theme_color_picker::mojom::ThemeColorPickerHandler::GetChromeColors";
      case messages::ThemeColorPickerHandler::kUpdateTheme:
            return "Receive reply theme_color_picker::mojom::ThemeColorPickerHandler::UpdateTheme";
      case messages::ThemeColorPickerHandler::kSetDefaultColor:
            return "Receive reply theme_color_picker::mojom::ThemeColorPickerHandler::SetDefaultColor";
      case messages::ThemeColorPickerHandler::kSetGreyDefaultColor:
            return "Receive reply theme_color_picker::mojom::ThemeColorPickerHandler::SetGreyDefaultColor";
      case messages::ThemeColorPickerHandler::kSetSeedColor:
            return "Receive reply theme_color_picker::mojom::ThemeColorPickerHandler::SetSeedColor";
      case messages::ThemeColorPickerHandler::kSetSeedColorFromHue:
            return "Receive reply theme_color_picker::mojom::ThemeColorPickerHandler::SetSeedColorFromHue";
      case messages::ThemeColorPickerHandler::kRemoveBackgroundImage:
            return "Receive reply theme_color_picker::mojom::ThemeColorPickerHandler::RemoveBackgroundImage";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ThemeColorPickerHandler::GetChromeColors_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbf83eaac;  // IPCStableHash for theme_color_picker::mojom::ThemeColorPickerHandler::GetChromeColors
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ThemeColorPickerHandler::UpdateTheme_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xc8785f02;  // IPCStableHash for theme_color_picker::mojom::ThemeColorPickerHandler::UpdateTheme
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ThemeColorPickerHandler::SetDefaultColor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2c5e80a8;  // IPCStableHash for theme_color_picker::mojom::ThemeColorPickerHandler::SetDefaultColor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ThemeColorPickerHandler::SetGreyDefaultColor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x818b9ed8;  // IPCStableHash for theme_color_picker::mojom::ThemeColorPickerHandler::SetGreyDefaultColor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ThemeColorPickerHandler::SetSeedColor_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xfa35f265;  // IPCStableHash for theme_color_picker::mojom::ThemeColorPickerHandler::SetSeedColor
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ThemeColorPickerHandler::SetSeedColorFromHue_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x6ad143aa;  // IPCStableHash for theme_color_picker::mojom::ThemeColorPickerHandler::SetSeedColorFromHue
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t ThemeColorPickerHandler::RemoveBackgroundImage_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x8da569ae;  // IPCStableHash for theme_color_picker::mojom::ThemeColorPickerHandler::RemoveBackgroundImage
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class ThemeColorPickerHandler_GetChromeColors_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  ThemeColorPickerHandler_GetChromeColors_ForwardToCallback(
      ThemeColorPickerHandler::GetChromeColorsCallback callback
      ) : callback_(std::move(callback)) {
  }

  ThemeColorPickerHandler_GetChromeColors_ForwardToCallback(const ThemeColorPickerHandler_GetChromeColors_ForwardToCallback&) = delete;
  ThemeColorPickerHandler_GetChromeColors_ForwardToCallback& operator=(const ThemeColorPickerHandler_GetChromeColors_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  ThemeColorPickerHandler::GetChromeColorsCallback callback_;
};

ThemeColorPickerHandlerProxy::ThemeColorPickerHandlerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ThemeColorPickerHandlerProxy::GetChromeColors(
    bool in_is_dark_mode, GetChromeColorsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send theme_color_picker::mojom::ThemeColorPickerHandler::GetChromeColors", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("is_dark_mode"), in_is_dark_mode,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ThemeColorPickerHandler::kGetChromeColors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::theme_color_picker::mojom::internal::ThemeColorPickerHandler_GetChromeColors_Params_Data> params(
          message);
  params.Allocate();

  params->is_dark_mode = in_is_dark_mode;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ThemeColorPickerHandler::Name_);
  message.set_method_name("GetChromeColors");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new ThemeColorPickerHandler_GetChromeColors_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void ThemeColorPickerHandlerProxy::UpdateTheme(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send theme_color_picker::mojom::ThemeColorPickerHandler::UpdateTheme");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ThemeColorPickerHandler::kUpdateTheme), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::theme_color_picker::mojom::internal::ThemeColorPickerHandler_UpdateTheme_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ThemeColorPickerHandler::Name_);
  message.set_method_name("UpdateTheme");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ThemeColorPickerHandlerProxy::SetDefaultColor(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send theme_color_picker::mojom::ThemeColorPickerHandler::SetDefaultColor");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ThemeColorPickerHandler::kSetDefaultColor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::theme_color_picker::mojom::internal::ThemeColorPickerHandler_SetDefaultColor_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ThemeColorPickerHandler::Name_);
  message.set_method_name("SetDefaultColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ThemeColorPickerHandlerProxy::SetGreyDefaultColor(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send theme_color_picker::mojom::ThemeColorPickerHandler::SetGreyDefaultColor");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ThemeColorPickerHandler::kSetGreyDefaultColor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::theme_color_picker::mojom::internal::ThemeColorPickerHandler_SetGreyDefaultColor_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ThemeColorPickerHandler::Name_);
  message.set_method_name("SetGreyDefaultColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ThemeColorPickerHandlerProxy::SetSeedColor(
    ::SkColor in_seed_color, ::ui::mojom::BrowserColorVariant in_variant) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send theme_color_picker::mojom::ThemeColorPickerHandler::SetSeedColor", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("seed_color"), in_seed_color,
                        "<value of type ::SkColor>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("variant"), in_variant,
                        "<value of type ::ui::mojom::BrowserColorVariant>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ThemeColorPickerHandler::kSetSeedColor), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::theme_color_picker::mojom::internal::ThemeColorPickerHandler_SetSeedColor_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->seed_color)::BaseType> seed_color_fragment(
          params.message());
  
  mojo::internal::Serialize<::skia::mojom::SkColorDataView>(
    in_seed_color,
    seed_color_fragment);

  params->seed_color.Set(
      seed_color_fragment.is_null() ? nullptr : seed_color_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->seed_color.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null seed_color in ThemeColorPickerHandler.SetSeedColor request");

  
  mojo::internal::Serialize<::ui::mojom::BrowserColorVariant>(
    in_variant,
    &params->variant);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ThemeColorPickerHandler::Name_);
  message.set_method_name("SetSeedColor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ThemeColorPickerHandlerProxy::SetSeedColorFromHue(
    float in_hue) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send theme_color_picker::mojom::ThemeColorPickerHandler::SetSeedColorFromHue", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("hue"), in_hue,
                        "<value of type float>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ThemeColorPickerHandler::kSetSeedColorFromHue), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::theme_color_picker::mojom::internal::ThemeColorPickerHandler_SetSeedColorFromHue_Params_Data> params(
          message);
  params.Allocate();

  params->hue = in_hue;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ThemeColorPickerHandler::Name_);
  message.set_method_name("SetSeedColorFromHue");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void ThemeColorPickerHandlerProxy::RemoveBackgroundImage(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send theme_color_picker::mojom::ThemeColorPickerHandler::RemoveBackgroundImage");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ThemeColorPickerHandler::kRemoveBackgroundImage), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::theme_color_picker::mojom::internal::ThemeColorPickerHandler_RemoveBackgroundImage_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ThemeColorPickerHandler::Name_);
  message.set_method_name("RemoveBackgroundImage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class ThemeColorPickerHandler_GetChromeColors_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static ThemeColorPickerHandler::GetChromeColorsCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<ThemeColorPickerHandler_GetChromeColors_ProxyToResponder> proxy(
        new ThemeColorPickerHandler_GetChromeColors_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&ThemeColorPickerHandler_GetChromeColors_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~ThemeColorPickerHandler_GetChromeColors_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  ThemeColorPickerHandler_GetChromeColors_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "ThemeColorPickerHandler::GetChromeColorsCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      std::vector<ChromeColorPtr> in_colors);
};

bool ThemeColorPickerHandler_GetChromeColors_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::ThemeColorPickerHandler_GetChromeColors_ResponseParams_Data* params =
      reinterpret_cast<
          internal::ThemeColorPickerHandler_GetChromeColors_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for ThemeColorPickerHandler.0
  bool success = true;
  std::vector<ChromeColorPtr> p_colors{};
  ThemeColorPickerHandler_GetChromeColors_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadColors(&p_colors))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        ThemeColorPickerHandler::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_colors));
  }
  return true;
}

void ThemeColorPickerHandler_GetChromeColors_ProxyToResponder::Run(
    std::vector<ChromeColorPtr> in_colors) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply theme_color_picker::mojom::ThemeColorPickerHandler::GetChromeColors", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("colors"), in_colors,
                        "<value of type std::vector<ChromeColorPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ThemeColorPickerHandler::kGetChromeColors), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::theme_color_picker::mojom::internal::ThemeColorPickerHandler_GetChromeColors_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->colors)::BaseType>
      colors_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& colors_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::theme_color_picker::mojom::ChromeColorDataView>>(
    in_colors,
    colors_fragment,
    &colors_validate_params);

  params->colors.Set(
      colors_fragment.is_null() ? nullptr : colors_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->colors.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null colors in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ThemeColorPickerHandler::Name_);
  message.set_method_name("GetChromeColors");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool ThemeColorPickerHandlerStubDispatch::Accept(
    ThemeColorPickerHandler* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ThemeColorPickerHandler>(message->header()->name)) {
    case messages::ThemeColorPickerHandler::kGetChromeColors: {
      break;
    }
    case messages::ThemeColorPickerHandler::kUpdateTheme: {
      DCHECK(message->is_serialized());
      internal::ThemeColorPickerHandler_UpdateTheme_Params_Data* params =
          reinterpret_cast<internal::ThemeColorPickerHandler_UpdateTheme_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ThemeColorPickerHandler.1
      bool success = true;
      ThemeColorPickerHandler_UpdateTheme_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ThemeColorPickerHandler::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateTheme(        );
      return true;
    }
    case messages::ThemeColorPickerHandler::kSetDefaultColor: {
      DCHECK(message->is_serialized());
      internal::ThemeColorPickerHandler_SetDefaultColor_Params_Data* params =
          reinterpret_cast<internal::ThemeColorPickerHandler_SetDefaultColor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ThemeColorPickerHandler.2
      bool success = true;
      ThemeColorPickerHandler_SetDefaultColor_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ThemeColorPickerHandler::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetDefaultColor(        );
      return true;
    }
    case messages::ThemeColorPickerHandler::kSetGreyDefaultColor: {
      DCHECK(message->is_serialized());
      internal::ThemeColorPickerHandler_SetGreyDefaultColor_Params_Data* params =
          reinterpret_cast<internal::ThemeColorPickerHandler_SetGreyDefaultColor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ThemeColorPickerHandler.3
      bool success = true;
      ThemeColorPickerHandler_SetGreyDefaultColor_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ThemeColorPickerHandler::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetGreyDefaultColor(        );
      return true;
    }
    case messages::ThemeColorPickerHandler::kSetSeedColor: {
      DCHECK(message->is_serialized());
      internal::ThemeColorPickerHandler_SetSeedColor_Params_Data* params =
          reinterpret_cast<internal::ThemeColorPickerHandler_SetSeedColor_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ThemeColorPickerHandler.4
      bool success = true;
      ::SkColor p_seed_color{};
      ::ui::mojom::BrowserColorVariant p_variant{};
      ThemeColorPickerHandler_SetSeedColor_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadSeedColor(&p_seed_color))
        success = false;
      if (success && !input_data_view.ReadVariant(&p_variant))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ThemeColorPickerHandler::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSeedColor(        
        std::move(p_seed_color), 
        std::move(p_variant));
      return true;
    }
    case messages::ThemeColorPickerHandler::kSetSeedColorFromHue: {
      DCHECK(message->is_serialized());
      internal::ThemeColorPickerHandler_SetSeedColorFromHue_Params_Data* params =
          reinterpret_cast<internal::ThemeColorPickerHandler_SetSeedColorFromHue_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ThemeColorPickerHandler.5
      bool success = true;
      float p_hue{};
      ThemeColorPickerHandler_SetSeedColorFromHue_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_hue = input_data_view.hue();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ThemeColorPickerHandler::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSeedColorFromHue(        
        std::move(p_hue));
      return true;
    }
    case messages::ThemeColorPickerHandler::kRemoveBackgroundImage: {
      DCHECK(message->is_serialized());
      internal::ThemeColorPickerHandler_RemoveBackgroundImage_Params_Data* params =
          reinterpret_cast<internal::ThemeColorPickerHandler_RemoveBackgroundImage_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ThemeColorPickerHandler.6
      bool success = true;
      ThemeColorPickerHandler_RemoveBackgroundImage_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ThemeColorPickerHandler::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->RemoveBackgroundImage(        );
      return true;
    }
  }
  return false;
}

// static
bool ThemeColorPickerHandlerStubDispatch::AcceptWithResponder(
    ThemeColorPickerHandler* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ThemeColorPickerHandler>(message->header()->name)) {
    case messages::ThemeColorPickerHandler::kGetChromeColors: {
      internal::ThemeColorPickerHandler_GetChromeColors_Params_Data* params =
          reinterpret_cast<
              internal::ThemeColorPickerHandler_GetChromeColors_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for ThemeColorPickerHandler.0
      bool success = true;
      bool p_is_dark_mode{};
      ThemeColorPickerHandler_GetChromeColors_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_is_dark_mode = input_data_view.is_dark_mode();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ThemeColorPickerHandler::Name_, 0, false);
        return false;
      }
      auto callback =
          ThemeColorPickerHandler_GetChromeColors_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetChromeColors(        
        std::move(p_is_dark_mode), std::move(callback));
      return true;
    }
    case messages::ThemeColorPickerHandler::kUpdateTheme: {
      break;
    }
    case messages::ThemeColorPickerHandler::kSetDefaultColor: {
      break;
    }
    case messages::ThemeColorPickerHandler::kSetGreyDefaultColor: {
      break;
    }
    case messages::ThemeColorPickerHandler::kSetSeedColor: {
      break;
    }
    case messages::ThemeColorPickerHandler::kSetSeedColorFromHue: {
      break;
    }
    case messages::ThemeColorPickerHandler::kRemoveBackgroundImage: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kThemeColorPickerHandlerValidationInfo[] = {
    { &internal::ThemeColorPickerHandler_GetChromeColors_Params_Data::Validate,
     &internal::ThemeColorPickerHandler_GetChromeColors_ResponseParams_Data::Validate},
    { &internal::ThemeColorPickerHandler_UpdateTheme_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ThemeColorPickerHandler_SetDefaultColor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ThemeColorPickerHandler_SetGreyDefaultColor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ThemeColorPickerHandler_SetSeedColor_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ThemeColorPickerHandler_SetSeedColorFromHue_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::ThemeColorPickerHandler_RemoveBackgroundImage_Params_Data::Validate,
     nullptr /* no response */},
};

bool ThemeColorPickerHandlerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::theme_color_picker::mojom::ThemeColorPickerHandler::Name_,
    kThemeColorPickerHandlerValidationInfo);
}

bool ThemeColorPickerHandlerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::theme_color_picker::mojom::ThemeColorPickerHandler::Name_,
    kThemeColorPickerHandlerValidationInfo);
}
// The declaration includes the definition on other builds.

ThemeColorPickerClient::IPCStableHashFunction ThemeColorPickerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::ThemeColorPickerClient>(message.name())) {
    case messages::ThemeColorPickerClient::kSetTheme: {
      return &ThemeColorPickerClient::SetTheme_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* ThemeColorPickerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::ThemeColorPickerClient>(message.name())) {
      case messages::ThemeColorPickerClient::kSetTheme:
            return "Receive theme_color_picker::mojom::ThemeColorPickerClient::SetTheme";
    }
  } else {
    switch (static_cast<messages::ThemeColorPickerClient>(message.name())) {
      case messages::ThemeColorPickerClient::kSetTheme:
            return "Receive reply theme_color_picker::mojom::ThemeColorPickerClient::SetTheme";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t ThemeColorPickerClient::SetTheme_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd63aae77;  // IPCStableHash for theme_color_picker::mojom::ThemeColorPickerClient::SetTheme
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

ThemeColorPickerClientProxy::ThemeColorPickerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ThemeColorPickerClientProxy::SetTheme(
    ThemePtr in_theme) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send theme_color_picker::mojom::ThemeColorPickerClient::SetTheme", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("theme"), in_theme,
                        "<value of type ThemePtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::ThemeColorPickerClient::kSetTheme), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::theme_color_picker::mojom::internal::ThemeColorPickerClient_SetTheme_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->theme)::BaseType> theme_fragment(
          params.message());
  
  mojo::internal::Serialize<::theme_color_picker::mojom::ThemeDataView>(
    in_theme,
    theme_fragment);

  params->theme.Set(
      theme_fragment.is_null() ? nullptr : theme_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->theme.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null theme in ThemeColorPickerClient.SetTheme request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ThemeColorPickerClient::Name_);
  message.set_method_name("SetTheme");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool ThemeColorPickerClientStubDispatch::Accept(
    ThemeColorPickerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::ThemeColorPickerClient>(message->header()->name)) {
    case messages::ThemeColorPickerClient::kSetTheme: {
      DCHECK(message->is_serialized());
      internal::ThemeColorPickerClient_SetTheme_Params_Data* params =
          reinterpret_cast<internal::ThemeColorPickerClient_SetTheme_Params_Data*>(
              message->mutable_payload());
      

      // Validation for ThemeColorPickerClient.0
      bool success = true;
      ThemePtr p_theme{};
      ThemeColorPickerClient_SetTheme_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadTheme(&p_theme))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ThemeColorPickerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTheme(        
        std::move(p_theme));
      return true;
    }
  }
  return false;
}

// static
bool ThemeColorPickerClientStubDispatch::AcceptWithResponder(
    ThemeColorPickerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::ThemeColorPickerClient>(message->header()->name)) {
    case messages::ThemeColorPickerClient::kSetTheme: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kThemeColorPickerClientValidationInfo[] = {
    { &internal::ThemeColorPickerClient_SetTheme_Params_Data::Validate,
     nullptr /* no response */},
};

bool ThemeColorPickerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::theme_color_picker::mojom::ThemeColorPickerClient::Name_,
    kThemeColorPickerClientValidationInfo);
}



}  // theme_color_picker::mojom


namespace mojo {


// static
bool StructTraits<::theme_color_picker::mojom::Theme::DataView, ::theme_color_picker::mojom::ThemePtr>::Read(
    ::theme_color_picker::mojom::Theme::DataView input,
    ::theme_color_picker::mojom::ThemePtr* output) {
  bool success = true;
  ::theme_color_picker::mojom::ThemePtr result(::theme_color_picker::mojom::Theme::New());
  
      if (success)
        result->has_background_image = input.has_background_image();
      if (success)
        result->has_third_party_theme = input.has_third_party_theme();
      if (success && !input.ReadBackgroundImageMainColor(&result->background_image_main_color))
        success = false;
      if (success)
        result->is_dark_mode = input.is_dark_mode();
      if (success && !input.ReadSeedColor(&result->seed_color))
        success = false;
      if (success)
        result->seed_color_hue = input.seed_color_hue();
      if (success && !input.ReadBackgroundColor(&result->background_color))
        success = false;
      if (success && !input.ReadForegroundColor(&result->foreground_color))
        success = false;
      if (success && !input.ReadColorPickerIconColor(&result->color_picker_icon_color))
        success = false;
      if (success)
        result->colors_managed_by_policy = input.colors_managed_by_policy();
      if (success)
        result->is_grey_baseline = input.is_grey_baseline();
      if (success && !input.ReadBrowserColorVariant(&result->browser_color_variant))
        success = false;
      if (success)
        result->follow_device_theme = input.follow_device_theme();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::theme_color_picker::mojom::ChromeColor::DataView, ::theme_color_picker::mojom::ChromeColorPtr>::Read(
    ::theme_color_picker::mojom::ChromeColor::DataView input,
    ::theme_color_picker::mojom::ChromeColorPtr* output) {
  bool success = true;
  ::theme_color_picker::mojom::ChromeColorPtr result(::theme_color_picker::mojom::ChromeColor::New());
  
      if (success && !input.ReadName(&result->name))
        success = false;
      if (success && !input.ReadSeed(&result->seed))
        success = false;
      if (success && !input.ReadBackground(&result->background))
        success = false;
      if (success && !input.ReadForeground(&result->foreground))
        success = false;
      if (success && !input.ReadBase(&result->base))
        success = false;
      if (success && !input.ReadVariant(&result->variant))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace theme_color_picker::mojom {


void ThemeColorPickerHandlerFactoryInterceptorForTesting::CreateThemeColorPickerHandler(::mojo::PendingReceiver<ThemeColorPickerHandler> handler, ::mojo::PendingRemote<ThemeColorPickerClient> client) {
  GetForwardingInterface()->CreateThemeColorPickerHandler(
    std::move(handler)
    , 
    std::move(client)
    );
}
ThemeColorPickerHandlerFactoryAsyncWaiter::ThemeColorPickerHandlerFactoryAsyncWaiter(
    ThemeColorPickerHandlerFactory* proxy) : proxy_(proxy) {}

ThemeColorPickerHandlerFactoryAsyncWaiter::~ThemeColorPickerHandlerFactoryAsyncWaiter() = default;





void ThemeColorPickerHandlerInterceptorForTesting::GetChromeColors(bool is_dark_mode, GetChromeColorsCallback callback) {
  GetForwardingInterface()->GetChromeColors(
    std::move(is_dark_mode)
    , std::move(callback));
}
void ThemeColorPickerHandlerInterceptorForTesting::UpdateTheme() {
  GetForwardingInterface()->UpdateTheme();
}
void ThemeColorPickerHandlerInterceptorForTesting::SetDefaultColor() {
  GetForwardingInterface()->SetDefaultColor();
}
void ThemeColorPickerHandlerInterceptorForTesting::SetGreyDefaultColor() {
  GetForwardingInterface()->SetGreyDefaultColor();
}
void ThemeColorPickerHandlerInterceptorForTesting::SetSeedColor(::SkColor seed_color, ::ui::mojom::BrowserColorVariant variant) {
  GetForwardingInterface()->SetSeedColor(
    std::move(seed_color)
    , 
    std::move(variant)
    );
}
void ThemeColorPickerHandlerInterceptorForTesting::SetSeedColorFromHue(float hue) {
  GetForwardingInterface()->SetSeedColorFromHue(
    std::move(hue)
    );
}
void ThemeColorPickerHandlerInterceptorForTesting::RemoveBackgroundImage() {
  GetForwardingInterface()->RemoveBackgroundImage();
}
ThemeColorPickerHandlerAsyncWaiter::ThemeColorPickerHandlerAsyncWaiter(
    ThemeColorPickerHandler* proxy) : proxy_(proxy) {}

ThemeColorPickerHandlerAsyncWaiter::~ThemeColorPickerHandlerAsyncWaiter() = default;


void ThemeColorPickerHandlerAsyncWaiter::GetChromeColors(
    bool is_dark_mode, std::vector<ChromeColorPtr>* out_colors) {
  base::RunLoop loop;
  proxy_->GetChromeColors(
      std::move(is_dark_mode),
      base::BindOnce(
          [](base::RunLoop* loop,
             std::vector<ChromeColorPtr>* out_colors
,
             std::vector<ChromeColorPtr> colors) {*out_colors = std::move(colors);
            loop->Quit();
          },
          &loop,
          out_colors));
  loop.Run();
}

std::vector<ChromeColorPtr> ThemeColorPickerHandlerAsyncWaiter::GetChromeColors(
    bool is_dark_mode) {
  std::vector<ChromeColorPtr> async_wait_result;
  GetChromeColors(std::move(is_dark_mode),&async_wait_result);
  return async_wait_result;
}




void ThemeColorPickerClientInterceptorForTesting::SetTheme(ThemePtr theme) {
  GetForwardingInterface()->SetTheme(
    std::move(theme)
    );
}
ThemeColorPickerClientAsyncWaiter::ThemeColorPickerClientAsyncWaiter(
    ThemeColorPickerClient* proxy) : proxy_(proxy) {}

ThemeColorPickerClientAsyncWaiter::~ThemeColorPickerClientAsyncWaiter() = default;







}  // theme_color_picker::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif