// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
import{CrLitElement}from"//resources/lit/v3_0/lit.rollup.js";import{getCss}from"./audio_wave.css.js";import{getHtml}from"./audio_wave.html.js";export const blurredRectUrl="//resources/images/eclipse_wave_blurred_rect.png";const BEZIER_TENSION_RATIO=.35;const MAX_AMPLITUDE=-25;const MIN_AMPLITUDE=0;const MAX_VERTICAL_SHIFT=-10;const MIN_VERTICAL_SHIFT=-0;const WAVE_SIDE_MARGIN_IDLE=56;const WAVE_SIDE_MARGIN_PEAK=0;const STROKE_WIDTH=3;const MS_PER_FRAME=16.67;const CIRCLE_RAD=Math.PI*2;function mapToRange(value,inputMin,inputMax,outputMin,outputMax,shouldClamp=false){if(shouldClamp){inputMax=Math.min(value,inputMax);inputMin=Math.max(value,inputMin)}return(value-inputMin)*((outputMax-outputMin)/(inputMax-inputMin))+outputMin}export class AudioWaveElement extends CrLitElement{static get styles(){return getCss()}render(){return getHtml.bind(this)()}static get properties(){return{isListening:{reflect:true,type:Boolean},isExpanding_:{reflect:true,type:Boolean}}}#isListening_accessor_storage=false;get isListening(){return this.#isListening_accessor_storage}set isListening(value){this.#isListening_accessor_storage=value}#isExpanding__accessor_storage=true;get isExpanding_(){return this.#isExpanding__accessor_storage}set isExpanding_(value){this.#isExpanding__accessor_storage=value}eclipseSvgWrapperEl;maskEl;thinPathEl;lowerGlowPathEl;clipPathEl;containerWidth=0;animationFrameId=null;decayingAmplitude=0;frame=0;lastUpdateTime=performance.now();firstUpdated(){this.eclipseSvgWrapperEl=this.$["eclipse-svg-wrapper"];this.maskEl=this.$["mask"];this.thinPathEl=this.$["thin-path"];this.lowerGlowPathEl=this.$["lower-glow-path"];this.clipPathEl=this.$["clip-path-shape"]}updated(changedProperties){super.updated(changedProperties);if(changedProperties.has("isListening")){this.isListening?this.onStartListen():this.onStopListen()}}disconnectedCallback(){super.disconnectedCallback();this.onStopListen()}onStartListen(){if(!this.eclipseSvgWrapperEl){return}this.containerWidth=this.eclipseSvgWrapperEl.offsetWidth;this.isExpanding_=true;if(this.animationFrameId===null){this.processFrame()}}onStopListen(){this.frame=0;this.decayingAmplitude=0;if(this.animationFrameId!==null){cancelAnimationFrame(this.animationFrameId);this.animationFrameId=null}this.isExpanding_=false}processFrame=()=>{if(!this.isListening){this.animationFrameId=null;return}const now=performance.now();const elapsed=now-this.lastUpdateTime;if(elapsed>MS_PER_FRAME){let ambientSimulatedMotion=.01+(1+Math.cos(this.frame/12*CIRCLE_RAD))*.05;ambientSimulatedMotion*=.95+Math.random()*.05;ambientSimulatedMotion*=.6+(1+Math.cos((this.frame+100)/160*CIRCLE_RAD))*.2;const startRamp=Math.min(1,this.frame/160);ambientSimulatedMotion*=startRamp;this.drawEclipseWavePath(ambientSimulatedMotion,startRamp);this.lastUpdateTime=now-elapsed%MS_PER_FRAME}if(this.isListening){this.animationFrameId=requestAnimationFrame(this.processFrame)}};drawEclipseWavePath(rawInputLevel,startRamp){if(!this.thinPathEl||!this.lowerGlowPathEl||!this.maskEl||!this.clipPathEl){return}this.frame++;this.decayingAmplitude=Math.max(this.decayingAmplitude,rawInputLevel);const idleBreathingOffset=(1+Math.cos((this.frame+50)%120/120*CIRCLE_RAD))/2*.4*startRamp;this.decayingAmplitude-=(this.decayingAmplitude-idleBreathingOffset)/1*.2;const effectiveAmplitude=Math.max(this.decayingAmplitude,idleBreathingOffset);const currentSidePadding=mapToRange(Math.pow(effectiveAmplitude,2.5),0,1,WAVE_SIDE_MARGIN_IDLE,WAVE_SIDE_MARGIN_PEAK);const anchorLeftX=currentSidePadding;const anchorRightX=this.containerWidth-currentSidePadding;const waveCenterX=(anchorLeftX+anchorRightX)/2;const waveHalfWidth=(anchorRightX-anchorLeftX)/2;const getParabolicDepth=xPosition=>{if(waveHalfWidth===0){return 0}const normalizedX=(xPosition-waveCenterX)/waveHalfWidth;const audioDisplacement=mapToRange(effectiveAmplitude,0,1,MIN_AMPLITUDE,MAX_AMPLITUDE);const baseOffset=mapToRange(effectiveAmplitude,0,1,MIN_VERTICAL_SHIFT,MAX_VERTICAL_SHIFT);return audioDisplacement*(1-Math.pow(normalizedX,2))+baseOffset};const controlPointXLeft=this.containerWidth*BEZIER_TENSION_RATIO;const controlPointXRight=this.containerWidth*(1-BEZIER_TENSION_RATIO);const controlPointY=getParabolicDepth(controlPointXLeft);const maskTranslateY=mapToRange(effectiveAmplitude,0,1,MIN_VERTICAL_SHIFT,MAX_VERTICAL_SHIFT);const buildBezierPath=(thickness,isSolidLine)=>{const topY=thickness*-.5+controlPointY;const bottomY=thickness*.5+(isSolidLine?controlPointY:-controlPointY);return`M ${anchorLeftX},${0}\n                  C ${controlPointXLeft},${topY} ${controlPointXRight},${topY} ${anchorRightX},${0}\n                  C ${controlPointXRight},${bottomY} ${controlPointXLeft},${bottomY} ${anchorLeftX},${0}\n                  Z`};this.thinPathEl.setAttribute("d",buildBezierPath(STROKE_WIDTH,true));this.lowerGlowPathEl.setAttribute("d",buildBezierPath(STROKE_WIDTH,false));this.maskEl.setAttribute("transform",`translate(0, ${maskTranslateY})`);const bottomClipY=1e3;const topControlY=STROKE_WIDTH*-.5+controlPointY;const clipPathString=`M ${0},${-maskTranslateY*.25}\n    L ${anchorLeftX},${0}\n    C ${controlPointXLeft},${topControlY} ${controlPointXRight},${topControlY} ${anchorRightX},${0}\n    L ${this.containerWidth},${-maskTranslateY*.25}\n    L ${this.containerWidth},${bottomClipY}\n    L ${0},${bottomClipY}\n    Z`;this.clipPathEl.setAttribute("d",clipPathString)}shouldUseSimulatedAudio(){return true}}customElements.define("audio-wave",AudioWaveElement);