// components/page_image_service/mojom/page_image_service.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const ClientIdSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ClientId {

  MIN_VALUE = 0,
  MAX_VALUE = 6,
  Journeys = 0,
  JourneysSidePanel = 1,
  NtpRealbox = 2,
  NtpQuests = 3,
  Bookmarks = 4,
  NtpTabResumption = 5,
  HistoryEmbeddings = 6,
}



export type PageImageServiceHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageImageServiceHandlerPendingReceiver>;

export class PageImageServiceHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageImageServiceHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageImageServiceHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageImageServiceHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'page_image_service.mojom.PageImageServiceHandler',
        scope);
  }
}

export interface PageImageServiceHandlerInterface {
  getPageImageUrl(clientId: ClientId, pageUrl: url_mojom_Url, options: Options): Promise<{
        result: (ImageResult | null), }>;
}

export class PageImageServiceHandlerRemote implements PageImageServiceHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageImageServiceHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageImageServiceHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageImageServiceHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageImageServiceHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  getPageImageUrl(
      clientId: ClientId,
      pageUrl: url_mojom_Url,
      options: Options): Promise<{
        result: (ImageResult | null), }> {
    return this.proxy.sendMessage(
        0,
        PageImageServiceHandler_GetPageImageUrl_ParamsSpec.$,
        PageImageServiceHandler_GetPageImageUrl_ResponseParamsSpec.$,
        [
          clientId,
          pageUrl,
          options
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageImageServiceHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageImageServiceHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageImageServiceHandlerRemote, PageImageServiceHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageImageServiceHandlerRemote, PageImageServiceHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageImageServiceHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageImageServiceHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageImageServiceHandler_GetPageImageUrl_ParamsSpec.$,
        PageImageServiceHandler_GetPageImageUrl_ResponseParamsSpec.$,
        impl.getPageImageUrl.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageImageServiceHandler {
  static get $interfaceName(): string {
    return "page_image_service.mojom.PageImageServiceHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageImageServiceHandlerRemote {
    let remote = new PageImageServiceHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageImageServiceHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageImageServiceHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageImageServiceHandlerRemote, PageImageServiceHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageImageServiceHandlerRemote, PageImageServiceHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  getPageImageUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageImageServiceHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.getPageImageUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageImageServiceHandler_GetPageImageUrl_ParamsSpec.$,
        PageImageServiceHandler_GetPageImageUrl_ResponseParamsSpec.$,
        this.getPageImageUrl.createReceiverHandler(true /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const OptionsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const ImageResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageImageServiceHandler_GetPageImageUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageImageServiceHandler_GetPageImageUrl_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface OptionsMojoType {
  suggestImages: boolean;
  optimizationGuideImages: boolean;
}


export type Options = OptionsMojoType;
mojo.internal.Struct<OptionsMojoType>(
    OptionsSpec.$,
    'Options',
    [
      mojo.internal.StructField<OptionsMojoType, boolean>(
        'suggestImages', 0,
        0,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<OptionsMojoType, boolean>(
        'optimizationGuideImages', 0,
        1,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface ImageResultMojoType {
  imageUrl: url_mojom_Url;
}


export type ImageResult = ImageResultMojoType;
mojo.internal.Struct<ImageResultMojoType>(
    ImageResultSpec.$,
    'ImageResult',
    [
      mojo.internal.StructField<ImageResultMojoType, url_mojom_Url>(
        'imageUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageImageServiceHandler_GetPageImageUrl_ParamsMojoType {
  clientId: ClientId;
  pageUrl: url_mojom_Url;
  options: Options;
}


export type PageImageServiceHandler_GetPageImageUrl_Params = PageImageServiceHandler_GetPageImageUrl_ParamsMojoType;
mojo.internal.Struct<PageImageServiceHandler_GetPageImageUrl_ParamsMojoType>(
    PageImageServiceHandler_GetPageImageUrl_ParamsSpec.$,
    'PageImageServiceHandler_GetPageImageUrl_Params',
    [
      mojo.internal.StructField<PageImageServiceHandler_GetPageImageUrl_ParamsMojoType, ClientId>(
        'clientId', 0,
        0,
        ClientIdSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageImageServiceHandler_GetPageImageUrl_ParamsMojoType, url_mojom_Url>(
        'pageUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageImageServiceHandler_GetPageImageUrl_ParamsMojoType, Options>(
        'options', 16,
        0,
        OptionsSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageImageServiceHandler_GetPageImageUrl_ResponseParamsMojoType {
  result: (ImageResult | null);
}


export type PageImageServiceHandler_GetPageImageUrl_ResponseParams = PageImageServiceHandler_GetPageImageUrl_ResponseParamsMojoType;
mojo.internal.Struct<PageImageServiceHandler_GetPageImageUrl_ResponseParamsMojoType>(
    PageImageServiceHandler_GetPageImageUrl_ResponseParamsSpec.$,
    'PageImageServiceHandler_GetPageImageUrl_ResponseParams',
    [
      mojo.internal.StructField<PageImageServiceHandler_GetPageImageUrl_ResponseParamsMojoType, ImageResult>(
        'result', 0,
        0,
        ImageResultSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



