// ui/webui/resources/cr_components/most_visited/most_visited.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_MOJOM_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/cr_components/most_visited/most_visited.mojom-features.h"  // IWYU pragma: export
#include "ui/webui/resources/cr_components/most_visited/most_visited.mojom-shared.h"  // IWYU pragma: export
#include "ui/webui/resources/cr_components/most_visited/most_visited.mojom-forward.h"  // IWYU pragma: export
#include "components/ntp_tiles/tile_source.mojom-forward.h"
#include "mojo/public/mojom/base/text_direction.mojom.h"
#include "skia/public/mojom/skcolor.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace most_visited::mojom {

class MostVisitedPageHandlerFactoryProxy;

template <typename ImplRefTraits>
class MostVisitedPageHandlerFactoryStub;

class MostVisitedPageHandlerFactoryRequestValidator;


class MostVisitedPageHandlerFactory
    : public MostVisitedPageHandlerFactoryInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "most_visited.mojom.MostVisitedPageHandlerFactory";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MostVisitedPageHandlerFactoryInterfaceBase;
  using Proxy_ = MostVisitedPageHandlerFactoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = MostVisitedPageHandlerFactoryStub<ImplRefTraits>;

  using RequestValidator_ = MostVisitedPageHandlerFactoryRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kCreatePageHandlerMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreatePageHandler_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MostVisitedPageHandlerFactory() = default;

  virtual void CreatePageHandler(::mojo::PendingRemote<MostVisitedPage> page, ::mojo::PendingReceiver<MostVisitedPageHandler> handler) = 0;
};

class MostVisitedPageHandlerProxy;

template <typename ImplRefTraits>
class MostVisitedPageHandlerStub;

class MostVisitedPageHandlerRequestValidator;
class MostVisitedPageHandlerResponseValidator;


class MostVisitedPageHandler
    : public MostVisitedPageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "most_visited.mojom.MostVisitedPageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MostVisitedPageHandlerInterfaceBase;
  using Proxy_ = MostVisitedPageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = MostVisitedPageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = MostVisitedPageHandlerRequestValidator;
  using ResponseValidator_ = MostVisitedPageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kAddMostVisitedTileMinVersion = 0,
    kDeleteMostVisitedTileMinVersion = 0,
    kReorderMostVisitedTileMinVersion = 0,
    kRestoreMostVisitedDefaultsMinVersion = 0,
    kUndoMostVisitedTileActionMinVersion = 0,
    kUpdateMostVisitedInfoMinVersion = 0,
    kUpdateMostVisitedTileMinVersion = 0,
    kPrerenderMostVisitedTileMinVersion = 0,
    kPrefetchMostVisitedTileMinVersion = 0,
    kPreconnectMostVisitedTileMinVersion = 0,
    kCancelPrerenderMinVersion = 0,
    kGetMostVisitedExpandedStateMinVersion = 0,
    kSetMostVisitedExpandedStateMinVersion = 0,
    kOnMostVisitedTilesRenderedMinVersion = 0,
    kOnMostVisitedTileNavigationMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct AddMostVisitedTile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct DeleteMostVisitedTile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ReorderMostVisitedTile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RestoreMostVisitedDefaults_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UndoMostVisitedTileAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateMostVisitedInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct UpdateMostVisitedTile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrerenderMostVisitedTile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PrefetchMostVisitedTile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct PreconnectMostVisitedTile_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct CancelPrerender_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct GetMostVisitedExpandedState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetMostVisitedExpandedState_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMostVisitedTilesRendered_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnMostVisitedTileNavigation_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MostVisitedPageHandler() = default;

  using AddMostVisitedTileCallback = base::OnceCallback<void(bool)>;
  using AddMostVisitedTileMojoCallback = base::OnceCallback<void(bool)>;

  virtual void AddMostVisitedTile(const ::GURL& url, const std::string& title, AddMostVisitedTileCallback callback) = 0;

  virtual void DeleteMostVisitedTile(MostVisitedTilePtr tile) = 0;

  virtual void ReorderMostVisitedTile(MostVisitedTilePtr tile, uint8_t new_pos) = 0;

  virtual void RestoreMostVisitedDefaults(::ntp_tiles::mojom::TileSource source) = 0;

  virtual void UndoMostVisitedTileAction(::ntp_tiles::mojom::TileSource source) = 0;

  virtual void UpdateMostVisitedInfo() = 0;

  using UpdateMostVisitedTileCallback = base::OnceCallback<void(bool)>;
  using UpdateMostVisitedTileMojoCallback = base::OnceCallback<void(bool)>;

  virtual void UpdateMostVisitedTile(MostVisitedTilePtr tile, const ::GURL& new_url, const std::string& new_title, UpdateMostVisitedTileCallback callback) = 0;

  virtual void PrerenderMostVisitedTile(MostVisitedTilePtr tile) = 0;

  virtual void PrefetchMostVisitedTile(MostVisitedTilePtr tile) = 0;

  virtual void PreconnectMostVisitedTile(MostVisitedTilePtr tile) = 0;

  virtual void CancelPrerender() = 0;

  using GetMostVisitedExpandedStateCallback = base::OnceCallback<void(bool)>;
  using GetMostVisitedExpandedStateMojoCallback = base::OnceCallback<void(bool)>;

  virtual void GetMostVisitedExpandedState(GetMostVisitedExpandedStateCallback callback) = 0;

  virtual void SetMostVisitedExpandedState(bool is_expanded) = 0;

  virtual void OnMostVisitedTilesRendered(std::vector<MostVisitedTilePtr> tiles, double time) = 0;

  virtual void OnMostVisitedTileNavigation(MostVisitedTilePtr tile, uint32_t index, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) = 0;
};

class MostVisitedPageProxy;

template <typename ImplRefTraits>
class MostVisitedPageStub;

class MostVisitedPageRequestValidator;


class MostVisitedPage
    : public MostVisitedPageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "most_visited.mojom.MostVisitedPage";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MostVisitedPageInterfaceBase;
  using Proxy_ = MostVisitedPageProxy;

  template <typename ImplRefTraits>
  using Stub_ = MostVisitedPageStub<ImplRefTraits>;

  using RequestValidator_ = MostVisitedPageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetMostVisitedInfoMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetMostVisitedInfo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MostVisitedPage() = default;

  virtual void SetMostVisitedInfo(MostVisitedInfoPtr info) = 0;
};



class  MostVisitedPageHandlerFactoryProxy
    : public MostVisitedPageHandlerFactory {
 public:
  using InterfaceType = MostVisitedPageHandlerFactory;

  explicit MostVisitedPageHandlerFactoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreatePageHandler(::mojo::PendingRemote<MostVisitedPage> page, ::mojo::PendingReceiver<MostVisitedPageHandler> handler) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MostVisitedPageHandlerProxy
    : public MostVisitedPageHandler {
 public:
  using InterfaceType = MostVisitedPageHandler;

  explicit MostVisitedPageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void AddMostVisitedTile(const ::GURL& url, const std::string& title, AddMostVisitedTileCallback callback) final;
  
  void DeleteMostVisitedTile(MostVisitedTilePtr tile) final;
  
  void ReorderMostVisitedTile(MostVisitedTilePtr tile, uint8_t new_pos) final;
  
  void RestoreMostVisitedDefaults(::ntp_tiles::mojom::TileSource source) final;
  
  void UndoMostVisitedTileAction(::ntp_tiles::mojom::TileSource source) final;
  
  void UpdateMostVisitedInfo() final;
  
  void UpdateMostVisitedTile(MostVisitedTilePtr tile, const ::GURL& new_url, const std::string& new_title, UpdateMostVisitedTileCallback callback) final;
  
  void PrerenderMostVisitedTile(MostVisitedTilePtr tile) final;
  
  void PrefetchMostVisitedTile(MostVisitedTilePtr tile) final;
  
  void PreconnectMostVisitedTile(MostVisitedTilePtr tile) final;
  
  void CancelPrerender() final;
  
  void GetMostVisitedExpandedState(GetMostVisitedExpandedStateCallback callback) final;
  
  void SetMostVisitedExpandedState(bool is_expanded) final;
  
  void OnMostVisitedTilesRendered(std::vector<MostVisitedTilePtr> tiles, double time) final;
  
  void OnMostVisitedTileNavigation(MostVisitedTilePtr tile, uint32_t index, uint8_t mouse_button, bool alt_key, bool ctrl_key, bool meta_key, bool shift_key) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  MostVisitedPageProxy
    : public MostVisitedPage {
 public:
  using InterfaceType = MostVisitedPage;

  explicit MostVisitedPageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetMostVisitedInfo(MostVisitedInfoPtr info) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MostVisitedPageHandlerFactoryStubDispatch {
 public:
  static bool Accept(MostVisitedPageHandlerFactory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MostVisitedPageHandlerFactory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MostVisitedPageHandlerFactory>>
class MostVisitedPageHandlerFactoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MostVisitedPageHandlerFactoryStub() = default;
  ~MostVisitedPageHandlerFactoryStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MostVisitedPageHandlerFactoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MostVisitedPageHandlerFactoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MostVisitedPageHandlerStubDispatch {
 public:
  static bool Accept(MostVisitedPageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MostVisitedPageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MostVisitedPageHandler>>
class MostVisitedPageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MostVisitedPageHandlerStub() = default;
  ~MostVisitedPageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MostVisitedPageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MostVisitedPageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MostVisitedPageStubDispatch {
 public:
  static bool Accept(MostVisitedPage* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MostVisitedPage* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MostVisitedPage>>
class MostVisitedPageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MostVisitedPageStub() = default;
  ~MostVisitedPageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MostVisitedPageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MostVisitedPageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MostVisitedPageHandlerFactoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MostVisitedPageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MostVisitedPageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MostVisitedPageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};










class  MostVisitedTile {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MostVisitedTile, T>::value>;
  using DataView = MostVisitedTileDataView;
  using Data_ = internal::MostVisitedTile_Data;

  template <typename... Args>
  static MostVisitedTilePtr New(Args&&... args) {
    return MostVisitedTilePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MostVisitedTilePtr From(const U& u) {
    return mojo::TypeConverter<MostVisitedTilePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MostVisitedTile>::Convert(*this);
  }


  MostVisitedTile();

  MostVisitedTile(
      const std::string& title,
      ::base::i18n::TextDirection title_direction,
      const ::GURL& url,
      bool is_query_tile,
      bool allow_user_edit,
      bool allow_user_delete,
      ::ntp_tiles::mojom::TileSource source,
      int32_t title_source);


  ~MostVisitedTile();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MostVisitedTilePtr>
  MostVisitedTilePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MostVisitedTile::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MostVisitedTile::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MostVisitedTile::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MostVisitedTile::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MostVisitedTile::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MostVisitedTile::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MostVisitedTile_UnserializedMessageContext<
            UserType, MostVisitedTile::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MostVisitedTile::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MostVisitedTile::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MostVisitedTile_UnserializedMessageContext<
            UserType, MostVisitedTile::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MostVisitedTile::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string title;
  
  ::base::i18n::TextDirection title_direction;
  
  ::GURL url;
  
  bool is_query_tile;
  
  bool allow_user_edit;
  
  bool allow_user_delete;
  
  ::ntp_tiles::mojom::TileSource source;
  
  int32_t title_source;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MostVisitedTile::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MostVisitedTile::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MostVisitedTile::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MostVisitedTile::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MostVisitedTheme {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MostVisitedTheme, T>::value>;
  using DataView = MostVisitedThemeDataView;
  using Data_ = internal::MostVisitedTheme_Data;

  template <typename... Args>
  static MostVisitedThemePtr New(Args&&... args) {
    return MostVisitedThemePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MostVisitedThemePtr From(const U& u) {
    return mojo::TypeConverter<MostVisitedThemePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MostVisitedTheme>::Convert(*this);
  }


  MostVisitedTheme();

  MostVisitedTheme(
      ::SkColor background_color,
      bool use_white_tile_icon,
      bool is_dark);


  ~MostVisitedTheme();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MostVisitedThemePtr>
  MostVisitedThemePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MostVisitedTheme::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MostVisitedTheme::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MostVisitedTheme::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MostVisitedTheme::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MostVisitedTheme::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MostVisitedTheme::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MostVisitedTheme_UnserializedMessageContext<
            UserType, MostVisitedTheme::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MostVisitedTheme::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MostVisitedTheme::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MostVisitedTheme_UnserializedMessageContext<
            UserType, MostVisitedTheme::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MostVisitedTheme::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::SkColor background_color;
  
  bool use_white_tile_icon;
  
  bool is_dark;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MostVisitedTheme::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MostVisitedTheme::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MostVisitedTheme::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MostVisitedTheme::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  MostVisitedInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<MostVisitedInfo, T>::value>;
  using DataView = MostVisitedInfoDataView;
  using Data_ = internal::MostVisitedInfo_Data;

  template <typename... Args>
  static MostVisitedInfoPtr New(Args&&... args) {
    return MostVisitedInfoPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static MostVisitedInfoPtr From(const U& u) {
    return mojo::TypeConverter<MostVisitedInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, MostVisitedInfo>::Convert(*this);
  }


  MostVisitedInfo();

  MostVisitedInfo(
      bool custom_links_enabled,
      bool enterprise_shortcuts_enabled,
      bool visible,
      std::vector<MostVisitedTilePtr> tiles);

MostVisitedInfo(const MostVisitedInfo&) = delete;
MostVisitedInfo& operator=(const MostVisitedInfo&) = delete;

  ~MostVisitedInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = MostVisitedInfoPtr>
  MostVisitedInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, MostVisitedInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, MostVisitedInfo::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, MostVisitedInfo::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MostVisitedInfo::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        MostVisitedInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        MostVisitedInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::MostVisitedInfo_UnserializedMessageContext<
            UserType, MostVisitedInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<MostVisitedInfo::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return MostVisitedInfo::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::MostVisitedInfo_UnserializedMessageContext<
            UserType, MostVisitedInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<MostVisitedInfo::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  bool custom_links_enabled;
  
  bool enterprise_shortcuts_enabled;
  
  bool visible;
  
  std::vector<MostVisitedTilePtr> tiles;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, MostVisitedInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, MostVisitedInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, MostVisitedInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, MostVisitedInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
MostVisitedTilePtr MostVisitedTile::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(title_direction),
      mojo::Clone(url),
      mojo::Clone(is_query_tile),
      mojo::Clone(allow_user_edit),
      mojo::Clone(allow_user_delete),
      mojo::Clone(source),
      mojo::Clone(title_source)
  );
}

template <typename T, MostVisitedTile::EnableIfSame<T>*>
bool MostVisitedTile::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->title_direction, other_struct.title_direction))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->is_query_tile, other_struct.is_query_tile))
    return false;
  if (!mojo::Equals(this->allow_user_edit, other_struct.allow_user_edit))
    return false;
  if (!mojo::Equals(this->allow_user_delete, other_struct.allow_user_delete))
    return false;
  if (!mojo::Equals(this->source, other_struct.source))
    return false;
  if (!mojo::Equals(this->title_source, other_struct.title_source))
    return false;
  return true;
}

template <typename T, MostVisitedTile::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.title_direction < rhs.title_direction)
    return true;
  if (rhs.title_direction < lhs.title_direction)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.is_query_tile < rhs.is_query_tile)
    return true;
  if (rhs.is_query_tile < lhs.is_query_tile)
    return false;
  if (lhs.allow_user_edit < rhs.allow_user_edit)
    return true;
  if (rhs.allow_user_edit < lhs.allow_user_edit)
    return false;
  if (lhs.allow_user_delete < rhs.allow_user_delete)
    return true;
  if (rhs.allow_user_delete < lhs.allow_user_delete)
    return false;
  if (lhs.source < rhs.source)
    return true;
  if (rhs.source < lhs.source)
    return false;
  if (lhs.title_source < rhs.title_source)
    return true;
  if (rhs.title_source < lhs.title_source)
    return false;
  return false;
}
template <typename StructPtrType>
MostVisitedThemePtr MostVisitedTheme::Clone() const {
  return New(
      mojo::Clone(background_color),
      mojo::Clone(use_white_tile_icon),
      mojo::Clone(is_dark)
  );
}

template <typename T, MostVisitedTheme::EnableIfSame<T>*>
bool MostVisitedTheme::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->background_color, other_struct.background_color))
    return false;
  if (!mojo::Equals(this->use_white_tile_icon, other_struct.use_white_tile_icon))
    return false;
  if (!mojo::Equals(this->is_dark, other_struct.is_dark))
    return false;
  return true;
}

template <typename T, MostVisitedTheme::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.background_color < rhs.background_color)
    return true;
  if (rhs.background_color < lhs.background_color)
    return false;
  if (lhs.use_white_tile_icon < rhs.use_white_tile_icon)
    return true;
  if (rhs.use_white_tile_icon < lhs.use_white_tile_icon)
    return false;
  if (lhs.is_dark < rhs.is_dark)
    return true;
  if (rhs.is_dark < lhs.is_dark)
    return false;
  return false;
}
template <typename StructPtrType>
MostVisitedInfoPtr MostVisitedInfo::Clone() const {
  return New(
      mojo::Clone(custom_links_enabled),
      mojo::Clone(enterprise_shortcuts_enabled),
      mojo::Clone(visible),
      mojo::Clone(tiles)
  );
}

template <typename T, MostVisitedInfo::EnableIfSame<T>*>
bool MostVisitedInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->custom_links_enabled, other_struct.custom_links_enabled))
    return false;
  if (!mojo::Equals(this->enterprise_shortcuts_enabled, other_struct.enterprise_shortcuts_enabled))
    return false;
  if (!mojo::Equals(this->visible, other_struct.visible))
    return false;
  if (!mojo::Equals(this->tiles, other_struct.tiles))
    return false;
  return true;
}

template <typename T, MostVisitedInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.custom_links_enabled < rhs.custom_links_enabled)
    return true;
  if (rhs.custom_links_enabled < lhs.custom_links_enabled)
    return false;
  if (lhs.enterprise_shortcuts_enabled < rhs.enterprise_shortcuts_enabled)
    return true;
  if (rhs.enterprise_shortcuts_enabled < lhs.enterprise_shortcuts_enabled)
    return false;
  if (lhs.visible < rhs.visible)
    return true;
  if (rhs.visible < lhs.visible)
    return false;
  if (lhs.tiles < rhs.tiles)
    return true;
  if (rhs.tiles < lhs.tiles)
    return false;
  return false;
}


}  // most_visited::mojom

namespace mojo {


template <>
struct  StructTraits<::most_visited::mojom::MostVisitedTile::DataView,
                                         ::most_visited::mojom::MostVisitedTilePtr> {
  static bool IsNull(const ::most_visited::mojom::MostVisitedTilePtr& input) { return !input; }
  static void SetToNull(::most_visited::mojom::MostVisitedTilePtr* output) { output->reset(); }

  static const decltype(::most_visited::mojom::MostVisitedTile::title)& title(
      const ::most_visited::mojom::MostVisitedTilePtr& input) {
    return input->title;
  }

  static decltype(::most_visited::mojom::MostVisitedTile::title_direction) title_direction(
      const ::most_visited::mojom::MostVisitedTilePtr& input) {
    return input->title_direction;
  }

  static const decltype(::most_visited::mojom::MostVisitedTile::url)& url(
      const ::most_visited::mojom::MostVisitedTilePtr& input) {
    return input->url;
  }

  static decltype(::most_visited::mojom::MostVisitedTile::is_query_tile) is_query_tile(
      const ::most_visited::mojom::MostVisitedTilePtr& input) {
    return input->is_query_tile;
  }

  static decltype(::most_visited::mojom::MostVisitedTile::allow_user_edit) allow_user_edit(
      const ::most_visited::mojom::MostVisitedTilePtr& input) {
    return input->allow_user_edit;
  }

  static decltype(::most_visited::mojom::MostVisitedTile::allow_user_delete) allow_user_delete(
      const ::most_visited::mojom::MostVisitedTilePtr& input) {
    return input->allow_user_delete;
  }

  static decltype(::most_visited::mojom::MostVisitedTile::source) source(
      const ::most_visited::mojom::MostVisitedTilePtr& input) {
    return input->source;
  }

  static decltype(::most_visited::mojom::MostVisitedTile::title_source) title_source(
      const ::most_visited::mojom::MostVisitedTilePtr& input) {
    return input->title_source;
  }

  static bool Read(::most_visited::mojom::MostVisitedTile::DataView input, ::most_visited::mojom::MostVisitedTilePtr* output);
};


template <>
struct  StructTraits<::most_visited::mojom::MostVisitedTheme::DataView,
                                         ::most_visited::mojom::MostVisitedThemePtr> {
  static bool IsNull(const ::most_visited::mojom::MostVisitedThemePtr& input) { return !input; }
  static void SetToNull(::most_visited::mojom::MostVisitedThemePtr* output) { output->reset(); }

  static const decltype(::most_visited::mojom::MostVisitedTheme::background_color)& background_color(
      const ::most_visited::mojom::MostVisitedThemePtr& input) {
    return input->background_color;
  }

  static decltype(::most_visited::mojom::MostVisitedTheme::use_white_tile_icon) use_white_tile_icon(
      const ::most_visited::mojom::MostVisitedThemePtr& input) {
    return input->use_white_tile_icon;
  }

  static decltype(::most_visited::mojom::MostVisitedTheme::is_dark) is_dark(
      const ::most_visited::mojom::MostVisitedThemePtr& input) {
    return input->is_dark;
  }

  static bool Read(::most_visited::mojom::MostVisitedTheme::DataView input, ::most_visited::mojom::MostVisitedThemePtr* output);
};


template <>
struct  StructTraits<::most_visited::mojom::MostVisitedInfo::DataView,
                                         ::most_visited::mojom::MostVisitedInfoPtr> {
  static bool IsNull(const ::most_visited::mojom::MostVisitedInfoPtr& input) { return !input; }
  static void SetToNull(::most_visited::mojom::MostVisitedInfoPtr* output) { output->reset(); }

  static decltype(::most_visited::mojom::MostVisitedInfo::custom_links_enabled) custom_links_enabled(
      const ::most_visited::mojom::MostVisitedInfoPtr& input) {
    return input->custom_links_enabled;
  }

  static decltype(::most_visited::mojom::MostVisitedInfo::enterprise_shortcuts_enabled) enterprise_shortcuts_enabled(
      const ::most_visited::mojom::MostVisitedInfoPtr& input) {
    return input->enterprise_shortcuts_enabled;
  }

  static decltype(::most_visited::mojom::MostVisitedInfo::visible) visible(
      const ::most_visited::mojom::MostVisitedInfoPtr& input) {
    return input->visible;
  }

  static const decltype(::most_visited::mojom::MostVisitedInfo::tiles)& tiles(
      const ::most_visited::mojom::MostVisitedInfoPtr& input) {
    return input->tiles;
  }

  static bool Read(::most_visited::mojom::MostVisitedInfo::DataView input, ::most_visited::mojom::MostVisitedInfoPtr* output);
};

}  // namespace mojo

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_MOJOM_H_