// ui/webui/resources/cr_components/most_visited/most_visited.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  TileSourceSpec as ntpTiles_mojom_TileSourceSpec,
  TileSource as ntpTiles_mojom_TileSource
} from '//resources/mojo/components/ntp_tiles/tile_source.mojom-webui.js';
import {
  TextDirectionSpec as mojoBase_mojom_TextDirectionSpec,
  TextDirection as mojoBase_mojom_TextDirection
} from '//resources/mojo/mojo/public/mojom/base/text_direction.mojom-webui.js';
import {
  SkColorSpec as skia_mojom_SkColorSpec,
  SkColor as skia_mojom_SkColor
} from '//resources/mojo/skia/public/mojom/skcolor.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';







export type MostVisitedPageHandlerFactoryPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<MostVisitedPageHandlerFactoryPendingReceiver>;

export class MostVisitedPageHandlerFactoryPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<MostVisitedPageHandlerFactory> {

  handle: mojo.internal.interfaceSupport.Endpoint<MostVisitedPageHandlerFactoryPendingReceiver>;
  constructor(handle: MojoHandle|MostVisitedPageHandlerFactoryPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'most_visited.mojom.MostVisitedPageHandlerFactory',
        scope);
  }
}

export interface MostVisitedPageHandlerFactoryInterface {
  createPageHandler(page: MostVisitedPageRemote, handler: MostVisitedPageHandlerPendingReceiver): void;
}

export class MostVisitedPageHandlerFactoryRemote implements MostVisitedPageHandlerFactoryInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<MostVisitedPageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<MostVisitedPageHandlerFactoryPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|MostVisitedPageHandlerFactoryPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MostVisitedPageHandlerFactoryPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createPageHandler(
      page: MostVisitedPageRemote,
      handler: MostVisitedPageHandlerPendingReceiver): void {
    this.proxy.sendMessage(
        0,
        MostVisitedPageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        [
          page,
          handler
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MostVisitedPageHandlerFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MostVisitedPageHandlerFactoryReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MostVisitedPageHandlerFactoryRemote, MostVisitedPageHandlerFactoryPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MostVisitedPageHandlerFactoryRemote, MostVisitedPageHandlerFactoryPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: MostVisitedPageHandlerFactoryInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MostVisitedPageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MostVisitedPageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        impl.createPageHandler.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MostVisitedPageHandlerFactory {
  static get $interfaceName(): string {
    return "most_visited.mojom.MostVisitedPageHandlerFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): MostVisitedPageHandlerFactoryRemote {
    let remote = new MostVisitedPageHandlerFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the MostVisitedPageHandlerFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MostVisitedPageHandlerFactoryCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MostVisitedPageHandlerFactoryRemote, MostVisitedPageHandlerFactoryPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MostVisitedPageHandlerFactoryRemote, MostVisitedPageHandlerFactoryPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createPageHandler: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MostVisitedPageHandlerFactoryRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createPageHandler =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MostVisitedPageHandlerFactory_CreatePageHandler_ParamsSpec.$,
        null,
        this.createPageHandler.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type MostVisitedPageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<MostVisitedPageHandlerPendingReceiver>;

export class MostVisitedPageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<MostVisitedPageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<MostVisitedPageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|MostVisitedPageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'most_visited.mojom.MostVisitedPageHandler',
        scope);
  }
}

export interface MostVisitedPageHandlerInterface {
  addMostVisitedTile(url: url_mojom_Url, title: string): Promise<{
        success: boolean, }>;
  deleteMostVisitedTile(tile: MostVisitedTile): void;
  reorderMostVisitedTile(tile: MostVisitedTile, newPos: number): void;
  restoreMostVisitedDefaults(source: ntpTiles_mojom_TileSource): void;
  undoMostVisitedTileAction(source: ntpTiles_mojom_TileSource): void;
  updateMostVisitedInfo(): void;
  updateMostVisitedTile(tile: MostVisitedTile, newUrl: url_mojom_Url, newTitle: string): Promise<{
        success: boolean, }>;
  prerenderMostVisitedTile(tile: MostVisitedTile): void;
  prefetchMostVisitedTile(tile: MostVisitedTile): void;
  preconnectMostVisitedTile(tile: MostVisitedTile): void;
  cancelPrerender(): void;
  getMostVisitedExpandedState(): Promise<{
        isExpanded: boolean, }>;
  setMostVisitedExpandedState(isExpanded: boolean): void;
  onMostVisitedTilesRendered(tiles: MostVisitedTile[], time: number): void;
  onMostVisitedTileNavigation(tile: MostVisitedTile, index: number, mouseButton: number, altKey: boolean, ctrlKey: boolean, metaKey: boolean, shiftKey: boolean): void;
}

export class MostVisitedPageHandlerRemote implements MostVisitedPageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<MostVisitedPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<MostVisitedPageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|MostVisitedPageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MostVisitedPageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  addMostVisitedTile(
      url: url_mojom_Url,
      title: string): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        0,
        MostVisitedPageHandler_AddMostVisitedTile_ParamsSpec.$,
        MostVisitedPageHandler_AddMostVisitedTile_ResponseParamsSpec.$,
        [
          url,
          title
        ],
        false);
  }

  deleteMostVisitedTile(
      tile: MostVisitedTile): void {
    this.proxy.sendMessage(
        1,
        MostVisitedPageHandler_DeleteMostVisitedTile_ParamsSpec.$,
        null,
        [
          tile
        ],
        false);
  }

  reorderMostVisitedTile(
      tile: MostVisitedTile,
      newPos: number): void {
    this.proxy.sendMessage(
        2,
        MostVisitedPageHandler_ReorderMostVisitedTile_ParamsSpec.$,
        null,
        [
          tile,
          newPos
        ],
        false);
  }

  restoreMostVisitedDefaults(
      source: ntpTiles_mojom_TileSource): void {
    this.proxy.sendMessage(
        3,
        MostVisitedPageHandler_RestoreMostVisitedDefaults_ParamsSpec.$,
        null,
        [
          source
        ],
        false);
  }

  undoMostVisitedTileAction(
      source: ntpTiles_mojom_TileSource): void {
    this.proxy.sendMessage(
        4,
        MostVisitedPageHandler_UndoMostVisitedTileAction_ParamsSpec.$,
        null,
        [
          source
        ],
        false);
  }

  updateMostVisitedInfo(): void {
    this.proxy.sendMessage(
        5,
        MostVisitedPageHandler_UpdateMostVisitedInfo_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  updateMostVisitedTile(
      tile: MostVisitedTile,
      newUrl: url_mojom_Url,
      newTitle: string): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        6,
        MostVisitedPageHandler_UpdateMostVisitedTile_ParamsSpec.$,
        MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParamsSpec.$,
        [
          tile,
          newUrl,
          newTitle
        ],
        false);
  }

  prerenderMostVisitedTile(
      tile: MostVisitedTile): void {
    this.proxy.sendMessage(
        7,
        MostVisitedPageHandler_PrerenderMostVisitedTile_ParamsSpec.$,
        null,
        [
          tile
        ],
        false);
  }

  prefetchMostVisitedTile(
      tile: MostVisitedTile): void {
    this.proxy.sendMessage(
        8,
        MostVisitedPageHandler_PrefetchMostVisitedTile_ParamsSpec.$,
        null,
        [
          tile
        ],
        false);
  }

  preconnectMostVisitedTile(
      tile: MostVisitedTile): void {
    this.proxy.sendMessage(
        9,
        MostVisitedPageHandler_PreconnectMostVisitedTile_ParamsSpec.$,
        null,
        [
          tile
        ],
        false);
  }

  cancelPrerender(): void {
    this.proxy.sendMessage(
        10,
        MostVisitedPageHandler_CancelPrerender_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  getMostVisitedExpandedState(): Promise<{
        isExpanded: boolean, }> {
    return this.proxy.sendMessage(
        11,
        MostVisitedPageHandler_GetMostVisitedExpandedState_ParamsSpec.$,
        MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  setMostVisitedExpandedState(
      isExpanded: boolean): void {
    this.proxy.sendMessage(
        12,
        MostVisitedPageHandler_SetMostVisitedExpandedState_ParamsSpec.$,
        null,
        [
          isExpanded
        ],
        false);
  }

  onMostVisitedTilesRendered(
      tiles: MostVisitedTile[],
      time: number): void {
    this.proxy.sendMessage(
        13,
        MostVisitedPageHandler_OnMostVisitedTilesRendered_ParamsSpec.$,
        null,
        [
          tiles,
          time
        ],
        false);
  }

  onMostVisitedTileNavigation(
      tile: MostVisitedTile,
      index: number,
      mouseButton: number,
      altKey: boolean,
      ctrlKey: boolean,
      metaKey: boolean,
      shiftKey: boolean): void {
    this.proxy.sendMessage(
        14,
        MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsSpec.$,
        null,
        [
          tile,
          index,
          mouseButton,
          altKey,
          ctrlKey,
          metaKey,
          shiftKey
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MostVisitedPageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MostVisitedPageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MostVisitedPageHandlerRemote, MostVisitedPageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MostVisitedPageHandlerRemote, MostVisitedPageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: MostVisitedPageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MostVisitedPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MostVisitedPageHandler_AddMostVisitedTile_ParamsSpec.$,
        MostVisitedPageHandler_AddMostVisitedTile_ResponseParamsSpec.$,
        impl.addMostVisitedTile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MostVisitedPageHandler_DeleteMostVisitedTile_ParamsSpec.$,
        null,
        impl.deleteMostVisitedTile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MostVisitedPageHandler_ReorderMostVisitedTile_ParamsSpec.$,
        null,
        impl.reorderMostVisitedTile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MostVisitedPageHandler_RestoreMostVisitedDefaults_ParamsSpec.$,
        null,
        impl.restoreMostVisitedDefaults.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MostVisitedPageHandler_UndoMostVisitedTileAction_ParamsSpec.$,
        null,
        impl.undoMostVisitedTileAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MostVisitedPageHandler_UpdateMostVisitedInfo_ParamsSpec.$,
        null,
        impl.updateMostVisitedInfo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        MostVisitedPageHandler_UpdateMostVisitedTile_ParamsSpec.$,
        MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParamsSpec.$,
        impl.updateMostVisitedTile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        MostVisitedPageHandler_PrerenderMostVisitedTile_ParamsSpec.$,
        null,
        impl.prerenderMostVisitedTile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        MostVisitedPageHandler_PrefetchMostVisitedTile_ParamsSpec.$,
        null,
        impl.prefetchMostVisitedTile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        MostVisitedPageHandler_PreconnectMostVisitedTile_ParamsSpec.$,
        null,
        impl.preconnectMostVisitedTile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        MostVisitedPageHandler_CancelPrerender_ParamsSpec.$,
        null,
        impl.cancelPrerender.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        MostVisitedPageHandler_GetMostVisitedExpandedState_ParamsSpec.$,
        MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParamsSpec.$,
        impl.getMostVisitedExpandedState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        MostVisitedPageHandler_SetMostVisitedExpandedState_ParamsSpec.$,
        null,
        impl.setMostVisitedExpandedState.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        MostVisitedPageHandler_OnMostVisitedTilesRendered_ParamsSpec.$,
        null,
        impl.onMostVisitedTilesRendered.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsSpec.$,
        null,
        impl.onMostVisitedTileNavigation.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MostVisitedPageHandler {
  static get $interfaceName(): string {
    return "most_visited.mojom.MostVisitedPageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): MostVisitedPageHandlerRemote {
    let remote = new MostVisitedPageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the MostVisitedPageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MostVisitedPageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MostVisitedPageHandlerRemote, MostVisitedPageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MostVisitedPageHandlerRemote, MostVisitedPageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  addMostVisitedTile: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  deleteMostVisitedTile: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  reorderMostVisitedTile: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  restoreMostVisitedDefaults: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  undoMostVisitedTileAction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateMostVisitedInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  updateMostVisitedTile: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  prerenderMostVisitedTile: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  prefetchMostVisitedTile: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  preconnectMostVisitedTile: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  cancelPrerender: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  getMostVisitedExpandedState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setMostVisitedExpandedState: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onMostVisitedTilesRendered: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onMostVisitedTileNavigation: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MostVisitedPageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.addMostVisitedTile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MostVisitedPageHandler_AddMostVisitedTile_ParamsSpec.$,
        MostVisitedPageHandler_AddMostVisitedTile_ResponseParamsSpec.$,
        this.addMostVisitedTile.createReceiverHandler(true /* expectsResponse */),
        false);
    this.deleteMostVisitedTile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MostVisitedPageHandler_DeleteMostVisitedTile_ParamsSpec.$,
        null,
        this.deleteMostVisitedTile.createReceiverHandler(false /* expectsResponse */),
        false);
    this.reorderMostVisitedTile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MostVisitedPageHandler_ReorderMostVisitedTile_ParamsSpec.$,
        null,
        this.reorderMostVisitedTile.createReceiverHandler(false /* expectsResponse */),
        false);
    this.restoreMostVisitedDefaults =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MostVisitedPageHandler_RestoreMostVisitedDefaults_ParamsSpec.$,
        null,
        this.restoreMostVisitedDefaults.createReceiverHandler(false /* expectsResponse */),
        false);
    this.undoMostVisitedTileAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MostVisitedPageHandler_UndoMostVisitedTileAction_ParamsSpec.$,
        null,
        this.undoMostVisitedTileAction.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateMostVisitedInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MostVisitedPageHandler_UpdateMostVisitedInfo_ParamsSpec.$,
        null,
        this.updateMostVisitedInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.updateMostVisitedTile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        MostVisitedPageHandler_UpdateMostVisitedTile_ParamsSpec.$,
        MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParamsSpec.$,
        this.updateMostVisitedTile.createReceiverHandler(true /* expectsResponse */),
        false);
    this.prerenderMostVisitedTile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        MostVisitedPageHandler_PrerenderMostVisitedTile_ParamsSpec.$,
        null,
        this.prerenderMostVisitedTile.createReceiverHandler(false /* expectsResponse */),
        false);
    this.prefetchMostVisitedTile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        MostVisitedPageHandler_PrefetchMostVisitedTile_ParamsSpec.$,
        null,
        this.prefetchMostVisitedTile.createReceiverHandler(false /* expectsResponse */),
        false);
    this.preconnectMostVisitedTile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        MostVisitedPageHandler_PreconnectMostVisitedTile_ParamsSpec.$,
        null,
        this.preconnectMostVisitedTile.createReceiverHandler(false /* expectsResponse */),
        false);
    this.cancelPrerender =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        MostVisitedPageHandler_CancelPrerender_ParamsSpec.$,
        null,
        this.cancelPrerender.createReceiverHandler(false /* expectsResponse */),
        false);
    this.getMostVisitedExpandedState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        MostVisitedPageHandler_GetMostVisitedExpandedState_ParamsSpec.$,
        MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParamsSpec.$,
        this.getMostVisitedExpandedState.createReceiverHandler(true /* expectsResponse */),
        false);
    this.setMostVisitedExpandedState =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        MostVisitedPageHandler_SetMostVisitedExpandedState_ParamsSpec.$,
        null,
        this.setMostVisitedExpandedState.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onMostVisitedTilesRendered =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        MostVisitedPageHandler_OnMostVisitedTilesRendered_ParamsSpec.$,
        null,
        this.onMostVisitedTilesRendered.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onMostVisitedTileNavigation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsSpec.$,
        null,
        this.onMostVisitedTileNavigation.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type MostVisitedPagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<MostVisitedPagePendingReceiver>;

export class MostVisitedPagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<MostVisitedPage> {

  handle: mojo.internal.interfaceSupport.Endpoint<MostVisitedPagePendingReceiver>;
  constructor(handle: MojoHandle|MostVisitedPagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'most_visited.mojom.MostVisitedPage',
        scope);
  }
}

export interface MostVisitedPageInterface {
  setMostVisitedInfo(info: MostVisitedInfo): void;
}

export class MostVisitedPageRemote implements MostVisitedPageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<MostVisitedPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<MostVisitedPagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|MostVisitedPagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MostVisitedPagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  setMostVisitedInfo(
      info: MostVisitedInfo): void {
    this.proxy.sendMessage(
        0,
        MostVisitedPage_SetMostVisitedInfo_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MostVisitedPage
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MostVisitedPageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MostVisitedPageRemote, MostVisitedPagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MostVisitedPageRemote, MostVisitedPagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: MostVisitedPageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MostVisitedPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MostVisitedPage_SetMostVisitedInfo_ParamsSpec.$,
        null,
        impl.setMostVisitedInfo.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MostVisitedPage {
  static get $interfaceName(): string {
    return "most_visited.mojom.MostVisitedPage";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): MostVisitedPageRemote {
    let remote = new MostVisitedPageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the MostVisitedPage
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MostVisitedPageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MostVisitedPageRemote, MostVisitedPagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MostVisitedPageRemote, MostVisitedPagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  setMostVisitedInfo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MostVisitedPageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.setMostVisitedInfo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MostVisitedPage_SetMostVisitedInfo_ParamsSpec.$,
        null,
        this.setMostVisitedInfo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const MostVisitedTileSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedThemeSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedInfoSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandlerFactory_CreatePageHandler_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_AddMostVisitedTile_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_AddMostVisitedTile_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_DeleteMostVisitedTile_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_ReorderMostVisitedTile_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_RestoreMostVisitedDefaults_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_UndoMostVisitedTileAction_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_UpdateMostVisitedInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_UpdateMostVisitedTile_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_PrerenderMostVisitedTile_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_PrefetchMostVisitedTile_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_PreconnectMostVisitedTile_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_CancelPrerender_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_GetMostVisitedExpandedState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_SetMostVisitedExpandedState_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_OnMostVisitedTilesRendered_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MostVisitedPage_SetMostVisitedInfo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface MostVisitedTileMojoType {
  title: string;
  titleDirection: mojoBase_mojom_TextDirection;
  isQueryTile: boolean;
  allowUserEdit: boolean;
  allowUserDelete: boolean;
  url: url_mojom_Url;
  source: ntpTiles_mojom_TileSource;
  titleSource: number;
}


export type MostVisitedTile = MostVisitedTileMojoType;
mojo.internal.Struct<MostVisitedTileMojoType>(
    MostVisitedTileSpec.$,
    'MostVisitedTile',
    [
      mojo.internal.StructField<MostVisitedTileMojoType, string>(
        'title', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedTileMojoType, mojoBase_mojom_TextDirection>(
        'titleDirection', 8,
        0,
        mojoBase_mojom_TextDirectionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedTileMojoType, url_mojom_Url>(
        'url', 16,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedTileMojoType, boolean>(
        'isQueryTile', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedTileMojoType, boolean>(
        'allowUserEdit', 12,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedTileMojoType, boolean>(
        'allowUserDelete', 12,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedTileMojoType, ntpTiles_mojom_TileSource>(
        'source', 24,
        0,
        ntpTiles_mojom_TileSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedTileMojoType, number>(
        'titleSource', 28,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 40],]);





export interface MostVisitedThemeMojoType {
  backgroundColor: skia_mojom_SkColor;
  useWhiteTileIcon: boolean;
  isDark: boolean;
}


export type MostVisitedTheme = MostVisitedThemeMojoType;
mojo.internal.Struct<MostVisitedThemeMojoType>(
    MostVisitedThemeSpec.$,
    'MostVisitedTheme',
    [
      mojo.internal.StructField<MostVisitedThemeMojoType, skia_mojom_SkColor>(
        'backgroundColor', 0,
        0,
        skia_mojom_SkColorSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedThemeMojoType, boolean>(
        'useWhiteTileIcon', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedThemeMojoType, boolean>(
        'isDark', 8,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface MostVisitedInfoMojoType {
  customLinksEnabled: boolean;
  enterpriseShortcutsEnabled: boolean;
  visible: boolean;
  tiles: MostVisitedTile[];
}


export type MostVisitedInfo = MostVisitedInfoMojoType;
mojo.internal.Struct<MostVisitedInfoMojoType>(
    MostVisitedInfoSpec.$,
    'MostVisitedInfo',
    [
      mojo.internal.StructField<MostVisitedInfoMojoType, boolean>(
        'customLinksEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedInfoMojoType, boolean>(
        'enterpriseShortcutsEnabled', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedInfoMojoType, boolean>(
        'visible', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedInfoMojoType, MostVisitedTile[]>(
        'tiles', 8,
        0,
        mojo.internal.Array(MostVisitedTileSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface MostVisitedPageHandlerFactory_CreatePageHandler_ParamsMojoType {
  page: MostVisitedPageRemote;
  handler: MostVisitedPageHandlerPendingReceiver;
}


export type MostVisitedPageHandlerFactory_CreatePageHandler_Params = MostVisitedPageHandlerFactory_CreatePageHandler_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandlerFactory_CreatePageHandler_ParamsMojoType>(
    MostVisitedPageHandlerFactory_CreatePageHandler_ParamsSpec.$,
    'MostVisitedPageHandlerFactory_CreatePageHandler_Params',
    [
      mojo.internal.StructField<MostVisitedPageHandlerFactory_CreatePageHandler_ParamsMojoType, MostVisitedPageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(MostVisitedPageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedPageHandlerFactory_CreatePageHandler_ParamsMojoType, MostVisitedPageHandlerPendingReceiver>(
        'handler', 8,
        0,
        mojo.internal.InterfaceRequest(MostVisitedPageHandlerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface MostVisitedPageHandler_AddMostVisitedTile_ParamsMojoType {
  url: url_mojom_Url;
  title: string;
}


export type MostVisitedPageHandler_AddMostVisitedTile_Params = MostVisitedPageHandler_AddMostVisitedTile_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_AddMostVisitedTile_ParamsMojoType>(
    MostVisitedPageHandler_AddMostVisitedTile_ParamsSpec.$,
    'MostVisitedPageHandler_AddMostVisitedTile_Params',
    [
      mojo.internal.StructField<MostVisitedPageHandler_AddMostVisitedTile_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedPageHandler_AddMostVisitedTile_ParamsMojoType, string>(
        'title', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface MostVisitedPageHandler_AddMostVisitedTile_ResponseParamsMojoType {
  success: boolean;
}


export type MostVisitedPageHandler_AddMostVisitedTile_ResponseParams = MostVisitedPageHandler_AddMostVisitedTile_ResponseParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_AddMostVisitedTile_ResponseParamsMojoType>(
    MostVisitedPageHandler_AddMostVisitedTile_ResponseParamsSpec.$,
    'MostVisitedPageHandler_AddMostVisitedTile_ResponseParams',
    [
      mojo.internal.StructField<MostVisitedPageHandler_AddMostVisitedTile_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MostVisitedPageHandler_DeleteMostVisitedTile_ParamsMojoType {
  tile: MostVisitedTile;
}


export type MostVisitedPageHandler_DeleteMostVisitedTile_Params = MostVisitedPageHandler_DeleteMostVisitedTile_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_DeleteMostVisitedTile_ParamsMojoType>(
    MostVisitedPageHandler_DeleteMostVisitedTile_ParamsSpec.$,
    'MostVisitedPageHandler_DeleteMostVisitedTile_Params',
    [
      mojo.internal.StructField<MostVisitedPageHandler_DeleteMostVisitedTile_ParamsMojoType, MostVisitedTile>(
        'tile', 0,
        0,
        MostVisitedTileSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MostVisitedPageHandler_ReorderMostVisitedTile_ParamsMojoType {
  tile: MostVisitedTile;
  newPos: number;
}


export type MostVisitedPageHandler_ReorderMostVisitedTile_Params = MostVisitedPageHandler_ReorderMostVisitedTile_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_ReorderMostVisitedTile_ParamsMojoType>(
    MostVisitedPageHandler_ReorderMostVisitedTile_ParamsSpec.$,
    'MostVisitedPageHandler_ReorderMostVisitedTile_Params',
    [
      mojo.internal.StructField<MostVisitedPageHandler_ReorderMostVisitedTile_ParamsMojoType, MostVisitedTile>(
        'tile', 0,
        0,
        MostVisitedTileSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedPageHandler_ReorderMostVisitedTile_ParamsMojoType, number>(
        'newPos', 8,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface MostVisitedPageHandler_RestoreMostVisitedDefaults_ParamsMojoType {
  source: ntpTiles_mojom_TileSource;
}


export type MostVisitedPageHandler_RestoreMostVisitedDefaults_Params = MostVisitedPageHandler_RestoreMostVisitedDefaults_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_RestoreMostVisitedDefaults_ParamsMojoType>(
    MostVisitedPageHandler_RestoreMostVisitedDefaults_ParamsSpec.$,
    'MostVisitedPageHandler_RestoreMostVisitedDefaults_Params',
    [
      mojo.internal.StructField<MostVisitedPageHandler_RestoreMostVisitedDefaults_ParamsMojoType, ntpTiles_mojom_TileSource>(
        'source', 0,
        0,
        ntpTiles_mojom_TileSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MostVisitedPageHandler_UndoMostVisitedTileAction_ParamsMojoType {
  source: ntpTiles_mojom_TileSource;
}


export type MostVisitedPageHandler_UndoMostVisitedTileAction_Params = MostVisitedPageHandler_UndoMostVisitedTileAction_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_UndoMostVisitedTileAction_ParamsMojoType>(
    MostVisitedPageHandler_UndoMostVisitedTileAction_ParamsSpec.$,
    'MostVisitedPageHandler_UndoMostVisitedTileAction_Params',
    [
      mojo.internal.StructField<MostVisitedPageHandler_UndoMostVisitedTileAction_ParamsMojoType, ntpTiles_mojom_TileSource>(
        'source', 0,
        0,
        ntpTiles_mojom_TileSourceSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MostVisitedPageHandler_UpdateMostVisitedInfo_ParamsMojoType {
}


export type MostVisitedPageHandler_UpdateMostVisitedInfo_Params = MostVisitedPageHandler_UpdateMostVisitedInfo_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_UpdateMostVisitedInfo_ParamsMojoType>(
    MostVisitedPageHandler_UpdateMostVisitedInfo_ParamsSpec.$,
    'MostVisitedPageHandler_UpdateMostVisitedInfo_Params',
    [
    ],
    [[0, 8],]);





export interface MostVisitedPageHandler_UpdateMostVisitedTile_ParamsMojoType {
  tile: MostVisitedTile;
  newUrl: url_mojom_Url;
  newTitle: string;
}


export type MostVisitedPageHandler_UpdateMostVisitedTile_Params = MostVisitedPageHandler_UpdateMostVisitedTile_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_UpdateMostVisitedTile_ParamsMojoType>(
    MostVisitedPageHandler_UpdateMostVisitedTile_ParamsSpec.$,
    'MostVisitedPageHandler_UpdateMostVisitedTile_Params',
    [
      mojo.internal.StructField<MostVisitedPageHandler_UpdateMostVisitedTile_ParamsMojoType, MostVisitedTile>(
        'tile', 0,
        0,
        MostVisitedTileSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedPageHandler_UpdateMostVisitedTile_ParamsMojoType, url_mojom_Url>(
        'newUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedPageHandler_UpdateMostVisitedTile_ParamsMojoType, string>(
        'newTitle', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParamsMojoType {
  success: boolean;
}


export type MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParams = MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParamsMojoType>(
    MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParamsSpec.$,
    'MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParams',
    [
      mojo.internal.StructField<MostVisitedPageHandler_UpdateMostVisitedTile_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MostVisitedPageHandler_PrerenderMostVisitedTile_ParamsMojoType {
  tile: MostVisitedTile;
}


export type MostVisitedPageHandler_PrerenderMostVisitedTile_Params = MostVisitedPageHandler_PrerenderMostVisitedTile_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_PrerenderMostVisitedTile_ParamsMojoType>(
    MostVisitedPageHandler_PrerenderMostVisitedTile_ParamsSpec.$,
    'MostVisitedPageHandler_PrerenderMostVisitedTile_Params',
    [
      mojo.internal.StructField<MostVisitedPageHandler_PrerenderMostVisitedTile_ParamsMojoType, MostVisitedTile>(
        'tile', 0,
        0,
        MostVisitedTileSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MostVisitedPageHandler_PrefetchMostVisitedTile_ParamsMojoType {
  tile: MostVisitedTile;
}


export type MostVisitedPageHandler_PrefetchMostVisitedTile_Params = MostVisitedPageHandler_PrefetchMostVisitedTile_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_PrefetchMostVisitedTile_ParamsMojoType>(
    MostVisitedPageHandler_PrefetchMostVisitedTile_ParamsSpec.$,
    'MostVisitedPageHandler_PrefetchMostVisitedTile_Params',
    [
      mojo.internal.StructField<MostVisitedPageHandler_PrefetchMostVisitedTile_ParamsMojoType, MostVisitedTile>(
        'tile', 0,
        0,
        MostVisitedTileSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MostVisitedPageHandler_PreconnectMostVisitedTile_ParamsMojoType {
  tile: MostVisitedTile;
}


export type MostVisitedPageHandler_PreconnectMostVisitedTile_Params = MostVisitedPageHandler_PreconnectMostVisitedTile_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_PreconnectMostVisitedTile_ParamsMojoType>(
    MostVisitedPageHandler_PreconnectMostVisitedTile_ParamsSpec.$,
    'MostVisitedPageHandler_PreconnectMostVisitedTile_Params',
    [
      mojo.internal.StructField<MostVisitedPageHandler_PreconnectMostVisitedTile_ParamsMojoType, MostVisitedTile>(
        'tile', 0,
        0,
        MostVisitedTileSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MostVisitedPageHandler_CancelPrerender_ParamsMojoType {
}


export type MostVisitedPageHandler_CancelPrerender_Params = MostVisitedPageHandler_CancelPrerender_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_CancelPrerender_ParamsMojoType>(
    MostVisitedPageHandler_CancelPrerender_ParamsSpec.$,
    'MostVisitedPageHandler_CancelPrerender_Params',
    [
    ],
    [[0, 8],]);





export interface MostVisitedPageHandler_GetMostVisitedExpandedState_ParamsMojoType {
}


export type MostVisitedPageHandler_GetMostVisitedExpandedState_Params = MostVisitedPageHandler_GetMostVisitedExpandedState_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_GetMostVisitedExpandedState_ParamsMojoType>(
    MostVisitedPageHandler_GetMostVisitedExpandedState_ParamsSpec.$,
    'MostVisitedPageHandler_GetMostVisitedExpandedState_Params',
    [
    ],
    [[0, 8],]);





export interface MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParamsMojoType {
  isExpanded: boolean;
}


export type MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParams = MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParamsMojoType>(
    MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParamsSpec.$,
    'MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParams',
    [
      mojo.internal.StructField<MostVisitedPageHandler_GetMostVisitedExpandedState_ResponseParamsMojoType, boolean>(
        'isExpanded', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MostVisitedPageHandler_SetMostVisitedExpandedState_ParamsMojoType {
  isExpanded: boolean;
}


export type MostVisitedPageHandler_SetMostVisitedExpandedState_Params = MostVisitedPageHandler_SetMostVisitedExpandedState_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_SetMostVisitedExpandedState_ParamsMojoType>(
    MostVisitedPageHandler_SetMostVisitedExpandedState_ParamsSpec.$,
    'MostVisitedPageHandler_SetMostVisitedExpandedState_Params',
    [
      mojo.internal.StructField<MostVisitedPageHandler_SetMostVisitedExpandedState_ParamsMojoType, boolean>(
        'isExpanded', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MostVisitedPageHandler_OnMostVisitedTilesRendered_ParamsMojoType {
  tiles: MostVisitedTile[];
  time: number;
}


export type MostVisitedPageHandler_OnMostVisitedTilesRendered_Params = MostVisitedPageHandler_OnMostVisitedTilesRendered_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_OnMostVisitedTilesRendered_ParamsMojoType>(
    MostVisitedPageHandler_OnMostVisitedTilesRendered_ParamsSpec.$,
    'MostVisitedPageHandler_OnMostVisitedTilesRendered_Params',
    [
      mojo.internal.StructField<MostVisitedPageHandler_OnMostVisitedTilesRendered_ParamsMojoType, MostVisitedTile[]>(
        'tiles', 0,
        0,
        mojo.internal.Array(MostVisitedTileSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedPageHandler_OnMostVisitedTilesRendered_ParamsMojoType, number>(
        'time', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsMojoType {
  tile: MostVisitedTile;
  index: number;
  mouseButton: number;
  altKey: boolean;
  ctrlKey: boolean;
  metaKey: boolean;
  shiftKey: boolean;
}


export type MostVisitedPageHandler_OnMostVisitedTileNavigation_Params = MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsMojoType;
mojo.internal.Struct<MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsMojoType>(
    MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsSpec.$,
    'MostVisitedPageHandler_OnMostVisitedTileNavigation_Params',
    [
      mojo.internal.StructField<MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsMojoType, MostVisitedTile>(
        'tile', 0,
        0,
        MostVisitedTileSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsMojoType, number>(
        'index', 8,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsMojoType, number>(
        'mouseButton', 12,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsMojoType, boolean>(
        'altKey', 13,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsMojoType, boolean>(
        'ctrlKey', 13,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsMojoType, boolean>(
        'metaKey', 13,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MostVisitedPageHandler_OnMostVisitedTileNavigation_ParamsMojoType, boolean>(
        'shiftKey', 13,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface MostVisitedPage_SetMostVisitedInfo_ParamsMojoType {
  info: MostVisitedInfo;
}


export type MostVisitedPage_SetMostVisitedInfo_Params = MostVisitedPage_SetMostVisitedInfo_ParamsMojoType;
mojo.internal.Struct<MostVisitedPage_SetMostVisitedInfo_ParamsMojoType>(
    MostVisitedPage_SetMostVisitedInfo_ParamsSpec.$,
    'MostVisitedPage_SetMostVisitedInfo_Params',
    [
      mojo.internal.StructField<MostVisitedPage_SetMostVisitedInfo_ParamsMojoType, MostVisitedInfo>(
        'info', 0,
        0,
        MostVisitedInfoSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



