// ui/webui/resources/cr_components/most_visited/most_visited.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_MOJOM_DATA_VIEW_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/webui/resources/cr_components/most_visited/most_visited.mojom-shared-internal.h"
#include "components/ntp_tiles/tile_source.mojom-shared.h"
#include "mojo/public/mojom/base/text_direction.mojom-shared.h"
#include "skia/public/mojom/skcolor.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"


namespace most_visited::mojom {
class MostVisitedTileDataView;

class MostVisitedThemeDataView;

class MostVisitedInfoDataView;



}  // most_visited::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::most_visited::mojom::MostVisitedTileDataView> {
  using Data = ::most_visited::mojom::internal::MostVisitedTile_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::most_visited::mojom::MostVisitedThemeDataView> {
  using Data = ::most_visited::mojom::internal::MostVisitedTheme_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::most_visited::mojom::MostVisitedInfoDataView> {
  using Data = ::most_visited::mojom::internal::MostVisitedInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace most_visited::mojom {
// Interface base classes. They are used for type safety check.
class MostVisitedPageHandlerFactoryInterfaceBase {};

using MostVisitedPageHandlerFactoryPtrDataView =
    mojo::InterfacePtrDataView<MostVisitedPageHandlerFactoryInterfaceBase>;
using MostVisitedPageHandlerFactoryRequestDataView =
    mojo::InterfaceRequestDataView<MostVisitedPageHandlerFactoryInterfaceBase>;
using MostVisitedPageHandlerFactoryAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MostVisitedPageHandlerFactoryInterfaceBase>;
using MostVisitedPageHandlerFactoryAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MostVisitedPageHandlerFactoryInterfaceBase>;
class MostVisitedPageHandlerInterfaceBase {};

using MostVisitedPageHandlerPtrDataView =
    mojo::InterfacePtrDataView<MostVisitedPageHandlerInterfaceBase>;
using MostVisitedPageHandlerRequestDataView =
    mojo::InterfaceRequestDataView<MostVisitedPageHandlerInterfaceBase>;
using MostVisitedPageHandlerAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MostVisitedPageHandlerInterfaceBase>;
using MostVisitedPageHandlerAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MostVisitedPageHandlerInterfaceBase>;
class MostVisitedPageInterfaceBase {};

using MostVisitedPagePtrDataView =
    mojo::InterfacePtrDataView<MostVisitedPageInterfaceBase>;
using MostVisitedPageRequestDataView =
    mojo::InterfaceRequestDataView<MostVisitedPageInterfaceBase>;
using MostVisitedPageAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<MostVisitedPageInterfaceBase>;
using MostVisitedPageAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<MostVisitedPageInterfaceBase>;


class MostVisitedTileDataView {
 public:
  MostVisitedTileDataView() = default;

  MostVisitedTileDataView(
      internal::MostVisitedTile_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetTitleDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTitle(UserType* output) {
    
    auto* pointer = data_->title.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadTitleDirection(UserType* output) const {
    auto data_value = data_->title_direction;
    return mojo::internal::Deserialize<::mojo_base::mojom::TextDirection>(
        data_value, output);
  }
  ::mojo_base::mojom::TextDirection title_direction() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::mojo_base::mojom::TextDirection>(data_->title_direction));
  }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  bool is_query_tile() const {
    return data_->is_query_tile;
  }
  bool allow_user_edit() const {
    return data_->allow_user_edit;
  }
  bool allow_user_delete() const {
    return data_->allow_user_delete;
  }
  template <typename UserType>
  [[nodiscard]] bool ReadSource(UserType* output) const {
    auto data_value = data_->source;
    return mojo::internal::Deserialize<::ntp_tiles::mojom::TileSource>(
        data_value, output);
  }
  ::ntp_tiles::mojom::TileSource source() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::ntp_tiles::mojom::TileSource>(data_->source));
  }
  int32_t title_source() const {
    return data_->title_source;
  }
 private:
  internal::MostVisitedTile_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MostVisitedThemeDataView {
 public:
  MostVisitedThemeDataView() = default;

  MostVisitedThemeDataView(
      internal::MostVisitedTheme_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetBackgroundColorDataView(
      ::skia::mojom::SkColorDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadBackgroundColor(UserType* output) {
    
    auto* pointer = data_->background_color.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkColorDataView>(
        pointer, output, message_);
  }
  bool use_white_tile_icon() const {
    return data_->use_white_tile_icon;
  }
  bool is_dark() const {
    return data_->is_dark;
  }
 private:
  internal::MostVisitedTheme_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class MostVisitedInfoDataView {
 public:
  MostVisitedInfoDataView() = default;

  MostVisitedInfoDataView(
      internal::MostVisitedInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  bool custom_links_enabled() const {
    return data_->custom_links_enabled;
  }
  bool enterprise_shortcuts_enabled() const {
    return data_->enterprise_shortcuts_enabled;
  }
  bool visible() const {
    return data_->visible;
  }
  inline void GetTilesDataView(
      mojo::ArrayDataView<MostVisitedTileDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTiles(UserType* output) {
    
    auto* pointer = data_->tiles.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::most_visited::mojom::MostVisitedTileDataView>>(
        pointer, output, message_);
  }
 private:
  internal::MostVisitedInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // most_visited::mojom

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_MOST_VISITED_MOST_VISITED_MOJOM_DATA_VIEW_H_