// ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_EMBEDDINGS_HISTORY_EMBEDDINGS_MOJOM_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_EMBEDDINGS_HISTORY_EMBEDDINGS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom-features.h"  // IWYU pragma: export
#include "ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom-shared.h"  // IWYU pragma: export
#include "ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace history_embeddings::mojom {

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "history_embeddings.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSetPageMinVersion = 0,
    kSearchMinVersion = 0,
    kSendQualityLogMinVersion = 0,
    kRecordSearchResultsMetricsMinVersion = 0,
    kSetUserFeedbackMinVersion = 0,
    kMaybeShowFeaturePromoMinVersion = 0,
    kOpenSettingsPageMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SetPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Search_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SendQualityLog_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordSearchResultsMetrics_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetUserFeedback_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct MaybeShowFeaturePromo_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenSettingsPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void SetPage(::mojo::PendingRemote<Page> page) = 0;

  virtual void Search(SearchQueryPtr query) = 0;

  virtual void SendQualityLog(const std::vector<uint32_t>& selected_indices, uint32_t num_entered_chars) = 0;

  virtual void RecordSearchResultsMetrics(bool nonEmptyResults, bool userClickedResult, bool answerShown, bool answerCitationClicked, bool otherHistoryResultClicked, uint32_t queryWordCount) = 0;

  virtual void SetUserFeedback(UserFeedback feedback) = 0;

  virtual void MaybeShowFeaturePromo() = 0;

  virtual void OpenSettingsPage() = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "history_embeddings.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kSearchResultChangedMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct SearchResultChanged_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void SearchResultChanged(SearchResultPtr result) = 0;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetPage(::mojo::PendingRemote<Page> page) final;
  
  void Search(SearchQueryPtr query) final;
  
  void SendQualityLog(const std::vector<uint32_t>& selected_indices, uint32_t num_entered_chars) final;
  
  void RecordSearchResultsMetrics(bool nonEmptyResults, bool userClickedResult, bool answerShown, bool answerCitationClicked, bool otherHistoryResultClicked, uint32_t queryWordCount) final;
  
  void SetUserFeedback(UserFeedback feedback) final;
  
  void MaybeShowFeaturePromo() final;
  
  void OpenSettingsPage() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SearchResultChanged(SearchResultPtr result) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};











class  AnswerData {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<AnswerData, T>::value>;
  using DataView = AnswerDataDataView;
  using Data_ = internal::AnswerData_Data;

  template <typename... Args>
  static AnswerDataPtr New(Args&&... args) {
    return AnswerDataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AnswerDataPtr From(const U& u) {
    return mojo::TypeConverter<AnswerDataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, AnswerData>::Convert(*this);
  }


  AnswerData();

  explicit AnswerData(
      std::vector<std::string> answer_text_directives);


  ~AnswerData();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AnswerDataPtr>
  AnswerDataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, AnswerData::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, AnswerData::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, AnswerData::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnswerData::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        AnswerData::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        AnswerData::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::AnswerData_UnserializedMessageContext<
            UserType, AnswerData::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<AnswerData::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return AnswerData::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::AnswerData_UnserializedMessageContext<
            UserType, AnswerData::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<AnswerData::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::string> answer_text_directives;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, AnswerData::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, AnswerData::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, AnswerData::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, AnswerData::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SearchResultItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SearchResultItem, T>::value>;
  using DataView = SearchResultItemDataView;
  using Data_ = internal::SearchResultItem_Data;

  template <typename... Args>
  static SearchResultItemPtr New(Args&&... args) {
    return SearchResultItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SearchResultItemPtr From(const U& u) {
    return mojo::TypeConverter<SearchResultItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SearchResultItem>::Convert(*this);
  }


  SearchResultItem();

  SearchResultItem(
      const std::string& title,
      const ::GURL& url,
      const std::string& url_for_display,
      const std::string& relative_time,
      const std::string& short_date_time,
      double last_url_visit_timestamp,
      const std::string& source_passage,
      AnswerDataPtr answer_data,
      bool is_url_known_to_sync);

SearchResultItem(const SearchResultItem&) = delete;
SearchResultItem& operator=(const SearchResultItem&) = delete;

  ~SearchResultItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SearchResultItemPtr>
  SearchResultItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SearchResultItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SearchResultItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SearchResultItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchResultItem::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchResultItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SearchResultItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SearchResultItem_UnserializedMessageContext<
            UserType, SearchResultItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SearchResultItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SearchResultItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SearchResultItem_UnserializedMessageContext<
            UserType, SearchResultItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SearchResultItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string title;
  
  ::GURL url;
  
  std::string url_for_display;
  
  std::string relative_time;
  
  std::string short_date_time;
  
  double last_url_visit_timestamp;
  
  std::string source_passage;
  
  AnswerDataPtr answer_data;
  
  bool is_url_known_to_sync;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SearchResultItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SearchResultItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SearchResultItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SearchResultItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SearchQuery {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SearchQuery, T>::value>;
  using DataView = SearchQueryDataView;
  using Data_ = internal::SearchQuery_Data;

  template <typename... Args>
  static SearchQueryPtr New(Args&&... args) {
    return SearchQueryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SearchQueryPtr From(const U& u) {
    return mojo::TypeConverter<SearchQueryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SearchQuery>::Convert(*this);
  }


  SearchQuery();

  SearchQuery(
      const std::string& query,
      std::optional<::base::Time> time_range_start);


  ~SearchQuery();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SearchQueryPtr>
  SearchQueryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SearchQuery::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SearchQuery::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SearchQuery::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchQuery::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchQuery::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SearchQuery::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SearchQuery_UnserializedMessageContext<
            UserType, SearchQuery::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SearchQuery::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SearchQuery::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SearchQuery_UnserializedMessageContext<
            UserType, SearchQuery::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SearchQuery::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string query;
  
  std::optional<::base::Time> time_range_start;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SearchQuery::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SearchQuery::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SearchQuery::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SearchQuery::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  SearchResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SearchResult, T>::value>;
  using DataView = SearchResultDataView;
  using Data_ = internal::SearchResult_Data;

  template <typename... Args>
  static SearchResultPtr New(Args&&... args) {
    return SearchResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SearchResultPtr From(const U& u) {
    return mojo::TypeConverter<SearchResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SearchResult>::Convert(*this);
  }


  SearchResult();

  SearchResult(
      const std::string& query,
      AnswerStatus answer_status,
      const std::string& answer,
      std::vector<SearchResultItemPtr> items);

SearchResult(const SearchResult&) = delete;
SearchResult& operator=(const SearchResult&) = delete;

  ~SearchResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SearchResultPtr>
  SearchResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SearchResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, SearchResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, SearchResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SearchResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SearchResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SearchResult_UnserializedMessageContext<
            UserType, SearchResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<SearchResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return SearchResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SearchResult_UnserializedMessageContext<
            UserType, SearchResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SearchResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string query;
  
  AnswerStatus answer_status;
  
  std::string answer;
  
  std::vector<SearchResultItemPtr> items;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SearchResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SearchResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SearchResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SearchResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AnswerDataPtr AnswerData::Clone() const {
  return New(
      mojo::Clone(answer_text_directives)
  );
}

template <typename T, AnswerData::EnableIfSame<T>*>
bool AnswerData::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->answer_text_directives, other_struct.answer_text_directives))
    return false;
  return true;
}

template <typename T, AnswerData::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.answer_text_directives < rhs.answer_text_directives)
    return true;
  if (rhs.answer_text_directives < lhs.answer_text_directives)
    return false;
  return false;
}
template <typename StructPtrType>
SearchResultItemPtr SearchResultItem::Clone() const {
  return New(
      mojo::Clone(title),
      mojo::Clone(url),
      mojo::Clone(url_for_display),
      mojo::Clone(relative_time),
      mojo::Clone(short_date_time),
      mojo::Clone(last_url_visit_timestamp),
      mojo::Clone(source_passage),
      mojo::Clone(answer_data),
      mojo::Clone(is_url_known_to_sync)
  );
}

template <typename T, SearchResultItem::EnableIfSame<T>*>
bool SearchResultItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->title, other_struct.title))
    return false;
  if (!mojo::Equals(this->url, other_struct.url))
    return false;
  if (!mojo::Equals(this->url_for_display, other_struct.url_for_display))
    return false;
  if (!mojo::Equals(this->relative_time, other_struct.relative_time))
    return false;
  if (!mojo::Equals(this->short_date_time, other_struct.short_date_time))
    return false;
  if (!mojo::Equals(this->last_url_visit_timestamp, other_struct.last_url_visit_timestamp))
    return false;
  if (!mojo::Equals(this->source_passage, other_struct.source_passage))
    return false;
  if (!mojo::Equals(this->answer_data, other_struct.answer_data))
    return false;
  if (!mojo::Equals(this->is_url_known_to_sync, other_struct.is_url_known_to_sync))
    return false;
  return true;
}

template <typename T, SearchResultItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.title < rhs.title)
    return true;
  if (rhs.title < lhs.title)
    return false;
  if (lhs.url < rhs.url)
    return true;
  if (rhs.url < lhs.url)
    return false;
  if (lhs.url_for_display < rhs.url_for_display)
    return true;
  if (rhs.url_for_display < lhs.url_for_display)
    return false;
  if (lhs.relative_time < rhs.relative_time)
    return true;
  if (rhs.relative_time < lhs.relative_time)
    return false;
  if (lhs.short_date_time < rhs.short_date_time)
    return true;
  if (rhs.short_date_time < lhs.short_date_time)
    return false;
  if (lhs.last_url_visit_timestamp < rhs.last_url_visit_timestamp)
    return true;
  if (rhs.last_url_visit_timestamp < lhs.last_url_visit_timestamp)
    return false;
  if (lhs.source_passage < rhs.source_passage)
    return true;
  if (rhs.source_passage < lhs.source_passage)
    return false;
  if (lhs.answer_data < rhs.answer_data)
    return true;
  if (rhs.answer_data < lhs.answer_data)
    return false;
  if (lhs.is_url_known_to_sync < rhs.is_url_known_to_sync)
    return true;
  if (rhs.is_url_known_to_sync < lhs.is_url_known_to_sync)
    return false;
  return false;
}
template <typename StructPtrType>
SearchQueryPtr SearchQuery::Clone() const {
  return New(
      mojo::Clone(query),
      mojo::Clone(time_range_start)
  );
}

template <typename T, SearchQuery::EnableIfSame<T>*>
bool SearchQuery::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->query, other_struct.query))
    return false;
  if (!mojo::Equals(this->time_range_start, other_struct.time_range_start))
    return false;
  return true;
}

template <typename T, SearchQuery::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.query < rhs.query)
    return true;
  if (rhs.query < lhs.query)
    return false;
  if (lhs.time_range_start < rhs.time_range_start)
    return true;
  if (rhs.time_range_start < lhs.time_range_start)
    return false;
  return false;
}
template <typename StructPtrType>
SearchResultPtr SearchResult::Clone() const {
  return New(
      mojo::Clone(query),
      mojo::Clone(answer_status),
      mojo::Clone(answer),
      mojo::Clone(items)
  );
}

template <typename T, SearchResult::EnableIfSame<T>*>
bool SearchResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->query, other_struct.query))
    return false;
  if (!mojo::Equals(this->answer_status, other_struct.answer_status))
    return false;
  if (!mojo::Equals(this->answer, other_struct.answer))
    return false;
  if (!mojo::Equals(this->items, other_struct.items))
    return false;
  return true;
}

template <typename T, SearchResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.query < rhs.query)
    return true;
  if (rhs.query < lhs.query)
    return false;
  if (lhs.answer_status < rhs.answer_status)
    return true;
  if (rhs.answer_status < lhs.answer_status)
    return false;
  if (lhs.answer < rhs.answer)
    return true;
  if (rhs.answer < lhs.answer)
    return false;
  if (lhs.items < rhs.items)
    return true;
  if (rhs.items < lhs.items)
    return false;
  return false;
}


}  // history_embeddings::mojom

namespace mojo {


template <>
struct  StructTraits<::history_embeddings::mojom::AnswerData::DataView,
                                         ::history_embeddings::mojom::AnswerDataPtr> {
  static bool IsNull(const ::history_embeddings::mojom::AnswerDataPtr& input) { return !input; }
  static void SetToNull(::history_embeddings::mojom::AnswerDataPtr* output) { output->reset(); }

  static const decltype(::history_embeddings::mojom::AnswerData::answer_text_directives)& answer_text_directives(
      const ::history_embeddings::mojom::AnswerDataPtr& input) {
    return input->answer_text_directives;
  }

  static bool Read(::history_embeddings::mojom::AnswerData::DataView input, ::history_embeddings::mojom::AnswerDataPtr* output);
};


template <>
struct  StructTraits<::history_embeddings::mojom::SearchResultItem::DataView,
                                         ::history_embeddings::mojom::SearchResultItemPtr> {
  static bool IsNull(const ::history_embeddings::mojom::SearchResultItemPtr& input) { return !input; }
  static void SetToNull(::history_embeddings::mojom::SearchResultItemPtr* output) { output->reset(); }

  static const decltype(::history_embeddings::mojom::SearchResultItem::title)& title(
      const ::history_embeddings::mojom::SearchResultItemPtr& input) {
    return input->title;
  }

  static const decltype(::history_embeddings::mojom::SearchResultItem::url)& url(
      const ::history_embeddings::mojom::SearchResultItemPtr& input) {
    return input->url;
  }

  static const decltype(::history_embeddings::mojom::SearchResultItem::url_for_display)& url_for_display(
      const ::history_embeddings::mojom::SearchResultItemPtr& input) {
    return input->url_for_display;
  }

  static const decltype(::history_embeddings::mojom::SearchResultItem::relative_time)& relative_time(
      const ::history_embeddings::mojom::SearchResultItemPtr& input) {
    return input->relative_time;
  }

  static const decltype(::history_embeddings::mojom::SearchResultItem::short_date_time)& short_date_time(
      const ::history_embeddings::mojom::SearchResultItemPtr& input) {
    return input->short_date_time;
  }

  static decltype(::history_embeddings::mojom::SearchResultItem::last_url_visit_timestamp) last_url_visit_timestamp(
      const ::history_embeddings::mojom::SearchResultItemPtr& input) {
    return input->last_url_visit_timestamp;
  }

  static const decltype(::history_embeddings::mojom::SearchResultItem::source_passage)& source_passage(
      const ::history_embeddings::mojom::SearchResultItemPtr& input) {
    return input->source_passage;
  }

  static const decltype(::history_embeddings::mojom::SearchResultItem::answer_data)& answer_data(
      const ::history_embeddings::mojom::SearchResultItemPtr& input) {
    return input->answer_data;
  }

  static decltype(::history_embeddings::mojom::SearchResultItem::is_url_known_to_sync) is_url_known_to_sync(
      const ::history_embeddings::mojom::SearchResultItemPtr& input) {
    return input->is_url_known_to_sync;
  }

  static bool Read(::history_embeddings::mojom::SearchResultItem::DataView input, ::history_embeddings::mojom::SearchResultItemPtr* output);
};


template <>
struct  StructTraits<::history_embeddings::mojom::SearchQuery::DataView,
                                         ::history_embeddings::mojom::SearchQueryPtr> {
  static bool IsNull(const ::history_embeddings::mojom::SearchQueryPtr& input) { return !input; }
  static void SetToNull(::history_embeddings::mojom::SearchQueryPtr* output) { output->reset(); }

  static const decltype(::history_embeddings::mojom::SearchQuery::query)& query(
      const ::history_embeddings::mojom::SearchQueryPtr& input) {
    return input->query;
  }

  static const decltype(::history_embeddings::mojom::SearchQuery::time_range_start)& time_range_start(
      const ::history_embeddings::mojom::SearchQueryPtr& input) {
    return input->time_range_start;
  }

  static bool Read(::history_embeddings::mojom::SearchQuery::DataView input, ::history_embeddings::mojom::SearchQueryPtr* output);
};


template <>
struct  StructTraits<::history_embeddings::mojom::SearchResult::DataView,
                                         ::history_embeddings::mojom::SearchResultPtr> {
  static bool IsNull(const ::history_embeddings::mojom::SearchResultPtr& input) { return !input; }
  static void SetToNull(::history_embeddings::mojom::SearchResultPtr* output) { output->reset(); }

  static const decltype(::history_embeddings::mojom::SearchResult::query)& query(
      const ::history_embeddings::mojom::SearchResultPtr& input) {
    return input->query;
  }

  static decltype(::history_embeddings::mojom::SearchResult::answer_status) answer_status(
      const ::history_embeddings::mojom::SearchResultPtr& input) {
    return input->answer_status;
  }

  static const decltype(::history_embeddings::mojom::SearchResult::answer)& answer(
      const ::history_embeddings::mojom::SearchResultPtr& input) {
    return input->answer;
  }

  static const decltype(::history_embeddings::mojom::SearchResult::items)& items(
      const ::history_embeddings::mojom::SearchResultPtr& input) {
    return input->items;
  }

  static bool Read(::history_embeddings::mojom::SearchResult::DataView input, ::history_embeddings::mojom::SearchResultPtr* output);
};

}  // namespace mojo

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_EMBEDDINGS_HISTORY_EMBEDDINGS_MOJOM_H_