// ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "base/strings/stringprintf.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/webui/resources/cr_components/history_embeddings/history_embeddings.mojom-params-data.h"
namespace history_embeddings {
namespace mojom {

NOINLINE static const char* AnswerStatusToStringHelper(AnswerStatus value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case AnswerStatus::kUnspecified:
      return "kUnspecified";
    case AnswerStatus::kLoading:
      return "kLoading";
    case AnswerStatus::kSuccess:
      return "kSuccess";
    case AnswerStatus::kUnanswerable:
      return "kUnanswerable";
    case AnswerStatus::kModelUnavailable:
      return "kModelUnavailable";
    case AnswerStatus::kExecutionFailure:
      return "kExecutionFailure";
    case AnswerStatus::kExecutionCanceled:
      return "kExecutionCanceled";
    case AnswerStatus::kFiltered:
      return "kFiltered";
    default:
      return nullptr;
  }
}

std::string AnswerStatusToString(AnswerStatus value) {
  const char *str = AnswerStatusToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown AnswerStatus value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, AnswerStatus value) {
  return os << AnswerStatusToString(value);
}

NOINLINE static const char* UserFeedbackToStringHelper(UserFeedback value) {
  // Defined in a helper function to ensure that Clang generates a lookup table.
  switch(value) {
    case UserFeedback::kUserFeedbackUnspecified:
      return "kUserFeedbackUnspecified";
    case UserFeedback::kUserFeedbackNegative:
      return "kUserFeedbackNegative";
    case UserFeedback::kUserFeedbackPositive:
      return "kUserFeedbackPositive";
    default:
      return nullptr;
  }
}

std::string UserFeedbackToString(UserFeedback value) {
  const char *str = UserFeedbackToStringHelper(value);
  if (!str) {
    return base::StringPrintf("Unknown UserFeedback value: %i", static_cast<int32_t>(value));
  }
  return str;
}

std::ostream& operator<<(std::ostream& os, UserFeedback value) {
  return os << UserFeedbackToString(value);
}

namespace internal {


// static
bool AnswerData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const AnswerData_Data* object =
      static_cast<const AnswerData_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->answer_text_directives, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& answer_text_directives_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->answer_text_directives, validation_context,
                                         &answer_text_directives_validate_params)) {
    return false;
  }

  return true;
}

AnswerData_Data::AnswerData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SearchResultItem_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 80, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SearchResultItem_Data* object =
      static_cast<const SearchResultItem_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->title, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& title_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->title, validation_context,
                                         &title_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url_for_display, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& url_for_display_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->url_for_display, validation_context,
                                         &url_for_display_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->relative_time, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& relative_time_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->relative_time, validation_context,
                                         &relative_time_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->short_date_time, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& short_date_time_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->short_date_time, validation_context,
                                         &short_date_time_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_passage, 7, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& source_passage_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->source_passage, validation_context,
                                         &source_passage_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->answer_data, validation_context))
    return false;

  return true;
}

SearchResultItem_Data::SearchResultItem_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SearchQuery_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SearchQuery_Data* object =
      static_cast<const SearchQuery_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->time_range_start, validation_context))
    return false;

  return true;
}

SearchQuery_Data::SearchQuery_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SearchResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SearchResult_Data* object =
      static_cast<const SearchResult_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& query_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->query, validation_context,
                                         &query_validate_params)) {
    return false;
  }


  if (!::history_embeddings::mojom::internal::AnswerStatus_Data
        ::Validate(object->answer_status, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->answer, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& answer_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->answer, validation_context,
                                         &answer_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->items, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& items_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->items, validation_context,
                                         &items_validate_params)) {
    return false;
  }

  return true;
}

SearchResult_Data::SearchResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetPage_Params_Data* object =
      static_cast<const PageHandler_SetPage_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->page, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->page,
                                                 validation_context)) {
    return false;
  }

  return true;
}

PageHandler_SetPage_Params_Data::PageHandler_SetPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_Search_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_Search_Params_Data* object =
      static_cast<const PageHandler_Search_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->query, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->query, validation_context))
    return false;

  return true;
}

PageHandler_Search_Params_Data::PageHandler_Search_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SendQualityLog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SendQualityLog_Params_Data* object =
      static_cast<const PageHandler_SendQualityLog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->selected_indices, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& selected_indices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->selected_indices, validation_context,
                                         &selected_indices_validate_params)) {
    return false;
  }

  return true;
}

PageHandler_SendQualityLog_Params_Data::PageHandler_SendQualityLog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_RecordSearchResultsMetrics_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_RecordSearchResultsMetrics_Params_Data* object =
      static_cast<const PageHandler_RecordSearchResultsMetrics_Params_Data*>(data);

  return true;
}

PageHandler_RecordSearchResultsMetrics_Params_Data::PageHandler_RecordSearchResultsMetrics_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_SetUserFeedback_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_SetUserFeedback_Params_Data* object =
      static_cast<const PageHandler_SetUserFeedback_Params_Data*>(data);


  if (!::history_embeddings::mojom::internal::UserFeedback_Data
        ::Validate(object->feedback, validation_context))
    return false;

  return true;
}

PageHandler_SetUserFeedback_Params_Data::PageHandler_SetUserFeedback_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_MaybeShowFeaturePromo_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_MaybeShowFeaturePromo_Params_Data* object =
      static_cast<const PageHandler_MaybeShowFeaturePromo_Params_Data*>(data);

  return true;
}

PageHandler_MaybeShowFeaturePromo_Params_Data::PageHandler_MaybeShowFeaturePromo_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool PageHandler_OpenSettingsPage_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const PageHandler_OpenSettingsPage_Params_Data* object =
      static_cast<const PageHandler_OpenSettingsPage_Params_Data*>(data);

  return true;
}

PageHandler_OpenSettingsPage_Params_Data::PageHandler_OpenSettingsPage_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Page_SearchResultChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const Page_SearchResultChanged_Params_Data* object =
      static_cast<const Page_SearchResultChanged_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

Page_SearchResultChanged_Params_Data::Page_SearchResultChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace history_embeddings

namespace perfetto {

// static
void TraceFormatTraits<::history_embeddings::mojom::AnswerStatus>::WriteIntoTrace(
   perfetto::TracedValue context, ::history_embeddings::mojom::AnswerStatus value) {
  return std::move(context).WriteString(::history_embeddings::mojom::AnswerStatusToString(value));
}

} // namespace perfetto

namespace perfetto {

// static
void TraceFormatTraits<::history_embeddings::mojom::UserFeedback>::WriteIntoTrace(
   perfetto::TracedValue context, ::history_embeddings::mojom::UserFeedback value) {
  return std::move(context).WriteString(::history_embeddings::mojom::UserFeedbackToString(value));
}

} // namespace perfetto