// ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  ClusterSpec as historyClusters_mojom_ClusterSpec,
  Cluster as historyClusters_mojom_Cluster,
  URLVisitSpec as historyClusters_mojom_URLVisitSpec,
  URLVisit as historyClusters_mojom_URLVisit
} from './history_cluster_types.mojom-webui.js';
import {
  TimeSpec as mojoBase_mojom_TimeSpec,
  Time as mojoBase_mojom_Time
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import {
  ClickModifiersSpec as ui_mojom_ClickModifiersSpec,
  ClickModifiers as ui_mojom_ClickModifiers
} from '//resources/mojo/ui/base/mojom/window_open_disposition.mojom-webui.js';
import {
  PointSpec as gfx_mojom_PointSpec,
  Point as gfx_mojom_Point
} from '//resources/mojo/ui/gfx/geometry/mojom/geometry.mojom-webui.js';
import {
  UrlSpec as url_mojom_UrlSpec,
  Url as url_mojom_Url
} from '//resources/mojo/url/mojom/url.mojom-webui.js';





export const ClusterActionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum ClusterAction {

  MIN_VALUE = 0,
  MAX_VALUE = 3,
  kDeleted = 0,
  kOpenedInTabGroup = 1,
  kRelatedSearchClicked = 2,
  kVisitClicked = 3,
}

export const RelatedSearchActionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum RelatedSearchAction {

  MIN_VALUE = 0,
  MAX_VALUE = 0,
  kClicked = 0,
}

export const VisitActionSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum VisitAction {

  MIN_VALUE = 0,
  MAX_VALUE = 2,
  kClicked = 0,
  kHidden = 1,
  kDeleted = 2,
}

export const VisitTypeSpec: { $: mojo.internal.MojomType } = { $: mojo.internal.Enum() };

export enum VisitType {

  MIN_VALUE = 0,
  MAX_VALUE = 1,
  kSRP = 0,
  kNonSRP = 1,
}



export type PageHandlerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;

export class PageHandlerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<PageHandler> {

  handle: mojo.internal.interfaceSupport.Endpoint<PageHandlerPendingReceiver>;
  constructor(handle: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'history_clusters.mojom.PageHandler',
        scope);
  }
}

export interface PageHandlerInterface {
  openHistoryUrl(url: url_mojom_Url, clickModifiers: ui_mojom_ClickModifiers): void;
  setPage(page: PageRemote): void;
  showContextMenuForSearchbox(query: string, point: gfx_mojom_Point): void;
  showContextMenuForURL(url: url_mojom_Url, point: gfx_mojom_Point): void;
  showSidePanelUI(): void;
  toggleVisibility(visible: boolean): Promise<{
        visible: boolean, }>;
  startQueryClusters(query: string, beginTime: (mojoBase_mojom_Time | null), recluster: boolean): void;
  loadMoreClusters(query: string): void;
  hideVisits(visits: historyClusters_mojom_URLVisit[]): Promise<{
        success: boolean, }>;
  removeVisits(visits: historyClusters_mojom_URLVisit[]): Promise<{
        success: boolean, }>;
  removeVisitByUrlAndTime(url: url_mojom_Url, timestamp: number): Promise<{
        success: boolean, }>;
  openVisitUrlsInTabGroup(visits: historyClusters_mojom_URLVisit[], tabGroupName: (string | null)): void;
  recordVisitAction(visitAction: VisitAction, visitIndex: number, visitType: VisitType): void;
  recordRelatedSearchAction(action: RelatedSearchAction, visitIndex: number): void;
  recordClusterAction(clusterAction: ClusterAction, clusterIndex: number): void;
  recordToggledVisibility(visible: boolean): void;
}

export class PageHandlerRemote implements PageHandlerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PageHandlerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PageHandlerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PageHandlerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  openHistoryUrl(
      url: url_mojom_Url,
      clickModifiers: ui_mojom_ClickModifiers): void {
    this.proxy.sendMessage(
        0,
        PageHandler_OpenHistoryUrl_ParamsSpec.$,
        null,
        [
          url,
          clickModifiers
        ],
        false);
  }

  setPage(
      page: PageRemote): void {
    this.proxy.sendMessage(
        1,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        [
          page
        ],
        false);
  }

  showContextMenuForSearchbox(
      query: string,
      point: gfx_mojom_Point): void {
    this.proxy.sendMessage(
        2,
        PageHandler_ShowContextMenuForSearchbox_ParamsSpec.$,
        null,
        [
          query,
          point
        ],
        false);
  }

  showContextMenuForURL(
      url: url_mojom_Url,
      point: gfx_mojom_Point): void {
    this.proxy.sendMessage(
        3,
        PageHandler_ShowContextMenuForURL_ParamsSpec.$,
        null,
        [
          url,
          point
        ],
        false);
  }

  showSidePanelUI(): void {
    this.proxy.sendMessage(
        4,
        PageHandler_ShowSidePanelUI_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  toggleVisibility(
      visible: boolean): Promise<{
        visible: boolean, }> {
    return this.proxy.sendMessage(
        5,
        PageHandler_ToggleVisibility_ParamsSpec.$,
        PageHandler_ToggleVisibility_ResponseParamsSpec.$,
        [
          visible
        ],
        false);
  }

  startQueryClusters(
      query: string,
      beginTime: (mojoBase_mojom_Time | null),
      recluster: boolean): void {
    this.proxy.sendMessage(
        6,
        PageHandler_StartQueryClusters_ParamsSpec.$,
        null,
        [
          query,
          beginTime,
          recluster
        ],
        false);
  }

  loadMoreClusters(
      query: string): void {
    this.proxy.sendMessage(
        7,
        PageHandler_LoadMoreClusters_ParamsSpec.$,
        null,
        [
          query
        ],
        false);
  }

  hideVisits(
      visits: historyClusters_mojom_URLVisit[]): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        8,
        PageHandler_HideVisits_ParamsSpec.$,
        PageHandler_HideVisits_ResponseParamsSpec.$,
        [
          visits
        ],
        false);
  }

  removeVisits(
      visits: historyClusters_mojom_URLVisit[]): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        9,
        PageHandler_RemoveVisits_ParamsSpec.$,
        PageHandler_RemoveVisits_ResponseParamsSpec.$,
        [
          visits
        ],
        false);
  }

  removeVisitByUrlAndTime(
      url: url_mojom_Url,
      timestamp: number): Promise<{
        success: boolean, }> {
    return this.proxy.sendMessage(
        10,
        PageHandler_RemoveVisitByUrlAndTime_ParamsSpec.$,
        PageHandler_RemoveVisitByUrlAndTime_ResponseParamsSpec.$,
        [
          url,
          timestamp
        ],
        false);
  }

  openVisitUrlsInTabGroup(
      visits: historyClusters_mojom_URLVisit[],
      tabGroupName: (string | null)): void {
    this.proxy.sendMessage(
        11,
        PageHandler_OpenVisitUrlsInTabGroup_ParamsSpec.$,
        null,
        [
          visits,
          tabGroupName
        ],
        false);
  }

  recordVisitAction(
      visitAction: VisitAction,
      visitIndex: number,
      visitType: VisitType): void {
    this.proxy.sendMessage(
        12,
        PageHandler_RecordVisitAction_ParamsSpec.$,
        null,
        [
          visitAction,
          visitIndex,
          visitType
        ],
        false);
  }

  recordRelatedSearchAction(
      action: RelatedSearchAction,
      visitIndex: number): void {
    this.proxy.sendMessage(
        13,
        PageHandler_RecordRelatedSearchAction_ParamsSpec.$,
        null,
        [
          action,
          visitIndex
        ],
        false);
  }

  recordClusterAction(
      clusterAction: ClusterAction,
      clusterIndex: number): void {
    this.proxy.sendMessage(
        14,
        PageHandler_RecordClusterAction_ParamsSpec.$,
        null,
        [
          clusterAction,
          clusterIndex
        ],
        false);
  }

  recordToggledVisibility(
      visible: boolean): void {
    this.proxy.sendMessage(
        15,
        PageHandler_RecordToggledVisibility_ParamsSpec.$,
        null,
        [
          visible
        ],
        false);
  }
};

/**
 * An object which receives request messages for the PageHandler
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageHandlerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageHandlerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        PageHandler_OpenHistoryUrl_ParamsSpec.$,
        null,
        impl.openHistoryUrl.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        impl.setPage.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        PageHandler_ShowContextMenuForSearchbox_ParamsSpec.$,
        null,
        impl.showContextMenuForSearchbox.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        PageHandler_ShowContextMenuForURL_ParamsSpec.$,
        null,
        impl.showContextMenuForURL.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        PageHandler_ShowSidePanelUI_ParamsSpec.$,
        null,
        impl.showSidePanelUI.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        PageHandler_ToggleVisibility_ParamsSpec.$,
        PageHandler_ToggleVisibility_ResponseParamsSpec.$,
        impl.toggleVisibility.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        PageHandler_StartQueryClusters_ParamsSpec.$,
        null,
        impl.startQueryClusters.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        PageHandler_LoadMoreClusters_ParamsSpec.$,
        null,
        impl.loadMoreClusters.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        PageHandler_HideVisits_ParamsSpec.$,
        PageHandler_HideVisits_ResponseParamsSpec.$,
        impl.hideVisits.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        PageHandler_RemoveVisits_ParamsSpec.$,
        PageHandler_RemoveVisits_ResponseParamsSpec.$,
        impl.removeVisits.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        PageHandler_RemoveVisitByUrlAndTime_ParamsSpec.$,
        PageHandler_RemoveVisitByUrlAndTime_ResponseParamsSpec.$,
        impl.removeVisitByUrlAndTime.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        PageHandler_OpenVisitUrlsInTabGroup_ParamsSpec.$,
        null,
        impl.openVisitUrlsInTabGroup.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        PageHandler_RecordVisitAction_ParamsSpec.$,
        null,
        impl.recordVisitAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        PageHandler_RecordRelatedSearchAction_ParamsSpec.$,
        null,
        impl.recordRelatedSearchAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        PageHandler_RecordClusterAction_ParamsSpec.$,
        null,
        impl.recordClusterAction.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        PageHandler_RecordToggledVisibility_ParamsSpec.$,
        null,
        impl.recordToggledVisibility.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class PageHandler {
  static get $interfaceName(): string {
    return "history_clusters.mojom.PageHandler";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageHandlerRemote {
    let remote = new PageHandlerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the PageHandler
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageHandlerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageHandlerRemote, PageHandlerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  openHistoryUrl: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setPage: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showContextMenuForSearchbox: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showContextMenuForURL: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  showSidePanelUI: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  toggleVisibility: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  startQueryClusters: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  loadMoreClusters: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  hideVisits: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  removeVisits: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  removeVisitByUrlAndTime: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  openVisitUrlsInTabGroup: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordVisitAction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordRelatedSearchAction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordClusterAction: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  recordToggledVisibility: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageHandlerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.openHistoryUrl =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        PageHandler_OpenHistoryUrl_ParamsSpec.$,
        null,
        this.openHistoryUrl.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setPage =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        PageHandler_SetPage_ParamsSpec.$,
        null,
        this.setPage.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showContextMenuForSearchbox =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        PageHandler_ShowContextMenuForSearchbox_ParamsSpec.$,
        null,
        this.showContextMenuForSearchbox.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showContextMenuForURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        PageHandler_ShowContextMenuForURL_ParamsSpec.$,
        null,
        this.showContextMenuForURL.createReceiverHandler(false /* expectsResponse */),
        false);
    this.showSidePanelUI =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        PageHandler_ShowSidePanelUI_ParamsSpec.$,
        null,
        this.showSidePanelUI.createReceiverHandler(false /* expectsResponse */),
        false);
    this.toggleVisibility =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        PageHandler_ToggleVisibility_ParamsSpec.$,
        PageHandler_ToggleVisibility_ResponseParamsSpec.$,
        this.toggleVisibility.createReceiverHandler(true /* expectsResponse */),
        false);
    this.startQueryClusters =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        PageHandler_StartQueryClusters_ParamsSpec.$,
        null,
        this.startQueryClusters.createReceiverHandler(false /* expectsResponse */),
        false);
    this.loadMoreClusters =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        PageHandler_LoadMoreClusters_ParamsSpec.$,
        null,
        this.loadMoreClusters.createReceiverHandler(false /* expectsResponse */),
        false);
    this.hideVisits =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        PageHandler_HideVisits_ParamsSpec.$,
        PageHandler_HideVisits_ResponseParamsSpec.$,
        this.hideVisits.createReceiverHandler(true /* expectsResponse */),
        false);
    this.removeVisits =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        PageHandler_RemoveVisits_ParamsSpec.$,
        PageHandler_RemoveVisits_ResponseParamsSpec.$,
        this.removeVisits.createReceiverHandler(true /* expectsResponse */),
        false);
    this.removeVisitByUrlAndTime =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        PageHandler_RemoveVisitByUrlAndTime_ParamsSpec.$,
        PageHandler_RemoveVisitByUrlAndTime_ResponseParamsSpec.$,
        this.removeVisitByUrlAndTime.createReceiverHandler(true /* expectsResponse */),
        false);
    this.openVisitUrlsInTabGroup =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        PageHandler_OpenVisitUrlsInTabGroup_ParamsSpec.$,
        null,
        this.openVisitUrlsInTabGroup.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordVisitAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        PageHandler_RecordVisitAction_ParamsSpec.$,
        null,
        this.recordVisitAction.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordRelatedSearchAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        PageHandler_RecordRelatedSearchAction_ParamsSpec.$,
        null,
        this.recordRelatedSearchAction.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordClusterAction =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        PageHandler_RecordClusterAction_ParamsSpec.$,
        null,
        this.recordClusterAction.createReceiverHandler(false /* expectsResponse */),
        false);
    this.recordToggledVisibility =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        PageHandler_RecordToggledVisibility_ParamsSpec.$,
        null,
        this.recordToggledVisibility.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type PagePendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;

export class PagePendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<Page> {

  handle: mojo.internal.interfaceSupport.Endpoint<PagePendingReceiver>;
  constructor(handle: MojoHandle|PagePendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'history_clusters.mojom.Page',
        scope);
  }
}

export interface PageInterface {
  onClustersQueryResult(result: QueryResult): void;
  onClusterImageUpdated(clusterIndex: number, imageUrl: url_mojom_Url): void;
  onVisitsHidden(hiddenVisits: historyClusters_mojom_URLVisit[]): void;
  onVisitsRemoved(removedVisits: historyClusters_mojom_URLVisit[]): void;
  onHistoryDeleted(): void;
  onQueryChangedByUser(query: string): void;
}

export class PageRemote implements PageInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<PagePendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|PagePendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          PagePendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  onClustersQueryResult(
      result: QueryResult): void {
    this.proxy.sendMessage(
        0,
        Page_OnClustersQueryResult_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }

  onClusterImageUpdated(
      clusterIndex: number,
      imageUrl: url_mojom_Url): void {
    this.proxy.sendMessage(
        1,
        Page_OnClusterImageUpdated_ParamsSpec.$,
        null,
        [
          clusterIndex,
          imageUrl
        ],
        false);
  }

  onVisitsHidden(
      hiddenVisits: historyClusters_mojom_URLVisit[]): void {
    this.proxy.sendMessage(
        2,
        Page_OnVisitsHidden_ParamsSpec.$,
        null,
        [
          hiddenVisits
        ],
        false);
  }

  onVisitsRemoved(
      removedVisits: historyClusters_mojom_URLVisit[]): void {
    this.proxy.sendMessage(
        3,
        Page_OnVisitsRemoved_ParamsSpec.$,
        null,
        [
          removedVisits
        ],
        false);
  }

  onHistoryDeleted(): void {
    this.proxy.sendMessage(
        4,
        Page_OnHistoryDeleted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  onQueryChangedByUser(
      query: string): void {
    this.proxy.sendMessage(
        5,
        Page_OnQueryChangedByUser_ParamsSpec.$,
        null,
        [
          query
        ],
        false);
  }
};

/**
 * An object which receives request messages for the Page
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class PageReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: PageInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Page_OnClustersQueryResult_ParamsSpec.$,
        null,
        impl.onClustersQueryResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Page_OnClusterImageUpdated_ParamsSpec.$,
        null,
        impl.onClusterImageUpdated.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Page_OnVisitsHidden_ParamsSpec.$,
        null,
        impl.onVisitsHidden.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Page_OnVisitsRemoved_ParamsSpec.$,
        null,
        impl.onVisitsRemoved.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Page_OnHistoryDeleted_ParamsSpec.$,
        null,
        impl.onHistoryDeleted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Page_OnQueryChangedByUser_ParamsSpec.$,
        null,
        impl.onQueryChangedByUser.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Page {
  static get $interfaceName(): string {
    return "history_clusters.mojom.Page";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): PageRemote {
    let remote = new PageRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the Page
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class PageCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    PageRemote, PagePendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    PageRemote, PagePendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  onClustersQueryResult: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onClusterImageUpdated: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onVisitsHidden: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onVisitsRemoved: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onHistoryDeleted: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onQueryChangedByUser: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      PageRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.onClustersQueryResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Page_OnClustersQueryResult_ParamsSpec.$,
        null,
        this.onClustersQueryResult.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onClusterImageUpdated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Page_OnClusterImageUpdated_ParamsSpec.$,
        null,
        this.onClusterImageUpdated.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onVisitsHidden =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Page_OnVisitsHidden_ParamsSpec.$,
        null,
        this.onVisitsHidden.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onVisitsRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Page_OnVisitsRemoved_ParamsSpec.$,
        null,
        this.onVisitsRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onHistoryDeleted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Page_OnHistoryDeleted_ParamsSpec.$,
        null,
        this.onHistoryDeleted.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onQueryChangedByUser =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Page_OnQueryChangedByUser_ParamsSpec.$,
        null,
        this.onQueryChangedByUser.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const QueryResultSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenHistoryUrl_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_SetPage_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShowContextMenuForSearchbox_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShowContextMenuForURL_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ShowSidePanelUI_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ToggleVisibility_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_ToggleVisibility_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_StartQueryClusters_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_LoadMoreClusters_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_HideVisits_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_HideVisits_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RemoveVisits_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RemoveVisits_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RemoveVisitByUrlAndTime_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RemoveVisitByUrlAndTime_ResponseParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_OpenVisitUrlsInTabGroup_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordVisitAction_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordRelatedSearchAction_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordClusterAction_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const PageHandler_RecordToggledVisibility_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnClustersQueryResult_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnClusterImageUpdated_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnVisitsHidden_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnVisitsRemoved_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnHistoryDeleted_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const Page_OnQueryChangedByUser_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface QueryResultMojoType {
  query: string;
  clusters: historyClusters_mojom_Cluster[];
  canLoadMore: boolean;
  isContinuation: boolean;
}


export type QueryResult = QueryResultMojoType;
mojo.internal.Struct<QueryResultMojoType>(
    QueryResultSpec.$,
    'QueryResult',
    [
      mojo.internal.StructField<QueryResultMojoType, string>(
        'query', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<QueryResultMojoType, historyClusters_mojom_Cluster[]>(
        'clusters', 8,
        0,
        mojo.internal.Array(historyClusters_mojom_ClusterSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<QueryResultMojoType, boolean>(
        'canLoadMore', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<QueryResultMojoType, boolean>(
        'isContinuation', 16,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_OpenHistoryUrl_ParamsMojoType {
  url: url_mojom_Url;
  clickModifiers: ui_mojom_ClickModifiers;
}


export type PageHandler_OpenHistoryUrl_Params = PageHandler_OpenHistoryUrl_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenHistoryUrl_ParamsMojoType>(
    PageHandler_OpenHistoryUrl_ParamsSpec.$,
    'PageHandler_OpenHistoryUrl_Params',
    [
      mojo.internal.StructField<PageHandler_OpenHistoryUrl_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OpenHistoryUrl_ParamsMojoType, ui_mojom_ClickModifiers>(
        'clickModifiers', 8,
        0,
        ui_mojom_ClickModifiersSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_SetPage_ParamsMojoType {
  page: PageRemote;
}


export type PageHandler_SetPage_Params = PageHandler_SetPage_ParamsMojoType;
mojo.internal.Struct<PageHandler_SetPage_ParamsMojoType>(
    PageHandler_SetPage_ParamsSpec.$,
    'PageHandler_SetPage_Params',
    [
      mojo.internal.StructField<PageHandler_SetPage_ParamsMojoType, PageRemote>(
        'page', 0,
        0,
        mojo.internal.InterfaceProxy(PageRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ShowContextMenuForSearchbox_ParamsMojoType {
  query: string;
  point: gfx_mojom_Point;
}


export type PageHandler_ShowContextMenuForSearchbox_Params = PageHandler_ShowContextMenuForSearchbox_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShowContextMenuForSearchbox_ParamsMojoType>(
    PageHandler_ShowContextMenuForSearchbox_ParamsSpec.$,
    'PageHandler_ShowContextMenuForSearchbox_Params',
    [
      mojo.internal.StructField<PageHandler_ShowContextMenuForSearchbox_ParamsMojoType, string>(
        'query', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ShowContextMenuForSearchbox_ParamsMojoType, gfx_mojom_Point>(
        'point', 8,
        0,
        gfx_mojom_PointSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_ShowContextMenuForURL_ParamsMojoType {
  url: url_mojom_Url;
  point: gfx_mojom_Point;
}


export type PageHandler_ShowContextMenuForURL_Params = PageHandler_ShowContextMenuForURL_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShowContextMenuForURL_ParamsMojoType>(
    PageHandler_ShowContextMenuForURL_ParamsSpec.$,
    'PageHandler_ShowContextMenuForURL_Params',
    [
      mojo.internal.StructField<PageHandler_ShowContextMenuForURL_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_ShowContextMenuForURL_ParamsMojoType, gfx_mojom_Point>(
        'point', 8,
        0,
        gfx_mojom_PointSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_ShowSidePanelUI_ParamsMojoType {
}


export type PageHandler_ShowSidePanelUI_Params = PageHandler_ShowSidePanelUI_ParamsMojoType;
mojo.internal.Struct<PageHandler_ShowSidePanelUI_ParamsMojoType>(
    PageHandler_ShowSidePanelUI_ParamsSpec.$,
    'PageHandler_ShowSidePanelUI_Params',
    [
    ],
    [[0, 8],]);





export interface PageHandler_ToggleVisibility_ParamsMojoType {
  visible: boolean;
}


export type PageHandler_ToggleVisibility_Params = PageHandler_ToggleVisibility_ParamsMojoType;
mojo.internal.Struct<PageHandler_ToggleVisibility_ParamsMojoType>(
    PageHandler_ToggleVisibility_ParamsSpec.$,
    'PageHandler_ToggleVisibility_Params',
    [
      mojo.internal.StructField<PageHandler_ToggleVisibility_ParamsMojoType, boolean>(
        'visible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_ToggleVisibility_ResponseParamsMojoType {
  visible: boolean;
}


export type PageHandler_ToggleVisibility_ResponseParams = PageHandler_ToggleVisibility_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_ToggleVisibility_ResponseParamsMojoType>(
    PageHandler_ToggleVisibility_ResponseParamsSpec.$,
    'PageHandler_ToggleVisibility_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_ToggleVisibility_ResponseParamsMojoType, boolean>(
        'visible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_StartQueryClusters_ParamsMojoType {
  query: string;
  beginTime: (mojoBase_mojom_Time | null);
  recluster: boolean;
}


export type PageHandler_StartQueryClusters_Params = PageHandler_StartQueryClusters_ParamsMojoType;
mojo.internal.Struct<PageHandler_StartQueryClusters_ParamsMojoType>(
    PageHandler_StartQueryClusters_ParamsSpec.$,
    'PageHandler_StartQueryClusters_Params',
    [
      mojo.internal.StructField<PageHandler_StartQueryClusters_ParamsMojoType, string>(
        'query', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_StartQueryClusters_ParamsMojoType, mojoBase_mojom_Time>(
        'beginTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_StartQueryClusters_ParamsMojoType, boolean>(
        'recluster', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface PageHandler_LoadMoreClusters_ParamsMojoType {
  query: string;
}


export type PageHandler_LoadMoreClusters_Params = PageHandler_LoadMoreClusters_ParamsMojoType;
mojo.internal.Struct<PageHandler_LoadMoreClusters_ParamsMojoType>(
    PageHandler_LoadMoreClusters_ParamsSpec.$,
    'PageHandler_LoadMoreClusters_Params',
    [
      mojo.internal.StructField<PageHandler_LoadMoreClusters_ParamsMojoType, string>(
        'query', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_HideVisits_ParamsMojoType {
  visits: historyClusters_mojom_URLVisit[];
}


export type PageHandler_HideVisits_Params = PageHandler_HideVisits_ParamsMojoType;
mojo.internal.Struct<PageHandler_HideVisits_ParamsMojoType>(
    PageHandler_HideVisits_ParamsSpec.$,
    'PageHandler_HideVisits_Params',
    [
      mojo.internal.StructField<PageHandler_HideVisits_ParamsMojoType, historyClusters_mojom_URLVisit[]>(
        'visits', 0,
        0,
        mojo.internal.Array(historyClusters_mojom_URLVisitSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_HideVisits_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_HideVisits_ResponseParams = PageHandler_HideVisits_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_HideVisits_ResponseParamsMojoType>(
    PageHandler_HideVisits_ResponseParamsSpec.$,
    'PageHandler_HideVisits_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_HideVisits_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RemoveVisits_ParamsMojoType {
  visits: historyClusters_mojom_URLVisit[];
}


export type PageHandler_RemoveVisits_Params = PageHandler_RemoveVisits_ParamsMojoType;
mojo.internal.Struct<PageHandler_RemoveVisits_ParamsMojoType>(
    PageHandler_RemoveVisits_ParamsSpec.$,
    'PageHandler_RemoveVisits_Params',
    [
      mojo.internal.StructField<PageHandler_RemoveVisits_ParamsMojoType, historyClusters_mojom_URLVisit[]>(
        'visits', 0,
        0,
        mojo.internal.Array(historyClusters_mojom_URLVisitSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RemoveVisits_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_RemoveVisits_ResponseParams = PageHandler_RemoveVisits_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_RemoveVisits_ResponseParamsMojoType>(
    PageHandler_RemoveVisits_ResponseParamsSpec.$,
    'PageHandler_RemoveVisits_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_RemoveVisits_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RemoveVisitByUrlAndTime_ParamsMojoType {
  url: url_mojom_Url;
  timestamp: number;
}


export type PageHandler_RemoveVisitByUrlAndTime_Params = PageHandler_RemoveVisitByUrlAndTime_ParamsMojoType;
mojo.internal.Struct<PageHandler_RemoveVisitByUrlAndTime_ParamsMojoType>(
    PageHandler_RemoveVisitByUrlAndTime_ParamsSpec.$,
    'PageHandler_RemoveVisitByUrlAndTime_Params',
    [
      mojo.internal.StructField<PageHandler_RemoveVisitByUrlAndTime_ParamsMojoType, url_mojom_Url>(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RemoveVisitByUrlAndTime_ParamsMojoType, number>(
        'timestamp', 8,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RemoveVisitByUrlAndTime_ResponseParamsMojoType {
  success: boolean;
}


export type PageHandler_RemoveVisitByUrlAndTime_ResponseParams = PageHandler_RemoveVisitByUrlAndTime_ResponseParamsMojoType;
mojo.internal.Struct<PageHandler_RemoveVisitByUrlAndTime_ResponseParamsMojoType>(
    PageHandler_RemoveVisitByUrlAndTime_ResponseParamsSpec.$,
    'PageHandler_RemoveVisitByUrlAndTime_ResponseParams',
    [
      mojo.internal.StructField<PageHandler_RemoveVisitByUrlAndTime_ResponseParamsMojoType, boolean>(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_OpenVisitUrlsInTabGroup_ParamsMojoType {
  visits: historyClusters_mojom_URLVisit[];
  tabGroupName: (string | null);
}


export type PageHandler_OpenVisitUrlsInTabGroup_Params = PageHandler_OpenVisitUrlsInTabGroup_ParamsMojoType;
mojo.internal.Struct<PageHandler_OpenVisitUrlsInTabGroup_ParamsMojoType>(
    PageHandler_OpenVisitUrlsInTabGroup_ParamsSpec.$,
    'PageHandler_OpenVisitUrlsInTabGroup_Params',
    [
      mojo.internal.StructField<PageHandler_OpenVisitUrlsInTabGroup_ParamsMojoType, historyClusters_mojom_URLVisit[]>(
        'visits', 0,
        0,
        mojo.internal.Array(historyClusters_mojom_URLVisitSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_OpenVisitUrlsInTabGroup_ParamsMojoType, string>(
        'tabGroupName', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RecordVisitAction_ParamsMojoType {
  visitAction: VisitAction;
  visitIndex: number;
  visitType: VisitType;
}


export type PageHandler_RecordVisitAction_Params = PageHandler_RecordVisitAction_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordVisitAction_ParamsMojoType>(
    PageHandler_RecordVisitAction_ParamsSpec.$,
    'PageHandler_RecordVisitAction_Params',
    [
      mojo.internal.StructField<PageHandler_RecordVisitAction_ParamsMojoType, VisitAction>(
        'visitAction', 0,
        0,
        VisitActionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordVisitAction_ParamsMojoType, number>(
        'visitIndex', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordVisitAction_ParamsMojoType, VisitType>(
        'visitType', 8,
        0,
        VisitTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface PageHandler_RecordRelatedSearchAction_ParamsMojoType {
  action: RelatedSearchAction;
  visitIndex: number;
}


export type PageHandler_RecordRelatedSearchAction_Params = PageHandler_RecordRelatedSearchAction_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordRelatedSearchAction_ParamsMojoType>(
    PageHandler_RecordRelatedSearchAction_ParamsSpec.$,
    'PageHandler_RecordRelatedSearchAction_Params',
    [
      mojo.internal.StructField<PageHandler_RecordRelatedSearchAction_ParamsMojoType, RelatedSearchAction>(
        'action', 0,
        0,
        RelatedSearchActionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordRelatedSearchAction_ParamsMojoType, number>(
        'visitIndex', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RecordClusterAction_ParamsMojoType {
  clusterAction: ClusterAction;
  clusterIndex: number;
}


export type PageHandler_RecordClusterAction_Params = PageHandler_RecordClusterAction_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordClusterAction_ParamsMojoType>(
    PageHandler_RecordClusterAction_ParamsSpec.$,
    'PageHandler_RecordClusterAction_Params',
    [
      mojo.internal.StructField<PageHandler_RecordClusterAction_ParamsMojoType, ClusterAction>(
        'clusterAction', 0,
        0,
        ClusterActionSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<PageHandler_RecordClusterAction_ParamsMojoType, number>(
        'clusterIndex', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface PageHandler_RecordToggledVisibility_ParamsMojoType {
  visible: boolean;
}


export type PageHandler_RecordToggledVisibility_Params = PageHandler_RecordToggledVisibility_ParamsMojoType;
mojo.internal.Struct<PageHandler_RecordToggledVisibility_ParamsMojoType>(
    PageHandler_RecordToggledVisibility_ParamsSpec.$,
    'PageHandler_RecordToggledVisibility_Params',
    [
      mojo.internal.StructField<PageHandler_RecordToggledVisibility_ParamsMojoType, boolean>(
        'visible', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnClustersQueryResult_ParamsMojoType {
  result: QueryResult;
}


export type Page_OnClustersQueryResult_Params = Page_OnClustersQueryResult_ParamsMojoType;
mojo.internal.Struct<Page_OnClustersQueryResult_ParamsMojoType>(
    Page_OnClustersQueryResult_ParamsSpec.$,
    'Page_OnClustersQueryResult_Params',
    [
      mojo.internal.StructField<Page_OnClustersQueryResult_ParamsMojoType, QueryResult>(
        'result', 0,
        0,
        QueryResultSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnClusterImageUpdated_ParamsMojoType {
  clusterIndex: number;
  imageUrl: url_mojom_Url;
}


export type Page_OnClusterImageUpdated_Params = Page_OnClusterImageUpdated_ParamsMojoType;
mojo.internal.Struct<Page_OnClusterImageUpdated_ParamsMojoType>(
    Page_OnClusterImageUpdated_ParamsSpec.$,
    'Page_OnClusterImageUpdated_Params',
    [
      mojo.internal.StructField<Page_OnClusterImageUpdated_ParamsMojoType, number>(
        'clusterIndex', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<Page_OnClusterImageUpdated_ParamsMojoType, url_mojom_Url>(
        'imageUrl', 8,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface Page_OnVisitsHidden_ParamsMojoType {
  hiddenVisits: historyClusters_mojom_URLVisit[];
}


export type Page_OnVisitsHidden_Params = Page_OnVisitsHidden_ParamsMojoType;
mojo.internal.Struct<Page_OnVisitsHidden_ParamsMojoType>(
    Page_OnVisitsHidden_ParamsSpec.$,
    'Page_OnVisitsHidden_Params',
    [
      mojo.internal.StructField<Page_OnVisitsHidden_ParamsMojoType, historyClusters_mojom_URLVisit[]>(
        'hiddenVisits', 0,
        0,
        mojo.internal.Array(historyClusters_mojom_URLVisitSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnVisitsRemoved_ParamsMojoType {
  removedVisits: historyClusters_mojom_URLVisit[];
}


export type Page_OnVisitsRemoved_Params = Page_OnVisitsRemoved_ParamsMojoType;
mojo.internal.Struct<Page_OnVisitsRemoved_ParamsMojoType>(
    Page_OnVisitsRemoved_ParamsSpec.$,
    'Page_OnVisitsRemoved_Params',
    [
      mojo.internal.StructField<Page_OnVisitsRemoved_ParamsMojoType, historyClusters_mojom_URLVisit[]>(
        'removedVisits', 0,
        0,
        mojo.internal.Array(historyClusters_mojom_URLVisitSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface Page_OnHistoryDeleted_ParamsMojoType {
}


export type Page_OnHistoryDeleted_Params = Page_OnHistoryDeleted_ParamsMojoType;
mojo.internal.Struct<Page_OnHistoryDeleted_ParamsMojoType>(
    Page_OnHistoryDeleted_ParamsSpec.$,
    'Page_OnHistoryDeleted_Params',
    [
    ],
    [[0, 8],]);





export interface Page_OnQueryChangedByUser_ParamsMojoType {
  query: string;
}


export type Page_OnQueryChangedByUser_Params = Page_OnQueryChangedByUser_ParamsMojoType;
mojo.internal.Struct<Page_OnQueryChangedByUser_ParamsMojoType>(
    Page_OnQueryChangedByUser_ParamsSpec.$,
    'Page_OnQueryChangedByUser_Params',
    [
      mojo.internal.StructField<Page_OnQueryChangedByUser_ParamsMojoType, string>(
        'query', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);



