// ui/webui/resources/cr_components/history_clusters/history_clusters.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_MOJOM_H_
#define UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-features.h"  // IWYU pragma: export
#include "ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-shared.h"  // IWYU pragma: export
#include "ui/webui/resources/cr_components/history_clusters/history_clusters.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "ui/base/mojom/window_open_disposition.mojom-forward.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "url/mojom/url.mojom.h"
#include "components/history_clusters/public/mojom/history_cluster_types.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace history_clusters::mojom {

class PageHandlerProxy;

template <typename ImplRefTraits>
class PageHandlerStub;

class PageHandlerRequestValidator;
class PageHandlerResponseValidator;


class PageHandler
    : public PageHandlerInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "history_clusters.mojom.PageHandler";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageHandlerInterfaceBase;
  using Proxy_ = PageHandlerProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageHandlerStub<ImplRefTraits>;

  using RequestValidator_ = PageHandlerRequestValidator;
  using ResponseValidator_ = PageHandlerResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOpenHistoryUrlMinVersion = 0,
    kSetPageMinVersion = 0,
    kShowContextMenuForSearchboxMinVersion = 0,
    kShowContextMenuForURLMinVersion = 0,
    kShowSidePanelUIMinVersion = 0,
    kToggleVisibilityMinVersion = 0,
    kStartQueryClustersMinVersion = 0,
    kLoadMoreClustersMinVersion = 0,
    kHideVisitsMinVersion = 0,
    kRemoveVisitsMinVersion = 0,
    kRemoveVisitByUrlAndTimeMinVersion = 0,
    kOpenVisitUrlsInTabGroupMinVersion = 0,
    kRecordVisitActionMinVersion = 0,
    kRecordRelatedSearchActionMinVersion = 0,
    kRecordClusterActionMinVersion = 0,
    kRecordToggledVisibilityMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OpenHistoryUrl_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct SetPage_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowContextMenuForSearchbox_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowContextMenuForURL_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ShowSidePanelUI_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct ToggleVisibility_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct StartQueryClusters_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct LoadMoreClusters_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct HideVisits_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveVisits_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveVisitByUrlAndTime_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OpenVisitUrlsInTabGroup_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordVisitAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordRelatedSearchAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordClusterAction_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RecordToggledVisibility_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~PageHandler() = default;

  virtual void OpenHistoryUrl(const ::GURL& url, ::ui::mojom::ClickModifiersPtr click_modifiers) = 0;

  virtual void SetPage(::mojo::PendingRemote<Page> page) = 0;

  virtual void ShowContextMenuForSearchbox(const std::string& query, const ::gfx::Point& point) = 0;

  virtual void ShowContextMenuForURL(const ::GURL& url, const ::gfx::Point& point) = 0;

  virtual void ShowSidePanelUI() = 0;

  using ToggleVisibilityCallback = base::OnceCallback<void(bool)>;
  using ToggleVisibilityMojoCallback = base::OnceCallback<void(bool)>;

  virtual void ToggleVisibility(bool visible, ToggleVisibilityCallback callback) = 0;

  virtual void StartQueryClusters(const std::string& query, std::optional<::base::Time> begin_time, bool recluster) = 0;

  virtual void LoadMoreClusters(const std::string& query) = 0;

  using HideVisitsCallback = base::OnceCallback<void(bool)>;
  using HideVisitsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void HideVisits(std::vector<::history_clusters::mojom::URLVisitPtr> visits, HideVisitsCallback callback) = 0;

  using RemoveVisitsCallback = base::OnceCallback<void(bool)>;
  using RemoveVisitsMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RemoveVisits(std::vector<::history_clusters::mojom::URLVisitPtr> visits, RemoveVisitsCallback callback) = 0;

  using RemoveVisitByUrlAndTimeCallback = base::OnceCallback<void(bool)>;
  using RemoveVisitByUrlAndTimeMojoCallback = base::OnceCallback<void(bool)>;

  virtual void RemoveVisitByUrlAndTime(const ::GURL& url, double timestamp, RemoveVisitByUrlAndTimeCallback callback) = 0;

  virtual void OpenVisitUrlsInTabGroup(std::vector<::history_clusters::mojom::URLVisitPtr> visits, const std::optional<std::string>& tab_group_name) = 0;

  virtual void RecordVisitAction(VisitAction visit_action, uint32_t visit_index, VisitType visit_type) = 0;

  virtual void RecordRelatedSearchAction(RelatedSearchAction action, uint32_t visit_index) = 0;

  virtual void RecordClusterAction(ClusterAction cluster_action, uint32_t cluster_index) = 0;

  virtual void RecordToggledVisibility(bool visible) = 0;
};

class PageProxy;

template <typename ImplRefTraits>
class PageStub;

class PageRequestValidator;


class Page
    : public PageInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "history_clusters.mojom.Page";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = PageInterfaceBase;
  using Proxy_ = PageProxy;

  template <typename ImplRefTraits>
  using Stub_ = PageStub<ImplRefTraits>;

  using RequestValidator_ = PageRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnClustersQueryResultMinVersion = 0,
    kOnClusterImageUpdatedMinVersion = 0,
    kOnVisitsHiddenMinVersion = 0,
    kOnVisitsRemovedMinVersion = 0,
    kOnHistoryDeletedMinVersion = 0,
    kOnQueryChangedByUserMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct OnClustersQueryResult_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnClusterImageUpdated_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnVisitsHidden_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnVisitsRemoved_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnHistoryDeleted_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct OnQueryChangedByUser_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Page() = default;

  virtual void OnClustersQueryResult(QueryResultPtr result) = 0;

  virtual void OnClusterImageUpdated(int32_t cluster_index, const ::GURL& image_url) = 0;

  virtual void OnVisitsHidden(std::vector<::history_clusters::mojom::URLVisitPtr> hidden_visits) = 0;

  virtual void OnVisitsRemoved(std::vector<::history_clusters::mojom::URLVisitPtr> removed_visits) = 0;

  virtual void OnHistoryDeleted() = 0;

  virtual void OnQueryChangedByUser(const std::string& query) = 0;
};



class  PageHandlerProxy
    : public PageHandler {
 public:
  using InterfaceType = PageHandler;

  explicit PageHandlerProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OpenHistoryUrl(const ::GURL& url, ::ui::mojom::ClickModifiersPtr click_modifiers) final;
  
  void SetPage(::mojo::PendingRemote<Page> page) final;
  
  void ShowContextMenuForSearchbox(const std::string& query, const ::gfx::Point& point) final;
  
  void ShowContextMenuForURL(const ::GURL& url, const ::gfx::Point& point) final;
  
  void ShowSidePanelUI() final;
  
  void ToggleVisibility(bool visible, ToggleVisibilityCallback callback) final;
  
  void StartQueryClusters(const std::string& query, std::optional<::base::Time> begin_time, bool recluster) final;
  
  void LoadMoreClusters(const std::string& query) final;
  
  void HideVisits(std::vector<::history_clusters::mojom::URLVisitPtr> visits, HideVisitsCallback callback) final;
  
  void RemoveVisits(std::vector<::history_clusters::mojom::URLVisitPtr> visits, RemoveVisitsCallback callback) final;
  
  void RemoveVisitByUrlAndTime(const ::GURL& url, double timestamp, RemoveVisitByUrlAndTimeCallback callback) final;
  
  void OpenVisitUrlsInTabGroup(std::vector<::history_clusters::mojom::URLVisitPtr> visits, const std::optional<std::string>& tab_group_name) final;
  
  void RecordVisitAction(VisitAction visit_action, uint32_t visit_index, VisitType visit_type) final;
  
  void RecordRelatedSearchAction(RelatedSearchAction action, uint32_t visit_index) final;
  
  void RecordClusterAction(ClusterAction cluster_action, uint32_t cluster_index) final;
  
  void RecordToggledVisibility(bool visible) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  PageProxy
    : public Page {
 public:
  using InterfaceType = Page;

  explicit PageProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnClustersQueryResult(QueryResultPtr result) final;
  
  void OnClusterImageUpdated(int32_t cluster_index, const ::GURL& image_url) final;
  
  void OnVisitsHidden(std::vector<::history_clusters::mojom::URLVisitPtr> hidden_visits) final;
  
  void OnVisitsRemoved(std::vector<::history_clusters::mojom::URLVisitPtr> removed_visits) final;
  
  void OnHistoryDeleted() final;
  
  void OnQueryChangedByUser(const std::string& query) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  PageHandlerStubDispatch {
 public:
  static bool Accept(PageHandler* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      PageHandler* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<PageHandler>>
class PageHandlerStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageHandlerStub() = default;
  ~PageHandlerStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageHandlerStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageStubDispatch {
 public:
  static bool Accept(Page* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Page* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Page>>
class PageStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  PageStub() = default;
  ~PageStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return PageStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  PageHandlerRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  PageHandlerResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};








class  QueryResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<QueryResult, T>::value>;
  using DataView = QueryResultDataView;
  using Data_ = internal::QueryResult_Data;

  template <typename... Args>
  static QueryResultPtr New(Args&&... args) {
    return QueryResultPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static QueryResultPtr From(const U& u) {
    return mojo::TypeConverter<QueryResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, QueryResult>::Convert(*this);
  }


  QueryResult();

  QueryResult(
      const std::string& query,
      std::vector<::history_clusters::mojom::ClusterPtr> clusters,
      bool can_load_more,
      bool is_continuation);

QueryResult(const QueryResult&) = delete;
QueryResult& operator=(const QueryResult&) = delete;

  ~QueryResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = QueryResultPtr>
  QueryResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, QueryResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, QueryResult::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, QueryResult::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryResult::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        QueryResult::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        QueryResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::QueryResult_UnserializedMessageContext<
            UserType, QueryResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<QueryResult::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return QueryResult::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::QueryResult_UnserializedMessageContext<
            UserType, QueryResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<QueryResult::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string query;
  
  std::vector<::history_clusters::mojom::ClusterPtr> clusters;
  
  bool can_load_more;
  
  bool is_continuation;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, QueryResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, QueryResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, QueryResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, QueryResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
QueryResultPtr QueryResult::Clone() const {
  return New(
      mojo::Clone(query),
      mojo::Clone(clusters),
      mojo::Clone(can_load_more),
      mojo::Clone(is_continuation)
  );
}

template <typename T, QueryResult::EnableIfSame<T>*>
bool QueryResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->query, other_struct.query))
    return false;
  if (!mojo::Equals(this->clusters, other_struct.clusters))
    return false;
  if (!mojo::Equals(this->can_load_more, other_struct.can_load_more))
    return false;
  if (!mojo::Equals(this->is_continuation, other_struct.is_continuation))
    return false;
  return true;
}

template <typename T, QueryResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.query < rhs.query)
    return true;
  if (rhs.query < lhs.query)
    return false;
  if (lhs.clusters < rhs.clusters)
    return true;
  if (rhs.clusters < lhs.clusters)
    return false;
  if (lhs.can_load_more < rhs.can_load_more)
    return true;
  if (rhs.can_load_more < lhs.can_load_more)
    return false;
  if (lhs.is_continuation < rhs.is_continuation)
    return true;
  if (rhs.is_continuation < lhs.is_continuation)
    return false;
  return false;
}


}  // history_clusters::mojom

namespace mojo {


template <>
struct  StructTraits<::history_clusters::mojom::QueryResult::DataView,
                                         ::history_clusters::mojom::QueryResultPtr> {
  static bool IsNull(const ::history_clusters::mojom::QueryResultPtr& input) { return !input; }
  static void SetToNull(::history_clusters::mojom::QueryResultPtr* output) { output->reset(); }

  static const decltype(::history_clusters::mojom::QueryResult::query)& query(
      const ::history_clusters::mojom::QueryResultPtr& input) {
    return input->query;
  }

  static const decltype(::history_clusters::mojom::QueryResult::clusters)& clusters(
      const ::history_clusters::mojom::QueryResultPtr& input) {
    return input->clusters;
  }

  static decltype(::history_clusters::mojom::QueryResult::can_load_more) can_load_more(
      const ::history_clusters::mojom::QueryResultPtr& input) {
    return input->can_load_more;
  }

  static decltype(::history_clusters::mojom::QueryResult::is_continuation) is_continuation(
      const ::history_clusters::mojom::QueryResultPtr& input) {
    return input->is_continuation;
  }

  static bool Read(::history_clusters::mojom::QueryResult::DataView input, ::history_clusters::mojom::QueryResultPtr* output);
};

}  // namespace mojo

#endif  // UI_WEBUI_RESOURCES_CR_COMPONENTS_HISTORY_CLUSTERS_HISTORY_CLUSTERS_MOJOM_H_