// ui/gfx/mojom/mask_filter_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/gfx/mojom/mask_filter_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('gfx.mojom');
  var rrect_f$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/rrect_f.mojom', 'rrect_f.mojom.js');
  }
  var linear_gradient$ =
      mojo.internal.exposeNamespace('gfx.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/gfx/mojom/linear_gradient.mojom', 'linear_gradient.mojom.js');
  }



  function MaskFilterInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  MaskFilterInfo.prototype.initDefaults_ = function() {
    this.roundedCornerBounds = null;
    this.gradientMask = null;
    this.clip_id_$flag = false;
    this.clip_id_$value = 0;
  };
  MaskFilterInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  MaskFilterInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MaskFilterInfo.roundedCornerBounds
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, rrect_f$.RRectF, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate MaskFilterInfo.gradientMask
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, linear_gradient$.LinearGradient, true);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  MaskFilterInfo.encodedSize = codec.kStructHeaderSize + 24;

  MaskFilterInfo.decode = function(decoder) {
    var packed;
    var val = new MaskFilterInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.roundedCornerBounds =
        decoder.decodeStructPointer(rrect_f$.RRectF);
    val.gradientMask =
        decoder.decodeStructPointer(linear_gradient$.LinearGradient);
    packed = decoder.readUint8();
    val.clip_id_$flag = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.clip_id_$value =
        decoder.decodeStruct(codec.Int32);
    return val;
  };

  MaskFilterInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(MaskFilterInfo.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(rrect_f$.RRectF, val.roundedCornerBounds);
    encoder.encodeStructPointer(linear_gradient$.LinearGradient, val.gradientMask);
    packed = 0;
    packed |= (val.clip_id_$flag & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Int32, val.clip_id_$value);
  };
  exports.MaskFilterInfo = MaskFilterInfo;
})();