// ui/gfx/mojom/display_color_spaces.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_SEND_VALIDATION_H_
#define UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_SEND_VALIDATION_H_

#include "ui/gfx/mojom/display_color_spaces.mojom-shared-internal.h"
#include "skia/public/mojom/skcolorspace_primaries.mojom-shared.h"
#include "ui/gfx/mojom/buffer_types.mojom-shared.h"
#include "ui/gfx/mojom/color_space.mojom-shared.h"
#include "ui/gfx/mojom/hdr_static_metadata.mojom-shared.h"

#include "ui/gfx/mojom/display_color_spaces.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::gfx::mojom::ContentColorUsage, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::DisplayColorSpacesDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::DisplayColorSpacesDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::DisplayColorSpaces_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::color_spaces(input)) in_color_spaces = Traits::color_spaces(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->color_spaces)::BaseType>
          color_spaces_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& color_spaces_validate_params =
          mojo::internal::GetArrayValidator<6, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::ColorSpaceDataView>, send_validation>(
        in_color_spaces,
        color_spaces_fragment,
        &color_spaces_validate_params);

      fragment->color_spaces.Set(
          color_spaces_fragment.is_null() ? nullptr : color_spaces_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->color_spaces.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_spaces in DisplayColorSpaces struct");

      decltype(Traits::buffer_formats(input)) in_buffer_formats = Traits::buffer_formats(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->buffer_formats)::BaseType>
          buffer_formats_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& buffer_formats_validate_params =
          mojo::internal::GetArrayOfEnumsValidator<6, false, ::gfx::mojom::internal::BufferFormat_Data::Validate>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::gfx::mojom::BufferFormat>, send_validation>(
        in_buffer_formats,
        buffer_formats_fragment,
        &buffer_formats_validate_params);

      fragment->buffer_formats.Set(
          buffer_formats_fragment.is_null() ? nullptr : buffer_formats_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->buffer_formats.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null buffer_formats in DisplayColorSpaces struct");

      decltype(Traits::primaries(input)) in_primaries = Traits::primaries(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->primaries)::BaseType> primaries_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::skia::mojom::SkColorSpacePrimariesDataView, send_validation>(
        in_primaries,
        primaries_fragment);

      fragment->primaries.Set(
          primaries_fragment.is_null() ? nullptr : primaries_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->primaries.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null primaries in DisplayColorSpaces struct");

      fragment->sdr_max_luminance_nits = Traits::sdr_max_luminance_nits(input);

      fragment->hdr_max_luminance_relative = Traits::hdr_max_luminance_relative(input);
  }
};

}  // namespace mojo::internal

#endif  // UI_GFX_MOJOM_DISPLAY_COLOR_SPACES_MOJOM_SEND_VALIDATION_H_