// ui/gfx/mojom/delegated_ink_point.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_DELEGATED_INK_POINT_MOJOM_BLINK_H_
#define UI_GFX_MOJOM_DELEGATED_INK_POINT_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/gfx/mojom/delegated_ink_point.mojom-features.h"  // IWYU pragma: export
#include "ui/gfx/mojom/delegated_ink_point.mojom-shared.h"  // IWYU pragma: export
#include "ui/gfx/mojom/delegated_ink_point.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom-blink.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace gfx::mojom::blink {








class  DelegatedInkPoint {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DelegatedInkPoint, T>::value>;
  using DataView = DelegatedInkPointDataView;
  using Data_ = internal::DelegatedInkPoint_Data;

  template <typename... Args>
  static DelegatedInkPointPtr New(Args&&... args) {
    return DelegatedInkPointPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DelegatedInkPointPtr From(const U& u) {
    return mojo::TypeConverter<DelegatedInkPointPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DelegatedInkPoint>::Convert(*this);
  }


  DelegatedInkPoint();

  DelegatedInkPoint(
      const ::gfx::PointF& point,
      ::base::TimeTicks timestamp,
      int32_t pointer_id);


  ~DelegatedInkPoint();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DelegatedInkPointPtr>
  DelegatedInkPointPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DelegatedInkPoint::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DelegatedInkPoint::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DelegatedInkPoint::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DelegatedInkPoint::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DelegatedInkPoint::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DelegatedInkPoint::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DelegatedInkPoint_UnserializedMessageContext<
            UserType, DelegatedInkPoint::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DelegatedInkPoint::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DelegatedInkPoint::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DelegatedInkPoint_UnserializedMessageContext<
            UserType, DelegatedInkPoint::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DelegatedInkPoint::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::PointF point;
  
  ::base::TimeTicks timestamp;
  
  int32_t pointer_id;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DelegatedInkPoint::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DelegatedInkPoint::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DelegatedInkPoint::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DelegatedInkPoint::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DelegatedInkPointPtr DelegatedInkPoint::Clone() const {
  return New(
      mojo::Clone(point),
      mojo::Clone(timestamp),
      mojo::Clone(pointer_id)
  );
}

template <typename T, DelegatedInkPoint::EnableIfSame<T>*>
bool DelegatedInkPoint::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->point, other_struct.point))
    return false;
  if (!mojo::Equals(this->timestamp, other_struct.timestamp))
    return false;
  if (!mojo::Equals(this->pointer_id, other_struct.pointer_id))
    return false;
  return true;
}

template <typename T, DelegatedInkPoint::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.point < rhs.point)
    return true;
  if (rhs.point < lhs.point)
    return false;
  if (lhs.timestamp < rhs.timestamp)
    return true;
  if (rhs.timestamp < lhs.timestamp)
    return false;
  if (lhs.pointer_id < rhs.pointer_id)
    return true;
  if (rhs.pointer_id < lhs.pointer_id)
    return false;
  return false;
}


}  // gfx::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::gfx::mojom::blink::DelegatedInkPoint::DataView,
                                         ::gfx::mojom::blink::DelegatedInkPointPtr> {
  static bool IsNull(const ::gfx::mojom::blink::DelegatedInkPointPtr& input) { return !input; }
  static void SetToNull(::gfx::mojom::blink::DelegatedInkPointPtr* output) { output->reset(); }

  static const decltype(::gfx::mojom::blink::DelegatedInkPoint::point)& point(
      const ::gfx::mojom::blink::DelegatedInkPointPtr& input) {
    return input->point;
  }

  static const decltype(::gfx::mojom::blink::DelegatedInkPoint::timestamp)& timestamp(
      const ::gfx::mojom::blink::DelegatedInkPointPtr& input) {
    return input->timestamp;
  }

  static decltype(::gfx::mojom::blink::DelegatedInkPoint::pointer_id) pointer_id(
      const ::gfx::mojom::blink::DelegatedInkPointPtr& input) {
    return input->pointer_id;
  }

  static bool Read(::gfx::mojom::blink::DelegatedInkPoint::DataView input, ::gfx::mojom::blink::DelegatedInkPointPtr* output);
};

}  // namespace mojo

#endif  // UI_GFX_MOJOM_DELEGATED_INK_POINT_MOJOM_BLINK_H_