// ui/gfx/mojom/ca_layer_params.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_GFX_MOJOM_CA_LAYER_PARAMS_MOJOM_SEND_VALIDATION_H_
#define UI_GFX_MOJOM_CA_LAYER_PARAMS_MOJOM_SEND_VALIDATION_H_

#include "ui/gfx/mojom/ca_layer_params.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"

#include "ui/gfx/mojom/ca_layer_params.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::CALayerParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::gfx::mojom::CALayerParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::gfx::mojom::internal::CALayerParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->is_empty = Traits::is_empty(input);

      decltype(Traits::content(input)) in_content = Traits::content(input);
      mojo::internal::MessageFragment<decltype(fragment->content)>
          content_fragment(fragment.message());
      content_fragment.Claim(&fragment->content);
      
      mojo::internal::Serialize<::gfx::mojom::CALayerContentDataView, send_validation>(
        in_content,
        content_fragment,
        true);

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->content.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null content in CALayerParams struct");

      decltype(Traits::pixel_size(input)) in_pixel_size = Traits::pixel_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->pixel_size)::BaseType> pixel_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_pixel_size,
        pixel_size_fragment);

      fragment->pixel_size.Set(
          pixel_size_fragment.is_null() ? nullptr : pixel_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->pixel_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null pixel_size in CALayerParams struct");

      fragment->scale_factor = Traits::scale_factor(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::gfx::mojom::CALayerContentDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::gfx::mojom::CALayerContentDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::gfx::mojom::internal::CALayerContent_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::gfx::mojom::CALayerContentDataView::Tag::kCaContextId: {
    decltype(Traits::ca_context_id(input))
    in_ca_context_id = Traits::ca_context_id(input);
    fragment->data.f_ca_context_id = in_ca_context_id;
    break;
  }
  case ::gfx::mojom::CALayerContentDataView::Tag::kIoSurfaceMachPort: {
    decltype(Traits::io_surface_mach_port(input))
    in_io_surface_mach_port = Traits::io_surface_mach_port(input);
        
mojo::internal::Serialize<mojo::PlatformHandle, send_validation>(
  in_io_surface_mach_port,
  &fragment->data.f_io_surface_mach_port,
  &fragment.message());
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(!mojo::internal::IsHandleOrInterfaceValid(fragment->data.f_io_surface_mach_port)),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
  "null io_surface_mach_port in CALayerContent union");
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // UI_GFX_MOJOM_CA_LAYER_PARAMS_MOJOM_SEND_VALIDATION_H_