// ui/display/mojom/screen_info.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_SCREEN_INFO_MOJOM_SEND_VALIDATION_H_
#define UI_DISPLAY_MOJOM_SCREEN_INFO_MOJOM_SEND_VALIDATION_H_

#include "ui/display/mojom/screen_info.mojom-shared-internal.h"
#include "ui/display/mojom/screen_orientation.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"

#include "ui/display/mojom/screen_info.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::display::mojom::ScreenInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::ScreenInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::ScreenInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->device_scale_factor = Traits::device_scale_factor(input);

      decltype(Traits::display_color_spaces(input)) in_display_color_spaces = Traits::display_color_spaces(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->display_color_spaces)::BaseType> display_color_spaces_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::DisplayColorSpacesDataView, send_validation>(
        in_display_color_spaces,
        display_color_spaces_fragment);

      fragment->display_color_spaces.Set(
          display_color_spaces_fragment.is_null() ? nullptr : display_color_spaces_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->display_color_spaces.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null display_color_spaces in ScreenInfo struct");

      fragment->depth = Traits::depth(input);

      fragment->depth_per_component = Traits::depth_per_component(input);

      fragment->is_monochrome = Traits::is_monochrome(input);

      decltype(Traits::rect(input)) in_rect = Traits::rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->rect)::BaseType> rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_rect,
        rect_fragment);

      fragment->rect.Set(
          rect_fragment.is_null() ? nullptr : rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null rect in ScreenInfo struct");

      decltype(Traits::available_rect(input)) in_available_rect = Traits::available_rect(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->available_rect)::BaseType> available_rect_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_available_rect,
        available_rect_fragment);

      fragment->available_rect.Set(
          available_rect_fragment.is_null() ? nullptr : available_rect_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->available_rect.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null available_rect in ScreenInfo struct");

      
      mojo::internal::Serialize<::display::mojom::ScreenOrientation>(
        Traits::orientation_type(input),
        &fragment->orientation_type);

      fragment->orientation_angle = Traits::orientation_angle(input);

      fragment->is_extended = Traits::is_extended(input);

      fragment->is_primary = Traits::is_primary(input);

      fragment->is_internal = Traits::is_internal(input);

      decltype(Traits::label(input)) in_label = Traits::label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->label)::BaseType> label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_label,
        label_fragment);

      fragment->label.Set(
          label_fragment.is_null() ? nullptr : label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in ScreenInfo struct");

      fragment->display_id = Traits::display_id(input);
  }
};

}  // namespace mojo::internal

#endif  // UI_DISPLAY_MOJOM_SCREEN_INFO_MOJOM_SEND_VALIDATION_H_