// ui/display/mojom/screen_info.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_SCREEN_INFO_MOJOM_DATA_VIEW_H_
#define UI_DISPLAY_MOJOM_SCREEN_INFO_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/display/mojom/screen_info.mojom-shared-internal.h"
#include "ui/display/mojom/screen_orientation.mojom-shared.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"


namespace display::mojom {
class ScreenInfoDataView;



}  // display::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::display::mojom::ScreenInfoDataView> {
  using Data = ::display::mojom::internal::ScreenInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace display::mojom {


class ScreenInfoDataView {
 public:
  ScreenInfoDataView() = default;

  ScreenInfoDataView(
      internal::ScreenInfo_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  float device_scale_factor() const {
    return data_->device_scale_factor;
  }
  inline void GetDisplayColorSpacesDataView(
      ::gfx::mojom::DisplayColorSpacesDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDisplayColorSpaces(UserType* output) {
    
    auto* pointer = data_->display_color_spaces.Get();
    return mojo::internal::Deserialize<::gfx::mojom::DisplayColorSpacesDataView>(
        pointer, output, message_);
  }
  uint32_t depth() const {
    return data_->depth;
  }
  uint32_t depth_per_component() const {
    return data_->depth_per_component;
  }
  bool is_monochrome() const {
    return data_->is_monochrome;
  }
  inline void GetRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRect(UserType* output) {
    
    auto* pointer = data_->rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  inline void GetAvailableRectDataView(
      ::gfx::mojom::RectDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAvailableRect(UserType* output) {
    
    auto* pointer = data_->available_rect.Get();
    return mojo::internal::Deserialize<::gfx::mojom::RectDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  [[nodiscard]] bool ReadOrientationType(UserType* output) const {
    auto data_value = data_->orientation_type;
    return mojo::internal::Deserialize<::display::mojom::ScreenOrientation>(
        data_value, output);
  }
  ::display::mojom::ScreenOrientation orientation_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::display::mojom::ScreenOrientation>(data_->orientation_type));
  }
  uint16_t orientation_angle() const {
    return data_->orientation_angle;
  }
  bool is_extended() const {
    return data_->is_extended;
  }
  bool is_primary() const {
    return data_->is_primary;
  }
  bool is_internal() const {
    return data_->is_internal;
  }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int64_t display_id() const {
    return data_->display_id;
  }
 private:
  internal::ScreenInfo_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // display::mojom

#endif  // UI_DISPLAY_MOJOM_SCREEN_INFO_MOJOM_DATA_VIEW_H_