// ui/display/mojom/display_mode.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_MODE_MOJOM_BLINK_H_
#define UI_DISPLAY_MOJOM_DISPLAY_MODE_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/display/mojom/display_mode.mojom-features.h"  // IWYU pragma: export
#include "ui/display/mojom/display_mode.mojom-shared.h"  // IWYU pragma: export
#include "ui/display/mojom/display_mode.mojom-blink-forward.h"  // IWYU pragma: export
#include "ui/gfx/geometry/mojom/geometry.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace display::mojom::blink {








class  DisplayMode {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<DisplayMode, T>::value>;
  using DataView = DisplayModeDataView;
  using Data_ = internal::DisplayMode_Data;

  template <typename... Args>
  static DisplayModePtr New(Args&&... args) {
    return DisplayModePtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static DisplayModePtr From(const U& u) {
    return mojo::TypeConverter<DisplayModePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, DisplayMode>::Convert(*this);
  }


  DisplayMode();

  DisplayMode(
      const ::gfx::Size& size,
      bool is_interlaced,
      float refresh_rate,
      std::optional<float> vsync_rate_min);


  ~DisplayMode();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = DisplayModePtr>
  DisplayModePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, DisplayMode::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, DisplayMode::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, DisplayMode::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DisplayMode::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        DisplayMode::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        DisplayMode::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::DisplayMode_UnserializedMessageContext<
            UserType, DisplayMode::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<DisplayMode::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return DisplayMode::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::DisplayMode_UnserializedMessageContext<
            UserType, DisplayMode::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<DisplayMode::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::gfx::Size size;
  
  bool is_interlaced;
  
  float refresh_rate;
  
  std::optional<float> vsync_rate_min;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, DisplayMode::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, DisplayMode::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, DisplayMode::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, DisplayMode::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
DisplayModePtr DisplayMode::Clone() const {
  return New(
      mojo::Clone(size),
      mojo::Clone(is_interlaced),
      mojo::Clone(refresh_rate),
      mojo::Clone(vsync_rate_min)
  );
}

template <typename T, DisplayMode::EnableIfSame<T>*>
bool DisplayMode::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->size, other_struct.size))
    return false;
  if (!mojo::Equals(this->is_interlaced, other_struct.is_interlaced))
    return false;
  if (!mojo::Equals(this->refresh_rate, other_struct.refresh_rate))
    return false;
  if (!mojo::Equals(this->vsync_rate_min, other_struct.vsync_rate_min))
    return false;
  return true;
}

template <typename T, DisplayMode::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.size < rhs.size)
    return true;
  if (rhs.size < lhs.size)
    return false;
  if (lhs.is_interlaced < rhs.is_interlaced)
    return true;
  if (rhs.is_interlaced < lhs.is_interlaced)
    return false;
  if (lhs.refresh_rate < rhs.refresh_rate)
    return true;
  if (rhs.refresh_rate < lhs.refresh_rate)
    return false;
  if (lhs.vsync_rate_min < rhs.vsync_rate_min)
    return true;
  if (rhs.vsync_rate_min < lhs.vsync_rate_min)
    return false;
  return false;
}


}  // display::mojom::blink

namespace mojo {


template <>
struct  StructTraits<::display::mojom::blink::DisplayMode::DataView,
                                         ::display::mojom::blink::DisplayModePtr> {
  static bool IsNull(const ::display::mojom::blink::DisplayModePtr& input) { return !input; }
  static void SetToNull(::display::mojom::blink::DisplayModePtr* output) { output->reset(); }

  static const decltype(::display::mojom::blink::DisplayMode::size)& size(
      const ::display::mojom::blink::DisplayModePtr& input) {
    return input->size;
  }

  static decltype(::display::mojom::blink::DisplayMode::is_interlaced) is_interlaced(
      const ::display::mojom::blink::DisplayModePtr& input) {
    return input->is_interlaced;
  }

  static decltype(::display::mojom::blink::DisplayMode::refresh_rate) refresh_rate(
      const ::display::mojom::blink::DisplayModePtr& input) {
    return input->refresh_rate;
  }

  static decltype(::display::mojom::blink::DisplayMode::vsync_rate_min) vsync_rate_min(
      const ::display::mojom::blink::DisplayModePtr& input) {
    return input->vsync_rate_min;
  }

  static bool Read(::display::mojom::blink::DisplayMode::DataView input, ::display::mojom::blink::DisplayModePtr* output);
};

}  // namespace mojo

#endif  // UI_DISPLAY_MOJOM_DISPLAY_MODE_MOJOM_BLINK_H_