// ui/display/mojom/display_color_management.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'ui/display/mojom/display_color_management.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('display.mojom');
  var skcolorspace$ =
      mojo.internal.exposeNamespace('skia.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'skia/public/mojom/skcolorspace.mojom', '../../../skia/public/mojom/skcolorspace.mojom.js');
  }
  var gamma_ramp_rgb_entry$ =
      mojo.internal.exposeNamespace('display.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'ui/display/mojom/gamma_ramp_rgb_entry.mojom', 'gamma_ramp_rgb_entry.mojom.js');
  }



  function GammaCurve(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GammaCurve.prototype.initDefaults_ = function() {
    this.lut = null;
  };
  GammaCurve.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GammaCurve.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GammaCurve.lut
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(gamma_ramp_rgb_entry$.GammaRampRGBEntry), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GammaCurve.encodedSize = codec.kStructHeaderSize + 8;

  GammaCurve.decode = function(decoder) {
    var packed;
    var val = new GammaCurve();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.lut =
        decoder.decodeArrayPointer(new codec.PointerTo(gamma_ramp_rgb_entry$.GammaRampRGBEntry));
    return val;
  };

  GammaCurve.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GammaCurve.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(gamma_ramp_rgb_entry$.GammaRampRGBEntry), val.lut);
  };
  function ColorCalibration(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ColorCalibration.prototype.initDefaults_ = function() {
    this.srgbToLinear = null;
    this.srgbToDeviceMatrix = null;
    this.linearToDevice = null;
  };
  ColorCalibration.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ColorCalibration.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ColorCalibration.srgbToLinear
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, GammaCurve, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ColorCalibration.srgbToDeviceMatrix
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, skcolorspace$.SkcmsMatrix3x3, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ColorCalibration.linearToDevice
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, GammaCurve, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ColorCalibration.encodedSize = codec.kStructHeaderSize + 24;

  ColorCalibration.decode = function(decoder) {
    var packed;
    var val = new ColorCalibration();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.srgbToLinear =
        decoder.decodeStructPointer(GammaCurve);
    val.srgbToDeviceMatrix =
        decoder.decodeStructPointer(skcolorspace$.SkcmsMatrix3x3);
    val.linearToDevice =
        decoder.decodeStructPointer(GammaCurve);
    return val;
  };

  ColorCalibration.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ColorCalibration.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(GammaCurve, val.srgbToLinear);
    encoder.encodeStructPointer(skcolorspace$.SkcmsMatrix3x3, val.srgbToDeviceMatrix);
    encoder.encodeStructPointer(GammaCurve, val.linearToDevice);
  };
  function ColorTemperatureAdjustment(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ColorTemperatureAdjustment.prototype.initDefaults_ = function() {
    this.srgbMatrix = null;
  };
  ColorTemperatureAdjustment.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ColorTemperatureAdjustment.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ColorTemperatureAdjustment.srgbMatrix
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, skcolorspace$.SkcmsMatrix3x3, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ColorTemperatureAdjustment.encodedSize = codec.kStructHeaderSize + 8;

  ColorTemperatureAdjustment.decode = function(decoder) {
    var packed;
    var val = new ColorTemperatureAdjustment();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.srgbMatrix =
        decoder.decodeStructPointer(skcolorspace$.SkcmsMatrix3x3);
    return val;
  };

  ColorTemperatureAdjustment.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ColorTemperatureAdjustment.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(skcolorspace$.SkcmsMatrix3x3, val.srgbMatrix);
  };
  function GammaAdjustment(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  GammaAdjustment.prototype.initDefaults_ = function() {
    this.curve = null;
  };
  GammaAdjustment.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  GammaAdjustment.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate GammaAdjustment.curve
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, GammaCurve, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  GammaAdjustment.encodedSize = codec.kStructHeaderSize + 8;

  GammaAdjustment.decode = function(decoder) {
    var packed;
    var val = new GammaAdjustment();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.curve =
        decoder.decodeStructPointer(GammaCurve);
    return val;
  };

  GammaAdjustment.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(GammaAdjustment.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(GammaCurve, val.curve);
  };
  exports.GammaCurve = GammaCurve;
  exports.ColorCalibration = ColorCalibration;
  exports.ColorTemperatureAdjustment = ColorTemperatureAdjustment;
  exports.GammaAdjustment = GammaAdjustment;
})();