// ui/display/mojom/display_color_management.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_COLOR_MANAGEMENT_MOJOM_DATA_VIEW_H_
#define UI_DISPLAY_MOJOM_DISPLAY_COLOR_MANAGEMENT_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "ui/display/mojom/display_color_management.mojom-shared-internal.h"
#include "skia/public/mojom/skcolorspace.mojom-shared.h"
#include "ui/display/mojom/gamma_ramp_rgb_entry.mojom-shared.h"


namespace display::mojom {
class GammaCurveDataView;

class ColorCalibrationDataView;

class ColorTemperatureAdjustmentDataView;

class GammaAdjustmentDataView;



}  // display::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::display::mojom::GammaCurveDataView> {
  using Data = ::display::mojom::internal::GammaCurve_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::display::mojom::ColorCalibrationDataView> {
  using Data = ::display::mojom::internal::ColorCalibration_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::display::mojom::ColorTemperatureAdjustmentDataView> {
  using Data = ::display::mojom::internal::ColorTemperatureAdjustment_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::display::mojom::GammaAdjustmentDataView> {
  using Data = ::display::mojom::internal::GammaAdjustment_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace display::mojom {


class GammaCurveDataView {
 public:
  GammaCurveDataView() = default;

  GammaCurveDataView(
      internal::GammaCurve_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLutDataView(
      mojo::ArrayDataView<::display::mojom::GammaRampRGBEntryDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLut(UserType* output) {
    
    auto* pointer = data_->lut.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::display::mojom::GammaRampRGBEntryDataView>>(
        pointer, output, message_);
  }
 private:
  internal::GammaCurve_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ColorCalibrationDataView {
 public:
  ColorCalibrationDataView() = default;

  ColorCalibrationDataView(
      internal::ColorCalibration_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSrgbToLinearDataView(
      GammaCurveDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrgbToLinear(UserType* output) {
    
    auto* pointer = data_->srgb_to_linear.Get();
    return mojo::internal::Deserialize<::display::mojom::GammaCurveDataView>(
        pointer, output, message_);
  }
  inline void GetSrgbToDeviceMatrixDataView(
      ::skia::mojom::SkcmsMatrix3x3DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrgbToDeviceMatrix(UserType* output) {
    
    auto* pointer = data_->srgb_to_device_matrix.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkcmsMatrix3x3DataView>(
        pointer, output, message_);
  }
  inline void GetLinearToDeviceDataView(
      GammaCurveDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLinearToDevice(UserType* output) {
    
    auto* pointer = data_->linear_to_device.Get();
    return mojo::internal::Deserialize<::display::mojom::GammaCurveDataView>(
        pointer, output, message_);
  }
 private:
  internal::ColorCalibration_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class ColorTemperatureAdjustmentDataView {
 public:
  ColorTemperatureAdjustmentDataView() = default;

  ColorTemperatureAdjustmentDataView(
      internal::ColorTemperatureAdjustment_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSrgbMatrixDataView(
      ::skia::mojom::SkcmsMatrix3x3DataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSrgbMatrix(UserType* output) {
    
    auto* pointer = data_->srgb_matrix.Get();
    return mojo::internal::Deserialize<::skia::mojom::SkcmsMatrix3x3DataView>(
        pointer, output, message_);
  }
 private:
  internal::ColorTemperatureAdjustment_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class GammaAdjustmentDataView {
 public:
  GammaAdjustmentDataView() = default;

  GammaAdjustmentDataView(
      internal::GammaAdjustment_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCurveDataView(
      GammaCurveDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCurve(UserType* output) {
    
    auto* pointer = data_->curve.Get();
    return mojo::internal::Deserialize<::display::mojom::GammaCurveDataView>(
        pointer, output, message_);
  }
 private:
  internal::GammaAdjustment_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // display::mojom

#endif  // UI_DISPLAY_MOJOM_DISPLAY_COLOR_MANAGEMENT_MOJOM_DATA_VIEW_H_