// ui/display/mojom/display.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_DISPLAY_MOJOM_DISPLAY_MOJOM_SEND_VALIDATION_H_
#define UI_DISPLAY_MOJOM_DISPLAY_MOJOM_SEND_VALIDATION_H_

#include "ui/display/mojom/display.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"
#include "ui/gfx/mojom/display_color_spaces.mojom-shared.h"

#include "ui/display/mojom/display.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::display::mojom::Rotation, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::display::mojom::TouchSupport, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::display::mojom::AccelerometerSupport, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::display::mojom::DisplayDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::display::mojom::DisplayDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::display::mojom::internal::Display_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->id = Traits::id(input);

      decltype(Traits::bounds(input)) in_bounds = Traits::bounds(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->bounds)::BaseType> bounds_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_bounds,
        bounds_fragment);

      fragment->bounds.Set(
          bounds_fragment.is_null() ? nullptr : bounds_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->bounds.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null bounds in Display struct");

      decltype(Traits::size_in_pixels(input)) in_size_in_pixels = Traits::size_in_pixels(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->size_in_pixels)::BaseType> size_in_pixels_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_size_in_pixels,
        size_in_pixels_fragment);

      fragment->size_in_pixels.Set(
          size_in_pixels_fragment.is_null() ? nullptr : size_in_pixels_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->size_in_pixels.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null size_in_pixels in Display struct");

      decltype(Traits::native_origin(input)) in_native_origin = Traits::native_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->native_origin)::BaseType> native_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::PointDataView, send_validation>(
        in_native_origin,
        native_origin_fragment);

      fragment->native_origin.Set(
          native_origin_fragment.is_null() ? nullptr : native_origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->native_origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null native_origin in Display struct");

      decltype(Traits::work_area(input)) in_work_area = Traits::work_area(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->work_area)::BaseType> work_area_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::RectDataView, send_validation>(
        in_work_area,
        work_area_fragment);

      fragment->work_area.Set(
          work_area_fragment.is_null() ? nullptr : work_area_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->work_area.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null work_area in Display struct");

      fragment->device_scale_factor = Traits::device_scale_factor(input);

      
      mojo::internal::Serialize<::display::mojom::Rotation>(
        Traits::rotation(input),
        &fragment->rotation);

      
      mojo::internal::Serialize<::display::mojom::TouchSupport>(
        Traits::touch_support(input),
        &fragment->touch_support);

      
      mojo::internal::Serialize<::display::mojom::AccelerometerSupport>(
        Traits::accelerometer_support(input),
        &fragment->accelerometer_support);

      decltype(Traits::maximum_cursor_size(input)) in_maximum_cursor_size = Traits::maximum_cursor_size(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->maximum_cursor_size)::BaseType> maximum_cursor_size_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::SizeDataView, send_validation>(
        in_maximum_cursor_size,
        maximum_cursor_size_fragment);

      fragment->maximum_cursor_size.Set(
          maximum_cursor_size_fragment.is_null() ? nullptr : maximum_cursor_size_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->maximum_cursor_size.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null maximum_cursor_size in Display struct");

      decltype(Traits::color_spaces(input)) in_color_spaces = Traits::color_spaces(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->color_spaces)::BaseType> color_spaces_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::gfx::mojom::DisplayColorSpacesDataView, send_validation>(
        in_color_spaces,
        color_spaces_fragment);

      fragment->color_spaces.Set(
          color_spaces_fragment.is_null() ? nullptr : color_spaces_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->color_spaces.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null color_spaces in Display struct");

      fragment->color_depth = Traits::color_depth(input);

      fragment->depth_per_component = Traits::depth_per_component(input);

      fragment->is_monochrome = Traits::is_monochrome(input);

      fragment->display_frequency = Traits::display_frequency(input);

      decltype(Traits::label(input)) in_label = Traits::label(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->label)::BaseType> label_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_label,
        label_fragment);

      fragment->label.Set(
          label_fragment.is_null() ? nullptr : label_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->label.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null label in Display struct");
  }
};

}  // namespace mojo::internal

#endif  // UI_DISPLAY_MOJOM_DISPLAY_MOJOM_SEND_VALIDATION_H_