// ui/base/ime/mojom/text_input_state.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/base/ime/mojom/text_input_state.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/base/ime/mojom/text_input_state.mojom-params-data.h"
#include "ui/base/ime/mojom/text_input_state.mojom-shared-message-ids.h"

#include "ui/base/ime/mojom/text_input_state.mojom-blink-import-headers.h"
#include "ui/base/ime/mojom/text_input_state.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace ui::mojom::blink {
ImeTextSpanInfo::ImeTextSpanInfo()
    : span(),
      bounds() {}

ImeTextSpanInfo::ImeTextSpanInfo(
    const ::ui::ImeTextSpan& span_in,
    const ::gfx::Rect& bounds_in)
    : span(std::move(span_in)),
      bounds(std::move(bounds_in)) {}

ImeTextSpanInfo::~ImeTextSpanInfo() = default;

void ImeTextSpanInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "span"), this->span,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::ui::ImeTextSpan&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bounds"), this->bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Rect&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool ImeTextSpanInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
TextInputState::TextInputState()
    : node_id(0),
      type(mojo::internal::ConvertEnumValue<::ui::mojom::blink::TextInputType, ::ui::TextInputType>(::ui::mojom::blink::TextInputType::NONE)),
      mode(mojo::internal::ConvertEnumValue<::ui::mojom::blink::TextInputMode, ::ui::TextInputMode>(::ui::mojom::blink::TextInputMode::kDefault)),
      action(mojo::internal::ConvertEnumValue<::ui::mojom::blink::TextInputAction, ::ui::TextInputAction>(::ui::mojom::blink::TextInputAction::kDefault)),
      flags(),
      value(),
      selection(),
      composition(),
      can_compose_inline(true),
      show_ime_if_needed(),
      always_hide_ime(),
      reply_to_request(),
      edit_context_control_bounds(),
      edit_context_selection_bounds(),
      vk_policy(::ui::mojom::blink::VirtualKeyboardPolicy::AUTO),
      last_vk_visibility_request(::ui::mojom::blink::VirtualKeyboardVisibilityRequest::NONE),
      ime_text_spans_info() {}

TextInputState::TextInputState(
    int32_t node_id_in,
    ::ui::TextInputType type_in,
    ::ui::TextInputMode mode_in,
    ::ui::TextInputAction action_in,
    uint32_t flags_in,
    const ::blink::String& value_in,
    const ::gfx::Range& selection_in,
    const std::optional<::gfx::Range>& composition_in,
    bool can_compose_inline_in,
    bool show_ime_if_needed_in,
    bool always_hide_ime_in,
    bool reply_to_request_in,
    const std::optional<::gfx::Rect>& edit_context_control_bounds_in,
    const std::optional<::gfx::Rect>& edit_context_selection_bounds_in,
    ::ui::mojom::blink::VirtualKeyboardPolicy vk_policy_in,
    ::ui::mojom::blink::VirtualKeyboardVisibilityRequest last_vk_visibility_request_in,
    ::blink::Vector<ImeTextSpanInfoPtr> ime_text_spans_info_in)
    : node_id(std::move(node_id_in)),
      type(std::move(type_in)),
      mode(std::move(mode_in)),
      action(std::move(action_in)),
      flags(std::move(flags_in)),
      value(std::move(value_in)),
      selection(std::move(selection_in)),
      composition(std::move(composition_in)),
      can_compose_inline(std::move(can_compose_inline_in)),
      show_ime_if_needed(std::move(show_ime_if_needed_in)),
      always_hide_ime(std::move(always_hide_ime_in)),
      reply_to_request(std::move(reply_to_request_in)),
      edit_context_control_bounds(std::move(edit_context_control_bounds_in)),
      edit_context_selection_bounds(std::move(edit_context_selection_bounds_in)),
      vk_policy(std::move(vk_policy_in)),
      last_vk_visibility_request(std::move(last_vk_visibility_request_in)),
      ime_text_spans_info(std::move(ime_text_spans_info_in)) {}

TextInputState::~TextInputState() = default;

void TextInputState::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "node_id"), this->node_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "type"), this->type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::TextInputType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "mode"), this->mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::TextInputMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "action"), this->action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::TextInputAction>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "flags"), this->flags,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "value"), this->value,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "selection"), this->selection,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::gfx::Range&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "composition"), this->composition,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Range>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "can_compose_inline"), this->can_compose_inline,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "show_ime_if_needed"), this->show_ime_if_needed,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "always_hide_ime"), this->always_hide_ime,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "reply_to_request"), this->reply_to_request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "edit_context_control_bounds"), this->edit_context_control_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "edit_context_selection_bounds"), this->edit_context_selection_bounds,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::gfx::Rect>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vk_policy"), this->vk_policy,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::mojom::blink::VirtualKeyboardPolicy>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "last_vk_visibility_request"), this->last_vk_visibility_request,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::mojom::blink::VirtualKeyboardVisibilityRequest>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "ime_text_spans_info"), this->ime_text_spans_info,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<ImeTextSpanInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool TextInputState::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // ui::mojom::blink


namespace mojo {


// static
bool StructTraits<::ui::mojom::blink::ImeTextSpanInfo::DataView, ::ui::mojom::blink::ImeTextSpanInfoPtr>::Read(
    ::ui::mojom::blink::ImeTextSpanInfo::DataView input,
    ::ui::mojom::blink::ImeTextSpanInfoPtr* output) {
  bool success = true;
  ::ui::mojom::blink::ImeTextSpanInfoPtr result(::ui::mojom::blink::ImeTextSpanInfo::New());
  
      if (success && !input.ReadSpan(&result->span))
        success = false;
      if (success && !input.ReadBounds(&result->bounds))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::ui::mojom::blink::TextInputState::DataView, ::ui::mojom::blink::TextInputStatePtr>::Read(
    ::ui::mojom::blink::TextInputState::DataView input,
    ::ui::mojom::blink::TextInputStatePtr* output) {
  bool success = true;
  ::ui::mojom::blink::TextInputStatePtr result(::ui::mojom::blink::TextInputState::New());
  
      if (success)
        result->node_id = input.node_id();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadMode(&result->mode))
        success = false;
      if (success && !input.ReadAction(&result->action))
        success = false;
      if (success)
        result->flags = input.flags();
      if (success && !input.ReadValue(&result->value))
        success = false;
      if (success && !input.ReadSelection(&result->selection))
        success = false;
      if (success && !input.ReadComposition(&result->composition))
        success = false;
      if (success)
        result->can_compose_inline = input.can_compose_inline();
      if (success)
        result->show_ime_if_needed = input.show_ime_if_needed();
      if (success)
        result->always_hide_ime = input.always_hide_ime();
      if (success)
        result->reply_to_request = input.reply_to_request();
      if (success && !input.ReadEditContextControlBounds(&result->edit_context_control_bounds))
        success = false;
      if (success && !input.ReadEditContextSelectionBounds(&result->edit_context_selection_bounds))
        success = false;
      if (success && !input.ReadVkPolicy(&result->vk_policy))
        success = false;
      if (success && !input.ReadLastVkVisibilityRequest(&result->last_vk_visibility_request))
        success = false;
      if (success && !input.ReadImeTextSpansInfo(&result->ime_text_spans_info))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ui::mojom::blink {




}  // ui::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif