// ui/base/accelerators/mojom/accelerator.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_ACCELERATORS_MOJOM_ACCELERATOR_MOJOM_H_
#define UI_BASE_ACCELERATORS_MOJOM_ACCELERATOR_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/base/accelerators/mojom/accelerator.mojom-features.h"  // IWYU pragma: export
#include "ui/base/accelerators/mojom/accelerator.mojom-shared.h"  // IWYU pragma: export
#include "ui/base/accelerators/mojom/accelerator.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/time.mojom.h"
#include "ui/events/mojom/event_constants.mojom-forward.h"
#include "ui/events/mojom/keyboard_codes.mojom-forward.h"
#include <string>
#include <vector>




#include "ui/base/accelerators/mojom/accelerator_mojom_traits.h"




namespace ui::mojom {








class  Accelerator {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<Accelerator, T>::value>;
  using DataView = AcceleratorDataView;
  using Data_ = internal::Accelerator_Data;

  template <typename... Args>
  static AcceleratorPtr New(Args&&... args) {
    return AcceleratorPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static AcceleratorPtr From(const U& u) {
    return mojo::TypeConverter<AcceleratorPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, Accelerator>::Convert(*this);
  }


  Accelerator();

  Accelerator(
      int32_t key_code,
      ::ui::Accelerator::KeyState key_state,
      int32_t modifiers,
      ::base::TimeTicks time_stamp);


  ~Accelerator();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = AcceleratorPtr>
  AcceleratorPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, Accelerator::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, Accelerator::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, Accelerator::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Accelerator::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        Accelerator::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        Accelerator::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::Accelerator_UnserializedMessageContext<
            UserType, Accelerator::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<Accelerator::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return Accelerator::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::Accelerator_UnserializedMessageContext<
            UserType, Accelerator::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<Accelerator::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  int32_t key_code;
  
  ::ui::Accelerator::KeyState key_state;
  
  int32_t modifiers;
  
  ::base::TimeTicks time_stamp;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, Accelerator::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, Accelerator::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, Accelerator::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, Accelerator::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
AcceleratorPtr Accelerator::Clone() const {
  return New(
      mojo::Clone(key_code),
      mojo::Clone(key_state),
      mojo::Clone(modifiers),
      mojo::Clone(time_stamp)
  );
}

template <typename T, Accelerator::EnableIfSame<T>*>
bool Accelerator::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key_code, other_struct.key_code))
    return false;
  if (!mojo::Equals(this->key_state, other_struct.key_state))
    return false;
  if (!mojo::Equals(this->modifiers, other_struct.modifiers))
    return false;
  if (!mojo::Equals(this->time_stamp, other_struct.time_stamp))
    return false;
  return true;
}

template <typename T, Accelerator::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key_code < rhs.key_code)
    return true;
  if (rhs.key_code < lhs.key_code)
    return false;
  if (lhs.key_state < rhs.key_state)
    return true;
  if (rhs.key_state < lhs.key_state)
    return false;
  if (lhs.modifiers < rhs.modifiers)
    return true;
  if (rhs.modifiers < lhs.modifiers)
    return false;
  if (lhs.time_stamp < rhs.time_stamp)
    return true;
  if (rhs.time_stamp < lhs.time_stamp)
    return false;
  return false;
}


}  // ui::mojom

namespace mojo {


template <>
struct  StructTraits<::ui::mojom::Accelerator::DataView,
                                         ::ui::mojom::AcceleratorPtr> {
  static bool IsNull(const ::ui::mojom::AcceleratorPtr& input) { return !input; }
  static void SetToNull(::ui::mojom::AcceleratorPtr* output) { output->reset(); }

  static decltype(::ui::mojom::Accelerator::key_code) key_code(
      const ::ui::mojom::AcceleratorPtr& input) {
    return input->key_code;
  }

  static decltype(::ui::mojom::Accelerator::key_state) key_state(
      const ::ui::mojom::AcceleratorPtr& input) {
    return input->key_state;
  }

  static decltype(::ui::mojom::Accelerator::modifiers) modifiers(
      const ::ui::mojom::AcceleratorPtr& input) {
    return input->modifiers;
  }

  static const decltype(::ui::mojom::Accelerator::time_stamp)& time_stamp(
      const ::ui::mojom::AcceleratorPtr& input) {
    return input->time_stamp;
  }

  static bool Read(::ui::mojom::Accelerator::DataView input, ::ui::mojom::AcceleratorPtr* output);
};

}  // namespace mojo

#endif  // UI_BASE_ACCELERATORS_MOJOM_ACCELERATOR_MOJOM_H_