// ui/base/accelerators/mojom/accelerator.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_BASE_ACCELERATORS_MOJOM_ACCELERATOR_MOJOM_SEND_VALIDATION_H_
#define UI_BASE_ACCELERATORS_MOJOM_ACCELERATOR_MOJOM_SEND_VALIDATION_H_

#include "ui/base/accelerators/mojom/accelerator.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "ui/events/mojom/event_constants.mojom-shared.h"
#include "ui/events/mojom/keyboard_codes.mojom-shared.h"

#include "ui/base/accelerators/mojom/accelerator.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::ui::mojom::AcceleratorKeyState, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ui::mojom::AcceleratorDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ui::mojom::AcceleratorDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ui::mojom::internal::Accelerator_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->key_code = Traits::key_code(input);

      
      mojo::internal::Serialize<::ui::mojom::AcceleratorKeyState>(
        Traits::key_state(input),
        &fragment->key_state);

      fragment->modifiers = Traits::modifiers(input);

      decltype(Traits::time_stamp(input)) in_time_stamp = Traits::time_stamp(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->time_stamp)::BaseType> time_stamp_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView, send_validation>(
        in_time_stamp,
        time_stamp_fragment);

      fragment->time_stamp.Set(
          time_stamp_fragment.is_null() ? nullptr : time_stamp_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->time_stamp.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null time_stamp in Accelerator struct");
  }
};

}  // namespace mojo::internal

#endif  // UI_BASE_ACCELERATORS_MOJOM_ACCELERATOR_MOJOM_SEND_VALIDATION_H_