// ui/accessibility/mojom/ax_tree_update.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "ui/accessibility/mojom/ax_tree_update.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "ui/accessibility/mojom/ax_tree_update.mojom-params-data.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared-message-ids.h"

#include "ui/accessibility/mojom/ax_tree_update.mojom-import-headers.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-test-utils.h"


namespace ax::mojom {
AXTreeUpdate::AXTreeUpdate()
    : has_tree_data(),
      tree_data(),
      node_id_to_clear(),
      root_id(),
      nodes(),
      event_from(),
      event_from_action(),
      event_intents(),
      tree_checks() {}

AXTreeUpdate::AXTreeUpdate(
    bool has_tree_data_in,
    ::ui::AXTreeData tree_data_in,
    int32_t node_id_to_clear_in,
    int32_t root_id_in,
    std::vector<::ui::AXNodeData> nodes_in,
    ::ax::mojom::EventFrom event_from_in,
    ::ax::mojom::Action event_from_action_in,
    std::vector<::ui::AXEventIntent> event_intents_in,
    const std::optional<::ui::AXTreeChecks>& tree_checks_in)
    : has_tree_data(std::move(has_tree_data_in)),
      tree_data(std::move(tree_data_in)),
      node_id_to_clear(std::move(node_id_to_clear_in)),
      root_id(std::move(root_id_in)),
      nodes(std::move(nodes_in)),
      event_from(std::move(event_from_in)),
      event_from_action(std::move(event_from_action_in)),
      event_intents(std::move(event_intents_in)),
      tree_checks(std::move(tree_checks_in)) {}

AXTreeUpdate::~AXTreeUpdate() = default;

void AXTreeUpdate::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_tree_data"), this->has_tree_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tree_data"), this->tree_data,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ui::AXTreeData>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "node_id_to_clear"), this->node_id_to_clear,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "root_id"), this->root_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "nodes"), this->nodes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::ui::AXNodeData>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_from"), this->event_from,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::EventFrom>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_from_action"), this->event_from_action,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::ax::mojom::Action>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "event_intents"), this->event_intents,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::vector<::ui::AXEventIntent>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "tree_checks"), this->tree_checks,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::ui::AXTreeChecks>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool AXTreeUpdate::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // ax::mojom


namespace mojo {


// static
bool StructTraits<::ax::mojom::AXTreeUpdate::DataView, ::ax::mojom::AXTreeUpdatePtr>::Read(
    ::ax::mojom::AXTreeUpdate::DataView input,
    ::ax::mojom::AXTreeUpdatePtr* output) {
  bool success = true;
  ::ax::mojom::AXTreeUpdatePtr result(::ax::mojom::AXTreeUpdate::New());
  
      if (success)
        result->has_tree_data = input.has_tree_data();
      if (success && !input.ReadTreeData(&result->tree_data))
        success = false;
      if (success)
        result->node_id_to_clear = input.node_id_to_clear();
      if (success)
        result->root_id = input.root_id();
      if (success && !input.ReadNodes(&result->nodes))
        success = false;
      if (success && !input.ReadEventFrom(&result->event_from))
        success = false;
      if (success && !input.ReadEventFromAction(&result->event_from_action))
        success = false;
      if (success && !input.ReadEventIntents(&result->event_intents))
        success = false;
      if (success && !input.ReadTreeChecks(&result->tree_checks))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace ax::mojom {




}  // ax::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif