// ui/accessibility/mojom/ax_tree_id.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_SEND_VALIDATION_H_
#define UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_SEND_VALIDATION_H_

#include "ui/accessibility/mojom/ax_tree_id.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"

#include "ui/accessibility/mojom/ax_tree_id.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::ax::mojom::AXTreeIDDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::ax::mojom::AXTreeIDDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::ax::mojom::internal::AXTreeID_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::ax::mojom::AXTreeIDDataView::Tag::kUnknown: {
    decltype(Traits::unknown(input))
    in_unknown = Traits::unknown(input);
    fragment->data.f_unknown = in_unknown;
    break;
  }
  case ::ax::mojom::AXTreeIDDataView::Tag::kToken: {
    decltype(Traits::token(input))
    in_token = Traits::token(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_token)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
  in_token,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null token in AXTreeID union");
    fragment->data.f_token.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // UI_ACCESSIBILITY_MOJOM_AX_TREE_ID_MOJOM_SEND_VALIDATION_H_