// ui/accessibility/mojom/ax_node_data.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_SHARED_H_
#define UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "ui/accessibility/mojom/ax_node_data.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-shared.h"




#include "ui/accessibility/mojom/ax_node_data.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXBitsetDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXBitsetDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::AXBitsetData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->set_bits = Traits::set_bits(input);

    fragment->values = Traits::values(input);
  }

  static bool Deserialize(::ax::mojom::internal::AXBitsetData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXBitsetDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::ax::mojom::AXNodeDataDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXNodeDataDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::AXNodeData_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    fragment->id = Traits::id(input);

    
    mojo::internal::Serialize<::ax::mojom::Role>(
      Traits::role(input),
      &fragment->role);

    fragment->state = Traits::state(input);

    fragment->actions = Traits::actions(input);

    decltype(Traits::string_attributes(input)) in_string_attributes = Traits::string_attributes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->string_attributes)::BaseType>
        string_attributes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& string_attributes_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::ax::mojom::internal::StringAttribute_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::ax::mojom::StringAttribute, mojo::StringDataView>>(
      in_string_attributes,
      string_attributes_fragment,
      &string_attributes_validate_params);

    fragment->string_attributes.Set(
        string_attributes_fragment.is_null() ? nullptr : string_attributes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->string_attributes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null string_attributes in AXNodeData struct");

    decltype(Traits::int_attributes(input)) in_int_attributes = Traits::int_attributes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->int_attributes)::BaseType>
        int_attributes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& int_attributes_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::ax::mojom::internal::IntAttribute_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::ax::mojom::IntAttribute, int32_t>>(
      in_int_attributes,
      int_attributes_fragment,
      &int_attributes_validate_params);

    fragment->int_attributes.Set(
        int_attributes_fragment.is_null() ? nullptr : int_attributes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->int_attributes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null int_attributes in AXNodeData struct");

    decltype(Traits::float_attributes(input)) in_float_attributes = Traits::float_attributes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->float_attributes)::BaseType>
        float_attributes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& float_attributes_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::ax::mojom::internal::FloatAttribute_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::ax::mojom::FloatAttribute, float>>(
      in_float_attributes,
      float_attributes_fragment,
      &float_attributes_validate_params);

    fragment->float_attributes.Set(
        float_attributes_fragment.is_null() ? nullptr : float_attributes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->float_attributes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null float_attributes in AXNodeData struct");

    decltype(Traits::bool_attributes(input)) in_bool_attributes = Traits::bool_attributes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bool_attributes)::BaseType>
        bool_attributes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& bool_attributes_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::ax::mojom::internal::BoolAttribute_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, nullptr>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::ax::mojom::BoolAttribute, bool>>(
      in_bool_attributes,
      bool_attributes_fragment,
      &bool_attributes_validate_params);

    fragment->bool_attributes.Set(
        bool_attributes_fragment.is_null() ? nullptr : bool_attributes_fragment.data());

    decltype(Traits::intlist_attributes(input)) in_intlist_attributes = Traits::intlist_attributes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->intlist_attributes)::BaseType>
        intlist_attributes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& intlist_attributes_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::ax::mojom::internal::IntListAttribute_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::ax::mojom::IntListAttribute, mojo::ArrayDataView<int32_t>>>(
      in_intlist_attributes,
      intlist_attributes_fragment,
      &intlist_attributes_validate_params);

    fragment->intlist_attributes.Set(
        intlist_attributes_fragment.is_null() ? nullptr : intlist_attributes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->intlist_attributes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null intlist_attributes in AXNodeData struct");

    decltype(Traits::stringlist_attributes(input)) in_stringlist_attributes = Traits::stringlist_attributes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->stringlist_attributes)::BaseType>
        stringlist_attributes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& stringlist_attributes_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayOfEnumsValidator<0, false, ::ax::mojom::internal::StringListAttribute_Data::Validate>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<::ax::mojom::StringListAttribute, mojo::ArrayDataView<mojo::StringDataView>>>(
      in_stringlist_attributes,
      stringlist_attributes_fragment,
      &stringlist_attributes_validate_params);

    fragment->stringlist_attributes.Set(
        stringlist_attributes_fragment.is_null() ? nullptr : stringlist_attributes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->stringlist_attributes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null stringlist_attributes in AXNodeData struct");

    decltype(Traits::html_attributes(input)) in_html_attributes = Traits::html_attributes(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->html_attributes)::BaseType>
        html_attributes_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& html_attributes_validate_params =
        mojo::internal::GetMapValidator<*&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>(), *&mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>()>();
    
    mojo::internal::Serialize<mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>>(
      in_html_attributes,
      html_attributes_fragment,
      &html_attributes_validate_params);

    fragment->html_attributes.Set(
        html_attributes_fragment.is_null() ? nullptr : html_attributes_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->html_attributes.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null html_attributes in AXNodeData struct");

    decltype(Traits::child_ids(input)) in_child_ids = Traits::child_ids(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->child_ids)::BaseType>
        child_ids_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& child_ids_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<int32_t>>(
      in_child_ids,
      child_ids_fragment,
      &child_ids_validate_params);

    fragment->child_ids.Set(
        child_ids_fragment.is_null() ? nullptr : child_ids_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->child_ids.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null child_ids in AXNodeData struct");

    decltype(Traits::relative_bounds(input)) in_relative_bounds = Traits::relative_bounds(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->relative_bounds)::BaseType> relative_bounds_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::ax::mojom::AXRelativeBoundsDataView>(
      in_relative_bounds,
      relative_bounds_fragment);

    fragment->relative_bounds.Set(
        relative_bounds_fragment.is_null() ? nullptr : relative_bounds_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->relative_bounds.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null relative_bounds in AXNodeData struct");

    decltype(Traits::bool_attributes_data(input)) in_bool_attributes_data = Traits::bool_attributes_data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->bool_attributes_data)::BaseType> bool_attributes_data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::ax::mojom::AXBitsetDataDataView>(
      in_bool_attributes_data,
      bool_attributes_data_fragment);

    fragment->bool_attributes_data.Set(
        bool_attributes_data_fragment.is_null() ? nullptr : bool_attributes_data_fragment.data());
  }

  static bool Deserialize(::ax::mojom::internal::AXNodeData_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::ax::mojom::AXNodeDataDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace ax::mojom {



inline void AXNodeDataDataView::GetStringAttributesDataView(
    mojo::MapDataView<::ax::mojom::StringAttribute, mojo::StringDataView>* output) {
  auto pointer = data_->string_attributes.Get();
  *output = mojo::MapDataView<::ax::mojom::StringAttribute, mojo::StringDataView>(pointer, message_);
}
inline void AXNodeDataDataView::GetIntAttributesDataView(
    mojo::MapDataView<::ax::mojom::IntAttribute, int32_t>* output) {
  auto pointer = data_->int_attributes.Get();
  *output = mojo::MapDataView<::ax::mojom::IntAttribute, int32_t>(pointer, message_);
}
inline void AXNodeDataDataView::GetFloatAttributesDataView(
    mojo::MapDataView<::ax::mojom::FloatAttribute, float>* output) {
  auto pointer = data_->float_attributes.Get();
  *output = mojo::MapDataView<::ax::mojom::FloatAttribute, float>(pointer, message_);
}
inline void AXNodeDataDataView::GetBoolAttributesDataView(
    mojo::MapDataView<::ax::mojom::BoolAttribute, bool>* output) {
  auto pointer = data_->bool_attributes.Get();
  *output = mojo::MapDataView<::ax::mojom::BoolAttribute, bool>(pointer, message_);
}
inline void AXNodeDataDataView::GetIntlistAttributesDataView(
    mojo::MapDataView<::ax::mojom::IntListAttribute, mojo::ArrayDataView<int32_t>>* output) {
  auto pointer = data_->intlist_attributes.Get();
  *output = mojo::MapDataView<::ax::mojom::IntListAttribute, mojo::ArrayDataView<int32_t>>(pointer, message_);
}
inline void AXNodeDataDataView::GetStringlistAttributesDataView(
    mojo::MapDataView<::ax::mojom::StringListAttribute, mojo::ArrayDataView<mojo::StringDataView>>* output) {
  auto pointer = data_->stringlist_attributes.Get();
  *output = mojo::MapDataView<::ax::mojom::StringListAttribute, mojo::ArrayDataView<mojo::StringDataView>>(pointer, message_);
}
inline void AXNodeDataDataView::GetHtmlAttributesDataView(
    mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>* output) {
  auto pointer = data_->html_attributes.Get();
  *output = mojo::MapDataView<mojo::StringDataView, mojo::StringDataView>(pointer, message_);
}
inline void AXNodeDataDataView::GetChildIdsDataView(
    mojo::ArrayDataView<int32_t>* output) {
  auto pointer = data_->child_ids.Get();
  *output = mojo::ArrayDataView<int32_t>(pointer, message_);
}
inline void AXNodeDataDataView::GetRelativeBoundsDataView(
    ::ax::mojom::AXRelativeBoundsDataView* output) {
  auto pointer = data_->relative_bounds.Get();
  *output = ::ax::mojom::AXRelativeBoundsDataView(pointer, message_);
}
inline void AXNodeDataDataView::GetBoolAttributesDataDataView(
    AXBitsetDataDataView* output) {
  auto pointer = data_->bool_attributes_data.Get();
  *output = AXBitsetDataDataView(pointer, message_);
}



}  // ax::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // UI_ACCESSIBILITY_MOJOM_AX_NODE_DATA_MOJOM_SHARED_H_