// ui/accessibility/mojom/ax_event.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_ACCESSIBILITY_MOJOM_AX_EVENT_MOJOM_SEND_VALIDATION_H_
#define UI_ACCESSIBILITY_MOJOM_AX_EVENT_MOJOM_SEND_VALIDATION_H_

#include "ui/accessibility/mojom/ax_event.mojom-shared-internal.h"
#include "ui/accessibility/ax_enums.mojom-shared.h"
#include "ui/accessibility/mojom/ax_event_intent.mojom-shared.h"

#include "ui/accessibility/mojom/ax_event.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::ax::mojom::AXEventDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::ax::mojom::AXEventDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::ax::mojom::internal::AXEvent_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::ax::mojom::Event>(
        Traits::event_type(input),
        &fragment->event_type);

      fragment->id = Traits::id(input);

      
      mojo::internal::Serialize<::ax::mojom::EventFrom>(
        Traits::event_from(input),
        &fragment->event_from);

      
      mojo::internal::Serialize<::ax::mojom::Action>(
        Traits::event_from_action(input),
        &fragment->event_from_action);

      decltype(Traits::event_intents(input)) in_event_intents = Traits::event_intents(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->event_intents)::BaseType>
          event_intents_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& event_intents_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::ax::mojom::EventIntentDataView>, send_validation>(
        in_event_intents,
        event_intents_fragment,
        &event_intents_validate_params);

      fragment->event_intents.Set(
          event_intents_fragment.is_null() ? nullptr : event_intents_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->event_intents.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null event_intents in AXEvent struct");

      fragment->action_request_id = Traits::action_request_id(input);
  }
};

}  // namespace mojo::internal

#endif  // UI_ACCESSIBILITY_MOJOM_AX_EVENT_MOJOM_SEND_VALIDATION_H_