import './CodeBlock.js';
import './MarkdownImage.js';
import './MarkdownLink.js';
import type * as Marked from '../../../third_party/marked/marked.js';
import * as Lit from '../../lit/lit.js';
import type * as Codeblock from './CodeBlock.js';
export interface MarkdownViewData {
    tokens: Marked.Marked.Token[];
    renderer?: MarkdownLitRenderer;
    animationEnabled?: boolean;
}
export type CodeTokenWithCitation = Marked.Marked.Tokens.Generic & {
    citations: Codeblock.Citation[];
};
export declare class MarkdownView extends HTMLElement {
    #private;
    set data(data: MarkdownViewData);
}
declare global {
    interface HTMLElementTagNameMap {
        'devtools-markdown-view': MarkdownView;
    }
}
/**
 * Default renderer is used for the IssuesPanel and allows only well-known images and links to be embedded.
 */
export declare class MarkdownLitRenderer {
    #private;
    addCustomClasses(customClasses: Record<Marked.Marked.Token['type'], string>): void;
    removeCustomClasses(customClasses: Record<Marked.Marked.Token['type'], string>): void;
    protected customClassMapForToken(type: Marked.Marked.Token['type']): Lit.Directive.DirectiveResult;
    renderChildTokens(token: Marked.Marked.Token): Lit.TemplateResult[];
    /**
     * Unescape will get rid of the escaping done by Marked to avoid double escaping due to escaping it also with lit.
     * Table taken from: front_end/third_party/marked/package/src/helpers.js
     */
    unescape(text: string): string;
    renderText(token: Marked.Marked.Token): Lit.TemplateResult;
    renderHeading(heading: Marked.Marked.Tokens.Heading): Lit.TemplateResult;
    renderCodeBlock(token: Marked.Marked.Tokens.Code): Lit.TemplateResult;
    templateForToken(token: Marked.Marked.MarkedToken): Lit.TemplateResult | null;
    renderToken(token: Marked.Marked.Token): Lit.TemplateResult;
}
/**
 * Renderer used in Console Insights and AI assistance for the text generated by an LLM.
 */
export declare class MarkdownInsightRenderer extends MarkdownLitRenderer {
    #private;
    constructor(citationClickHandler?: (index: number) => void);
    renderToken(token: Marked.Marked.Token): Lit.TemplateResult;
    sanitizeUrl(maybeUrl: string): string | null;
    detectCodeLanguage(token: Marked.Marked.Tokens.Code): string;
    templateForToken(token: Marked.Marked.Token): Lit.TemplateResult | null;
}
