import * as Trace from '../../models/trace/trace.js';
import * as PerfUI from '../../ui/legacy/components/perf_ui/perf_ui.js';
/**
 * This class can take in a thread that has been generated by the
 * RendererHandler and apply certain actions to it in order to modify what is
 * shown to the user. These actions can be automatically applied by DevTools or
 * applied by the user.
 *
 * Once actions are applied, the invisibleEntries() method will return the
 * entries that are invisible, and this is the list of entries that should be
 * removed before rendering the resulting thread on the timeline.
 */
export declare class EntriesFilter {
    #private;
    constructor(parsedTrace: Trace.TraceModel.ParsedTrace);
    /**
     * Checks which actions can be applied on an entry. This allows us to only show possible actions in the Context Menu.
     * For example, if an entry has no children, COLLAPSE_FUNCTION will not change the FlameChart, therefore there is no need to show this action as an option.
     */
    findPossibleActions(entry: Trace.Types.Events.Event): PerfUI.FlameChart.PossibleFilterActions;
    /**
     * Returns the amount of entry descendants that belong to the hidden entries array.
     * */
    findHiddenDescendantsAmount(entry: Trace.Types.Events.Event): number;
    /**
     * Returns the set of entries that are invisible given the set of applied actions.
     */
    invisibleEntries(): Trace.Types.Events.Event[];
    /**
     * Sets hidden and expandable. Called when a trace with modifications is loaded and some entries are set as hidden and expandable.
     * Both arrays are set together because if there is one, the other must be present too.
     */
    setHiddenAndExpandableEntries(invisibleEntries: Trace.Types.Events.Event[], expandableEntries: Trace.Types.Events.Event[]): void;
    entryIsInvisible(entry: Trace.Types.Events.Event): boolean;
    /**
     * Returns the array of entries that have a sign indicating that entries below are hidden,
     * and so that they can be "expanded" to reveal their hidden children.
     */
    expandableEntries(): Trace.Types.Events.Event[];
    /**
     * Applies an action to hide entries or removes entries
     * from hidden entries array depending on the action.
     */
    applyFilterAction(action: PerfUI.FlameChart.UserFilterAction): Trace.Types.Events.Event[];
    firstVisibleParentEntryForEntry(entry: Trace.Types.Events.Event): Trace.Types.Events.Event | null;
    /**
     * If an entry was selected from a link instead of clicking on it,
     * it might be in the invisible entries array.
     * If it is, reveal it by resetting clidren the closest expandable entry,
     */
    revealEntry(entry: Trace.Types.Events.Event): void;
    isEntryExpandable(event: Trace.Types.Events.Event): boolean;
}
