// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// File is generated by scripts/build/code_generator_frontend.py
/**
 * @typedef {{
 *  registerCommand: function(
 *      string&any,
 *      !Array.<!{
 *          name: string,
 *          type: string,
 *          optional: boolean,
 *          description: string,
 *          typeRef: string | null
 *      }>,
 *      !Array.<string>,
 *      string
 *  ): void,
 *  registerEnum: function(string&any, !Object<string, string>): void,
 *  registerEvent: function(string&any, !Array<string>): void,
 *  registerType: function(
 *      string&any,
 *      !Array.<!{
 *          name: string,
 *          type: string,
 *          optional: boolean,
 *          description: string,
 *          typeRef: string | null
 *      }>
 *  ): void,
 * }}
 */
// @ts-expect-error typedef
export let InspectorBackendAPI;
/**
 * @param {!InspectorBackendAPI} inspectorBackend
 */
export function registerCommands(inspectorBackend) {
    // Accessibility.
    inspectorBackend.registerEnum("Accessibility.AXValueType", { Boolean: "boolean", Tristate: "tristate", BooleanOrUndefined: "booleanOrUndefined", Idref: "idref", IdrefList: "idrefList", Integer: "integer", Node: "node", NodeList: "nodeList", Number: "number", String: "string", ComputedString: "computedString", Token: "token", TokenList: "tokenList", DomRelation: "domRelation", Role: "role", InternalRole: "internalRole", ValueUndefined: "valueUndefined" });
    inspectorBackend.registerEnum("Accessibility.AXValueSourceType", { Attribute: "attribute", Implicit: "implicit", Style: "style", Contents: "contents", Placeholder: "placeholder", RelatedElement: "relatedElement" });
    inspectorBackend.registerEnum("Accessibility.AXValueNativeSourceType", { Description: "description", Figcaption: "figcaption", Label: "label", Labelfor: "labelfor", Labelwrapped: "labelwrapped", Legend: "legend", Rubyannotation: "rubyannotation", Tablecaption: "tablecaption", Title: "title", Other: "other" });
    inspectorBackend.registerEnum("Accessibility.AXPropertyName", { Actions: "actions", Busy: "busy", Disabled: "disabled", Editable: "editable", Focusable: "focusable", Focused: "focused", Hidden: "hidden", HiddenRoot: "hiddenRoot", Invalid: "invalid", Keyshortcuts: "keyshortcuts", Settable: "settable", Roledescription: "roledescription", Live: "live", Atomic: "atomic", Relevant: "relevant", Root: "root", Autocomplete: "autocomplete", HasPopup: "hasPopup", Level: "level", Multiselectable: "multiselectable", Orientation: "orientation", Multiline: "multiline", Readonly: "readonly", Required: "required", Valuemin: "valuemin", Valuemax: "valuemax", Valuetext: "valuetext", Checked: "checked", Expanded: "expanded", Modal: "modal", Pressed: "pressed", Selected: "selected", Activedescendant: "activedescendant", Controls: "controls", Describedby: "describedby", Details: "details", Errormessage: "errormessage", Flowto: "flowto", Labelledby: "labelledby", Owns: "owns", Url: "url", ActiveFullscreenElement: "activeFullscreenElement", ActiveModalDialog: "activeModalDialog", ActiveAriaModalDialog: "activeAriaModalDialog", AriaHiddenElement: "ariaHiddenElement", AriaHiddenSubtree: "ariaHiddenSubtree", EmptyAlt: "emptyAlt", EmptyText: "emptyText", InertElement: "inertElement", InertSubtree: "inertSubtree", LabelContainer: "labelContainer", LabelFor: "labelFor", NotRendered: "notRendered", NotVisible: "notVisible", PresentationalRole: "presentationalRole", ProbablyPresentational: "probablyPresentational", InactiveCarouselTabContent: "inactiveCarouselTabContent", Uninteresting: "uninteresting" });
    inspectorBackend.registerEvent("Accessibility.loadComplete", ["root"]);
    inspectorBackend.registerEvent("Accessibility.nodesUpdated", ["nodes"]);
    inspectorBackend.registerCommand("Accessibility.disable", [], [], "Disables the accessibility domain.");
    inspectorBackend.registerCommand("Accessibility.enable", [], [], "Enables the accessibility domain which causes `AXNodeId`s to remain consistent between method calls. This turns on accessibility for the page, which can impact performance until accessibility is disabled.");
    inspectorBackend.registerCommand("Accessibility.getPartialAXTree", [{ "name": "nodeId", "type": "number", "optional": true, "description": "Identifier of the node to get the partial accessibility tree for.", "typeRef": "DOM.NodeId" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "Identifier of the backend node to get the partial accessibility tree for.", "typeRef": "DOM.BackendNodeId" }, { "name": "objectId", "type": "string", "optional": true, "description": "JavaScript object id of the node wrapper to get the partial accessibility tree for.", "typeRef": "Runtime.RemoteObjectId" }, { "name": "fetchRelatives", "type": "boolean", "optional": true, "description": "Whether to fetch this node's ancestors, siblings and children. Defaults to true.", "typeRef": null }], ["nodes"], "Fetches the accessibility node and partial accessibility tree for this DOM node, if it exists.");
    inspectorBackend.registerCommand("Accessibility.getFullAXTree", [{ "name": "depth", "type": "number", "optional": true, "description": "The maximum depth at which descendants of the root node should be retrieved. If omitted, the full tree is returned.", "typeRef": null }, { "name": "frameId", "type": "string", "optional": true, "description": "The frame for whose document the AX tree should be retrieved. If omitted, the root frame is used.", "typeRef": "Page.FrameId" }], ["nodes"], "Fetches the entire accessibility tree for the root Document");
    inspectorBackend.registerCommand("Accessibility.getRootAXNode", [{ "name": "frameId", "type": "string", "optional": true, "description": "The frame in whose document the node resides. If omitted, the root frame is used.", "typeRef": "Page.FrameId" }], ["node"], "Fetches the root node. Requires `enable()` to have been called previously.");
    inspectorBackend.registerCommand("Accessibility.getAXNodeAndAncestors", [{ "name": "nodeId", "type": "number", "optional": true, "description": "Identifier of the node to get.", "typeRef": "DOM.NodeId" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "Identifier of the backend node to get.", "typeRef": "DOM.BackendNodeId" }, { "name": "objectId", "type": "string", "optional": true, "description": "JavaScript object id of the node wrapper to get.", "typeRef": "Runtime.RemoteObjectId" }], ["nodes"], "Fetches a node and all ancestors up to and including the root. Requires `enable()` to have been called previously.");
    inspectorBackend.registerCommand("Accessibility.getChildAXNodes", [{ "name": "id", "type": "string", "optional": false, "description": "", "typeRef": "Accessibility.AXNodeId" }, { "name": "frameId", "type": "string", "optional": true, "description": "The frame in whose document the node resides. If omitted, the root frame is used.", "typeRef": "Page.FrameId" }], ["nodes"], "Fetches a particular accessibility node by AXNodeId. Requires `enable()` to have been called previously.");
    inspectorBackend.registerCommand("Accessibility.queryAXTree", [{ "name": "nodeId", "type": "number", "optional": true, "description": "Identifier of the node for the root to query.", "typeRef": "DOM.NodeId" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "Identifier of the backend node for the root to query.", "typeRef": "DOM.BackendNodeId" }, { "name": "objectId", "type": "string", "optional": true, "description": "JavaScript object id of the node wrapper for the root to query.", "typeRef": "Runtime.RemoteObjectId" }, { "name": "accessibleName", "type": "string", "optional": true, "description": "Find nodes with this computed name.", "typeRef": null }, { "name": "role", "type": "string", "optional": true, "description": "Find nodes with this computed role.", "typeRef": null }], ["nodes"], "Query a DOM node's accessibility subtree for accessible name and role. This command computes the name and role for all nodes in the subtree, including those that are ignored for accessibility, and returns those that match the specified name and role. If no DOM node is specified, or the DOM node does not exist, the command returns an error. If neither `accessibleName` or `role` is specified, it returns all the accessibility nodes in the subtree.");
    inspectorBackend.registerType("Accessibility.AXValueSource", [{ "name": "type", "type": "string", "optional": false, "description": "What type of source this is.", "typeRef": "Accessibility.AXValueSourceType" }, { "name": "value", "type": "object", "optional": true, "description": "The value of this property source.", "typeRef": "Accessibility.AXValue" }, { "name": "attribute", "type": "string", "optional": true, "description": "The name of the relevant attribute, if any.", "typeRef": null }, { "name": "attributeValue", "type": "object", "optional": true, "description": "The value of the relevant attribute, if any.", "typeRef": "Accessibility.AXValue" }, { "name": "superseded", "type": "boolean", "optional": true, "description": "Whether this source is superseded by a higher priority source.", "typeRef": null }, { "name": "nativeSource", "type": "string", "optional": true, "description": "The native markup source for this value, e.g. a `<label>` element.", "typeRef": "Accessibility.AXValueNativeSourceType" }, { "name": "nativeSourceValue", "type": "object", "optional": true, "description": "The value, such as a node or node list, of the native source.", "typeRef": "Accessibility.AXValue" }, { "name": "invalid", "type": "boolean", "optional": true, "description": "Whether the value for this property is invalid.", "typeRef": null }, { "name": "invalidReason", "type": "string", "optional": true, "description": "Reason for the value being invalid, if it is.", "typeRef": null }]);
    inspectorBackend.registerType("Accessibility.AXRelatedNode", [{ "name": "backendDOMNodeId", "type": "number", "optional": false, "description": "The BackendNodeId of the related DOM node.", "typeRef": "DOM.BackendNodeId" }, { "name": "idref", "type": "string", "optional": true, "description": "The IDRef value provided, if any.", "typeRef": null }, { "name": "text", "type": "string", "optional": true, "description": "The text alternative of this node in the current context.", "typeRef": null }]);
    inspectorBackend.registerType("Accessibility.AXProperty", [{ "name": "name", "type": "string", "optional": false, "description": "The name of this property.", "typeRef": "Accessibility.AXPropertyName" }, { "name": "value", "type": "object", "optional": false, "description": "The value of this property.", "typeRef": "Accessibility.AXValue" }]);
    inspectorBackend.registerType("Accessibility.AXValue", [{ "name": "type", "type": "string", "optional": false, "description": "The type of this value.", "typeRef": "Accessibility.AXValueType" }, { "name": "value", "type": "any", "optional": true, "description": "The computed value of this property.", "typeRef": null }, { "name": "relatedNodes", "type": "array", "optional": true, "description": "One or more related nodes, if applicable.", "typeRef": "Accessibility.AXRelatedNode" }, { "name": "sources", "type": "array", "optional": true, "description": "The sources which contributed to the computation of this property.", "typeRef": "Accessibility.AXValueSource" }]);
    inspectorBackend.registerType("Accessibility.AXNode", [{ "name": "nodeId", "type": "string", "optional": false, "description": "Unique identifier for this node.", "typeRef": "Accessibility.AXNodeId" }, { "name": "ignored", "type": "boolean", "optional": false, "description": "Whether this node is ignored for accessibility", "typeRef": null }, { "name": "ignoredReasons", "type": "array", "optional": true, "description": "Collection of reasons why this node is hidden.", "typeRef": "Accessibility.AXProperty" }, { "name": "role", "type": "object", "optional": true, "description": "This `Node`'s role, whether explicit or implicit.", "typeRef": "Accessibility.AXValue" }, { "name": "chromeRole", "type": "object", "optional": true, "description": "This `Node`'s Chrome raw role.", "typeRef": "Accessibility.AXValue" }, { "name": "name", "type": "object", "optional": true, "description": "The accessible name for this `Node`.", "typeRef": "Accessibility.AXValue" }, { "name": "description", "type": "object", "optional": true, "description": "The accessible description for this `Node`.", "typeRef": "Accessibility.AXValue" }, { "name": "value", "type": "object", "optional": true, "description": "The value for this `Node`.", "typeRef": "Accessibility.AXValue" }, { "name": "properties", "type": "array", "optional": true, "description": "All other properties", "typeRef": "Accessibility.AXProperty" }, { "name": "parentId", "type": "string", "optional": true, "description": "ID for this node's parent.", "typeRef": "Accessibility.AXNodeId" }, { "name": "childIds", "type": "array", "optional": true, "description": "IDs for each of this node's child nodes.", "typeRef": "Accessibility.AXNodeId" }, { "name": "backendDOMNodeId", "type": "number", "optional": true, "description": "The backend ID for the associated DOM node, if any.", "typeRef": "DOM.BackendNodeId" }, { "name": "frameId", "type": "string", "optional": true, "description": "The frame ID for the frame associated with this nodes document.", "typeRef": "Page.FrameId" }]);
    // Animation.
    inspectorBackend.registerEnum("Animation.AnimationType", { CSSTransition: "CSSTransition", CSSAnimation: "CSSAnimation", WebAnimation: "WebAnimation" });
    inspectorBackend.registerEvent("Animation.animationCanceled", ["id"]);
    inspectorBackend.registerEvent("Animation.animationCreated", ["id"]);
    inspectorBackend.registerEvent("Animation.animationStarted", ["animation"]);
    inspectorBackend.registerEvent("Animation.animationUpdated", ["animation"]);
    inspectorBackend.registerCommand("Animation.disable", [], [], "Disables animation domain notifications.");
    inspectorBackend.registerCommand("Animation.enable", [], [], "Enables animation domain notifications.");
    inspectorBackend.registerCommand("Animation.getCurrentTime", [{ "name": "id", "type": "string", "optional": false, "description": "Id of animation.", "typeRef": null }], ["currentTime"], "Returns the current time of the an animation.");
    inspectorBackend.registerCommand("Animation.getPlaybackRate", [], ["playbackRate"], "Gets the playback rate of the document timeline.");
    inspectorBackend.registerCommand("Animation.releaseAnimations", [{ "name": "animations", "type": "array", "optional": false, "description": "List of animation ids to seek.", "typeRef": "string" }], [], "Releases a set of animations to no longer be manipulated.");
    inspectorBackend.registerCommand("Animation.resolveAnimation", [{ "name": "animationId", "type": "string", "optional": false, "description": "Animation id.", "typeRef": null }], ["remoteObject"], "Gets the remote object of the Animation.");
    inspectorBackend.registerCommand("Animation.seekAnimations", [{ "name": "animations", "type": "array", "optional": false, "description": "List of animation ids to seek.", "typeRef": "string" }, { "name": "currentTime", "type": "number", "optional": false, "description": "Set the current time of each animation.", "typeRef": null }], [], "Seek a set of animations to a particular time within each animation.");
    inspectorBackend.registerCommand("Animation.setPaused", [{ "name": "animations", "type": "array", "optional": false, "description": "Animations to set the pause state of.", "typeRef": "string" }, { "name": "paused", "type": "boolean", "optional": false, "description": "Paused state to set to.", "typeRef": null }], [], "Sets the paused state of a set of animations.");
    inspectorBackend.registerCommand("Animation.setPlaybackRate", [{ "name": "playbackRate", "type": "number", "optional": false, "description": "Playback rate for animations on page", "typeRef": null }], [], "Sets the playback rate of the document timeline.");
    inspectorBackend.registerCommand("Animation.setTiming", [{ "name": "animationId", "type": "string", "optional": false, "description": "Animation id.", "typeRef": null }, { "name": "duration", "type": "number", "optional": false, "description": "Duration of the animation.", "typeRef": null }, { "name": "delay", "type": "number", "optional": false, "description": "Delay of the animation.", "typeRef": null }], [], "Sets the timing of an animation node.");
    inspectorBackend.registerType("Animation.Animation", [{ "name": "id", "type": "string", "optional": false, "description": "`Animation`'s id.", "typeRef": null }, { "name": "name", "type": "string", "optional": false, "description": "`Animation`'s name.", "typeRef": null }, { "name": "pausedState", "type": "boolean", "optional": false, "description": "`Animation`'s internal paused state.", "typeRef": null }, { "name": "playState", "type": "string", "optional": false, "description": "`Animation`'s play state.", "typeRef": null }, { "name": "playbackRate", "type": "number", "optional": false, "description": "`Animation`'s playback rate.", "typeRef": null }, { "name": "startTime", "type": "number", "optional": false, "description": "`Animation`'s start time. Milliseconds for time based animations and percentage [0 - 100] for scroll driven animations (i.e. when viewOrScrollTimeline exists).", "typeRef": null }, { "name": "currentTime", "type": "number", "optional": false, "description": "`Animation`'s current time.", "typeRef": null }, { "name": "type", "type": "string", "optional": false, "description": "Animation type of `Animation`.", "typeRef": null }, { "name": "source", "type": "object", "optional": true, "description": "`Animation`'s source animation node.", "typeRef": "Animation.AnimationEffect" }, { "name": "cssId", "type": "string", "optional": true, "description": "A unique ID for `Animation` representing the sources that triggered this CSS animation/transition.", "typeRef": null }, { "name": "viewOrScrollTimeline", "type": "object", "optional": true, "description": "View or scroll timeline", "typeRef": "Animation.ViewOrScrollTimeline" }]);
    inspectorBackend.registerType("Animation.ViewOrScrollTimeline", [{ "name": "sourceNodeId", "type": "number", "optional": true, "description": "Scroll container node", "typeRef": "DOM.BackendNodeId" }, { "name": "startOffset", "type": "number", "optional": true, "description": "Represents the starting scroll position of the timeline as a length offset in pixels from scroll origin.", "typeRef": null }, { "name": "endOffset", "type": "number", "optional": true, "description": "Represents the ending scroll position of the timeline as a length offset in pixels from scroll origin.", "typeRef": null }, { "name": "subjectNodeId", "type": "number", "optional": true, "description": "The element whose principal box's visibility in the scrollport defined the progress of the timeline. Does not exist for animations with ScrollTimeline", "typeRef": "DOM.BackendNodeId" }, { "name": "axis", "type": "string", "optional": false, "description": "Orientation of the scroll", "typeRef": "DOM.ScrollOrientation" }]);
    inspectorBackend.registerType("Animation.AnimationEffect", [{ "name": "delay", "type": "number", "optional": false, "description": "`AnimationEffect`'s delay.", "typeRef": null }, { "name": "endDelay", "type": "number", "optional": false, "description": "`AnimationEffect`'s end delay.", "typeRef": null }, { "name": "iterationStart", "type": "number", "optional": false, "description": "`AnimationEffect`'s iteration start.", "typeRef": null }, { "name": "iterations", "type": "number", "optional": false, "description": "`AnimationEffect`'s iterations.", "typeRef": null }, { "name": "duration", "type": "number", "optional": false, "description": "`AnimationEffect`'s iteration duration. Milliseconds for time based animations and percentage [0 - 100] for scroll driven animations (i.e. when viewOrScrollTimeline exists).", "typeRef": null }, { "name": "direction", "type": "string", "optional": false, "description": "`AnimationEffect`'s playback direction.", "typeRef": null }, { "name": "fill", "type": "string", "optional": false, "description": "`AnimationEffect`'s fill mode.", "typeRef": null }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "`AnimationEffect`'s target node.", "typeRef": "DOM.BackendNodeId" }, { "name": "keyframesRule", "type": "object", "optional": true, "description": "`AnimationEffect`'s keyframes.", "typeRef": "Animation.KeyframesRule" }, { "name": "easing", "type": "string", "optional": false, "description": "`AnimationEffect`'s timing function.", "typeRef": null }]);
    inspectorBackend.registerType("Animation.KeyframesRule", [{ "name": "name", "type": "string", "optional": true, "description": "CSS keyframed animation's name.", "typeRef": null }, { "name": "keyframes", "type": "array", "optional": false, "description": "List of animation keyframes.", "typeRef": "Animation.KeyframeStyle" }]);
    inspectorBackend.registerType("Animation.KeyframeStyle", [{ "name": "offset", "type": "string", "optional": false, "description": "Keyframe's time offset.", "typeRef": null }, { "name": "easing", "type": "string", "optional": false, "description": "`AnimationEffect`'s timing function.", "typeRef": null }]);
    // Audits.
    inspectorBackend.registerEnum("Audits.CookieExclusionReason", { ExcludeSameSiteUnspecifiedTreatedAsLax: "ExcludeSameSiteUnspecifiedTreatedAsLax", ExcludeSameSiteNoneInsecure: "ExcludeSameSiteNoneInsecure", ExcludeSameSiteLax: "ExcludeSameSiteLax", ExcludeSameSiteStrict: "ExcludeSameSiteStrict", ExcludeInvalidSameParty: "ExcludeInvalidSameParty", ExcludeSamePartyCrossPartyContext: "ExcludeSamePartyCrossPartyContext", ExcludeDomainNonASCII: "ExcludeDomainNonASCII", ExcludeThirdPartyCookieBlockedInFirstPartySet: "ExcludeThirdPartyCookieBlockedInFirstPartySet", ExcludeThirdPartyPhaseout: "ExcludeThirdPartyPhaseout", ExcludePortMismatch: "ExcludePortMismatch", ExcludeSchemeMismatch: "ExcludeSchemeMismatch" });
    inspectorBackend.registerEnum("Audits.CookieWarningReason", { WarnSameSiteUnspecifiedCrossSiteContext: "WarnSameSiteUnspecifiedCrossSiteContext", WarnSameSiteNoneInsecure: "WarnSameSiteNoneInsecure", WarnSameSiteUnspecifiedLaxAllowUnsafe: "WarnSameSiteUnspecifiedLaxAllowUnsafe", WarnSameSiteStrictLaxDowngradeStrict: "WarnSameSiteStrictLaxDowngradeStrict", WarnSameSiteStrictCrossDowngradeStrict: "WarnSameSiteStrictCrossDowngradeStrict", WarnSameSiteStrictCrossDowngradeLax: "WarnSameSiteStrictCrossDowngradeLax", WarnSameSiteLaxCrossDowngradeStrict: "WarnSameSiteLaxCrossDowngradeStrict", WarnSameSiteLaxCrossDowngradeLax: "WarnSameSiteLaxCrossDowngradeLax", WarnAttributeValueExceedsMaxSize: "WarnAttributeValueExceedsMaxSize", WarnDomainNonASCII: "WarnDomainNonASCII", WarnThirdPartyPhaseout: "WarnThirdPartyPhaseout", WarnCrossSiteRedirectDowngradeChangesInclusion: "WarnCrossSiteRedirectDowngradeChangesInclusion", WarnDeprecationTrialMetadata: "WarnDeprecationTrialMetadata", WarnThirdPartyCookieHeuristic: "WarnThirdPartyCookieHeuristic" });
    inspectorBackend.registerEnum("Audits.CookieOperation", { SetCookie: "SetCookie", ReadCookie: "ReadCookie" });
    inspectorBackend.registerEnum("Audits.InsightType", { GitHubResource: "GitHubResource", GracePeriod: "GracePeriod", Heuristics: "Heuristics" });
    inspectorBackend.registerEnum("Audits.MixedContentResolutionStatus", { MixedContentBlocked: "MixedContentBlocked", MixedContentAutomaticallyUpgraded: "MixedContentAutomaticallyUpgraded", MixedContentWarning: "MixedContentWarning" });
    inspectorBackend.registerEnum("Audits.MixedContentResourceType", { AttributionSrc: "AttributionSrc", Audio: "Audio", Beacon: "Beacon", CSPReport: "CSPReport", Download: "Download", EventSource: "EventSource", Favicon: "Favicon", Font: "Font", Form: "Form", Frame: "Frame", Image: "Image", Import: "Import", JSON: "JSON", Manifest: "Manifest", Ping: "Ping", PluginData: "PluginData", PluginResource: "PluginResource", Prefetch: "Prefetch", Resource: "Resource", Script: "Script", ServiceWorker: "ServiceWorker", SharedWorker: "SharedWorker", SpeculationRules: "SpeculationRules", Stylesheet: "Stylesheet", Track: "Track", Video: "Video", Worker: "Worker", XMLHttpRequest: "XMLHttpRequest", XSLT: "XSLT" });
    inspectorBackend.registerEnum("Audits.BlockedByResponseReason", { CoepFrameResourceNeedsCoepHeader: "CoepFrameResourceNeedsCoepHeader", CoopSandboxedIFrameCannotNavigateToCoopPage: "CoopSandboxedIFrameCannotNavigateToCoopPage", CorpNotSameOrigin: "CorpNotSameOrigin", CorpNotSameOriginAfterDefaultedToSameOriginByCoep: "CorpNotSameOriginAfterDefaultedToSameOriginByCoep", CorpNotSameOriginAfterDefaultedToSameOriginByDip: "CorpNotSameOriginAfterDefaultedToSameOriginByDip", CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip: "CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip", CorpNotSameSite: "CorpNotSameSite", SRIMessageSignatureMismatch: "SRIMessageSignatureMismatch" });
    inspectorBackend.registerEnum("Audits.HeavyAdResolutionStatus", { HeavyAdBlocked: "HeavyAdBlocked", HeavyAdWarning: "HeavyAdWarning" });
    inspectorBackend.registerEnum("Audits.HeavyAdReason", { NetworkTotalLimit: "NetworkTotalLimit", CpuTotalLimit: "CpuTotalLimit", CpuPeakLimit: "CpuPeakLimit" });
    inspectorBackend.registerEnum("Audits.ContentSecurityPolicyViolationType", { KInlineViolation: "kInlineViolation", KEvalViolation: "kEvalViolation", KURLViolation: "kURLViolation", KSRIViolation: "kSRIViolation", KTrustedTypesSinkViolation: "kTrustedTypesSinkViolation", KTrustedTypesPolicyViolation: "kTrustedTypesPolicyViolation", KWasmEvalViolation: "kWasmEvalViolation" });
    inspectorBackend.registerEnum("Audits.SharedArrayBufferIssueType", { TransferIssue: "TransferIssue", CreationIssue: "CreationIssue" });
    inspectorBackend.registerEnum("Audits.AttributionReportingIssueType", { PermissionPolicyDisabled: "PermissionPolicyDisabled", UntrustworthyReportingOrigin: "UntrustworthyReportingOrigin", InsecureContext: "InsecureContext", InvalidHeader: "InvalidHeader", InvalidRegisterTriggerHeader: "InvalidRegisterTriggerHeader", SourceAndTriggerHeaders: "SourceAndTriggerHeaders", SourceIgnored: "SourceIgnored", TriggerIgnored: "TriggerIgnored", OsSourceIgnored: "OsSourceIgnored", OsTriggerIgnored: "OsTriggerIgnored", InvalidRegisterOsSourceHeader: "InvalidRegisterOsSourceHeader", InvalidRegisterOsTriggerHeader: "InvalidRegisterOsTriggerHeader", WebAndOsHeaders: "WebAndOsHeaders", NoWebOrOsSupport: "NoWebOrOsSupport", NavigationRegistrationWithoutTransientUserActivation: "NavigationRegistrationWithoutTransientUserActivation", InvalidInfoHeader: "InvalidInfoHeader", NoRegisterSourceHeader: "NoRegisterSourceHeader", NoRegisterTriggerHeader: "NoRegisterTriggerHeader", NoRegisterOsSourceHeader: "NoRegisterOsSourceHeader", NoRegisterOsTriggerHeader: "NoRegisterOsTriggerHeader", NavigationRegistrationUniqueScopeAlreadySet: "NavigationRegistrationUniqueScopeAlreadySet" });
    inspectorBackend.registerEnum("Audits.SharedDictionaryError", { UseErrorCrossOriginNoCorsRequest: "UseErrorCrossOriginNoCorsRequest", UseErrorDictionaryLoadFailure: "UseErrorDictionaryLoadFailure", UseErrorMatchingDictionaryNotUsed: "UseErrorMatchingDictionaryNotUsed", UseErrorUnexpectedContentDictionaryHeader: "UseErrorUnexpectedContentDictionaryHeader", WriteErrorCossOriginNoCorsRequest: "WriteErrorCossOriginNoCorsRequest", WriteErrorDisallowedBySettings: "WriteErrorDisallowedBySettings", WriteErrorExpiredResponse: "WriteErrorExpiredResponse", WriteErrorFeatureDisabled: "WriteErrorFeatureDisabled", WriteErrorInsufficientResources: "WriteErrorInsufficientResources", WriteErrorInvalidMatchField: "WriteErrorInvalidMatchField", WriteErrorInvalidStructuredHeader: "WriteErrorInvalidStructuredHeader", WriteErrorInvalidTTLField: "WriteErrorInvalidTTLField", WriteErrorNavigationRequest: "WriteErrorNavigationRequest", WriteErrorNoMatchField: "WriteErrorNoMatchField", WriteErrorNonIntegerTTLField: "WriteErrorNonIntegerTTLField", WriteErrorNonListMatchDestField: "WriteErrorNonListMatchDestField", WriteErrorNonSecureContext: "WriteErrorNonSecureContext", WriteErrorNonStringIdField: "WriteErrorNonStringIdField", WriteErrorNonStringInMatchDestList: "WriteErrorNonStringInMatchDestList", WriteErrorNonStringMatchField: "WriteErrorNonStringMatchField", WriteErrorNonTokenTypeField: "WriteErrorNonTokenTypeField", WriteErrorRequestAborted: "WriteErrorRequestAborted", WriteErrorShuttingDown: "WriteErrorShuttingDown", WriteErrorTooLongIdField: "WriteErrorTooLongIdField", WriteErrorUnsupportedType: "WriteErrorUnsupportedType" });
    inspectorBackend.registerEnum("Audits.SRIMessageSignatureError", { MissingSignatureHeader: "MissingSignatureHeader", MissingSignatureInputHeader: "MissingSignatureInputHeader", InvalidSignatureHeader: "InvalidSignatureHeader", InvalidSignatureInputHeader: "InvalidSignatureInputHeader", SignatureHeaderValueIsNotByteSequence: "SignatureHeaderValueIsNotByteSequence", SignatureHeaderValueIsParameterized: "SignatureHeaderValueIsParameterized", SignatureHeaderValueIsIncorrectLength: "SignatureHeaderValueIsIncorrectLength", SignatureInputHeaderMissingLabel: "SignatureInputHeaderMissingLabel", SignatureInputHeaderValueNotInnerList: "SignatureInputHeaderValueNotInnerList", SignatureInputHeaderValueMissingComponents: "SignatureInputHeaderValueMissingComponents", SignatureInputHeaderInvalidComponentType: "SignatureInputHeaderInvalidComponentType", SignatureInputHeaderInvalidComponentName: "SignatureInputHeaderInvalidComponentName", SignatureInputHeaderInvalidHeaderComponentParameter: "SignatureInputHeaderInvalidHeaderComponentParameter", SignatureInputHeaderInvalidDerivedComponentParameter: "SignatureInputHeaderInvalidDerivedComponentParameter", SignatureInputHeaderKeyIdLength: "SignatureInputHeaderKeyIdLength", SignatureInputHeaderInvalidParameter: "SignatureInputHeaderInvalidParameter", SignatureInputHeaderMissingRequiredParameters: "SignatureInputHeaderMissingRequiredParameters", ValidationFailedSignatureExpired: "ValidationFailedSignatureExpired", ValidationFailedInvalidLength: "ValidationFailedInvalidLength", ValidationFailedSignatureMismatch: "ValidationFailedSignatureMismatch", ValidationFailedIntegrityMismatch: "ValidationFailedIntegrityMismatch" });
    inspectorBackend.registerEnum("Audits.UnencodedDigestError", { MalformedDictionary: "MalformedDictionary", UnknownAlgorithm: "UnknownAlgorithm", IncorrectDigestType: "IncorrectDigestType", IncorrectDigestLength: "IncorrectDigestLength" });
    inspectorBackend.registerEnum("Audits.GenericIssueErrorType", { FormLabelForNameError: "FormLabelForNameError", FormDuplicateIdForInputError: "FormDuplicateIdForInputError", FormInputWithNoLabelError: "FormInputWithNoLabelError", FormAutocompleteAttributeEmptyError: "FormAutocompleteAttributeEmptyError", FormEmptyIdAndNameAttributesForInputError: "FormEmptyIdAndNameAttributesForInputError", FormAriaLabelledByToNonExistingId: "FormAriaLabelledByToNonExistingId", FormInputAssignedAutocompleteValueToIdOrNameAttributeError: "FormInputAssignedAutocompleteValueToIdOrNameAttributeError", FormLabelHasNeitherForNorNestedInput: "FormLabelHasNeitherForNorNestedInput", FormLabelForMatchesNonExistingIdError: "FormLabelForMatchesNonExistingIdError", FormInputHasWrongButWellIntendedAutocompleteValueError: "FormInputHasWrongButWellIntendedAutocompleteValueError", ResponseWasBlockedByORB: "ResponseWasBlockedByORB" });
    inspectorBackend.registerEnum("Audits.ClientHintIssueReason", { MetaTagAllowListInvalidOrigin: "MetaTagAllowListInvalidOrigin", MetaTagModifiedHTML: "MetaTagModifiedHTML" });
    inspectorBackend.registerEnum("Audits.FederatedAuthRequestIssueReason", { ShouldEmbargo: "ShouldEmbargo", TooManyRequests: "TooManyRequests", WellKnownHttpNotFound: "WellKnownHttpNotFound", WellKnownNoResponse: "WellKnownNoResponse", WellKnownInvalidResponse: "WellKnownInvalidResponse", WellKnownListEmpty: "WellKnownListEmpty", WellKnownInvalidContentType: "WellKnownInvalidContentType", ConfigNotInWellKnown: "ConfigNotInWellKnown", WellKnownTooBig: "WellKnownTooBig", ConfigHttpNotFound: "ConfigHttpNotFound", ConfigNoResponse: "ConfigNoResponse", ConfigInvalidResponse: "ConfigInvalidResponse", ConfigInvalidContentType: "ConfigInvalidContentType", ClientMetadataHttpNotFound: "ClientMetadataHttpNotFound", ClientMetadataNoResponse: "ClientMetadataNoResponse", ClientMetadataInvalidResponse: "ClientMetadataInvalidResponse", ClientMetadataInvalidContentType: "ClientMetadataInvalidContentType", IdpNotPotentiallyTrustworthy: "IdpNotPotentiallyTrustworthy", DisabledInSettings: "DisabledInSettings", DisabledInFlags: "DisabledInFlags", ErrorFetchingSignin: "ErrorFetchingSignin", InvalidSigninResponse: "InvalidSigninResponse", AccountsHttpNotFound: "AccountsHttpNotFound", AccountsNoResponse: "AccountsNoResponse", AccountsInvalidResponse: "AccountsInvalidResponse", AccountsListEmpty: "AccountsListEmpty", AccountsInvalidContentType: "AccountsInvalidContentType", IdTokenHttpNotFound: "IdTokenHttpNotFound", IdTokenNoResponse: "IdTokenNoResponse", IdTokenInvalidResponse: "IdTokenInvalidResponse", IdTokenIdpErrorResponse: "IdTokenIdpErrorResponse", IdTokenCrossSiteIdpErrorResponse: "IdTokenCrossSiteIdpErrorResponse", IdTokenInvalidRequest: "IdTokenInvalidRequest", IdTokenInvalidContentType: "IdTokenInvalidContentType", ErrorIdToken: "ErrorIdToken", Canceled: "Canceled", RpPageNotVisible: "RpPageNotVisible", SilentMediationFailure: "SilentMediationFailure", ThirdPartyCookiesBlocked: "ThirdPartyCookiesBlocked", NotSignedInWithIdp: "NotSignedInWithIdp", MissingTransientUserActivation: "MissingTransientUserActivation", ReplacedByActiveMode: "ReplacedByActiveMode", InvalidFieldsSpecified: "InvalidFieldsSpecified", RelyingPartyOriginIsOpaque: "RelyingPartyOriginIsOpaque", TypeNotMatching: "TypeNotMatching", UiDismissedNoEmbargo: "UiDismissedNoEmbargo", CorsError: "CorsError", SuppressedBySegmentationPlatform: "SuppressedBySegmentationPlatform" });
    inspectorBackend.registerEnum("Audits.FederatedAuthUserInfoRequestIssueReason", { NotSameOrigin: "NotSameOrigin", NotIframe: "NotIframe", NotPotentiallyTrustworthy: "NotPotentiallyTrustworthy", NoAPIPermission: "NoApiPermission", NotSignedInWithIdp: "NotSignedInWithIdp", NoAccountSharingPermission: "NoAccountSharingPermission", InvalidConfigOrWellKnown: "InvalidConfigOrWellKnown", InvalidAccountsResponse: "InvalidAccountsResponse", NoReturningUserFromFetchedAccounts: "NoReturningUserFromFetchedAccounts" });
    inspectorBackend.registerEnum("Audits.PartitioningBlobURLInfo", { BlockedCrossPartitionFetching: "BlockedCrossPartitionFetching", EnforceNoopenerForNavigation: "EnforceNoopenerForNavigation" });
    inspectorBackend.registerEnum("Audits.ElementAccessibilityIssueReason", { DisallowedSelectChild: "DisallowedSelectChild", DisallowedOptGroupChild: "DisallowedOptGroupChild", NonPhrasingContentOptionChild: "NonPhrasingContentOptionChild", InteractiveContentOptionChild: "InteractiveContentOptionChild", InteractiveContentLegendChild: "InteractiveContentLegendChild", InteractiveContentSummaryDescendant: "InteractiveContentSummaryDescendant" });
    inspectorBackend.registerEnum("Audits.StyleSheetLoadingIssueReason", { LateImportRule: "LateImportRule", RequestFailed: "RequestFailed" });
    inspectorBackend.registerEnum("Audits.PropertyRuleIssueReason", { InvalidSyntax: "InvalidSyntax", InvalidInitialValue: "InvalidInitialValue", InvalidInherits: "InvalidInherits", InvalidName: "InvalidName" });
    inspectorBackend.registerEnum("Audits.UserReidentificationIssueType", { BlockedFrameNavigation: "BlockedFrameNavigation", BlockedSubresource: "BlockedSubresource", NoisedCanvasReadback: "NoisedCanvasReadback" });
    inspectorBackend.registerEnum("Audits.InspectorIssueCode", { CookieIssue: "CookieIssue", MixedContentIssue: "MixedContentIssue", BlockedByResponseIssue: "BlockedByResponseIssue", HeavyAdIssue: "HeavyAdIssue", ContentSecurityPolicyIssue: "ContentSecurityPolicyIssue", SharedArrayBufferIssue: "SharedArrayBufferIssue", LowTextContrastIssue: "LowTextContrastIssue", CorsIssue: "CorsIssue", AttributionReportingIssue: "AttributionReportingIssue", QuirksModeIssue: "QuirksModeIssue", PartitioningBlobURLIssue: "PartitioningBlobURLIssue", NavigatorUserAgentIssue: "NavigatorUserAgentIssue", GenericIssue: "GenericIssue", DeprecationIssue: "DeprecationIssue", ClientHintIssue: "ClientHintIssue", FederatedAuthRequestIssue: "FederatedAuthRequestIssue", BounceTrackingIssue: "BounceTrackingIssue", CookieDeprecationMetadataIssue: "CookieDeprecationMetadataIssue", StylesheetLoadingIssue: "StylesheetLoadingIssue", FederatedAuthUserInfoRequestIssue: "FederatedAuthUserInfoRequestIssue", PropertyRuleIssue: "PropertyRuleIssue", SharedDictionaryIssue: "SharedDictionaryIssue", ElementAccessibilityIssue: "ElementAccessibilityIssue", SRIMessageSignatureIssue: "SRIMessageSignatureIssue", UnencodedDigestIssue: "UnencodedDigestIssue", UserReidentificationIssue: "UserReidentificationIssue" });
    inspectorBackend.registerEvent("Audits.issueAdded", ["issue"]);
    inspectorBackend.registerEnum("Audits.GetEncodedResponseRequestEncoding", { Webp: "webp", Jpeg: "jpeg", Png: "png" });
    inspectorBackend.registerCommand("Audits.getEncodedResponse", [{ "name": "requestId", "type": "string", "optional": false, "description": "Identifier of the network request to get content for.", "typeRef": "Network.RequestId" }, { "name": "encoding", "type": "string", "optional": false, "description": "The encoding to use.", "typeRef": "Audits.GetEncodedResponseRequestEncoding" }, { "name": "quality", "type": "number", "optional": true, "description": "The quality of the encoding (0-1). (defaults to 1)", "typeRef": null }, { "name": "sizeOnly", "type": "boolean", "optional": true, "description": "Whether to only return the size information (defaults to false).", "typeRef": null }], ["body", "originalSize", "encodedSize"], "Returns the response body and size if it were re-encoded with the specified settings. Only applies to images.");
    inspectorBackend.registerCommand("Audits.disable", [], [], "Disables issues domain, prevents further issues from being reported to the client.");
    inspectorBackend.registerCommand("Audits.enable", [], [], "Enables issues domain, sends the issues collected so far to the client by means of the `issueAdded` event.");
    inspectorBackend.registerCommand("Audits.checkContrast", [{ "name": "reportAAA", "type": "boolean", "optional": true, "description": "Whether to report WCAG AAA level issues. Default is false.", "typeRef": null }], [], "Runs the contrast check for the target page. Found issues are reported using Audits.issueAdded event.");
    inspectorBackend.registerCommand("Audits.checkFormsIssues", [], ["formIssues"], "Runs the form issues check for the target page. Found issues are reported using Audits.issueAdded event.");
    inspectorBackend.registerType("Audits.AffectedCookie", [{ "name": "name", "type": "string", "optional": false, "description": "The following three properties uniquely identify a cookie", "typeRef": null }, { "name": "path", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "domain", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Audits.AffectedRequest", [{ "name": "requestId", "type": "string", "optional": true, "description": "The unique request id.", "typeRef": "Network.RequestId" }, { "name": "url", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Audits.AffectedFrame", [{ "name": "frameId", "type": "string", "optional": false, "description": "", "typeRef": "Page.FrameId" }]);
    inspectorBackend.registerType("Audits.CookieIssueInsight", [{ "name": "type", "type": "string", "optional": false, "description": "", "typeRef": "Audits.InsightType" }, { "name": "tableEntryUrl", "type": "string", "optional": true, "description": "Link to table entry in third-party cookie migration readiness list.", "typeRef": null }]);
    inspectorBackend.registerType("Audits.CookieIssueDetails", [{ "name": "cookie", "type": "object", "optional": true, "description": "If AffectedCookie is not set then rawCookieLine contains the raw Set-Cookie header string. This hints at a problem where the cookie line is syntactically or semantically malformed in a way that no valid cookie could be created.", "typeRef": "Audits.AffectedCookie" }, { "name": "rawCookieLine", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "cookieWarningReasons", "type": "array", "optional": false, "description": "", "typeRef": "Audits.CookieWarningReason" }, { "name": "cookieExclusionReasons", "type": "array", "optional": false, "description": "", "typeRef": "Audits.CookieExclusionReason" }, { "name": "operation", "type": "string", "optional": false, "description": "Optionally identifies the site-for-cookies and the cookie url, which may be used by the front-end as additional context.", "typeRef": "Audits.CookieOperation" }, { "name": "siteForCookies", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "cookieUrl", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "request", "type": "object", "optional": true, "description": "", "typeRef": "Audits.AffectedRequest" }, { "name": "insight", "type": "object", "optional": true, "description": "The recommended solution to the issue.", "typeRef": "Audits.CookieIssueInsight" }]);
    inspectorBackend.registerType("Audits.MixedContentIssueDetails", [{ "name": "resourceType", "type": "string", "optional": true, "description": "The type of resource causing the mixed content issue (css, js, iframe, form,...). Marked as optional because it is mapped to from blink::mojom::RequestContextType, which will be replaced by network::mojom::RequestDestination", "typeRef": "Audits.MixedContentResourceType" }, { "name": "resolutionStatus", "type": "string", "optional": false, "description": "The way the mixed content issue is being resolved.", "typeRef": "Audits.MixedContentResolutionStatus" }, { "name": "insecureURL", "type": "string", "optional": false, "description": "The unsafe http url causing the mixed content issue.", "typeRef": null }, { "name": "mainResourceURL", "type": "string", "optional": false, "description": "The url responsible for the call to an unsafe url.", "typeRef": null }, { "name": "request", "type": "object", "optional": true, "description": "The mixed content request. Does not always exist (e.g. for unsafe form submission urls).", "typeRef": "Audits.AffectedRequest" }, { "name": "frame", "type": "object", "optional": true, "description": "Optional because not every mixed content issue is necessarily linked to a frame.", "typeRef": "Audits.AffectedFrame" }]);
    inspectorBackend.registerType("Audits.BlockedByResponseIssueDetails", [{ "name": "request", "type": "object", "optional": false, "description": "", "typeRef": "Audits.AffectedRequest" }, { "name": "parentFrame", "type": "object", "optional": true, "description": "", "typeRef": "Audits.AffectedFrame" }, { "name": "blockedFrame", "type": "object", "optional": true, "description": "", "typeRef": "Audits.AffectedFrame" }, { "name": "reason", "type": "string", "optional": false, "description": "", "typeRef": "Audits.BlockedByResponseReason" }]);
    inspectorBackend.registerType("Audits.HeavyAdIssueDetails", [{ "name": "resolution", "type": "string", "optional": false, "description": "The resolution status, either blocking the content or warning.", "typeRef": "Audits.HeavyAdResolutionStatus" }, { "name": "reason", "type": "string", "optional": false, "description": "The reason the ad was blocked, total network or cpu or peak cpu.", "typeRef": "Audits.HeavyAdReason" }, { "name": "frame", "type": "object", "optional": false, "description": "The frame that was blocked.", "typeRef": "Audits.AffectedFrame" }]);
    inspectorBackend.registerType("Audits.SourceCodeLocation", [{ "name": "scriptId", "type": "string", "optional": true, "description": "", "typeRef": "Runtime.ScriptId" }, { "name": "url", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "lineNumber", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "columnNumber", "type": "number", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Audits.ContentSecurityPolicyIssueDetails", [{ "name": "blockedURL", "type": "string", "optional": true, "description": "The url not included in allowed sources.", "typeRef": null }, { "name": "violatedDirective", "type": "string", "optional": false, "description": "Specific directive that is violated, causing the CSP issue.", "typeRef": null }, { "name": "isReportOnly", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "contentSecurityPolicyViolationType", "type": "string", "optional": false, "description": "", "typeRef": "Audits.ContentSecurityPolicyViolationType" }, { "name": "frameAncestor", "type": "object", "optional": true, "description": "", "typeRef": "Audits.AffectedFrame" }, { "name": "sourceCodeLocation", "type": "object", "optional": true, "description": "", "typeRef": "Audits.SourceCodeLocation" }, { "name": "violatingNodeId", "type": "number", "optional": true, "description": "", "typeRef": "DOM.BackendNodeId" }]);
    inspectorBackend.registerType("Audits.SharedArrayBufferIssueDetails", [{ "name": "sourceCodeLocation", "type": "object", "optional": false, "description": "", "typeRef": "Audits.SourceCodeLocation" }, { "name": "isWarning", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "type", "type": "string", "optional": false, "description": "", "typeRef": "Audits.SharedArrayBufferIssueType" }]);
    inspectorBackend.registerType("Audits.LowTextContrastIssueDetails", [{ "name": "violatingNodeId", "type": "number", "optional": false, "description": "", "typeRef": "DOM.BackendNodeId" }, { "name": "violatingNodeSelector", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "contrastRatio", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "thresholdAA", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "thresholdAAA", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "fontSize", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "fontWeight", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Audits.CorsIssueDetails", [{ "name": "corsErrorStatus", "type": "object", "optional": false, "description": "", "typeRef": "Network.CorsErrorStatus" }, { "name": "isWarning", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "request", "type": "object", "optional": false, "description": "", "typeRef": "Audits.AffectedRequest" }, { "name": "location", "type": "object", "optional": true, "description": "", "typeRef": "Audits.SourceCodeLocation" }, { "name": "initiatorOrigin", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "resourceIPAddressSpace", "type": "string", "optional": true, "description": "", "typeRef": "Network.IPAddressSpace" }, { "name": "clientSecurityState", "type": "object", "optional": true, "description": "", "typeRef": "Network.ClientSecurityState" }]);
    inspectorBackend.registerType("Audits.AttributionReportingIssueDetails", [{ "name": "violationType", "type": "string", "optional": false, "description": "", "typeRef": "Audits.AttributionReportingIssueType" }, { "name": "request", "type": "object", "optional": true, "description": "", "typeRef": "Audits.AffectedRequest" }, { "name": "violatingNodeId", "type": "number", "optional": true, "description": "", "typeRef": "DOM.BackendNodeId" }, { "name": "invalidParameter", "type": "string", "optional": true, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Audits.QuirksModeIssueDetails", [{ "name": "isLimitedQuirksMode", "type": "boolean", "optional": false, "description": "If false, it means the document's mode is \\\"quirks\\\" instead of \\\"limited-quirks\\\".", "typeRef": null }, { "name": "documentNodeId", "type": "number", "optional": false, "description": "", "typeRef": "DOM.BackendNodeId" }, { "name": "url", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "frameId", "type": "string", "optional": false, "description": "", "typeRef": "Page.FrameId" }, { "name": "loaderId", "type": "string", "optional": false, "description": "", "typeRef": "Network.LoaderId" }]);
    inspectorBackend.registerType("Audits.NavigatorUserAgentIssueDetails", [{ "name": "url", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "location", "type": "object", "optional": true, "description": "", "typeRef": "Audits.SourceCodeLocation" }]);
    inspectorBackend.registerType("Audits.SharedDictionaryIssueDetails", [{ "name": "sharedDictionaryError", "type": "string", "optional": false, "description": "", "typeRef": "Audits.SharedDictionaryError" }, { "name": "request", "type": "object", "optional": false, "description": "", "typeRef": "Audits.AffectedRequest" }]);
    inspectorBackend.registerType("Audits.SRIMessageSignatureIssueDetails", [{ "name": "error", "type": "string", "optional": false, "description": "", "typeRef": "Audits.SRIMessageSignatureError" }, { "name": "signatureBase", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "integrityAssertions", "type": "array", "optional": false, "description": "", "typeRef": "string" }, { "name": "request", "type": "object", "optional": false, "description": "", "typeRef": "Audits.AffectedRequest" }]);
    inspectorBackend.registerType("Audits.UnencodedDigestIssueDetails", [{ "name": "error", "type": "string", "optional": false, "description": "", "typeRef": "Audits.UnencodedDigestError" }, { "name": "request", "type": "object", "optional": false, "description": "", "typeRef": "Audits.AffectedRequest" }]);
    inspectorBackend.registerType("Audits.GenericIssueDetails", [{ "name": "errorType", "type": "string", "optional": false, "description": "Issues with the same errorType are aggregated in the frontend.", "typeRef": "Audits.GenericIssueErrorType" }, { "name": "frameId", "type": "string", "optional": true, "description": "", "typeRef": "Page.FrameId" }, { "name": "violatingNodeId", "type": "number", "optional": true, "description": "", "typeRef": "DOM.BackendNodeId" }, { "name": "violatingNodeAttribute", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "request", "type": "object", "optional": true, "description": "", "typeRef": "Audits.AffectedRequest" }]);
    inspectorBackend.registerType("Audits.DeprecationIssueDetails", [{ "name": "affectedFrame", "type": "object", "optional": true, "description": "", "typeRef": "Audits.AffectedFrame" }, { "name": "sourceCodeLocation", "type": "object", "optional": false, "description": "", "typeRef": "Audits.SourceCodeLocation" }, { "name": "type", "type": "string", "optional": false, "description": "One of the deprecation names from third_party/blink/renderer/core/frame/deprecation/deprecation.json5", "typeRef": null }]);
    inspectorBackend.registerType("Audits.BounceTrackingIssueDetails", [{ "name": "trackingSites", "type": "array", "optional": false, "description": "", "typeRef": "string" }]);
    inspectorBackend.registerType("Audits.CookieDeprecationMetadataIssueDetails", [{ "name": "allowedSites", "type": "array", "optional": false, "description": "", "typeRef": "string" }, { "name": "optOutPercentage", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "isOptOutTopLevel", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "operation", "type": "string", "optional": false, "description": "", "typeRef": "Audits.CookieOperation" }]);
    inspectorBackend.registerType("Audits.FederatedAuthRequestIssueDetails", [{ "name": "federatedAuthRequestIssueReason", "type": "string", "optional": false, "description": "", "typeRef": "Audits.FederatedAuthRequestIssueReason" }]);
    inspectorBackend.registerType("Audits.FederatedAuthUserInfoRequestIssueDetails", [{ "name": "federatedAuthUserInfoRequestIssueReason", "type": "string", "optional": false, "description": "", "typeRef": "Audits.FederatedAuthUserInfoRequestIssueReason" }]);
    inspectorBackend.registerType("Audits.ClientHintIssueDetails", [{ "name": "sourceCodeLocation", "type": "object", "optional": false, "description": "", "typeRef": "Audits.SourceCodeLocation" }, { "name": "clientHintIssueReason", "type": "string", "optional": false, "description": "", "typeRef": "Audits.ClientHintIssueReason" }]);
    inspectorBackend.registerType("Audits.FailedRequestInfo", [{ "name": "url", "type": "string", "optional": false, "description": "The URL that failed to load.", "typeRef": null }, { "name": "failureMessage", "type": "string", "optional": false, "description": "The failure message for the failed request.", "typeRef": null }, { "name": "requestId", "type": "string", "optional": true, "description": "", "typeRef": "Network.RequestId" }]);
    inspectorBackend.registerType("Audits.PartitioningBlobURLIssueDetails", [{ "name": "url", "type": "string", "optional": false, "description": "The BlobURL that failed to load.", "typeRef": null }, { "name": "partitioningBlobURLInfo", "type": "string", "optional": false, "description": "Additional information about the Partitioning Blob URL issue.", "typeRef": "Audits.PartitioningBlobURLInfo" }]);
    inspectorBackend.registerType("Audits.ElementAccessibilityIssueDetails", [{ "name": "nodeId", "type": "number", "optional": false, "description": "", "typeRef": "DOM.BackendNodeId" }, { "name": "elementAccessibilityIssueReason", "type": "string", "optional": false, "description": "", "typeRef": "Audits.ElementAccessibilityIssueReason" }, { "name": "hasDisallowedAttributes", "type": "boolean", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Audits.StylesheetLoadingIssueDetails", [{ "name": "sourceCodeLocation", "type": "object", "optional": false, "description": "Source code position that referenced the failing stylesheet.", "typeRef": "Audits.SourceCodeLocation" }, { "name": "styleSheetLoadingIssueReason", "type": "string", "optional": false, "description": "Reason why the stylesheet couldn't be loaded.", "typeRef": "Audits.StyleSheetLoadingIssueReason" }, { "name": "failedRequestInfo", "type": "object", "optional": true, "description": "Contains additional info when the failure was due to a request.", "typeRef": "Audits.FailedRequestInfo" }]);
    inspectorBackend.registerType("Audits.PropertyRuleIssueDetails", [{ "name": "sourceCodeLocation", "type": "object", "optional": false, "description": "Source code position of the property rule.", "typeRef": "Audits.SourceCodeLocation" }, { "name": "propertyRuleIssueReason", "type": "string", "optional": false, "description": "Reason why the property rule was discarded.", "typeRef": "Audits.PropertyRuleIssueReason" }, { "name": "propertyValue", "type": "string", "optional": true, "description": "The value of the property rule property that failed to parse", "typeRef": null }]);
    inspectorBackend.registerType("Audits.UserReidentificationIssueDetails", [{ "name": "type", "type": "string", "optional": false, "description": "", "typeRef": "Audits.UserReidentificationIssueType" }, { "name": "request", "type": "object", "optional": true, "description": "Applies to BlockedFrameNavigation and BlockedSubresource issue types.", "typeRef": "Audits.AffectedRequest" }, { "name": "sourceCodeLocation", "type": "object", "optional": true, "description": "Applies to NoisedCanvasReadback issue type.", "typeRef": "Audits.SourceCodeLocation" }]);
    inspectorBackend.registerType("Audits.InspectorIssueDetails", [{ "name": "cookieIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.CookieIssueDetails" }, { "name": "mixedContentIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.MixedContentIssueDetails" }, { "name": "blockedByResponseIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.BlockedByResponseIssueDetails" }, { "name": "heavyAdIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.HeavyAdIssueDetails" }, { "name": "contentSecurityPolicyIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.ContentSecurityPolicyIssueDetails" }, { "name": "sharedArrayBufferIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.SharedArrayBufferIssueDetails" }, { "name": "lowTextContrastIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.LowTextContrastIssueDetails" }, { "name": "corsIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.CorsIssueDetails" }, { "name": "attributionReportingIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.AttributionReportingIssueDetails" }, { "name": "quirksModeIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.QuirksModeIssueDetails" }, { "name": "partitioningBlobURLIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.PartitioningBlobURLIssueDetails" }, { "name": "navigatorUserAgentIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.NavigatorUserAgentIssueDetails" }, { "name": "genericIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.GenericIssueDetails" }, { "name": "deprecationIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.DeprecationIssueDetails" }, { "name": "clientHintIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.ClientHintIssueDetails" }, { "name": "federatedAuthRequestIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.FederatedAuthRequestIssueDetails" }, { "name": "bounceTrackingIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.BounceTrackingIssueDetails" }, { "name": "cookieDeprecationMetadataIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.CookieDeprecationMetadataIssueDetails" }, { "name": "stylesheetLoadingIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.StylesheetLoadingIssueDetails" }, { "name": "propertyRuleIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.PropertyRuleIssueDetails" }, { "name": "federatedAuthUserInfoRequestIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.FederatedAuthUserInfoRequestIssueDetails" }, { "name": "sharedDictionaryIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.SharedDictionaryIssueDetails" }, { "name": "elementAccessibilityIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.ElementAccessibilityIssueDetails" }, { "name": "sriMessageSignatureIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.SRIMessageSignatureIssueDetails" }, { "name": "unencodedDigestIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.UnencodedDigestIssueDetails" }, { "name": "userReidentificationIssueDetails", "type": "object", "optional": true, "description": "", "typeRef": "Audits.UserReidentificationIssueDetails" }]);
    inspectorBackend.registerType("Audits.InspectorIssue", [{ "name": "code", "type": "string", "optional": false, "description": "", "typeRef": "Audits.InspectorIssueCode" }, { "name": "details", "type": "object", "optional": false, "description": "", "typeRef": "Audits.InspectorIssueDetails" }, { "name": "issueId", "type": "string", "optional": true, "description": "A unique id for this issue. May be omitted if no other entity (e.g. exception, CDP message, etc.) is referencing this issue.", "typeRef": "Audits.IssueId" }]);
    // Autofill.
    inspectorBackend.registerEnum("Autofill.FillingStrategy", { AutocompleteAttribute: "autocompleteAttribute", AutofillInferred: "autofillInferred" });
    inspectorBackend.registerEvent("Autofill.addressFormFilled", ["filledFields", "addressUi"]);
    inspectorBackend.registerCommand("Autofill.trigger", [{ "name": "fieldId", "type": "number", "optional": false, "description": "Identifies a field that serves as an anchor for autofill.", "typeRef": "DOM.BackendNodeId" }, { "name": "frameId", "type": "string", "optional": true, "description": "Identifies the frame that field belongs to.", "typeRef": "Page.FrameId" }, { "name": "card", "type": "object", "optional": true, "description": "Credit card information to fill out the form. Credit card data is not saved.  Mutually exclusive with `address`.", "typeRef": "Autofill.CreditCard" }, { "name": "address", "type": "object", "optional": true, "description": "Address to fill out the form. Address data is not saved. Mutually exclusive with `card`.", "typeRef": "Autofill.Address" }], [], "Trigger autofill on a form identified by the fieldId. If the field and related form cannot be autofilled, returns an error.");
    inspectorBackend.registerCommand("Autofill.setAddresses", [{ "name": "addresses", "type": "array", "optional": false, "description": "", "typeRef": "Autofill.Address" }], [], "Set addresses so that developers can verify their forms implementation.");
    inspectorBackend.registerCommand("Autofill.disable", [], [], "Disables autofill domain notifications.");
    inspectorBackend.registerCommand("Autofill.enable", [], [], "Enables autofill domain notifications.");
    inspectorBackend.registerType("Autofill.CreditCard", [{ "name": "number", "type": "string", "optional": false, "description": "16-digit credit card number.", "typeRef": null }, { "name": "name", "type": "string", "optional": false, "description": "Name of the credit card owner.", "typeRef": null }, { "name": "expiryMonth", "type": "string", "optional": false, "description": "2-digit expiry month.", "typeRef": null }, { "name": "expiryYear", "type": "string", "optional": false, "description": "4-digit expiry year.", "typeRef": null }, { "name": "cvc", "type": "string", "optional": false, "description": "3-digit card verification code.", "typeRef": null }]);
    inspectorBackend.registerType("Autofill.AddressField", [{ "name": "name", "type": "string", "optional": false, "description": "address field name, for example GIVEN_NAME. The full list of supported field names: https://source.chromium.org/chromium/chromium/src/+/main:components/autofill/core/browser/field_types.cc;l=38", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "address field value, for example Jon Doe.", "typeRef": null }]);
    inspectorBackend.registerType("Autofill.AddressFields", [{ "name": "fields", "type": "array", "optional": false, "description": "", "typeRef": "Autofill.AddressField" }]);
    inspectorBackend.registerType("Autofill.Address", [{ "name": "fields", "type": "array", "optional": false, "description": "fields and values defining an address.", "typeRef": "Autofill.AddressField" }]);
    inspectorBackend.registerType("Autofill.AddressUI", [{ "name": "addressFields", "type": "array", "optional": false, "description": "A two dimension array containing the representation of values from an address profile.", "typeRef": "Autofill.AddressFields" }]);
    inspectorBackend.registerType("Autofill.FilledField", [{ "name": "htmlType", "type": "string", "optional": false, "description": "The type of the field, e.g text, password etc.", "typeRef": null }, { "name": "id", "type": "string", "optional": false, "description": "the html id", "typeRef": null }, { "name": "name", "type": "string", "optional": false, "description": "the html name", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "the field value", "typeRef": null }, { "name": "autofillType", "type": "string", "optional": false, "description": "The actual field type, e.g FAMILY_NAME", "typeRef": null }, { "name": "fillingStrategy", "type": "string", "optional": false, "description": "The filling strategy", "typeRef": "Autofill.FillingStrategy" }, { "name": "frameId", "type": "string", "optional": false, "description": "The frame the field belongs to", "typeRef": "Page.FrameId" }, { "name": "fieldId", "type": "number", "optional": false, "description": "The form field's DOM node", "typeRef": "DOM.BackendNodeId" }]);
    // BackgroundService.
    inspectorBackend.registerEnum("BackgroundService.ServiceName", { BackgroundFetch: "backgroundFetch", BackgroundSync: "backgroundSync", PushMessaging: "pushMessaging", Notifications: "notifications", PaymentHandler: "paymentHandler", PeriodicBackgroundSync: "periodicBackgroundSync" });
    inspectorBackend.registerEvent("BackgroundService.recordingStateChanged", ["isRecording", "service"]);
    inspectorBackend.registerEvent("BackgroundService.backgroundServiceEventReceived", ["backgroundServiceEvent"]);
    inspectorBackend.registerCommand("BackgroundService.startObserving", [{ "name": "service", "type": "string", "optional": false, "description": "", "typeRef": "BackgroundService.ServiceName" }], [], "Enables event updates for the service.");
    inspectorBackend.registerCommand("BackgroundService.stopObserving", [{ "name": "service", "type": "string", "optional": false, "description": "", "typeRef": "BackgroundService.ServiceName" }], [], "Disables event updates for the service.");
    inspectorBackend.registerCommand("BackgroundService.setRecording", [{ "name": "shouldRecord", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "service", "type": "string", "optional": false, "description": "", "typeRef": "BackgroundService.ServiceName" }], [], "Set the recording state for the service.");
    inspectorBackend.registerCommand("BackgroundService.clearEvents", [{ "name": "service", "type": "string", "optional": false, "description": "", "typeRef": "BackgroundService.ServiceName" }], [], "Clears all stored data for the service.");
    inspectorBackend.registerType("BackgroundService.EventMetadata", [{ "name": "key", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("BackgroundService.BackgroundServiceEvent", [{ "name": "timestamp", "type": "number", "optional": false, "description": "Timestamp of the event (in seconds).", "typeRef": "Network.TimeSinceEpoch" }, { "name": "origin", "type": "string", "optional": false, "description": "The origin this event belongs to.", "typeRef": null }, { "name": "serviceWorkerRegistrationId", "type": "string", "optional": false, "description": "The Service Worker ID that initiated the event.", "typeRef": "ServiceWorker.RegistrationID" }, { "name": "service", "type": "string", "optional": false, "description": "The Background Service this event belongs to.", "typeRef": "BackgroundService.ServiceName" }, { "name": "eventName", "type": "string", "optional": false, "description": "A description of the event.", "typeRef": null }, { "name": "instanceId", "type": "string", "optional": false, "description": "An identifier that groups related events together.", "typeRef": null }, { "name": "eventMetadata", "type": "array", "optional": false, "description": "A list of event-specific information.", "typeRef": "BackgroundService.EventMetadata" }, { "name": "storageKey", "type": "string", "optional": false, "description": "Storage key this event belongs to.", "typeRef": null }]);
    // BluetoothEmulation.
    inspectorBackend.registerEnum("BluetoothEmulation.CentralState", { Absent: "absent", PoweredOff: "powered-off", PoweredOn: "powered-on" });
    inspectorBackend.registerEnum("BluetoothEmulation.GATTOperationType", { Connection: "connection", Discovery: "discovery" });
    inspectorBackend.registerEnum("BluetoothEmulation.CharacteristicWriteType", { WriteDefaultDeprecated: "write-default-deprecated", WriteWithResponse: "write-with-response", WriteWithoutResponse: "write-without-response" });
    inspectorBackend.registerEnum("BluetoothEmulation.CharacteristicOperationType", { Read: "read", Write: "write", SubscribeToNotifications: "subscribe-to-notifications", UnsubscribeFromNotifications: "unsubscribe-from-notifications" });
    inspectorBackend.registerEnum("BluetoothEmulation.DescriptorOperationType", { Read: "read", Write: "write" });
    inspectorBackend.registerEvent("BluetoothEmulation.gattOperationReceived", ["address", "type"]);
    inspectorBackend.registerEvent("BluetoothEmulation.characteristicOperationReceived", ["characteristicId", "type", "data", "writeType"]);
    inspectorBackend.registerEvent("BluetoothEmulation.descriptorOperationReceived", ["descriptorId", "type", "data"]);
    inspectorBackend.registerCommand("BluetoothEmulation.enable", [{ "name": "state", "type": "string", "optional": false, "description": "State of the simulated central.", "typeRef": "BluetoothEmulation.CentralState" }, { "name": "leSupported", "type": "boolean", "optional": false, "description": "If the simulated central supports low-energy.", "typeRef": null }], [], "Enable the BluetoothEmulation domain.");
    inspectorBackend.registerCommand("BluetoothEmulation.setSimulatedCentralState", [{ "name": "state", "type": "string", "optional": false, "description": "State of the simulated central.", "typeRef": "BluetoothEmulation.CentralState" }], [], "Set the state of the simulated central.");
    inspectorBackend.registerCommand("BluetoothEmulation.disable", [], [], "Disable the BluetoothEmulation domain.");
    inspectorBackend.registerCommand("BluetoothEmulation.simulatePreconnectedPeripheral", [{ "name": "address", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "manufacturerData", "type": "array", "optional": false, "description": "", "typeRef": "BluetoothEmulation.ManufacturerData" }, { "name": "knownServiceUuids", "type": "array", "optional": false, "description": "", "typeRef": "string" }], [], "Simulates a peripheral with |address|, |name| and |knownServiceUuids| that has already been connected to the system.");
    inspectorBackend.registerCommand("BluetoothEmulation.simulateAdvertisement", [{ "name": "entry", "type": "object", "optional": false, "description": "", "typeRef": "BluetoothEmulation.ScanEntry" }], [], "Simulates an advertisement packet described in |entry| being received by the central.");
    inspectorBackend.registerCommand("BluetoothEmulation.simulateGATTOperationResponse", [{ "name": "address", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "type", "type": "string", "optional": false, "description": "", "typeRef": "BluetoothEmulation.GATTOperationType" }, { "name": "code", "type": "number", "optional": false, "description": "", "typeRef": null }], [], "Simulates the response code from the peripheral with |address| for a GATT operation of |type|. The |code| value follows the HCI Error Codes from Bluetooth Core Specification Vol 2 Part D 1.3 List Of Error Codes.");
    inspectorBackend.registerCommand("BluetoothEmulation.simulateCharacteristicOperationResponse", [{ "name": "characteristicId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "type", "type": "string", "optional": false, "description": "", "typeRef": "BluetoothEmulation.CharacteristicOperationType" }, { "name": "code", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "data", "type": "string", "optional": true, "description": "", "typeRef": null }], [], "Simulates the response from the characteristic with |characteristicId| for a characteristic operation of |type|. The |code| value follows the Error Codes from Bluetooth Core Specification Vol 3 Part F 3.4.1.1 Error Response. The |data| is expected to exist when simulating a successful read operation response.");
    inspectorBackend.registerCommand("BluetoothEmulation.simulateDescriptorOperationResponse", [{ "name": "descriptorId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "type", "type": "string", "optional": false, "description": "", "typeRef": "BluetoothEmulation.DescriptorOperationType" }, { "name": "code", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "data", "type": "string", "optional": true, "description": "", "typeRef": null }], [], "Simulates the response from the descriptor with |descriptorId| for a descriptor operation of |type|. The |code| value follows the Error Codes from Bluetooth Core Specification Vol 3 Part F 3.4.1.1 Error Response. The |data| is expected to exist when simulating a successful read operation response.");
    inspectorBackend.registerCommand("BluetoothEmulation.addService", [{ "name": "address", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "serviceUuid", "type": "string", "optional": false, "description": "", "typeRef": null }], ["serviceId"], "Adds a service with |serviceUuid| to the peripheral with |address|.");
    inspectorBackend.registerCommand("BluetoothEmulation.removeService", [{ "name": "serviceId", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Removes the service respresented by |serviceId| from the simulated central.");
    inspectorBackend.registerCommand("BluetoothEmulation.addCharacteristic", [{ "name": "serviceId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "characteristicUuid", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "properties", "type": "object", "optional": false, "description": "", "typeRef": "BluetoothEmulation.CharacteristicProperties" }], ["characteristicId"], "Adds a characteristic with |characteristicUuid| and |properties| to the service represented by |serviceId|.");
    inspectorBackend.registerCommand("BluetoothEmulation.removeCharacteristic", [{ "name": "characteristicId", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Removes the characteristic respresented by |characteristicId| from the simulated central.");
    inspectorBackend.registerCommand("BluetoothEmulation.addDescriptor", [{ "name": "characteristicId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "descriptorUuid", "type": "string", "optional": false, "description": "", "typeRef": null }], ["descriptorId"], "Adds a descriptor with |descriptorUuid| to the characteristic respresented by |characteristicId|.");
    inspectorBackend.registerCommand("BluetoothEmulation.removeDescriptor", [{ "name": "descriptorId", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Removes the descriptor with |descriptorId| from the simulated central.");
    inspectorBackend.registerCommand("BluetoothEmulation.simulateGATTDisconnection", [{ "name": "address", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Simulates a GATT disconnection from the peripheral with |address|.");
    inspectorBackend.registerType("BluetoothEmulation.ManufacturerData", [{ "name": "key", "type": "number", "optional": false, "description": "Company identifier https://bitbucket.org/bluetooth-SIG/public/src/main/assigned_numbers/company_identifiers/company_identifiers.yaml https://usb.org/developers", "typeRef": null }, { "name": "data", "type": "string", "optional": false, "description": "Manufacturer-specific data", "typeRef": null }]);
    inspectorBackend.registerType("BluetoothEmulation.ScanRecord", [{ "name": "name", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "uuids", "type": "array", "optional": true, "description": "", "typeRef": "string" }, { "name": "appearance", "type": "number", "optional": true, "description": "Stores the external appearance description of the device.", "typeRef": null }, { "name": "txPower", "type": "number", "optional": true, "description": "Stores the transmission power of a broadcasting device.", "typeRef": null }, { "name": "manufacturerData", "type": "array", "optional": true, "description": "Key is the company identifier and the value is an array of bytes of manufacturer specific data.", "typeRef": "BluetoothEmulation.ManufacturerData" }]);
    inspectorBackend.registerType("BluetoothEmulation.ScanEntry", [{ "name": "deviceAddress", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "rssi", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "scanRecord", "type": "object", "optional": false, "description": "", "typeRef": "BluetoothEmulation.ScanRecord" }]);
    inspectorBackend.registerType("BluetoothEmulation.CharacteristicProperties", [{ "name": "broadcast", "type": "boolean", "optional": true, "description": "", "typeRef": null }, { "name": "read", "type": "boolean", "optional": true, "description": "", "typeRef": null }, { "name": "writeWithoutResponse", "type": "boolean", "optional": true, "description": "", "typeRef": null }, { "name": "write", "type": "boolean", "optional": true, "description": "", "typeRef": null }, { "name": "notify", "type": "boolean", "optional": true, "description": "", "typeRef": null }, { "name": "indicate", "type": "boolean", "optional": true, "description": "", "typeRef": null }, { "name": "authenticatedSignedWrites", "type": "boolean", "optional": true, "description": "", "typeRef": null }, { "name": "extendedProperties", "type": "boolean", "optional": true, "description": "", "typeRef": null }]);
    // Browser.
    inspectorBackend.registerEnum("Browser.WindowState", { Normal: "normal", Minimized: "minimized", Maximized: "maximized", Fullscreen: "fullscreen" });
    inspectorBackend.registerEnum("Browser.PermissionType", { Ar: "ar", AudioCapture: "audioCapture", AutomaticFullscreen: "automaticFullscreen", BackgroundFetch: "backgroundFetch", BackgroundSync: "backgroundSync", CameraPanTiltZoom: "cameraPanTiltZoom", CapturedSurfaceControl: "capturedSurfaceControl", ClipboardReadWrite: "clipboardReadWrite", ClipboardSanitizedWrite: "clipboardSanitizedWrite", DisplayCapture: "displayCapture", DurableStorage: "durableStorage", Geolocation: "geolocation", HandTracking: "handTracking", IdleDetection: "idleDetection", KeyboardLock: "keyboardLock", LocalFonts: "localFonts", LocalNetworkAccess: "localNetworkAccess", Midi: "midi", MidiSysex: "midiSysex", Nfc: "nfc", Notifications: "notifications", PaymentHandler: "paymentHandler", PeriodicBackgroundSync: "periodicBackgroundSync", PointerLock: "pointerLock", ProtectedMediaIdentifier: "protectedMediaIdentifier", Sensors: "sensors", SmartCard: "smartCard", SpeakerSelection: "speakerSelection", StorageAccess: "storageAccess", TopLevelStorageAccess: "topLevelStorageAccess", VideoCapture: "videoCapture", Vr: "vr", WakeLockScreen: "wakeLockScreen", WakeLockSystem: "wakeLockSystem", WebAppInstallation: "webAppInstallation", WebPrinting: "webPrinting", WindowManagement: "windowManagement" });
    inspectorBackend.registerEnum("Browser.PermissionSetting", { Granted: "granted", Denied: "denied", Prompt: "prompt" });
    inspectorBackend.registerEnum("Browser.BrowserCommandId", { OpenTabSearch: "openTabSearch", CloseTabSearch: "closeTabSearch", OpenGlic: "openGlic" });
    inspectorBackend.registerEnum("Browser.PrivacySandboxAPI", { BiddingAndAuctionServices: "BiddingAndAuctionServices", TrustedKeyValue: "TrustedKeyValue" });
    inspectorBackend.registerEvent("Browser.downloadWillBegin", ["frameId", "guid", "url", "suggestedFilename"]);
    inspectorBackend.registerEnum("Browser.DownloadProgressEventState", { InProgress: "inProgress", Completed: "completed", Canceled: "canceled" });
    inspectorBackend.registerEvent("Browser.downloadProgress", ["guid", "totalBytes", "receivedBytes", "state", "filePath"]);
    inspectorBackend.registerCommand("Browser.setPermission", [{ "name": "permission", "type": "object", "optional": false, "description": "Descriptor of permission to override.", "typeRef": "Browser.PermissionDescriptor" }, { "name": "setting", "type": "string", "optional": false, "description": "Setting of the permission.", "typeRef": "Browser.PermissionSetting" }, { "name": "origin", "type": "string", "optional": true, "description": "Embedding origin the permission applies to, all origins if not specified.", "typeRef": null }, { "name": "embeddedOrigin", "type": "string", "optional": true, "description": "Embedded origin the permission applies to. It is ignored unless the embedding origin is present and valid. If the embedding origin is provided but the embedded origin isn't, the embedding origin is used as the embedded origin.", "typeRef": null }, { "name": "browserContextId", "type": "string", "optional": true, "description": "Context to override. When omitted, default browser context is used.", "typeRef": "Browser.BrowserContextID" }], [], "Set permission settings for given embedding and embedded origins.");
    inspectorBackend.registerCommand("Browser.grantPermissions", [{ "name": "permissions", "type": "array", "optional": false, "description": "", "typeRef": "Browser.PermissionType" }, { "name": "origin", "type": "string", "optional": true, "description": "Origin the permission applies to, all origins if not specified.", "typeRef": null }, { "name": "browserContextId", "type": "string", "optional": true, "description": "BrowserContext to override permissions. When omitted, default browser context is used.", "typeRef": "Browser.BrowserContextID" }], [], "Grant specific permissions to the given origin and reject all others. Deprecated. Use setPermission instead.");
    inspectorBackend.registerCommand("Browser.resetPermissions", [{ "name": "browserContextId", "type": "string", "optional": true, "description": "BrowserContext to reset permissions. When omitted, default browser context is used.", "typeRef": "Browser.BrowserContextID" }], [], "Reset all permission management for all origins.");
    inspectorBackend.registerEnum("Browser.SetDownloadBehaviorRequestBehavior", { Deny: "deny", Allow: "allow", AllowAndName: "allowAndName", Default: "default" });
    inspectorBackend.registerCommand("Browser.setDownloadBehavior", [{ "name": "behavior", "type": "string", "optional": false, "description": "Whether to allow all or deny all download requests, or use default Chrome behavior if available (otherwise deny). |allowAndName| allows download and names files according to their download guids.", "typeRef": "Browser.SetDownloadBehaviorRequestBehavior" }, { "name": "browserContextId", "type": "string", "optional": true, "description": "BrowserContext to set download behavior. When omitted, default browser context is used.", "typeRef": "Browser.BrowserContextID" }, { "name": "downloadPath", "type": "string", "optional": true, "description": "The default path to save downloaded files to. This is required if behavior is set to 'allow' or 'allowAndName'.", "typeRef": null }, { "name": "eventsEnabled", "type": "boolean", "optional": true, "description": "Whether to emit download events (defaults to false).", "typeRef": null }], [], "Set the behavior when downloading a file.");
    inspectorBackend.registerCommand("Browser.cancelDownload", [{ "name": "guid", "type": "string", "optional": false, "description": "Global unique identifier of the download.", "typeRef": null }, { "name": "browserContextId", "type": "string", "optional": true, "description": "BrowserContext to perform the action in. When omitted, default browser context is used.", "typeRef": "Browser.BrowserContextID" }], [], "Cancel a download if in progress");
    inspectorBackend.registerCommand("Browser.close", [], [], "Close browser gracefully.");
    inspectorBackend.registerCommand("Browser.crash", [], [], "Crashes browser on the main thread.");
    inspectorBackend.registerCommand("Browser.crashGpuProcess", [], [], "Crashes GPU process.");
    inspectorBackend.registerCommand("Browser.getVersion", [], ["protocolVersion", "product", "revision", "userAgent", "jsVersion"], "Returns version information.");
    inspectorBackend.registerCommand("Browser.getBrowserCommandLine", [], ["arguments"], "Returns the command line switches for the browser process if, and only if --enable-automation is on the commandline.");
    inspectorBackend.registerCommand("Browser.getHistograms", [{ "name": "query", "type": "string", "optional": true, "description": "Requested substring in name. Only histograms which have query as a substring in their name are extracted. An empty or absent query returns all histograms.", "typeRef": null }, { "name": "delta", "type": "boolean", "optional": true, "description": "If true, retrieve delta since last delta call.", "typeRef": null }], ["histograms"], "Get Chrome histograms.");
    inspectorBackend.registerCommand("Browser.getHistogram", [{ "name": "name", "type": "string", "optional": false, "description": "Requested histogram name.", "typeRef": null }, { "name": "delta", "type": "boolean", "optional": true, "description": "If true, retrieve delta since last delta call.", "typeRef": null }], ["histogram"], "Get a Chrome histogram by name.");
    inspectorBackend.registerCommand("Browser.getWindowBounds", [{ "name": "windowId", "type": "number", "optional": false, "description": "Browser window id.", "typeRef": "Browser.WindowID" }], ["bounds"], "Get position and size of the browser window.");
    inspectorBackend.registerCommand("Browser.getWindowForTarget", [{ "name": "targetId", "type": "string", "optional": true, "description": "Devtools agent host id. If called as a part of the session, associated targetId is used.", "typeRef": "Target.TargetID" }], ["windowId", "bounds"], "Get the browser window that contains the devtools target.");
    inspectorBackend.registerCommand("Browser.setWindowBounds", [{ "name": "windowId", "type": "number", "optional": false, "description": "Browser window id.", "typeRef": "Browser.WindowID" }, { "name": "bounds", "type": "object", "optional": false, "description": "New window bounds. The 'minimized', 'maximized' and 'fullscreen' states cannot be combined with 'left', 'top', 'width' or 'height'. Leaves unspecified fields unchanged.", "typeRef": "Browser.Bounds" }], [], "Set position and/or size of the browser window.");
    inspectorBackend.registerCommand("Browser.setContentsSize", [{ "name": "windowId", "type": "number", "optional": false, "description": "Browser window id.", "typeRef": "Browser.WindowID" }, { "name": "width", "type": "number", "optional": true, "description": "The window contents width in DIP. Assumes current width if omitted. Must be specified if 'height' is omitted.", "typeRef": null }, { "name": "height", "type": "number", "optional": true, "description": "The window contents height in DIP. Assumes current height if omitted. Must be specified if 'width' is omitted.", "typeRef": null }], [], "Set size of the browser contents resizing browser window as necessary.");
    inspectorBackend.registerCommand("Browser.setDockTile", [{ "name": "badgeLabel", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "image", "type": "string", "optional": true, "description": "Png encoded image.", "typeRef": null }], [], "Set dock tile details, platform-specific.");
    inspectorBackend.registerCommand("Browser.executeBrowserCommand", [{ "name": "commandId", "type": "string", "optional": false, "description": "", "typeRef": "Browser.BrowserCommandId" }], [], "Invoke custom browser commands used by telemetry.");
    inspectorBackend.registerCommand("Browser.addPrivacySandboxEnrollmentOverride", [{ "name": "url", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Allows a site to use privacy sandbox features that require enrollment without the site actually being enrolled. Only supported on page targets.");
    inspectorBackend.registerCommand("Browser.addPrivacySandboxCoordinatorKeyConfig", [{ "name": "api", "type": "string", "optional": false, "description": "", "typeRef": "Browser.PrivacySandboxAPI" }, { "name": "coordinatorOrigin", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "keyConfig", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "browserContextId", "type": "string", "optional": true, "description": "BrowserContext to perform the action in. When omitted, default browser context is used.", "typeRef": "Browser.BrowserContextID" }], [], "Configures encryption keys used with a given privacy sandbox API to talk to a trusted coordinator.  Since this is intended for test automation only, coordinatorOrigin must be a .test domain. No existing coordinator configuration for the origin may exist.");
    inspectorBackend.registerType("Browser.Bounds", [{ "name": "left", "type": "number", "optional": true, "description": "The offset from the left edge of the screen to the window in pixels.", "typeRef": null }, { "name": "top", "type": "number", "optional": true, "description": "The offset from the top edge of the screen to the window in pixels.", "typeRef": null }, { "name": "width", "type": "number", "optional": true, "description": "The window width in pixels.", "typeRef": null }, { "name": "height", "type": "number", "optional": true, "description": "The window height in pixels.", "typeRef": null }, { "name": "windowState", "type": "string", "optional": true, "description": "The window state. Default to normal.", "typeRef": "Browser.WindowState" }]);
    inspectorBackend.registerType("Browser.PermissionDescriptor", [{ "name": "name", "type": "string", "optional": false, "description": "Name of permission. See https://cs.chromium.org/chromium/src/third_party/blink/renderer/modules/permissions/permission_descriptor.idl for valid permission names.", "typeRef": null }, { "name": "sysex", "type": "boolean", "optional": true, "description": "For \\\"midi\\\" permission, may also specify sysex control.", "typeRef": null }, { "name": "userVisibleOnly", "type": "boolean", "optional": true, "description": "For \\\"push\\\" permission, may specify userVisibleOnly. Note that userVisibleOnly = true is the only currently supported type.", "typeRef": null }, { "name": "allowWithoutSanitization", "type": "boolean", "optional": true, "description": "For \\\"clipboard\\\" permission, may specify allowWithoutSanitization.", "typeRef": null }, { "name": "allowWithoutGesture", "type": "boolean", "optional": true, "description": "For \\\"fullscreen\\\" permission, must specify allowWithoutGesture:true.", "typeRef": null }, { "name": "panTiltZoom", "type": "boolean", "optional": true, "description": "For \\\"camera\\\" permission, may specify panTiltZoom.", "typeRef": null }]);
    inspectorBackend.registerType("Browser.Bucket", [{ "name": "low", "type": "number", "optional": false, "description": "Minimum value (inclusive).", "typeRef": null }, { "name": "high", "type": "number", "optional": false, "description": "Maximum value (exclusive).", "typeRef": null }, { "name": "count", "type": "number", "optional": false, "description": "Number of samples.", "typeRef": null }]);
    inspectorBackend.registerType("Browser.Histogram", [{ "name": "name", "type": "string", "optional": false, "description": "Name.", "typeRef": null }, { "name": "sum", "type": "number", "optional": false, "description": "Sum of sample values.", "typeRef": null }, { "name": "count", "type": "number", "optional": false, "description": "Total number of samples.", "typeRef": null }, { "name": "buckets", "type": "array", "optional": false, "description": "Buckets.", "typeRef": "Browser.Bucket" }]);
    // CSS.
    inspectorBackend.registerEnum("CSS.StyleSheetOrigin", { Injected: "injected", UserAgent: "user-agent", Inspector: "inspector", Regular: "regular" });
    inspectorBackend.registerEnum("CSS.CSSRuleType", { MediaRule: "MediaRule", SupportsRule: "SupportsRule", ContainerRule: "ContainerRule", LayerRule: "LayerRule", ScopeRule: "ScopeRule", StyleRule: "StyleRule", StartingStyleRule: "StartingStyleRule" });
    inspectorBackend.registerEnum("CSS.CSSMediaSource", { MediaRule: "mediaRule", ImportRule: "importRule", LinkedSheet: "linkedSheet", InlineSheet: "inlineSheet" });
    inspectorBackend.registerEvent("CSS.fontsUpdated", ["font"]);
    inspectorBackend.registerEvent("CSS.mediaQueryResultChanged", []);
    inspectorBackend.registerEvent("CSS.styleSheetAdded", ["header"]);
    inspectorBackend.registerEvent("CSS.styleSheetChanged", ["styleSheetId"]);
    inspectorBackend.registerEvent("CSS.styleSheetRemoved", ["styleSheetId"]);
    inspectorBackend.registerEvent("CSS.computedStyleUpdated", ["nodeId"]);
    inspectorBackend.registerCommand("CSS.addRule", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "The css style sheet identifier where a new rule should be inserted.", "typeRef": "CSS.StyleSheetId" }, { "name": "ruleText", "type": "string", "optional": false, "description": "The text of a new rule.", "typeRef": null }, { "name": "location", "type": "object", "optional": false, "description": "Text position of a new rule in the target style sheet.", "typeRef": "CSS.SourceRange" }, { "name": "nodeForPropertySyntaxValidation", "type": "number", "optional": true, "description": "NodeId for the DOM node in whose context custom property declarations for registered properties should be validated. If omitted, declarations in the new rule text can only be validated statically, which may produce incorrect results if the declaration contains a var() for example.", "typeRef": "DOM.NodeId" }], ["rule"], "Inserts a new rule with the given `ruleText` in a stylesheet with given `styleSheetId`, at the position specified by `location`.");
    inspectorBackend.registerCommand("CSS.collectClassNames", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "", "typeRef": "CSS.StyleSheetId" }], ["classNames"], "Returns all class names from specified stylesheet.");
    inspectorBackend.registerCommand("CSS.createStyleSheet", [{ "name": "frameId", "type": "string", "optional": false, "description": "Identifier of the frame where \\\"via-inspector\\\" stylesheet should be created.", "typeRef": "Page.FrameId" }, { "name": "force", "type": "boolean", "optional": true, "description": "If true, creates a new stylesheet for every call. If false, returns a stylesheet previously created by a call with force=false for the frame's document if it exists or creates a new stylesheet (default: false).", "typeRef": null }], ["styleSheetId"], "Creates a new special \"via-inspector\" stylesheet in the frame with given `frameId`.");
    inspectorBackend.registerCommand("CSS.disable", [], [], "Disables the CSS agent for the given page.");
    inspectorBackend.registerCommand("CSS.enable", [], [], "Enables the CSS agent for the given page. Clients should not assume that the CSS agent has been enabled until the result of this command is received.");
    inspectorBackend.registerCommand("CSS.forcePseudoState", [{ "name": "nodeId", "type": "number", "optional": false, "description": "The element id for which to force the pseudo state.", "typeRef": "DOM.NodeId" }, { "name": "forcedPseudoClasses", "type": "array", "optional": false, "description": "Element pseudo classes to force when computing the element's style.", "typeRef": "string" }], [], "Ensures that the given node will have specified pseudo-classes whenever its style is computed by the browser.");
    inspectorBackend.registerCommand("CSS.forceStartingStyle", [{ "name": "nodeId", "type": "number", "optional": false, "description": "The element id for which to force the starting-style state.", "typeRef": "DOM.NodeId" }, { "name": "forced", "type": "boolean", "optional": false, "description": "Boolean indicating if this is on or off.", "typeRef": null }], [], "Ensures that the given node is in its starting-style state.");
    inspectorBackend.registerCommand("CSS.getBackgroundColors", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to get background colors for.", "typeRef": "DOM.NodeId" }], ["backgroundColors", "computedFontSize", "computedFontWeight"], "");
    inspectorBackend.registerCommand("CSS.getComputedStyleForNode", [{ "name": "nodeId", "type": "number", "optional": false, "description": "", "typeRef": "DOM.NodeId" }], ["computedStyle", "extraFields"], "Returns the computed style for a DOM node identified by `nodeId`.");
    inspectorBackend.registerCommand("CSS.resolveValues", [{ "name": "values", "type": "array", "optional": false, "description": "Cascade-dependent keywords (revert/revert-layer) do not work.", "typeRef": "string" }, { "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node in whose context the expression is evaluated", "typeRef": "DOM.NodeId" }, { "name": "propertyName", "type": "string", "optional": true, "description": "Only longhands and custom property names are accepted.", "typeRef": null }, { "name": "pseudoType", "type": "string", "optional": true, "description": "Pseudo element type, only works for pseudo elements that generate elements in the tree, such as ::before and ::after.", "typeRef": "DOM.PseudoType" }, { "name": "pseudoIdentifier", "type": "string", "optional": true, "description": "Pseudo element custom ident.", "typeRef": null }], ["results"], "Resolve the specified values in the context of the provided element. For example, a value of '1em' is evaluated according to the computed 'font-size' of the element and a value 'calc(1px + 2px)' will be resolved to '3px'. If the `propertyName` was specified the `values` are resolved as if they were property's declaration. If a value cannot be parsed according to the provided property syntax, the value is parsed using combined syntax as if null `propertyName` was provided. If the value cannot be resolved even then, return the provided value without any changes.");
    inspectorBackend.registerCommand("CSS.getLonghandProperties", [{ "name": "shorthandName", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "", "typeRef": null }], ["longhandProperties"], "");
    inspectorBackend.registerCommand("CSS.getInlineStylesForNode", [{ "name": "nodeId", "type": "number", "optional": false, "description": "", "typeRef": "DOM.NodeId" }], ["inlineStyle", "attributesStyle"], "Returns the styles defined inline (explicitly in the \"style\" attribute and implicitly, using DOM attributes) for a DOM node identified by `nodeId`.");
    inspectorBackend.registerCommand("CSS.getAnimatedStylesForNode", [{ "name": "nodeId", "type": "number", "optional": false, "description": "", "typeRef": "DOM.NodeId" }], ["animationStyles", "transitionsStyle", "inherited"], "Returns the styles coming from animations & transitions including the animation & transition styles coming from inheritance chain.");
    inspectorBackend.registerCommand("CSS.getMatchedStylesForNode", [{ "name": "nodeId", "type": "number", "optional": false, "description": "", "typeRef": "DOM.NodeId" }], ["inlineStyle", "attributesStyle", "matchedCSSRules", "pseudoElements", "inherited", "inheritedPseudoElements", "cssKeyframesRules", "cssPositionTryRules", "activePositionFallbackIndex", "cssPropertyRules", "cssPropertyRegistrations", "cssFontPaletteValuesRule", "parentLayoutNodeId", "cssFunctionRules"], "Returns requested styles for a DOM node identified by `nodeId`.");
    inspectorBackend.registerCommand("CSS.getEnvironmentVariables", [], ["environmentVariables"], "Returns the values of the default UA-defined environment variables used in env()");
    inspectorBackend.registerCommand("CSS.getMediaQueries", [], ["medias"], "Returns all media queries parsed by the rendering engine.");
    inspectorBackend.registerCommand("CSS.getPlatformFontsForNode", [{ "name": "nodeId", "type": "number", "optional": false, "description": "", "typeRef": "DOM.NodeId" }], ["fonts"], "Requests information about platform fonts which we used to render child TextNodes in the given node.");
    inspectorBackend.registerCommand("CSS.getStyleSheetText", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "", "typeRef": "CSS.StyleSheetId" }], ["text"], "Returns the current textual content for a stylesheet.");
    inspectorBackend.registerCommand("CSS.getLayersForNode", [{ "name": "nodeId", "type": "number", "optional": false, "description": "", "typeRef": "DOM.NodeId" }], ["rootLayer"], "Returns all layers parsed by the rendering engine for the tree scope of a node. Given a DOM element identified by nodeId, getLayersForNode returns the root layer for the nearest ancestor document or shadow root. The layer root contains the full layer tree for the tree scope and their ordering.");
    inspectorBackend.registerCommand("CSS.getLocationForSelector", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "", "typeRef": "CSS.StyleSheetId" }, { "name": "selectorText", "type": "string", "optional": false, "description": "", "typeRef": null }], ["ranges"], "Given a CSS selector text and a style sheet ID, getLocationForSelector returns an array of locations of the CSS selector in the style sheet.");
    inspectorBackend.registerCommand("CSS.trackComputedStyleUpdatesForNode", [{ "name": "nodeId", "type": "number", "optional": true, "description": "", "typeRef": "DOM.NodeId" }], [], "Starts tracking the given node for the computed style updates and whenever the computed style is updated for node, it queues a `computedStyleUpdated` event with throttling. There can only be 1 node tracked for computed style updates so passing a new node id removes tracking from the previous node. Pass `undefined` to disable tracking.");
    inspectorBackend.registerCommand("CSS.trackComputedStyleUpdates", [{ "name": "propertiesToTrack", "type": "array", "optional": false, "description": "", "typeRef": "CSS.CSSComputedStyleProperty" }], [], "Starts tracking the given computed styles for updates. The specified array of properties replaces the one previously specified. Pass empty array to disable tracking. Use takeComputedStyleUpdates to retrieve the list of nodes that had properties modified. The changes to computed style properties are only tracked for nodes pushed to the front-end by the DOM agent. If no changes to the tracked properties occur after the node has been pushed to the front-end, no updates will be issued for the node.");
    inspectorBackend.registerCommand("CSS.takeComputedStyleUpdates", [], ["nodeIds"], "Polls the next batch of computed style updates.");
    inspectorBackend.registerCommand("CSS.setEffectivePropertyValueForNode", [{ "name": "nodeId", "type": "number", "optional": false, "description": "The element id for which to set property.", "typeRef": "DOM.NodeId" }, { "name": "propertyName", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Find a rule with the given active property for the given node and set the new value for this property");
    inspectorBackend.registerCommand("CSS.setPropertyRulePropertyName", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "", "typeRef": "CSS.StyleSheetId" }, { "name": "range", "type": "object", "optional": false, "description": "", "typeRef": "CSS.SourceRange" }, { "name": "propertyName", "type": "string", "optional": false, "description": "", "typeRef": null }], ["propertyName"], "Modifies the property rule property name.");
    inspectorBackend.registerCommand("CSS.setKeyframeKey", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "", "typeRef": "CSS.StyleSheetId" }, { "name": "range", "type": "object", "optional": false, "description": "", "typeRef": "CSS.SourceRange" }, { "name": "keyText", "type": "string", "optional": false, "description": "", "typeRef": null }], ["keyText"], "Modifies the keyframe rule key text.");
    inspectorBackend.registerCommand("CSS.setMediaText", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "", "typeRef": "CSS.StyleSheetId" }, { "name": "range", "type": "object", "optional": false, "description": "", "typeRef": "CSS.SourceRange" }, { "name": "text", "type": "string", "optional": false, "description": "", "typeRef": null }], ["media"], "Modifies the rule selector.");
    inspectorBackend.registerCommand("CSS.setContainerQueryText", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "", "typeRef": "CSS.StyleSheetId" }, { "name": "range", "type": "object", "optional": false, "description": "", "typeRef": "CSS.SourceRange" }, { "name": "text", "type": "string", "optional": false, "description": "", "typeRef": null }], ["containerQuery"], "Modifies the expression of a container query.");
    inspectorBackend.registerCommand("CSS.setSupportsText", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "", "typeRef": "CSS.StyleSheetId" }, { "name": "range", "type": "object", "optional": false, "description": "", "typeRef": "CSS.SourceRange" }, { "name": "text", "type": "string", "optional": false, "description": "", "typeRef": null }], ["supports"], "Modifies the expression of a supports at-rule.");
    inspectorBackend.registerCommand("CSS.setScopeText", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "", "typeRef": "CSS.StyleSheetId" }, { "name": "range", "type": "object", "optional": false, "description": "", "typeRef": "CSS.SourceRange" }, { "name": "text", "type": "string", "optional": false, "description": "", "typeRef": null }], ["scope"], "Modifies the expression of a scope at-rule.");
    inspectorBackend.registerCommand("CSS.setRuleSelector", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "", "typeRef": "CSS.StyleSheetId" }, { "name": "range", "type": "object", "optional": false, "description": "", "typeRef": "CSS.SourceRange" }, { "name": "selector", "type": "string", "optional": false, "description": "", "typeRef": null }], ["selectorList"], "Modifies the rule selector.");
    inspectorBackend.registerCommand("CSS.setStyleSheetText", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "", "typeRef": "CSS.StyleSheetId" }, { "name": "text", "type": "string", "optional": false, "description": "", "typeRef": null }], ["sourceMapURL"], "Sets the new stylesheet text.");
    inspectorBackend.registerCommand("CSS.setStyleTexts", [{ "name": "edits", "type": "array", "optional": false, "description": "", "typeRef": "CSS.StyleDeclarationEdit" }, { "name": "nodeForPropertySyntaxValidation", "type": "number", "optional": true, "description": "NodeId for the DOM node in whose context custom property declarations for registered properties should be validated. If omitted, declarations in the new rule text can only be validated statically, which may produce incorrect results if the declaration contains a var() for example.", "typeRef": "DOM.NodeId" }], ["styles"], "Applies specified style edits one after another in the given order.");
    inspectorBackend.registerCommand("CSS.startRuleUsageTracking", [], [], "Enables the selector recording.");
    inspectorBackend.registerCommand("CSS.stopRuleUsageTracking", [], ["ruleUsage"], "Stop tracking rule usage and return the list of rules that were used since last call to `takeCoverageDelta` (or since start of coverage instrumentation).");
    inspectorBackend.registerCommand("CSS.takeCoverageDelta", [], ["coverage", "timestamp"], "Obtain list of rules that became used since last call to this method (or since start of coverage instrumentation).");
    inspectorBackend.registerCommand("CSS.setLocalFontsEnabled", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "Whether rendering of local fonts is enabled.", "typeRef": null }], [], "Enables/disables rendering of local CSS fonts (enabled by default).");
    inspectorBackend.registerType("CSS.PseudoElementMatches", [{ "name": "pseudoType", "type": "string", "optional": false, "description": "Pseudo element type.", "typeRef": "DOM.PseudoType" }, { "name": "pseudoIdentifier", "type": "string", "optional": true, "description": "Pseudo element custom ident.", "typeRef": null }, { "name": "matches", "type": "array", "optional": false, "description": "Matches of CSS rules applicable to the pseudo style.", "typeRef": "CSS.RuleMatch" }]);
    inspectorBackend.registerType("CSS.CSSAnimationStyle", [{ "name": "name", "type": "string", "optional": true, "description": "The name of the animation.", "typeRef": null }, { "name": "style", "type": "object", "optional": false, "description": "The style coming from the animation.", "typeRef": "CSS.CSSStyle" }]);
    inspectorBackend.registerType("CSS.InheritedStyleEntry", [{ "name": "inlineStyle", "type": "object", "optional": true, "description": "The ancestor node's inline style, if any, in the style inheritance chain.", "typeRef": "CSS.CSSStyle" }, { "name": "matchedCSSRules", "type": "array", "optional": false, "description": "Matches of CSS rules matching the ancestor node in the style inheritance chain.", "typeRef": "CSS.RuleMatch" }]);
    inspectorBackend.registerType("CSS.InheritedAnimatedStyleEntry", [{ "name": "animationStyles", "type": "array", "optional": true, "description": "Styles coming from the animations of the ancestor, if any, in the style inheritance chain.", "typeRef": "CSS.CSSAnimationStyle" }, { "name": "transitionsStyle", "type": "object", "optional": true, "description": "The style coming from the transitions of the ancestor, if any, in the style inheritance chain.", "typeRef": "CSS.CSSStyle" }]);
    inspectorBackend.registerType("CSS.InheritedPseudoElementMatches", [{ "name": "pseudoElements", "type": "array", "optional": false, "description": "Matches of pseudo styles from the pseudos of an ancestor node.", "typeRef": "CSS.PseudoElementMatches" }]);
    inspectorBackend.registerType("CSS.RuleMatch", [{ "name": "rule", "type": "object", "optional": false, "description": "CSS rule in the match.", "typeRef": "CSS.CSSRule" }, { "name": "matchingSelectors", "type": "array", "optional": false, "description": "Matching selector indices in the rule's selectorList selectors (0-based).", "typeRef": "integer" }]);
    inspectorBackend.registerType("CSS.Value", [{ "name": "text", "type": "string", "optional": false, "description": "Value text.", "typeRef": null }, { "name": "range", "type": "object", "optional": true, "description": "Value range in the underlying resource (if available).", "typeRef": "CSS.SourceRange" }, { "name": "specificity", "type": "object", "optional": true, "description": "Specificity of the selector.", "typeRef": "CSS.Specificity" }]);
    inspectorBackend.registerType("CSS.Specificity", [{ "name": "a", "type": "number", "optional": false, "description": "The a component, which represents the number of ID selectors.", "typeRef": null }, { "name": "b", "type": "number", "optional": false, "description": "The b component, which represents the number of class selectors, attributes selectors, and pseudo-classes.", "typeRef": null }, { "name": "c", "type": "number", "optional": false, "description": "The c component, which represents the number of type selectors and pseudo-elements.", "typeRef": null }]);
    inspectorBackend.registerType("CSS.SelectorList", [{ "name": "selectors", "type": "array", "optional": false, "description": "Selectors in the list.", "typeRef": "CSS.Value" }, { "name": "text", "type": "string", "optional": false, "description": "Rule selector text.", "typeRef": null }]);
    inspectorBackend.registerType("CSS.CSSStyleSheetHeader", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "The stylesheet identifier.", "typeRef": "CSS.StyleSheetId" }, { "name": "frameId", "type": "string", "optional": false, "description": "Owner frame identifier.", "typeRef": "Page.FrameId" }, { "name": "sourceURL", "type": "string", "optional": false, "description": "Stylesheet resource URL. Empty if this is a constructed stylesheet created using new CSSStyleSheet() (but non-empty if this is a constructed stylesheet imported as a CSS module script).", "typeRef": null }, { "name": "sourceMapURL", "type": "string", "optional": true, "description": "URL of source map associated with the stylesheet (if any).", "typeRef": null }, { "name": "origin", "type": "string", "optional": false, "description": "Stylesheet origin.", "typeRef": "CSS.StyleSheetOrigin" }, { "name": "title", "type": "string", "optional": false, "description": "Stylesheet title.", "typeRef": null }, { "name": "ownerNode", "type": "number", "optional": true, "description": "The backend id for the owner node of the stylesheet.", "typeRef": "DOM.BackendNodeId" }, { "name": "disabled", "type": "boolean", "optional": false, "description": "Denotes whether the stylesheet is disabled.", "typeRef": null }, { "name": "hasSourceURL", "type": "boolean", "optional": true, "description": "Whether the sourceURL field value comes from the sourceURL comment.", "typeRef": null }, { "name": "isInline", "type": "boolean", "optional": false, "description": "Whether this stylesheet is created for STYLE tag by parser. This flag is not set for document.written STYLE tags.", "typeRef": null }, { "name": "isMutable", "type": "boolean", "optional": false, "description": "Whether this stylesheet is mutable. Inline stylesheets become mutable after they have been modified via CSSOM API. `<link>` element's stylesheets become mutable only if DevTools modifies them. Constructed stylesheets (new CSSStyleSheet()) are mutable immediately after creation.", "typeRef": null }, { "name": "isConstructed", "type": "boolean", "optional": false, "description": "True if this stylesheet is created through new CSSStyleSheet() or imported as a CSS module script.", "typeRef": null }, { "name": "startLine", "type": "number", "optional": false, "description": "Line offset of the stylesheet within the resource (zero based).", "typeRef": null }, { "name": "startColumn", "type": "number", "optional": false, "description": "Column offset of the stylesheet within the resource (zero based).", "typeRef": null }, { "name": "length", "type": "number", "optional": false, "description": "Size of the content (in characters).", "typeRef": null }, { "name": "endLine", "type": "number", "optional": false, "description": "Line offset of the end of the stylesheet within the resource (zero based).", "typeRef": null }, { "name": "endColumn", "type": "number", "optional": false, "description": "Column offset of the end of the stylesheet within the resource (zero based).", "typeRef": null }, { "name": "loadingFailed", "type": "boolean", "optional": true, "description": "If the style sheet was loaded from a network resource, this indicates when the resource failed to load", "typeRef": null }]);
    inspectorBackend.registerType("CSS.CSSRule", [{ "name": "styleSheetId", "type": "string", "optional": true, "description": "The css style sheet identifier (absent for user agent stylesheet and user-specified stylesheet rules) this rule came from.", "typeRef": "CSS.StyleSheetId" }, { "name": "selectorList", "type": "object", "optional": false, "description": "Rule selector data.", "typeRef": "CSS.SelectorList" }, { "name": "nestingSelectors", "type": "array", "optional": true, "description": "Array of selectors from ancestor style rules, sorted by distance from the current rule.", "typeRef": "string" }, { "name": "origin", "type": "string", "optional": false, "description": "Parent stylesheet's origin.", "typeRef": "CSS.StyleSheetOrigin" }, { "name": "style", "type": "object", "optional": false, "description": "Associated style declaration.", "typeRef": "CSS.CSSStyle" }, { "name": "originTreeScopeNodeId", "type": "number", "optional": true, "description": "The BackendNodeId of the DOM node that constitutes the origin tree scope of this rule.", "typeRef": "DOM.BackendNodeId" }, { "name": "media", "type": "array", "optional": true, "description": "Media list array (for rules involving media queries). The array enumerates media queries starting with the innermost one, going outwards.", "typeRef": "CSS.CSSMedia" }, { "name": "containerQueries", "type": "array", "optional": true, "description": "Container query list array (for rules involving container queries). The array enumerates container queries starting with the innermost one, going outwards.", "typeRef": "CSS.CSSContainerQuery" }, { "name": "supports", "type": "array", "optional": true, "description": "@supports CSS at-rule array. The array enumerates @supports at-rules starting with the innermost one, going outwards.", "typeRef": "CSS.CSSSupports" }, { "name": "layers", "type": "array", "optional": true, "description": "Cascade layer array. Contains the layer hierarchy that this rule belongs to starting with the innermost layer and going outwards.", "typeRef": "CSS.CSSLayer" }, { "name": "scopes", "type": "array", "optional": true, "description": "@scope CSS at-rule array. The array enumerates @scope at-rules starting with the innermost one, going outwards.", "typeRef": "CSS.CSSScope" }, { "name": "ruleTypes", "type": "array", "optional": true, "description": "The array keeps the types of ancestor CSSRules from the innermost going outwards.", "typeRef": "CSS.CSSRuleType" }, { "name": "startingStyles", "type": "array", "optional": true, "description": "@starting-style CSS at-rule array. The array enumerates @starting-style at-rules starting with the innermost one, going outwards.", "typeRef": "CSS.CSSStartingStyle" }]);
    inspectorBackend.registerType("CSS.RuleUsage", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "The css style sheet identifier (absent for user agent stylesheet and user-specified stylesheet rules) this rule came from.", "typeRef": "CSS.StyleSheetId" }, { "name": "startOffset", "type": "number", "optional": false, "description": "Offset of the start of the rule (including selector) from the beginning of the stylesheet.", "typeRef": null }, { "name": "endOffset", "type": "number", "optional": false, "description": "Offset of the end of the rule body from the beginning of the stylesheet.", "typeRef": null }, { "name": "used", "type": "boolean", "optional": false, "description": "Indicates whether the rule was actually used by some element in the page.", "typeRef": null }]);
    inspectorBackend.registerType("CSS.SourceRange", [{ "name": "startLine", "type": "number", "optional": false, "description": "Start line of range.", "typeRef": null }, { "name": "startColumn", "type": "number", "optional": false, "description": "Start column of range (inclusive).", "typeRef": null }, { "name": "endLine", "type": "number", "optional": false, "description": "End line of range", "typeRef": null }, { "name": "endColumn", "type": "number", "optional": false, "description": "End column of range (exclusive).", "typeRef": null }]);
    inspectorBackend.registerType("CSS.ShorthandEntry", [{ "name": "name", "type": "string", "optional": false, "description": "Shorthand name.", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "Shorthand value.", "typeRef": null }, { "name": "important", "type": "boolean", "optional": true, "description": "Whether the property has \\\"!important\\\" annotation (implies `false` if absent).", "typeRef": null }]);
    inspectorBackend.registerType("CSS.CSSComputedStyleProperty", [{ "name": "name", "type": "string", "optional": false, "description": "Computed style property name.", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "Computed style property value.", "typeRef": null }]);
    inspectorBackend.registerType("CSS.ComputedStyleExtraFields", [{ "name": "isAppearanceBase", "type": "boolean", "optional": false, "description": "Returns whether or not this node is being rendered with base appearance, which happens when it has its appearance property set to base/base-select or it is in the subtree of an element being rendered with base appearance.", "typeRef": null }]);
    inspectorBackend.registerType("CSS.CSSStyle", [{ "name": "styleSheetId", "type": "string", "optional": true, "description": "The css style sheet identifier (absent for user agent stylesheet and user-specified stylesheet rules) this rule came from.", "typeRef": "CSS.StyleSheetId" }, { "name": "cssProperties", "type": "array", "optional": false, "description": "CSS properties in the style.", "typeRef": "CSS.CSSProperty" }, { "name": "shorthandEntries", "type": "array", "optional": false, "description": "Computed values for all shorthands found in the style.", "typeRef": "CSS.ShorthandEntry" }, { "name": "cssText", "type": "string", "optional": true, "description": "Style declaration text (if available).", "typeRef": null }, { "name": "range", "type": "object", "optional": true, "description": "Style declaration range in the enclosing stylesheet (if available).", "typeRef": "CSS.SourceRange" }]);
    inspectorBackend.registerType("CSS.CSSProperty", [{ "name": "name", "type": "string", "optional": false, "description": "The property name.", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "The property value.", "typeRef": null }, { "name": "important", "type": "boolean", "optional": true, "description": "Whether the property has \\\"!important\\\" annotation (implies `false` if absent).", "typeRef": null }, { "name": "implicit", "type": "boolean", "optional": true, "description": "Whether the property is implicit (implies `false` if absent).", "typeRef": null }, { "name": "text", "type": "string", "optional": true, "description": "The full property text as specified in the style.", "typeRef": null }, { "name": "parsedOk", "type": "boolean", "optional": true, "description": "Whether the property is understood by the browser (implies `true` if absent).", "typeRef": null }, { "name": "disabled", "type": "boolean", "optional": true, "description": "Whether the property is disabled by the user (present for source-based properties only).", "typeRef": null }, { "name": "range", "type": "object", "optional": true, "description": "The entire property range in the enclosing style declaration (if available).", "typeRef": "CSS.SourceRange" }, { "name": "longhandProperties", "type": "array", "optional": true, "description": "Parsed longhand components of this property if it is a shorthand. This field will be empty if the given property is not a shorthand.", "typeRef": "CSS.CSSProperty" }]);
    inspectorBackend.registerType("CSS.CSSMedia", [{ "name": "text", "type": "string", "optional": false, "description": "Media query text.", "typeRef": null }, { "name": "source", "type": "string", "optional": false, "description": "Source of the media query: \\\"mediaRule\\\" if specified by a @media rule, \\\"importRule\\\" if specified by an @import rule, \\\"linkedSheet\\\" if specified by a \\\"media\\\" attribute in a linked stylesheet's LINK tag, \\\"inlineSheet\\\" if specified by a \\\"media\\\" attribute in an inline stylesheet's STYLE tag.", "typeRef": null }, { "name": "sourceURL", "type": "string", "optional": true, "description": "URL of the document containing the media query description.", "typeRef": null }, { "name": "range", "type": "object", "optional": true, "description": "The associated rule (@media or @import) header range in the enclosing stylesheet (if available).", "typeRef": "CSS.SourceRange" }, { "name": "styleSheetId", "type": "string", "optional": true, "description": "Identifier of the stylesheet containing this object (if exists).", "typeRef": "CSS.StyleSheetId" }, { "name": "mediaList", "type": "array", "optional": true, "description": "Array of media queries.", "typeRef": "CSS.MediaQuery" }]);
    inspectorBackend.registerType("CSS.MediaQuery", [{ "name": "expressions", "type": "array", "optional": false, "description": "Array of media query expressions.", "typeRef": "CSS.MediaQueryExpression" }, { "name": "active", "type": "boolean", "optional": false, "description": "Whether the media query condition is satisfied.", "typeRef": null }]);
    inspectorBackend.registerType("CSS.MediaQueryExpression", [{ "name": "value", "type": "number", "optional": false, "description": "Media query expression value.", "typeRef": null }, { "name": "unit", "type": "string", "optional": false, "description": "Media query expression units.", "typeRef": null }, { "name": "feature", "type": "string", "optional": false, "description": "Media query expression feature.", "typeRef": null }, { "name": "valueRange", "type": "object", "optional": true, "description": "The associated range of the value text in the enclosing stylesheet (if available).", "typeRef": "CSS.SourceRange" }, { "name": "computedLength", "type": "number", "optional": true, "description": "Computed length of media query expression (if applicable).", "typeRef": null }]);
    inspectorBackend.registerType("CSS.CSSContainerQuery", [{ "name": "text", "type": "string", "optional": false, "description": "Container query text.", "typeRef": null }, { "name": "range", "type": "object", "optional": true, "description": "The associated rule header range in the enclosing stylesheet (if available).", "typeRef": "CSS.SourceRange" }, { "name": "styleSheetId", "type": "string", "optional": true, "description": "Identifier of the stylesheet containing this object (if exists).", "typeRef": "CSS.StyleSheetId" }, { "name": "name", "type": "string", "optional": true, "description": "Optional name for the container.", "typeRef": null }, { "name": "physicalAxes", "type": "string", "optional": true, "description": "Optional physical axes queried for the container.", "typeRef": "DOM.PhysicalAxes" }, { "name": "logicalAxes", "type": "string", "optional": true, "description": "Optional logical axes queried for the container.", "typeRef": "DOM.LogicalAxes" }, { "name": "queriesScrollState", "type": "boolean", "optional": true, "description": "true if the query contains scroll-state() queries.", "typeRef": null }, { "name": "queriesAnchored", "type": "boolean", "optional": true, "description": "true if the query contains anchored() queries.", "typeRef": null }]);
    inspectorBackend.registerType("CSS.CSSSupports", [{ "name": "text", "type": "string", "optional": false, "description": "Supports rule text.", "typeRef": null }, { "name": "active", "type": "boolean", "optional": false, "description": "Whether the supports condition is satisfied.", "typeRef": null }, { "name": "range", "type": "object", "optional": true, "description": "The associated rule header range in the enclosing stylesheet (if available).", "typeRef": "CSS.SourceRange" }, { "name": "styleSheetId", "type": "string", "optional": true, "description": "Identifier of the stylesheet containing this object (if exists).", "typeRef": "CSS.StyleSheetId" }]);
    inspectorBackend.registerType("CSS.CSSScope", [{ "name": "text", "type": "string", "optional": false, "description": "Scope rule text.", "typeRef": null }, { "name": "range", "type": "object", "optional": true, "description": "The associated rule header range in the enclosing stylesheet (if available).", "typeRef": "CSS.SourceRange" }, { "name": "styleSheetId", "type": "string", "optional": true, "description": "Identifier of the stylesheet containing this object (if exists).", "typeRef": "CSS.StyleSheetId" }]);
    inspectorBackend.registerType("CSS.CSSLayer", [{ "name": "text", "type": "string", "optional": false, "description": "Layer name.", "typeRef": null }, { "name": "range", "type": "object", "optional": true, "description": "The associated rule header range in the enclosing stylesheet (if available).", "typeRef": "CSS.SourceRange" }, { "name": "styleSheetId", "type": "string", "optional": true, "description": "Identifier of the stylesheet containing this object (if exists).", "typeRef": "CSS.StyleSheetId" }]);
    inspectorBackend.registerType("CSS.CSSStartingStyle", [{ "name": "range", "type": "object", "optional": true, "description": "The associated rule header range in the enclosing stylesheet (if available).", "typeRef": "CSS.SourceRange" }, { "name": "styleSheetId", "type": "string", "optional": true, "description": "Identifier of the stylesheet containing this object (if exists).", "typeRef": "CSS.StyleSheetId" }]);
    inspectorBackend.registerType("CSS.CSSLayerData", [{ "name": "name", "type": "string", "optional": false, "description": "Layer name.", "typeRef": null }, { "name": "subLayers", "type": "array", "optional": true, "description": "Direct sub-layers", "typeRef": "CSS.CSSLayerData" }, { "name": "order", "type": "number", "optional": false, "description": "Layer order. The order determines the order of the layer in the cascade order. A higher number has higher priority in the cascade order.", "typeRef": null }]);
    inspectorBackend.registerType("CSS.PlatformFontUsage", [{ "name": "familyName", "type": "string", "optional": false, "description": "Font's family name reported by platform.", "typeRef": null }, { "name": "postScriptName", "type": "string", "optional": false, "description": "Font's PostScript name reported by platform.", "typeRef": null }, { "name": "isCustomFont", "type": "boolean", "optional": false, "description": "Indicates if the font was downloaded or resolved locally.", "typeRef": null }, { "name": "glyphCount", "type": "number", "optional": false, "description": "Amount of glyphs that were rendered with this font.", "typeRef": null }]);
    inspectorBackend.registerType("CSS.FontVariationAxis", [{ "name": "tag", "type": "string", "optional": false, "description": "The font-variation-setting tag (a.k.a. \\\"axis tag\\\").", "typeRef": null }, { "name": "name", "type": "string", "optional": false, "description": "Human-readable variation name in the default language (normally, \\\"en\\\").", "typeRef": null }, { "name": "minValue", "type": "number", "optional": false, "description": "The minimum value (inclusive) the font supports for this tag.", "typeRef": null }, { "name": "maxValue", "type": "number", "optional": false, "description": "The maximum value (inclusive) the font supports for this tag.", "typeRef": null }, { "name": "defaultValue", "type": "number", "optional": false, "description": "The default value.", "typeRef": null }]);
    inspectorBackend.registerType("CSS.FontFace", [{ "name": "fontFamily", "type": "string", "optional": false, "description": "The font-family.", "typeRef": null }, { "name": "fontStyle", "type": "string", "optional": false, "description": "The font-style.", "typeRef": null }, { "name": "fontVariant", "type": "string", "optional": false, "description": "The font-variant.", "typeRef": null }, { "name": "fontWeight", "type": "string", "optional": false, "description": "The font-weight.", "typeRef": null }, { "name": "fontStretch", "type": "string", "optional": false, "description": "The font-stretch.", "typeRef": null }, { "name": "fontDisplay", "type": "string", "optional": false, "description": "The font-display.", "typeRef": null }, { "name": "unicodeRange", "type": "string", "optional": false, "description": "The unicode-range.", "typeRef": null }, { "name": "src", "type": "string", "optional": false, "description": "The src.", "typeRef": null }, { "name": "platformFontFamily", "type": "string", "optional": false, "description": "The resolved platform font family", "typeRef": null }, { "name": "fontVariationAxes", "type": "array", "optional": true, "description": "Available variation settings (a.k.a. \\\"axes\\\").", "typeRef": "CSS.FontVariationAxis" }]);
    inspectorBackend.registerType("CSS.CSSTryRule", [{ "name": "styleSheetId", "type": "string", "optional": true, "description": "The css style sheet identifier (absent for user agent stylesheet and user-specified stylesheet rules) this rule came from.", "typeRef": "CSS.StyleSheetId" }, { "name": "origin", "type": "string", "optional": false, "description": "Parent stylesheet's origin.", "typeRef": "CSS.StyleSheetOrigin" }, { "name": "style", "type": "object", "optional": false, "description": "Associated style declaration.", "typeRef": "CSS.CSSStyle" }]);
    inspectorBackend.registerType("CSS.CSSPositionTryRule", [{ "name": "name", "type": "object", "optional": false, "description": "The prelude dashed-ident name", "typeRef": "CSS.Value" }, { "name": "styleSheetId", "type": "string", "optional": true, "description": "The css style sheet identifier (absent for user agent stylesheet and user-specified stylesheet rules) this rule came from.", "typeRef": "CSS.StyleSheetId" }, { "name": "origin", "type": "string", "optional": false, "description": "Parent stylesheet's origin.", "typeRef": "CSS.StyleSheetOrigin" }, { "name": "style", "type": "object", "optional": false, "description": "Associated style declaration.", "typeRef": "CSS.CSSStyle" }, { "name": "active", "type": "boolean", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("CSS.CSSKeyframesRule", [{ "name": "animationName", "type": "object", "optional": false, "description": "Animation name.", "typeRef": "CSS.Value" }, { "name": "keyframes", "type": "array", "optional": false, "description": "List of keyframes.", "typeRef": "CSS.CSSKeyframeRule" }]);
    inspectorBackend.registerType("CSS.CSSPropertyRegistration", [{ "name": "propertyName", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "initialValue", "type": "object", "optional": true, "description": "", "typeRef": "CSS.Value" }, { "name": "inherits", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "syntax", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("CSS.CSSFontPaletteValuesRule", [{ "name": "styleSheetId", "type": "string", "optional": true, "description": "The css style sheet identifier (absent for user agent stylesheet and user-specified stylesheet rules) this rule came from.", "typeRef": "CSS.StyleSheetId" }, { "name": "origin", "type": "string", "optional": false, "description": "Parent stylesheet's origin.", "typeRef": "CSS.StyleSheetOrigin" }, { "name": "fontPaletteName", "type": "object", "optional": false, "description": "Associated font palette name.", "typeRef": "CSS.Value" }, { "name": "style", "type": "object", "optional": false, "description": "Associated style declaration.", "typeRef": "CSS.CSSStyle" }]);
    inspectorBackend.registerType("CSS.CSSPropertyRule", [{ "name": "styleSheetId", "type": "string", "optional": true, "description": "The css style sheet identifier (absent for user agent stylesheet and user-specified stylesheet rules) this rule came from.", "typeRef": "CSS.StyleSheetId" }, { "name": "origin", "type": "string", "optional": false, "description": "Parent stylesheet's origin.", "typeRef": "CSS.StyleSheetOrigin" }, { "name": "propertyName", "type": "object", "optional": false, "description": "Associated property name.", "typeRef": "CSS.Value" }, { "name": "style", "type": "object", "optional": false, "description": "Associated style declaration.", "typeRef": "CSS.CSSStyle" }]);
    inspectorBackend.registerType("CSS.CSSFunctionParameter", [{ "name": "name", "type": "string", "optional": false, "description": "The parameter name.", "typeRef": null }, { "name": "type", "type": "string", "optional": false, "description": "The parameter type.", "typeRef": null }]);
    inspectorBackend.registerType("CSS.CSSFunctionConditionNode", [{ "name": "media", "type": "object", "optional": true, "description": "Media query for this conditional block. Only one type of condition should be set.", "typeRef": "CSS.CSSMedia" }, { "name": "containerQueries", "type": "object", "optional": true, "description": "Container query for this conditional block. Only one type of condition should be set.", "typeRef": "CSS.CSSContainerQuery" }, { "name": "supports", "type": "object", "optional": true, "description": "@supports CSS at-rule condition. Only one type of condition should be set.", "typeRef": "CSS.CSSSupports" }, { "name": "children", "type": "array", "optional": false, "description": "Block body.", "typeRef": "CSS.CSSFunctionNode" }, { "name": "conditionText", "type": "string", "optional": false, "description": "The condition text.", "typeRef": null }]);
    inspectorBackend.registerType("CSS.CSSFunctionNode", [{ "name": "condition", "type": "object", "optional": true, "description": "A conditional block. If set, style should not be set.", "typeRef": "CSS.CSSFunctionConditionNode" }, { "name": "style", "type": "object", "optional": true, "description": "Values set by this node. If set, condition should not be set.", "typeRef": "CSS.CSSStyle" }]);
    inspectorBackend.registerType("CSS.CSSFunctionRule", [{ "name": "name", "type": "object", "optional": false, "description": "Name of the function.", "typeRef": "CSS.Value" }, { "name": "styleSheetId", "type": "string", "optional": true, "description": "The css style sheet identifier (absent for user agent stylesheet and user-specified stylesheet rules) this rule came from.", "typeRef": "CSS.StyleSheetId" }, { "name": "origin", "type": "string", "optional": false, "description": "Parent stylesheet's origin.", "typeRef": "CSS.StyleSheetOrigin" }, { "name": "parameters", "type": "array", "optional": false, "description": "List of parameters.", "typeRef": "CSS.CSSFunctionParameter" }, { "name": "children", "type": "array", "optional": false, "description": "Function body.", "typeRef": "CSS.CSSFunctionNode" }]);
    inspectorBackend.registerType("CSS.CSSKeyframeRule", [{ "name": "styleSheetId", "type": "string", "optional": true, "description": "The css style sheet identifier (absent for user agent stylesheet and user-specified stylesheet rules) this rule came from.", "typeRef": "CSS.StyleSheetId" }, { "name": "origin", "type": "string", "optional": false, "description": "Parent stylesheet's origin.", "typeRef": "CSS.StyleSheetOrigin" }, { "name": "keyText", "type": "object", "optional": false, "description": "Associated key text.", "typeRef": "CSS.Value" }, { "name": "style", "type": "object", "optional": false, "description": "Associated style declaration.", "typeRef": "CSS.CSSStyle" }]);
    inspectorBackend.registerType("CSS.StyleDeclarationEdit", [{ "name": "styleSheetId", "type": "string", "optional": false, "description": "The css style sheet identifier.", "typeRef": "CSS.StyleSheetId" }, { "name": "range", "type": "object", "optional": false, "description": "The range of the style text in the enclosing stylesheet.", "typeRef": "CSS.SourceRange" }, { "name": "text", "type": "string", "optional": false, "description": "New style text.", "typeRef": null }]);
    // CacheStorage.
    inspectorBackend.registerEnum("CacheStorage.CachedResponseType", { Basic: "basic", Cors: "cors", Default: "default", Error: "error", OpaqueResponse: "opaqueResponse", OpaqueRedirect: "opaqueRedirect" });
    inspectorBackend.registerCommand("CacheStorage.deleteCache", [{ "name": "cacheId", "type": "string", "optional": false, "description": "Id of cache for deletion.", "typeRef": "CacheStorage.CacheId" }], [], "Deletes a cache.");
    inspectorBackend.registerCommand("CacheStorage.deleteEntry", [{ "name": "cacheId", "type": "string", "optional": false, "description": "Id of cache where the entry will be deleted.", "typeRef": "CacheStorage.CacheId" }, { "name": "request", "type": "string", "optional": false, "description": "URL spec of the request.", "typeRef": null }], [], "Deletes a cache entry.");
    inspectorBackend.registerCommand("CacheStorage.requestCacheNames", [{ "name": "securityOrigin", "type": "string", "optional": true, "description": "At least and at most one of securityOrigin, storageKey, storageBucket must be specified. Security origin.", "typeRef": null }, { "name": "storageKey", "type": "string", "optional": true, "description": "Storage key.", "typeRef": null }, { "name": "storageBucket", "type": "object", "optional": true, "description": "Storage bucket. If not specified, it uses the default bucket.", "typeRef": "Storage.StorageBucket" }], ["caches"], "Requests cache names.");
    inspectorBackend.registerCommand("CacheStorage.requestCachedResponse", [{ "name": "cacheId", "type": "string", "optional": false, "description": "Id of cache that contains the entry.", "typeRef": "CacheStorage.CacheId" }, { "name": "requestURL", "type": "string", "optional": false, "description": "URL spec of the request.", "typeRef": null }, { "name": "requestHeaders", "type": "array", "optional": false, "description": "headers of the request.", "typeRef": "CacheStorage.Header" }], ["response"], "Fetches cache entry.");
    inspectorBackend.registerCommand("CacheStorage.requestEntries", [{ "name": "cacheId", "type": "string", "optional": false, "description": "ID of cache to get entries from.", "typeRef": "CacheStorage.CacheId" }, { "name": "skipCount", "type": "number", "optional": true, "description": "Number of records to skip.", "typeRef": null }, { "name": "pageSize", "type": "number", "optional": true, "description": "Number of records to fetch.", "typeRef": null }, { "name": "pathFilter", "type": "string", "optional": true, "description": "If present, only return the entries containing this substring in the path", "typeRef": null }], ["cacheDataEntries", "returnCount"], "Requests data from cache.");
    inspectorBackend.registerType("CacheStorage.DataEntry", [{ "name": "requestURL", "type": "string", "optional": false, "description": "Request URL.", "typeRef": null }, { "name": "requestMethod", "type": "string", "optional": false, "description": "Request method.", "typeRef": null }, { "name": "requestHeaders", "type": "array", "optional": false, "description": "Request headers", "typeRef": "CacheStorage.Header" }, { "name": "responseTime", "type": "number", "optional": false, "description": "Number of seconds since epoch.", "typeRef": null }, { "name": "responseStatus", "type": "number", "optional": false, "description": "HTTP response status code.", "typeRef": null }, { "name": "responseStatusText", "type": "string", "optional": false, "description": "HTTP response status text.", "typeRef": null }, { "name": "responseType", "type": "string", "optional": false, "description": "HTTP response type", "typeRef": "CacheStorage.CachedResponseType" }, { "name": "responseHeaders", "type": "array", "optional": false, "description": "Response headers", "typeRef": "CacheStorage.Header" }]);
    inspectorBackend.registerType("CacheStorage.Cache", [{ "name": "cacheId", "type": "string", "optional": false, "description": "An opaque unique id of the cache.", "typeRef": "CacheStorage.CacheId" }, { "name": "securityOrigin", "type": "string", "optional": false, "description": "Security origin of the cache.", "typeRef": null }, { "name": "storageKey", "type": "string", "optional": false, "description": "Storage key of the cache.", "typeRef": null }, { "name": "storageBucket", "type": "object", "optional": true, "description": "Storage bucket of the cache.", "typeRef": "Storage.StorageBucket" }, { "name": "cacheName", "type": "string", "optional": false, "description": "The name of the cache.", "typeRef": null }]);
    inspectorBackend.registerType("CacheStorage.Header", [{ "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("CacheStorage.CachedResponse", [{ "name": "body", "type": "string", "optional": false, "description": "Entry content, base64-encoded.", "typeRef": null }]);
    // Cast.
    inspectorBackend.registerEvent("Cast.sinksUpdated", ["sinks"]);
    inspectorBackend.registerEvent("Cast.issueUpdated", ["issueMessage"]);
    inspectorBackend.registerCommand("Cast.enable", [{ "name": "presentationUrl", "type": "string", "optional": true, "description": "", "typeRef": null }], [], "Starts observing for sinks that can be used for tab mirroring, and if set, sinks compatible with |presentationUrl| as well. When sinks are found, a |sinksUpdated| event is fired. Also starts observing for issue messages. When an issue is added or removed, an |issueUpdated| event is fired.");
    inspectorBackend.registerCommand("Cast.disable", [], [], "Stops observing for sinks and issues.");
    inspectorBackend.registerCommand("Cast.setSinkToUse", [{ "name": "sinkName", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Sets a sink to be used when the web page requests the browser to choose a sink via Presentation API, Remote Playback API, or Cast SDK.");
    inspectorBackend.registerCommand("Cast.startDesktopMirroring", [{ "name": "sinkName", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Starts mirroring the desktop to the sink.");
    inspectorBackend.registerCommand("Cast.startTabMirroring", [{ "name": "sinkName", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Starts mirroring the tab to the sink.");
    inspectorBackend.registerCommand("Cast.stopCasting", [{ "name": "sinkName", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Stops the active Cast session on the sink.");
    inspectorBackend.registerType("Cast.Sink", [{ "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "id", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "session", "type": "string", "optional": true, "description": "Text describing the current session. Present only if there is an active session on the sink.", "typeRef": null }]);
    // DOM.
    inspectorBackend.registerEnum("DOM.PseudoType", { FirstLine: "first-line", FirstLetter: "first-letter", Checkmark: "checkmark", Before: "before", After: "after", PickerIcon: "picker-icon", InterestHint: "interest-hint", Marker: "marker", Backdrop: "backdrop", Column: "column", Selection: "selection", SearchText: "search-text", TargetText: "target-text", SpellingError: "spelling-error", GrammarError: "grammar-error", Highlight: "highlight", FirstLineInherited: "first-line-inherited", ScrollMarker: "scroll-marker", ScrollMarkerGroup: "scroll-marker-group", ScrollButton: "scroll-button", Scrollbar: "scrollbar", ScrollbarThumb: "scrollbar-thumb", ScrollbarButton: "scrollbar-button", ScrollbarTrack: "scrollbar-track", ScrollbarTrackPiece: "scrollbar-track-piece", ScrollbarCorner: "scrollbar-corner", Resizer: "resizer", InputListButton: "input-list-button", ViewTransition: "view-transition", ViewTransitionGroup: "view-transition-group", ViewTransitionImagePair: "view-transition-image-pair", ViewTransitionGroupChildren: "view-transition-group-children", ViewTransitionOld: "view-transition-old", ViewTransitionNew: "view-transition-new", Placeholder: "placeholder", FileSelectorButton: "file-selector-button", DetailsContent: "details-content", Picker: "picker", PermissionIcon: "permission-icon" });
    inspectorBackend.registerEnum("DOM.ShadowRootType", { UserAgent: "user-agent", Open: "open", Closed: "closed" });
    inspectorBackend.registerEnum("DOM.CompatibilityMode", { QuirksMode: "QuirksMode", LimitedQuirksMode: "LimitedQuirksMode", NoQuirksMode: "NoQuirksMode" });
    inspectorBackend.registerEnum("DOM.PhysicalAxes", { Horizontal: "Horizontal", Vertical: "Vertical", Both: "Both" });
    inspectorBackend.registerEnum("DOM.LogicalAxes", { Inline: "Inline", Block: "Block", Both: "Both" });
    inspectorBackend.registerEnum("DOM.ScrollOrientation", { Horizontal: "horizontal", Vertical: "vertical" });
    inspectorBackend.registerEvent("DOM.attributeModified", ["nodeId", "name", "value"]);
    inspectorBackend.registerEvent("DOM.attributeRemoved", ["nodeId", "name"]);
    inspectorBackend.registerEvent("DOM.characterDataModified", ["nodeId", "characterData"]);
    inspectorBackend.registerEvent("DOM.childNodeCountUpdated", ["nodeId", "childNodeCount"]);
    inspectorBackend.registerEvent("DOM.childNodeInserted", ["parentNodeId", "previousNodeId", "node"]);
    inspectorBackend.registerEvent("DOM.childNodeRemoved", ["parentNodeId", "nodeId"]);
    inspectorBackend.registerEvent("DOM.distributedNodesUpdated", ["insertionPointId", "distributedNodes"]);
    inspectorBackend.registerEvent("DOM.documentUpdated", []);
    inspectorBackend.registerEvent("DOM.inlineStyleInvalidated", ["nodeIds"]);
    inspectorBackend.registerEvent("DOM.pseudoElementAdded", ["parentId", "pseudoElement"]);
    inspectorBackend.registerEvent("DOM.topLayerElementsUpdated", []);
    inspectorBackend.registerEvent("DOM.scrollableFlagUpdated", ["nodeId", "isScrollable"]);
    inspectorBackend.registerEvent("DOM.affectedByStartingStylesFlagUpdated", ["nodeId", "affectedByStartingStyles"]);
    inspectorBackend.registerEvent("DOM.pseudoElementRemoved", ["parentId", "pseudoElementId"]);
    inspectorBackend.registerEvent("DOM.setChildNodes", ["parentId", "nodes"]);
    inspectorBackend.registerEvent("DOM.shadowRootPopped", ["hostId", "rootId"]);
    inspectorBackend.registerEvent("DOM.shadowRootPushed", ["hostId", "root"]);
    inspectorBackend.registerCommand("DOM.collectClassNamesFromSubtree", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to collect class names.", "typeRef": "DOM.NodeId" }], ["classNames"], "Collects class names for the node with given id and all of it's child nodes.");
    inspectorBackend.registerCommand("DOM.copyTo", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to copy.", "typeRef": "DOM.NodeId" }, { "name": "targetNodeId", "type": "number", "optional": false, "description": "Id of the element to drop the copy into.", "typeRef": "DOM.NodeId" }, { "name": "insertBeforeNodeId", "type": "number", "optional": true, "description": "Drop the copy before this node (if absent, the copy becomes the last child of `targetNodeId`).", "typeRef": "DOM.NodeId" }], ["nodeId"], "Creates a deep copy of the specified node and places it into the target container before the given anchor.");
    inspectorBackend.registerCommand("DOM.describeNode", [{ "name": "nodeId", "type": "number", "optional": true, "description": "Identifier of the node.", "typeRef": "DOM.NodeId" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "Identifier of the backend node.", "typeRef": "DOM.BackendNodeId" }, { "name": "objectId", "type": "string", "optional": true, "description": "JavaScript object id of the node wrapper.", "typeRef": "Runtime.RemoteObjectId" }, { "name": "depth", "type": "number", "optional": true, "description": "The maximum depth at which children should be retrieved, defaults to 1. Use -1 for the entire subtree or provide an integer larger than 0.", "typeRef": null }, { "name": "pierce", "type": "boolean", "optional": true, "description": "Whether or not iframes and shadow roots should be traversed when returning the subtree (default is false).", "typeRef": null }], ["node"], "Describes node given its id, does not require domain to be enabled. Does not start tracking any objects, can be used for automation.");
    inspectorBackend.registerCommand("DOM.scrollIntoViewIfNeeded", [{ "name": "nodeId", "type": "number", "optional": true, "description": "Identifier of the node.", "typeRef": "DOM.NodeId" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "Identifier of the backend node.", "typeRef": "DOM.BackendNodeId" }, { "name": "objectId", "type": "string", "optional": true, "description": "JavaScript object id of the node wrapper.", "typeRef": "Runtime.RemoteObjectId" }, { "name": "rect", "type": "object", "optional": true, "description": "The rect to be scrolled into view, relative to the node's border box, in CSS pixels. When omitted, center of the node will be used, similar to Element.scrollIntoView.", "typeRef": "DOM.Rect" }], [], "Scrolls the specified rect of the given node into view if not already visible. Note: exactly one between nodeId, backendNodeId and objectId should be passed to identify the node.");
    inspectorBackend.registerCommand("DOM.disable", [], [], "Disables DOM agent for the given page.");
    inspectorBackend.registerCommand("DOM.discardSearchResults", [{ "name": "searchId", "type": "string", "optional": false, "description": "Unique search session identifier.", "typeRef": null }], [], "Discards search results from the session with the given id. `getSearchResults` should no longer be called for that search.");
    inspectorBackend.registerEnum("DOM.EnableRequestIncludeWhitespace", { None: "none", All: "all" });
    inspectorBackend.registerCommand("DOM.enable", [{ "name": "includeWhitespace", "type": "string", "optional": true, "description": "Whether to include whitespaces in the children array of returned Nodes.", "typeRef": "DOM.EnableRequestIncludeWhitespace" }], [], "Enables DOM agent for the given page.");
    inspectorBackend.registerCommand("DOM.focus", [{ "name": "nodeId", "type": "number", "optional": true, "description": "Identifier of the node.", "typeRef": "DOM.NodeId" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "Identifier of the backend node.", "typeRef": "DOM.BackendNodeId" }, { "name": "objectId", "type": "string", "optional": true, "description": "JavaScript object id of the node wrapper.", "typeRef": "Runtime.RemoteObjectId" }], [], "Focuses the given element.");
    inspectorBackend.registerCommand("DOM.getAttributes", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to retrieve attributes for.", "typeRef": "DOM.NodeId" }], ["attributes"], "Returns attributes for the specified node.");
    inspectorBackend.registerCommand("DOM.getBoxModel", [{ "name": "nodeId", "type": "number", "optional": true, "description": "Identifier of the node.", "typeRef": "DOM.NodeId" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "Identifier of the backend node.", "typeRef": "DOM.BackendNodeId" }, { "name": "objectId", "type": "string", "optional": true, "description": "JavaScript object id of the node wrapper.", "typeRef": "Runtime.RemoteObjectId" }], ["model"], "Returns boxes for the given node.");
    inspectorBackend.registerCommand("DOM.getContentQuads", [{ "name": "nodeId", "type": "number", "optional": true, "description": "Identifier of the node.", "typeRef": "DOM.NodeId" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "Identifier of the backend node.", "typeRef": "DOM.BackendNodeId" }, { "name": "objectId", "type": "string", "optional": true, "description": "JavaScript object id of the node wrapper.", "typeRef": "Runtime.RemoteObjectId" }], ["quads"], "Returns quads that describe node position on the page. This method might return multiple quads for inline nodes.");
    inspectorBackend.registerCommand("DOM.getDocument", [{ "name": "depth", "type": "number", "optional": true, "description": "The maximum depth at which children should be retrieved, defaults to 1. Use -1 for the entire subtree or provide an integer larger than 0.", "typeRef": null }, { "name": "pierce", "type": "boolean", "optional": true, "description": "Whether or not iframes and shadow roots should be traversed when returning the subtree (default is false).", "typeRef": null }], ["root"], "Returns the root DOM node (and optionally the subtree) to the caller. Implicitly enables the DOM domain events for the current target.");
    inspectorBackend.registerCommand("DOM.getFlattenedDocument", [{ "name": "depth", "type": "number", "optional": true, "description": "The maximum depth at which children should be retrieved, defaults to 1. Use -1 for the entire subtree or provide an integer larger than 0.", "typeRef": null }, { "name": "pierce", "type": "boolean", "optional": true, "description": "Whether or not iframes and shadow roots should be traversed when returning the subtree (default is false).", "typeRef": null }], ["nodes"], "Returns the root DOM node (and optionally the subtree) to the caller. Deprecated, as it is not designed to work well with the rest of the DOM agent. Use DOMSnapshot.captureSnapshot instead.");
    inspectorBackend.registerCommand("DOM.getNodesForSubtreeByStyle", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Node ID pointing to the root of a subtree.", "typeRef": "DOM.NodeId" }, { "name": "computedStyles", "type": "array", "optional": false, "description": "The style to filter nodes by (includes nodes if any of properties matches).", "typeRef": "DOM.CSSComputedStyleProperty" }, { "name": "pierce", "type": "boolean", "optional": true, "description": "Whether or not iframes and shadow roots in the same target should be traversed when returning the results (default is false).", "typeRef": null }], ["nodeIds"], "Finds nodes with a given computed style in a subtree.");
    inspectorBackend.registerCommand("DOM.getNodeForLocation", [{ "name": "x", "type": "number", "optional": false, "description": "X coordinate.", "typeRef": null }, { "name": "y", "type": "number", "optional": false, "description": "Y coordinate.", "typeRef": null }, { "name": "includeUserAgentShadowDOM", "type": "boolean", "optional": true, "description": "False to skip to the nearest non-UA shadow root ancestor (default: false).", "typeRef": null }, { "name": "ignorePointerEventsNone", "type": "boolean", "optional": true, "description": "Whether to ignore pointer-events: none on elements and hit test them.", "typeRef": null }], ["backendNodeId", "frameId", "nodeId"], "Returns node id at given location. Depending on whether DOM domain is enabled, nodeId is either returned or not.");
    inspectorBackend.registerCommand("DOM.getOuterHTML", [{ "name": "nodeId", "type": "number", "optional": true, "description": "Identifier of the node.", "typeRef": "DOM.NodeId" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "Identifier of the backend node.", "typeRef": "DOM.BackendNodeId" }, { "name": "objectId", "type": "string", "optional": true, "description": "JavaScript object id of the node wrapper.", "typeRef": "Runtime.RemoteObjectId" }, { "name": "includeShadowDOM", "type": "boolean", "optional": true, "description": "Include all shadow roots. Equals to false if not specified.", "typeRef": null }], ["outerHTML"], "Returns node's HTML markup.");
    inspectorBackend.registerCommand("DOM.getRelayoutBoundary", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node.", "typeRef": "DOM.NodeId" }], ["nodeId"], "Returns the id of the nearest ancestor that is a relayout boundary.");
    inspectorBackend.registerCommand("DOM.getSearchResults", [{ "name": "searchId", "type": "string", "optional": false, "description": "Unique search session identifier.", "typeRef": null }, { "name": "fromIndex", "type": "number", "optional": false, "description": "Start index of the search result to be returned.", "typeRef": null }, { "name": "toIndex", "type": "number", "optional": false, "description": "End index of the search result to be returned.", "typeRef": null }], ["nodeIds"], "Returns search results from given `fromIndex` to given `toIndex` from the search with the given identifier.");
    inspectorBackend.registerCommand("DOM.hideHighlight", [], [], "Hides any highlight.");
    inspectorBackend.registerCommand("DOM.highlightNode", [], [], "Highlights DOM node.");
    inspectorBackend.registerCommand("DOM.highlightRect", [], [], "Highlights given rectangle.");
    inspectorBackend.registerCommand("DOM.markUndoableState", [], [], "Marks last undoable state.");
    inspectorBackend.registerCommand("DOM.moveTo", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to move.", "typeRef": "DOM.NodeId" }, { "name": "targetNodeId", "type": "number", "optional": false, "description": "Id of the element to drop the moved node into.", "typeRef": "DOM.NodeId" }, { "name": "insertBeforeNodeId", "type": "number", "optional": true, "description": "Drop node before this one (if absent, the moved node becomes the last child of `targetNodeId`).", "typeRef": "DOM.NodeId" }], ["nodeId"], "Moves node into the new container, places it before the given anchor.");
    inspectorBackend.registerCommand("DOM.performSearch", [{ "name": "query", "type": "string", "optional": false, "description": "Plain text or query selector or XPath search query.", "typeRef": null }, { "name": "includeUserAgentShadowDOM", "type": "boolean", "optional": true, "description": "True to search in user agent shadow DOM.", "typeRef": null }], ["searchId", "resultCount"], "Searches for a given string in the DOM tree. Use `getSearchResults` to access search results or `cancelSearch` to end this search session.");
    inspectorBackend.registerCommand("DOM.pushNodeByPathToFrontend", [{ "name": "path", "type": "string", "optional": false, "description": "Path to node in the proprietary format.", "typeRef": null }], ["nodeId"], "Requests that the node is sent to the caller given its path. // FIXME, use XPath");
    inspectorBackend.registerCommand("DOM.pushNodesByBackendIdsToFrontend", [{ "name": "backendNodeIds", "type": "array", "optional": false, "description": "The array of backend node ids.", "typeRef": "DOM.BackendNodeId" }], ["nodeIds"], "Requests that a batch of nodes is sent to the caller given their backend node ids.");
    inspectorBackend.registerCommand("DOM.querySelector", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to query upon.", "typeRef": "DOM.NodeId" }, { "name": "selector", "type": "string", "optional": false, "description": "Selector string.", "typeRef": null }], ["nodeId"], "Executes `querySelector` on a given node.");
    inspectorBackend.registerCommand("DOM.querySelectorAll", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to query upon.", "typeRef": "DOM.NodeId" }, { "name": "selector", "type": "string", "optional": false, "description": "Selector string.", "typeRef": null }], ["nodeIds"], "Executes `querySelectorAll` on a given node.");
    inspectorBackend.registerCommand("DOM.getTopLayerElements", [], ["nodeIds"], "Returns NodeIds of current top layer elements. Top layer is rendered closest to the user within a viewport, therefore its elements always appear on top of all other content.");
    inspectorBackend.registerEnum("DOM.GetElementByRelationRequestRelation", { PopoverTarget: "PopoverTarget", InterestTarget: "InterestTarget", CommandFor: "CommandFor" });
    inspectorBackend.registerCommand("DOM.getElementByRelation", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node from which to query the relation.", "typeRef": "DOM.NodeId" }, { "name": "relation", "type": "string", "optional": false, "description": "Type of relation to get.", "typeRef": "DOM.GetElementByRelationRequestRelation" }], ["nodeId"], "Returns the NodeId of the matched element according to certain relations.");
    inspectorBackend.registerCommand("DOM.redo", [], [], "Re-does the last undone action.");
    inspectorBackend.registerCommand("DOM.removeAttribute", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the element to remove attribute from.", "typeRef": "DOM.NodeId" }, { "name": "name", "type": "string", "optional": false, "description": "Name of the attribute to remove.", "typeRef": null }], [], "Removes attribute with given name from an element with given id.");
    inspectorBackend.registerCommand("DOM.removeNode", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to remove.", "typeRef": "DOM.NodeId" }], [], "Removes node with given id.");
    inspectorBackend.registerCommand("DOM.requestChildNodes", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to get children for.", "typeRef": "DOM.NodeId" }, { "name": "depth", "type": "number", "optional": true, "description": "The maximum depth at which children should be retrieved, defaults to 1. Use -1 for the entire subtree or provide an integer larger than 0.", "typeRef": null }, { "name": "pierce", "type": "boolean", "optional": true, "description": "Whether or not iframes and shadow roots should be traversed when returning the sub-tree (default is false).", "typeRef": null }], [], "Requests that children of the node with given id are returned to the caller in form of `setChildNodes` events where not only immediate children are retrieved, but all children down to the specified depth.");
    inspectorBackend.registerCommand("DOM.requestNode", [{ "name": "objectId", "type": "string", "optional": false, "description": "JavaScript object id to convert into node.", "typeRef": "Runtime.RemoteObjectId" }], ["nodeId"], "Requests that the node is sent to the caller given the JavaScript node object reference. All nodes that form the path from the node to the root are also sent to the client as a series of `setChildNodes` notifications.");
    inspectorBackend.registerCommand("DOM.resolveNode", [{ "name": "nodeId", "type": "number", "optional": true, "description": "Id of the node to resolve.", "typeRef": "DOM.NodeId" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "Backend identifier of the node to resolve.", "typeRef": "DOM.BackendNodeId" }, { "name": "objectGroup", "type": "string", "optional": true, "description": "Symbolic group name that can be used to release multiple objects.", "typeRef": null }, { "name": "executionContextId", "type": "number", "optional": true, "description": "Execution context in which to resolve the node.", "typeRef": "Runtime.ExecutionContextId" }], ["object"], "Resolves the JavaScript node object for a given NodeId or BackendNodeId.");
    inspectorBackend.registerCommand("DOM.setAttributeValue", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the element to set attribute for.", "typeRef": "DOM.NodeId" }, { "name": "name", "type": "string", "optional": false, "description": "Attribute name.", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "Attribute value.", "typeRef": null }], [], "Sets attribute for an element with given id.");
    inspectorBackend.registerCommand("DOM.setAttributesAsText", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the element to set attributes for.", "typeRef": "DOM.NodeId" }, { "name": "text", "type": "string", "optional": false, "description": "Text with a number of attributes. Will parse this text using HTML parser.", "typeRef": null }, { "name": "name", "type": "string", "optional": true, "description": "Attribute name to replace with new attributes derived from text in case text parsed successfully.", "typeRef": null }], [], "Sets attributes on element with given id. This method is useful when user edits some existing attribute value and types in several attribute name/value pairs.");
    inspectorBackend.registerCommand("DOM.setFileInputFiles", [{ "name": "files", "type": "array", "optional": false, "description": "Array of file paths to set.", "typeRef": "string" }, { "name": "nodeId", "type": "number", "optional": true, "description": "Identifier of the node.", "typeRef": "DOM.NodeId" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "Identifier of the backend node.", "typeRef": "DOM.BackendNodeId" }, { "name": "objectId", "type": "string", "optional": true, "description": "JavaScript object id of the node wrapper.", "typeRef": "Runtime.RemoteObjectId" }], [], "Sets files for the given file input element.");
    inspectorBackend.registerCommand("DOM.setNodeStackTracesEnabled", [{ "name": "enable", "type": "boolean", "optional": false, "description": "Enable or disable.", "typeRef": null }], [], "Sets if stack traces should be captured for Nodes. See `Node.getNodeStackTraces`. Default is disabled.");
    inspectorBackend.registerCommand("DOM.getNodeStackTraces", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to get stack traces for.", "typeRef": "DOM.NodeId" }], ["creation"], "Gets stack traces associated with a Node. As of now, only provides stack trace for Node creation.");
    inspectorBackend.registerCommand("DOM.getFileInfo", [{ "name": "objectId", "type": "string", "optional": false, "description": "JavaScript object id of the node wrapper.", "typeRef": "Runtime.RemoteObjectId" }], ["path"], "Returns file information for the given File wrapper.");
    inspectorBackend.registerCommand("DOM.getDetachedDomNodes", [], ["detachedNodes"], "Returns list of detached nodes");
    inspectorBackend.registerCommand("DOM.setInspectedNode", [{ "name": "nodeId", "type": "number", "optional": false, "description": "DOM node id to be accessible by means of $x command line API.", "typeRef": "DOM.NodeId" }], [], "Enables console to refer to the node with given id via $x (see Command Line API for more details $x functions).");
    inspectorBackend.registerCommand("DOM.setNodeName", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to set name for.", "typeRef": "DOM.NodeId" }, { "name": "name", "type": "string", "optional": false, "description": "New node's name.", "typeRef": null }], ["nodeId"], "Sets node name for a node with given id.");
    inspectorBackend.registerCommand("DOM.setNodeValue", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to set value for.", "typeRef": "DOM.NodeId" }, { "name": "value", "type": "string", "optional": false, "description": "New node's value.", "typeRef": null }], [], "Sets node value for a node with given id.");
    inspectorBackend.registerCommand("DOM.setOuterHTML", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to set markup for.", "typeRef": "DOM.NodeId" }, { "name": "outerHTML", "type": "string", "optional": false, "description": "Outer HTML markup to set.", "typeRef": null }], [], "Sets node HTML markup, returns new node id.");
    inspectorBackend.registerCommand("DOM.undo", [], [], "Undoes the last performed action.");
    inspectorBackend.registerCommand("DOM.getFrameOwner", [{ "name": "frameId", "type": "string", "optional": false, "description": "", "typeRef": "Page.FrameId" }], ["backendNodeId", "nodeId"], "Returns iframe node that owns iframe with the given domain.");
    inspectorBackend.registerCommand("DOM.getContainerForNode", [{ "name": "nodeId", "type": "number", "optional": false, "description": "", "typeRef": "DOM.NodeId" }, { "name": "containerName", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "physicalAxes", "type": "string", "optional": true, "description": "", "typeRef": "DOM.PhysicalAxes" }, { "name": "logicalAxes", "type": "string", "optional": true, "description": "", "typeRef": "DOM.LogicalAxes" }, { "name": "queriesScrollState", "type": "boolean", "optional": true, "description": "", "typeRef": null }, { "name": "queriesAnchored", "type": "boolean", "optional": true, "description": "", "typeRef": null }], ["nodeId"], "Returns the query container of the given node based on container query conditions: containerName, physical and logical axes, and whether it queries scroll-state or anchored elements. If no axes are provided and queriesScrollState is false, the style container is returned, which is the direct parent or the closest element with a matching container-name.");
    inspectorBackend.registerCommand("DOM.getQueryingDescendantsForContainer", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the container node to find querying descendants from.", "typeRef": "DOM.NodeId" }], ["nodeIds"], "Returns the descendants of a container query container that have container queries against this container.");
    inspectorBackend.registerCommand("DOM.getAnchorElement", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the positioned element from which to find the anchor.", "typeRef": "DOM.NodeId" }, { "name": "anchorSpecifier", "type": "string", "optional": true, "description": "An optional anchor specifier, as defined in https://www.w3.org/TR/css-anchor-position-1/#anchor-specifier. If not provided, it will return the implicit anchor element for the given positioned element.", "typeRef": null }], ["nodeId"], "Returns the target anchor element of the given anchor query according to https://www.w3.org/TR/css-anchor-position-1/#target.");
    inspectorBackend.registerCommand("DOM.forceShowPopover", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the popover HTMLElement", "typeRef": "DOM.NodeId" }, { "name": "enable", "type": "boolean", "optional": false, "description": "If true, opens the popover and keeps it open. If false, closes the popover if it was previously force-opened.", "typeRef": null }], ["nodeIds"], "When enabling, this API force-opens the popover identified by nodeId and keeps it open until disabled.");
    inspectorBackend.registerType("DOM.BackendNode", [{ "name": "nodeType", "type": "number", "optional": false, "description": "`Node`'s nodeType.", "typeRef": null }, { "name": "nodeName", "type": "string", "optional": false, "description": "`Node`'s nodeName.", "typeRef": null }, { "name": "backendNodeId", "type": "number", "optional": false, "description": "", "typeRef": "DOM.BackendNodeId" }]);
    inspectorBackend.registerType("DOM.Node", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Node identifier that is passed into the rest of the DOM messages as the `nodeId`. Backend will only push node with given `id` once. It is aware of all requested nodes and will only fire DOM events for nodes known to the client.", "typeRef": "DOM.NodeId" }, { "name": "parentId", "type": "number", "optional": true, "description": "The id of the parent node if any.", "typeRef": "DOM.NodeId" }, { "name": "backendNodeId", "type": "number", "optional": false, "description": "The BackendNodeId for this node.", "typeRef": "DOM.BackendNodeId" }, { "name": "nodeType", "type": "number", "optional": false, "description": "`Node`'s nodeType.", "typeRef": null }, { "name": "nodeName", "type": "string", "optional": false, "description": "`Node`'s nodeName.", "typeRef": null }, { "name": "localName", "type": "string", "optional": false, "description": "`Node`'s localName.", "typeRef": null }, { "name": "nodeValue", "type": "string", "optional": false, "description": "`Node`'s nodeValue.", "typeRef": null }, { "name": "childNodeCount", "type": "number", "optional": true, "description": "Child count for `Container` nodes.", "typeRef": null }, { "name": "children", "type": "array", "optional": true, "description": "Child nodes of this node when requested with children.", "typeRef": "DOM.Node" }, { "name": "attributes", "type": "array", "optional": true, "description": "Attributes of the `Element` node in the form of flat array `[name1, value1, name2, value2]`.", "typeRef": "string" }, { "name": "documentURL", "type": "string", "optional": true, "description": "Document URL that `Document` or `FrameOwner` node points to.", "typeRef": null }, { "name": "baseURL", "type": "string", "optional": true, "description": "Base URL that `Document` or `FrameOwner` node uses for URL completion.", "typeRef": null }, { "name": "publicId", "type": "string", "optional": true, "description": "`DocumentType`'s publicId.", "typeRef": null }, { "name": "systemId", "type": "string", "optional": true, "description": "`DocumentType`'s systemId.", "typeRef": null }, { "name": "internalSubset", "type": "string", "optional": true, "description": "`DocumentType`'s internalSubset.", "typeRef": null }, { "name": "xmlVersion", "type": "string", "optional": true, "description": "`Document`'s XML version in case of XML documents.", "typeRef": null }, { "name": "name", "type": "string", "optional": true, "description": "`Attr`'s name.", "typeRef": null }, { "name": "value", "type": "string", "optional": true, "description": "`Attr`'s value.", "typeRef": null }, { "name": "pseudoType", "type": "string", "optional": true, "description": "Pseudo element type for this node.", "typeRef": "DOM.PseudoType" }, { "name": "pseudoIdentifier", "type": "string", "optional": true, "description": "Pseudo element identifier for this node. Only present if there is a valid pseudoType.", "typeRef": null }, { "name": "shadowRootType", "type": "string", "optional": true, "description": "Shadow root type.", "typeRef": "DOM.ShadowRootType" }, { "name": "frameId", "type": "string", "optional": true, "description": "Frame ID for frame owner elements.", "typeRef": "Page.FrameId" }, { "name": "contentDocument", "type": "object", "optional": true, "description": "Content document for frame owner elements.", "typeRef": "DOM.Node" }, { "name": "shadowRoots", "type": "array", "optional": true, "description": "Shadow root list for given element host.", "typeRef": "DOM.Node" }, { "name": "templateContent", "type": "object", "optional": true, "description": "Content document fragment for template elements.", "typeRef": "DOM.Node" }, { "name": "pseudoElements", "type": "array", "optional": true, "description": "Pseudo elements associated with this node.", "typeRef": "DOM.Node" }, { "name": "importedDocument", "type": "object", "optional": true, "description": "Deprecated, as the HTML Imports API has been removed (crbug.com/937746). This property used to return the imported document for the HTMLImport links. The property is always undefined now.", "typeRef": "DOM.Node" }, { "name": "distributedNodes", "type": "array", "optional": true, "description": "Distributed nodes for given insertion point.", "typeRef": "DOM.BackendNode" }, { "name": "isSVG", "type": "boolean", "optional": true, "description": "Whether the node is SVG.", "typeRef": null }, { "name": "compatibilityMode", "type": "string", "optional": true, "description": "", "typeRef": "DOM.CompatibilityMode" }, { "name": "assignedSlot", "type": "object", "optional": true, "description": "", "typeRef": "DOM.BackendNode" }, { "name": "isScrollable", "type": "boolean", "optional": true, "description": "", "typeRef": null }, { "name": "affectedByStartingStyles", "type": "boolean", "optional": true, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("DOM.DetachedElementInfo", [{ "name": "treeNode", "type": "object", "optional": false, "description": "", "typeRef": "DOM.Node" }, { "name": "retainedNodeIds", "type": "array", "optional": false, "description": "", "typeRef": "DOM.NodeId" }]);
    inspectorBackend.registerType("DOM.RGBA", [{ "name": "r", "type": "number", "optional": false, "description": "The red component, in the [0-255] range.", "typeRef": null }, { "name": "g", "type": "number", "optional": false, "description": "The green component, in the [0-255] range.", "typeRef": null }, { "name": "b", "type": "number", "optional": false, "description": "The blue component, in the [0-255] range.", "typeRef": null }, { "name": "a", "type": "number", "optional": true, "description": "The alpha component, in the [0-1] range (default: 1).", "typeRef": null }]);
    inspectorBackend.registerType("DOM.Quad", [{ "name": "Quad", "type": "array", "optional": false, "description": "An array of quad vertices, x immediately followed by y for each point, points clock-wise.", "typeRef": "number" }]);
    inspectorBackend.registerType("DOM.BoxModel", [{ "name": "content", "type": "array", "optional": false, "description": "Content box", "typeRef": "DOM.Quad" }, { "name": "padding", "type": "array", "optional": false, "description": "Padding box", "typeRef": "DOM.Quad" }, { "name": "border", "type": "array", "optional": false, "description": "Border box", "typeRef": "DOM.Quad" }, { "name": "margin", "type": "array", "optional": false, "description": "Margin box", "typeRef": "DOM.Quad" }, { "name": "width", "type": "number", "optional": false, "description": "Node width", "typeRef": null }, { "name": "height", "type": "number", "optional": false, "description": "Node height", "typeRef": null }, { "name": "shapeOutside", "type": "object", "optional": true, "description": "Shape outside coordinates", "typeRef": "DOM.ShapeOutsideInfo" }]);
    inspectorBackend.registerType("DOM.ShapeOutsideInfo", [{ "name": "bounds", "type": "array", "optional": false, "description": "Shape bounds", "typeRef": "DOM.Quad" }, { "name": "shape", "type": "array", "optional": false, "description": "Shape coordinate details", "typeRef": "any" }, { "name": "marginShape", "type": "array", "optional": false, "description": "Margin shape bounds", "typeRef": "any" }]);
    inspectorBackend.registerType("DOM.Rect", [{ "name": "x", "type": "number", "optional": false, "description": "X coordinate", "typeRef": null }, { "name": "y", "type": "number", "optional": false, "description": "Y coordinate", "typeRef": null }, { "name": "width", "type": "number", "optional": false, "description": "Rectangle width", "typeRef": null }, { "name": "height", "type": "number", "optional": false, "description": "Rectangle height", "typeRef": null }]);
    inspectorBackend.registerType("DOM.CSSComputedStyleProperty", [{ "name": "name", "type": "string", "optional": false, "description": "Computed style property name.", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "Computed style property value.", "typeRef": null }]);
    // DOMDebugger.
    inspectorBackend.registerEnum("DOMDebugger.DOMBreakpointType", { SubtreeModified: "subtree-modified", AttributeModified: "attribute-modified", NodeRemoved: "node-removed" });
    inspectorBackend.registerEnum("DOMDebugger.CSPViolationType", { TrustedtypeSinkViolation: "trustedtype-sink-violation", TrustedtypePolicyViolation: "trustedtype-policy-violation" });
    inspectorBackend.registerCommand("DOMDebugger.getEventListeners", [{ "name": "objectId", "type": "string", "optional": false, "description": "Identifier of the object to return listeners for.", "typeRef": "Runtime.RemoteObjectId" }, { "name": "depth", "type": "number", "optional": true, "description": "The maximum depth at which Node children should be retrieved, defaults to 1. Use -1 for the entire subtree or provide an integer larger than 0.", "typeRef": null }, { "name": "pierce", "type": "boolean", "optional": true, "description": "Whether or not iframes and shadow roots should be traversed when returning the subtree (default is false). Reports listeners for all contexts if pierce is enabled.", "typeRef": null }], ["listeners"], "Returns event listeners of the given object.");
    inspectorBackend.registerCommand("DOMDebugger.removeDOMBreakpoint", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Identifier of the node to remove breakpoint from.", "typeRef": "DOM.NodeId" }, { "name": "type", "type": "string", "optional": false, "description": "Type of the breakpoint to remove.", "typeRef": "DOMDebugger.DOMBreakpointType" }], [], "Removes DOM breakpoint that was set using `setDOMBreakpoint`.");
    inspectorBackend.registerCommand("DOMDebugger.removeEventListenerBreakpoint", [{ "name": "eventName", "type": "string", "optional": false, "description": "Event name.", "typeRef": null }, { "name": "targetName", "type": "string", "optional": true, "description": "EventTarget interface name.", "typeRef": null }], [], "Removes breakpoint on particular DOM event.");
    inspectorBackend.registerCommand("DOMDebugger.removeInstrumentationBreakpoint", [{ "name": "eventName", "type": "string", "optional": false, "description": "Instrumentation name to stop on.", "typeRef": null }], [], "Removes breakpoint on particular native event.");
    inspectorBackend.registerCommand("DOMDebugger.removeXHRBreakpoint", [{ "name": "url", "type": "string", "optional": false, "description": "Resource URL substring.", "typeRef": null }], [], "Removes breakpoint from XMLHttpRequest.");
    inspectorBackend.registerCommand("DOMDebugger.setBreakOnCSPViolation", [{ "name": "violationTypes", "type": "array", "optional": false, "description": "CSP Violations to stop upon.", "typeRef": "DOMDebugger.CSPViolationType" }], [], "Sets breakpoint on particular CSP violations.");
    inspectorBackend.registerCommand("DOMDebugger.setDOMBreakpoint", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Identifier of the node to set breakpoint on.", "typeRef": "DOM.NodeId" }, { "name": "type", "type": "string", "optional": false, "description": "Type of the operation to stop upon.", "typeRef": "DOMDebugger.DOMBreakpointType" }], [], "Sets breakpoint on particular operation with DOM.");
    inspectorBackend.registerCommand("DOMDebugger.setEventListenerBreakpoint", [{ "name": "eventName", "type": "string", "optional": false, "description": "DOM Event name to stop on (any DOM event will do).", "typeRef": null }, { "name": "targetName", "type": "string", "optional": true, "description": "EventTarget interface name to stop on. If equal to `\\\"*\\\"` or not provided, will stop on any EventTarget.", "typeRef": null }], [], "Sets breakpoint on particular DOM event.");
    inspectorBackend.registerCommand("DOMDebugger.setInstrumentationBreakpoint", [{ "name": "eventName", "type": "string", "optional": false, "description": "Instrumentation name to stop on.", "typeRef": null }], [], "Sets breakpoint on particular native event.");
    inspectorBackend.registerCommand("DOMDebugger.setXHRBreakpoint", [{ "name": "url", "type": "string", "optional": false, "description": "Resource URL substring. All XHRs having this substring in the URL will get stopped upon.", "typeRef": null }], [], "Sets breakpoint on XMLHttpRequest.");
    inspectorBackend.registerType("DOMDebugger.EventListener", [{ "name": "type", "type": "string", "optional": false, "description": "`EventListener`'s type.", "typeRef": null }, { "name": "useCapture", "type": "boolean", "optional": false, "description": "`EventListener`'s useCapture.", "typeRef": null }, { "name": "passive", "type": "boolean", "optional": false, "description": "`EventListener`'s passive flag.", "typeRef": null }, { "name": "once", "type": "boolean", "optional": false, "description": "`EventListener`'s once flag.", "typeRef": null }, { "name": "scriptId", "type": "string", "optional": false, "description": "Script id of the handler code.", "typeRef": "Runtime.ScriptId" }, { "name": "lineNumber", "type": "number", "optional": false, "description": "Line number in the script (0-based).", "typeRef": null }, { "name": "columnNumber", "type": "number", "optional": false, "description": "Column number in the script (0-based).", "typeRef": null }, { "name": "handler", "type": "object", "optional": true, "description": "Event handler function value.", "typeRef": "Runtime.RemoteObject" }, { "name": "originalHandler", "type": "object", "optional": true, "description": "Event original handler function value.", "typeRef": "Runtime.RemoteObject" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "Node the listener is added to (if any).", "typeRef": "DOM.BackendNodeId" }]);
    // DOMSnapshot.
    inspectorBackend.registerCommand("DOMSnapshot.disable", [], [], "Disables DOM snapshot agent for the given page.");
    inspectorBackend.registerCommand("DOMSnapshot.enable", [], [], "Enables DOM snapshot agent for the given page.");
    inspectorBackend.registerCommand("DOMSnapshot.getSnapshot", [{ "name": "computedStyleWhitelist", "type": "array", "optional": false, "description": "Whitelist of computed styles to return.", "typeRef": "string" }, { "name": "includeEventListeners", "type": "boolean", "optional": true, "description": "Whether or not to retrieve details of DOM listeners (default false).", "typeRef": null }, { "name": "includePaintOrder", "type": "boolean", "optional": true, "description": "Whether to determine and include the paint order index of LayoutTreeNodes (default false).", "typeRef": null }, { "name": "includeUserAgentShadowTree", "type": "boolean", "optional": true, "description": "Whether to include UA shadow tree in the snapshot (default false).", "typeRef": null }], ["domNodes", "layoutTreeNodes", "computedStyles"], "Returns a document snapshot, including the full DOM tree of the root node (including iframes, template contents, and imported documents) in a flattened array, as well as layout and white-listed computed style information for the nodes. Shadow DOM in the returned DOM tree is flattened.");
    inspectorBackend.registerCommand("DOMSnapshot.captureSnapshot", [{ "name": "computedStyles", "type": "array", "optional": false, "description": "Whitelist of computed styles to return.", "typeRef": "string" }, { "name": "includePaintOrder", "type": "boolean", "optional": true, "description": "Whether to include layout object paint orders into the snapshot.", "typeRef": null }, { "name": "includeDOMRects", "type": "boolean", "optional": true, "description": "Whether to include DOM rectangles (offsetRects, clientRects, scrollRects) into the snapshot", "typeRef": null }, { "name": "includeBlendedBackgroundColors", "type": "boolean", "optional": true, "description": "Whether to include blended background colors in the snapshot (default: false). Blended background color is achieved by blending background colors of all elements that overlap with the current element.", "typeRef": null }, { "name": "includeTextColorOpacities", "type": "boolean", "optional": true, "description": "Whether to include text color opacity in the snapshot (default: false). An element might have the opacity property set that affects the text color of the element. The final text color opacity is computed based on the opacity of all overlapping elements.", "typeRef": null }], ["documents", "strings"], "Returns a document snapshot, including the full DOM tree of the root node (including iframes, template contents, and imported documents) in a flattened array, as well as layout and white-listed computed style information for the nodes. Shadow DOM in the returned DOM tree is flattened.");
    inspectorBackend.registerType("DOMSnapshot.DOMNode", [{ "name": "nodeType", "type": "number", "optional": false, "description": "`Node`'s nodeType.", "typeRef": null }, { "name": "nodeName", "type": "string", "optional": false, "description": "`Node`'s nodeName.", "typeRef": null }, { "name": "nodeValue", "type": "string", "optional": false, "description": "`Node`'s nodeValue.", "typeRef": null }, { "name": "textValue", "type": "string", "optional": true, "description": "Only set for textarea elements, contains the text value.", "typeRef": null }, { "name": "inputValue", "type": "string", "optional": true, "description": "Only set for input elements, contains the input's associated text value.", "typeRef": null }, { "name": "inputChecked", "type": "boolean", "optional": true, "description": "Only set for radio and checkbox input elements, indicates if the element has been checked", "typeRef": null }, { "name": "optionSelected", "type": "boolean", "optional": true, "description": "Only set for option elements, indicates if the element has been selected", "typeRef": null }, { "name": "backendNodeId", "type": "number", "optional": false, "description": "`Node`'s id, corresponds to DOM.Node.backendNodeId.", "typeRef": "DOM.BackendNodeId" }, { "name": "childNodeIndexes", "type": "array", "optional": true, "description": "The indexes of the node's child nodes in the `domNodes` array returned by `getSnapshot`, if any.", "typeRef": "integer" }, { "name": "attributes", "type": "array", "optional": true, "description": "Attributes of an `Element` node.", "typeRef": "DOMSnapshot.NameValue" }, { "name": "pseudoElementIndexes", "type": "array", "optional": true, "description": "Indexes of pseudo elements associated with this node in the `domNodes` array returned by `getSnapshot`, if any.", "typeRef": "integer" }, { "name": "layoutNodeIndex", "type": "number", "optional": true, "description": "The index of the node's related layout tree node in the `layoutTreeNodes` array returned by `getSnapshot`, if any.", "typeRef": null }, { "name": "documentURL", "type": "string", "optional": true, "description": "Document URL that `Document` or `FrameOwner` node points to.", "typeRef": null }, { "name": "baseURL", "type": "string", "optional": true, "description": "Base URL that `Document` or `FrameOwner` node uses for URL completion.", "typeRef": null }, { "name": "contentLanguage", "type": "string", "optional": true, "description": "Only set for documents, contains the document's content language.", "typeRef": null }, { "name": "documentEncoding", "type": "string", "optional": true, "description": "Only set for documents, contains the document's character set encoding.", "typeRef": null }, { "name": "publicId", "type": "string", "optional": true, "description": "`DocumentType` node's publicId.", "typeRef": null }, { "name": "systemId", "type": "string", "optional": true, "description": "`DocumentType` node's systemId.", "typeRef": null }, { "name": "frameId", "type": "string", "optional": true, "description": "Frame ID for frame owner elements and also for the document node.", "typeRef": "Page.FrameId" }, { "name": "contentDocumentIndex", "type": "number", "optional": true, "description": "The index of a frame owner element's content document in the `domNodes` array returned by `getSnapshot`, if any.", "typeRef": null }, { "name": "pseudoType", "type": "string", "optional": true, "description": "Type of a pseudo element node.", "typeRef": "DOM.PseudoType" }, { "name": "shadowRootType", "type": "string", "optional": true, "description": "Shadow root type.", "typeRef": "DOM.ShadowRootType" }, { "name": "isClickable", "type": "boolean", "optional": true, "description": "Whether this DOM node responds to mouse clicks. This includes nodes that have had click event listeners attached via JavaScript as well as anchor tags that naturally navigate when clicked.", "typeRef": null }, { "name": "eventListeners", "type": "array", "optional": true, "description": "Details of the node's event listeners, if any.", "typeRef": "DOMDebugger.EventListener" }, { "name": "currentSourceURL", "type": "string", "optional": true, "description": "The selected url for nodes with a srcset attribute.", "typeRef": null }, { "name": "originURL", "type": "string", "optional": true, "description": "The url of the script (if any) that generates this node.", "typeRef": null }, { "name": "scrollOffsetX", "type": "number", "optional": true, "description": "Scroll offsets, set when this node is a Document.", "typeRef": null }, { "name": "scrollOffsetY", "type": "number", "optional": true, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("DOMSnapshot.InlineTextBox", [{ "name": "boundingBox", "type": "object", "optional": false, "description": "The bounding box in document coordinates. Note that scroll offset of the document is ignored.", "typeRef": "DOM.Rect" }, { "name": "startCharacterIndex", "type": "number", "optional": false, "description": "The starting index in characters, for this post layout textbox substring. Characters that would be represented as a surrogate pair in UTF-16 have length 2.", "typeRef": null }, { "name": "numCharacters", "type": "number", "optional": false, "description": "The number of characters in this post layout textbox substring. Characters that would be represented as a surrogate pair in UTF-16 have length 2.", "typeRef": null }]);
    inspectorBackend.registerType("DOMSnapshot.LayoutTreeNode", [{ "name": "domNodeIndex", "type": "number", "optional": false, "description": "The index of the related DOM node in the `domNodes` array returned by `getSnapshot`.", "typeRef": null }, { "name": "boundingBox", "type": "object", "optional": false, "description": "The bounding box in document coordinates. Note that scroll offset of the document is ignored.", "typeRef": "DOM.Rect" }, { "name": "layoutText", "type": "string", "optional": true, "description": "Contents of the LayoutText, if any.", "typeRef": null }, { "name": "inlineTextNodes", "type": "array", "optional": true, "description": "The post-layout inline text nodes, if any.", "typeRef": "DOMSnapshot.InlineTextBox" }, { "name": "styleIndex", "type": "number", "optional": true, "description": "Index into the `computedStyles` array returned by `getSnapshot`.", "typeRef": null }, { "name": "paintOrder", "type": "number", "optional": true, "description": "Global paint order index, which is determined by the stacking order of the nodes. Nodes that are painted together will have the same index. Only provided if includePaintOrder in getSnapshot was true.", "typeRef": null }, { "name": "isStackingContext", "type": "boolean", "optional": true, "description": "Set to true to indicate the element begins a new stacking context.", "typeRef": null }]);
    inspectorBackend.registerType("DOMSnapshot.ComputedStyle", [{ "name": "properties", "type": "array", "optional": false, "description": "Name/value pairs of computed style properties.", "typeRef": "DOMSnapshot.NameValue" }]);
    inspectorBackend.registerType("DOMSnapshot.NameValue", [{ "name": "name", "type": "string", "optional": false, "description": "Attribute/property name.", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "Attribute/property value.", "typeRef": null }]);
    inspectorBackend.registerType("DOMSnapshot.ArrayOfStrings", [{ "name": "ArrayOfStrings", "type": "array", "optional": false, "description": "Index of the string in the strings table.", "typeRef": "DOMSnapshot.StringIndex" }]);
    inspectorBackend.registerType("DOMSnapshot.RareStringData", [{ "name": "index", "type": "array", "optional": false, "description": "", "typeRef": "integer" }, { "name": "value", "type": "array", "optional": false, "description": "", "typeRef": "DOMSnapshot.StringIndex" }]);
    inspectorBackend.registerType("DOMSnapshot.RareBooleanData", [{ "name": "index", "type": "array", "optional": false, "description": "", "typeRef": "integer" }]);
    inspectorBackend.registerType("DOMSnapshot.RareIntegerData", [{ "name": "index", "type": "array", "optional": false, "description": "", "typeRef": "integer" }, { "name": "value", "type": "array", "optional": false, "description": "", "typeRef": "integer" }]);
    inspectorBackend.registerType("DOMSnapshot.Rectangle", [{ "name": "Rectangle", "type": "array", "optional": false, "description": "", "typeRef": "number" }]);
    inspectorBackend.registerType("DOMSnapshot.DocumentSnapshot", [{ "name": "documentURL", "type": "number", "optional": false, "description": "Document URL that `Document` or `FrameOwner` node points to.", "typeRef": "DOMSnapshot.StringIndex" }, { "name": "title", "type": "number", "optional": false, "description": "Document title.", "typeRef": "DOMSnapshot.StringIndex" }, { "name": "baseURL", "type": "number", "optional": false, "description": "Base URL that `Document` or `FrameOwner` node uses for URL completion.", "typeRef": "DOMSnapshot.StringIndex" }, { "name": "contentLanguage", "type": "number", "optional": false, "description": "Contains the document's content language.", "typeRef": "DOMSnapshot.StringIndex" }, { "name": "encodingName", "type": "number", "optional": false, "description": "Contains the document's character set encoding.", "typeRef": "DOMSnapshot.StringIndex" }, { "name": "publicId", "type": "number", "optional": false, "description": "`DocumentType` node's publicId.", "typeRef": "DOMSnapshot.StringIndex" }, { "name": "systemId", "type": "number", "optional": false, "description": "`DocumentType` node's systemId.", "typeRef": "DOMSnapshot.StringIndex" }, { "name": "frameId", "type": "number", "optional": false, "description": "Frame ID for frame owner elements and also for the document node.", "typeRef": "DOMSnapshot.StringIndex" }, { "name": "nodes", "type": "object", "optional": false, "description": "A table with dom nodes.", "typeRef": "DOMSnapshot.NodeTreeSnapshot" }, { "name": "layout", "type": "object", "optional": false, "description": "The nodes in the layout tree.", "typeRef": "DOMSnapshot.LayoutTreeSnapshot" }, { "name": "textBoxes", "type": "object", "optional": false, "description": "The post-layout inline text nodes.", "typeRef": "DOMSnapshot.TextBoxSnapshot" }, { "name": "scrollOffsetX", "type": "number", "optional": true, "description": "Horizontal scroll offset.", "typeRef": null }, { "name": "scrollOffsetY", "type": "number", "optional": true, "description": "Vertical scroll offset.", "typeRef": null }, { "name": "contentWidth", "type": "number", "optional": true, "description": "Document content width.", "typeRef": null }, { "name": "contentHeight", "type": "number", "optional": true, "description": "Document content height.", "typeRef": null }]);
    inspectorBackend.registerType("DOMSnapshot.NodeTreeSnapshot", [{ "name": "parentIndex", "type": "array", "optional": true, "description": "Parent node index.", "typeRef": "integer" }, { "name": "nodeType", "type": "array", "optional": true, "description": "`Node`'s nodeType.", "typeRef": "integer" }, { "name": "shadowRootType", "type": "object", "optional": true, "description": "Type of the shadow root the `Node` is in. String values are equal to the `ShadowRootType` enum.", "typeRef": "DOMSnapshot.RareStringData" }, { "name": "nodeName", "type": "array", "optional": true, "description": "`Node`'s nodeName.", "typeRef": "DOMSnapshot.StringIndex" }, { "name": "nodeValue", "type": "array", "optional": true, "description": "`Node`'s nodeValue.", "typeRef": "DOMSnapshot.StringIndex" }, { "name": "backendNodeId", "type": "array", "optional": true, "description": "`Node`'s id, corresponds to DOM.Node.backendNodeId.", "typeRef": "DOM.BackendNodeId" }, { "name": "attributes", "type": "array", "optional": true, "description": "Attributes of an `Element` node. Flatten name, value pairs.", "typeRef": "DOMSnapshot.ArrayOfStrings" }, { "name": "textValue", "type": "object", "optional": true, "description": "Only set for textarea elements, contains the text value.", "typeRef": "DOMSnapshot.RareStringData" }, { "name": "inputValue", "type": "object", "optional": true, "description": "Only set for input elements, contains the input's associated text value.", "typeRef": "DOMSnapshot.RareStringData" }, { "name": "inputChecked", "type": "object", "optional": true, "description": "Only set for radio and checkbox input elements, indicates if the element has been checked", "typeRef": "DOMSnapshot.RareBooleanData" }, { "name": "optionSelected", "type": "object", "optional": true, "description": "Only set for option elements, indicates if the element has been selected", "typeRef": "DOMSnapshot.RareBooleanData" }, { "name": "contentDocumentIndex", "type": "object", "optional": true, "description": "The index of the document in the list of the snapshot documents.", "typeRef": "DOMSnapshot.RareIntegerData" }, { "name": "pseudoType", "type": "object", "optional": true, "description": "Type of a pseudo element node.", "typeRef": "DOMSnapshot.RareStringData" }, { "name": "pseudoIdentifier", "type": "object", "optional": true, "description": "Pseudo element identifier for this node. Only present if there is a valid pseudoType.", "typeRef": "DOMSnapshot.RareStringData" }, { "name": "isClickable", "type": "object", "optional": true, "description": "Whether this DOM node responds to mouse clicks. This includes nodes that have had click event listeners attached via JavaScript as well as anchor tags that naturally navigate when clicked.", "typeRef": "DOMSnapshot.RareBooleanData" }, { "name": "currentSourceURL", "type": "object", "optional": true, "description": "The selected url for nodes with a srcset attribute.", "typeRef": "DOMSnapshot.RareStringData" }, { "name": "originURL", "type": "object", "optional": true, "description": "The url of the script (if any) that generates this node.", "typeRef": "DOMSnapshot.RareStringData" }]);
    inspectorBackend.registerType("DOMSnapshot.LayoutTreeSnapshot", [{ "name": "nodeIndex", "type": "array", "optional": false, "description": "Index of the corresponding node in the `NodeTreeSnapshot` array returned by `captureSnapshot`.", "typeRef": "integer" }, { "name": "styles", "type": "array", "optional": false, "description": "Array of indexes specifying computed style strings, filtered according to the `computedStyles` parameter passed to `captureSnapshot`.", "typeRef": "DOMSnapshot.ArrayOfStrings" }, { "name": "bounds", "type": "array", "optional": false, "description": "The absolute position bounding box.", "typeRef": "DOMSnapshot.Rectangle" }, { "name": "text", "type": "array", "optional": false, "description": "Contents of the LayoutText, if any.", "typeRef": "DOMSnapshot.StringIndex" }, { "name": "stackingContexts", "type": "object", "optional": false, "description": "Stacking context information.", "typeRef": "DOMSnapshot.RareBooleanData" }, { "name": "paintOrders", "type": "array", "optional": true, "description": "Global paint order index, which is determined by the stacking order of the nodes. Nodes that are painted together will have the same index. Only provided if includePaintOrder in captureSnapshot was true.", "typeRef": "integer" }, { "name": "offsetRects", "type": "array", "optional": true, "description": "The offset rect of nodes. Only available when includeDOMRects is set to true", "typeRef": "DOMSnapshot.Rectangle" }, { "name": "scrollRects", "type": "array", "optional": true, "description": "The scroll rect of nodes. Only available when includeDOMRects is set to true", "typeRef": "DOMSnapshot.Rectangle" }, { "name": "clientRects", "type": "array", "optional": true, "description": "The client rect of nodes. Only available when includeDOMRects is set to true", "typeRef": "DOMSnapshot.Rectangle" }, { "name": "blendedBackgroundColors", "type": "array", "optional": true, "description": "The list of background colors that are blended with colors of overlapping elements.", "typeRef": "DOMSnapshot.StringIndex" }, { "name": "textColorOpacities", "type": "array", "optional": true, "description": "The list of computed text opacities.", "typeRef": "number" }]);
    inspectorBackend.registerType("DOMSnapshot.TextBoxSnapshot", [{ "name": "layoutIndex", "type": "array", "optional": false, "description": "Index of the layout tree node that owns this box collection.", "typeRef": "integer" }, { "name": "bounds", "type": "array", "optional": false, "description": "The absolute position bounding box.", "typeRef": "DOMSnapshot.Rectangle" }, { "name": "start", "type": "array", "optional": false, "description": "The starting index in characters, for this post layout textbox substring. Characters that would be represented as a surrogate pair in UTF-16 have length 2.", "typeRef": "integer" }, { "name": "length", "type": "array", "optional": false, "description": "The number of characters in this post layout textbox substring. Characters that would be represented as a surrogate pair in UTF-16 have length 2.", "typeRef": "integer" }]);
    // DOMStorage.
    inspectorBackend.registerEvent("DOMStorage.domStorageItemAdded", ["storageId", "key", "newValue"]);
    inspectorBackend.registerEvent("DOMStorage.domStorageItemRemoved", ["storageId", "key"]);
    inspectorBackend.registerEvent("DOMStorage.domStorageItemUpdated", ["storageId", "key", "oldValue", "newValue"]);
    inspectorBackend.registerEvent("DOMStorage.domStorageItemsCleared", ["storageId"]);
    inspectorBackend.registerCommand("DOMStorage.clear", [{ "name": "storageId", "type": "object", "optional": false, "description": "", "typeRef": "DOMStorage.StorageId" }], [], "");
    inspectorBackend.registerCommand("DOMStorage.disable", [], [], "Disables storage tracking, prevents storage events from being sent to the client.");
    inspectorBackend.registerCommand("DOMStorage.enable", [], [], "Enables storage tracking, storage events will now be delivered to the client.");
    inspectorBackend.registerCommand("DOMStorage.getDOMStorageItems", [{ "name": "storageId", "type": "object", "optional": false, "description": "", "typeRef": "DOMStorage.StorageId" }], ["entries"], "");
    inspectorBackend.registerCommand("DOMStorage.removeDOMStorageItem", [{ "name": "storageId", "type": "object", "optional": false, "description": "", "typeRef": "DOMStorage.StorageId" }, { "name": "key", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("DOMStorage.setDOMStorageItem", [{ "name": "storageId", "type": "object", "optional": false, "description": "", "typeRef": "DOMStorage.StorageId" }, { "name": "key", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerType("DOMStorage.StorageId", [{ "name": "securityOrigin", "type": "string", "optional": true, "description": "Security origin for the storage.", "typeRef": null }, { "name": "storageKey", "type": "string", "optional": true, "description": "Represents a key by which DOM Storage keys its CachedStorageAreas", "typeRef": "DOMStorage.SerializedStorageKey" }, { "name": "isLocalStorage", "type": "boolean", "optional": false, "description": "Whether the storage is local storage (not session storage).", "typeRef": null }]);
    inspectorBackend.registerType("DOMStorage.Item", [{ "name": "Item", "type": "array", "optional": false, "description": "DOM Storage item.", "typeRef": "string" }]);
    // DeviceAccess.
    inspectorBackend.registerEvent("DeviceAccess.deviceRequestPrompted", ["id", "devices"]);
    inspectorBackend.registerCommand("DeviceAccess.enable", [], [], "Enable events in this domain.");
    inspectorBackend.registerCommand("DeviceAccess.disable", [], [], "Disable events in this domain.");
    inspectorBackend.registerCommand("DeviceAccess.selectPrompt", [{ "name": "id", "type": "string", "optional": false, "description": "", "typeRef": "DeviceAccess.RequestId" }, { "name": "deviceId", "type": "string", "optional": false, "description": "", "typeRef": "DeviceAccess.DeviceId" }], [], "Select a device in response to a DeviceAccess.deviceRequestPrompted event.");
    inspectorBackend.registerCommand("DeviceAccess.cancelPrompt", [{ "name": "id", "type": "string", "optional": false, "description": "", "typeRef": "DeviceAccess.RequestId" }], [], "Cancel a prompt in response to a DeviceAccess.deviceRequestPrompted event.");
    inspectorBackend.registerType("DeviceAccess.PromptDevice", [{ "name": "id", "type": "string", "optional": false, "description": "", "typeRef": "DeviceAccess.DeviceId" }, { "name": "name", "type": "string", "optional": false, "description": "Display name as it appears in a device request user prompt.", "typeRef": null }]);
    // DeviceOrientation.
    inspectorBackend.registerCommand("DeviceOrientation.clearDeviceOrientationOverride", [], [], "Clears the overridden Device Orientation.");
    inspectorBackend.registerCommand("DeviceOrientation.setDeviceOrientationOverride", [{ "name": "alpha", "type": "number", "optional": false, "description": "Mock alpha", "typeRef": null }, { "name": "beta", "type": "number", "optional": false, "description": "Mock beta", "typeRef": null }, { "name": "gamma", "type": "number", "optional": false, "description": "Mock gamma", "typeRef": null }], [], "Overrides the Device Orientation.");
    // Emulation.
    inspectorBackend.registerEnum("Emulation.ScreenOrientationType", { PortraitPrimary: "portraitPrimary", PortraitSecondary: "portraitSecondary", LandscapePrimary: "landscapePrimary", LandscapeSecondary: "landscapeSecondary" });
    inspectorBackend.registerEnum("Emulation.DisplayFeatureOrientation", { Vertical: "vertical", Horizontal: "horizontal" });
    inspectorBackend.registerEnum("Emulation.DevicePostureType", { Continuous: "continuous", Folded: "folded" });
    inspectorBackend.registerEnum("Emulation.VirtualTimePolicy", { Advance: "advance", Pause: "pause", PauseIfNetworkFetchesPending: "pauseIfNetworkFetchesPending" });
    inspectorBackend.registerEnum("Emulation.SensorType", { AbsoluteOrientation: "absolute-orientation", Accelerometer: "accelerometer", AmbientLight: "ambient-light", Gravity: "gravity", Gyroscope: "gyroscope", LinearAcceleration: "linear-acceleration", Magnetometer: "magnetometer", RelativeOrientation: "relative-orientation" });
    inspectorBackend.registerEnum("Emulation.PressureSource", { Cpu: "cpu" });
    inspectorBackend.registerEnum("Emulation.PressureState", { Nominal: "nominal", Fair: "fair", Serious: "serious", Critical: "critical" });
    inspectorBackend.registerEnum("Emulation.DisabledImageType", { Avif: "avif", Webp: "webp" });
    inspectorBackend.registerEvent("Emulation.virtualTimeBudgetExpired", []);
    inspectorBackend.registerCommand("Emulation.canEmulate", [], ["result"], "Tells whether emulation is supported.");
    inspectorBackend.registerCommand("Emulation.clearDeviceMetricsOverride", [], [], "Clears the overridden device metrics.");
    inspectorBackend.registerCommand("Emulation.clearGeolocationOverride", [], [], "Clears the overridden Geolocation Position and Error.");
    inspectorBackend.registerCommand("Emulation.resetPageScaleFactor", [], [], "Requests that page scale factor is reset to initial values.");
    inspectorBackend.registerCommand("Emulation.setFocusEmulationEnabled", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "Whether to enable to disable focus emulation.", "typeRef": null }], [], "Enables or disables simulating a focused and active page.");
    inspectorBackend.registerCommand("Emulation.setAutoDarkModeOverride", [{ "name": "enabled", "type": "boolean", "optional": true, "description": "Whether to enable or disable automatic dark mode. If not specified, any existing override will be cleared.", "typeRef": null }], [], "Automatically render all web contents using a dark theme.");
    inspectorBackend.registerCommand("Emulation.setCPUThrottlingRate", [{ "name": "rate", "type": "number", "optional": false, "description": "Throttling rate as a slowdown factor (1 is no throttle, 2 is 2x slowdown, etc).", "typeRef": null }], [], "Enables CPU throttling to emulate slow CPUs.");
    inspectorBackend.registerCommand("Emulation.setDefaultBackgroundColorOverride", [{ "name": "color", "type": "object", "optional": true, "description": "RGBA of the default background color. If not specified, any existing override will be cleared.", "typeRef": "DOM.RGBA" }], [], "Sets or clears an override of the default background color of the frame. This override is used if the content does not specify one.");
    inspectorBackend.registerCommand("Emulation.setSafeAreaInsetsOverride", [{ "name": "insets", "type": "object", "optional": false, "description": "", "typeRef": "Emulation.SafeAreaInsets" }], [], "Overrides the values for env(safe-area-inset-*) and env(safe-area-max-inset-*). Unset values will cause the respective variables to be undefined, even if previously overridden.");
    inspectorBackend.registerCommand("Emulation.setDeviceMetricsOverride", [{ "name": "width", "type": "number", "optional": false, "description": "Overriding width value in pixels (minimum 0, maximum 10000000). 0 disables the override.", "typeRef": null }, { "name": "height", "type": "number", "optional": false, "description": "Overriding height value in pixels (minimum 0, maximum 10000000). 0 disables the override.", "typeRef": null }, { "name": "deviceScaleFactor", "type": "number", "optional": false, "description": "Overriding device scale factor value. 0 disables the override.", "typeRef": null }, { "name": "mobile", "type": "boolean", "optional": false, "description": "Whether to emulate mobile device. This includes viewport meta tag, overlay scrollbars, text autosizing and more.", "typeRef": null }, { "name": "scale", "type": "number", "optional": true, "description": "Scale to apply to resulting view image.", "typeRef": null }, { "name": "screenWidth", "type": "number", "optional": true, "description": "Overriding screen width value in pixels (minimum 0, maximum 10000000).", "typeRef": null }, { "name": "screenHeight", "type": "number", "optional": true, "description": "Overriding screen height value in pixels (minimum 0, maximum 10000000).", "typeRef": null }, { "name": "positionX", "type": "number", "optional": true, "description": "Overriding view X position on screen in pixels (minimum 0, maximum 10000000).", "typeRef": null }, { "name": "positionY", "type": "number", "optional": true, "description": "Overriding view Y position on screen in pixels (minimum 0, maximum 10000000).", "typeRef": null }, { "name": "dontSetVisibleSize", "type": "boolean", "optional": true, "description": "Do not set visible view size, rely upon explicit setVisibleSize call.", "typeRef": null }, { "name": "screenOrientation", "type": "object", "optional": true, "description": "Screen orientation override.", "typeRef": "Emulation.ScreenOrientation" }, { "name": "viewport", "type": "object", "optional": true, "description": "If set, the visible area of the page will be overridden to this viewport. This viewport change is not observed by the page, e.g. viewport-relative elements do not change positions.", "typeRef": "Page.Viewport" }, { "name": "displayFeature", "type": "object", "optional": true, "description": "If set, the display feature of a multi-segment screen. If not set, multi-segment support is turned-off. Deprecated, use Emulation.setDisplayFeaturesOverride.", "typeRef": "Emulation.DisplayFeature" }, { "name": "devicePosture", "type": "object", "optional": true, "description": "If set, the posture of a foldable device. If not set the posture is set to continuous. Deprecated, use Emulation.setDevicePostureOverride.", "typeRef": "Emulation.DevicePosture" }], [], "Overrides the values of device screen dimensions (window.screen.width, window.screen.height, window.innerWidth, window.innerHeight, and \"device-width\"/\"device-height\"-related CSS media query results).");
    inspectorBackend.registerCommand("Emulation.setDevicePostureOverride", [{ "name": "posture", "type": "object", "optional": false, "description": "", "typeRef": "Emulation.DevicePosture" }], [], "Start reporting the given posture value to the Device Posture API. This override can also be set in setDeviceMetricsOverride().");
    inspectorBackend.registerCommand("Emulation.clearDevicePostureOverride", [], [], "Clears a device posture override set with either setDeviceMetricsOverride() or setDevicePostureOverride() and starts using posture information from the platform again. Does nothing if no override is set.");
    inspectorBackend.registerCommand("Emulation.setDisplayFeaturesOverride", [{ "name": "features", "type": "array", "optional": false, "description": "", "typeRef": "Emulation.DisplayFeature" }], [], "Start using the given display features to pupulate the Viewport Segments API. This override can also be set in setDeviceMetricsOverride().");
    inspectorBackend.registerCommand("Emulation.clearDisplayFeaturesOverride", [], [], "Clears the display features override set with either setDeviceMetricsOverride() or setDisplayFeaturesOverride() and starts using display features from the platform again. Does nothing if no override is set.");
    inspectorBackend.registerCommand("Emulation.setScrollbarsHidden", [{ "name": "hidden", "type": "boolean", "optional": false, "description": "Whether scrollbars should be always hidden.", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("Emulation.setDocumentCookieDisabled", [{ "name": "disabled", "type": "boolean", "optional": false, "description": "Whether document.coookie API should be disabled.", "typeRef": null }], [], "");
    inspectorBackend.registerEnum("Emulation.SetEmitTouchEventsForMouseRequestConfiguration", { Mobile: "mobile", Desktop: "desktop" });
    inspectorBackend.registerCommand("Emulation.setEmitTouchEventsForMouse", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "Whether touch emulation based on mouse input should be enabled.", "typeRef": null }, { "name": "configuration", "type": "string", "optional": true, "description": "Touch/gesture events configuration. Default: current platform.", "typeRef": "Emulation.SetEmitTouchEventsForMouseRequestConfiguration" }], [], "");
    inspectorBackend.registerCommand("Emulation.setEmulatedMedia", [{ "name": "media", "type": "string", "optional": true, "description": "Media type to emulate. Empty string disables the override.", "typeRef": null }, { "name": "features", "type": "array", "optional": true, "description": "Media features to emulate.", "typeRef": "Emulation.MediaFeature" }], [], "Emulates the given media type or media feature for CSS media queries.");
    inspectorBackend.registerEnum("Emulation.SetEmulatedVisionDeficiencyRequestType", { None: "none", BlurredVision: "blurredVision", ReducedContrast: "reducedContrast", Achromatopsia: "achromatopsia", Deuteranopia: "deuteranopia", Protanopia: "protanopia", Tritanopia: "tritanopia" });
    inspectorBackend.registerCommand("Emulation.setEmulatedVisionDeficiency", [{ "name": "type", "type": "string", "optional": false, "description": "Vision deficiency to emulate. Order: best-effort emulations come first, followed by any physiologically accurate emulations for medically recognized color vision deficiencies.", "typeRef": "Emulation.SetEmulatedVisionDeficiencyRequestType" }], [], "Emulates the given vision deficiency.");
    inspectorBackend.registerCommand("Emulation.setEmulatedOSTextScale", [{ "name": "scale", "type": "number", "optional": true, "description": "", "typeRef": null }], [], "Emulates the given OS text scale.");
    inspectorBackend.registerCommand("Emulation.setGeolocationOverride", [{ "name": "latitude", "type": "number", "optional": true, "description": "Mock latitude", "typeRef": null }, { "name": "longitude", "type": "number", "optional": true, "description": "Mock longitude", "typeRef": null }, { "name": "accuracy", "type": "number", "optional": true, "description": "Mock accuracy", "typeRef": null }, { "name": "altitude", "type": "number", "optional": true, "description": "Mock altitude", "typeRef": null }, { "name": "altitudeAccuracy", "type": "number", "optional": true, "description": "Mock altitudeAccuracy", "typeRef": null }, { "name": "heading", "type": "number", "optional": true, "description": "Mock heading", "typeRef": null }, { "name": "speed", "type": "number", "optional": true, "description": "Mock speed", "typeRef": null }], [], "Overrides the Geolocation Position or Error. Omitting latitude, longitude or accuracy emulates position unavailable.");
    inspectorBackend.registerCommand("Emulation.getOverriddenSensorInformation", [{ "name": "type", "type": "string", "optional": false, "description": "", "typeRef": "Emulation.SensorType" }], ["requestedSamplingFrequency"], "");
    inspectorBackend.registerCommand("Emulation.setSensorOverrideEnabled", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "type", "type": "string", "optional": false, "description": "", "typeRef": "Emulation.SensorType" }, { "name": "metadata", "type": "object", "optional": true, "description": "", "typeRef": "Emulation.SensorMetadata" }], [], "Overrides a platform sensor of a given type. If |enabled| is true, calls to Sensor.start() will use a virtual sensor as backend rather than fetching data from a real hardware sensor. Otherwise, existing virtual sensor-backend Sensor objects will fire an error event and new calls to Sensor.start() will attempt to use a real sensor instead.");
    inspectorBackend.registerCommand("Emulation.setSensorOverrideReadings", [{ "name": "type", "type": "string", "optional": false, "description": "", "typeRef": "Emulation.SensorType" }, { "name": "reading", "type": "object", "optional": false, "description": "", "typeRef": "Emulation.SensorReading" }], [], "Updates the sensor readings reported by a sensor type previously overridden by setSensorOverrideEnabled.");
    inspectorBackend.registerCommand("Emulation.setPressureSourceOverrideEnabled", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "source", "type": "string", "optional": false, "description": "", "typeRef": "Emulation.PressureSource" }, { "name": "metadata", "type": "object", "optional": true, "description": "", "typeRef": "Emulation.PressureMetadata" }], [], "Overrides a pressure source of a given type, as used by the Compute Pressure API, so that updates to PressureObserver.observe() are provided via setPressureStateOverride instead of being retrieved from platform-provided telemetry data.");
    inspectorBackend.registerCommand("Emulation.setPressureStateOverride", [{ "name": "source", "type": "string", "optional": false, "description": "", "typeRef": "Emulation.PressureSource" }, { "name": "state", "type": "string", "optional": false, "description": "", "typeRef": "Emulation.PressureState" }], [], "TODO: OBSOLETE: To remove when setPressureDataOverride is merged. Provides a given pressure state that will be processed and eventually be delivered to PressureObserver users. |source| must have been previously overridden by setPressureSourceOverrideEnabled.");
    inspectorBackend.registerCommand("Emulation.setPressureDataOverride", [{ "name": "source", "type": "string", "optional": false, "description": "", "typeRef": "Emulation.PressureSource" }, { "name": "state", "type": "string", "optional": false, "description": "", "typeRef": "Emulation.PressureState" }, { "name": "ownContributionEstimate", "type": "number", "optional": true, "description": "", "typeRef": null }], [], "Provides a given pressure data set that will be processed and eventually be delivered to PressureObserver users. |source| must have been previously overridden by setPressureSourceOverrideEnabled.");
    inspectorBackend.registerCommand("Emulation.setIdleOverride", [{ "name": "isUserActive", "type": "boolean", "optional": false, "description": "Mock isUserActive", "typeRef": null }, { "name": "isScreenUnlocked", "type": "boolean", "optional": false, "description": "Mock isScreenUnlocked", "typeRef": null }], [], "Overrides the Idle state.");
    inspectorBackend.registerCommand("Emulation.clearIdleOverride", [], [], "Clears Idle state overrides.");
    inspectorBackend.registerCommand("Emulation.setNavigatorOverrides", [{ "name": "platform", "type": "string", "optional": false, "description": "The platform navigator.platform should return.", "typeRef": null }], [], "Overrides value returned by the javascript navigator object.");
    inspectorBackend.registerCommand("Emulation.setPageScaleFactor", [{ "name": "pageScaleFactor", "type": "number", "optional": false, "description": "Page scale factor.", "typeRef": null }], [], "Sets a specified page scale factor.");
    inspectorBackend.registerCommand("Emulation.setScriptExecutionDisabled", [{ "name": "value", "type": "boolean", "optional": false, "description": "Whether script execution should be disabled in the page.", "typeRef": null }], [], "Switches script execution in the page.");
    inspectorBackend.registerCommand("Emulation.setTouchEmulationEnabled", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "Whether the touch event emulation should be enabled.", "typeRef": null }, { "name": "maxTouchPoints", "type": "number", "optional": true, "description": "Maximum touch points supported. Defaults to one.", "typeRef": null }], [], "Enables touch on platforms which do not support them.");
    inspectorBackend.registerCommand("Emulation.setVirtualTimePolicy", [{ "name": "policy", "type": "string", "optional": false, "description": "", "typeRef": "Emulation.VirtualTimePolicy" }, { "name": "budget", "type": "number", "optional": true, "description": "If set, after this many virtual milliseconds have elapsed virtual time will be paused and a virtualTimeBudgetExpired event is sent.", "typeRef": null }, { "name": "maxVirtualTimeTaskStarvationCount", "type": "number", "optional": true, "description": "If set this specifies the maximum number of tasks that can be run before virtual is forced forwards to prevent deadlock.", "typeRef": null }, { "name": "initialVirtualTime", "type": "number", "optional": true, "description": "If set, base::Time::Now will be overridden to initially return this value.", "typeRef": "Network.TimeSinceEpoch" }], ["virtualTimeTicksBase"], "Turns on virtual time for all frames (replacing real-time with a synthetic time source) and sets the current virtual time policy.  Note this supersedes any previous time budget.");
    inspectorBackend.registerCommand("Emulation.setLocaleOverride", [{ "name": "locale", "type": "string", "optional": true, "description": "ICU style C locale (e.g. \\\"en_US\\\"). If not specified or empty, disables the override and restores default host system locale.", "typeRef": null }], [], "Overrides default host system locale with the specified one.");
    inspectorBackend.registerCommand("Emulation.setTimezoneOverride", [{ "name": "timezoneId", "type": "string", "optional": false, "description": "The timezone identifier. List of supported timezones: https://source.chromium.org/chromium/chromium/deps/icu.git/+/faee8bc70570192d82d2978a71e2a615788597d1:source/data/misc/metaZones.txt If empty, disables the override and restores default host system timezone.", "typeRef": null }], [], "Overrides default host system timezone with the specified one.");
    inspectorBackend.registerCommand("Emulation.setVisibleSize", [{ "name": "width", "type": "number", "optional": false, "description": "Frame width (DIP).", "typeRef": null }, { "name": "height", "type": "number", "optional": false, "description": "Frame height (DIP).", "typeRef": null }], [], "Resizes the frame/viewport of the page. Note that this does not affect the frame's container (e.g. browser window). Can be used to produce screenshots of the specified size. Not supported on Android.");
    inspectorBackend.registerCommand("Emulation.setDisabledImageTypes", [{ "name": "imageTypes", "type": "array", "optional": false, "description": "Image types to disable.", "typeRef": "Emulation.DisabledImageType" }], [], "");
    inspectorBackend.registerCommand("Emulation.setDataSaverOverride", [{ "name": "dataSaverEnabled", "type": "boolean", "optional": true, "description": "Override value. Omitting the parameter disables the override.", "typeRef": null }], [], "Override the value of navigator.connection.saveData");
    inspectorBackend.registerCommand("Emulation.setHardwareConcurrencyOverride", [{ "name": "hardwareConcurrency", "type": "number", "optional": false, "description": "Hardware concurrency to report", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("Emulation.setUserAgentOverride", [{ "name": "userAgent", "type": "string", "optional": false, "description": "User agent to use.", "typeRef": null }, { "name": "acceptLanguage", "type": "string", "optional": true, "description": "Browser language to emulate.", "typeRef": null }, { "name": "platform", "type": "string", "optional": true, "description": "The platform navigator.platform should return.", "typeRef": null }, { "name": "userAgentMetadata", "type": "object", "optional": true, "description": "To be sent in Sec-CH-UA-* headers and returned in navigator.userAgentData", "typeRef": "Emulation.UserAgentMetadata" }], [], "Allows overriding user agent with the given string. `userAgentMetadata` must be set for Client Hint headers to be sent.");
    inspectorBackend.registerCommand("Emulation.setAutomationOverride", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "Whether the override should be enabled.", "typeRef": null }], [], "Allows overriding the automation flag.");
    inspectorBackend.registerCommand("Emulation.setSmallViewportHeightDifferenceOverride", [{ "name": "difference", "type": "number", "optional": false, "description": "This will cause an element of size 100svh to be `difference` pixels smaller than an element of size 100lvh.", "typeRef": null }], [], "Allows overriding the difference between the small and large viewport sizes, which determine the value of the `svh` and `lvh` unit, respectively. Only supported for top-level frames.");
    inspectorBackend.registerCommand("Emulation.getScreenInfos", [], ["screenInfos"], "Returns device's screen configuration.");
    inspectorBackend.registerCommand("Emulation.addScreen", [{ "name": "left", "type": "number", "optional": false, "description": "Offset of the left edge of the screen in pixels.", "typeRef": null }, { "name": "top", "type": "number", "optional": false, "description": "Offset of the top edge of the screen in pixels.", "typeRef": null }, { "name": "width", "type": "number", "optional": false, "description": "The width of the screen in pixels.", "typeRef": null }, { "name": "height", "type": "number", "optional": false, "description": "The height of the screen in pixels.", "typeRef": null }, { "name": "workAreaInsets", "type": "object", "optional": true, "description": "Specifies the screen's work area. Default is entire screen.", "typeRef": "Emulation.WorkAreaInsets" }, { "name": "devicePixelRatio", "type": "number", "optional": true, "description": "Specifies the screen's device pixel ratio. Default is 1.", "typeRef": null }, { "name": "rotation", "type": "number", "optional": true, "description": "Specifies the screen's rotation angle. Available values are 0, 90, 180 and 270. Default is 0.", "typeRef": null }, { "name": "colorDepth", "type": "number", "optional": true, "description": "Specifies the screen's color depth in bits. Default is 24.", "typeRef": null }, { "name": "label", "type": "string", "optional": true, "description": "Specifies the descriptive label for the screen. Default is none.", "typeRef": null }, { "name": "isInternal", "type": "boolean", "optional": true, "description": "Indicates whether the screen is internal to the device or external, attached to the device. Default is false.", "typeRef": null }], ["screenInfo"], "Add a new screen to the device. Only supported in headless mode.");
    inspectorBackend.registerCommand("Emulation.removeScreen", [{ "name": "screenId", "type": "string", "optional": false, "description": "", "typeRef": "Emulation.ScreenId" }], [], "Remove screen from the device. Only supported in headless mode.");
    inspectorBackend.registerType("Emulation.SafeAreaInsets", [{ "name": "top", "type": "number", "optional": true, "description": "Overrides safe-area-inset-top.", "typeRef": null }, { "name": "topMax", "type": "number", "optional": true, "description": "Overrides safe-area-max-inset-top.", "typeRef": null }, { "name": "left", "type": "number", "optional": true, "description": "Overrides safe-area-inset-left.", "typeRef": null }, { "name": "leftMax", "type": "number", "optional": true, "description": "Overrides safe-area-max-inset-left.", "typeRef": null }, { "name": "bottom", "type": "number", "optional": true, "description": "Overrides safe-area-inset-bottom.", "typeRef": null }, { "name": "bottomMax", "type": "number", "optional": true, "description": "Overrides safe-area-max-inset-bottom.", "typeRef": null }, { "name": "right", "type": "number", "optional": true, "description": "Overrides safe-area-inset-right.", "typeRef": null }, { "name": "rightMax", "type": "number", "optional": true, "description": "Overrides safe-area-max-inset-right.", "typeRef": null }]);
    inspectorBackend.registerType("Emulation.ScreenOrientation", [{ "name": "type", "type": "string", "optional": false, "description": "Orientation type.", "typeRef": null }, { "name": "angle", "type": "number", "optional": false, "description": "Orientation angle.", "typeRef": null }]);
    inspectorBackend.registerType("Emulation.DisplayFeature", [{ "name": "orientation", "type": "string", "optional": false, "description": "Orientation of a display feature in relation to screen", "typeRef": null }, { "name": "offset", "type": "number", "optional": false, "description": "The offset from the screen origin in either the x (for vertical orientation) or y (for horizontal orientation) direction.", "typeRef": null }, { "name": "maskLength", "type": "number", "optional": false, "description": "A display feature may mask content such that it is not physically displayed - this length along with the offset describes this area. A display feature that only splits content will have a 0 mask_length.", "typeRef": null }]);
    inspectorBackend.registerType("Emulation.DevicePosture", [{ "name": "type", "type": "string", "optional": false, "description": "Current posture of the device", "typeRef": null }]);
    inspectorBackend.registerType("Emulation.MediaFeature", [{ "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Emulation.UserAgentBrandVersion", [{ "name": "brand", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "version", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Emulation.UserAgentMetadata", [{ "name": "brands", "type": "array", "optional": true, "description": "Brands appearing in Sec-CH-UA.", "typeRef": "Emulation.UserAgentBrandVersion" }, { "name": "fullVersionList", "type": "array", "optional": true, "description": "Brands appearing in Sec-CH-UA-Full-Version-List.", "typeRef": "Emulation.UserAgentBrandVersion" }, { "name": "fullVersion", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "platform", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "platformVersion", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "architecture", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "model", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "mobile", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "bitness", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "wow64", "type": "boolean", "optional": true, "description": "", "typeRef": null }, { "name": "formFactors", "type": "array", "optional": true, "description": "Used to specify User Agent form-factor values. See https://wicg.github.io/ua-client-hints/#sec-ch-ua-form-factors", "typeRef": "string" }]);
    inspectorBackend.registerType("Emulation.SensorMetadata", [{ "name": "available", "type": "boolean", "optional": true, "description": "", "typeRef": null }, { "name": "minimumFrequency", "type": "number", "optional": true, "description": "", "typeRef": null }, { "name": "maximumFrequency", "type": "number", "optional": true, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Emulation.SensorReadingSingle", [{ "name": "value", "type": "number", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Emulation.SensorReadingXYZ", [{ "name": "x", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "y", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "z", "type": "number", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Emulation.SensorReadingQuaternion", [{ "name": "x", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "y", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "z", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "w", "type": "number", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Emulation.SensorReading", [{ "name": "single", "type": "object", "optional": true, "description": "", "typeRef": "Emulation.SensorReadingSingle" }, { "name": "xyz", "type": "object", "optional": true, "description": "", "typeRef": "Emulation.SensorReadingXYZ" }, { "name": "quaternion", "type": "object", "optional": true, "description": "", "typeRef": "Emulation.SensorReadingQuaternion" }]);
    inspectorBackend.registerType("Emulation.PressureMetadata", [{ "name": "available", "type": "boolean", "optional": true, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Emulation.WorkAreaInsets", [{ "name": "top", "type": "number", "optional": true, "description": "Work area top inset in pixels. Default is 0;", "typeRef": null }, { "name": "left", "type": "number", "optional": true, "description": "Work area left inset in pixels. Default is 0;", "typeRef": null }, { "name": "bottom", "type": "number", "optional": true, "description": "Work area bottom inset in pixels. Default is 0;", "typeRef": null }, { "name": "right", "type": "number", "optional": true, "description": "Work area right inset in pixels. Default is 0;", "typeRef": null }]);
    inspectorBackend.registerType("Emulation.ScreenInfo", [{ "name": "left", "type": "number", "optional": false, "description": "Offset of the left edge of the screen.", "typeRef": null }, { "name": "top", "type": "number", "optional": false, "description": "Offset of the top edge of the screen.", "typeRef": null }, { "name": "width", "type": "number", "optional": false, "description": "Width of the screen.", "typeRef": null }, { "name": "height", "type": "number", "optional": false, "description": "Height of the screen.", "typeRef": null }, { "name": "availLeft", "type": "number", "optional": false, "description": "Offset of the left edge of the available screen area.", "typeRef": null }, { "name": "availTop", "type": "number", "optional": false, "description": "Offset of the top edge of the available screen area.", "typeRef": null }, { "name": "availWidth", "type": "number", "optional": false, "description": "Width of the available screen area.", "typeRef": null }, { "name": "availHeight", "type": "number", "optional": false, "description": "Height of the available screen area.", "typeRef": null }, { "name": "devicePixelRatio", "type": "number", "optional": false, "description": "Specifies the screen's device pixel ratio.", "typeRef": null }, { "name": "orientation", "type": "object", "optional": false, "description": "Specifies the screen's orientation.", "typeRef": "Emulation.ScreenOrientation" }, { "name": "colorDepth", "type": "number", "optional": false, "description": "Specifies the screen's color depth in bits.", "typeRef": null }, { "name": "isExtended", "type": "boolean", "optional": false, "description": "Indicates whether the device has multiple screens.", "typeRef": null }, { "name": "isInternal", "type": "boolean", "optional": false, "description": "Indicates whether the screen is internal to the device or external, attached to the device.", "typeRef": null }, { "name": "isPrimary", "type": "boolean", "optional": false, "description": "Indicates whether the screen is set as the the operating system primary screen.", "typeRef": null }, { "name": "label", "type": "string", "optional": false, "description": "Specifies the descriptive label for the screen.", "typeRef": null }, { "name": "id", "type": "string", "optional": false, "description": "Specifies the unique identifier of the screen.", "typeRef": "Emulation.ScreenId" }]);
    // EventBreakpoints.
    inspectorBackend.registerCommand("EventBreakpoints.setInstrumentationBreakpoint", [{ "name": "eventName", "type": "string", "optional": false, "description": "Instrumentation name to stop on.", "typeRef": null }], [], "Sets breakpoint on particular native event.");
    inspectorBackend.registerCommand("EventBreakpoints.removeInstrumentationBreakpoint", [{ "name": "eventName", "type": "string", "optional": false, "description": "Instrumentation name to stop on.", "typeRef": null }], [], "Removes breakpoint on particular native event.");
    inspectorBackend.registerCommand("EventBreakpoints.disable", [], [], "Removes all breakpoints");
    // Extensions.
    inspectorBackend.registerEnum("Extensions.StorageArea", { Session: "session", Local: "local", Sync: "sync", Managed: "managed" });
    inspectorBackend.registerCommand("Extensions.loadUnpacked", [{ "name": "path", "type": "string", "optional": false, "description": "Absolute file path.", "typeRef": null }], ["id"], "Installs an unpacked extension from the filesystem similar to --load-extension CLI flags. Returns extension ID once the extension has been installed. Available if the client is connected using the --remote-debugging-pipe flag and the --enable-unsafe-extension-debugging flag is set.");
    inspectorBackend.registerCommand("Extensions.uninstall", [{ "name": "id", "type": "string", "optional": false, "description": "Extension id.", "typeRef": null }], [], "Uninstalls an unpacked extension (others not supported) from the profile. Available if the client is connected using the --remote-debugging-pipe flag and the --enable-unsafe-extension-debugging.");
    inspectorBackend.registerCommand("Extensions.getStorageItems", [{ "name": "id", "type": "string", "optional": false, "description": "ID of extension.", "typeRef": null }, { "name": "storageArea", "type": "string", "optional": false, "description": "StorageArea to retrieve data from.", "typeRef": "Extensions.StorageArea" }, { "name": "keys", "type": "array", "optional": true, "description": "Keys to retrieve.", "typeRef": "string" }], ["data"], "Gets data from extension storage in the given `storageArea`. If `keys` is specified, these are used to filter the result.");
    inspectorBackend.registerCommand("Extensions.removeStorageItems", [{ "name": "id", "type": "string", "optional": false, "description": "ID of extension.", "typeRef": null }, { "name": "storageArea", "type": "string", "optional": false, "description": "StorageArea to remove data from.", "typeRef": "Extensions.StorageArea" }, { "name": "keys", "type": "array", "optional": false, "description": "Keys to remove.", "typeRef": "string" }], [], "Removes `keys` from extension storage in the given `storageArea`.");
    inspectorBackend.registerCommand("Extensions.clearStorageItems", [{ "name": "id", "type": "string", "optional": false, "description": "ID of extension.", "typeRef": null }, { "name": "storageArea", "type": "string", "optional": false, "description": "StorageArea to remove data from.", "typeRef": "Extensions.StorageArea" }], [], "Clears extension storage in the given `storageArea`.");
    inspectorBackend.registerCommand("Extensions.setStorageItems", [{ "name": "id", "type": "string", "optional": false, "description": "ID of extension.", "typeRef": null }, { "name": "storageArea", "type": "string", "optional": false, "description": "StorageArea to set data in.", "typeRef": "Extensions.StorageArea" }, { "name": "values", "type": "object", "optional": false, "description": "Values to set.", "typeRef": null }], [], "Sets `values` in extension storage in the given `storageArea`. The provided `values` will be merged with existing values in the storage area.");
    // FedCm.
    inspectorBackend.registerEnum("FedCm.LoginState", { SignIn: "SignIn", SignUp: "SignUp" });
    inspectorBackend.registerEnum("FedCm.DialogType", { AccountChooser: "AccountChooser", AutoReauthn: "AutoReauthn", ConfirmIdpLogin: "ConfirmIdpLogin", Error: "Error" });
    inspectorBackend.registerEnum("FedCm.DialogButton", { ConfirmIdpLoginContinue: "ConfirmIdpLoginContinue", ErrorGotIt: "ErrorGotIt", ErrorMoreDetails: "ErrorMoreDetails" });
    inspectorBackend.registerEnum("FedCm.AccountUrlType", { TermsOfService: "TermsOfService", PrivacyPolicy: "PrivacyPolicy" });
    inspectorBackend.registerEvent("FedCm.dialogShown", ["dialogId", "dialogType", "accounts", "title", "subtitle"]);
    inspectorBackend.registerEvent("FedCm.dialogClosed", ["dialogId"]);
    inspectorBackend.registerCommand("FedCm.enable", [{ "name": "disableRejectionDelay", "type": "boolean", "optional": true, "description": "Allows callers to disable the promise rejection delay that would normally happen, if this is unimportant to what's being tested. (step 4 of https://fedidcg.github.io/FedCM/#browser-api-rp-sign-in)", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("FedCm.disable", [], [], "");
    inspectorBackend.registerCommand("FedCm.selectAccount", [{ "name": "dialogId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "accountIndex", "type": "number", "optional": false, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("FedCm.clickDialogButton", [{ "name": "dialogId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "dialogButton", "type": "string", "optional": false, "description": "", "typeRef": "FedCm.DialogButton" }], [], "");
    inspectorBackend.registerCommand("FedCm.openUrl", [{ "name": "dialogId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "accountIndex", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "accountUrlType", "type": "string", "optional": false, "description": "", "typeRef": "FedCm.AccountUrlType" }], [], "");
    inspectorBackend.registerCommand("FedCm.dismissDialog", [{ "name": "dialogId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "triggerCooldown", "type": "boolean", "optional": true, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("FedCm.resetCooldown", [], [], "Resets the cooldown time, if any, to allow the next FedCM call to show a dialog even if one was recently dismissed by the user.");
    inspectorBackend.registerType("FedCm.Account", [{ "name": "accountId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "email", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "givenName", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "pictureUrl", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "idpConfigUrl", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "idpLoginUrl", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "loginState", "type": "string", "optional": false, "description": "", "typeRef": "FedCm.LoginState" }, { "name": "termsOfServiceUrl", "type": "string", "optional": true, "description": "These two are only set if the loginState is signUp", "typeRef": null }, { "name": "privacyPolicyUrl", "type": "string", "optional": true, "description": "", "typeRef": null }]);
    // Fetch.
    inspectorBackend.registerEnum("Fetch.RequestStage", { Request: "Request", Response: "Response" });
    inspectorBackend.registerEnum("Fetch.AuthChallengeSource", { Server: "Server", Proxy: "Proxy" });
    inspectorBackend.registerEnum("Fetch.AuthChallengeResponseResponse", { Default: "Default", CancelAuth: "CancelAuth", ProvideCredentials: "ProvideCredentials" });
    inspectorBackend.registerEvent("Fetch.requestPaused", ["requestId", "request", "frameId", "resourceType", "responseErrorReason", "responseStatusCode", "responseStatusText", "responseHeaders", "networkId", "redirectedRequestId"]);
    inspectorBackend.registerEvent("Fetch.authRequired", ["requestId", "request", "frameId", "resourceType", "authChallenge"]);
    inspectorBackend.registerCommand("Fetch.disable", [], [], "Disables the fetch domain.");
    inspectorBackend.registerCommand("Fetch.enable", [{ "name": "patterns", "type": "array", "optional": true, "description": "If specified, only requests matching any of these patterns will produce fetchRequested event and will be paused until clients response. If not set, all requests will be affected.", "typeRef": "Fetch.RequestPattern" }, { "name": "handleAuthRequests", "type": "boolean", "optional": true, "description": "If true, authRequired events will be issued and requests will be paused expecting a call to continueWithAuth.", "typeRef": null }], [], "Enables issuing of requestPaused events. A request will be paused until client calls one of failRequest, fulfillRequest or continueRequest/continueWithAuth.");
    inspectorBackend.registerCommand("Fetch.failRequest", [{ "name": "requestId", "type": "string", "optional": false, "description": "An id the client received in requestPaused event.", "typeRef": "Fetch.RequestId" }, { "name": "errorReason", "type": "string", "optional": false, "description": "Causes the request to fail with the given reason.", "typeRef": "Network.ErrorReason" }], [], "Causes the request to fail with specified reason.");
    inspectorBackend.registerCommand("Fetch.fulfillRequest", [{ "name": "requestId", "type": "string", "optional": false, "description": "An id the client received in requestPaused event.", "typeRef": "Fetch.RequestId" }, { "name": "responseCode", "type": "number", "optional": false, "description": "An HTTP response code.", "typeRef": null }, { "name": "responseHeaders", "type": "array", "optional": true, "description": "Response headers.", "typeRef": "Fetch.HeaderEntry" }, { "name": "binaryResponseHeaders", "type": "string", "optional": true, "description": "Alternative way of specifying response headers as a \\0-separated series of name: value pairs. Prefer the above method unless you need to represent some non-UTF8 values that can't be transmitted over the protocol as text.", "typeRef": null }, { "name": "body", "type": "string", "optional": true, "description": "A response body. If absent, original response body will be used if the request is intercepted at the response stage and empty body will be used if the request is intercepted at the request stage.", "typeRef": null }, { "name": "responsePhrase", "type": "string", "optional": true, "description": "A textual representation of responseCode. If absent, a standard phrase matching responseCode is used.", "typeRef": null }], [], "Provides response to the request.");
    inspectorBackend.registerCommand("Fetch.continueRequest", [{ "name": "requestId", "type": "string", "optional": false, "description": "An id the client received in requestPaused event.", "typeRef": "Fetch.RequestId" }, { "name": "url", "type": "string", "optional": true, "description": "If set, the request url will be modified in a way that's not observable by page.", "typeRef": null }, { "name": "method", "type": "string", "optional": true, "description": "If set, the request method is overridden.", "typeRef": null }, { "name": "postData", "type": "string", "optional": true, "description": "If set, overrides the post data in the request.", "typeRef": null }, { "name": "headers", "type": "array", "optional": true, "description": "If set, overrides the request headers. Note that the overrides do not extend to subsequent redirect hops, if a redirect happens. Another override may be applied to a different request produced by a redirect.", "typeRef": "Fetch.HeaderEntry" }, { "name": "interceptResponse", "type": "boolean", "optional": true, "description": "If set, overrides response interception behavior for this request.", "typeRef": null }], [], "Continues the request, optionally modifying some of its parameters.");
    inspectorBackend.registerCommand("Fetch.continueWithAuth", [{ "name": "requestId", "type": "string", "optional": false, "description": "An id the client received in authRequired event.", "typeRef": "Fetch.RequestId" }, { "name": "authChallengeResponse", "type": "object", "optional": false, "description": "Response to  with an authChallenge.", "typeRef": "Fetch.AuthChallengeResponse" }], [], "Continues a request supplying authChallengeResponse following authRequired event.");
    inspectorBackend.registerCommand("Fetch.continueResponse", [{ "name": "requestId", "type": "string", "optional": false, "description": "An id the client received in requestPaused event.", "typeRef": "Fetch.RequestId" }, { "name": "responseCode", "type": "number", "optional": true, "description": "An HTTP response code. If absent, original response code will be used.", "typeRef": null }, { "name": "responsePhrase", "type": "string", "optional": true, "description": "A textual representation of responseCode. If absent, a standard phrase matching responseCode is used.", "typeRef": null }, { "name": "responseHeaders", "type": "array", "optional": true, "description": "Response headers. If absent, original response headers will be used.", "typeRef": "Fetch.HeaderEntry" }, { "name": "binaryResponseHeaders", "type": "string", "optional": true, "description": "Alternative way of specifying response headers as a \\0-separated series of name: value pairs. Prefer the above method unless you need to represent some non-UTF8 values that can't be transmitted over the protocol as text.", "typeRef": null }], [], "Continues loading of the paused response, optionally modifying the response headers. If either responseCode or headers are modified, all of them must be present.");
    inspectorBackend.registerCommand("Fetch.getResponseBody", [{ "name": "requestId", "type": "string", "optional": false, "description": "Identifier for the intercepted request to get body for.", "typeRef": "Fetch.RequestId" }], ["body", "base64Encoded"], "Causes the body of the response to be received from the server and returned as a single string. May only be issued for a request that is paused in the Response stage and is mutually exclusive with takeResponseBodyForInterceptionAsStream. Calling other methods that affect the request or disabling fetch domain before body is received results in an undefined behavior. Note that the response body is not available for redirects. Requests paused in the _redirect received_ state may be differentiated by `responseCode` and presence of `location` response header, see comments to `requestPaused` for details.");
    inspectorBackend.registerCommand("Fetch.takeResponseBodyAsStream", [{ "name": "requestId", "type": "string", "optional": false, "description": "", "typeRef": "Fetch.RequestId" }], ["stream"], "Returns a handle to the stream representing the response body. The request must be paused in the HeadersReceived stage. Note that after this command the request can't be continued as is -- client either needs to cancel it or to provide the response body. The stream only supports sequential read, IO.read will fail if the position is specified. This method is mutually exclusive with getResponseBody. Calling other methods that affect the request or disabling fetch domain before body is received results in an undefined behavior.");
    inspectorBackend.registerType("Fetch.RequestPattern", [{ "name": "urlPattern", "type": "string", "optional": true, "description": "Wildcards (`'*'` -> zero or more, `'?'` -> exactly one) are allowed. Escape character is backslash. Omitting is equivalent to `\\\"*\\\"`.", "typeRef": null }, { "name": "resourceType", "type": "string", "optional": true, "description": "If set, only requests for matching resource types will be intercepted.", "typeRef": "Network.ResourceType" }, { "name": "requestStage", "type": "string", "optional": true, "description": "Stage at which to begin intercepting requests. Default is Request.", "typeRef": "Fetch.RequestStage" }]);
    inspectorBackend.registerType("Fetch.HeaderEntry", [{ "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Fetch.AuthChallenge", [{ "name": "source", "type": "string", "optional": true, "description": "Source of the authentication challenge.", "typeRef": null }, { "name": "origin", "type": "string", "optional": false, "description": "Origin of the challenger.", "typeRef": null }, { "name": "scheme", "type": "string", "optional": false, "description": "The authentication scheme used, such as basic or digest", "typeRef": null }, { "name": "realm", "type": "string", "optional": false, "description": "The realm of the challenge. May be empty.", "typeRef": null }]);
    inspectorBackend.registerType("Fetch.AuthChallengeResponse", [{ "name": "response", "type": "string", "optional": false, "description": "The decision on what to do in response to the authorization challenge.  Default means deferring to the default behavior of the net stack, which will likely either the Cancel authentication or display a popup dialog box.", "typeRef": null }, { "name": "username", "type": "string", "optional": true, "description": "The username to provide, possibly empty. Should only be set if response is ProvideCredentials.", "typeRef": null }, { "name": "password", "type": "string", "optional": true, "description": "The password to provide, possibly empty. Should only be set if response is ProvideCredentials.", "typeRef": null }]);
    // FileSystem.
    inspectorBackend.registerCommand("FileSystem.getDirectory", [{ "name": "bucketFileSystemLocator", "type": "object", "optional": false, "description": "", "typeRef": "FileSystem.BucketFileSystemLocator" }], ["directory"], "");
    inspectorBackend.registerType("FileSystem.File", [{ "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "lastModified", "type": "number", "optional": false, "description": "Timestamp", "typeRef": "Network.TimeSinceEpoch" }, { "name": "size", "type": "number", "optional": false, "description": "Size in bytes", "typeRef": null }, { "name": "type", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("FileSystem.Directory", [{ "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "nestedDirectories", "type": "array", "optional": false, "description": "", "typeRef": "string" }, { "name": "nestedFiles", "type": "array", "optional": false, "description": "Files that are directly nested under this directory.", "typeRef": "FileSystem.File" }]);
    inspectorBackend.registerType("FileSystem.BucketFileSystemLocator", [{ "name": "storageKey", "type": "string", "optional": false, "description": "Storage key", "typeRef": "Storage.SerializedStorageKey" }, { "name": "bucketName", "type": "string", "optional": true, "description": "Bucket name. Not passing a `bucketName` will retrieve the default Bucket. (https://developer.mozilla.org/en-US/docs/Web/API/Storage_API#storage_buckets)", "typeRef": null }, { "name": "pathComponents", "type": "array", "optional": false, "description": "Path to the directory using each path component as an array item.", "typeRef": "string" }]);
    // HeadlessExperimental.
    inspectorBackend.registerEnum("HeadlessExperimental.ScreenshotParamsFormat", { Jpeg: "jpeg", Png: "png", Webp: "webp" });
    inspectorBackend.registerCommand("HeadlessExperimental.beginFrame", [{ "name": "frameTimeTicks", "type": "number", "optional": true, "description": "Timestamp of this BeginFrame in Renderer TimeTicks (milliseconds of uptime). If not set, the current time will be used.", "typeRef": null }, { "name": "interval", "type": "number", "optional": true, "description": "The interval between BeginFrames that is reported to the compositor, in milliseconds. Defaults to a 60 frames/second interval, i.e. about 16.666 milliseconds.", "typeRef": null }, { "name": "noDisplayUpdates", "type": "boolean", "optional": true, "description": "Whether updates should not be committed and drawn onto the display. False by default. If true, only side effects of the BeginFrame will be run, such as layout and animations, but any visual updates may not be visible on the display or in screenshots.", "typeRef": null }, { "name": "screenshot", "type": "object", "optional": true, "description": "If set, a screenshot of the frame will be captured and returned in the response. Otherwise, no screenshot will be captured. Note that capturing a screenshot can fail, for example, during renderer initialization. In such a case, no screenshot data will be returned.", "typeRef": "HeadlessExperimental.ScreenshotParams" }], ["hasDamage", "screenshotData"], "Sends a BeginFrame to the target and returns when the frame was completed. Optionally captures a screenshot from the resulting frame. Requires that the target was created with enabled BeginFrameControl. Designed for use with --run-all-compositor-stages-before-draw, see also https://goo.gle/chrome-headless-rendering for more background.");
    inspectorBackend.registerCommand("HeadlessExperimental.disable", [], [], "Disables headless events for the target.");
    inspectorBackend.registerCommand("HeadlessExperimental.enable", [], [], "Enables headless events for the target.");
    inspectorBackend.registerType("HeadlessExperimental.ScreenshotParams", [{ "name": "format", "type": "string", "optional": true, "description": "Image compression format (defaults to png).", "typeRef": null }, { "name": "quality", "type": "number", "optional": true, "description": "Compression quality from range [0..100] (jpeg and webp only).", "typeRef": null }, { "name": "optimizeForSpeed", "type": "boolean", "optional": true, "description": "Optimize image encoding for speed, not for resulting size (defaults to false)", "typeRef": null }]);
    // IO.
    inspectorBackend.registerCommand("IO.close", [{ "name": "handle", "type": "string", "optional": false, "description": "Handle of the stream to close.", "typeRef": "IO.StreamHandle" }], [], "Close the stream, discard any temporary backing storage.");
    inspectorBackend.registerCommand("IO.read", [{ "name": "handle", "type": "string", "optional": false, "description": "Handle of the stream to read.", "typeRef": "IO.StreamHandle" }, { "name": "offset", "type": "number", "optional": true, "description": "Seek to the specified offset before reading (if not specified, proceed with offset following the last read). Some types of streams may only support sequential reads.", "typeRef": null }, { "name": "size", "type": "number", "optional": true, "description": "Maximum number of bytes to read (left upon the agent discretion if not specified).", "typeRef": null }], ["base64Encoded", "data", "eof"], "Read a chunk of the stream");
    inspectorBackend.registerCommand("IO.resolveBlob", [{ "name": "objectId", "type": "string", "optional": false, "description": "Object id of a Blob object wrapper.", "typeRef": "Runtime.RemoteObjectId" }], ["uuid"], "Return UUID of Blob object specified by a remote object id.");
    // IndexedDB.
    inspectorBackend.registerEnum("IndexedDB.KeyType", { Number: "number", String: "string", Date: "date", Array: "array" });
    inspectorBackend.registerEnum("IndexedDB.KeyPathType", { Null: "null", String: "string", Array: "array" });
    inspectorBackend.registerCommand("IndexedDB.clearObjectStore", [{ "name": "securityOrigin", "type": "string", "optional": true, "description": "At least and at most one of securityOrigin, storageKey, or storageBucket must be specified. Security origin.", "typeRef": null }, { "name": "storageKey", "type": "string", "optional": true, "description": "Storage key.", "typeRef": null }, { "name": "storageBucket", "type": "object", "optional": true, "description": "Storage bucket. If not specified, it uses the default bucket.", "typeRef": "Storage.StorageBucket" }, { "name": "databaseName", "type": "string", "optional": false, "description": "Database name.", "typeRef": null }, { "name": "objectStoreName", "type": "string", "optional": false, "description": "Object store name.", "typeRef": null }], [], "Clears all entries from an object store.");
    inspectorBackend.registerCommand("IndexedDB.deleteDatabase", [{ "name": "securityOrigin", "type": "string", "optional": true, "description": "At least and at most one of securityOrigin, storageKey, or storageBucket must be specified. Security origin.", "typeRef": null }, { "name": "storageKey", "type": "string", "optional": true, "description": "Storage key.", "typeRef": null }, { "name": "storageBucket", "type": "object", "optional": true, "description": "Storage bucket. If not specified, it uses the default bucket.", "typeRef": "Storage.StorageBucket" }, { "name": "databaseName", "type": "string", "optional": false, "description": "Database name.", "typeRef": null }], [], "Deletes a database.");
    inspectorBackend.registerCommand("IndexedDB.deleteObjectStoreEntries", [{ "name": "securityOrigin", "type": "string", "optional": true, "description": "At least and at most one of securityOrigin, storageKey, or storageBucket must be specified. Security origin.", "typeRef": null }, { "name": "storageKey", "type": "string", "optional": true, "description": "Storage key.", "typeRef": null }, { "name": "storageBucket", "type": "object", "optional": true, "description": "Storage bucket. If not specified, it uses the default bucket.", "typeRef": "Storage.StorageBucket" }, { "name": "databaseName", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "objectStoreName", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "keyRange", "type": "object", "optional": false, "description": "Range of entry keys to delete", "typeRef": "IndexedDB.KeyRange" }], [], "Delete a range of entries from an object store");
    inspectorBackend.registerCommand("IndexedDB.disable", [], [], "Disables events from backend.");
    inspectorBackend.registerCommand("IndexedDB.enable", [], [], "Enables events from backend.");
    inspectorBackend.registerCommand("IndexedDB.requestData", [{ "name": "securityOrigin", "type": "string", "optional": true, "description": "At least and at most one of securityOrigin, storageKey, or storageBucket must be specified. Security origin.", "typeRef": null }, { "name": "storageKey", "type": "string", "optional": true, "description": "Storage key.", "typeRef": null }, { "name": "storageBucket", "type": "object", "optional": true, "description": "Storage bucket. If not specified, it uses the default bucket.", "typeRef": "Storage.StorageBucket" }, { "name": "databaseName", "type": "string", "optional": false, "description": "Database name.", "typeRef": null }, { "name": "objectStoreName", "type": "string", "optional": false, "description": "Object store name.", "typeRef": null }, { "name": "indexName", "type": "string", "optional": true, "description": "Index name. If not specified, it performs an object store data request.", "typeRef": null }, { "name": "skipCount", "type": "number", "optional": false, "description": "Number of records to skip.", "typeRef": null }, { "name": "pageSize", "type": "number", "optional": false, "description": "Number of records to fetch.", "typeRef": null }, { "name": "keyRange", "type": "object", "optional": true, "description": "Key range.", "typeRef": "IndexedDB.KeyRange" }], ["objectStoreDataEntries", "hasMore"], "Requests data from object store or index.");
    inspectorBackend.registerCommand("IndexedDB.getMetadata", [{ "name": "securityOrigin", "type": "string", "optional": true, "description": "At least and at most one of securityOrigin, storageKey, or storageBucket must be specified. Security origin.", "typeRef": null }, { "name": "storageKey", "type": "string", "optional": true, "description": "Storage key.", "typeRef": null }, { "name": "storageBucket", "type": "object", "optional": true, "description": "Storage bucket. If not specified, it uses the default bucket.", "typeRef": "Storage.StorageBucket" }, { "name": "databaseName", "type": "string", "optional": false, "description": "Database name.", "typeRef": null }, { "name": "objectStoreName", "type": "string", "optional": false, "description": "Object store name.", "typeRef": null }], ["entriesCount", "keyGeneratorValue"], "Gets metadata of an object store.");
    inspectorBackend.registerCommand("IndexedDB.requestDatabase", [{ "name": "securityOrigin", "type": "string", "optional": true, "description": "At least and at most one of securityOrigin, storageKey, or storageBucket must be specified. Security origin.", "typeRef": null }, { "name": "storageKey", "type": "string", "optional": true, "description": "Storage key.", "typeRef": null }, { "name": "storageBucket", "type": "object", "optional": true, "description": "Storage bucket. If not specified, it uses the default bucket.", "typeRef": "Storage.StorageBucket" }, { "name": "databaseName", "type": "string", "optional": false, "description": "Database name.", "typeRef": null }], ["databaseWithObjectStores"], "Requests database with given name in given frame.");
    inspectorBackend.registerCommand("IndexedDB.requestDatabaseNames", [{ "name": "securityOrigin", "type": "string", "optional": true, "description": "At least and at most one of securityOrigin, storageKey, or storageBucket must be specified. Security origin.", "typeRef": null }, { "name": "storageKey", "type": "string", "optional": true, "description": "Storage key.", "typeRef": null }, { "name": "storageBucket", "type": "object", "optional": true, "description": "Storage bucket. If not specified, it uses the default bucket.", "typeRef": "Storage.StorageBucket" }], ["databaseNames"], "Requests database names for given security origin.");
    inspectorBackend.registerType("IndexedDB.DatabaseWithObjectStores", [{ "name": "name", "type": "string", "optional": false, "description": "Database name.", "typeRef": null }, { "name": "version", "type": "number", "optional": false, "description": "Database version (type is not 'integer', as the standard requires the version number to be 'unsigned long long')", "typeRef": null }, { "name": "objectStores", "type": "array", "optional": false, "description": "Object stores in this database.", "typeRef": "IndexedDB.ObjectStore" }]);
    inspectorBackend.registerType("IndexedDB.ObjectStore", [{ "name": "name", "type": "string", "optional": false, "description": "Object store name.", "typeRef": null }, { "name": "keyPath", "type": "object", "optional": false, "description": "Object store key path.", "typeRef": "IndexedDB.KeyPath" }, { "name": "autoIncrement", "type": "boolean", "optional": false, "description": "If true, object store has auto increment flag set.", "typeRef": null }, { "name": "indexes", "type": "array", "optional": false, "description": "Indexes in this object store.", "typeRef": "IndexedDB.ObjectStoreIndex" }]);
    inspectorBackend.registerType("IndexedDB.ObjectStoreIndex", [{ "name": "name", "type": "string", "optional": false, "description": "Index name.", "typeRef": null }, { "name": "keyPath", "type": "object", "optional": false, "description": "Index key path.", "typeRef": "IndexedDB.KeyPath" }, { "name": "unique", "type": "boolean", "optional": false, "description": "If true, index is unique.", "typeRef": null }, { "name": "multiEntry", "type": "boolean", "optional": false, "description": "If true, index allows multiple entries for a key.", "typeRef": null }]);
    inspectorBackend.registerType("IndexedDB.Key", [{ "name": "type", "type": "string", "optional": false, "description": "Key type.", "typeRef": null }, { "name": "number", "type": "number", "optional": true, "description": "Number value.", "typeRef": null }, { "name": "string", "type": "string", "optional": true, "description": "String value.", "typeRef": null }, { "name": "date", "type": "number", "optional": true, "description": "Date value.", "typeRef": null }, { "name": "array", "type": "array", "optional": true, "description": "Array value.", "typeRef": "IndexedDB.Key" }]);
    inspectorBackend.registerType("IndexedDB.KeyRange", [{ "name": "lower", "type": "object", "optional": true, "description": "Lower bound.", "typeRef": "IndexedDB.Key" }, { "name": "upper", "type": "object", "optional": true, "description": "Upper bound.", "typeRef": "IndexedDB.Key" }, { "name": "lowerOpen", "type": "boolean", "optional": false, "description": "If true lower bound is open.", "typeRef": null }, { "name": "upperOpen", "type": "boolean", "optional": false, "description": "If true upper bound is open.", "typeRef": null }]);
    inspectorBackend.registerType("IndexedDB.DataEntry", [{ "name": "key", "type": "object", "optional": false, "description": "Key object.", "typeRef": "Runtime.RemoteObject" }, { "name": "primaryKey", "type": "object", "optional": false, "description": "Primary key object.", "typeRef": "Runtime.RemoteObject" }, { "name": "value", "type": "object", "optional": false, "description": "Value object.", "typeRef": "Runtime.RemoteObject" }]);
    inspectorBackend.registerType("IndexedDB.KeyPath", [{ "name": "type", "type": "string", "optional": false, "description": "Key path type.", "typeRef": null }, { "name": "string", "type": "string", "optional": true, "description": "String value.", "typeRef": null }, { "name": "array", "type": "array", "optional": true, "description": "Array value.", "typeRef": "string" }]);
    // Input.
    inspectorBackend.registerEnum("Input.GestureSourceType", { Default: "default", Touch: "touch", Mouse: "mouse" });
    inspectorBackend.registerEnum("Input.MouseButton", { None: "none", Left: "left", Middle: "middle", Right: "right", Back: "back", Forward: "forward" });
    inspectorBackend.registerEvent("Input.dragIntercepted", ["data"]);
    inspectorBackend.registerEnum("Input.DispatchDragEventRequestType", { DragEnter: "dragEnter", DragOver: "dragOver", Drop: "drop", DragCancel: "dragCancel" });
    inspectorBackend.registerCommand("Input.dispatchDragEvent", [{ "name": "type", "type": "string", "optional": false, "description": "Type of the drag event.", "typeRef": "Input.DispatchDragEventRequestType" }, { "name": "x", "type": "number", "optional": false, "description": "X coordinate of the event relative to the main frame's viewport in CSS pixels.", "typeRef": null }, { "name": "y", "type": "number", "optional": false, "description": "Y coordinate of the event relative to the main frame's viewport in CSS pixels. 0 refers to the top of the viewport and Y increases as it proceeds towards the bottom of the viewport.", "typeRef": null }, { "name": "data", "type": "object", "optional": false, "description": "", "typeRef": "Input.DragData" }, { "name": "modifiers", "type": "number", "optional": true, "description": "Bit field representing pressed modifier keys. Alt=1, Ctrl=2, Meta/Command=4, Shift=8 (default: 0).", "typeRef": null }], [], "Dispatches a drag event into the page.");
    inspectorBackend.registerEnum("Input.DispatchKeyEventRequestType", { KeyDown: "keyDown", KeyUp: "keyUp", RawKeyDown: "rawKeyDown", Char: "char" });
    inspectorBackend.registerCommand("Input.dispatchKeyEvent", [{ "name": "type", "type": "string", "optional": false, "description": "Type of the key event.", "typeRef": "Input.DispatchKeyEventRequestType" }, { "name": "modifiers", "type": "number", "optional": true, "description": "Bit field representing pressed modifier keys. Alt=1, Ctrl=2, Meta/Command=4, Shift=8 (default: 0).", "typeRef": null }, { "name": "timestamp", "type": "number", "optional": true, "description": "Time at which the event occurred.", "typeRef": "Input.TimeSinceEpoch" }, { "name": "text", "type": "string", "optional": true, "description": "Text as generated by processing a virtual key code with a keyboard layout. Not needed for for `keyUp` and `rawKeyDown` events (default: \\\"\\\")", "typeRef": null }, { "name": "unmodifiedText", "type": "string", "optional": true, "description": "Text that would have been generated by the keyboard if no modifiers were pressed (except for shift). Useful for shortcut (accelerator) key handling (default: \\\"\\\").", "typeRef": null }, { "name": "keyIdentifier", "type": "string", "optional": true, "description": "Unique key identifier (e.g., 'U+0041') (default: \\\"\\\").", "typeRef": null }, { "name": "code", "type": "string", "optional": true, "description": "Unique DOM defined string value for each physical key (e.g., 'KeyA') (default: \\\"\\\").", "typeRef": null }, { "name": "key", "type": "string", "optional": true, "description": "Unique DOM defined string value describing the meaning of the key in the context of active modifiers, keyboard layout, etc (e.g., 'AltGr') (default: \\\"\\\").", "typeRef": null }, { "name": "windowsVirtualKeyCode", "type": "number", "optional": true, "description": "Windows virtual key code (default: 0).", "typeRef": null }, { "name": "nativeVirtualKeyCode", "type": "number", "optional": true, "description": "Native virtual key code (default: 0).", "typeRef": null }, { "name": "autoRepeat", "type": "boolean", "optional": true, "description": "Whether the event was generated from auto repeat (default: false).", "typeRef": null }, { "name": "isKeypad", "type": "boolean", "optional": true, "description": "Whether the event was generated from the keypad (default: false).", "typeRef": null }, { "name": "isSystemKey", "type": "boolean", "optional": true, "description": "Whether the event was a system key event (default: false).", "typeRef": null }, { "name": "location", "type": "number", "optional": true, "description": "Whether the event was from the left or right side of the keyboard. 1=Left, 2=Right (default: 0).", "typeRef": null }, { "name": "commands", "type": "array", "optional": true, "description": "Editing commands to send with the key event (e.g., 'selectAll') (default: []). These are related to but not equal the command names used in `document.execCommand` and NSStandardKeyBindingResponding. See https://source.chromium.org/chromium/chromium/src/+/main:third_party/blink/renderer/core/editing/commands/editor_command_names.h for valid command names.", "typeRef": "string" }], [], "Dispatches a key event to the page.");
    inspectorBackend.registerCommand("Input.insertText", [{ "name": "text", "type": "string", "optional": false, "description": "The text to insert.", "typeRef": null }], [], "This method emulates inserting text that doesn't come from a key press, for example an emoji keyboard or an IME.");
    inspectorBackend.registerCommand("Input.imeSetComposition", [{ "name": "text", "type": "string", "optional": false, "description": "The text to insert", "typeRef": null }, { "name": "selectionStart", "type": "number", "optional": false, "description": "selection start", "typeRef": null }, { "name": "selectionEnd", "type": "number", "optional": false, "description": "selection end", "typeRef": null }, { "name": "replacementStart", "type": "number", "optional": true, "description": "replacement start", "typeRef": null }, { "name": "replacementEnd", "type": "number", "optional": true, "description": "replacement end", "typeRef": null }], [], "This method sets the current candidate text for IME. Use imeCommitComposition to commit the final text. Use imeSetComposition with empty string as text to cancel composition.");
    inspectorBackend.registerEnum("Input.DispatchMouseEventRequestType", { MousePressed: "mousePressed", MouseReleased: "mouseReleased", MouseMoved: "mouseMoved", MouseWheel: "mouseWheel" });
    inspectorBackend.registerEnum("Input.DispatchMouseEventRequestPointerType", { Mouse: "mouse", Pen: "pen" });
    inspectorBackend.registerCommand("Input.dispatchMouseEvent", [{ "name": "type", "type": "string", "optional": false, "description": "Type of the mouse event.", "typeRef": "Input.DispatchMouseEventRequestType" }, { "name": "x", "type": "number", "optional": false, "description": "X coordinate of the event relative to the main frame's viewport in CSS pixels.", "typeRef": null }, { "name": "y", "type": "number", "optional": false, "description": "Y coordinate of the event relative to the main frame's viewport in CSS pixels. 0 refers to the top of the viewport and Y increases as it proceeds towards the bottom of the viewport.", "typeRef": null }, { "name": "modifiers", "type": "number", "optional": true, "description": "Bit field representing pressed modifier keys. Alt=1, Ctrl=2, Meta/Command=4, Shift=8 (default: 0).", "typeRef": null }, { "name": "timestamp", "type": "number", "optional": true, "description": "Time at which the event occurred.", "typeRef": "Input.TimeSinceEpoch" }, { "name": "button", "type": "string", "optional": true, "description": "Mouse button (default: \\\"none\\\").", "typeRef": "Input.MouseButton" }, { "name": "buttons", "type": "number", "optional": true, "description": "A number indicating which buttons are pressed on the mouse when a mouse event is triggered. Left=1, Right=2, Middle=4, Back=8, Forward=16, None=0.", "typeRef": null }, { "name": "clickCount", "type": "number", "optional": true, "description": "Number of times the mouse button was clicked (default: 0).", "typeRef": null }, { "name": "force", "type": "number", "optional": true, "description": "The normalized pressure, which has a range of [0,1] (default: 0).", "typeRef": null }, { "name": "tangentialPressure", "type": "number", "optional": true, "description": "The normalized tangential pressure, which has a range of [-1,1] (default: 0).", "typeRef": null }, { "name": "tiltX", "type": "number", "optional": true, "description": "The plane angle between the Y-Z plane and the plane containing both the stylus axis and the Y axis, in degrees of the range [-90,90], a positive tiltX is to the right (default: 0).", "typeRef": null }, { "name": "tiltY", "type": "number", "optional": true, "description": "The plane angle between the X-Z plane and the plane containing both the stylus axis and the X axis, in degrees of the range [-90,90], a positive tiltY is towards the user (default: 0).", "typeRef": null }, { "name": "twist", "type": "number", "optional": true, "description": "The clockwise rotation of a pen stylus around its own major axis, in degrees in the range [0,359] (default: 0).", "typeRef": null }, { "name": "deltaX", "type": "number", "optional": true, "description": "X delta in CSS pixels for mouse wheel event (default: 0).", "typeRef": null }, { "name": "deltaY", "type": "number", "optional": true, "description": "Y delta in CSS pixels for mouse wheel event (default: 0).", "typeRef": null }, { "name": "pointerType", "type": "string", "optional": true, "description": "Pointer type (default: \\\"mouse\\\").", "typeRef": "Input.DispatchMouseEventRequestPointerType" }], [], "Dispatches a mouse event to the page.");
    inspectorBackend.registerEnum("Input.DispatchTouchEventRequestType", { TouchStart: "touchStart", TouchEnd: "touchEnd", TouchMove: "touchMove", TouchCancel: "touchCancel" });
    inspectorBackend.registerCommand("Input.dispatchTouchEvent", [{ "name": "type", "type": "string", "optional": false, "description": "Type of the touch event. TouchEnd and TouchCancel must not contain any touch points, while TouchStart and TouchMove must contains at least one.", "typeRef": "Input.DispatchTouchEventRequestType" }, { "name": "touchPoints", "type": "array", "optional": false, "description": "Active touch points on the touch device. One event per any changed point (compared to previous touch event in a sequence) is generated, emulating pressing/moving/releasing points one by one.", "typeRef": "Input.TouchPoint" }, { "name": "modifiers", "type": "number", "optional": true, "description": "Bit field representing pressed modifier keys. Alt=1, Ctrl=2, Meta/Command=4, Shift=8 (default: 0).", "typeRef": null }, { "name": "timestamp", "type": "number", "optional": true, "description": "Time at which the event occurred.", "typeRef": "Input.TimeSinceEpoch" }], [], "Dispatches a touch event to the page.");
    inspectorBackend.registerCommand("Input.cancelDragging", [], [], "Cancels any active dragging in the page.");
    inspectorBackend.registerEnum("Input.EmulateTouchFromMouseEventRequestType", { MousePressed: "mousePressed", MouseReleased: "mouseReleased", MouseMoved: "mouseMoved", MouseWheel: "mouseWheel" });
    inspectorBackend.registerCommand("Input.emulateTouchFromMouseEvent", [{ "name": "type", "type": "string", "optional": false, "description": "Type of the mouse event.", "typeRef": "Input.EmulateTouchFromMouseEventRequestType" }, { "name": "x", "type": "number", "optional": false, "description": "X coordinate of the mouse pointer in DIP.", "typeRef": null }, { "name": "y", "type": "number", "optional": false, "description": "Y coordinate of the mouse pointer in DIP.", "typeRef": null }, { "name": "button", "type": "string", "optional": false, "description": "Mouse button. Only \\\"none\\\", \\\"left\\\", \\\"right\\\" are supported.", "typeRef": "Input.MouseButton" }, { "name": "timestamp", "type": "number", "optional": true, "description": "Time at which the event occurred (default: current time).", "typeRef": "Input.TimeSinceEpoch" }, { "name": "deltaX", "type": "number", "optional": true, "description": "X delta in DIP for mouse wheel event (default: 0).", "typeRef": null }, { "name": "deltaY", "type": "number", "optional": true, "description": "Y delta in DIP for mouse wheel event (default: 0).", "typeRef": null }, { "name": "modifiers", "type": "number", "optional": true, "description": "Bit field representing pressed modifier keys. Alt=1, Ctrl=2, Meta/Command=4, Shift=8 (default: 0).", "typeRef": null }, { "name": "clickCount", "type": "number", "optional": true, "description": "Number of times the mouse button was clicked (default: 0).", "typeRef": null }], [], "Emulates touch event from the mouse event parameters.");
    inspectorBackend.registerCommand("Input.setIgnoreInputEvents", [{ "name": "ignore", "type": "boolean", "optional": false, "description": "Ignores input events processing when set to true.", "typeRef": null }], [], "Ignores input events (useful while auditing page).");
    inspectorBackend.registerCommand("Input.setInterceptDrags", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "", "typeRef": null }], [], "Prevents default drag and drop behavior and instead emits `Input.dragIntercepted` events. Drag and drop behavior can be directly controlled via `Input.dispatchDragEvent`.");
    inspectorBackend.registerCommand("Input.synthesizePinchGesture", [{ "name": "x", "type": "number", "optional": false, "description": "X coordinate of the start of the gesture in CSS pixels.", "typeRef": null }, { "name": "y", "type": "number", "optional": false, "description": "Y coordinate of the start of the gesture in CSS pixels.", "typeRef": null }, { "name": "scaleFactor", "type": "number", "optional": false, "description": "Relative scale factor after zooming (>1.0 zooms in, <1.0 zooms out).", "typeRef": null }, { "name": "relativeSpeed", "type": "number", "optional": true, "description": "Relative pointer speed in pixels per second (default: 800).", "typeRef": null }, { "name": "gestureSourceType", "type": "string", "optional": true, "description": "Which type of input events to be generated (default: 'default', which queries the platform for the preferred input type).", "typeRef": "Input.GestureSourceType" }], [], "Synthesizes a pinch gesture over a time period by issuing appropriate touch events.");
    inspectorBackend.registerCommand("Input.synthesizeScrollGesture", [{ "name": "x", "type": "number", "optional": false, "description": "X coordinate of the start of the gesture in CSS pixels.", "typeRef": null }, { "name": "y", "type": "number", "optional": false, "description": "Y coordinate of the start of the gesture in CSS pixels.", "typeRef": null }, { "name": "xDistance", "type": "number", "optional": true, "description": "The distance to scroll along the X axis (positive to scroll left).", "typeRef": null }, { "name": "yDistance", "type": "number", "optional": true, "description": "The distance to scroll along the Y axis (positive to scroll up).", "typeRef": null }, { "name": "xOverscroll", "type": "number", "optional": true, "description": "The number of additional pixels to scroll back along the X axis, in addition to the given distance.", "typeRef": null }, { "name": "yOverscroll", "type": "number", "optional": true, "description": "The number of additional pixels to scroll back along the Y axis, in addition to the given distance.", "typeRef": null }, { "name": "preventFling", "type": "boolean", "optional": true, "description": "Prevent fling (default: true).", "typeRef": null }, { "name": "speed", "type": "number", "optional": true, "description": "Swipe speed in pixels per second (default: 800).", "typeRef": null }, { "name": "gestureSourceType", "type": "string", "optional": true, "description": "Which type of input events to be generated (default: 'default', which queries the platform for the preferred input type).", "typeRef": "Input.GestureSourceType" }, { "name": "repeatCount", "type": "number", "optional": true, "description": "The number of times to repeat the gesture (default: 0).", "typeRef": null }, { "name": "repeatDelayMs", "type": "number", "optional": true, "description": "The number of milliseconds delay between each repeat. (default: 250).", "typeRef": null }, { "name": "interactionMarkerName", "type": "string", "optional": true, "description": "The name of the interaction markers to generate, if not empty (default: \\\"\\\").", "typeRef": null }], [], "Synthesizes a scroll gesture over a time period by issuing appropriate touch events.");
    inspectorBackend.registerCommand("Input.synthesizeTapGesture", [{ "name": "x", "type": "number", "optional": false, "description": "X coordinate of the start of the gesture in CSS pixels.", "typeRef": null }, { "name": "y", "type": "number", "optional": false, "description": "Y coordinate of the start of the gesture in CSS pixels.", "typeRef": null }, { "name": "duration", "type": "number", "optional": true, "description": "Duration between touchdown and touchup events in ms (default: 50).", "typeRef": null }, { "name": "tapCount", "type": "number", "optional": true, "description": "Number of times to perform the tap (e.g. 2 for double tap, default: 1).", "typeRef": null }, { "name": "gestureSourceType", "type": "string", "optional": true, "description": "Which type of input events to be generated (default: 'default', which queries the platform for the preferred input type).", "typeRef": "Input.GestureSourceType" }], [], "Synthesizes a tap gesture over a time period by issuing appropriate touch events.");
    inspectorBackend.registerType("Input.TouchPoint", [{ "name": "x", "type": "number", "optional": false, "description": "X coordinate of the event relative to the main frame's viewport in CSS pixels.", "typeRef": null }, { "name": "y", "type": "number", "optional": false, "description": "Y coordinate of the event relative to the main frame's viewport in CSS pixels. 0 refers to the top of the viewport and Y increases as it proceeds towards the bottom of the viewport.", "typeRef": null }, { "name": "radiusX", "type": "number", "optional": true, "description": "X radius of the touch area (default: 1.0).", "typeRef": null }, { "name": "radiusY", "type": "number", "optional": true, "description": "Y radius of the touch area (default: 1.0).", "typeRef": null }, { "name": "rotationAngle", "type": "number", "optional": true, "description": "Rotation angle (default: 0.0).", "typeRef": null }, { "name": "force", "type": "number", "optional": true, "description": "Force (default: 1.0).", "typeRef": null }, { "name": "tangentialPressure", "type": "number", "optional": true, "description": "The normalized tangential pressure, which has a range of [-1,1] (default: 0).", "typeRef": null }, { "name": "tiltX", "type": "number", "optional": true, "description": "The plane angle between the Y-Z plane and the plane containing both the stylus axis and the Y axis, in degrees of the range [-90,90], a positive tiltX is to the right (default: 0)", "typeRef": null }, { "name": "tiltY", "type": "number", "optional": true, "description": "The plane angle between the X-Z plane and the plane containing both the stylus axis and the X axis, in degrees of the range [-90,90], a positive tiltY is towards the user (default: 0).", "typeRef": null }, { "name": "twist", "type": "number", "optional": true, "description": "The clockwise rotation of a pen stylus around its own major axis, in degrees in the range [0,359] (default: 0).", "typeRef": null }, { "name": "id", "type": "number", "optional": true, "description": "Identifier used to track touch sources between events, must be unique within an event.", "typeRef": null }]);
    inspectorBackend.registerType("Input.DragDataItem", [{ "name": "mimeType", "type": "string", "optional": false, "description": "Mime type of the dragged data.", "typeRef": null }, { "name": "data", "type": "string", "optional": false, "description": "Depending of the value of `mimeType`, it contains the dragged link, text, HTML markup or any other data.", "typeRef": null }, { "name": "title", "type": "string", "optional": true, "description": "Title associated with a link. Only valid when `mimeType` == \\\"text/uri-list\\\".", "typeRef": null }, { "name": "baseURL", "type": "string", "optional": true, "description": "Stores the base URL for the contained markup. Only valid when `mimeType` == \\\"text/html\\\".", "typeRef": null }]);
    inspectorBackend.registerType("Input.DragData", [{ "name": "items", "type": "array", "optional": false, "description": "", "typeRef": "Input.DragDataItem" }, { "name": "files", "type": "array", "optional": true, "description": "List of filenames that should be included when dropping", "typeRef": "string" }, { "name": "dragOperationsMask", "type": "number", "optional": false, "description": "Bit field representing allowed drag operations. Copy = 1, Link = 2, Move = 16", "typeRef": null }]);
    // Inspector.
    inspectorBackend.registerEvent("Inspector.detached", ["reason"]);
    inspectorBackend.registerEvent("Inspector.targetCrashed", []);
    inspectorBackend.registerEvent("Inspector.targetReloadedAfterCrash", []);
    inspectorBackend.registerEvent("Inspector.workerScriptLoaded", []);
    inspectorBackend.registerCommand("Inspector.disable", [], [], "Disables inspector domain notifications.");
    inspectorBackend.registerCommand("Inspector.enable", [], [], "Enables inspector domain notifications.");
    // LayerTree.
    inspectorBackend.registerEnum("LayerTree.ScrollRectType", { RepaintsOnScroll: "RepaintsOnScroll", TouchEventHandler: "TouchEventHandler", WheelEventHandler: "WheelEventHandler" });
    inspectorBackend.registerEvent("LayerTree.layerPainted", ["layerId", "clip"]);
    inspectorBackend.registerEvent("LayerTree.layerTreeDidChange", ["layers"]);
    inspectorBackend.registerCommand("LayerTree.compositingReasons", [{ "name": "layerId", "type": "string", "optional": false, "description": "The id of the layer for which we want to get the reasons it was composited.", "typeRef": "LayerTree.LayerId" }], ["compositingReasons", "compositingReasonIds"], "Provides the reasons why the given layer was composited.");
    inspectorBackend.registerCommand("LayerTree.disable", [], [], "Disables compositing tree inspection.");
    inspectorBackend.registerCommand("LayerTree.enable", [], [], "Enables compositing tree inspection.");
    inspectorBackend.registerCommand("LayerTree.loadSnapshot", [{ "name": "tiles", "type": "array", "optional": false, "description": "An array of tiles composing the snapshot.", "typeRef": "LayerTree.PictureTile" }], ["snapshotId"], "Returns the snapshot identifier.");
    inspectorBackend.registerCommand("LayerTree.makeSnapshot", [{ "name": "layerId", "type": "string", "optional": false, "description": "The id of the layer.", "typeRef": "LayerTree.LayerId" }], ["snapshotId"], "Returns the layer snapshot identifier.");
    inspectorBackend.registerCommand("LayerTree.profileSnapshot", [{ "name": "snapshotId", "type": "string", "optional": false, "description": "The id of the layer snapshot.", "typeRef": "LayerTree.SnapshotId" }, { "name": "minRepeatCount", "type": "number", "optional": true, "description": "The maximum number of times to replay the snapshot (1, if not specified).", "typeRef": null }, { "name": "minDuration", "type": "number", "optional": true, "description": "The minimum duration (in seconds) to replay the snapshot.", "typeRef": null }, { "name": "clipRect", "type": "object", "optional": true, "description": "The clip rectangle to apply when replaying the snapshot.", "typeRef": "DOM.Rect" }], ["timings"], "");
    inspectorBackend.registerCommand("LayerTree.releaseSnapshot", [{ "name": "snapshotId", "type": "string", "optional": false, "description": "The id of the layer snapshot.", "typeRef": "LayerTree.SnapshotId" }], [], "Releases layer snapshot captured by the back-end.");
    inspectorBackend.registerCommand("LayerTree.replaySnapshot", [{ "name": "snapshotId", "type": "string", "optional": false, "description": "The id of the layer snapshot.", "typeRef": "LayerTree.SnapshotId" }, { "name": "fromStep", "type": "number", "optional": true, "description": "The first step to replay from (replay from the very start if not specified).", "typeRef": null }, { "name": "toStep", "type": "number", "optional": true, "description": "The last step to replay to (replay till the end if not specified).", "typeRef": null }, { "name": "scale", "type": "number", "optional": true, "description": "The scale to apply while replaying (defaults to 1).", "typeRef": null }], ["dataURL"], "Replays the layer snapshot and returns the resulting bitmap.");
    inspectorBackend.registerCommand("LayerTree.snapshotCommandLog", [{ "name": "snapshotId", "type": "string", "optional": false, "description": "The id of the layer snapshot.", "typeRef": "LayerTree.SnapshotId" }], ["commandLog"], "Replays the layer snapshot and returns canvas log.");
    inspectorBackend.registerType("LayerTree.ScrollRect", [{ "name": "rect", "type": "object", "optional": false, "description": "Rectangle itself.", "typeRef": "DOM.Rect" }, { "name": "type", "type": "string", "optional": false, "description": "Reason for rectangle to force scrolling on the main thread", "typeRef": null }]);
    inspectorBackend.registerType("LayerTree.StickyPositionConstraint", [{ "name": "stickyBoxRect", "type": "object", "optional": false, "description": "Layout rectangle of the sticky element before being shifted", "typeRef": "DOM.Rect" }, { "name": "containingBlockRect", "type": "object", "optional": false, "description": "Layout rectangle of the containing block of the sticky element", "typeRef": "DOM.Rect" }, { "name": "nearestLayerShiftingStickyBox", "type": "string", "optional": true, "description": "The nearest sticky layer that shifts the sticky box", "typeRef": "LayerTree.LayerId" }, { "name": "nearestLayerShiftingContainingBlock", "type": "string", "optional": true, "description": "The nearest sticky layer that shifts the containing block", "typeRef": "LayerTree.LayerId" }]);
    inspectorBackend.registerType("LayerTree.PictureTile", [{ "name": "x", "type": "number", "optional": false, "description": "Offset from owning layer left boundary", "typeRef": null }, { "name": "y", "type": "number", "optional": false, "description": "Offset from owning layer top boundary", "typeRef": null }, { "name": "picture", "type": "string", "optional": false, "description": "Base64-encoded snapshot data.", "typeRef": null }]);
    inspectorBackend.registerType("LayerTree.Layer", [{ "name": "layerId", "type": "string", "optional": false, "description": "The unique id for this layer.", "typeRef": "LayerTree.LayerId" }, { "name": "parentLayerId", "type": "string", "optional": true, "description": "The id of parent (not present for root).", "typeRef": "LayerTree.LayerId" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "The backend id for the node associated with this layer.", "typeRef": "DOM.BackendNodeId" }, { "name": "offsetX", "type": "number", "optional": false, "description": "Offset from parent layer, X coordinate.", "typeRef": null }, { "name": "offsetY", "type": "number", "optional": false, "description": "Offset from parent layer, Y coordinate.", "typeRef": null }, { "name": "width", "type": "number", "optional": false, "description": "Layer width.", "typeRef": null }, { "name": "height", "type": "number", "optional": false, "description": "Layer height.", "typeRef": null }, { "name": "transform", "type": "array", "optional": true, "description": "Transformation matrix for layer, default is identity matrix", "typeRef": "number" }, { "name": "anchorX", "type": "number", "optional": true, "description": "Transform anchor point X, absent if no transform specified", "typeRef": null }, { "name": "anchorY", "type": "number", "optional": true, "description": "Transform anchor point Y, absent if no transform specified", "typeRef": null }, { "name": "anchorZ", "type": "number", "optional": true, "description": "Transform anchor point Z, absent if no transform specified", "typeRef": null }, { "name": "paintCount", "type": "number", "optional": false, "description": "Indicates how many time this layer has painted.", "typeRef": null }, { "name": "drawsContent", "type": "boolean", "optional": false, "description": "Indicates whether this layer hosts any content, rather than being used for transform/scrolling purposes only.", "typeRef": null }, { "name": "invisible", "type": "boolean", "optional": true, "description": "Set if layer is not visible.", "typeRef": null }, { "name": "scrollRects", "type": "array", "optional": true, "description": "Rectangles scrolling on main thread only.", "typeRef": "LayerTree.ScrollRect" }, { "name": "stickyPositionConstraint", "type": "object", "optional": true, "description": "Sticky position constraint information", "typeRef": "LayerTree.StickyPositionConstraint" }]);
    inspectorBackend.registerType("LayerTree.PaintProfile", [{ "name": "PaintProfile", "type": "array", "optional": false, "description": "Array of timings, one per paint step.", "typeRef": "number" }]);
    // Log.
    inspectorBackend.registerEnum("Log.LogEntrySource", { XML: "xml", Javascript: "javascript", Network: "network", Storage: "storage", Appcache: "appcache", Rendering: "rendering", Security: "security", Deprecation: "deprecation", Worker: "worker", Violation: "violation", Intervention: "intervention", Recommendation: "recommendation", Other: "other" });
    inspectorBackend.registerEnum("Log.LogEntryLevel", { Verbose: "verbose", Info: "info", Warning: "warning", Error: "error" });
    inspectorBackend.registerEnum("Log.LogEntryCategory", { Cors: "cors" });
    inspectorBackend.registerEnum("Log.ViolationSettingName", { LongTask: "longTask", LongLayout: "longLayout", BlockedEvent: "blockedEvent", BlockedParser: "blockedParser", DiscouragedAPIUse: "discouragedAPIUse", Handler: "handler", RecurringHandler: "recurringHandler" });
    inspectorBackend.registerEvent("Log.entryAdded", ["entry"]);
    inspectorBackend.registerCommand("Log.clear", [], [], "Clears the log.");
    inspectorBackend.registerCommand("Log.disable", [], [], "Disables log domain, prevents further log entries from being reported to the client.");
    inspectorBackend.registerCommand("Log.enable", [], [], "Enables log domain, sends the entries collected so far to the client by means of the `entryAdded` notification.");
    inspectorBackend.registerCommand("Log.startViolationsReport", [{ "name": "config", "type": "array", "optional": false, "description": "Configuration for violations.", "typeRef": "Log.ViolationSetting" }], [], "start violation reporting.");
    inspectorBackend.registerCommand("Log.stopViolationsReport", [], [], "Stop violation reporting.");
    inspectorBackend.registerType("Log.LogEntry", [{ "name": "source", "type": "string", "optional": false, "description": "Log entry source.", "typeRef": null }, { "name": "level", "type": "string", "optional": false, "description": "Log entry severity.", "typeRef": null }, { "name": "text", "type": "string", "optional": false, "description": "Logged text.", "typeRef": null }, { "name": "category", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "timestamp", "type": "number", "optional": false, "description": "Timestamp when this entry was added.", "typeRef": "Runtime.Timestamp" }, { "name": "url", "type": "string", "optional": true, "description": "URL of the resource if known.", "typeRef": null }, { "name": "lineNumber", "type": "number", "optional": true, "description": "Line number in the resource.", "typeRef": null }, { "name": "stackTrace", "type": "object", "optional": true, "description": "JavaScript stack trace.", "typeRef": "Runtime.StackTrace" }, { "name": "networkRequestId", "type": "string", "optional": true, "description": "Identifier of the network request associated with this entry.", "typeRef": "Network.RequestId" }, { "name": "workerId", "type": "string", "optional": true, "description": "Identifier of the worker associated with this entry.", "typeRef": null }, { "name": "args", "type": "array", "optional": true, "description": "Call arguments.", "typeRef": "Runtime.RemoteObject" }]);
    inspectorBackend.registerType("Log.ViolationSetting", [{ "name": "name", "type": "string", "optional": false, "description": "Violation type.", "typeRef": null }, { "name": "threshold", "type": "number", "optional": false, "description": "Time threshold to trigger upon.", "typeRef": null }]);
    // Media.
    inspectorBackend.registerEnum("Media.PlayerMessageLevel", { Error: "error", Warning: "warning", Info: "info", Debug: "debug" });
    inspectorBackend.registerEvent("Media.playerPropertiesChanged", ["playerId", "properties"]);
    inspectorBackend.registerEvent("Media.playerEventsAdded", ["playerId", "events"]);
    inspectorBackend.registerEvent("Media.playerMessagesLogged", ["playerId", "messages"]);
    inspectorBackend.registerEvent("Media.playerErrorsRaised", ["playerId", "errors"]);
    inspectorBackend.registerEvent("Media.playerCreated", ["player"]);
    inspectorBackend.registerCommand("Media.enable", [], [], "Enables the Media domain");
    inspectorBackend.registerCommand("Media.disable", [], [], "Disables the Media domain.");
    inspectorBackend.registerType("Media.PlayerMessage", [{ "name": "level", "type": "string", "optional": false, "description": "Keep in sync with MediaLogMessageLevel We are currently keeping the message level 'error' separate from the PlayerError type because right now they represent different things, this one being a DVLOG(ERROR) style log message that gets printed based on what log level is selected in the UI, and the other is a representation of a media::PipelineStatus object. Soon however we're going to be moving away from using PipelineStatus for errors and introducing a new error type which should hopefully let us integrate the error log level into the PlayerError type.", "typeRef": null }, { "name": "message", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Media.PlayerProperty", [{ "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Media.PlayerEvent", [{ "name": "timestamp", "type": "number", "optional": false, "description": "", "typeRef": "Media.Timestamp" }, { "name": "value", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Media.PlayerErrorSourceLocation", [{ "name": "file", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "line", "type": "number", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Media.PlayerError", [{ "name": "errorType", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "code", "type": "number", "optional": false, "description": "Code is the numeric enum entry for a specific set of error codes, such as PipelineStatusCodes in media/base/pipeline_status.h", "typeRef": null }, { "name": "stack", "type": "array", "optional": false, "description": "A trace of where this error was caused / where it passed through.", "typeRef": "Media.PlayerErrorSourceLocation" }, { "name": "cause", "type": "array", "optional": false, "description": "Errors potentially have a root cause error, ie, a DecoderError might be caused by an WindowsError", "typeRef": "Media.PlayerError" }, { "name": "data", "type": "object", "optional": false, "description": "Extra data attached to an error, such as an HRESULT, Video Codec, etc.", "typeRef": null }]);
    inspectorBackend.registerType("Media.Player", [{ "name": "playerId", "type": "string", "optional": false, "description": "", "typeRef": "Media.PlayerId" }, { "name": "domNodeId", "type": "number", "optional": true, "description": "", "typeRef": "DOM.BackendNodeId" }]);
    // Memory.
    inspectorBackend.registerEnum("Memory.PressureLevel", { Moderate: "moderate", Critical: "critical" });
    inspectorBackend.registerCommand("Memory.getDOMCounters", [], ["documents", "nodes", "jsEventListeners"], "Retruns current DOM object counters.");
    inspectorBackend.registerCommand("Memory.getDOMCountersForLeakDetection", [], ["counters"], "Retruns DOM object counters after preparing renderer for leak detection.");
    inspectorBackend.registerCommand("Memory.prepareForLeakDetection", [], [], "Prepares for leak detection by terminating workers, stopping spellcheckers, dropping non-essential internal caches, running garbage collections, etc.");
    inspectorBackend.registerCommand("Memory.forciblyPurgeJavaScriptMemory", [], [], "Simulate OomIntervention by purging V8 memory.");
    inspectorBackend.registerCommand("Memory.setPressureNotificationsSuppressed", [{ "name": "suppressed", "type": "boolean", "optional": false, "description": "If true, memory pressure notifications will be suppressed.", "typeRef": null }], [], "Enable/disable suppressing memory pressure notifications in all processes.");
    inspectorBackend.registerCommand("Memory.simulatePressureNotification", [{ "name": "level", "type": "string", "optional": false, "description": "Memory pressure level of the notification.", "typeRef": "Memory.PressureLevel" }], [], "Simulate a memory pressure notification in all processes.");
    inspectorBackend.registerCommand("Memory.startSampling", [{ "name": "samplingInterval", "type": "number", "optional": true, "description": "Average number of bytes between samples.", "typeRef": null }, { "name": "suppressRandomness", "type": "boolean", "optional": true, "description": "Do not randomize intervals between samples.", "typeRef": null }], [], "Start collecting native memory profile.");
    inspectorBackend.registerCommand("Memory.stopSampling", [], [], "Stop collecting native memory profile.");
    inspectorBackend.registerCommand("Memory.getAllTimeSamplingProfile", [], ["profile"], "Retrieve native memory allocations profile collected since renderer process startup.");
    inspectorBackend.registerCommand("Memory.getBrowserSamplingProfile", [], ["profile"], "Retrieve native memory allocations profile collected since browser process startup.");
    inspectorBackend.registerCommand("Memory.getSamplingProfile", [], ["profile"], "Retrieve native memory allocations profile collected since last `startSampling` call.");
    inspectorBackend.registerType("Memory.SamplingProfileNode", [{ "name": "size", "type": "number", "optional": false, "description": "Size of the sampled allocation.", "typeRef": null }, { "name": "total", "type": "number", "optional": false, "description": "Total bytes attributed to this sample.", "typeRef": null }, { "name": "stack", "type": "array", "optional": false, "description": "Execution stack at the point of allocation.", "typeRef": "string" }]);
    inspectorBackend.registerType("Memory.SamplingProfile", [{ "name": "samples", "type": "array", "optional": false, "description": "", "typeRef": "Memory.SamplingProfileNode" }, { "name": "modules", "type": "array", "optional": false, "description": "", "typeRef": "Memory.Module" }]);
    inspectorBackend.registerType("Memory.Module", [{ "name": "name", "type": "string", "optional": false, "description": "Name of the module.", "typeRef": null }, { "name": "uuid", "type": "string", "optional": false, "description": "UUID of the module.", "typeRef": null }, { "name": "baseAddress", "type": "string", "optional": false, "description": "Base address where the module is loaded into memory. Encoded as a decimal or hexadecimal (0x prefixed) string.", "typeRef": null }, { "name": "size", "type": "number", "optional": false, "description": "Size of the module in bytes.", "typeRef": null }]);
    inspectorBackend.registerType("Memory.DOMCounter", [{ "name": "name", "type": "string", "optional": false, "description": "Object name. Note: object names should be presumed volatile and clients should not expect the returned names to be consistent across runs.", "typeRef": null }, { "name": "count", "type": "number", "optional": false, "description": "Object count.", "typeRef": null }]);
    // Network.
    inspectorBackend.registerEnum("Network.ResourceType", { Document: "Document", Stylesheet: "Stylesheet", Image: "Image", Media: "Media", Font: "Font", Script: "Script", TextTrack: "TextTrack", XHR: "XHR", Fetch: "Fetch", Prefetch: "Prefetch", EventSource: "EventSource", WebSocket: "WebSocket", Manifest: "Manifest", SignedExchange: "SignedExchange", Ping: "Ping", CSPViolationReport: "CSPViolationReport", Preflight: "Preflight", FedCM: "FedCM", Other: "Other" });
    inspectorBackend.registerEnum("Network.ErrorReason", { Failed: "Failed", Aborted: "Aborted", TimedOut: "TimedOut", AccessDenied: "AccessDenied", ConnectionClosed: "ConnectionClosed", ConnectionReset: "ConnectionReset", ConnectionRefused: "ConnectionRefused", ConnectionAborted: "ConnectionAborted", ConnectionFailed: "ConnectionFailed", NameNotResolved: "NameNotResolved", InternetDisconnected: "InternetDisconnected", AddressUnreachable: "AddressUnreachable", BlockedByClient: "BlockedByClient", BlockedByResponse: "BlockedByResponse" });
    inspectorBackend.registerEnum("Network.ConnectionType", { None: "none", Cellular2g: "cellular2g", Cellular3g: "cellular3g", Cellular4g: "cellular4g", Bluetooth: "bluetooth", Ethernet: "ethernet", Wifi: "wifi", Wimax: "wimax", Other: "other" });
    inspectorBackend.registerEnum("Network.CookieSameSite", { Strict: "Strict", Lax: "Lax", None: "None" });
    inspectorBackend.registerEnum("Network.CookiePriority", { Low: "Low", Medium: "Medium", High: "High" });
    inspectorBackend.registerEnum("Network.CookieSourceScheme", { Unset: "Unset", NonSecure: "NonSecure", Secure: "Secure" });
    inspectorBackend.registerEnum("Network.ResourcePriority", { VeryLow: "VeryLow", Low: "Low", Medium: "Medium", High: "High", VeryHigh: "VeryHigh" });
    inspectorBackend.registerEnum("Network.RequestReferrerPolicy", { UnsafeUrl: "unsafe-url", NoReferrerWhenDowngrade: "no-referrer-when-downgrade", NoReferrer: "no-referrer", Origin: "origin", OriginWhenCrossOrigin: "origin-when-cross-origin", SameOrigin: "same-origin", StrictOrigin: "strict-origin", StrictOriginWhenCrossOrigin: "strict-origin-when-cross-origin" });
    inspectorBackend.registerEnum("Network.CertificateTransparencyCompliance", { Unknown: "unknown", NotCompliant: "not-compliant", Compliant: "compliant" });
    inspectorBackend.registerEnum("Network.BlockedReason", { Other: "other", Csp: "csp", MixedContent: "mixed-content", Origin: "origin", Inspector: "inspector", Integrity: "integrity", SubresourceFilter: "subresource-filter", ContentType: "content-type", CoepFrameResourceNeedsCoepHeader: "coep-frame-resource-needs-coep-header", CoopSandboxedIframeCannotNavigateToCoopPage: "coop-sandboxed-iframe-cannot-navigate-to-coop-page", CorpNotSameOrigin: "corp-not-same-origin", CorpNotSameOriginAfterDefaultedToSameOriginByCoep: "corp-not-same-origin-after-defaulted-to-same-origin-by-coep", CorpNotSameOriginAfterDefaultedToSameOriginByDip: "corp-not-same-origin-after-defaulted-to-same-origin-by-dip", CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip: "corp-not-same-origin-after-defaulted-to-same-origin-by-coep-and-dip", CorpNotSameSite: "corp-not-same-site", SriMessageSignatureMismatch: "sri-message-signature-mismatch" });
    inspectorBackend.registerEnum("Network.IpProxyStatus", { Available: "Available", FeatureNotEnabled: "FeatureNotEnabled", MaskedDomainListNotEnabled: "MaskedDomainListNotEnabled", MaskedDomainListNotPopulated: "MaskedDomainListNotPopulated", AuthTokensUnavailable: "AuthTokensUnavailable", Unavailable: "Unavailable", BypassedByDevTools: "BypassedByDevTools" });
    inspectorBackend.registerEnum("Network.CorsError", { DisallowedByMode: "DisallowedByMode", InvalidResponse: "InvalidResponse", WildcardOriginNotAllowed: "WildcardOriginNotAllowed", MissingAllowOriginHeader: "MissingAllowOriginHeader", MultipleAllowOriginValues: "MultipleAllowOriginValues", InvalidAllowOriginValue: "InvalidAllowOriginValue", AllowOriginMismatch: "AllowOriginMismatch", InvalidAllowCredentials: "InvalidAllowCredentials", CorsDisabledScheme: "CorsDisabledScheme", PreflightInvalidStatus: "PreflightInvalidStatus", PreflightDisallowedRedirect: "PreflightDisallowedRedirect", PreflightWildcardOriginNotAllowed: "PreflightWildcardOriginNotAllowed", PreflightMissingAllowOriginHeader: "PreflightMissingAllowOriginHeader", PreflightMultipleAllowOriginValues: "PreflightMultipleAllowOriginValues", PreflightInvalidAllowOriginValue: "PreflightInvalidAllowOriginValue", PreflightAllowOriginMismatch: "PreflightAllowOriginMismatch", PreflightInvalidAllowCredentials: "PreflightInvalidAllowCredentials", PreflightMissingAllowExternal: "PreflightMissingAllowExternal", PreflightInvalidAllowExternal: "PreflightInvalidAllowExternal", PreflightMissingAllowPrivateNetwork: "PreflightMissingAllowPrivateNetwork", PreflightInvalidAllowPrivateNetwork: "PreflightInvalidAllowPrivateNetwork", InvalidAllowMethodsPreflightResponse: "InvalidAllowMethodsPreflightResponse", InvalidAllowHeadersPreflightResponse: "InvalidAllowHeadersPreflightResponse", MethodDisallowedByPreflightResponse: "MethodDisallowedByPreflightResponse", HeaderDisallowedByPreflightResponse: "HeaderDisallowedByPreflightResponse", RedirectContainsCredentials: "RedirectContainsCredentials", InsecurePrivateNetwork: "InsecurePrivateNetwork", InvalidPrivateNetworkAccess: "InvalidPrivateNetworkAccess", UnexpectedPrivateNetworkAccess: "UnexpectedPrivateNetworkAccess", NoCorsRedirectModeNotFollow: "NoCorsRedirectModeNotFollow", PreflightMissingPrivateNetworkAccessId: "PreflightMissingPrivateNetworkAccessId", PreflightMissingPrivateNetworkAccessName: "PreflightMissingPrivateNetworkAccessName", PrivateNetworkAccessPermissionUnavailable: "PrivateNetworkAccessPermissionUnavailable", PrivateNetworkAccessPermissionDenied: "PrivateNetworkAccessPermissionDenied", LocalNetworkAccessPermissionDenied: "LocalNetworkAccessPermissionDenied" });
    inspectorBackend.registerEnum("Network.ServiceWorkerResponseSource", { CacheStorage: "cache-storage", HttpCache: "http-cache", FallbackCode: "fallback-code", Network: "network" });
    inspectorBackend.registerEnum("Network.TrustTokenParamsRefreshPolicy", { UseCached: "UseCached", Refresh: "Refresh" });
    inspectorBackend.registerEnum("Network.TrustTokenOperationType", { Issuance: "Issuance", Redemption: "Redemption", Signing: "Signing" });
    inspectorBackend.registerEnum("Network.AlternateProtocolUsage", { AlternativeJobWonWithoutRace: "alternativeJobWonWithoutRace", AlternativeJobWonRace: "alternativeJobWonRace", MainJobWonRace: "mainJobWonRace", MappingMissing: "mappingMissing", Broken: "broken", DnsAlpnH3JobWonWithoutRace: "dnsAlpnH3JobWonWithoutRace", DnsAlpnH3JobWonRace: "dnsAlpnH3JobWonRace", UnspecifiedReason: "unspecifiedReason" });
    inspectorBackend.registerEnum("Network.ServiceWorkerRouterSource", { Network: "network", Cache: "cache", FetchEvent: "fetch-event", RaceNetworkAndFetchHandler: "race-network-and-fetch-handler", RaceNetworkAndCache: "race-network-and-cache" });
    inspectorBackend.registerEnum("Network.InitiatorType", { Parser: "parser", Script: "script", Preload: "preload", SignedExchange: "SignedExchange", Preflight: "preflight", FedCM: "FedCM", Other: "other" });
    inspectorBackend.registerEnum("Network.SetCookieBlockedReason", { SecureOnly: "SecureOnly", SameSiteStrict: "SameSiteStrict", SameSiteLax: "SameSiteLax", SameSiteUnspecifiedTreatedAsLax: "SameSiteUnspecifiedTreatedAsLax", SameSiteNoneInsecure: "SameSiteNoneInsecure", UserPreferences: "UserPreferences", ThirdPartyPhaseout: "ThirdPartyPhaseout", ThirdPartyBlockedInFirstPartySet: "ThirdPartyBlockedInFirstPartySet", SyntaxError: "SyntaxError", SchemeNotSupported: "SchemeNotSupported", OverwriteSecure: "OverwriteSecure", InvalidDomain: "InvalidDomain", InvalidPrefix: "InvalidPrefix", UnknownError: "UnknownError", SchemefulSameSiteStrict: "SchemefulSameSiteStrict", SchemefulSameSiteLax: "SchemefulSameSiteLax", SchemefulSameSiteUnspecifiedTreatedAsLax: "SchemefulSameSiteUnspecifiedTreatedAsLax", SamePartyFromCrossPartyContext: "SamePartyFromCrossPartyContext", SamePartyConflictsWithOtherAttributes: "SamePartyConflictsWithOtherAttributes", NameValuePairExceedsMaxSize: "NameValuePairExceedsMaxSize", DisallowedCharacter: "DisallowedCharacter", NoCookieContent: "NoCookieContent" });
    inspectorBackend.registerEnum("Network.CookieBlockedReason", { SecureOnly: "SecureOnly", NotOnPath: "NotOnPath", DomainMismatch: "DomainMismatch", SameSiteStrict: "SameSiteStrict", SameSiteLax: "SameSiteLax", SameSiteUnspecifiedTreatedAsLax: "SameSiteUnspecifiedTreatedAsLax", SameSiteNoneInsecure: "SameSiteNoneInsecure", UserPreferences: "UserPreferences", ThirdPartyPhaseout: "ThirdPartyPhaseout", ThirdPartyBlockedInFirstPartySet: "ThirdPartyBlockedInFirstPartySet", UnknownError: "UnknownError", SchemefulSameSiteStrict: "SchemefulSameSiteStrict", SchemefulSameSiteLax: "SchemefulSameSiteLax", SchemefulSameSiteUnspecifiedTreatedAsLax: "SchemefulSameSiteUnspecifiedTreatedAsLax", SamePartyFromCrossPartyContext: "SamePartyFromCrossPartyContext", NameValuePairExceedsMaxSize: "NameValuePairExceedsMaxSize", PortMismatch: "PortMismatch", SchemeMismatch: "SchemeMismatch", AnonymousContext: "AnonymousContext" });
    inspectorBackend.registerEnum("Network.CookieExemptionReason", { None: "None", UserSetting: "UserSetting", TPCDMetadata: "TPCDMetadata", TPCDDeprecationTrial: "TPCDDeprecationTrial", TopLevelTPCDDeprecationTrial: "TopLevelTPCDDeprecationTrial", TPCDHeuristics: "TPCDHeuristics", EnterprisePolicy: "EnterprisePolicy", StorageAccess: "StorageAccess", TopLevelStorageAccess: "TopLevelStorageAccess", Scheme: "Scheme", SameSiteNoneCookiesInSandbox: "SameSiteNoneCookiesInSandbox" });
    inspectorBackend.registerEnum("Network.AuthChallengeSource", { Server: "Server", Proxy: "Proxy" });
    inspectorBackend.registerEnum("Network.AuthChallengeResponseResponse", { Default: "Default", CancelAuth: "CancelAuth", ProvideCredentials: "ProvideCredentials" });
    inspectorBackend.registerEnum("Network.InterceptionStage", { Request: "Request", HeadersReceived: "HeadersReceived" });
    inspectorBackend.registerEnum("Network.SignedExchangeErrorField", { SignatureSig: "signatureSig", SignatureIntegrity: "signatureIntegrity", SignatureCertUrl: "signatureCertUrl", SignatureCertSha256: "signatureCertSha256", SignatureValidityUrl: "signatureValidityUrl", SignatureTimestamps: "signatureTimestamps" });
    inspectorBackend.registerEnum("Network.ContentEncoding", { Deflate: "deflate", Gzip: "gzip", Br: "br", Zstd: "zstd" });
    inspectorBackend.registerEnum("Network.DirectSocketDnsQueryType", { Ipv4: "ipv4", Ipv6: "ipv6" });
    inspectorBackend.registerEnum("Network.PrivateNetworkRequestPolicy", { Allow: "Allow", BlockFromInsecureToMorePrivate: "BlockFromInsecureToMorePrivate", WarnFromInsecureToMorePrivate: "WarnFromInsecureToMorePrivate", PreflightBlock: "PreflightBlock", PreflightWarn: "PreflightWarn", PermissionBlock: "PermissionBlock", PermissionWarn: "PermissionWarn" });
    inspectorBackend.registerEnum("Network.IPAddressSpace", { Loopback: "Loopback", Local: "Local", Public: "Public", Unknown: "Unknown" });
    inspectorBackend.registerEnum("Network.CrossOriginOpenerPolicyValue", { SameOrigin: "SameOrigin", SameOriginAllowPopups: "SameOriginAllowPopups", RestrictProperties: "RestrictProperties", UnsafeNone: "UnsafeNone", SameOriginPlusCoep: "SameOriginPlusCoep", RestrictPropertiesPlusCoep: "RestrictPropertiesPlusCoep", NoopenerAllowPopups: "NoopenerAllowPopups" });
    inspectorBackend.registerEnum("Network.CrossOriginEmbedderPolicyValue", { None: "None", Credentialless: "Credentialless", RequireCorp: "RequireCorp" });
    inspectorBackend.registerEnum("Network.ContentSecurityPolicySource", { HTTP: "HTTP", Meta: "Meta" });
    inspectorBackend.registerEnum("Network.ReportStatus", { Queued: "Queued", Pending: "Pending", MarkedForRemoval: "MarkedForRemoval", Success: "Success" });
    inspectorBackend.registerEvent("Network.dataReceived", ["requestId", "timestamp", "dataLength", "encodedDataLength", "data"]);
    inspectorBackend.registerEvent("Network.eventSourceMessageReceived", ["requestId", "timestamp", "eventName", "eventId", "data"]);
    inspectorBackend.registerEvent("Network.loadingFailed", ["requestId", "timestamp", "type", "errorText", "canceled", "blockedReason", "corsErrorStatus"]);
    inspectorBackend.registerEvent("Network.loadingFinished", ["requestId", "timestamp", "encodedDataLength"]);
    inspectorBackend.registerEvent("Network.requestIntercepted", ["interceptionId", "request", "frameId", "resourceType", "isNavigationRequest", "isDownload", "redirectUrl", "authChallenge", "responseErrorReason", "responseStatusCode", "responseHeaders", "requestId"]);
    inspectorBackend.registerEvent("Network.requestServedFromCache", ["requestId"]);
    inspectorBackend.registerEvent("Network.requestWillBeSent", ["requestId", "loaderId", "documentURL", "request", "timestamp", "wallTime", "initiator", "redirectHasExtraInfo", "redirectResponse", "type", "frameId", "hasUserGesture"]);
    inspectorBackend.registerEvent("Network.resourceChangedPriority", ["requestId", "newPriority", "timestamp"]);
    inspectorBackend.registerEvent("Network.signedExchangeReceived", ["requestId", "info"]);
    inspectorBackend.registerEvent("Network.responseReceived", ["requestId", "loaderId", "timestamp", "type", "response", "hasExtraInfo", "frameId"]);
    inspectorBackend.registerEvent("Network.webSocketClosed", ["requestId", "timestamp"]);
    inspectorBackend.registerEvent("Network.webSocketCreated", ["requestId", "url", "initiator"]);
    inspectorBackend.registerEvent("Network.webSocketFrameError", ["requestId", "timestamp", "errorMessage"]);
    inspectorBackend.registerEvent("Network.webSocketFrameReceived", ["requestId", "timestamp", "response"]);
    inspectorBackend.registerEvent("Network.webSocketFrameSent", ["requestId", "timestamp", "response"]);
    inspectorBackend.registerEvent("Network.webSocketHandshakeResponseReceived", ["requestId", "timestamp", "response"]);
    inspectorBackend.registerEvent("Network.webSocketWillSendHandshakeRequest", ["requestId", "timestamp", "wallTime", "request"]);
    inspectorBackend.registerEvent("Network.webTransportCreated", ["transportId", "url", "timestamp", "initiator"]);
    inspectorBackend.registerEvent("Network.webTransportConnectionEstablished", ["transportId", "timestamp"]);
    inspectorBackend.registerEvent("Network.webTransportClosed", ["transportId", "timestamp"]);
    inspectorBackend.registerEvent("Network.directTCPSocketCreated", ["identifier", "remoteAddr", "remotePort", "options", "timestamp", "initiator"]);
    inspectorBackend.registerEvent("Network.directTCPSocketOpened", ["identifier", "remoteAddr", "remotePort", "timestamp", "localAddr", "localPort"]);
    inspectorBackend.registerEvent("Network.directTCPSocketAborted", ["identifier", "errorMessage", "timestamp"]);
    inspectorBackend.registerEvent("Network.directTCPSocketClosed", ["identifier", "timestamp"]);
    inspectorBackend.registerEvent("Network.directTCPSocketChunkSent", ["identifier", "data", "timestamp"]);
    inspectorBackend.registerEvent("Network.directTCPSocketChunkReceived", ["identifier", "data", "timestamp"]);
    inspectorBackend.registerEvent("Network.directUDPSocketCreated", ["identifier", "options", "timestamp", "initiator"]);
    inspectorBackend.registerEvent("Network.directUDPSocketOpened", ["identifier", "localAddr", "localPort", "timestamp", "remoteAddr", "remotePort"]);
    inspectorBackend.registerEvent("Network.directUDPSocketAborted", ["identifier", "errorMessage", "timestamp"]);
    inspectorBackend.registerEvent("Network.directUDPSocketClosed", ["identifier", "timestamp"]);
    inspectorBackend.registerEvent("Network.directUDPSocketChunkSent", ["identifier", "message", "timestamp"]);
    inspectorBackend.registerEvent("Network.directUDPSocketChunkReceived", ["identifier", "message", "timestamp"]);
    inspectorBackend.registerEvent("Network.requestWillBeSentExtraInfo", ["requestId", "associatedCookies", "headers", "connectTiming", "clientSecurityState", "siteHasCookieInOtherPartition", "appliedNetworkConditionsId"]);
    inspectorBackend.registerEvent("Network.responseReceivedExtraInfo", ["requestId", "blockedCookies", "headers", "resourceIPAddressSpace", "statusCode", "headersText", "cookiePartitionKey", "cookiePartitionKeyOpaque", "exemptedCookies"]);
    inspectorBackend.registerEvent("Network.responseReceivedEarlyHints", ["requestId", "headers"]);
    inspectorBackend.registerEnum("Network.TrustTokenOperationDoneEventStatus", { Ok: "Ok", InvalidArgument: "InvalidArgument", MissingIssuerKeys: "MissingIssuerKeys", FailedPrecondition: "FailedPrecondition", ResourceExhausted: "ResourceExhausted", AlreadyExists: "AlreadyExists", ResourceLimited: "ResourceLimited", Unauthorized: "Unauthorized", BadResponse: "BadResponse", InternalError: "InternalError", UnknownError: "UnknownError", FulfilledLocally: "FulfilledLocally", SiteIssuerLimit: "SiteIssuerLimit" });
    inspectorBackend.registerEvent("Network.trustTokenOperationDone", ["status", "type", "requestId", "topLevelOrigin", "issuerOrigin", "issuedTokenCount"]);
    inspectorBackend.registerEvent("Network.policyUpdated", []);
    inspectorBackend.registerEvent("Network.reportingApiReportAdded", ["report"]);
    inspectorBackend.registerEvent("Network.reportingApiReportUpdated", ["report"]);
    inspectorBackend.registerEvent("Network.reportingApiEndpointsChangedForOrigin", ["origin", "endpoints"]);
    inspectorBackend.registerCommand("Network.getIPProtectionProxyStatus", [], ["status"], "Returns enum representing if IP Proxy of requests is available or reason it is not active.");
    inspectorBackend.registerCommand("Network.setIPProtectionProxyBypassEnabled", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "Whether IP Proxy is being bypassed by devtools; false by default.", "typeRef": null }], [], "Sets bypass IP Protection Proxy boolean.");
    inspectorBackend.registerCommand("Network.setAcceptedEncodings", [{ "name": "encodings", "type": "array", "optional": false, "description": "List of accepted content encodings.", "typeRef": "Network.ContentEncoding" }], [], "Sets a list of content encodings that will be accepted. Empty list means no encoding is accepted.");
    inspectorBackend.registerCommand("Network.clearAcceptedEncodingsOverride", [], [], "Clears accepted encodings set by setAcceptedEncodings");
    inspectorBackend.registerCommand("Network.canClearBrowserCache", [], ["result"], "Tells whether clearing browser cache is supported.");
    inspectorBackend.registerCommand("Network.canClearBrowserCookies", [], ["result"], "Tells whether clearing browser cookies is supported.");
    inspectorBackend.registerCommand("Network.canEmulateNetworkConditions", [], ["result"], "Tells whether emulation of network conditions is supported.");
    inspectorBackend.registerCommand("Network.clearBrowserCache", [], [], "Clears browser cache.");
    inspectorBackend.registerCommand("Network.clearBrowserCookies", [], [], "Clears browser cookies.");
    inspectorBackend.registerCommand("Network.continueInterceptedRequest", [{ "name": "interceptionId", "type": "string", "optional": false, "description": "", "typeRef": "Network.InterceptionId" }, { "name": "errorReason", "type": "string", "optional": true, "description": "If set this causes the request to fail with the given reason. Passing `Aborted` for requests marked with `isNavigationRequest` also cancels the navigation. Must not be set in response to an authChallenge.", "typeRef": "Network.ErrorReason" }, { "name": "rawResponse", "type": "string", "optional": true, "description": "If set the requests completes using with the provided base64 encoded raw response, including HTTP status line and headers etc... Must not be set in response to an authChallenge.", "typeRef": null }, { "name": "url", "type": "string", "optional": true, "description": "If set the request url will be modified in a way that's not observable by page. Must not be set in response to an authChallenge.", "typeRef": null }, { "name": "method", "type": "string", "optional": true, "description": "If set this allows the request method to be overridden. Must not be set in response to an authChallenge.", "typeRef": null }, { "name": "postData", "type": "string", "optional": true, "description": "If set this allows postData to be set. Must not be set in response to an authChallenge.", "typeRef": null }, { "name": "headers", "type": "object", "optional": true, "description": "If set this allows the request headers to be changed. Must not be set in response to an authChallenge.", "typeRef": "Network.Headers" }, { "name": "authChallengeResponse", "type": "object", "optional": true, "description": "Response to a requestIntercepted with an authChallenge. Must not be set otherwise.", "typeRef": "Network.AuthChallengeResponse" }], [], "Response to Network.requestIntercepted which either modifies the request to continue with any modifications, or blocks it, or completes it with the provided response bytes. If a network fetch occurs as a result which encounters a redirect an additional Network.requestIntercepted event will be sent with the same InterceptionId. Deprecated, use Fetch.continueRequest, Fetch.fulfillRequest and Fetch.failRequest instead.");
    inspectorBackend.registerCommand("Network.deleteCookies", [{ "name": "name", "type": "string", "optional": false, "description": "Name of the cookies to remove.", "typeRef": null }, { "name": "url", "type": "string", "optional": true, "description": "If specified, deletes all the cookies with the given name where domain and path match provided URL.", "typeRef": null }, { "name": "domain", "type": "string", "optional": true, "description": "If specified, deletes only cookies with the exact domain.", "typeRef": null }, { "name": "path", "type": "string", "optional": true, "description": "If specified, deletes only cookies with the exact path.", "typeRef": null }, { "name": "partitionKey", "type": "object", "optional": true, "description": "If specified, deletes only cookies with the the given name and partitionKey where all partition key attributes match the cookie partition key attribute.", "typeRef": "Network.CookiePartitionKey" }], [], "Deletes browser cookies with matching name and url or domain/path/partitionKey pair.");
    inspectorBackend.registerCommand("Network.disable", [], [], "Disables network tracking, prevents network events from being sent to the client.");
    inspectorBackend.registerCommand("Network.emulateNetworkConditions", [{ "name": "offline", "type": "boolean", "optional": false, "description": "True to emulate internet disconnection.", "typeRef": null }, { "name": "latency", "type": "number", "optional": false, "description": "Minimum latency from request sent to response headers received (ms).", "typeRef": null }, { "name": "downloadThroughput", "type": "number", "optional": false, "description": "Maximal aggregated download throughput (bytes/sec). -1 disables download throttling.", "typeRef": null }, { "name": "uploadThroughput", "type": "number", "optional": false, "description": "Maximal aggregated upload throughput (bytes/sec).  -1 disables upload throttling.", "typeRef": null }, { "name": "connectionType", "type": "string", "optional": true, "description": "Connection type if known.", "typeRef": "Network.ConnectionType" }, { "name": "packetLoss", "type": "number", "optional": true, "description": "WebRTC packet loss (percent, 0-100). 0 disables packet loss emulation, 100 drops all the packets.", "typeRef": null }, { "name": "packetQueueLength", "type": "number", "optional": true, "description": "WebRTC packet queue length (packet). 0 removes any queue length limitations.", "typeRef": null }, { "name": "packetReordering", "type": "boolean", "optional": true, "description": "WebRTC packetReordering feature.", "typeRef": null }], [], "Activates emulation of network conditions. This command is deprecated in favor of the emulateNetworkConditionsByRule and overrideNetworkState commands, which can be used together to the same effect.");
    inspectorBackend.registerCommand("Network.emulateNetworkConditionsByRule", [{ "name": "offline", "type": "boolean", "optional": false, "description": "True to emulate internet disconnection.", "typeRef": null }, { "name": "matchedNetworkConditions", "type": "array", "optional": false, "description": "Configure conditions for matching requests. If multiple entries match a request, the first entry wins.  Global conditions can be configured by leaving the urlPattern for the conditions empty. These global conditions are also applied for throttling of p2p connections.", "typeRef": "Network.NetworkConditions" }], ["ruleIds"], "Activates emulation of network conditions for individual requests using URL match patterns. Unlike the deprecated Network.emulateNetworkConditions this method does not affect `navigator` state. Use Network.overrideNetworkState to explicitly modify `navigator` behavior.");
    inspectorBackend.registerCommand("Network.overrideNetworkState", [{ "name": "offline", "type": "boolean", "optional": false, "description": "True to emulate internet disconnection.", "typeRef": null }, { "name": "latency", "type": "number", "optional": false, "description": "Minimum latency from request sent to response headers received (ms).", "typeRef": null }, { "name": "downloadThroughput", "type": "number", "optional": false, "description": "Maximal aggregated download throughput (bytes/sec). -1 disables download throttling.", "typeRef": null }, { "name": "uploadThroughput", "type": "number", "optional": false, "description": "Maximal aggregated upload throughput (bytes/sec).  -1 disables upload throttling.", "typeRef": null }, { "name": "connectionType", "type": "string", "optional": true, "description": "Connection type if known.", "typeRef": "Network.ConnectionType" }], [], "Override the state of navigator.onLine and navigator.connection.");
    inspectorBackend.registerCommand("Network.enable", [{ "name": "maxTotalBufferSize", "type": "number", "optional": true, "description": "Buffer size in bytes to use when preserving network payloads (XHRs, etc).", "typeRef": null }, { "name": "maxResourceBufferSize", "type": "number", "optional": true, "description": "Per-resource buffer size in bytes to use when preserving network payloads (XHRs, etc).", "typeRef": null }, { "name": "maxPostDataSize", "type": "number", "optional": true, "description": "Longest post body size (in bytes) that would be included in requestWillBeSent notification", "typeRef": null }, { "name": "reportDirectSocketTraffic", "type": "boolean", "optional": true, "description": "Whether DirectSocket chunk send/receive events should be reported.", "typeRef": null }, { "name": "enableDurableMessages", "type": "boolean", "optional": true, "description": "Enable storing response bodies outside of renderer, so that these survive a cross-process navigation. Requires maxTotalBufferSize to be set. Currently defaults to false.", "typeRef": null }], [], "Enables network tracking, network events will now be delivered to the client.");
    inspectorBackend.registerCommand("Network.getAllCookies", [], ["cookies"], "Returns all browser cookies. Depending on the backend support, will return detailed cookie information in the `cookies` field. Deprecated. Use Storage.getCookies instead.");
    inspectorBackend.registerCommand("Network.getCertificate", [{ "name": "origin", "type": "string", "optional": false, "description": "Origin to get certificate for.", "typeRef": null }], ["tableNames"], "Returns the DER-encoded certificate.");
    inspectorBackend.registerCommand("Network.getCookies", [{ "name": "urls", "type": "array", "optional": true, "description": "The list of URLs for which applicable cookies will be fetched. If not specified, it's assumed to be set to the list containing the URLs of the page and all of its subframes.", "typeRef": "string" }], ["cookies"], "Returns all browser cookies for the current URL. Depending on the backend support, will return detailed cookie information in the `cookies` field.");
    inspectorBackend.registerCommand("Network.getResponseBody", [{ "name": "requestId", "type": "string", "optional": false, "description": "Identifier of the network request to get content for.", "typeRef": "Network.RequestId" }], ["body", "base64Encoded"], "Returns content served for the given request.");
    inspectorBackend.registerCommand("Network.getRequestPostData", [{ "name": "requestId", "type": "string", "optional": false, "description": "Identifier of the network request to get content for.", "typeRef": "Network.RequestId" }], ["postData"], "Returns post data sent with the request. Returns an error when no data was sent with the request.");
    inspectorBackend.registerCommand("Network.getResponseBodyForInterception", [{ "name": "interceptionId", "type": "string", "optional": false, "description": "Identifier for the intercepted request to get body for.", "typeRef": "Network.InterceptionId" }], ["body", "base64Encoded"], "Returns content served for the given currently intercepted request.");
    inspectorBackend.registerCommand("Network.takeResponseBodyForInterceptionAsStream", [{ "name": "interceptionId", "type": "string", "optional": false, "description": "", "typeRef": "Network.InterceptionId" }], ["stream"], "Returns a handle to the stream representing the response body. Note that after this command, the intercepted request can't be continued as is -- you either need to cancel it or to provide the response body. The stream only supports sequential read, IO.read will fail if the position is specified.");
    inspectorBackend.registerCommand("Network.replayXHR", [{ "name": "requestId", "type": "string", "optional": false, "description": "Identifier of XHR to replay.", "typeRef": "Network.RequestId" }], [], "This method sends a new XMLHttpRequest which is identical to the original one. The following parameters should be identical: method, url, async, request body, extra headers, withCredentials attribute, user, password.");
    inspectorBackend.registerCommand("Network.searchInResponseBody", [{ "name": "requestId", "type": "string", "optional": false, "description": "Identifier of the network response to search.", "typeRef": "Network.RequestId" }, { "name": "query", "type": "string", "optional": false, "description": "String to search for.", "typeRef": null }, { "name": "caseSensitive", "type": "boolean", "optional": true, "description": "If true, search is case sensitive.", "typeRef": null }, { "name": "isRegex", "type": "boolean", "optional": true, "description": "If true, treats string parameter as regex.", "typeRef": null }], ["result"], "Searches for given string in response content.");
    inspectorBackend.registerCommand("Network.setBlockedURLs", [{ "name": "urlPatterns", "type": "array", "optional": true, "description": "Patterns to match in the order in which they are given. These patterns also take precedence over any wildcard patterns defined in `urls`.", "typeRef": "Network.BlockPattern" }, { "name": "urls", "type": "array", "optional": true, "description": "URL patterns to block. Wildcards ('*') are allowed.", "typeRef": "string" }], [], "Blocks URLs from loading.");
    inspectorBackend.registerCommand("Network.setBypassServiceWorker", [{ "name": "bypass", "type": "boolean", "optional": false, "description": "Bypass service worker and load from network.", "typeRef": null }], [], "Toggles ignoring of service worker for each request.");
    inspectorBackend.registerCommand("Network.setCacheDisabled", [{ "name": "cacheDisabled", "type": "boolean", "optional": false, "description": "Cache disabled state.", "typeRef": null }], [], "Toggles ignoring cache for each request. If `true`, cache will not be used.");
    inspectorBackend.registerCommand("Network.setCookie", [{ "name": "name", "type": "string", "optional": false, "description": "Cookie name.", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "Cookie value.", "typeRef": null }, { "name": "url", "type": "string", "optional": true, "description": "The request-URI to associate with the setting of the cookie. This value can affect the default domain, path, source port, and source scheme values of the created cookie.", "typeRef": null }, { "name": "domain", "type": "string", "optional": true, "description": "Cookie domain.", "typeRef": null }, { "name": "path", "type": "string", "optional": true, "description": "Cookie path.", "typeRef": null }, { "name": "secure", "type": "boolean", "optional": true, "description": "True if cookie is secure.", "typeRef": null }, { "name": "httpOnly", "type": "boolean", "optional": true, "description": "True if cookie is http-only.", "typeRef": null }, { "name": "sameSite", "type": "string", "optional": true, "description": "Cookie SameSite type.", "typeRef": "Network.CookieSameSite" }, { "name": "expires", "type": "number", "optional": true, "description": "Cookie expiration date, session cookie if not set", "typeRef": "Network.TimeSinceEpoch" }, { "name": "priority", "type": "string", "optional": true, "description": "Cookie Priority type.", "typeRef": "Network.CookiePriority" }, { "name": "sameParty", "type": "boolean", "optional": true, "description": "True if cookie is SameParty.", "typeRef": null }, { "name": "sourceScheme", "type": "string", "optional": true, "description": "Cookie source scheme type.", "typeRef": "Network.CookieSourceScheme" }, { "name": "sourcePort", "type": "number", "optional": true, "description": "Cookie source port. Valid values are {-1, [1, 65535]}, -1 indicates an unspecified port. An unspecified port value allows protocol clients to emulate legacy cookie scope for the port. This is a temporary ability and it will be removed in the future.", "typeRef": null }, { "name": "partitionKey", "type": "object", "optional": true, "description": "Cookie partition key. If not set, the cookie will be set as not partitioned.", "typeRef": "Network.CookiePartitionKey" }], ["success"], "Sets a cookie with the given cookie data; may overwrite equivalent cookies if they exist.");
    inspectorBackend.registerCommand("Network.setCookies", [{ "name": "cookies", "type": "array", "optional": false, "description": "Cookies to be set.", "typeRef": "Network.CookieParam" }], [], "Sets given cookies.");
    inspectorBackend.registerCommand("Network.setExtraHTTPHeaders", [{ "name": "headers", "type": "object", "optional": false, "description": "Map with extra HTTP headers.", "typeRef": "Network.Headers" }], [], "Specifies whether to always send extra HTTP headers with the requests from this page.");
    inspectorBackend.registerCommand("Network.setAttachDebugStack", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "Whether to attach a page script stack for debugging purpose.", "typeRef": null }], [], "Specifies whether to attach a page script stack id in requests");
    inspectorBackend.registerCommand("Network.setRequestInterception", [{ "name": "patterns", "type": "array", "optional": false, "description": "Requests matching any of these patterns will be forwarded and wait for the corresponding continueInterceptedRequest call.", "typeRef": "Network.RequestPattern" }], [], "Sets the requests to intercept that match the provided patterns and optionally resource types. Deprecated, please use Fetch.enable instead.");
    inspectorBackend.registerCommand("Network.setUserAgentOverride", [{ "name": "userAgent", "type": "string", "optional": false, "description": "User agent to use.", "typeRef": null }, { "name": "acceptLanguage", "type": "string", "optional": true, "description": "Browser language to emulate.", "typeRef": null }, { "name": "platform", "type": "string", "optional": true, "description": "The platform navigator.platform should return.", "typeRef": null }, { "name": "userAgentMetadata", "type": "object", "optional": true, "description": "To be sent in Sec-CH-UA-* headers and returned in navigator.userAgentData", "typeRef": "Emulation.UserAgentMetadata" }], [], "Allows overriding user agent with the given string.");
    inspectorBackend.registerCommand("Network.streamResourceContent", [{ "name": "requestId", "type": "string", "optional": false, "description": "Identifier of the request to stream.", "typeRef": "Network.RequestId" }], ["bufferedData"], "Enables streaming of the response for the given requestId. If enabled, the dataReceived event contains the data that was received during streaming.");
    inspectorBackend.registerCommand("Network.getSecurityIsolationStatus", [{ "name": "frameId", "type": "string", "optional": true, "description": "If no frameId is provided, the status of the target is provided.", "typeRef": "Page.FrameId" }], ["status"], "Returns information about the COEP/COOP isolation status.");
    inspectorBackend.registerCommand("Network.enableReportingApi", [{ "name": "enable", "type": "boolean", "optional": false, "description": "Whether to enable or disable events for the Reporting API", "typeRef": null }], [], "Enables tracking for the Reporting API, events generated by the Reporting API will now be delivered to the client. Enabling triggers 'reportingApiReportAdded' for all existing reports.");
    inspectorBackend.registerCommand("Network.loadNetworkResource", [{ "name": "frameId", "type": "string", "optional": true, "description": "Frame id to get the resource for. Mandatory for frame targets, and should be omitted for worker targets.", "typeRef": "Page.FrameId" }, { "name": "url", "type": "string", "optional": false, "description": "URL of the resource to get content for.", "typeRef": null }, { "name": "options", "type": "object", "optional": false, "description": "Options for the request.", "typeRef": "Network.LoadNetworkResourceOptions" }], ["resource"], "Fetches the resource and returns the content.");
    inspectorBackend.registerCommand("Network.setCookieControls", [{ "name": "enableThirdPartyCookieRestriction", "type": "boolean", "optional": false, "description": "Whether 3pc restriction is enabled.", "typeRef": null }, { "name": "disableThirdPartyCookieMetadata", "type": "boolean", "optional": false, "description": "Whether 3pc grace period exception should be enabled; false by default.", "typeRef": null }, { "name": "disableThirdPartyCookieHeuristics", "type": "boolean", "optional": false, "description": "Whether 3pc heuristics exceptions should be enabled; false by default.", "typeRef": null }], [], "Sets Controls for third-party cookie access Page reload is required before the new cookie behavior will be observed");
    inspectorBackend.registerType("Network.ResourceTiming", [{ "name": "requestTime", "type": "number", "optional": false, "description": "Timing's requestTime is a baseline in seconds, while the other numbers are ticks in milliseconds relatively to this requestTime.", "typeRef": null }, { "name": "proxyStart", "type": "number", "optional": false, "description": "Started resolving proxy.", "typeRef": null }, { "name": "proxyEnd", "type": "number", "optional": false, "description": "Finished resolving proxy.", "typeRef": null }, { "name": "dnsStart", "type": "number", "optional": false, "description": "Started DNS address resolve.", "typeRef": null }, { "name": "dnsEnd", "type": "number", "optional": false, "description": "Finished DNS address resolve.", "typeRef": null }, { "name": "connectStart", "type": "number", "optional": false, "description": "Started connecting to the remote host.", "typeRef": null }, { "name": "connectEnd", "type": "number", "optional": false, "description": "Connected to the remote host.", "typeRef": null }, { "name": "sslStart", "type": "number", "optional": false, "description": "Started SSL handshake.", "typeRef": null }, { "name": "sslEnd", "type": "number", "optional": false, "description": "Finished SSL handshake.", "typeRef": null }, { "name": "workerStart", "type": "number", "optional": false, "description": "Started running ServiceWorker.", "typeRef": null }, { "name": "workerReady", "type": "number", "optional": false, "description": "Finished Starting ServiceWorker.", "typeRef": null }, { "name": "workerFetchStart", "type": "number", "optional": false, "description": "Started fetch event.", "typeRef": null }, { "name": "workerRespondWithSettled", "type": "number", "optional": false, "description": "Settled fetch event respondWith promise.", "typeRef": null }, { "name": "workerRouterEvaluationStart", "type": "number", "optional": true, "description": "Started ServiceWorker static routing source evaluation.", "typeRef": null }, { "name": "workerCacheLookupStart", "type": "number", "optional": true, "description": "Started cache lookup when the source was evaluated to `cache`.", "typeRef": null }, { "name": "sendStart", "type": "number", "optional": false, "description": "Started sending request.", "typeRef": null }, { "name": "sendEnd", "type": "number", "optional": false, "description": "Finished sending request.", "typeRef": null }, { "name": "pushStart", "type": "number", "optional": false, "description": "Time the server started pushing request.", "typeRef": null }, { "name": "pushEnd", "type": "number", "optional": false, "description": "Time the server finished pushing request.", "typeRef": null }, { "name": "receiveHeadersStart", "type": "number", "optional": false, "description": "Started receiving response headers.", "typeRef": null }, { "name": "receiveHeadersEnd", "type": "number", "optional": false, "description": "Finished receiving response headers.", "typeRef": null }]);
    inspectorBackend.registerType("Network.PostDataEntry", [{ "name": "bytes", "type": "string", "optional": true, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Network.Request", [{ "name": "url", "type": "string", "optional": false, "description": "Request URL (without fragment).", "typeRef": null }, { "name": "urlFragment", "type": "string", "optional": true, "description": "Fragment of the requested URL starting with hash, if present.", "typeRef": null }, { "name": "method", "type": "string", "optional": false, "description": "HTTP request method.", "typeRef": null }, { "name": "headers", "type": "object", "optional": false, "description": "HTTP request headers.", "typeRef": "Network.Headers" }, { "name": "postData", "type": "string", "optional": true, "description": "HTTP POST request data. Use postDataEntries instead.", "typeRef": null }, { "name": "hasPostData", "type": "boolean", "optional": true, "description": "True when the request has POST data. Note that postData might still be omitted when this flag is true when the data is too long.", "typeRef": null }, { "name": "postDataEntries", "type": "array", "optional": true, "description": "Request body elements (post data broken into individual entries).", "typeRef": "Network.PostDataEntry" }, { "name": "mixedContentType", "type": "string", "optional": true, "description": "The mixed content type of the request.", "typeRef": "Security.MixedContentType" }, { "name": "initialPriority", "type": "string", "optional": false, "description": "Priority of the resource request at the time request is sent.", "typeRef": "Network.ResourcePriority" }, { "name": "referrerPolicy", "type": "string", "optional": false, "description": "The referrer policy of the request, as defined in https://www.w3.org/TR/referrer-policy/", "typeRef": null }, { "name": "isLinkPreload", "type": "boolean", "optional": true, "description": "Whether is loaded via link preload.", "typeRef": null }, { "name": "trustTokenParams", "type": "object", "optional": true, "description": "Set for requests when the TrustToken API is used. Contains the parameters passed by the developer (e.g. via \\\"fetch\\\") as understood by the backend.", "typeRef": "Network.TrustTokenParams" }, { "name": "isSameSite", "type": "boolean", "optional": true, "description": "True if this resource request is considered to be the 'same site' as the request corresponding to the main frame.", "typeRef": null }, { "name": "isAdRelated", "type": "boolean", "optional": true, "description": "True when the resource request is ad-related.", "typeRef": null }]);
    inspectorBackend.registerType("Network.SignedCertificateTimestamp", [{ "name": "status", "type": "string", "optional": false, "description": "Validation status.", "typeRef": null }, { "name": "origin", "type": "string", "optional": false, "description": "Origin.", "typeRef": null }, { "name": "logDescription", "type": "string", "optional": false, "description": "Log name / description.", "typeRef": null }, { "name": "logId", "type": "string", "optional": false, "description": "Log ID.", "typeRef": null }, { "name": "timestamp", "type": "number", "optional": false, "description": "Issuance date. Unlike TimeSinceEpoch, this contains the number of milliseconds since January 1, 1970, UTC, not the number of seconds.", "typeRef": null }, { "name": "hashAlgorithm", "type": "string", "optional": false, "description": "Hash algorithm.", "typeRef": null }, { "name": "signatureAlgorithm", "type": "string", "optional": false, "description": "Signature algorithm.", "typeRef": null }, { "name": "signatureData", "type": "string", "optional": false, "description": "Signature data.", "typeRef": null }]);
    inspectorBackend.registerType("Network.SecurityDetails", [{ "name": "protocol", "type": "string", "optional": false, "description": "Protocol name (e.g. \\\"TLS 1.2\\\" or \\\"QUIC\\\").", "typeRef": null }, { "name": "keyExchange", "type": "string", "optional": false, "description": "Key Exchange used by the connection, or the empty string if not applicable.", "typeRef": null }, { "name": "keyExchangeGroup", "type": "string", "optional": true, "description": "(EC)DH group used by the connection, if applicable.", "typeRef": null }, { "name": "cipher", "type": "string", "optional": false, "description": "Cipher name.", "typeRef": null }, { "name": "mac", "type": "string", "optional": true, "description": "TLS MAC. Note that AEAD ciphers do not have separate MACs.", "typeRef": null }, { "name": "certificateId", "type": "number", "optional": false, "description": "Certificate ID value.", "typeRef": "Security.CertificateId" }, { "name": "subjectName", "type": "string", "optional": false, "description": "Certificate subject name.", "typeRef": null }, { "name": "sanList", "type": "array", "optional": false, "description": "Subject Alternative Name (SAN) DNS names and IP addresses.", "typeRef": "string" }, { "name": "issuer", "type": "string", "optional": false, "description": "Name of the issuing CA.", "typeRef": null }, { "name": "validFrom", "type": "number", "optional": false, "description": "Certificate valid from date.", "typeRef": "Network.TimeSinceEpoch" }, { "name": "validTo", "type": "number", "optional": false, "description": "Certificate valid to (expiration) date", "typeRef": "Network.TimeSinceEpoch" }, { "name": "signedCertificateTimestampList", "type": "array", "optional": false, "description": "List of signed certificate timestamps (SCTs).", "typeRef": "Network.SignedCertificateTimestamp" }, { "name": "certificateTransparencyCompliance", "type": "string", "optional": false, "description": "Whether the request complied with Certificate Transparency policy", "typeRef": "Network.CertificateTransparencyCompliance" }, { "name": "serverSignatureAlgorithm", "type": "number", "optional": true, "description": "The signature algorithm used by the server in the TLS server signature, represented as a TLS SignatureScheme code point. Omitted if not applicable or not known.", "typeRef": null }, { "name": "encryptedClientHello", "type": "boolean", "optional": false, "description": "Whether the connection used Encrypted ClientHello", "typeRef": null }]);
    inspectorBackend.registerType("Network.CorsErrorStatus", [{ "name": "corsError", "type": "string", "optional": false, "description": "", "typeRef": "Network.CorsError" }, { "name": "failedParameter", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Network.TrustTokenParams", [{ "name": "operation", "type": "string", "optional": false, "description": "", "typeRef": "Network.TrustTokenOperationType" }, { "name": "refreshPolicy", "type": "string", "optional": false, "description": "Only set for \\\"token-redemption\\\" operation and determine whether to request a fresh SRR or use a still valid cached SRR.", "typeRef": null }, { "name": "issuers", "type": "array", "optional": true, "description": "Origins of issuers from whom to request tokens or redemption records.", "typeRef": "string" }]);
    inspectorBackend.registerType("Network.ServiceWorkerRouterInfo", [{ "name": "ruleIdMatched", "type": "number", "optional": true, "description": "ID of the rule matched. If there is a matched rule, this field will be set, otherwiser no value will be set.", "typeRef": null }, { "name": "matchedSourceType", "type": "string", "optional": true, "description": "The router source of the matched rule. If there is a matched rule, this field will be set, otherwise no value will be set.", "typeRef": "Network.ServiceWorkerRouterSource" }, { "name": "actualSourceType", "type": "string", "optional": true, "description": "The actual router source used.", "typeRef": "Network.ServiceWorkerRouterSource" }]);
    inspectorBackend.registerType("Network.Response", [{ "name": "url", "type": "string", "optional": false, "description": "Response URL. This URL can be different from CachedResource.url in case of redirect.", "typeRef": null }, { "name": "status", "type": "number", "optional": false, "description": "HTTP response status code.", "typeRef": null }, { "name": "statusText", "type": "string", "optional": false, "description": "HTTP response status text.", "typeRef": null }, { "name": "headers", "type": "object", "optional": false, "description": "HTTP response headers.", "typeRef": "Network.Headers" }, { "name": "headersText", "type": "string", "optional": true, "description": "HTTP response headers text. This has been replaced by the headers in Network.responseReceivedExtraInfo.", "typeRef": null }, { "name": "mimeType", "type": "string", "optional": false, "description": "Resource mimeType as determined by the browser.", "typeRef": null }, { "name": "charset", "type": "string", "optional": false, "description": "Resource charset as determined by the browser (if applicable).", "typeRef": null }, { "name": "requestHeaders", "type": "object", "optional": true, "description": "Refined HTTP request headers that were actually transmitted over the network.", "typeRef": "Network.Headers" }, { "name": "requestHeadersText", "type": "string", "optional": true, "description": "HTTP request headers text. This has been replaced by the headers in Network.requestWillBeSentExtraInfo.", "typeRef": null }, { "name": "connectionReused", "type": "boolean", "optional": false, "description": "Specifies whether physical connection was actually reused for this request.", "typeRef": null }, { "name": "connectionId", "type": "number", "optional": false, "description": "Physical connection id that was actually used for this request.", "typeRef": null }, { "name": "remoteIPAddress", "type": "string", "optional": true, "description": "Remote IP address.", "typeRef": null }, { "name": "remotePort", "type": "number", "optional": true, "description": "Remote port.", "typeRef": null }, { "name": "fromDiskCache", "type": "boolean", "optional": true, "description": "Specifies that the request was served from the disk cache.", "typeRef": null }, { "name": "fromServiceWorker", "type": "boolean", "optional": true, "description": "Specifies that the request was served from the ServiceWorker.", "typeRef": null }, { "name": "fromPrefetchCache", "type": "boolean", "optional": true, "description": "Specifies that the request was served from the prefetch cache.", "typeRef": null }, { "name": "fromEarlyHints", "type": "boolean", "optional": true, "description": "Specifies that the request was served from the prefetch cache.", "typeRef": null }, { "name": "serviceWorkerRouterInfo", "type": "object", "optional": true, "description": "Information about how ServiceWorker Static Router API was used. If this field is set with `matchedSourceType` field, a matching rule is found. If this field is set without `matchedSource`, no matching rule is found. Otherwise, the API is not used.", "typeRef": "Network.ServiceWorkerRouterInfo" }, { "name": "encodedDataLength", "type": "number", "optional": false, "description": "Total number of bytes received for this request so far.", "typeRef": null }, { "name": "timing", "type": "object", "optional": true, "description": "Timing information for the given request.", "typeRef": "Network.ResourceTiming" }, { "name": "serviceWorkerResponseSource", "type": "string", "optional": true, "description": "Response source of response from ServiceWorker.", "typeRef": "Network.ServiceWorkerResponseSource" }, { "name": "responseTime", "type": "number", "optional": true, "description": "The time at which the returned response was generated.", "typeRef": "Network.TimeSinceEpoch" }, { "name": "cacheStorageCacheName", "type": "string", "optional": true, "description": "Cache Storage Cache Name.", "typeRef": null }, { "name": "protocol", "type": "string", "optional": true, "description": "Protocol used to fetch this request.", "typeRef": null }, { "name": "alternateProtocolUsage", "type": "string", "optional": true, "description": "The reason why Chrome uses a specific transport protocol for HTTP semantics.", "typeRef": "Network.AlternateProtocolUsage" }, { "name": "securityState", "type": "string", "optional": false, "description": "Security state of the request resource.", "typeRef": "Security.SecurityState" }, { "name": "securityDetails", "type": "object", "optional": true, "description": "Security details for the request.", "typeRef": "Network.SecurityDetails" }, { "name": "isIpProtectionUsed", "type": "boolean", "optional": true, "description": "Indicates whether the request was sent through IP Protection proxies. If set to true, the request used the IP Protection privacy feature.", "typeRef": null }]);
    inspectorBackend.registerType("Network.WebSocketRequest", [{ "name": "headers", "type": "object", "optional": false, "description": "HTTP request headers.", "typeRef": "Network.Headers" }]);
    inspectorBackend.registerType("Network.WebSocketResponse", [{ "name": "status", "type": "number", "optional": false, "description": "HTTP response status code.", "typeRef": null }, { "name": "statusText", "type": "string", "optional": false, "description": "HTTP response status text.", "typeRef": null }, { "name": "headers", "type": "object", "optional": false, "description": "HTTP response headers.", "typeRef": "Network.Headers" }, { "name": "headersText", "type": "string", "optional": true, "description": "HTTP response headers text.", "typeRef": null }, { "name": "requestHeaders", "type": "object", "optional": true, "description": "HTTP request headers.", "typeRef": "Network.Headers" }, { "name": "requestHeadersText", "type": "string", "optional": true, "description": "HTTP request headers text.", "typeRef": null }]);
    inspectorBackend.registerType("Network.WebSocketFrame", [{ "name": "opcode", "type": "number", "optional": false, "description": "WebSocket message opcode.", "typeRef": null }, { "name": "mask", "type": "boolean", "optional": false, "description": "WebSocket message mask.", "typeRef": null }, { "name": "payloadData", "type": "string", "optional": false, "description": "WebSocket message payload data. If the opcode is 1, this is a text message and payloadData is a UTF-8 string. If the opcode isn't 1, then payloadData is a base64 encoded string representing binary data.", "typeRef": null }]);
    inspectorBackend.registerType("Network.CachedResource", [{ "name": "url", "type": "string", "optional": false, "description": "Resource URL. This is the url of the original network request.", "typeRef": null }, { "name": "type", "type": "string", "optional": false, "description": "Type of this resource.", "typeRef": "Network.ResourceType" }, { "name": "response", "type": "object", "optional": true, "description": "Cached response data.", "typeRef": "Network.Response" }, { "name": "bodySize", "type": "number", "optional": false, "description": "Cached response body size.", "typeRef": null }]);
    inspectorBackend.registerType("Network.Initiator", [{ "name": "type", "type": "string", "optional": false, "description": "Type of this initiator.", "typeRef": null }, { "name": "stack", "type": "object", "optional": true, "description": "Initiator JavaScript stack trace, set for Script only. Requires the Debugger domain to be enabled.", "typeRef": "Runtime.StackTrace" }, { "name": "url", "type": "string", "optional": true, "description": "Initiator URL, set for Parser type or for Script type (when script is importing module) or for SignedExchange type.", "typeRef": null }, { "name": "lineNumber", "type": "number", "optional": true, "description": "Initiator line number, set for Parser type or for Script type (when script is importing module) (0-based).", "typeRef": null }, { "name": "columnNumber", "type": "number", "optional": true, "description": "Initiator column number, set for Parser type or for Script type (when script is importing module) (0-based).", "typeRef": null }, { "name": "requestId", "type": "string", "optional": true, "description": "Set if another request triggered this request (e.g. preflight).", "typeRef": "Network.RequestId" }]);
    inspectorBackend.registerType("Network.CookiePartitionKey", [{ "name": "topLevelSite", "type": "string", "optional": false, "description": "The site of the top-level URL the browser was visiting at the start of the request to the endpoint that set the cookie.", "typeRef": null }, { "name": "hasCrossSiteAncestor", "type": "boolean", "optional": false, "description": "Indicates if the cookie has any ancestors that are cross-site to the topLevelSite.", "typeRef": null }]);
    inspectorBackend.registerType("Network.Cookie", [{ "name": "name", "type": "string", "optional": false, "description": "Cookie name.", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "Cookie value.", "typeRef": null }, { "name": "domain", "type": "string", "optional": false, "description": "Cookie domain.", "typeRef": null }, { "name": "path", "type": "string", "optional": false, "description": "Cookie path.", "typeRef": null }, { "name": "expires", "type": "number", "optional": false, "description": "Cookie expiration date as the number of seconds since the UNIX epoch. The value is set to -1 if the expiry date is not set. The value can be null for values that cannot be represented in JSON (\u00b1Inf).", "typeRef": null }, { "name": "size", "type": "number", "optional": false, "description": "Cookie size.", "typeRef": null }, { "name": "httpOnly", "type": "boolean", "optional": false, "description": "True if cookie is http-only.", "typeRef": null }, { "name": "secure", "type": "boolean", "optional": false, "description": "True if cookie is secure.", "typeRef": null }, { "name": "session", "type": "boolean", "optional": false, "description": "True in case of session cookie.", "typeRef": null }, { "name": "sameSite", "type": "string", "optional": true, "description": "Cookie SameSite type.", "typeRef": "Network.CookieSameSite" }, { "name": "priority", "type": "string", "optional": false, "description": "Cookie Priority", "typeRef": "Network.CookiePriority" }, { "name": "sameParty", "type": "boolean", "optional": false, "description": "True if cookie is SameParty.", "typeRef": null }, { "name": "sourceScheme", "type": "string", "optional": false, "description": "Cookie source scheme type.", "typeRef": "Network.CookieSourceScheme" }, { "name": "sourcePort", "type": "number", "optional": false, "description": "Cookie source port. Valid values are {-1, [1, 65535]}, -1 indicates an unspecified port. An unspecified port value allows protocol clients to emulate legacy cookie scope for the port. This is a temporary ability and it will be removed in the future.", "typeRef": null }, { "name": "partitionKey", "type": "object", "optional": true, "description": "Cookie partition key.", "typeRef": "Network.CookiePartitionKey" }, { "name": "partitionKeyOpaque", "type": "boolean", "optional": true, "description": "True if cookie partition key is opaque.", "typeRef": null }]);
    inspectorBackend.registerType("Network.BlockedSetCookieWithReason", [{ "name": "blockedReasons", "type": "array", "optional": false, "description": "The reason(s) this cookie was blocked.", "typeRef": "Network.SetCookieBlockedReason" }, { "name": "cookieLine", "type": "string", "optional": false, "description": "The string representing this individual cookie as it would appear in the header. This is not the entire \\\"cookie\\\" or \\\"set-cookie\\\" header which could have multiple cookies.", "typeRef": null }, { "name": "cookie", "type": "object", "optional": true, "description": "The cookie object which represents the cookie which was not stored. It is optional because sometimes complete cookie information is not available, such as in the case of parsing errors.", "typeRef": "Network.Cookie" }]);
    inspectorBackend.registerType("Network.ExemptedSetCookieWithReason", [{ "name": "exemptionReason", "type": "string", "optional": false, "description": "The reason the cookie was exempted.", "typeRef": "Network.CookieExemptionReason" }, { "name": "cookieLine", "type": "string", "optional": false, "description": "The string representing this individual cookie as it would appear in the header.", "typeRef": null }, { "name": "cookie", "type": "object", "optional": false, "description": "The cookie object representing the cookie.", "typeRef": "Network.Cookie" }]);
    inspectorBackend.registerType("Network.AssociatedCookie", [{ "name": "cookie", "type": "object", "optional": false, "description": "The cookie object representing the cookie which was not sent.", "typeRef": "Network.Cookie" }, { "name": "blockedReasons", "type": "array", "optional": false, "description": "The reason(s) the cookie was blocked. If empty means the cookie is included.", "typeRef": "Network.CookieBlockedReason" }, { "name": "exemptionReason", "type": "string", "optional": true, "description": "The reason the cookie should have been blocked by 3PCD but is exempted. A cookie could only have at most one exemption reason.", "typeRef": "Network.CookieExemptionReason" }]);
    inspectorBackend.registerType("Network.CookieParam", [{ "name": "name", "type": "string", "optional": false, "description": "Cookie name.", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "Cookie value.", "typeRef": null }, { "name": "url", "type": "string", "optional": true, "description": "The request-URI to associate with the setting of the cookie. This value can affect the default domain, path, source port, and source scheme values of the created cookie.", "typeRef": null }, { "name": "domain", "type": "string", "optional": true, "description": "Cookie domain.", "typeRef": null }, { "name": "path", "type": "string", "optional": true, "description": "Cookie path.", "typeRef": null }, { "name": "secure", "type": "boolean", "optional": true, "description": "True if cookie is secure.", "typeRef": null }, { "name": "httpOnly", "type": "boolean", "optional": true, "description": "True if cookie is http-only.", "typeRef": null }, { "name": "sameSite", "type": "string", "optional": true, "description": "Cookie SameSite type.", "typeRef": "Network.CookieSameSite" }, { "name": "expires", "type": "number", "optional": true, "description": "Cookie expiration date, session cookie if not set", "typeRef": "Network.TimeSinceEpoch" }, { "name": "priority", "type": "string", "optional": true, "description": "Cookie Priority.", "typeRef": "Network.CookiePriority" }, { "name": "sameParty", "type": "boolean", "optional": true, "description": "True if cookie is SameParty.", "typeRef": null }, { "name": "sourceScheme", "type": "string", "optional": true, "description": "Cookie source scheme type.", "typeRef": "Network.CookieSourceScheme" }, { "name": "sourcePort", "type": "number", "optional": true, "description": "Cookie source port. Valid values are {-1, [1, 65535]}, -1 indicates an unspecified port. An unspecified port value allows protocol clients to emulate legacy cookie scope for the port. This is a temporary ability and it will be removed in the future.", "typeRef": null }, { "name": "partitionKey", "type": "object", "optional": true, "description": "Cookie partition key. If not set, the cookie will be set as not partitioned.", "typeRef": "Network.CookiePartitionKey" }]);
    inspectorBackend.registerType("Network.AuthChallenge", [{ "name": "source", "type": "string", "optional": true, "description": "Source of the authentication challenge.", "typeRef": null }, { "name": "origin", "type": "string", "optional": false, "description": "Origin of the challenger.", "typeRef": null }, { "name": "scheme", "type": "string", "optional": false, "description": "The authentication scheme used, such as basic or digest", "typeRef": null }, { "name": "realm", "type": "string", "optional": false, "description": "The realm of the challenge. May be empty.", "typeRef": null }]);
    inspectorBackend.registerType("Network.AuthChallengeResponse", [{ "name": "response", "type": "string", "optional": false, "description": "The decision on what to do in response to the authorization challenge.  Default means deferring to the default behavior of the net stack, which will likely either the Cancel authentication or display a popup dialog box.", "typeRef": null }, { "name": "username", "type": "string", "optional": true, "description": "The username to provide, possibly empty. Should only be set if response is ProvideCredentials.", "typeRef": null }, { "name": "password", "type": "string", "optional": true, "description": "The password to provide, possibly empty. Should only be set if response is ProvideCredentials.", "typeRef": null }]);
    inspectorBackend.registerType("Network.RequestPattern", [{ "name": "urlPattern", "type": "string", "optional": true, "description": "Wildcards (`'*'` -> zero or more, `'?'` -> exactly one) are allowed. Escape character is backslash. Omitting is equivalent to `\\\"*\\\"`.", "typeRef": null }, { "name": "resourceType", "type": "string", "optional": true, "description": "If set, only requests for matching resource types will be intercepted.", "typeRef": "Network.ResourceType" }, { "name": "interceptionStage", "type": "string", "optional": true, "description": "Stage at which to begin intercepting requests. Default is Request.", "typeRef": "Network.InterceptionStage" }]);
    inspectorBackend.registerType("Network.SignedExchangeSignature", [{ "name": "label", "type": "string", "optional": false, "description": "Signed exchange signature label.", "typeRef": null }, { "name": "signature", "type": "string", "optional": false, "description": "The hex string of signed exchange signature.", "typeRef": null }, { "name": "integrity", "type": "string", "optional": false, "description": "Signed exchange signature integrity.", "typeRef": null }, { "name": "certUrl", "type": "string", "optional": true, "description": "Signed exchange signature cert Url.", "typeRef": null }, { "name": "certSha256", "type": "string", "optional": true, "description": "The hex string of signed exchange signature cert sha256.", "typeRef": null }, { "name": "validityUrl", "type": "string", "optional": false, "description": "Signed exchange signature validity Url.", "typeRef": null }, { "name": "date", "type": "number", "optional": false, "description": "Signed exchange signature date.", "typeRef": null }, { "name": "expires", "type": "number", "optional": false, "description": "Signed exchange signature expires.", "typeRef": null }, { "name": "certificates", "type": "array", "optional": true, "description": "The encoded certificates.", "typeRef": "string" }]);
    inspectorBackend.registerType("Network.SignedExchangeHeader", [{ "name": "requestUrl", "type": "string", "optional": false, "description": "Signed exchange request URL.", "typeRef": null }, { "name": "responseCode", "type": "number", "optional": false, "description": "Signed exchange response code.", "typeRef": null }, { "name": "responseHeaders", "type": "object", "optional": false, "description": "Signed exchange response headers.", "typeRef": "Network.Headers" }, { "name": "signatures", "type": "array", "optional": false, "description": "Signed exchange response signature.", "typeRef": "Network.SignedExchangeSignature" }, { "name": "headerIntegrity", "type": "string", "optional": false, "description": "Signed exchange header integrity hash in the form of `sha256-<base64-hash-value>`.", "typeRef": null }]);
    inspectorBackend.registerType("Network.SignedExchangeError", [{ "name": "message", "type": "string", "optional": false, "description": "Error message.", "typeRef": null }, { "name": "signatureIndex", "type": "number", "optional": true, "description": "The index of the signature which caused the error.", "typeRef": null }, { "name": "errorField", "type": "string", "optional": true, "description": "The field which caused the error.", "typeRef": "Network.SignedExchangeErrorField" }]);
    inspectorBackend.registerType("Network.SignedExchangeInfo", [{ "name": "outerResponse", "type": "object", "optional": false, "description": "The outer response of signed HTTP exchange which was received from network.", "typeRef": "Network.Response" }, { "name": "hasExtraInfo", "type": "boolean", "optional": false, "description": "Whether network response for the signed exchange was accompanied by extra headers.", "typeRef": null }, { "name": "header", "type": "object", "optional": true, "description": "Information about the signed exchange header.", "typeRef": "Network.SignedExchangeHeader" }, { "name": "securityDetails", "type": "object", "optional": true, "description": "Security details for the signed exchange header.", "typeRef": "Network.SecurityDetails" }, { "name": "errors", "type": "array", "optional": true, "description": "Errors occurred while handling the signed exchange.", "typeRef": "Network.SignedExchangeError" }]);
    inspectorBackend.registerType("Network.NetworkConditions", [{ "name": "urlPattern", "type": "string", "optional": false, "description": "Only matching requests will be affected by these conditions. Patterns use the URLPattern constructor string syntax (https://urlpattern.spec.whatwg.org/) and must be absolute. If the pattern is empty, all requests are matched (including p2p connections).", "typeRef": null }, { "name": "latency", "type": "number", "optional": false, "description": "Minimum latency from request sent to response headers received (ms).", "typeRef": null }, { "name": "downloadThroughput", "type": "number", "optional": false, "description": "Maximal aggregated download throughput (bytes/sec). -1 disables download throttling.", "typeRef": null }, { "name": "uploadThroughput", "type": "number", "optional": false, "description": "Maximal aggregated upload throughput (bytes/sec).  -1 disables upload throttling.", "typeRef": null }, { "name": "connectionType", "type": "string", "optional": true, "description": "Connection type if known.", "typeRef": "Network.ConnectionType" }, { "name": "packetLoss", "type": "number", "optional": true, "description": "WebRTC packet loss (percent, 0-100). 0 disables packet loss emulation, 100 drops all the packets.", "typeRef": null }, { "name": "packetQueueLength", "type": "number", "optional": true, "description": "WebRTC packet queue length (packet). 0 removes any queue length limitations.", "typeRef": null }, { "name": "packetReordering", "type": "boolean", "optional": true, "description": "WebRTC packetReordering feature.", "typeRef": null }]);
    inspectorBackend.registerType("Network.BlockPattern", [{ "name": "urlPattern", "type": "string", "optional": false, "description": "URL pattern to match. Patterns use the URLPattern constructor string syntax (https://urlpattern.spec.whatwg.org/) and must be absolute. Example: `*://*:*/*.css`.", "typeRef": null }, { "name": "block", "type": "boolean", "optional": false, "description": "Whether or not to block the pattern. If false, a matching request will not be blocked even if it matches a later `BlockPattern`.", "typeRef": null }]);
    inspectorBackend.registerType("Network.DirectTCPSocketOptions", [{ "name": "noDelay", "type": "boolean", "optional": false, "description": "TCP_NODELAY option", "typeRef": null }, { "name": "keepAliveDelay", "type": "number", "optional": true, "description": "Expected to be unsigned integer.", "typeRef": null }, { "name": "sendBufferSize", "type": "number", "optional": true, "description": "Expected to be unsigned integer.", "typeRef": null }, { "name": "receiveBufferSize", "type": "number", "optional": true, "description": "Expected to be unsigned integer.", "typeRef": null }, { "name": "dnsQueryType", "type": "string", "optional": true, "description": "", "typeRef": "Network.DirectSocketDnsQueryType" }]);
    inspectorBackend.registerType("Network.DirectUDPSocketOptions", [{ "name": "remoteAddr", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "remotePort", "type": "number", "optional": true, "description": "Unsigned int 16.", "typeRef": null }, { "name": "localAddr", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "localPort", "type": "number", "optional": true, "description": "Unsigned int 16.", "typeRef": null }, { "name": "dnsQueryType", "type": "string", "optional": true, "description": "", "typeRef": "Network.DirectSocketDnsQueryType" }, { "name": "sendBufferSize", "type": "number", "optional": true, "description": "Expected to be unsigned integer.", "typeRef": null }, { "name": "receiveBufferSize", "type": "number", "optional": true, "description": "Expected to be unsigned integer.", "typeRef": null }]);
    inspectorBackend.registerType("Network.DirectUDPMessage", [{ "name": "data", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "remoteAddr", "type": "string", "optional": true, "description": "Null for connected mode.", "typeRef": null }, { "name": "remotePort", "type": "number", "optional": true, "description": "Null for connected mode. Expected to be unsigned integer.", "typeRef": null }]);
    inspectorBackend.registerType("Network.ConnectTiming", [{ "name": "requestTime", "type": "number", "optional": false, "description": "Timing's requestTime is a baseline in seconds, while the other numbers are ticks in milliseconds relatively to this requestTime. Matches ResourceTiming's requestTime for the same request (but not for redirected requests).", "typeRef": null }]);
    inspectorBackend.registerType("Network.ClientSecurityState", [{ "name": "initiatorIsSecureContext", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "initiatorIPAddressSpace", "type": "string", "optional": false, "description": "", "typeRef": "Network.IPAddressSpace" }, { "name": "privateNetworkRequestPolicy", "type": "string", "optional": false, "description": "", "typeRef": "Network.PrivateNetworkRequestPolicy" }]);
    inspectorBackend.registerType("Network.CrossOriginOpenerPolicyStatus", [{ "name": "value", "type": "string", "optional": false, "description": "", "typeRef": "Network.CrossOriginOpenerPolicyValue" }, { "name": "reportOnlyValue", "type": "string", "optional": false, "description": "", "typeRef": "Network.CrossOriginOpenerPolicyValue" }, { "name": "reportingEndpoint", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "reportOnlyReportingEndpoint", "type": "string", "optional": true, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Network.CrossOriginEmbedderPolicyStatus", [{ "name": "value", "type": "string", "optional": false, "description": "", "typeRef": "Network.CrossOriginEmbedderPolicyValue" }, { "name": "reportOnlyValue", "type": "string", "optional": false, "description": "", "typeRef": "Network.CrossOriginEmbedderPolicyValue" }, { "name": "reportingEndpoint", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "reportOnlyReportingEndpoint", "type": "string", "optional": true, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Network.ContentSecurityPolicyStatus", [{ "name": "effectiveDirectives", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "isEnforced", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "source", "type": "string", "optional": false, "description": "", "typeRef": "Network.ContentSecurityPolicySource" }]);
    inspectorBackend.registerType("Network.SecurityIsolationStatus", [{ "name": "coop", "type": "object", "optional": true, "description": "", "typeRef": "Network.CrossOriginOpenerPolicyStatus" }, { "name": "coep", "type": "object", "optional": true, "description": "", "typeRef": "Network.CrossOriginEmbedderPolicyStatus" }, { "name": "csp", "type": "array", "optional": true, "description": "", "typeRef": "Network.ContentSecurityPolicyStatus" }]);
    inspectorBackend.registerType("Network.ReportingApiReport", [{ "name": "id", "type": "string", "optional": false, "description": "", "typeRef": "Network.ReportId" }, { "name": "initiatorUrl", "type": "string", "optional": false, "description": "The URL of the document that triggered the report.", "typeRef": null }, { "name": "destination", "type": "string", "optional": false, "description": "The name of the endpoint group that should be used to deliver the report.", "typeRef": null }, { "name": "type", "type": "string", "optional": false, "description": "The type of the report (specifies the set of data that is contained in the report body).", "typeRef": null }, { "name": "timestamp", "type": "number", "optional": false, "description": "When the report was generated.", "typeRef": "Network.TimeSinceEpoch" }, { "name": "depth", "type": "number", "optional": false, "description": "How many uploads deep the related request was.", "typeRef": null }, { "name": "completedAttempts", "type": "number", "optional": false, "description": "The number of delivery attempts made so far, not including an active attempt.", "typeRef": null }, { "name": "body", "type": "object", "optional": false, "description": "", "typeRef": null }, { "name": "status", "type": "string", "optional": false, "description": "", "typeRef": "Network.ReportStatus" }]);
    inspectorBackend.registerType("Network.ReportingApiEndpoint", [{ "name": "url", "type": "string", "optional": false, "description": "The URL of the endpoint to which reports may be delivered.", "typeRef": null }, { "name": "groupName", "type": "string", "optional": false, "description": "Name of the endpoint group.", "typeRef": null }]);
    inspectorBackend.registerType("Network.LoadNetworkResourcePageResult", [{ "name": "success", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "netError", "type": "number", "optional": true, "description": "Optional values used for error reporting.", "typeRef": null }, { "name": "netErrorName", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "httpStatusCode", "type": "number", "optional": true, "description": "", "typeRef": null }, { "name": "stream", "type": "string", "optional": true, "description": "If successful, one of the following two fields holds the result.", "typeRef": "IO.StreamHandle" }, { "name": "headers", "type": "object", "optional": true, "description": "Response headers.", "typeRef": "Network.Headers" }]);
    inspectorBackend.registerType("Network.LoadNetworkResourceOptions", [{ "name": "disableCache", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "includeCredentials", "type": "boolean", "optional": false, "description": "", "typeRef": null }]);
    // Overlay.
    inspectorBackend.registerEnum("Overlay.LineStylePattern", { Dashed: "dashed", Dotted: "dotted" });
    inspectorBackend.registerEnum("Overlay.ContrastAlgorithm", { Aa: "aa", Aaa: "aaa", Apca: "apca" });
    inspectorBackend.registerEnum("Overlay.ColorFormat", { Rgb: "rgb", Hsl: "hsl", Hwb: "hwb", Hex: "hex" });
    inspectorBackend.registerEnum("Overlay.InspectMode", { SearchForNode: "searchForNode", SearchForUAShadowDOM: "searchForUAShadowDOM", CaptureAreaScreenshot: "captureAreaScreenshot", None: "none" });
    inspectorBackend.registerEvent("Overlay.inspectNodeRequested", ["backendNodeId"]);
    inspectorBackend.registerEvent("Overlay.nodeHighlightRequested", ["nodeId"]);
    inspectorBackend.registerEvent("Overlay.screenshotRequested", ["viewport"]);
    inspectorBackend.registerEvent("Overlay.inspectModeCanceled", []);
    inspectorBackend.registerCommand("Overlay.disable", [], [], "Disables domain notifications.");
    inspectorBackend.registerCommand("Overlay.enable", [], [], "Enables domain notifications.");
    inspectorBackend.registerCommand("Overlay.getHighlightObjectForTest", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to get highlight object for.", "typeRef": "DOM.NodeId" }, { "name": "includeDistance", "type": "boolean", "optional": true, "description": "Whether to include distance info.", "typeRef": null }, { "name": "includeStyle", "type": "boolean", "optional": true, "description": "Whether to include style info.", "typeRef": null }, { "name": "colorFormat", "type": "string", "optional": true, "description": "The color format to get config with (default: hex).", "typeRef": "Overlay.ColorFormat" }, { "name": "showAccessibilityInfo", "type": "boolean", "optional": true, "description": "Whether to show accessibility info (default: true).", "typeRef": null }], ["highlight"], "For testing.");
    inspectorBackend.registerCommand("Overlay.getGridHighlightObjectsForTest", [{ "name": "nodeIds", "type": "array", "optional": false, "description": "Ids of the node to get highlight object for.", "typeRef": "DOM.NodeId" }], ["highlights"], "For Persistent Grid testing.");
    inspectorBackend.registerCommand("Overlay.getSourceOrderHighlightObjectForTest", [{ "name": "nodeId", "type": "number", "optional": false, "description": "Id of the node to highlight.", "typeRef": "DOM.NodeId" }], ["highlight"], "For Source Order Viewer testing.");
    inspectorBackend.registerCommand("Overlay.hideHighlight", [], [], "Hides any highlight.");
    inspectorBackend.registerCommand("Overlay.highlightFrame", [{ "name": "frameId", "type": "string", "optional": false, "description": "Identifier of the frame to highlight.", "typeRef": "Page.FrameId" }, { "name": "contentColor", "type": "object", "optional": true, "description": "The content box highlight fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "contentOutlineColor", "type": "object", "optional": true, "description": "The content box highlight outline color (default: transparent).", "typeRef": "DOM.RGBA" }], [], "Highlights owner element of the frame with given id. Deprecated: Doesn't work reliably and cannot be fixed due to process separation (the owner node might be in a different process). Determine the owner node in the client and use highlightNode.");
    inspectorBackend.registerCommand("Overlay.highlightNode", [{ "name": "highlightConfig", "type": "object", "optional": false, "description": "A descriptor for the highlight appearance.", "typeRef": "Overlay.HighlightConfig" }, { "name": "nodeId", "type": "number", "optional": true, "description": "Identifier of the node to highlight.", "typeRef": "DOM.NodeId" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "Identifier of the backend node to highlight.", "typeRef": "DOM.BackendNodeId" }, { "name": "objectId", "type": "string", "optional": true, "description": "JavaScript object id of the node to be highlighted.", "typeRef": "Runtime.RemoteObjectId" }, { "name": "selector", "type": "string", "optional": true, "description": "Selectors to highlight relevant nodes.", "typeRef": null }], [], "Highlights DOM node with given id or with the given JavaScript object wrapper. Either nodeId or objectId must be specified.");
    inspectorBackend.registerCommand("Overlay.highlightQuad", [{ "name": "quad", "type": "array", "optional": false, "description": "Quad to highlight", "typeRef": "DOM.Quad" }, { "name": "color", "type": "object", "optional": true, "description": "The highlight fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "outlineColor", "type": "object", "optional": true, "description": "The highlight outline color (default: transparent).", "typeRef": "DOM.RGBA" }], [], "Highlights given quad. Coordinates are absolute with respect to the main frame viewport.");
    inspectorBackend.registerCommand("Overlay.highlightRect", [{ "name": "x", "type": "number", "optional": false, "description": "X coordinate", "typeRef": null }, { "name": "y", "type": "number", "optional": false, "description": "Y coordinate", "typeRef": null }, { "name": "width", "type": "number", "optional": false, "description": "Rectangle width", "typeRef": null }, { "name": "height", "type": "number", "optional": false, "description": "Rectangle height", "typeRef": null }, { "name": "color", "type": "object", "optional": true, "description": "The highlight fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "outlineColor", "type": "object", "optional": true, "description": "The highlight outline color (default: transparent).", "typeRef": "DOM.RGBA" }], [], "Highlights given rectangle. Coordinates are absolute with respect to the main frame viewport. Issue: the method does not handle device pixel ratio (DPR) correctly. The coordinates currently have to be adjusted by the client if DPR is not 1 (see crbug.com/437807128).");
    inspectorBackend.registerCommand("Overlay.highlightSourceOrder", [{ "name": "sourceOrderConfig", "type": "object", "optional": false, "description": "A descriptor for the appearance of the overlay drawing.", "typeRef": "Overlay.SourceOrderConfig" }, { "name": "nodeId", "type": "number", "optional": true, "description": "Identifier of the node to highlight.", "typeRef": "DOM.NodeId" }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "Identifier of the backend node to highlight.", "typeRef": "DOM.BackendNodeId" }, { "name": "objectId", "type": "string", "optional": true, "description": "JavaScript object id of the node to be highlighted.", "typeRef": "Runtime.RemoteObjectId" }], [], "Highlights the source order of the children of the DOM node with given id or with the given JavaScript object wrapper. Either nodeId or objectId must be specified.");
    inspectorBackend.registerCommand("Overlay.setInspectMode", [{ "name": "mode", "type": "string", "optional": false, "description": "Set an inspection mode.", "typeRef": "Overlay.InspectMode" }, { "name": "highlightConfig", "type": "object", "optional": true, "description": "A descriptor for the highlight appearance of hovered-over nodes. May be omitted if `enabled == false`.", "typeRef": "Overlay.HighlightConfig" }], [], "Enters the 'inspect' mode. In this mode, elements that user is hovering over are highlighted. Backend then generates 'inspectNodeRequested' event upon element selection.");
    inspectorBackend.registerCommand("Overlay.setShowAdHighlights", [{ "name": "show", "type": "boolean", "optional": false, "description": "True for showing ad highlights", "typeRef": null }], [], "Highlights owner element of all frames detected to be ads.");
    inspectorBackend.registerCommand("Overlay.setPausedInDebuggerMessage", [{ "name": "message", "type": "string", "optional": true, "description": "The message to display, also triggers resume and step over controls.", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("Overlay.setShowDebugBorders", [{ "name": "show", "type": "boolean", "optional": false, "description": "True for showing debug borders", "typeRef": null }], [], "Requests that backend shows debug borders on layers");
    inspectorBackend.registerCommand("Overlay.setShowFPSCounter", [{ "name": "show", "type": "boolean", "optional": false, "description": "True for showing the FPS counter", "typeRef": null }], [], "Requests that backend shows the FPS counter");
    inspectorBackend.registerCommand("Overlay.setShowGridOverlays", [{ "name": "gridNodeHighlightConfigs", "type": "array", "optional": false, "description": "An array of node identifiers and descriptors for the highlight appearance.", "typeRef": "Overlay.GridNodeHighlightConfig" }], [], "Highlight multiple elements with the CSS Grid overlay.");
    inspectorBackend.registerCommand("Overlay.setShowFlexOverlays", [{ "name": "flexNodeHighlightConfigs", "type": "array", "optional": false, "description": "An array of node identifiers and descriptors for the highlight appearance.", "typeRef": "Overlay.FlexNodeHighlightConfig" }], [], "");
    inspectorBackend.registerCommand("Overlay.setShowScrollSnapOverlays", [{ "name": "scrollSnapHighlightConfigs", "type": "array", "optional": false, "description": "An array of node identifiers and descriptors for the highlight appearance.", "typeRef": "Overlay.ScrollSnapHighlightConfig" }], [], "");
    inspectorBackend.registerCommand("Overlay.setShowContainerQueryOverlays", [{ "name": "containerQueryHighlightConfigs", "type": "array", "optional": false, "description": "An array of node identifiers and descriptors for the highlight appearance.", "typeRef": "Overlay.ContainerQueryHighlightConfig" }], [], "");
    inspectorBackend.registerCommand("Overlay.setShowPaintRects", [{ "name": "result", "type": "boolean", "optional": false, "description": "True for showing paint rectangles", "typeRef": null }], [], "Requests that backend shows paint rectangles");
    inspectorBackend.registerCommand("Overlay.setShowLayoutShiftRegions", [{ "name": "result", "type": "boolean", "optional": false, "description": "True for showing layout shift regions", "typeRef": null }], [], "Requests that backend shows layout shift regions");
    inspectorBackend.registerCommand("Overlay.setShowScrollBottleneckRects", [{ "name": "show", "type": "boolean", "optional": false, "description": "True for showing scroll bottleneck rects", "typeRef": null }], [], "Requests that backend shows scroll bottleneck rects");
    inspectorBackend.registerCommand("Overlay.setShowHitTestBorders", [{ "name": "show", "type": "boolean", "optional": false, "description": "True for showing hit-test borders", "typeRef": null }], [], "Deprecated, no longer has any effect.");
    inspectorBackend.registerCommand("Overlay.setShowWebVitals", [{ "name": "show", "type": "boolean", "optional": false, "description": "", "typeRef": null }], [], "Deprecated, no longer has any effect.");
    inspectorBackend.registerCommand("Overlay.setShowViewportSizeOnResize", [{ "name": "show", "type": "boolean", "optional": false, "description": "Whether to paint size or not.", "typeRef": null }], [], "Paints viewport size upon main frame resize.");
    inspectorBackend.registerCommand("Overlay.setShowHinge", [{ "name": "hingeConfig", "type": "object", "optional": true, "description": "hinge data, null means hideHinge", "typeRef": "Overlay.HingeConfig" }], [], "Add a dual screen device hinge");
    inspectorBackend.registerCommand("Overlay.setShowIsolatedElements", [{ "name": "isolatedElementHighlightConfigs", "type": "array", "optional": false, "description": "An array of node identifiers and descriptors for the highlight appearance.", "typeRef": "Overlay.IsolatedElementHighlightConfig" }], [], "Show elements in isolation mode with overlays.");
    inspectorBackend.registerCommand("Overlay.setShowWindowControlsOverlay", [{ "name": "windowControlsOverlayConfig", "type": "object", "optional": true, "description": "Window Controls Overlay data, null means hide Window Controls Overlay", "typeRef": "Overlay.WindowControlsOverlayConfig" }], [], "Show Window Controls Overlay for PWA");
    inspectorBackend.registerType("Overlay.SourceOrderConfig", [{ "name": "parentOutlineColor", "type": "object", "optional": false, "description": "the color to outline the given element in.", "typeRef": "DOM.RGBA" }, { "name": "childOutlineColor", "type": "object", "optional": false, "description": "the color to outline the child elements in.", "typeRef": "DOM.RGBA" }]);
    inspectorBackend.registerType("Overlay.GridHighlightConfig", [{ "name": "showGridExtensionLines", "type": "boolean", "optional": true, "description": "Whether the extension lines from grid cells to the rulers should be shown (default: false).", "typeRef": null }, { "name": "showPositiveLineNumbers", "type": "boolean", "optional": true, "description": "Show Positive line number labels (default: false).", "typeRef": null }, { "name": "showNegativeLineNumbers", "type": "boolean", "optional": true, "description": "Show Negative line number labels (default: false).", "typeRef": null }, { "name": "showAreaNames", "type": "boolean", "optional": true, "description": "Show area name labels (default: false).", "typeRef": null }, { "name": "showLineNames", "type": "boolean", "optional": true, "description": "Show line name labels (default: false).", "typeRef": null }, { "name": "showTrackSizes", "type": "boolean", "optional": true, "description": "Show track size labels (default: false).", "typeRef": null }, { "name": "gridBorderColor", "type": "object", "optional": true, "description": "The grid container border highlight color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "cellBorderColor", "type": "object", "optional": true, "description": "The cell border color (default: transparent). Deprecated, please use rowLineColor and columnLineColor instead.", "typeRef": "DOM.RGBA" }, { "name": "rowLineColor", "type": "object", "optional": true, "description": "The row line color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "columnLineColor", "type": "object", "optional": true, "description": "The column line color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "gridBorderDash", "type": "boolean", "optional": true, "description": "Whether the grid border is dashed (default: false).", "typeRef": null }, { "name": "cellBorderDash", "type": "boolean", "optional": true, "description": "Whether the cell border is dashed (default: false). Deprecated, please us rowLineDash and columnLineDash instead.", "typeRef": null }, { "name": "rowLineDash", "type": "boolean", "optional": true, "description": "Whether row lines are dashed (default: false).", "typeRef": null }, { "name": "columnLineDash", "type": "boolean", "optional": true, "description": "Whether column lines are dashed (default: false).", "typeRef": null }, { "name": "rowGapColor", "type": "object", "optional": true, "description": "The row gap highlight fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "rowHatchColor", "type": "object", "optional": true, "description": "The row gap hatching fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "columnGapColor", "type": "object", "optional": true, "description": "The column gap highlight fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "columnHatchColor", "type": "object", "optional": true, "description": "The column gap hatching fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "areaBorderColor", "type": "object", "optional": true, "description": "The named grid areas border color (Default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "gridBackgroundColor", "type": "object", "optional": true, "description": "The grid container background color (Default: transparent).", "typeRef": "DOM.RGBA" }]);
    inspectorBackend.registerType("Overlay.FlexContainerHighlightConfig", [{ "name": "containerBorder", "type": "object", "optional": true, "description": "The style of the container border", "typeRef": "Overlay.LineStyle" }, { "name": "lineSeparator", "type": "object", "optional": true, "description": "The style of the separator between lines", "typeRef": "Overlay.LineStyle" }, { "name": "itemSeparator", "type": "object", "optional": true, "description": "The style of the separator between items", "typeRef": "Overlay.LineStyle" }, { "name": "mainDistributedSpace", "type": "object", "optional": true, "description": "Style of content-distribution space on the main axis (justify-content).", "typeRef": "Overlay.BoxStyle" }, { "name": "crossDistributedSpace", "type": "object", "optional": true, "description": "Style of content-distribution space on the cross axis (align-content).", "typeRef": "Overlay.BoxStyle" }, { "name": "rowGapSpace", "type": "object", "optional": true, "description": "Style of empty space caused by row gaps (gap/row-gap).", "typeRef": "Overlay.BoxStyle" }, { "name": "columnGapSpace", "type": "object", "optional": true, "description": "Style of empty space caused by columns gaps (gap/column-gap).", "typeRef": "Overlay.BoxStyle" }, { "name": "crossAlignment", "type": "object", "optional": true, "description": "Style of the self-alignment line (align-items).", "typeRef": "Overlay.LineStyle" }]);
    inspectorBackend.registerType("Overlay.FlexItemHighlightConfig", [{ "name": "baseSizeBox", "type": "object", "optional": true, "description": "Style of the box representing the item's base size", "typeRef": "Overlay.BoxStyle" }, { "name": "baseSizeBorder", "type": "object", "optional": true, "description": "Style of the border around the box representing the item's base size", "typeRef": "Overlay.LineStyle" }, { "name": "flexibilityArrow", "type": "object", "optional": true, "description": "Style of the arrow representing if the item grew or shrank", "typeRef": "Overlay.LineStyle" }]);
    inspectorBackend.registerType("Overlay.LineStyle", [{ "name": "color", "type": "object", "optional": true, "description": "The color of the line (default: transparent)", "typeRef": "DOM.RGBA" }, { "name": "pattern", "type": "string", "optional": true, "description": "The line pattern (default: solid)", "typeRef": null }]);
    inspectorBackend.registerType("Overlay.BoxStyle", [{ "name": "fillColor", "type": "object", "optional": true, "description": "The background color for the box (default: transparent)", "typeRef": "DOM.RGBA" }, { "name": "hatchColor", "type": "object", "optional": true, "description": "The hatching color for the box (default: transparent)", "typeRef": "DOM.RGBA" }]);
    inspectorBackend.registerType("Overlay.HighlightConfig", [{ "name": "showInfo", "type": "boolean", "optional": true, "description": "Whether the node info tooltip should be shown (default: false).", "typeRef": null }, { "name": "showStyles", "type": "boolean", "optional": true, "description": "Whether the node styles in the tooltip (default: false).", "typeRef": null }, { "name": "showRulers", "type": "boolean", "optional": true, "description": "Whether the rulers should be shown (default: false).", "typeRef": null }, { "name": "showAccessibilityInfo", "type": "boolean", "optional": true, "description": "Whether the a11y info should be shown (default: true).", "typeRef": null }, { "name": "showExtensionLines", "type": "boolean", "optional": true, "description": "Whether the extension lines from node to the rulers should be shown (default: false).", "typeRef": null }, { "name": "contentColor", "type": "object", "optional": true, "description": "The content box highlight fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "paddingColor", "type": "object", "optional": true, "description": "The padding highlight fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "borderColor", "type": "object", "optional": true, "description": "The border highlight fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "marginColor", "type": "object", "optional": true, "description": "The margin highlight fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "eventTargetColor", "type": "object", "optional": true, "description": "The event target element highlight fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "shapeColor", "type": "object", "optional": true, "description": "The shape outside fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "shapeMarginColor", "type": "object", "optional": true, "description": "The shape margin fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "cssGridColor", "type": "object", "optional": true, "description": "The grid layout color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "colorFormat", "type": "string", "optional": true, "description": "The color format used to format color styles (default: hex).", "typeRef": "Overlay.ColorFormat" }, { "name": "gridHighlightConfig", "type": "object", "optional": true, "description": "The grid layout highlight configuration (default: all transparent).", "typeRef": "Overlay.GridHighlightConfig" }, { "name": "flexContainerHighlightConfig", "type": "object", "optional": true, "description": "The flex container highlight configuration (default: all transparent).", "typeRef": "Overlay.FlexContainerHighlightConfig" }, { "name": "flexItemHighlightConfig", "type": "object", "optional": true, "description": "The flex item highlight configuration (default: all transparent).", "typeRef": "Overlay.FlexItemHighlightConfig" }, { "name": "contrastAlgorithm", "type": "string", "optional": true, "description": "The contrast algorithm to use for the contrast ratio (default: aa).", "typeRef": "Overlay.ContrastAlgorithm" }, { "name": "containerQueryContainerHighlightConfig", "type": "object", "optional": true, "description": "The container query container highlight configuration (default: all transparent).", "typeRef": "Overlay.ContainerQueryContainerHighlightConfig" }]);
    inspectorBackend.registerType("Overlay.GridNodeHighlightConfig", [{ "name": "gridHighlightConfig", "type": "object", "optional": false, "description": "A descriptor for the highlight appearance.", "typeRef": "Overlay.GridHighlightConfig" }, { "name": "nodeId", "type": "number", "optional": false, "description": "Identifier of the node to highlight.", "typeRef": "DOM.NodeId" }]);
    inspectorBackend.registerType("Overlay.FlexNodeHighlightConfig", [{ "name": "flexContainerHighlightConfig", "type": "object", "optional": false, "description": "A descriptor for the highlight appearance of flex containers.", "typeRef": "Overlay.FlexContainerHighlightConfig" }, { "name": "nodeId", "type": "number", "optional": false, "description": "Identifier of the node to highlight.", "typeRef": "DOM.NodeId" }]);
    inspectorBackend.registerType("Overlay.ScrollSnapContainerHighlightConfig", [{ "name": "snapportBorder", "type": "object", "optional": true, "description": "The style of the snapport border (default: transparent)", "typeRef": "Overlay.LineStyle" }, { "name": "snapAreaBorder", "type": "object", "optional": true, "description": "The style of the snap area border (default: transparent)", "typeRef": "Overlay.LineStyle" }, { "name": "scrollMarginColor", "type": "object", "optional": true, "description": "The margin highlight fill color (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "scrollPaddingColor", "type": "object", "optional": true, "description": "The padding highlight fill color (default: transparent).", "typeRef": "DOM.RGBA" }]);
    inspectorBackend.registerType("Overlay.ScrollSnapHighlightConfig", [{ "name": "scrollSnapContainerHighlightConfig", "type": "object", "optional": false, "description": "A descriptor for the highlight appearance of scroll snap containers.", "typeRef": "Overlay.ScrollSnapContainerHighlightConfig" }, { "name": "nodeId", "type": "number", "optional": false, "description": "Identifier of the node to highlight.", "typeRef": "DOM.NodeId" }]);
    inspectorBackend.registerType("Overlay.HingeConfig", [{ "name": "rect", "type": "object", "optional": false, "description": "A rectangle represent hinge", "typeRef": "DOM.Rect" }, { "name": "contentColor", "type": "object", "optional": true, "description": "The content box highlight fill color (default: a dark color).", "typeRef": "DOM.RGBA" }, { "name": "outlineColor", "type": "object", "optional": true, "description": "The content box highlight outline color (default: transparent).", "typeRef": "DOM.RGBA" }]);
    inspectorBackend.registerType("Overlay.WindowControlsOverlayConfig", [{ "name": "showCSS", "type": "boolean", "optional": false, "description": "Whether the title bar CSS should be shown when emulating the Window Controls Overlay.", "typeRef": null }, { "name": "selectedPlatform", "type": "string", "optional": false, "description": "Selected platforms to show the overlay.", "typeRef": null }, { "name": "themeColor", "type": "string", "optional": false, "description": "The theme color defined in app manifest.", "typeRef": null }]);
    inspectorBackend.registerType("Overlay.ContainerQueryHighlightConfig", [{ "name": "containerQueryContainerHighlightConfig", "type": "object", "optional": false, "description": "A descriptor for the highlight appearance of container query containers.", "typeRef": "Overlay.ContainerQueryContainerHighlightConfig" }, { "name": "nodeId", "type": "number", "optional": false, "description": "Identifier of the container node to highlight.", "typeRef": "DOM.NodeId" }]);
    inspectorBackend.registerType("Overlay.ContainerQueryContainerHighlightConfig", [{ "name": "containerBorder", "type": "object", "optional": true, "description": "The style of the container border.", "typeRef": "Overlay.LineStyle" }, { "name": "descendantBorder", "type": "object", "optional": true, "description": "The style of the descendants' borders.", "typeRef": "Overlay.LineStyle" }]);
    inspectorBackend.registerType("Overlay.IsolatedElementHighlightConfig", [{ "name": "isolationModeHighlightConfig", "type": "object", "optional": false, "description": "A descriptor for the highlight appearance of an element in isolation mode.", "typeRef": "Overlay.IsolationModeHighlightConfig" }, { "name": "nodeId", "type": "number", "optional": false, "description": "Identifier of the isolated element to highlight.", "typeRef": "DOM.NodeId" }]);
    inspectorBackend.registerType("Overlay.IsolationModeHighlightConfig", [{ "name": "resizerColor", "type": "object", "optional": true, "description": "The fill color of the resizers (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "resizerHandleColor", "type": "object", "optional": true, "description": "The fill color for resizer handles (default: transparent).", "typeRef": "DOM.RGBA" }, { "name": "maskColor", "type": "object", "optional": true, "description": "The fill color for the mask covering non-isolated elements (default: transparent).", "typeRef": "DOM.RGBA" }]);
    // PWA.
    inspectorBackend.registerEnum("PWA.DisplayMode", { Standalone: "standalone", Browser: "browser" });
    inspectorBackend.registerCommand("PWA.getOsAppState", [{ "name": "manifestId", "type": "string", "optional": false, "description": "The id from the webapp's manifest file, commonly it's the url of the site installing the webapp. See https://web.dev/learn/pwa/web-app-manifest.", "typeRef": null }], ["badgeCount", "fileHandlers"], "Returns the following OS state for the given manifest id.");
    inspectorBackend.registerCommand("PWA.install", [{ "name": "manifestId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "installUrlOrBundleUrl", "type": "string", "optional": true, "description": "The location of the app or bundle overriding the one derived from the manifestId.", "typeRef": null }], [], "Installs the given manifest identity, optionally using the given installUrlOrBundleUrl  IWA-specific install description: manifestId corresponds to isolated-app:// + web_package::SignedWebBundleId  File installation mode: The installUrlOrBundleUrl can be either file:// or http(s):// pointing to a signed web bundle (.swbn). In this case SignedWebBundleId must correspond to The .swbn file's signing key.  Dev proxy installation mode: installUrlOrBundleUrl must be http(s):// that serves dev mode IWA. web_package::SignedWebBundleId must be of type dev proxy.  The advantage of dev proxy mode is that all changes to IWA automatically will be reflected in the running app without reinstallation.  To generate bundle id for proxy mode: 1. Generate 32 random bytes. 2. Add a specific suffix at the end following the documentation    https://github.com/WICG/isolated-web-apps/blob/main/Scheme.md#suffix 3. Encode the entire sequence using Base32 without padding.  If Chrome is not in IWA dev mode, the installation will fail, regardless of the state of the allowlist.");
    inspectorBackend.registerCommand("PWA.uninstall", [{ "name": "manifestId", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Uninstalls the given manifest_id and closes any opened app windows.");
    inspectorBackend.registerCommand("PWA.launch", [{ "name": "manifestId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "url", "type": "string", "optional": true, "description": "", "typeRef": null }], ["targetId"], "Launches the installed web app, or an url in the same web app instead of the default start url if it is provided. Returns a page Target.TargetID which can be used to attach to via Target.attachToTarget or similar APIs.");
    inspectorBackend.registerCommand("PWA.launchFilesInApp", [{ "name": "manifestId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "files", "type": "array", "optional": false, "description": "", "typeRef": "string" }], ["targetIds"], "Opens one or more local files from an installed web app identified by its manifestId. The web app needs to have file handlers registered to process the files. The API returns one or more page Target.TargetIDs which can be used to attach to via Target.attachToTarget or similar APIs. If some files in the parameters cannot be handled by the web app, they will be ignored. If none of the files can be handled, this API returns an error. If no files are provided as the parameter, this API also returns an error.  According to the definition of the file handlers in the manifest file, one Target.TargetID may represent a page handling one or more files. The order of the returned Target.TargetIDs is not guaranteed.  TODO(crbug.com/339454034): Check the existences of the input files.");
    inspectorBackend.registerCommand("PWA.openCurrentPageInApp", [{ "name": "manifestId", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Opens the current page in its web app identified by the manifest id, needs to be called on a page target. This function returns immediately without waiting for the app to finish loading.");
    inspectorBackend.registerCommand("PWA.changeAppUserSettings", [{ "name": "manifestId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "linkCapturing", "type": "boolean", "optional": true, "description": "If user allows the links clicked on by the user in the app's scope, or extended scope if the manifest has scope extensions and the flags `DesktopPWAsLinkCapturingWithScopeExtensions` and `WebAppEnableScopeExtensions` are enabled.  Note, the API does not support resetting the linkCapturing to the initial value, uninstalling and installing the web app again will reset it.  TODO(crbug.com/339453269): Setting this value on ChromeOS is not supported yet.", "typeRef": null }, { "name": "displayMode", "type": "string", "optional": true, "description": "", "typeRef": "PWA.DisplayMode" }], [], "Changes user settings of the web app identified by its manifestId. If the app was not installed, this command returns an error. Unset parameters will be ignored; unrecognized values will cause an error.  Unlike the ones defined in the manifest files of the web apps, these settings are provided by the browser and controlled by the users, they impact the way the browser handling the web apps.  See the comment of each parameter.");
    inspectorBackend.registerType("PWA.FileHandlerAccept", [{ "name": "mediaType", "type": "string", "optional": false, "description": "New name of the mimetype according to https://www.iana.org/assignments/media-types/media-types.xhtml", "typeRef": null }, { "name": "fileExtensions", "type": "array", "optional": false, "description": "", "typeRef": "string" }]);
    inspectorBackend.registerType("PWA.FileHandler", [{ "name": "action", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "accepts", "type": "array", "optional": false, "description": "", "typeRef": "PWA.FileHandlerAccept" }, { "name": "displayName", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    // Page.
    inspectorBackend.registerEnum("Page.AdFrameType", { None: "none", Child: "child", Root: "root" });
    inspectorBackend.registerEnum("Page.AdFrameExplanation", { ParentIsAd: "ParentIsAd", CreatedByAdScript: "CreatedByAdScript", MatchedBlockingRule: "MatchedBlockingRule" });
    inspectorBackend.registerEnum("Page.SecureContextType", { Secure: "Secure", SecureLocalhost: "SecureLocalhost", InsecureScheme: "InsecureScheme", InsecureAncestor: "InsecureAncestor" });
    inspectorBackend.registerEnum("Page.CrossOriginIsolatedContextType", { Isolated: "Isolated", NotIsolated: "NotIsolated", NotIsolatedFeatureDisabled: "NotIsolatedFeatureDisabled" });
    inspectorBackend.registerEnum("Page.GatedAPIFeatures", { SharedArrayBuffers: "SharedArrayBuffers", SharedArrayBuffersTransferAllowed: "SharedArrayBuffersTransferAllowed", PerformanceMeasureMemory: "PerformanceMeasureMemory", PerformanceProfile: "PerformanceProfile" });
    inspectorBackend.registerEnum("Page.PermissionsPolicyFeature", { Accelerometer: "accelerometer", AllScreensCapture: "all-screens-capture", AmbientLightSensor: "ambient-light-sensor", AriaNotify: "aria-notify", AttributionReporting: "attribution-reporting", Autoplay: "autoplay", Bluetooth: "bluetooth", BrowsingTopics: "browsing-topics", Camera: "camera", CapturedSurfaceControl: "captured-surface-control", ChDpr: "ch-dpr", ChDeviceMemory: "ch-device-memory", ChDownlink: "ch-downlink", ChEct: "ch-ect", ChPrefersColorScheme: "ch-prefers-color-scheme", ChPrefersReducedMotion: "ch-prefers-reduced-motion", ChPrefersReducedTransparency: "ch-prefers-reduced-transparency", ChRtt: "ch-rtt", ChSaveData: "ch-save-data", ChUa: "ch-ua", ChUaArch: "ch-ua-arch", ChUaBitness: "ch-ua-bitness", ChUaHighEntropyValues: "ch-ua-high-entropy-values", ChUaPlatform: "ch-ua-platform", ChUaModel: "ch-ua-model", ChUaMobile: "ch-ua-mobile", ChUaFormFactors: "ch-ua-form-factors", ChUaFullVersion: "ch-ua-full-version", ChUaFullVersionList: "ch-ua-full-version-list", ChUaPlatformVersion: "ch-ua-platform-version", ChUaWow64: "ch-ua-wow64", ChViewportHeight: "ch-viewport-height", ChViewportWidth: "ch-viewport-width", ChWidth: "ch-width", ClipboardRead: "clipboard-read", ClipboardWrite: "clipboard-write", ComputePressure: "compute-pressure", ControlledFrame: "controlled-frame", CrossOriginIsolated: "cross-origin-isolated", DeferredFetch: "deferred-fetch", DeferredFetchMinimal: "deferred-fetch-minimal", DeviceAttributes: "device-attributes", DigitalCredentialsCreate: "digital-credentials-create", DigitalCredentialsGet: "digital-credentials-get", DirectSockets: "direct-sockets", DirectSocketsMulticast: "direct-sockets-multicast", DirectSocketsPrivate: "direct-sockets-private", DisplayCapture: "display-capture", DocumentDomain: "document-domain", EncryptedMedia: "encrypted-media", ExecutionWhileOutOfViewport: "execution-while-out-of-viewport", ExecutionWhileNotRendered: "execution-while-not-rendered", FencedUnpartitionedStorageRead: "fenced-unpartitioned-storage-read", FocusWithoutUserActivation: "focus-without-user-activation", Fullscreen: "fullscreen", Frobulate: "frobulate", Gamepad: "gamepad", Geolocation: "geolocation", Gyroscope: "gyroscope", Hid: "hid", IdentityCredentialsGet: "identity-credentials-get", IdleDetection: "idle-detection", InterestCohort: "interest-cohort", JoinAdInterestGroup: "join-ad-interest-group", KeyboardMap: "keyboard-map", LanguageDetector: "language-detector", LanguageModel: "language-model", LocalFonts: "local-fonts", LocalNetworkAccess: "local-network-access", Magnetometer: "magnetometer", MediaPlaybackWhileNotVisible: "media-playback-while-not-visible", Microphone: "microphone", Midi: "midi", OnDeviceSpeechRecognition: "on-device-speech-recognition", OtpCredentials: "otp-credentials", Payment: "payment", PictureInPicture: "picture-in-picture", Popins: "popins", PrivateAggregation: "private-aggregation", PrivateStateTokenIssuance: "private-state-token-issuance", PrivateStateTokenRedemption: "private-state-token-redemption", PublickeyCredentialsCreate: "publickey-credentials-create", PublickeyCredentialsGet: "publickey-credentials-get", RecordAdAuctionEvents: "record-ad-auction-events", Rewriter: "rewriter", RunAdAuction: "run-ad-auction", ScreenWakeLock: "screen-wake-lock", Serial: "serial", SharedAutofill: "shared-autofill", SharedStorage: "shared-storage", SharedStorageSelectUrl: "shared-storage-select-url", SmartCard: "smart-card", SpeakerSelection: "speaker-selection", StorageAccess: "storage-access", SubApps: "sub-apps", Summarizer: "summarizer", SyncXhr: "sync-xhr", Translator: "translator", Unload: "unload", Usb: "usb", UsbUnrestricted: "usb-unrestricted", VerticalScroll: "vertical-scroll", WebAppInstallation: "web-app-installation", WebPrinting: "web-printing", WebShare: "web-share", WindowManagement: "window-management", Writer: "writer", XrSpatialTracking: "xr-spatial-tracking" });
    inspectorBackend.registerEnum("Page.PermissionsPolicyBlockReason", { Header: "Header", IframeAttribute: "IframeAttribute", InFencedFrameTree: "InFencedFrameTree", InIsolatedApp: "InIsolatedApp" });
    inspectorBackend.registerEnum("Page.OriginTrialTokenStatus", { Success: "Success", NotSupported: "NotSupported", Insecure: "Insecure", Expired: "Expired", WrongOrigin: "WrongOrigin", InvalidSignature: "InvalidSignature", Malformed: "Malformed", WrongVersion: "WrongVersion", FeatureDisabled: "FeatureDisabled", TokenDisabled: "TokenDisabled", FeatureDisabledForUser: "FeatureDisabledForUser", UnknownTrial: "UnknownTrial" });
    inspectorBackend.registerEnum("Page.OriginTrialStatus", { Enabled: "Enabled", ValidTokenNotProvided: "ValidTokenNotProvided", OSNotSupported: "OSNotSupported", TrialNotAllowed: "TrialNotAllowed" });
    inspectorBackend.registerEnum("Page.OriginTrialUsageRestriction", { None: "None", Subset: "Subset" });
    inspectorBackend.registerEnum("Page.TransitionType", { Link: "link", Typed: "typed", Address_bar: "address_bar", Auto_bookmark: "auto_bookmark", Auto_subframe: "auto_subframe", Manual_subframe: "manual_subframe", Generated: "generated", Auto_toplevel: "auto_toplevel", Form_submit: "form_submit", Reload: "reload", Keyword: "keyword", Keyword_generated: "keyword_generated", Other: "other" });
    inspectorBackend.registerEnum("Page.DialogType", { Alert: "alert", Confirm: "confirm", Prompt: "prompt", Beforeunload: "beforeunload" });
    inspectorBackend.registerEnum("Page.ClientNavigationReason", { AnchorClick: "anchorClick", FormSubmissionGet: "formSubmissionGet", FormSubmissionPost: "formSubmissionPost", HttpHeaderRefresh: "httpHeaderRefresh", InitialFrameNavigation: "initialFrameNavigation", MetaTagRefresh: "metaTagRefresh", Other: "other", PageBlockInterstitial: "pageBlockInterstitial", Reload: "reload", ScriptInitiated: "scriptInitiated" });
    inspectorBackend.registerEnum("Page.ClientNavigationDisposition", { CurrentTab: "currentTab", NewTab: "newTab", NewWindow: "newWindow", Download: "download" });
    inspectorBackend.registerEnum("Page.ReferrerPolicy", { NoReferrer: "noReferrer", NoReferrerWhenDowngrade: "noReferrerWhenDowngrade", Origin: "origin", OriginWhenCrossOrigin: "originWhenCrossOrigin", SameOrigin: "sameOrigin", StrictOrigin: "strictOrigin", StrictOriginWhenCrossOrigin: "strictOriginWhenCrossOrigin", UnsafeUrl: "unsafeUrl" });
    inspectorBackend.registerEnum("Page.NavigationType", { Navigation: "Navigation", BackForwardCacheRestore: "BackForwardCacheRestore" });
    inspectorBackend.registerEnum("Page.BackForwardCacheNotRestoredReason", { NotPrimaryMainFrame: "NotPrimaryMainFrame", BackForwardCacheDisabled: "BackForwardCacheDisabled", RelatedActiveContentsExist: "RelatedActiveContentsExist", HTTPStatusNotOK: "HTTPStatusNotOK", SchemeNotHTTPOrHTTPS: "SchemeNotHTTPOrHTTPS", Loading: "Loading", WasGrantedMediaAccess: "WasGrantedMediaAccess", DisableForRenderFrameHostCalled: "DisableForRenderFrameHostCalled", DomainNotAllowed: "DomainNotAllowed", HTTPMethodNotGET: "HTTPMethodNotGET", SubframeIsNavigating: "SubframeIsNavigating", Timeout: "Timeout", CacheLimit: "CacheLimit", JavaScriptExecution: "JavaScriptExecution", RendererProcessKilled: "RendererProcessKilled", RendererProcessCrashed: "RendererProcessCrashed", SchedulerTrackedFeatureUsed: "SchedulerTrackedFeatureUsed", ConflictingBrowsingInstance: "ConflictingBrowsingInstance", CacheFlushed: "CacheFlushed", ServiceWorkerVersionActivation: "ServiceWorkerVersionActivation", SessionRestored: "SessionRestored", ServiceWorkerPostMessage: "ServiceWorkerPostMessage", EnteredBackForwardCacheBeforeServiceWorkerHostAdded: "EnteredBackForwardCacheBeforeServiceWorkerHostAdded", RenderFrameHostReused_SameSite: "RenderFrameHostReused_SameSite", RenderFrameHostReused_CrossSite: "RenderFrameHostReused_CrossSite", ServiceWorkerClaim: "ServiceWorkerClaim", IgnoreEventAndEvict: "IgnoreEventAndEvict", HaveInnerContents: "HaveInnerContents", TimeoutPuttingInCache: "TimeoutPuttingInCache", BackForwardCacheDisabledByLowMemory: "BackForwardCacheDisabledByLowMemory", BackForwardCacheDisabledByCommandLine: "BackForwardCacheDisabledByCommandLine", NetworkRequestDatAPIpeDrainedAsBytesConsumer: "NetworkRequestDatapipeDrainedAsBytesConsumer", NetworkRequestRedirected: "NetworkRequestRedirected", NetworkRequestTimeout: "NetworkRequestTimeout", NetworkExceedsBufferLimit: "NetworkExceedsBufferLimit", NavigationCancelledWhileRestoring: "NavigationCancelledWhileRestoring", NotMostRecentNavigationEntry: "NotMostRecentNavigationEntry", BackForwardCacheDisabledForPrerender: "BackForwardCacheDisabledForPrerender", UserAgentOverrideDiffers: "UserAgentOverrideDiffers", ForegroundCacheLimit: "ForegroundCacheLimit", BrowsingInstanceNotSwapped: "BrowsingInstanceNotSwapped", BackForwardCacheDisabledForDelegate: "BackForwardCacheDisabledForDelegate", UnloadHandlerExistsInMainFrame: "UnloadHandlerExistsInMainFrame", UnloadHandlerExistsInSubFrame: "UnloadHandlerExistsInSubFrame", ServiceWorkerUnregistration: "ServiceWorkerUnregistration", CacheControlNoStore: "CacheControlNoStore", CacheControlNoStoreCookieModified: "CacheControlNoStoreCookieModified", CacheControlNoStoreHTTPOnlyCookieModified: "CacheControlNoStoreHTTPOnlyCookieModified", NoResponseHead: "NoResponseHead", Unknown: "Unknown", ActivationNavigationsDisallowedForBug1234857: "ActivationNavigationsDisallowedForBug1234857", ErrorDocument: "ErrorDocument", FencedFramesEmbedder: "FencedFramesEmbedder", CookieDisabled: "CookieDisabled", HTTPAuthRequired: "HTTPAuthRequired", CookieFlushed: "CookieFlushed", BroadcastChannelOnMessage: "BroadcastChannelOnMessage", WebViewSettingsChanged: "WebViewSettingsChanged", WebViewJavaScriptObjectChanged: "WebViewJavaScriptObjectChanged", WebViewMessageListenerInjected: "WebViewMessageListenerInjected", WebViewSafeBrowsingAllowlistChanged: "WebViewSafeBrowsingAllowlistChanged", WebViewDocumentStartJavascriptChanged: "WebViewDocumentStartJavascriptChanged", WebSocket: "WebSocket", WebTransport: "WebTransport", WebRTC: "WebRTC", MainResourceHasCacheControlNoStore: "MainResourceHasCacheControlNoStore", MainResourceHasCacheControlNoCache: "MainResourceHasCacheControlNoCache", SubresourceHasCacheControlNoStore: "SubresourceHasCacheControlNoStore", SubresourceHasCacheControlNoCache: "SubresourceHasCacheControlNoCache", ContainsPlugins: "ContainsPlugins", DocumentLoaded: "DocumentLoaded", OutstandingNetworkRequestOthers: "OutstandingNetworkRequestOthers", RequestedMIDIPermission: "RequestedMIDIPermission", RequestedAudioCapturePermission: "RequestedAudioCapturePermission", RequestedVideoCapturePermission: "RequestedVideoCapturePermission", RequestedBackForwardCacheBlockedSensors: "RequestedBackForwardCacheBlockedSensors", RequestedBackgroundWorkPermission: "RequestedBackgroundWorkPermission", BroadcastChannel: "BroadcastChannel", WebXR: "WebXR", SharedWorker: "SharedWorker", SharedWorkerMessage: "SharedWorkerMessage", SharedWorkerWithNoActiveClient: "SharedWorkerWithNoActiveClient", WebLocks: "WebLocks", WebHID: "WebHID", WebBluetooth: "WebBluetooth", WebShare: "WebShare", RequestedStorageAccessGrant: "RequestedStorageAccessGrant", WebNfc: "WebNfc", OutstandingNetworkRequestFetch: "OutstandingNetworkRequestFetch", OutstandingNetworkRequestXHR: "OutstandingNetworkRequestXHR", AppBanner: "AppBanner", Printing: "Printing", WebDatabase: "WebDatabase", PictureInPicture: "PictureInPicture", SpeechRecognizer: "SpeechRecognizer", IdleManager: "IdleManager", PaymentManager: "PaymentManager", SpeechSynthesis: "SpeechSynthesis", KeyboardLock: "KeyboardLock", WebOTPService: "WebOTPService", OutstandingNetworkRequestDirectSocket: "OutstandingNetworkRequestDirectSocket", InjectedJavascript: "InjectedJavascript", InjectedStyleSheet: "InjectedStyleSheet", KeepaliveRequest: "KeepaliveRequest", IndexedDBEvent: "IndexedDBEvent", Dummy: "Dummy", JsNetworkRequestReceivedCacheControlNoStoreResource: "JsNetworkRequestReceivedCacheControlNoStoreResource", WebRTCUsedWithCCNS: "WebRTCUsedWithCCNS", WebTransportUsedWithCCNS: "WebTransportUsedWithCCNS", WebSocketUsedWithCCNS: "WebSocketUsedWithCCNS", SmartCard: "SmartCard", LiveMediaStreamTrack: "LiveMediaStreamTrack", UnloadHandler: "UnloadHandler", ParserAborted: "ParserAborted", ContentSecurityHandler: "ContentSecurityHandler", ContentWebAuthenticationAPI: "ContentWebAuthenticationAPI", ContentFileChooser: "ContentFileChooser", ContentSerial: "ContentSerial", ContentFileSystemAccess: "ContentFileSystemAccess", ContentMediaDevicesDispatcherHost: "ContentMediaDevicesDispatcherHost", ContentWebBluetooth: "ContentWebBluetooth", ContentWebUSB: "ContentWebUSB", ContentMediaSessionService: "ContentMediaSessionService", ContentScreenReader: "ContentScreenReader", ContentDiscarded: "ContentDiscarded", EmbedderPopupBlockerTabHelper: "EmbedderPopupBlockerTabHelper", EmbedderSafeBrowsingTriggeredPopupBlocker: "EmbedderSafeBrowsingTriggeredPopupBlocker", EmbedderSafeBrowsingThreatDetails: "EmbedderSafeBrowsingThreatDetails", EmbedderAppBannerManager: "EmbedderAppBannerManager", EmbedderDomDistillerViewerSource: "EmbedderDomDistillerViewerSource", EmbedderDomDistillerSelfDeletingRequestDelegate: "EmbedderDomDistillerSelfDeletingRequestDelegate", EmbedderOomInterventionTabHelper: "EmbedderOomInterventionTabHelper", EmbedderOfflinePage: "EmbedderOfflinePage", EmbedderChromePasswordManagerClientBindCredentialManager: "EmbedderChromePasswordManagerClientBindCredentialManager", EmbedderPermissionRequestManager: "EmbedderPermissionRequestManager", EmbedderModalDialog: "EmbedderModalDialog", EmbedderExtensions: "EmbedderExtensions", EmbedderExtensionMessaging: "EmbedderExtensionMessaging", EmbedderExtensionMessagingForOpenPort: "EmbedderExtensionMessagingForOpenPort", EmbedderExtensionSentMessageToCachedFrame: "EmbedderExtensionSentMessageToCachedFrame", RequestedByWebViewClient: "RequestedByWebViewClient", PostMessageByWebViewClient: "PostMessageByWebViewClient", CacheControlNoStoreDeviceBoundSessionTerminated: "CacheControlNoStoreDeviceBoundSessionTerminated", CacheLimitPrunedOnModerateMemoryPressure: "CacheLimitPrunedOnModerateMemoryPressure", CacheLimitPrunedOnCriticalMemoryPressure: "CacheLimitPrunedOnCriticalMemoryPressure" });
    inspectorBackend.registerEnum("Page.BackForwardCacheNotRestoredReasonType", { SupportPending: "SupportPending", PageSupportNeeded: "PageSupportNeeded", Circumstantial: "Circumstantial" });
    inspectorBackend.registerEvent("Page.domContentEventFired", ["timestamp"]);
    inspectorBackend.registerEnum("Page.FileChooserOpenedEventMode", { SelectSingle: "selectSingle", SelectMultiple: "selectMultiple" });
    inspectorBackend.registerEvent("Page.fileChooserOpened", ["frameId", "mode", "backendNodeId"]);
    inspectorBackend.registerEvent("Page.frameAttached", ["frameId", "parentFrameId", "stack"]);
    inspectorBackend.registerEvent("Page.frameClearedScheduledNavigation", ["frameId"]);
    inspectorBackend.registerEnum("Page.FrameDetachedEventReason", { Remove: "remove", Swap: "swap" });
    inspectorBackend.registerEvent("Page.frameDetached", ["frameId", "reason"]);
    inspectorBackend.registerEvent("Page.frameSubtreeWillBeDetached", ["frameId"]);
    inspectorBackend.registerEvent("Page.frameNavigated", ["frame", "type"]);
    inspectorBackend.registerEvent("Page.documentOpened", ["frame"]);
    inspectorBackend.registerEvent("Page.frameResized", []);
    inspectorBackend.registerEnum("Page.FrameStartedNavigatingEventNavigationType", { Reload: "reload", ReloadBypassingCache: "reloadBypassingCache", Restore: "restore", RestoreWithPost: "restoreWithPost", HistorySameDocument: "historySameDocument", HistoryDifferentDocument: "historyDifferentDocument", SameDocument: "sameDocument", DifferentDocument: "differentDocument" });
    inspectorBackend.registerEvent("Page.frameStartedNavigating", ["frameId", "url", "loaderId", "navigationType"]);
    inspectorBackend.registerEvent("Page.frameRequestedNavigation", ["frameId", "reason", "url", "disposition"]);
    inspectorBackend.registerEvent("Page.frameScheduledNavigation", ["frameId", "delay", "reason", "url"]);
    inspectorBackend.registerEvent("Page.frameStartedLoading", ["frameId"]);
    inspectorBackend.registerEvent("Page.frameStoppedLoading", ["frameId"]);
    inspectorBackend.registerEvent("Page.downloadWillBegin", ["frameId", "guid", "url", "suggestedFilename"]);
    inspectorBackend.registerEnum("Page.DownloadProgressEventState", { InProgress: "inProgress", Completed: "completed", Canceled: "canceled" });
    inspectorBackend.registerEvent("Page.downloadProgress", ["guid", "totalBytes", "receivedBytes", "state"]);
    inspectorBackend.registerEvent("Page.interstitialHidden", []);
    inspectorBackend.registerEvent("Page.interstitialShown", []);
    inspectorBackend.registerEvent("Page.javascriptDialogClosed", ["frameId", "result", "userInput"]);
    inspectorBackend.registerEvent("Page.javascriptDialogOpening", ["url", "frameId", "message", "type", "hasBrowserHandler", "defaultPrompt"]);
    inspectorBackend.registerEvent("Page.lifecycleEvent", ["frameId", "loaderId", "name", "timestamp"]);
    inspectorBackend.registerEvent("Page.backForwardCacheNotUsed", ["loaderId", "frameId", "notRestoredExplanations", "notRestoredExplanationsTree"]);
    inspectorBackend.registerEvent("Page.loadEventFired", ["timestamp"]);
    inspectorBackend.registerEnum("Page.NavigatedWithinDocumentEventNavigationType", { Fragment: "fragment", HistoryAPI: "historyApi", Other: "other" });
    inspectorBackend.registerEvent("Page.navigatedWithinDocument", ["frameId", "url", "navigationType"]);
    inspectorBackend.registerEvent("Page.screencastFrame", ["data", "metadata", "sessionId"]);
    inspectorBackend.registerEvent("Page.screencastVisibilityChanged", ["visible"]);
    inspectorBackend.registerEvent("Page.windowOpen", ["url", "windowName", "windowFeatures", "userGesture"]);
    inspectorBackend.registerEvent("Page.compilationCacheProduced", ["url", "data"]);
    inspectorBackend.registerCommand("Page.addScriptToEvaluateOnLoad", [{ "name": "scriptSource", "type": "string", "optional": false, "description": "", "typeRef": null }], ["identifier"], "Deprecated, please use addScriptToEvaluateOnNewDocument instead.");
    inspectorBackend.registerCommand("Page.addScriptToEvaluateOnNewDocument", [{ "name": "source", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "worldName", "type": "string", "optional": true, "description": "If specified, creates an isolated world with the given name and evaluates given script in it. This world name will be used as the ExecutionContextDescription::name when the corresponding event is emitted.", "typeRef": null }, { "name": "includeCommandLineAPI", "type": "boolean", "optional": true, "description": "Specifies whether command line API should be available to the script, defaults to false.", "typeRef": null }, { "name": "runImmediately", "type": "boolean", "optional": true, "description": "If true, runs the script immediately on existing execution contexts or worlds. Default: false.", "typeRef": null }], ["identifier"], "Evaluates given script in every frame upon creation (before loading frame's scripts).");
    inspectorBackend.registerCommand("Page.bringToFront", [], [], "Brings page to front (activates tab).");
    inspectorBackend.registerEnum("Page.CaptureScreenshotRequestFormat", { Jpeg: "jpeg", Png: "png", Webp: "webp" });
    inspectorBackend.registerCommand("Page.captureScreenshot", [{ "name": "format", "type": "string", "optional": true, "description": "Image compression format (defaults to png).", "typeRef": "Page.CaptureScreenshotRequestFormat" }, { "name": "quality", "type": "number", "optional": true, "description": "Compression quality from range [0..100] (jpeg only).", "typeRef": null }, { "name": "clip", "type": "object", "optional": true, "description": "Capture the screenshot of a given region only.", "typeRef": "Page.Viewport" }, { "name": "fromSurface", "type": "boolean", "optional": true, "description": "Capture the screenshot from the surface, rather than the view. Defaults to true.", "typeRef": null }, { "name": "captureBeyondViewport", "type": "boolean", "optional": true, "description": "Capture the screenshot beyond the viewport. Defaults to false.", "typeRef": null }, { "name": "optimizeForSpeed", "type": "boolean", "optional": true, "description": "Optimize image encoding for speed, not for resulting size (defaults to false)", "typeRef": null }], ["data"], "Capture page screenshot.");
    inspectorBackend.registerEnum("Page.CaptureSnapshotRequestFormat", { MHTML: "mhtml" });
    inspectorBackend.registerCommand("Page.captureSnapshot", [{ "name": "format", "type": "string", "optional": true, "description": "Format (defaults to mhtml).", "typeRef": "Page.CaptureSnapshotRequestFormat" }], ["data"], "Returns a snapshot of the page as a string. For MHTML format, the serialization includes iframes, shadow DOM, external resources, and element-inline styles.");
    inspectorBackend.registerCommand("Page.clearDeviceMetricsOverride", [], [], "Clears the overridden device metrics.");
    inspectorBackend.registerCommand("Page.clearDeviceOrientationOverride", [], [], "Clears the overridden Device Orientation.");
    inspectorBackend.registerCommand("Page.clearGeolocationOverride", [], [], "Clears the overridden Geolocation Position and Error.");
    inspectorBackend.registerCommand("Page.createIsolatedWorld", [{ "name": "frameId", "type": "string", "optional": false, "description": "Id of the frame in which the isolated world should be created.", "typeRef": "Page.FrameId" }, { "name": "worldName", "type": "string", "optional": true, "description": "An optional name which is reported in the Execution Context.", "typeRef": null }, { "name": "grantUniveralAccess", "type": "boolean", "optional": true, "description": "Whether or not universal access should be granted to the isolated world. This is a powerful option, use with caution.", "typeRef": null }], ["executionContextId"], "Creates an isolated world for the given frame.");
    inspectorBackend.registerCommand("Page.deleteCookie", [{ "name": "cookieName", "type": "string", "optional": false, "description": "Name of the cookie to remove.", "typeRef": null }, { "name": "url", "type": "string", "optional": false, "description": "URL to match cooke domain and path.", "typeRef": null }], [], "Deletes browser cookie with given name, domain and path.");
    inspectorBackend.registerCommand("Page.disable", [], [], "Disables page domain notifications.");
    inspectorBackend.registerCommand("Page.enable", [{ "name": "enableFileChooserOpenedEvent", "type": "boolean", "optional": true, "description": "If true, the `Page.fileChooserOpened` event will be emitted regardless of the state set by `Page.setInterceptFileChooserDialog` command (default: false).", "typeRef": null }], [], "Enables page domain notifications.");
    inspectorBackend.registerCommand("Page.getAppManifest", [{ "name": "manifestId", "type": "string", "optional": true, "description": "", "typeRef": null }], ["url", "errors", "data", "parsed", "manifest"], "Gets the processed manifest for this current document.   This API always waits for the manifest to be loaded.   If manifestId is provided, and it does not match the manifest of the     current document, this API errors out.   If there is not a loaded page, this API errors out immediately.");
    inspectorBackend.registerCommand("Page.getInstallabilityErrors", [], ["installabilityErrors"], "");
    inspectorBackend.registerCommand("Page.getManifestIcons", [], ["primaryIcon"], "Deprecated because it's not guaranteed that the returned icon is in fact the one used for PWA installation.");
    inspectorBackend.registerCommand("Page.getAppId", [], ["appId", "recommendedId"], "Returns the unique (PWA) app id. Only returns values if the feature flag 'WebAppEnableManifestId' is enabled");
    inspectorBackend.registerCommand("Page.getAdScriptAncestry", [{ "name": "frameId", "type": "string", "optional": false, "description": "", "typeRef": "Page.FrameId" }], ["adScriptAncestry"], "");
    inspectorBackend.registerCommand("Page.getFrameTree", [], ["frameTree"], "Returns present frame tree structure.");
    inspectorBackend.registerCommand("Page.getLayoutMetrics", [], ["layoutViewport", "visualViewport", "contentSize", "cssLayoutViewport", "cssVisualViewport", "cssContentSize"], "Returns metrics relating to the layouting of the page, such as viewport bounds/scale.");
    inspectorBackend.registerCommand("Page.getNavigationHistory", [], ["currentIndex", "entries"], "Returns navigation history for the current page.");
    inspectorBackend.registerCommand("Page.resetNavigationHistory", [], [], "Resets navigation history for the current page.");
    inspectorBackend.registerCommand("Page.getResourceContent", [{ "name": "frameId", "type": "string", "optional": false, "description": "Frame id to get resource for.", "typeRef": "Page.FrameId" }, { "name": "url", "type": "string", "optional": false, "description": "URL of the resource to get content for.", "typeRef": null }], ["content", "base64Encoded"], "Returns content of the given resource.");
    inspectorBackend.registerCommand("Page.getResourceTree", [], ["frameTree"], "Returns present frame / resource tree structure.");
    inspectorBackend.registerCommand("Page.handleJavaScriptDialog", [{ "name": "accept", "type": "boolean", "optional": false, "description": "Whether to accept or dismiss the dialog.", "typeRef": null }, { "name": "promptText", "type": "string", "optional": true, "description": "The text to enter into the dialog prompt before accepting. Used only if this is a prompt dialog.", "typeRef": null }], [], "Accepts or dismisses a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload).");
    inspectorBackend.registerCommand("Page.navigate", [{ "name": "url", "type": "string", "optional": false, "description": "URL to navigate the page to.", "typeRef": null }, { "name": "referrer", "type": "string", "optional": true, "description": "Referrer URL.", "typeRef": null }, { "name": "transitionType", "type": "string", "optional": true, "description": "Intended transition type.", "typeRef": "Page.TransitionType" }, { "name": "frameId", "type": "string", "optional": true, "description": "Frame id to navigate, if not specified navigates the top frame.", "typeRef": "Page.FrameId" }, { "name": "referrerPolicy", "type": "string", "optional": true, "description": "Referrer-policy used for the navigation.", "typeRef": "Page.ReferrerPolicy" }], ["frameId", "loaderId", "errorText", "isDownload"], "Navigates current page to the given URL.");
    inspectorBackend.registerCommand("Page.navigateToHistoryEntry", [{ "name": "entryId", "type": "number", "optional": false, "description": "Unique id of the entry to navigate to.", "typeRef": null }], [], "Navigates current page to the given history entry.");
    inspectorBackend.registerEnum("Page.PrintToPDFRequestTransferMode", { ReturnAsBase64: "ReturnAsBase64", ReturnAsStream: "ReturnAsStream" });
    inspectorBackend.registerCommand("Page.printToPDF", [{ "name": "landscape", "type": "boolean", "optional": true, "description": "Paper orientation. Defaults to false.", "typeRef": null }, { "name": "displayHeaderFooter", "type": "boolean", "optional": true, "description": "Display header and footer. Defaults to false.", "typeRef": null }, { "name": "printBackground", "type": "boolean", "optional": true, "description": "Print background graphics. Defaults to false.", "typeRef": null }, { "name": "scale", "type": "number", "optional": true, "description": "Scale of the webpage rendering. Defaults to 1.", "typeRef": null }, { "name": "paperWidth", "type": "number", "optional": true, "description": "Paper width in inches. Defaults to 8.5 inches.", "typeRef": null }, { "name": "paperHeight", "type": "number", "optional": true, "description": "Paper height in inches. Defaults to 11 inches.", "typeRef": null }, { "name": "marginTop", "type": "number", "optional": true, "description": "Top margin in inches. Defaults to 1cm (~0.4 inches).", "typeRef": null }, { "name": "marginBottom", "type": "number", "optional": true, "description": "Bottom margin in inches. Defaults to 1cm (~0.4 inches).", "typeRef": null }, { "name": "marginLeft", "type": "number", "optional": true, "description": "Left margin in inches. Defaults to 1cm (~0.4 inches).", "typeRef": null }, { "name": "marginRight", "type": "number", "optional": true, "description": "Right margin in inches. Defaults to 1cm (~0.4 inches).", "typeRef": null }, { "name": "pageRanges", "type": "string", "optional": true, "description": "Paper ranges to print, one based, e.g., '1-5, 8, 11-13'. Pages are printed in the document order, not in the order specified, and no more than once. Defaults to empty string, which implies the entire document is printed. The page numbers are quietly capped to actual page count of the document, and ranges beyond the end of the document are ignored. If this results in no pages to print, an error is reported. It is an error to specify a range with start greater than end.", "typeRef": null }, { "name": "headerTemplate", "type": "string", "optional": true, "description": "HTML template for the print header. Should be valid HTML markup with following classes used to inject printing values into them: - `date`: formatted print date - `title`: document title - `url`: document location - `pageNumber`: current page number - `totalPages`: total pages in the document  For example, `<span class=title></span>` would generate span containing the title.", "typeRef": null }, { "name": "footerTemplate", "type": "string", "optional": true, "description": "HTML template for the print footer. Should use the same format as the `headerTemplate`.", "typeRef": null }, { "name": "preferCSSPageSize", "type": "boolean", "optional": true, "description": "Whether or not to prefer page size as defined by css. Defaults to false, in which case the content will be scaled to fit the paper size.", "typeRef": null }, { "name": "transferMode", "type": "string", "optional": true, "description": "return as stream", "typeRef": "Page.PrintToPDFRequestTransferMode" }, { "name": "generateTaggedPDF", "type": "boolean", "optional": true, "description": "Whether or not to generate tagged (accessible) PDF. Defaults to embedder choice.", "typeRef": null }, { "name": "generateDocumentOutline", "type": "boolean", "optional": true, "description": "Whether or not to embed the document outline into the PDF.", "typeRef": null }], ["data", "stream"], "Print page as PDF.");
    inspectorBackend.registerCommand("Page.reload", [{ "name": "ignoreCache", "type": "boolean", "optional": true, "description": "If true, browser cache is ignored (as if the user pressed Shift+refresh).", "typeRef": null }, { "name": "scriptToEvaluateOnLoad", "type": "string", "optional": true, "description": "If set, the script will be injected into all frames of the inspected page after reload. Argument will be ignored if reloading dataURL origin.", "typeRef": null }, { "name": "loaderId", "type": "string", "optional": true, "description": "If set, an error will be thrown if the target page's main frame's loader id does not match the provided id. This prevents accidentally reloading an unintended target in case there's a racing navigation.", "typeRef": "Network.LoaderId" }], [], "Reloads given page optionally ignoring the cache.");
    inspectorBackend.registerCommand("Page.removeScriptToEvaluateOnLoad", [{ "name": "identifier", "type": "string", "optional": false, "description": "", "typeRef": "Page.ScriptIdentifier" }], [], "Deprecated, please use removeScriptToEvaluateOnNewDocument instead.");
    inspectorBackend.registerCommand("Page.removeScriptToEvaluateOnNewDocument", [{ "name": "identifier", "type": "string", "optional": false, "description": "", "typeRef": "Page.ScriptIdentifier" }], [], "Removes given script from the list.");
    inspectorBackend.registerCommand("Page.screencastFrameAck", [{ "name": "sessionId", "type": "number", "optional": false, "description": "Frame number.", "typeRef": null }], [], "Acknowledges that a screencast frame has been received by the frontend.");
    inspectorBackend.registerCommand("Page.searchInResource", [{ "name": "frameId", "type": "string", "optional": false, "description": "Frame id for resource to search in.", "typeRef": "Page.FrameId" }, { "name": "url", "type": "string", "optional": false, "description": "URL of the resource to search in.", "typeRef": null }, { "name": "query", "type": "string", "optional": false, "description": "String to search for.", "typeRef": null }, { "name": "caseSensitive", "type": "boolean", "optional": true, "description": "If true, search is case sensitive.", "typeRef": null }, { "name": "isRegex", "type": "boolean", "optional": true, "description": "If true, treats string parameter as regex.", "typeRef": null }], ["result"], "Searches for given string in resource content.");
    inspectorBackend.registerCommand("Page.setAdBlockingEnabled", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "Whether to block ads.", "typeRef": null }], [], "Enable Chrome's experimental ad filter on all sites.");
    inspectorBackend.registerCommand("Page.setBypassCSP", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "Whether to bypass page CSP.", "typeRef": null }], [], "Enable page Content Security Policy by-passing.");
    inspectorBackend.registerCommand("Page.getPermissionsPolicyState", [{ "name": "frameId", "type": "string", "optional": false, "description": "", "typeRef": "Page.FrameId" }], ["states"], "Get Permissions Policy state on given frame.");
    inspectorBackend.registerCommand("Page.getOriginTrials", [{ "name": "frameId", "type": "string", "optional": false, "description": "", "typeRef": "Page.FrameId" }], ["originTrials"], "Get Origin Trials on given frame.");
    inspectorBackend.registerCommand("Page.setDeviceMetricsOverride", [{ "name": "width", "type": "number", "optional": false, "description": "Overriding width value in pixels (minimum 0, maximum 10000000). 0 disables the override.", "typeRef": null }, { "name": "height", "type": "number", "optional": false, "description": "Overriding height value in pixels (minimum 0, maximum 10000000). 0 disables the override.", "typeRef": null }, { "name": "deviceScaleFactor", "type": "number", "optional": false, "description": "Overriding device scale factor value. 0 disables the override.", "typeRef": null }, { "name": "mobile", "type": "boolean", "optional": false, "description": "Whether to emulate mobile device. This includes viewport meta tag, overlay scrollbars, text autosizing and more.", "typeRef": null }, { "name": "scale", "type": "number", "optional": true, "description": "Scale to apply to resulting view image.", "typeRef": null }, { "name": "screenWidth", "type": "number", "optional": true, "description": "Overriding screen width value in pixels (minimum 0, maximum 10000000).", "typeRef": null }, { "name": "screenHeight", "type": "number", "optional": true, "description": "Overriding screen height value in pixels (minimum 0, maximum 10000000).", "typeRef": null }, { "name": "positionX", "type": "number", "optional": true, "description": "Overriding view X position on screen in pixels (minimum 0, maximum 10000000).", "typeRef": null }, { "name": "positionY", "type": "number", "optional": true, "description": "Overriding view Y position on screen in pixels (minimum 0, maximum 10000000).", "typeRef": null }, { "name": "dontSetVisibleSize", "type": "boolean", "optional": true, "description": "Do not set visible view size, rely upon explicit setVisibleSize call.", "typeRef": null }, { "name": "screenOrientation", "type": "object", "optional": true, "description": "Screen orientation override.", "typeRef": "Emulation.ScreenOrientation" }, { "name": "viewport", "type": "object", "optional": true, "description": "The viewport dimensions and scale. If not set, the override is cleared.", "typeRef": "Page.Viewport" }], [], "Overrides the values of device screen dimensions (window.screen.width, window.screen.height, window.innerWidth, window.innerHeight, and \"device-width\"/\"device-height\"-related CSS media query results).");
    inspectorBackend.registerCommand("Page.setDeviceOrientationOverride", [{ "name": "alpha", "type": "number", "optional": false, "description": "Mock alpha", "typeRef": null }, { "name": "beta", "type": "number", "optional": false, "description": "Mock beta", "typeRef": null }, { "name": "gamma", "type": "number", "optional": false, "description": "Mock gamma", "typeRef": null }], [], "Overrides the Device Orientation.");
    inspectorBackend.registerCommand("Page.setFontFamilies", [{ "name": "fontFamilies", "type": "object", "optional": false, "description": "Specifies font families to set. If a font family is not specified, it won't be changed.", "typeRef": "Page.FontFamilies" }, { "name": "forScripts", "type": "array", "optional": true, "description": "Specifies font families to set for individual scripts.", "typeRef": "Page.ScriptFontFamilies" }], [], "Set generic font families.");
    inspectorBackend.registerCommand("Page.setFontSizes", [{ "name": "fontSizes", "type": "object", "optional": false, "description": "Specifies font sizes to set. If a font size is not specified, it won't be changed.", "typeRef": "Page.FontSizes" }], [], "Set default font sizes.");
    inspectorBackend.registerCommand("Page.setDocumentContent", [{ "name": "frameId", "type": "string", "optional": false, "description": "Frame id to set HTML for.", "typeRef": "Page.FrameId" }, { "name": "html", "type": "string", "optional": false, "description": "HTML content to set.", "typeRef": null }], [], "Sets given markup as the document's HTML.");
    inspectorBackend.registerEnum("Page.SetDownloadBehaviorRequestBehavior", { Deny: "deny", Allow: "allow", Default: "default" });
    inspectorBackend.registerCommand("Page.setDownloadBehavior", [{ "name": "behavior", "type": "string", "optional": false, "description": "Whether to allow all or deny all download requests, or use default Chrome behavior if available (otherwise deny).", "typeRef": "Page.SetDownloadBehaviorRequestBehavior" }, { "name": "downloadPath", "type": "string", "optional": true, "description": "The default path to save downloaded files to. This is required if behavior is set to 'allow'", "typeRef": null }], [], "Set the behavior when downloading a file.");
    inspectorBackend.registerCommand("Page.setGeolocationOverride", [{ "name": "latitude", "type": "number", "optional": true, "description": "Mock latitude", "typeRef": null }, { "name": "longitude", "type": "number", "optional": true, "description": "Mock longitude", "typeRef": null }, { "name": "accuracy", "type": "number", "optional": true, "description": "Mock accuracy", "typeRef": null }], [], "Overrides the Geolocation Position or Error. Omitting any of the parameters emulates position unavailable.");
    inspectorBackend.registerCommand("Page.setLifecycleEventsEnabled", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "If true, starts emitting lifecycle events.", "typeRef": null }], [], "Controls whether page will emit lifecycle events.");
    inspectorBackend.registerEnum("Page.SetTouchEmulationEnabledRequestConfiguration", { Mobile: "mobile", Desktop: "desktop" });
    inspectorBackend.registerCommand("Page.setTouchEmulationEnabled", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "Whether the touch event emulation should be enabled.", "typeRef": null }, { "name": "configuration", "type": "string", "optional": true, "description": "Touch/gesture events configuration. Default: current platform.", "typeRef": "Page.SetTouchEmulationEnabledRequestConfiguration" }], [], "Toggles mouse event-based touch event emulation.");
    inspectorBackend.registerEnum("Page.StartScreencastRequestFormat", { Jpeg: "jpeg", Png: "png" });
    inspectorBackend.registerCommand("Page.startScreencast", [{ "name": "format", "type": "string", "optional": true, "description": "Image compression format.", "typeRef": "Page.StartScreencastRequestFormat" }, { "name": "quality", "type": "number", "optional": true, "description": "Compression quality from range [0..100].", "typeRef": null }, { "name": "maxWidth", "type": "number", "optional": true, "description": "Maximum screenshot width.", "typeRef": null }, { "name": "maxHeight", "type": "number", "optional": true, "description": "Maximum screenshot height.", "typeRef": null }, { "name": "everyNthFrame", "type": "number", "optional": true, "description": "Send every n-th frame.", "typeRef": null }], [], "Starts sending each frame using the `screencastFrame` event.");
    inspectorBackend.registerCommand("Page.stopLoading", [], [], "Force the page stop all navigations and pending resource fetches.");
    inspectorBackend.registerCommand("Page.crash", [], [], "Crashes renderer on the IO thread, generates minidumps.");
    inspectorBackend.registerCommand("Page.close", [], [], "Tries to close page, running its beforeunload hooks, if any.");
    inspectorBackend.registerEnum("Page.SetWebLifecycleStateRequestState", { Frozen: "frozen", Active: "active" });
    inspectorBackend.registerCommand("Page.setWebLifecycleState", [{ "name": "state", "type": "string", "optional": false, "description": "Target lifecycle state", "typeRef": "Page.SetWebLifecycleStateRequestState" }], [], "Tries to update the web lifecycle state of the page. It will transition the page to the given state according to: https://github.com/WICG/web-lifecycle/");
    inspectorBackend.registerCommand("Page.stopScreencast", [], [], "Stops sending each frame in the `screencastFrame`.");
    inspectorBackend.registerCommand("Page.produceCompilationCache", [{ "name": "scripts", "type": "array", "optional": false, "description": "", "typeRef": "Page.CompilationCacheParams" }], [], "Requests backend to produce compilation cache for the specified scripts. `scripts` are appended to the list of scripts for which the cache would be produced. The list may be reset during page navigation. When script with a matching URL is encountered, the cache is optionally produced upon backend discretion, based on internal heuristics. See also: `Page.compilationCacheProduced`.");
    inspectorBackend.registerCommand("Page.addCompilationCache", [{ "name": "url", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "data", "type": "string", "optional": false, "description": "Base64-encoded data", "typeRef": null }], [], "Seeds compilation cache for given url. Compilation cache does not survive cross-process navigation.");
    inspectorBackend.registerCommand("Page.clearCompilationCache", [], [], "Clears seeded compilation cache.");
    inspectorBackend.registerEnum("Page.SetSPCTransactionModeRequestMode", { None: "none", AutoAccept: "autoAccept", AutoChooseToAuthAnotherWay: "autoChooseToAuthAnotherWay", AutoReject: "autoReject", AutoOptOut: "autoOptOut" });
    inspectorBackend.registerCommand("Page.setSPCTransactionMode", [{ "name": "mode", "type": "string", "optional": false, "description": "", "typeRef": "Page.SetSPCTransactionModeRequestMode" }], [], "Sets the Secure Payment Confirmation transaction mode. https://w3c.github.io/secure-payment-confirmation/#sctn-automation-set-spc-transaction-mode");
    inspectorBackend.registerEnum("Page.SetRPHRegistrationModeRequestMode", { None: "none", AutoAccept: "autoAccept", AutoReject: "autoReject" });
    inspectorBackend.registerCommand("Page.setRPHRegistrationMode", [{ "name": "mode", "type": "string", "optional": false, "description": "", "typeRef": "Page.SetRPHRegistrationModeRequestMode" }], [], "Extensions for Custom Handlers API: https://html.spec.whatwg.org/multipage/system-state.html#rph-automation");
    inspectorBackend.registerCommand("Page.generateTestReport", [{ "name": "message", "type": "string", "optional": false, "description": "Message to be displayed in the report.", "typeRef": null }, { "name": "group", "type": "string", "optional": true, "description": "Specifies the endpoint group to deliver the report to.", "typeRef": null }], [], "Generates a report for testing.");
    inspectorBackend.registerCommand("Page.waitForDebugger", [], [], "Pauses page execution. Can be resumed using generic Runtime.runIfWaitingForDebugger.");
    inspectorBackend.registerCommand("Page.setInterceptFileChooserDialog", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "cancel", "type": "boolean", "optional": true, "description": "If true, cancels the dialog by emitting relevant events (if any) in addition to not showing it if the interception is enabled (default: false).", "typeRef": null }], [], "Intercept file chooser requests and transfer control to protocol clients. When file chooser interception is enabled, native file chooser dialog is not shown. Instead, a protocol event `Page.fileChooserOpened` is emitted.");
    inspectorBackend.registerCommand("Page.setPrerenderingAllowed", [{ "name": "isAllowed", "type": "boolean", "optional": false, "description": "", "typeRef": null }], [], "Enable/disable prerendering manually.  This command is a short-term solution for https://crbug.com/1440085. See https://docs.google.com/document/d/12HVmFxYj5Jc-eJr5OmWsa2bqTJsbgGLKI6ZIyx0_wpA for more details.  TODO(https://crbug.com/1440085): Remove this once Puppeteer supports tab targets.");
    inspectorBackend.registerType("Page.AdFrameStatus", [{ "name": "adFrameType", "type": "string", "optional": false, "description": "", "typeRef": "Page.AdFrameType" }, { "name": "explanations", "type": "array", "optional": true, "description": "", "typeRef": "Page.AdFrameExplanation" }]);
    inspectorBackend.registerType("Page.AdScriptId", [{ "name": "scriptId", "type": "string", "optional": false, "description": "Script Id of the script which caused a script or frame to be labelled as an ad.", "typeRef": "Runtime.ScriptId" }, { "name": "debuggerId", "type": "string", "optional": false, "description": "Id of scriptId's debugger.", "typeRef": "Runtime.UniqueDebuggerId" }]);
    inspectorBackend.registerType("Page.AdScriptAncestry", [{ "name": "ancestryChain", "type": "array", "optional": false, "description": "A chain of `AdScriptId`s representing the ancestry of an ad script that led to the creation of a frame. The chain is ordered from the script itself (lower level) up to its root ancestor that was flagged by filterlist.", "typeRef": "Page.AdScriptId" }, { "name": "rootScriptFilterlistRule", "type": "string", "optional": true, "description": "The filterlist rule that caused the root (last) script in `ancestryChain` to be ad-tagged. Only populated if the rule is available.", "typeRef": null }]);
    inspectorBackend.registerType("Page.PermissionsPolicyBlockLocator", [{ "name": "frameId", "type": "string", "optional": false, "description": "", "typeRef": "Page.FrameId" }, { "name": "blockReason", "type": "string", "optional": false, "description": "", "typeRef": "Page.PermissionsPolicyBlockReason" }]);
    inspectorBackend.registerType("Page.PermissionsPolicyFeatureState", [{ "name": "feature", "type": "string", "optional": false, "description": "", "typeRef": "Page.PermissionsPolicyFeature" }, { "name": "allowed", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "locator", "type": "object", "optional": true, "description": "", "typeRef": "Page.PermissionsPolicyBlockLocator" }]);
    inspectorBackend.registerType("Page.OriginTrialToken", [{ "name": "origin", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "matchSubDomains", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "trialName", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "expiryTime", "type": "number", "optional": false, "description": "", "typeRef": "Network.TimeSinceEpoch" }, { "name": "isThirdParty", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "usageRestriction", "type": "string", "optional": false, "description": "", "typeRef": "Page.OriginTrialUsageRestriction" }]);
    inspectorBackend.registerType("Page.OriginTrialTokenWithStatus", [{ "name": "rawTokenText", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "parsedToken", "type": "object", "optional": true, "description": "`parsedToken` is present only when the token is extractable and parsable.", "typeRef": "Page.OriginTrialToken" }, { "name": "status", "type": "string", "optional": false, "description": "", "typeRef": "Page.OriginTrialTokenStatus" }]);
    inspectorBackend.registerType("Page.OriginTrial", [{ "name": "trialName", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "status", "type": "string", "optional": false, "description": "", "typeRef": "Page.OriginTrialStatus" }, { "name": "tokensWithStatus", "type": "array", "optional": false, "description": "", "typeRef": "Page.OriginTrialTokenWithStatus" }]);
    inspectorBackend.registerType("Page.SecurityOriginDetails", [{ "name": "isLocalhost", "type": "boolean", "optional": false, "description": "Indicates whether the frame document's security origin is one of the local hostnames (e.g. \\\"localhost\\\") or IP addresses (IPv4 127.0.0.0/8 or IPv6 ::1).", "typeRef": null }]);
    inspectorBackend.registerType("Page.Frame", [{ "name": "id", "type": "string", "optional": false, "description": "Frame unique identifier.", "typeRef": "Page.FrameId" }, { "name": "parentId", "type": "string", "optional": true, "description": "Parent frame identifier.", "typeRef": "Page.FrameId" }, { "name": "loaderId", "type": "string", "optional": false, "description": "Identifier of the loader associated with this frame.", "typeRef": "Network.LoaderId" }, { "name": "name", "type": "string", "optional": true, "description": "Frame's name as specified in the tag.", "typeRef": null }, { "name": "url", "type": "string", "optional": false, "description": "Frame document's URL without fragment.", "typeRef": null }, { "name": "urlFragment", "type": "string", "optional": true, "description": "Frame document's URL fragment including the '#'.", "typeRef": null }, { "name": "domainAndRegistry", "type": "string", "optional": false, "description": "Frame document's registered domain, taking the public suffixes list into account. Extracted from the Frame's url. Example URLs: http://www.google.com/file.html -> \\\"google.com\\\"               http://a.b.co.uk/file.html      -> \\\"b.co.uk\\\"", "typeRef": null }, { "name": "securityOrigin", "type": "string", "optional": false, "description": "Frame document's security origin.", "typeRef": null }, { "name": "securityOriginDetails", "type": "object", "optional": true, "description": "Additional details about the frame document's security origin.", "typeRef": "Page.SecurityOriginDetails" }, { "name": "mimeType", "type": "string", "optional": false, "description": "Frame document's mimeType as determined by the browser.", "typeRef": null }, { "name": "unreachableUrl", "type": "string", "optional": true, "description": "If the frame failed to load, this contains the URL that could not be loaded. Note that unlike url above, this URL may contain a fragment.", "typeRef": null }, { "name": "adFrameStatus", "type": "object", "optional": true, "description": "Indicates whether this frame was tagged as an ad and why.", "typeRef": "Page.AdFrameStatus" }, { "name": "secureContextType", "type": "string", "optional": false, "description": "Indicates whether the main document is a secure context and explains why that is the case.", "typeRef": "Page.SecureContextType" }, { "name": "crossOriginIsolatedContextType", "type": "string", "optional": false, "description": "Indicates whether this is a cross origin isolated context.", "typeRef": "Page.CrossOriginIsolatedContextType" }, { "name": "gatedAPIFeatures", "type": "array", "optional": false, "description": "Indicated which gated APIs / features are available.", "typeRef": "Page.GatedAPIFeatures" }]);
    inspectorBackend.registerType("Page.FrameResource", [{ "name": "url", "type": "string", "optional": false, "description": "Resource URL.", "typeRef": null }, { "name": "type", "type": "string", "optional": false, "description": "Type of this resource.", "typeRef": "Network.ResourceType" }, { "name": "mimeType", "type": "string", "optional": false, "description": "Resource mimeType as determined by the browser.", "typeRef": null }, { "name": "lastModified", "type": "number", "optional": true, "description": "last-modified timestamp as reported by server.", "typeRef": "Network.TimeSinceEpoch" }, { "name": "contentSize", "type": "number", "optional": true, "description": "Resource content size.", "typeRef": null }, { "name": "failed", "type": "boolean", "optional": true, "description": "True if the resource failed to load.", "typeRef": null }, { "name": "canceled", "type": "boolean", "optional": true, "description": "True if the resource was canceled during loading.", "typeRef": null }]);
    inspectorBackend.registerType("Page.FrameResourceTree", [{ "name": "frame", "type": "object", "optional": false, "description": "Frame information for this tree item.", "typeRef": "Page.Frame" }, { "name": "childFrames", "type": "array", "optional": true, "description": "Child frames.", "typeRef": "Page.FrameResourceTree" }, { "name": "resources", "type": "array", "optional": false, "description": "Information about frame resources.", "typeRef": "Page.FrameResource" }]);
    inspectorBackend.registerType("Page.FrameTree", [{ "name": "frame", "type": "object", "optional": false, "description": "Frame information for this tree item.", "typeRef": "Page.Frame" }, { "name": "childFrames", "type": "array", "optional": true, "description": "Child frames.", "typeRef": "Page.FrameTree" }]);
    inspectorBackend.registerType("Page.NavigationEntry", [{ "name": "id", "type": "number", "optional": false, "description": "Unique id of the navigation history entry.", "typeRef": null }, { "name": "url", "type": "string", "optional": false, "description": "URL of the navigation history entry.", "typeRef": null }, { "name": "userTypedURL", "type": "string", "optional": false, "description": "URL that the user typed in the url bar.", "typeRef": null }, { "name": "title", "type": "string", "optional": false, "description": "Title of the navigation history entry.", "typeRef": null }, { "name": "transitionType", "type": "string", "optional": false, "description": "Transition type.", "typeRef": "Page.TransitionType" }]);
    inspectorBackend.registerType("Page.ScreencastFrameMetadata", [{ "name": "offsetTop", "type": "number", "optional": false, "description": "Top offset in DIP.", "typeRef": null }, { "name": "pageScaleFactor", "type": "number", "optional": false, "description": "Page scale factor.", "typeRef": null }, { "name": "deviceWidth", "type": "number", "optional": false, "description": "Device screen width in DIP.", "typeRef": null }, { "name": "deviceHeight", "type": "number", "optional": false, "description": "Device screen height in DIP.", "typeRef": null }, { "name": "scrollOffsetX", "type": "number", "optional": false, "description": "Position of horizontal scroll in CSS pixels.", "typeRef": null }, { "name": "scrollOffsetY", "type": "number", "optional": false, "description": "Position of vertical scroll in CSS pixels.", "typeRef": null }, { "name": "timestamp", "type": "number", "optional": true, "description": "Frame swap timestamp.", "typeRef": "Network.TimeSinceEpoch" }]);
    inspectorBackend.registerType("Page.AppManifestError", [{ "name": "message", "type": "string", "optional": false, "description": "Error message.", "typeRef": null }, { "name": "critical", "type": "number", "optional": false, "description": "If critical, this is a non-recoverable parse error.", "typeRef": null }, { "name": "line", "type": "number", "optional": false, "description": "Error line.", "typeRef": null }, { "name": "column", "type": "number", "optional": false, "description": "Error column.", "typeRef": null }]);
    inspectorBackend.registerType("Page.AppManifestParsedProperties", [{ "name": "scope", "type": "string", "optional": false, "description": "Computed scope value", "typeRef": null }]);
    inspectorBackend.registerType("Page.LayoutViewport", [{ "name": "pageX", "type": "number", "optional": false, "description": "Horizontal offset relative to the document (CSS pixels).", "typeRef": null }, { "name": "pageY", "type": "number", "optional": false, "description": "Vertical offset relative to the document (CSS pixels).", "typeRef": null }, { "name": "clientWidth", "type": "number", "optional": false, "description": "Width (CSS pixels), excludes scrollbar if present.", "typeRef": null }, { "name": "clientHeight", "type": "number", "optional": false, "description": "Height (CSS pixels), excludes scrollbar if present.", "typeRef": null }]);
    inspectorBackend.registerType("Page.VisualViewport", [{ "name": "offsetX", "type": "number", "optional": false, "description": "Horizontal offset relative to the layout viewport (CSS pixels).", "typeRef": null }, { "name": "offsetY", "type": "number", "optional": false, "description": "Vertical offset relative to the layout viewport (CSS pixels).", "typeRef": null }, { "name": "pageX", "type": "number", "optional": false, "description": "Horizontal offset relative to the document (CSS pixels).", "typeRef": null }, { "name": "pageY", "type": "number", "optional": false, "description": "Vertical offset relative to the document (CSS pixels).", "typeRef": null }, { "name": "clientWidth", "type": "number", "optional": false, "description": "Width (CSS pixels), excludes scrollbar if present.", "typeRef": null }, { "name": "clientHeight", "type": "number", "optional": false, "description": "Height (CSS pixels), excludes scrollbar if present.", "typeRef": null }, { "name": "scale", "type": "number", "optional": false, "description": "Scale relative to the ideal viewport (size at width=device-width).", "typeRef": null }, { "name": "zoom", "type": "number", "optional": true, "description": "Page zoom factor (CSS to device independent pixels ratio).", "typeRef": null }]);
    inspectorBackend.registerType("Page.Viewport", [{ "name": "x", "type": "number", "optional": false, "description": "X offset in device independent pixels (dip).", "typeRef": null }, { "name": "y", "type": "number", "optional": false, "description": "Y offset in device independent pixels (dip).", "typeRef": null }, { "name": "width", "type": "number", "optional": false, "description": "Rectangle width in device independent pixels (dip).", "typeRef": null }, { "name": "height", "type": "number", "optional": false, "description": "Rectangle height in device independent pixels (dip).", "typeRef": null }, { "name": "scale", "type": "number", "optional": false, "description": "Page scale factor.", "typeRef": null }]);
    inspectorBackend.registerType("Page.FontFamilies", [{ "name": "standard", "type": "string", "optional": true, "description": "The standard font-family.", "typeRef": null }, { "name": "fixed", "type": "string", "optional": true, "description": "The fixed font-family.", "typeRef": null }, { "name": "serif", "type": "string", "optional": true, "description": "The serif font-family.", "typeRef": null }, { "name": "sansSerif", "type": "string", "optional": true, "description": "The sansSerif font-family.", "typeRef": null }, { "name": "cursive", "type": "string", "optional": true, "description": "The cursive font-family.", "typeRef": null }, { "name": "fantasy", "type": "string", "optional": true, "description": "The fantasy font-family.", "typeRef": null }, { "name": "math", "type": "string", "optional": true, "description": "The math font-family.", "typeRef": null }]);
    inspectorBackend.registerType("Page.ScriptFontFamilies", [{ "name": "script", "type": "string", "optional": false, "description": "Name of the script which these font families are defined for.", "typeRef": null }, { "name": "fontFamilies", "type": "object", "optional": false, "description": "Generic font families collection for the script.", "typeRef": "Page.FontFamilies" }]);
    inspectorBackend.registerType("Page.FontSizes", [{ "name": "standard", "type": "number", "optional": true, "description": "Default standard font size.", "typeRef": null }, { "name": "fixed", "type": "number", "optional": true, "description": "Default fixed font size.", "typeRef": null }]);
    inspectorBackend.registerType("Page.InstallabilityErrorArgument", [{ "name": "name", "type": "string", "optional": false, "description": "Argument name (e.g. name:'minimum-icon-size-in-pixels').", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "Argument value (e.g. value:'64').", "typeRef": null }]);
    inspectorBackend.registerType("Page.InstallabilityError", [{ "name": "errorId", "type": "string", "optional": false, "description": "The error id (e.g. 'manifest-missing-suitable-icon').", "typeRef": null }, { "name": "errorArguments", "type": "array", "optional": false, "description": "The list of error arguments (e.g. {name:'minimum-icon-size-in-pixels', value:'64'}).", "typeRef": "Page.InstallabilityErrorArgument" }]);
    inspectorBackend.registerType("Page.CompilationCacheParams", [{ "name": "url", "type": "string", "optional": false, "description": "The URL of the script to produce a compilation cache entry for.", "typeRef": null }, { "name": "eager", "type": "boolean", "optional": true, "description": "A hint to the backend whether eager compilation is recommended. (the actual compilation mode used is upon backend discretion).", "typeRef": null }]);
    inspectorBackend.registerType("Page.FileFilter", [{ "name": "name", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "accepts", "type": "array", "optional": true, "description": "", "typeRef": "string" }]);
    inspectorBackend.registerType("Page.FileHandler", [{ "name": "action", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "icons", "type": "array", "optional": true, "description": "", "typeRef": "Page.ImageResource" }, { "name": "accepts", "type": "array", "optional": true, "description": "Mimic a map, name is the key, accepts is the value.", "typeRef": "Page.FileFilter" }, { "name": "launchType", "type": "string", "optional": false, "description": "Won't repeat the enums, using string for easy comparison. Same as the other enums below.", "typeRef": null }]);
    inspectorBackend.registerType("Page.ImageResource", [{ "name": "url", "type": "string", "optional": false, "description": "The src field in the definition, but changing to url in favor of consistency.", "typeRef": null }, { "name": "sizes", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "type", "type": "string", "optional": true, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Page.LaunchHandler", [{ "name": "clientMode", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Page.ProtocolHandler", [{ "name": "protocol", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "url", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Page.RelatedApplication", [{ "name": "id", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "url", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Page.ScopeExtension", [{ "name": "origin", "type": "string", "optional": false, "description": "Instead of using tuple, this field always returns the serialized string for easy understanding and comparison.", "typeRef": null }, { "name": "hasOriginWildcard", "type": "boolean", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Page.Screenshot", [{ "name": "image", "type": "object", "optional": false, "description": "", "typeRef": "Page.ImageResource" }, { "name": "formFactor", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "label", "type": "string", "optional": true, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Page.ShareTarget", [{ "name": "action", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "method", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "enctype", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "title", "type": "string", "optional": true, "description": "Embed the ShareTargetParams", "typeRef": null }, { "name": "text", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "url", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "files", "type": "array", "optional": true, "description": "", "typeRef": "Page.FileFilter" }]);
    inspectorBackend.registerType("Page.Shortcut", [{ "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "url", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Page.WebAppManifest", [{ "name": "backgroundColor", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "description", "type": "string", "optional": true, "description": "The extra description provided by the manifest.", "typeRef": null }, { "name": "dir", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "display", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "displayOverrides", "type": "array", "optional": true, "description": "The overrided display mode controlled by the user.", "typeRef": "string" }, { "name": "fileHandlers", "type": "array", "optional": true, "description": "The handlers to open files.", "typeRef": "Page.FileHandler" }, { "name": "icons", "type": "array", "optional": true, "description": "", "typeRef": "Page.ImageResource" }, { "name": "id", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "lang", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "launchHandler", "type": "object", "optional": true, "description": "TODO(crbug.com/1231886): This field is non-standard and part of a Chrome experiment. See: https://github.com/WICG/web-app-launch/blob/main/launch_handler.md", "typeRef": "Page.LaunchHandler" }, { "name": "name", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "orientation", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "preferRelatedApplications", "type": "boolean", "optional": true, "description": "", "typeRef": null }, { "name": "protocolHandlers", "type": "array", "optional": true, "description": "The handlers to open protocols.", "typeRef": "Page.ProtocolHandler" }, { "name": "relatedApplications", "type": "array", "optional": true, "description": "", "typeRef": "Page.RelatedApplication" }, { "name": "scope", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "scopeExtensions", "type": "array", "optional": true, "description": "Non-standard, see https://github.com/WICG/manifest-incubations/blob/gh-pages/scope_extensions-explainer.md", "typeRef": "Page.ScopeExtension" }, { "name": "screenshots", "type": "array", "optional": true, "description": "The screenshots used by chromium.", "typeRef": "Page.Screenshot" }, { "name": "shareTarget", "type": "object", "optional": true, "description": "", "typeRef": "Page.ShareTarget" }, { "name": "shortName", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "shortcuts", "type": "array", "optional": true, "description": "", "typeRef": "Page.Shortcut" }, { "name": "startUrl", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "themeColor", "type": "string", "optional": true, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Page.BackForwardCacheBlockingDetails", [{ "name": "url", "type": "string", "optional": true, "description": "Url of the file where blockage happened. Optional because of tests.", "typeRef": null }, { "name": "function", "type": "string", "optional": true, "description": "Function name where blockage happened. Optional because of anonymous functions and tests.", "typeRef": null }, { "name": "lineNumber", "type": "number", "optional": false, "description": "Line number in the script (0-based).", "typeRef": null }, { "name": "columnNumber", "type": "number", "optional": false, "description": "Column number in the script (0-based).", "typeRef": null }]);
    inspectorBackend.registerType("Page.BackForwardCacheNotRestoredExplanation", [{ "name": "type", "type": "string", "optional": false, "description": "Type of the reason", "typeRef": "Page.BackForwardCacheNotRestoredReasonType" }, { "name": "reason", "type": "string", "optional": false, "description": "Not restored reason", "typeRef": "Page.BackForwardCacheNotRestoredReason" }, { "name": "context", "type": "string", "optional": true, "description": "Context associated with the reason. The meaning of this context is dependent on the reason: - EmbedderExtensionSentMessageToCachedFrame: the extension ID.", "typeRef": null }, { "name": "details", "type": "array", "optional": true, "description": "", "typeRef": "Page.BackForwardCacheBlockingDetails" }]);
    inspectorBackend.registerType("Page.BackForwardCacheNotRestoredExplanationTree", [{ "name": "url", "type": "string", "optional": false, "description": "URL of each frame", "typeRef": null }, { "name": "explanations", "type": "array", "optional": false, "description": "Not restored reasons of each frame", "typeRef": "Page.BackForwardCacheNotRestoredExplanation" }, { "name": "children", "type": "array", "optional": false, "description": "Array of children frame", "typeRef": "Page.BackForwardCacheNotRestoredExplanationTree" }]);
    // Performance.
    inspectorBackend.registerEvent("Performance.metrics", ["metrics", "title"]);
    inspectorBackend.registerCommand("Performance.disable", [], [], "Disable collecting and reporting metrics.");
    inspectorBackend.registerEnum("Performance.EnableRequestTimeDomain", { TimeTicks: "timeTicks", ThreadTicks: "threadTicks" });
    inspectorBackend.registerCommand("Performance.enable", [{ "name": "timeDomain", "type": "string", "optional": true, "description": "Time domain to use for collecting and reporting duration metrics.", "typeRef": "Performance.EnableRequestTimeDomain" }], [], "Enable collecting and reporting metrics.");
    inspectorBackend.registerEnum("Performance.SetTimeDomainRequestTimeDomain", { TimeTicks: "timeTicks", ThreadTicks: "threadTicks" });
    inspectorBackend.registerCommand("Performance.setTimeDomain", [{ "name": "timeDomain", "type": "string", "optional": false, "description": "Time domain", "typeRef": "Performance.SetTimeDomainRequestTimeDomain" }], [], "Sets time domain to use for collecting and reporting duration metrics. Note that this must be called before enabling metrics collection. Calling this method while metrics collection is enabled returns an error.");
    inspectorBackend.registerCommand("Performance.getMetrics", [], ["metrics"], "Retrieve current values of run-time metrics.");
    inspectorBackend.registerType("Performance.Metric", [{ "name": "name", "type": "string", "optional": false, "description": "Metric name.", "typeRef": null }, { "name": "value", "type": "number", "optional": false, "description": "Metric value.", "typeRef": null }]);
    // PerformanceTimeline.
    inspectorBackend.registerEvent("PerformanceTimeline.timelineEventAdded", ["event"]);
    inspectorBackend.registerCommand("PerformanceTimeline.enable", [{ "name": "eventTypes", "type": "array", "optional": false, "description": "The types of event to report, as specified in https://w3c.github.io/performance-timeline/#dom-performanceentry-entrytype The specified filter overrides any previous filters, passing empty filter disables recording. Note that not all types exposed to the web platform are currently supported.", "typeRef": "string" }], [], "Previously buffered events would be reported before method returns. See also: timelineEventAdded");
    inspectorBackend.registerType("PerformanceTimeline.LargestContentfulPaint", [{ "name": "renderTime", "type": "number", "optional": false, "description": "", "typeRef": "Network.TimeSinceEpoch" }, { "name": "loadTime", "type": "number", "optional": false, "description": "", "typeRef": "Network.TimeSinceEpoch" }, { "name": "size", "type": "number", "optional": false, "description": "The number of pixels being painted.", "typeRef": null }, { "name": "elementId", "type": "string", "optional": true, "description": "The id attribute of the element, if available.", "typeRef": null }, { "name": "url", "type": "string", "optional": true, "description": "The URL of the image (may be trimmed).", "typeRef": null }, { "name": "nodeId", "type": "number", "optional": true, "description": "", "typeRef": "DOM.BackendNodeId" }]);
    inspectorBackend.registerType("PerformanceTimeline.LayoutShiftAttribution", [{ "name": "previousRect", "type": "object", "optional": false, "description": "", "typeRef": "DOM.Rect" }, { "name": "currentRect", "type": "object", "optional": false, "description": "", "typeRef": "DOM.Rect" }, { "name": "nodeId", "type": "number", "optional": true, "description": "", "typeRef": "DOM.BackendNodeId" }]);
    inspectorBackend.registerType("PerformanceTimeline.LayoutShift", [{ "name": "value", "type": "number", "optional": false, "description": "Score increment produced by this event.", "typeRef": null }, { "name": "hadRecentInput", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "lastInputTime", "type": "number", "optional": false, "description": "", "typeRef": "Network.TimeSinceEpoch" }, { "name": "sources", "type": "array", "optional": false, "description": "", "typeRef": "PerformanceTimeline.LayoutShiftAttribution" }]);
    inspectorBackend.registerType("PerformanceTimeline.TimelineEvent", [{ "name": "frameId", "type": "string", "optional": false, "description": "Identifies the frame that this event is related to. Empty for non-frame targets.", "typeRef": "Page.FrameId" }, { "name": "type", "type": "string", "optional": false, "description": "The event type, as specified in https://w3c.github.io/performance-timeline/#dom-performanceentry-entrytype This determines which of the optional \\\"details\\\" fields is present.", "typeRef": null }, { "name": "name", "type": "string", "optional": false, "description": "Name may be empty depending on the type.", "typeRef": null }, { "name": "time", "type": "number", "optional": false, "description": "Time in seconds since Epoch, monotonically increasing within document lifetime.", "typeRef": "Network.TimeSinceEpoch" }, { "name": "duration", "type": "number", "optional": true, "description": "Event duration, if applicable.", "typeRef": null }, { "name": "lcpDetails", "type": "object", "optional": true, "description": "", "typeRef": "PerformanceTimeline.LargestContentfulPaint" }, { "name": "layoutShiftDetails", "type": "object", "optional": true, "description": "", "typeRef": "PerformanceTimeline.LayoutShift" }]);
    // Preload.
    inspectorBackend.registerEnum("Preload.RuleSetErrorType", { SourceIsNotJsonObject: "SourceIsNotJsonObject", InvalidRulesSkipped: "InvalidRulesSkipped", InvalidRulesetLevelTag: "InvalidRulesetLevelTag" });
    inspectorBackend.registerEnum("Preload.SpeculationAction", { Prefetch: "Prefetch", Prerender: "Prerender", PrerenderUntilScript: "PrerenderUntilScript" });
    inspectorBackend.registerEnum("Preload.SpeculationTargetHint", { Blank: "Blank", Self: "Self" });
    inspectorBackend.registerEnum("Preload.PrerenderFinalStatus", { Activated: "Activated", Destroyed: "Destroyed", LowEndDevice: "LowEndDevice", InvalidSchemeRedirect: "InvalidSchemeRedirect", InvalidSchemeNavigation: "InvalidSchemeNavigation", NavigationRequestBlockedByCsp: "NavigationRequestBlockedByCsp", MojoBinderPolicy: "MojoBinderPolicy", RendererProcessCrashed: "RendererProcessCrashed", RendererProcessKilled: "RendererProcessKilled", Download: "Download", TriggerDestroyed: "TriggerDestroyed", NavigationNotCommitted: "NavigationNotCommitted", NavigationBadHttpStatus: "NavigationBadHttpStatus", ClientCertRequested: "ClientCertRequested", NavigationRequestNetworkError: "NavigationRequestNetworkError", CancelAllHostsForTesting: "CancelAllHostsForTesting", DidFailLoad: "DidFailLoad", Stop: "Stop", SslCertificateError: "SslCertificateError", LoginAuthRequested: "LoginAuthRequested", UaChangeRequiresReload: "UaChangeRequiresReload", BlockedByClient: "BlockedByClient", AudioOutputDeviceRequested: "AudioOutputDeviceRequested", MixedContent: "MixedContent", TriggerBackgrounded: "TriggerBackgrounded", MemoryLimitExceeded: "MemoryLimitExceeded", DataSaverEnabled: "DataSaverEnabled", TriggerUrlHasEffectiveUrl: "TriggerUrlHasEffectiveUrl", ActivatedBeforeStarted: "ActivatedBeforeStarted", InactivePageRestriction: "InactivePageRestriction", StartFailed: "StartFailed", TimeoutBackgrounded: "TimeoutBackgrounded", CrossSiteRedirectInInitialNavigation: "CrossSiteRedirectInInitialNavigation", CrossSiteNavigationInInitialNavigation: "CrossSiteNavigationInInitialNavigation", SameSiteCrossOriginRedirectNotOptInInInitialNavigation: "SameSiteCrossOriginRedirectNotOptInInInitialNavigation", SameSiteCrossOriginNavigationNotOptInInInitialNavigation: "SameSiteCrossOriginNavigationNotOptInInInitialNavigation", ActivationNavigationParameterMismatch: "ActivationNavigationParameterMismatch", ActivatedInBackground: "ActivatedInBackground", EmbedderHostDisallowed: "EmbedderHostDisallowed", ActivationNavigationDestroyedBeforeSuccess: "ActivationNavigationDestroyedBeforeSuccess", TabClosedByUserGesture: "TabClosedByUserGesture", TabClosedWithoutUserGesture: "TabClosedWithoutUserGesture", PrimaryMainFrameRendererProcessCrashed: "PrimaryMainFrameRendererProcessCrashed", PrimaryMainFrameRendererProcessKilled: "PrimaryMainFrameRendererProcessKilled", ActivationFramePolicyNotCompatible: "ActivationFramePolicyNotCompatible", PreloadingDisabled: "PreloadingDisabled", BatterySaverEnabled: "BatterySaverEnabled", ActivatedDuringMainFrameNavigation: "ActivatedDuringMainFrameNavigation", PreloadingUnsupportedByWebContents: "PreloadingUnsupportedByWebContents", CrossSiteRedirectInMainFrameNavigation: "CrossSiteRedirectInMainFrameNavigation", CrossSiteNavigationInMainFrameNavigation: "CrossSiteNavigationInMainFrameNavigation", SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation: "SameSiteCrossOriginRedirectNotOptInInMainFrameNavigation", SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation: "SameSiteCrossOriginNavigationNotOptInInMainFrameNavigation", MemoryPressureOnTrigger: "MemoryPressureOnTrigger", MemoryPressureAfterTriggered: "MemoryPressureAfterTriggered", PrerenderingDisabledByDevTools: "PrerenderingDisabledByDevTools", SpeculationRuleRemoved: "SpeculationRuleRemoved", ActivatedWithAuxiliaryBrowsingContexts: "ActivatedWithAuxiliaryBrowsingContexts", MaxNumOfRunningEagerPrerendersExceeded: "MaxNumOfRunningEagerPrerendersExceeded", MaxNumOfRunningNonEagerPrerendersExceeded: "MaxNumOfRunningNonEagerPrerendersExceeded", MaxNumOfRunningEmbedderPrerendersExceeded: "MaxNumOfRunningEmbedderPrerendersExceeded", PrerenderingUrlHasEffectiveUrl: "PrerenderingUrlHasEffectiveUrl", RedirectedPrerenderingUrlHasEffectiveUrl: "RedirectedPrerenderingUrlHasEffectiveUrl", ActivationUrlHasEffectiveUrl: "ActivationUrlHasEffectiveUrl", JavaScriptInterfaceAdded: "JavaScriptInterfaceAdded", JavaScriptInterfaceRemoved: "JavaScriptInterfaceRemoved", AllPrerenderingCanceled: "AllPrerenderingCanceled", WindowClosed: "WindowClosed", SlowNetwork: "SlowNetwork", OtherPrerenderedPageActivated: "OtherPrerenderedPageActivated", V8OptimizerDisabled: "V8OptimizerDisabled", PrerenderFailedDuringPrefetch: "PrerenderFailedDuringPrefetch", BrowsingDataRemoved: "BrowsingDataRemoved", PrerenderHostReused: "PrerenderHostReused" });
    inspectorBackend.registerEnum("Preload.PreloadingStatus", { Pending: "Pending", Running: "Running", Ready: "Ready", Success: "Success", Failure: "Failure", NotSupported: "NotSupported" });
    inspectorBackend.registerEnum("Preload.PrefetchStatus", { PrefetchAllowed: "PrefetchAllowed", PrefetchFailedIneligibleRedirect: "PrefetchFailedIneligibleRedirect", PrefetchFailedInvalidRedirect: "PrefetchFailedInvalidRedirect", PrefetchFailedMIMENotSupported: "PrefetchFailedMIMENotSupported", PrefetchFailedNetError: "PrefetchFailedNetError", PrefetchFailedNon2XX: "PrefetchFailedNon2XX", PrefetchEvictedAfterBrowsingDataRemoved: "PrefetchEvictedAfterBrowsingDataRemoved", PrefetchEvictedAfterCandidateRemoved: "PrefetchEvictedAfterCandidateRemoved", PrefetchEvictedForNewerPrefetch: "PrefetchEvictedForNewerPrefetch", PrefetchHeldback: "PrefetchHeldback", PrefetchIneligibleRetryAfter: "PrefetchIneligibleRetryAfter", PrefetchIsPrivacyDecoy: "PrefetchIsPrivacyDecoy", PrefetchIsStale: "PrefetchIsStale", PrefetchNotEligibleBrowserContextOffTheRecord: "PrefetchNotEligibleBrowserContextOffTheRecord", PrefetchNotEligibleDataSaverEnabled: "PrefetchNotEligibleDataSaverEnabled", PrefetchNotEligibleExistingProxy: "PrefetchNotEligibleExistingProxy", PrefetchNotEligibleHostIsNonUnique: "PrefetchNotEligibleHostIsNonUnique", PrefetchNotEligibleNonDefaultStoragePartition: "PrefetchNotEligibleNonDefaultStoragePartition", PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy: "PrefetchNotEligibleSameSiteCrossOriginPrefetchRequiredProxy", PrefetchNotEligibleSchemeIsNotHttps: "PrefetchNotEligibleSchemeIsNotHttps", PrefetchNotEligibleUserHasCookies: "PrefetchNotEligibleUserHasCookies", PrefetchNotEligibleUserHasServiceWorker: "PrefetchNotEligibleUserHasServiceWorker", PrefetchNotEligibleUserHasServiceWorkerNoFetchHandler: "PrefetchNotEligibleUserHasServiceWorkerNoFetchHandler", PrefetchNotEligibleRedirectFromServiceWorker: "PrefetchNotEligibleRedirectFromServiceWorker", PrefetchNotEligibleRedirectToServiceWorker: "PrefetchNotEligibleRedirectToServiceWorker", PrefetchNotEligibleBatterySaverEnabled: "PrefetchNotEligibleBatterySaverEnabled", PrefetchNotEligiblePreloadingDisabled: "PrefetchNotEligiblePreloadingDisabled", PrefetchNotFinishedInTime: "PrefetchNotFinishedInTime", PrefetchNotStarted: "PrefetchNotStarted", PrefetchNotUsedCookiesChanged: "PrefetchNotUsedCookiesChanged", PrefetchProxyNotAvailable: "PrefetchProxyNotAvailable", PrefetchResponseUsed: "PrefetchResponseUsed", PrefetchSuccessfulButNotUsed: "PrefetchSuccessfulButNotUsed", PrefetchNotUsedProbeFailed: "PrefetchNotUsedProbeFailed" });
    inspectorBackend.registerEvent("Preload.ruleSetUpdated", ["ruleSet"]);
    inspectorBackend.registerEvent("Preload.ruleSetRemoved", ["id"]);
    inspectorBackend.registerEvent("Preload.preloadEnabledStateUpdated", ["disabledByPreference", "disabledByDataSaver", "disabledByBatterySaver", "disabledByHoldbackPrefetchSpeculationRules", "disabledByHoldbackPrerenderSpeculationRules"]);
    inspectorBackend.registerEvent("Preload.prefetchStatusUpdated", ["key", "pipelineId", "initiatingFrameId", "prefetchUrl", "status", "prefetchStatus", "requestId"]);
    inspectorBackend.registerEvent("Preload.prerenderStatusUpdated", ["key", "pipelineId", "status", "prerenderStatus", "disallowedMojoInterface", "mismatchedHeaders"]);
    inspectorBackend.registerEvent("Preload.preloadingAttemptSourcesUpdated", ["loaderId", "preloadingAttemptSources"]);
    inspectorBackend.registerCommand("Preload.enable", [], [], "");
    inspectorBackend.registerCommand("Preload.disable", [], [], "");
    inspectorBackend.registerType("Preload.RuleSet", [{ "name": "id", "type": "string", "optional": false, "description": "", "typeRef": "Preload.RuleSetId" }, { "name": "loaderId", "type": "string", "optional": false, "description": "Identifies a document which the rule set is associated with.", "typeRef": "Network.LoaderId" }, { "name": "sourceText", "type": "string", "optional": false, "description": "Source text of JSON representing the rule set. If it comes from `<script>` tag, it is the textContent of the node. Note that it is a JSON for valid case.  See also: - https://wicg.github.io/nav-speculation/speculation-rules.html - https://github.com/WICG/nav-speculation/blob/main/triggers.md", "typeRef": null }, { "name": "backendNodeId", "type": "number", "optional": true, "description": "A speculation rule set is either added through an inline `<script>` tag or through an external resource via the 'Speculation-Rules' HTTP header. For the first case, we include the BackendNodeId of the relevant `<script>` tag. For the second case, we include the external URL where the rule set was loaded from, and also RequestId if Network domain is enabled.  See also: - https://wicg.github.io/nav-speculation/speculation-rules.html#speculation-rules-script - https://wicg.github.io/nav-speculation/speculation-rules.html#speculation-rules-header", "typeRef": "DOM.BackendNodeId" }, { "name": "url", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "requestId", "type": "string", "optional": true, "description": "", "typeRef": "Network.RequestId" }, { "name": "errorType", "type": "string", "optional": true, "description": "Error information `errorMessage` is null iff `errorType` is null.", "typeRef": "Preload.RuleSetErrorType" }, { "name": "errorMessage", "type": "string", "optional": true, "description": "TODO(https://crbug.com/1425354): Replace this property with structured error.", "typeRef": null }, { "name": "tag", "type": "string", "optional": true, "description": "For more details, see: https://github.com/WICG/nav-speculation/blob/main/speculation-rules-tags.md", "typeRef": null }]);
    inspectorBackend.registerType("Preload.PreloadingAttemptKey", [{ "name": "loaderId", "type": "string", "optional": false, "description": "", "typeRef": "Network.LoaderId" }, { "name": "action", "type": "string", "optional": false, "description": "", "typeRef": "Preload.SpeculationAction" }, { "name": "url", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "targetHint", "type": "string", "optional": true, "description": "", "typeRef": "Preload.SpeculationTargetHint" }]);
    inspectorBackend.registerType("Preload.PreloadingAttemptSource", [{ "name": "key", "type": "object", "optional": false, "description": "", "typeRef": "Preload.PreloadingAttemptKey" }, { "name": "ruleSetIds", "type": "array", "optional": false, "description": "", "typeRef": "Preload.RuleSetId" }, { "name": "nodeIds", "type": "array", "optional": false, "description": "", "typeRef": "DOM.BackendNodeId" }]);
    inspectorBackend.registerType("Preload.PrerenderMismatchedHeaders", [{ "name": "headerName", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "initialValue", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "activationValue", "type": "string", "optional": true, "description": "", "typeRef": null }]);
    // Security.
    inspectorBackend.registerEnum("Security.MixedContentType", { Blockable: "blockable", OptionallyBlockable: "optionally-blockable", None: "none" });
    inspectorBackend.registerEnum("Security.SecurityState", { Unknown: "unknown", Neutral: "neutral", Insecure: "insecure", Secure: "secure", Info: "info", InsecureBroken: "insecure-broken" });
    inspectorBackend.registerEnum("Security.SafetyTipStatus", { BadReputation: "badReputation", Lookalike: "lookalike" });
    inspectorBackend.registerEnum("Security.CertificateErrorAction", { Continue: "continue", Cancel: "cancel" });
    inspectorBackend.registerEvent("Security.certificateError", ["eventId", "errorType", "requestURL"]);
    inspectorBackend.registerEvent("Security.visibleSecurityStateChanged", ["visibleSecurityState"]);
    inspectorBackend.registerEvent("Security.securityStateChanged", ["securityState", "schemeIsCryptographic", "explanations", "insecureContentStatus", "summary"]);
    inspectorBackend.registerCommand("Security.disable", [], [], "Disables tracking security state changes.");
    inspectorBackend.registerCommand("Security.enable", [], [], "Enables tracking security state changes.");
    inspectorBackend.registerCommand("Security.setIgnoreCertificateErrors", [{ "name": "ignore", "type": "boolean", "optional": false, "description": "If true, all certificate errors will be ignored.", "typeRef": null }], [], "Enable/disable whether all certificate errors should be ignored.");
    inspectorBackend.registerCommand("Security.handleCertificateError", [{ "name": "eventId", "type": "number", "optional": false, "description": "The ID of the event.", "typeRef": null }, { "name": "action", "type": "string", "optional": false, "description": "The action to take on the certificate error.", "typeRef": "Security.CertificateErrorAction" }], [], "Handles a certificate error that fired a certificateError event.");
    inspectorBackend.registerCommand("Security.setOverrideCertificateErrors", [{ "name": "override", "type": "boolean", "optional": false, "description": "If true, certificate errors will be overridden.", "typeRef": null }], [], "Enable/disable overriding certificate errors. If enabled, all certificate error events need to be handled by the DevTools client and should be answered with `handleCertificateError` commands.");
    inspectorBackend.registerType("Security.CertificateSecurityState", [{ "name": "protocol", "type": "string", "optional": false, "description": "Protocol name (e.g. \\\"TLS 1.2\\\" or \\\"QUIC\\\").", "typeRef": null }, { "name": "keyExchange", "type": "string", "optional": false, "description": "Key Exchange used by the connection, or the empty string if not applicable.", "typeRef": null }, { "name": "keyExchangeGroup", "type": "string", "optional": true, "description": "(EC)DH group used by the connection, if applicable.", "typeRef": null }, { "name": "cipher", "type": "string", "optional": false, "description": "Cipher name.", "typeRef": null }, { "name": "mac", "type": "string", "optional": true, "description": "TLS MAC. Note that AEAD ciphers do not have separate MACs.", "typeRef": null }, { "name": "certificate", "type": "array", "optional": false, "description": "Page certificate.", "typeRef": "string" }, { "name": "subjectName", "type": "string", "optional": false, "description": "Certificate subject name.", "typeRef": null }, { "name": "issuer", "type": "string", "optional": false, "description": "Name of the issuing CA.", "typeRef": null }, { "name": "validFrom", "type": "number", "optional": false, "description": "Certificate valid from date.", "typeRef": "Network.TimeSinceEpoch" }, { "name": "validTo", "type": "number", "optional": false, "description": "Certificate valid to (expiration) date", "typeRef": "Network.TimeSinceEpoch" }, { "name": "certificateNetworkError", "type": "string", "optional": true, "description": "The highest priority network error code, if the certificate has an error.", "typeRef": null }, { "name": "certificateHasWeakSignature", "type": "boolean", "optional": false, "description": "True if the certificate uses a weak signature algorithm.", "typeRef": null }, { "name": "certificateHasSha1Signature", "type": "boolean", "optional": false, "description": "True if the certificate has a SHA1 signature in the chain.", "typeRef": null }, { "name": "modernSSL", "type": "boolean", "optional": false, "description": "True if modern SSL", "typeRef": null }, { "name": "obsoleteSslProtocol", "type": "boolean", "optional": false, "description": "True if the connection is using an obsolete SSL protocol.", "typeRef": null }, { "name": "obsoleteSslKeyExchange", "type": "boolean", "optional": false, "description": "True if the connection is using an obsolete SSL key exchange.", "typeRef": null }, { "name": "obsoleteSslCipher", "type": "boolean", "optional": false, "description": "True if the connection is using an obsolete SSL cipher.", "typeRef": null }, { "name": "obsoleteSslSignature", "type": "boolean", "optional": false, "description": "True if the connection is using an obsolete SSL signature.", "typeRef": null }]);
    inspectorBackend.registerType("Security.SafetyTipInfo", [{ "name": "safetyTipStatus", "type": "string", "optional": false, "description": "Describes whether the page triggers any safety tips or reputation warnings. Default is unknown.", "typeRef": "Security.SafetyTipStatus" }, { "name": "safeUrl", "type": "string", "optional": true, "description": "The URL the safety tip suggested (\\\"Did you mean?\\\"). Only filled in for lookalike matches.", "typeRef": null }]);
    inspectorBackend.registerType("Security.VisibleSecurityState", [{ "name": "securityState", "type": "string", "optional": false, "description": "The security level of the page.", "typeRef": "Security.SecurityState" }, { "name": "certificateSecurityState", "type": "object", "optional": true, "description": "Security state details about the page certificate.", "typeRef": "Security.CertificateSecurityState" }, { "name": "safetyTipInfo", "type": "object", "optional": true, "description": "The type of Safety Tip triggered on the page. Note that this field will be set even if the Safety Tip UI was not actually shown.", "typeRef": "Security.SafetyTipInfo" }, { "name": "securityStateIssueIds", "type": "array", "optional": false, "description": "Array of security state issues ids.", "typeRef": "string" }]);
    inspectorBackend.registerType("Security.SecurityStateExplanation", [{ "name": "securityState", "type": "string", "optional": false, "description": "Security state representing the severity of the factor being explained.", "typeRef": "Security.SecurityState" }, { "name": "title", "type": "string", "optional": false, "description": "Title describing the type of factor.", "typeRef": null }, { "name": "summary", "type": "string", "optional": false, "description": "Short phrase describing the type of factor.", "typeRef": null }, { "name": "description", "type": "string", "optional": false, "description": "Full text explanation of the factor.", "typeRef": null }, { "name": "mixedContentType", "type": "string", "optional": false, "description": "The type of mixed content described by the explanation.", "typeRef": "Security.MixedContentType" }, { "name": "certificate", "type": "array", "optional": false, "description": "Page certificate.", "typeRef": "string" }, { "name": "recommendations", "type": "array", "optional": true, "description": "Recommendations to fix any issues.", "typeRef": "string" }]);
    inspectorBackend.registerType("Security.InsecureContentStatus", [{ "name": "ranMixedContent", "type": "boolean", "optional": false, "description": "Always false.", "typeRef": null }, { "name": "displayedMixedContent", "type": "boolean", "optional": false, "description": "Always false.", "typeRef": null }, { "name": "containedMixedForm", "type": "boolean", "optional": false, "description": "Always false.", "typeRef": null }, { "name": "ranContentWithCertErrors", "type": "boolean", "optional": false, "description": "Always false.", "typeRef": null }, { "name": "displayedContentWithCertErrors", "type": "boolean", "optional": false, "description": "Always false.", "typeRef": null }, { "name": "ranInsecureContentStyle", "type": "string", "optional": false, "description": "Always set to unknown.", "typeRef": "Security.SecurityState" }, { "name": "displayedInsecureContentStyle", "type": "string", "optional": false, "description": "Always set to unknown.", "typeRef": "Security.SecurityState" }]);
    // ServiceWorker.
    inspectorBackend.registerEnum("ServiceWorker.ServiceWorkerVersionRunningStatus", { Stopped: "stopped", Starting: "starting", Running: "running", Stopping: "stopping" });
    inspectorBackend.registerEnum("ServiceWorker.ServiceWorkerVersionStatus", { New: "new", Installing: "installing", Installed: "installed", Activating: "activating", Activated: "activated", Redundant: "redundant" });
    inspectorBackend.registerEvent("ServiceWorker.workerErrorReported", ["errorMessage"]);
    inspectorBackend.registerEvent("ServiceWorker.workerRegistrationUpdated", ["registrations"]);
    inspectorBackend.registerEvent("ServiceWorker.workerVersionUpdated", ["versions"]);
    inspectorBackend.registerCommand("ServiceWorker.deliverPushMessage", [{ "name": "origin", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "registrationId", "type": "string", "optional": false, "description": "", "typeRef": "ServiceWorker.RegistrationID" }, { "name": "data", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("ServiceWorker.disable", [], [], "");
    inspectorBackend.registerCommand("ServiceWorker.dispatchSyncEvent", [{ "name": "origin", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "registrationId", "type": "string", "optional": false, "description": "", "typeRef": "ServiceWorker.RegistrationID" }, { "name": "tag", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "lastChance", "type": "boolean", "optional": false, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("ServiceWorker.dispatchPeriodicSyncEvent", [{ "name": "origin", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "registrationId", "type": "string", "optional": false, "description": "", "typeRef": "ServiceWorker.RegistrationID" }, { "name": "tag", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("ServiceWorker.enable", [], [], "");
    inspectorBackend.registerCommand("ServiceWorker.setForceUpdateOnPageLoad", [{ "name": "forceUpdateOnPageLoad", "type": "boolean", "optional": false, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("ServiceWorker.skipWaiting", [{ "name": "scopeURL", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("ServiceWorker.startWorker", [{ "name": "scopeURL", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("ServiceWorker.stopAllWorkers", [], [], "");
    inspectorBackend.registerCommand("ServiceWorker.stopWorker", [{ "name": "versionId", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("ServiceWorker.unregister", [{ "name": "scopeURL", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("ServiceWorker.updateRegistration", [{ "name": "scopeURL", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerType("ServiceWorker.ServiceWorkerRegistration", [{ "name": "registrationId", "type": "string", "optional": false, "description": "", "typeRef": "ServiceWorker.RegistrationID" }, { "name": "scopeURL", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "isDeleted", "type": "boolean", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("ServiceWorker.ServiceWorkerVersion", [{ "name": "versionId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "registrationId", "type": "string", "optional": false, "description": "", "typeRef": "ServiceWorker.RegistrationID" }, { "name": "scriptURL", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "runningStatus", "type": "string", "optional": false, "description": "", "typeRef": "ServiceWorker.ServiceWorkerVersionRunningStatus" }, { "name": "status", "type": "string", "optional": false, "description": "", "typeRef": "ServiceWorker.ServiceWorkerVersionStatus" }, { "name": "scriptLastModified", "type": "number", "optional": true, "description": "The Last-Modified header value of the main script.", "typeRef": null }, { "name": "scriptResponseTime", "type": "number", "optional": true, "description": "The time at which the response headers of the main script were received from the server. For cached script it is the last time the cache entry was validated.", "typeRef": null }, { "name": "controlledClients", "type": "array", "optional": true, "description": "", "typeRef": "Target.TargetID" }, { "name": "targetId", "type": "string", "optional": true, "description": "", "typeRef": "Target.TargetID" }, { "name": "routerRules", "type": "string", "optional": true, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("ServiceWorker.ServiceWorkerErrorMessage", [{ "name": "errorMessage", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "registrationId", "type": "string", "optional": false, "description": "", "typeRef": "ServiceWorker.RegistrationID" }, { "name": "versionId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "sourceURL", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "lineNumber", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "columnNumber", "type": "number", "optional": false, "description": "", "typeRef": null }]);
    // Storage.
    inspectorBackend.registerEnum("Storage.StorageType", { Cookies: "cookies", File_systems: "file_systems", Indexeddb: "indexeddb", Local_storage: "local_storage", Shader_cache: "shader_cache", Websql: "websql", Service_workers: "service_workers", Cache_storage: "cache_storage", Interest_groups: "interest_groups", Shared_storage: "shared_storage", Storage_buckets: "storage_buckets", All: "all", Other: "other" });
    inspectorBackend.registerEnum("Storage.InterestGroupAccessType", { Join: "join", Leave: "leave", Update: "update", Loaded: "loaded", Bid: "bid", Win: "win", AdditionalBid: "additionalBid", AdditionalBidWin: "additionalBidWin", TopLevelBid: "topLevelBid", TopLevelAdditionalBid: "topLevelAdditionalBid", Clear: "clear" });
    inspectorBackend.registerEnum("Storage.InterestGroupAuctionEventType", { Started: "started", ConfigResolved: "configResolved" });
    inspectorBackend.registerEnum("Storage.InterestGroupAuctionFetchType", { BidderJs: "bidderJs", BidderWasm: "bidderWasm", SellerJs: "sellerJs", BidderTrustedSignals: "bidderTrustedSignals", SellerTrustedSignals: "sellerTrustedSignals" });
    inspectorBackend.registerEnum("Storage.SharedStorageAccessScope", { Window: "window", SharedStorageWorklet: "sharedStorageWorklet", ProtectedAudienceWorklet: "protectedAudienceWorklet", Header: "header" });
    inspectorBackend.registerEnum("Storage.SharedStorageAccessMethod", { AddModule: "addModule", CreateWorklet: "createWorklet", SelectURL: "selectURL", Run: "run", BatchUpdate: "batchUpdate", Set: "set", Append: "append", Delete: "delete", Clear: "clear", Get: "get", Keys: "keys", Values: "values", Entries: "entries", Length: "length", RemainingBudget: "remainingBudget" });
    inspectorBackend.registerEnum("Storage.StorageBucketsDurability", { Relaxed: "relaxed", Strict: "strict" });
    inspectorBackend.registerEnum("Storage.AttributionReportingSourceType", { Navigation: "navigation", Event: "event" });
    inspectorBackend.registerEnum("Storage.AttributionReportingTriggerDataMatching", { Exact: "exact", Modulus: "modulus" });
    inspectorBackend.registerEnum("Storage.AttributionReportingSourceRegistrationResult", { Success: "success", InternalError: "internalError", InsufficientSourceCapacity: "insufficientSourceCapacity", InsufficientUniqueDestinationCapacity: "insufficientUniqueDestinationCapacity", ExcessiveReportingOrigins: "excessiveReportingOrigins", ProhibitedByBrowserPolicy: "prohibitedByBrowserPolicy", SuccessNoised: "successNoised", DestinationReportingLimitReached: "destinationReportingLimitReached", DestinationGlobalLimitReached: "destinationGlobalLimitReached", DestinationBothLimitsReached: "destinationBothLimitsReached", ReportingOriginsPerSiteLimitReached: "reportingOriginsPerSiteLimitReached", ExceedsMaxChannelCapacity: "exceedsMaxChannelCapacity", ExceedsMaxScopesChannelCapacity: "exceedsMaxScopesChannelCapacity", ExceedsMaxTriggerStateCardinality: "exceedsMaxTriggerStateCardinality", ExceedsMaxEventStatesLimit: "exceedsMaxEventStatesLimit", DestinationPerDayReportingLimitReached: "destinationPerDayReportingLimitReached" });
    inspectorBackend.registerEnum("Storage.AttributionReportingSourceRegistrationTimeConfig", { Include: "include", Exclude: "exclude" });
    inspectorBackend.registerEnum("Storage.AttributionReportingEventLevelResult", { Success: "success", SuccessDroppedLowerPriority: "successDroppedLowerPriority", InternalError: "internalError", NoCapacityForAttributionDestination: "noCapacityForAttributionDestination", NoMatchingSources: "noMatchingSources", Deduplicated: "deduplicated", ExcessiveAttributions: "excessiveAttributions", PriorityTooLow: "priorityTooLow", NeverAttributedSource: "neverAttributedSource", ExcessiveReportingOrigins: "excessiveReportingOrigins", NoMatchingSourceFilterData: "noMatchingSourceFilterData", ProhibitedByBrowserPolicy: "prohibitedByBrowserPolicy", NoMatchingConfigurations: "noMatchingConfigurations", ExcessiveReports: "excessiveReports", FalselyAttributedSource: "falselyAttributedSource", ReportWindowPassed: "reportWindowPassed", NotRegistered: "notRegistered", ReportWindowNotStarted: "reportWindowNotStarted", NoMatchingTriggerData: "noMatchingTriggerData" });
    inspectorBackend.registerEnum("Storage.AttributionReportingAggregatableResult", { Success: "success", InternalError: "internalError", NoCapacityForAttributionDestination: "noCapacityForAttributionDestination", NoMatchingSources: "noMatchingSources", ExcessiveAttributions: "excessiveAttributions", ExcessiveReportingOrigins: "excessiveReportingOrigins", NoHistograms: "noHistograms", InsufficientBudget: "insufficientBudget", InsufficientNamedBudget: "insufficientNamedBudget", NoMatchingSourceFilterData: "noMatchingSourceFilterData", NotRegistered: "notRegistered", ProhibitedByBrowserPolicy: "prohibitedByBrowserPolicy", Deduplicated: "deduplicated", ReportWindowPassed: "reportWindowPassed", ExcessiveReports: "excessiveReports" });
    inspectorBackend.registerEnum("Storage.AttributionReportingReportResult", { Sent: "sent", Prohibited: "prohibited", FailedToAssemble: "failedToAssemble", Expired: "expired" });
    inspectorBackend.registerEvent("Storage.cacheStorageContentUpdated", ["origin", "storageKey", "bucketId", "cacheName"]);
    inspectorBackend.registerEvent("Storage.cacheStorageListUpdated", ["origin", "storageKey", "bucketId"]);
    inspectorBackend.registerEvent("Storage.indexedDBContentUpdated", ["origin", "storageKey", "bucketId", "databaseName", "objectStoreName"]);
    inspectorBackend.registerEvent("Storage.indexedDBListUpdated", ["origin", "storageKey", "bucketId"]);
    inspectorBackend.registerEvent("Storage.interestGroupAccessed", ["accessTime", "type", "ownerOrigin", "name", "componentSellerOrigin", "bid", "bidCurrency", "uniqueAuctionId"]);
    inspectorBackend.registerEvent("Storage.interestGroupAuctionEventOccurred", ["eventTime", "type", "uniqueAuctionId", "parentAuctionId", "auctionConfig"]);
    inspectorBackend.registerEvent("Storage.interestGroupAuctionNetworkRequestCreated", ["type", "requestId", "auctions"]);
    inspectorBackend.registerEvent("Storage.sharedStorageAccessed", ["accessTime", "scope", "method", "mainFrameId", "ownerOrigin", "ownerSite", "params"]);
    inspectorBackend.registerEvent("Storage.sharedStorageWorkletOperationExecutionFinished", ["finishedTime", "executionTime", "method", "operationId", "workletTargetId", "mainFrameId", "ownerOrigin"]);
    inspectorBackend.registerEvent("Storage.storageBucketCreatedOrUpdated", ["bucketInfo"]);
    inspectorBackend.registerEvent("Storage.storageBucketDeleted", ["bucketId"]);
    inspectorBackend.registerEvent("Storage.attributionReportingSourceRegistered", ["registration", "result"]);
    inspectorBackend.registerEvent("Storage.attributionReportingTriggerRegistered", ["registration", "eventLevel", "aggregatable"]);
    inspectorBackend.registerEvent("Storage.attributionReportingReportSent", ["url", "body", "result", "netError", "netErrorName", "httpStatusCode"]);
    inspectorBackend.registerEvent("Storage.attributionReportingVerboseDebugReportSent", ["url", "body", "netError", "netErrorName", "httpStatusCode"]);
    inspectorBackend.registerCommand("Storage.getStorageKeyForFrame", [{ "name": "frameId", "type": "string", "optional": false, "description": "", "typeRef": "Page.FrameId" }], ["storageKey"], "Returns a storage key given a frame id. Deprecated. Please use Storage.getStorageKey instead.");
    inspectorBackend.registerCommand("Storage.getStorageKey", [{ "name": "frameId", "type": "string", "optional": true, "description": "", "typeRef": "Page.FrameId" }], ["storageKey"], "Returns storage key for the given frame. If no frame ID is provided, the storage key of the target executing this command is returned.");
    inspectorBackend.registerCommand("Storage.clearDataForOrigin", [{ "name": "origin", "type": "string", "optional": false, "description": "Security origin.", "typeRef": null }, { "name": "storageTypes", "type": "string", "optional": false, "description": "Comma separated list of StorageType to clear.", "typeRef": null }], [], "Clears storage for origin.");
    inspectorBackend.registerCommand("Storage.clearDataForStorageKey", [{ "name": "storageKey", "type": "string", "optional": false, "description": "Storage key.", "typeRef": null }, { "name": "storageTypes", "type": "string", "optional": false, "description": "Comma separated list of StorageType to clear.", "typeRef": null }], [], "Clears storage for storage key.");
    inspectorBackend.registerCommand("Storage.getCookies", [{ "name": "browserContextId", "type": "string", "optional": true, "description": "Browser context to use when called on the browser endpoint.", "typeRef": "Browser.BrowserContextID" }], ["cookies"], "Returns all browser cookies.");
    inspectorBackend.registerCommand("Storage.setCookies", [{ "name": "cookies", "type": "array", "optional": false, "description": "Cookies to be set.", "typeRef": "Network.CookieParam" }, { "name": "browserContextId", "type": "string", "optional": true, "description": "Browser context to use when called on the browser endpoint.", "typeRef": "Browser.BrowserContextID" }], [], "Sets given cookies.");
    inspectorBackend.registerCommand("Storage.clearCookies", [{ "name": "browserContextId", "type": "string", "optional": true, "description": "Browser context to use when called on the browser endpoint.", "typeRef": "Browser.BrowserContextID" }], [], "Clears cookies.");
    inspectorBackend.registerCommand("Storage.getUsageAndQuota", [{ "name": "origin", "type": "string", "optional": false, "description": "Security origin.", "typeRef": null }], ["usage", "quota", "overrideActive", "usageBreakdown"], "Returns usage and quota in bytes.");
    inspectorBackend.registerCommand("Storage.overrideQuotaForOrigin", [{ "name": "origin", "type": "string", "optional": false, "description": "Security origin.", "typeRef": null }, { "name": "quotaSize", "type": "number", "optional": true, "description": "The quota size (in bytes) to override the original quota with. If this is called multiple times, the overridden quota will be equal to the quotaSize provided in the final call. If this is called without specifying a quotaSize, the quota will be reset to the default value for the specified origin. If this is called multiple times with different origins, the override will be maintained for each origin until it is disabled (called without a quotaSize).", "typeRef": null }], [], "Override quota for the specified origin");
    inspectorBackend.registerCommand("Storage.trackCacheStorageForOrigin", [{ "name": "origin", "type": "string", "optional": false, "description": "Security origin.", "typeRef": null }], [], "Registers origin to be notified when an update occurs to its cache storage list.");
    inspectorBackend.registerCommand("Storage.trackCacheStorageForStorageKey", [{ "name": "storageKey", "type": "string", "optional": false, "description": "Storage key.", "typeRef": null }], [], "Registers storage key to be notified when an update occurs to its cache storage list.");
    inspectorBackend.registerCommand("Storage.trackIndexedDBForOrigin", [{ "name": "origin", "type": "string", "optional": false, "description": "Security origin.", "typeRef": null }], [], "Registers origin to be notified when an update occurs to its IndexedDB.");
    inspectorBackend.registerCommand("Storage.trackIndexedDBForStorageKey", [{ "name": "storageKey", "type": "string", "optional": false, "description": "Storage key.", "typeRef": null }], [], "Registers storage key to be notified when an update occurs to its IndexedDB.");
    inspectorBackend.registerCommand("Storage.untrackCacheStorageForOrigin", [{ "name": "origin", "type": "string", "optional": false, "description": "Security origin.", "typeRef": null }], [], "Unregisters origin from receiving notifications for cache storage.");
    inspectorBackend.registerCommand("Storage.untrackCacheStorageForStorageKey", [{ "name": "storageKey", "type": "string", "optional": false, "description": "Storage key.", "typeRef": null }], [], "Unregisters storage key from receiving notifications for cache storage.");
    inspectorBackend.registerCommand("Storage.untrackIndexedDBForOrigin", [{ "name": "origin", "type": "string", "optional": false, "description": "Security origin.", "typeRef": null }], [], "Unregisters origin from receiving notifications for IndexedDB.");
    inspectorBackend.registerCommand("Storage.untrackIndexedDBForStorageKey", [{ "name": "storageKey", "type": "string", "optional": false, "description": "Storage key.", "typeRef": null }], [], "Unregisters storage key from receiving notifications for IndexedDB.");
    inspectorBackend.registerCommand("Storage.getTrustTokens", [], ["tokens"], "Returns the number of stored Trust Tokens per issuer for the current browsing context.");
    inspectorBackend.registerCommand("Storage.clearTrustTokens", [{ "name": "issuerOrigin", "type": "string", "optional": false, "description": "", "typeRef": null }], ["didDeleteTokens"], "Removes all Trust Tokens issued by the provided issuerOrigin. Leaves other stored data, including the issuer's Redemption Records, intact.");
    inspectorBackend.registerCommand("Storage.getInterestGroupDetails", [{ "name": "ownerOrigin", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }], ["details"], "Gets details for a named interest group.");
    inspectorBackend.registerCommand("Storage.setInterestGroupTracking", [{ "name": "enable", "type": "boolean", "optional": false, "description": "", "typeRef": null }], [], "Enables/Disables issuing of interestGroupAccessed events.");
    inspectorBackend.registerCommand("Storage.setInterestGroupAuctionTracking", [{ "name": "enable", "type": "boolean", "optional": false, "description": "", "typeRef": null }], [], "Enables/Disables issuing of interestGroupAuctionEventOccurred and interestGroupAuctionNetworkRequestCreated.");
    inspectorBackend.registerCommand("Storage.getSharedStorageMetadata", [{ "name": "ownerOrigin", "type": "string", "optional": false, "description": "", "typeRef": null }], ["metadata"], "Gets metadata for an origin's shared storage.");
    inspectorBackend.registerCommand("Storage.getSharedStorageEntries", [{ "name": "ownerOrigin", "type": "string", "optional": false, "description": "", "typeRef": null }], ["entries"], "Gets the entries in an given origin's shared storage.");
    inspectorBackend.registerCommand("Storage.setSharedStorageEntry", [{ "name": "ownerOrigin", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "key", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "ignoreIfPresent", "type": "boolean", "optional": true, "description": "If `ignoreIfPresent` is included and true, then only sets the entry if `key` doesn't already exist.", "typeRef": null }], [], "Sets entry with `key` and `value` for a given origin's shared storage.");
    inspectorBackend.registerCommand("Storage.deleteSharedStorageEntry", [{ "name": "ownerOrigin", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "key", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Deletes entry for `key` (if it exists) for a given origin's shared storage.");
    inspectorBackend.registerCommand("Storage.clearSharedStorageEntries", [{ "name": "ownerOrigin", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Clears all entries for a given origin's shared storage.");
    inspectorBackend.registerCommand("Storage.resetSharedStorageBudget", [{ "name": "ownerOrigin", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Resets the budget for `ownerOrigin` by clearing all budget withdrawals.");
    inspectorBackend.registerCommand("Storage.setSharedStorageTracking", [{ "name": "enable", "type": "boolean", "optional": false, "description": "", "typeRef": null }], [], "Enables/disables issuing of sharedStorageAccessed events.");
    inspectorBackend.registerCommand("Storage.setStorageBucketTracking", [{ "name": "storageKey", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "enable", "type": "boolean", "optional": false, "description": "", "typeRef": null }], [], "Set tracking for a storage key's buckets.");
    inspectorBackend.registerCommand("Storage.deleteStorageBucket", [{ "name": "bucket", "type": "object", "optional": false, "description": "", "typeRef": "Storage.StorageBucket" }], [], "Deletes the Storage Bucket with the given storage key and bucket name.");
    inspectorBackend.registerCommand("Storage.runBounceTrackingMitigations", [], ["deletedSites"], "Deletes state for sites identified as potential bounce trackers, immediately.");
    inspectorBackend.registerCommand("Storage.setAttributionReportingLocalTestingMode", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "If enabled, noise is suppressed and reports are sent immediately.", "typeRef": null }], [], "https://wicg.github.io/attribution-reporting-api/");
    inspectorBackend.registerCommand("Storage.setAttributionReportingTracking", [{ "name": "enable", "type": "boolean", "optional": false, "description": "", "typeRef": null }], [], "Enables/disables issuing of Attribution Reporting events.");
    inspectorBackend.registerCommand("Storage.sendPendingAttributionReports", [], ["numSent"], "Sends all pending Attribution Reports immediately, regardless of their scheduled report time.");
    inspectorBackend.registerCommand("Storage.getRelatedWebsiteSets", [], ["sets"], "Returns the effective Related Website Sets in use by this profile for the browser session. The effective Related Website Sets will not change during a browser session.");
    inspectorBackend.registerCommand("Storage.getAffectedUrlsForThirdPartyCookieMetadata", [{ "name": "firstPartyUrl", "type": "string", "optional": false, "description": "The URL of the page currently being visited.", "typeRef": null }, { "name": "thirdPartyUrls", "type": "array", "optional": false, "description": "The list of embedded resource URLs from the page.", "typeRef": "string" }], ["matchedUrls"], "Returns the list of URLs from a page and its embedded resources that match existing grace period URL pattern rules. https://developers.google.com/privacy-sandbox/cookies/temporary-exceptions/grace-period");
    inspectorBackend.registerCommand("Storage.setProtectedAudienceKAnonymity", [{ "name": "owner", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "hashes", "type": "array", "optional": false, "description": "", "typeRef": "binary" }], [], "");
    inspectorBackend.registerType("Storage.UsageForType", [{ "name": "storageType", "type": "string", "optional": false, "description": "Name of storage type.", "typeRef": "Storage.StorageType" }, { "name": "usage", "type": "number", "optional": false, "description": "Storage usage (bytes).", "typeRef": null }]);
    inspectorBackend.registerType("Storage.TrustTokens", [{ "name": "issuerOrigin", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "count", "type": "number", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Storage.SharedStorageEntry", [{ "name": "key", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Storage.SharedStorageMetadata", [{ "name": "creationTime", "type": "number", "optional": false, "description": "Time when the origin's shared storage was last created.", "typeRef": "Network.TimeSinceEpoch" }, { "name": "length", "type": "number", "optional": false, "description": "Number of key-value pairs stored in origin's shared storage.", "typeRef": null }, { "name": "remainingBudget", "type": "number", "optional": false, "description": "Current amount of bits of entropy remaining in the navigation budget.", "typeRef": null }, { "name": "bytesUsed", "type": "number", "optional": false, "description": "Total number of bytes stored as key-value pairs in origin's shared storage.", "typeRef": null }]);
    inspectorBackend.registerType("Storage.SharedStoragePrivateAggregationConfig", [{ "name": "aggregationCoordinatorOrigin", "type": "string", "optional": true, "description": "The chosen aggregation service deployment.", "typeRef": null }, { "name": "contextId", "type": "string", "optional": true, "description": "The context ID provided.", "typeRef": null }, { "name": "filteringIdMaxBytes", "type": "number", "optional": false, "description": "Configures the maximum size allowed for filtering IDs.", "typeRef": null }, { "name": "maxContributions", "type": "number", "optional": true, "description": "The limit on the number of contributions in the final report.", "typeRef": null }]);
    inspectorBackend.registerType("Storage.SharedStorageReportingMetadata", [{ "name": "eventType", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "reportingUrl", "type": "string", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Storage.SharedStorageUrlWithMetadata", [{ "name": "url", "type": "string", "optional": false, "description": "Spec of candidate URL.", "typeRef": null }, { "name": "reportingMetadata", "type": "array", "optional": false, "description": "Any associated reporting metadata.", "typeRef": "Storage.SharedStorageReportingMetadata" }]);
    inspectorBackend.registerType("Storage.SharedStorageAccessParams", [{ "name": "scriptSourceUrl", "type": "string", "optional": true, "description": "Spec of the module script URL. Present only for SharedStorageAccessMethods: addModule and createWorklet.", "typeRef": null }, { "name": "dataOrigin", "type": "string", "optional": true, "description": "String denoting \\\"context-origin\\\", \\\"script-origin\\\", or a custom origin to be used as the worklet's data origin. Present only for SharedStorageAccessMethod: createWorklet.", "typeRef": null }, { "name": "operationName", "type": "string", "optional": true, "description": "Name of the registered operation to be run. Present only for SharedStorageAccessMethods: run and selectURL.", "typeRef": null }, { "name": "operationId", "type": "string", "optional": true, "description": "ID of the operation call. Present only for SharedStorageAccessMethods: run and selectURL.", "typeRef": null }, { "name": "keepAlive", "type": "boolean", "optional": true, "description": "Whether or not to keep the worket alive for future run or selectURL calls. Present only for SharedStorageAccessMethods: run and selectURL.", "typeRef": null }, { "name": "privateAggregationConfig", "type": "object", "optional": true, "description": "Configures the private aggregation options. Present only for SharedStorageAccessMethods: run and selectURL.", "typeRef": "Storage.SharedStoragePrivateAggregationConfig" }, { "name": "serializedData", "type": "string", "optional": true, "description": "The operation's serialized data in bytes (converted to a string). Present only for SharedStorageAccessMethods: run and selectURL. TODO(crbug.com/401011862): Consider updating this parameter to binary.", "typeRef": null }, { "name": "urlsWithMetadata", "type": "array", "optional": true, "description": "Array of candidate URLs' specs, along with any associated metadata. Present only for SharedStorageAccessMethod: selectURL.", "typeRef": "Storage.SharedStorageUrlWithMetadata" }, { "name": "urnUuid", "type": "string", "optional": true, "description": "Spec of the URN:UUID generated for a selectURL call. Present only for SharedStorageAccessMethod: selectURL.", "typeRef": null }, { "name": "key", "type": "string", "optional": true, "description": "Key for a specific entry in an origin's shared storage. Present only for SharedStorageAccessMethods: set, append, delete, and get.", "typeRef": null }, { "name": "value", "type": "string", "optional": true, "description": "Value for a specific entry in an origin's shared storage. Present only for SharedStorageAccessMethods: set and append.", "typeRef": null }, { "name": "ignoreIfPresent", "type": "boolean", "optional": true, "description": "Whether or not to set an entry for a key if that key is already present. Present only for SharedStorageAccessMethod: set.", "typeRef": null }, { "name": "workletOrdinal", "type": "number", "optional": true, "description": "A number denoting the (0-based) order of the worklet's creation relative to all other shared storage worklets created by documents using the current storage partition. Present only for SharedStorageAccessMethods: addModule, createWorklet.", "typeRef": null }, { "name": "workletTargetId", "type": "string", "optional": true, "description": "Hex representation of the DevTools token used as the TargetID for the associated shared storage worklet. Present only for SharedStorageAccessMethods: addModule, createWorklet, run, selectURL, and any other SharedStorageAccessMethod when the SharedStorageAccessScope is sharedStorageWorklet.", "typeRef": "Target.TargetID" }, { "name": "withLock", "type": "string", "optional": true, "description": "Name of the lock to be acquired, if present. Optionally present only for SharedStorageAccessMethods: batchUpdate, set, append, delete, and clear.", "typeRef": null }, { "name": "batchUpdateId", "type": "string", "optional": true, "description": "If the method has been called as part of a batchUpdate, then this number identifies the batch to which it belongs. Optionally present only for SharedStorageAccessMethods: batchUpdate (required), set, append, delete, and clear.", "typeRef": null }, { "name": "batchSize", "type": "number", "optional": true, "description": "Number of modifier methods sent in batch. Present only for SharedStorageAccessMethod: batchUpdate.", "typeRef": null }]);
    inspectorBackend.registerType("Storage.StorageBucket", [{ "name": "storageKey", "type": "string", "optional": false, "description": "", "typeRef": "Storage.SerializedStorageKey" }, { "name": "name", "type": "string", "optional": true, "description": "If not specified, it is the default bucket of the storageKey.", "typeRef": null }]);
    inspectorBackend.registerType("Storage.StorageBucketInfo", [{ "name": "bucket", "type": "object", "optional": false, "description": "", "typeRef": "Storage.StorageBucket" }, { "name": "id", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "expiration", "type": "number", "optional": false, "description": "", "typeRef": "Network.TimeSinceEpoch" }, { "name": "quota", "type": "number", "optional": false, "description": "Storage quota (bytes).", "typeRef": null }, { "name": "persistent", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "durability", "type": "string", "optional": false, "description": "", "typeRef": "Storage.StorageBucketsDurability" }]);
    inspectorBackend.registerType("Storage.AttributionReportingFilterDataEntry", [{ "name": "key", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "values", "type": "array", "optional": false, "description": "", "typeRef": "string" }]);
    inspectorBackend.registerType("Storage.AttributionReportingFilterConfig", [{ "name": "filterValues", "type": "array", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingFilterDataEntry" }, { "name": "lookbackWindow", "type": "number", "optional": true, "description": "duration in seconds", "typeRef": null }]);
    inspectorBackend.registerType("Storage.AttributionReportingFilterPair", [{ "name": "filters", "type": "array", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingFilterConfig" }, { "name": "notFilters", "type": "array", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingFilterConfig" }]);
    inspectorBackend.registerType("Storage.AttributionReportingAggregationKeysEntry", [{ "name": "key", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "value", "type": "string", "optional": false, "description": "", "typeRef": "Storage.UnsignedInt128AsBase16" }]);
    inspectorBackend.registerType("Storage.AttributionReportingEventReportWindows", [{ "name": "start", "type": "number", "optional": false, "description": "duration in seconds", "typeRef": null }, { "name": "ends", "type": "array", "optional": false, "description": "duration in seconds", "typeRef": "integer" }]);
    inspectorBackend.registerType("Storage.AttributionReportingAggregatableDebugReportingData", [{ "name": "keyPiece", "type": "string", "optional": false, "description": "", "typeRef": "Storage.UnsignedInt128AsBase16" }, { "name": "value", "type": "number", "optional": false, "description": "number instead of integer because not all uint32 can be represented by int", "typeRef": null }, { "name": "types", "type": "array", "optional": false, "description": "", "typeRef": "string" }]);
    inspectorBackend.registerType("Storage.AttributionReportingAggregatableDebugReportingConfig", [{ "name": "budget", "type": "number", "optional": true, "description": "number instead of integer because not all uint32 can be represented by int, only present for source registrations", "typeRef": null }, { "name": "keyPiece", "type": "string", "optional": false, "description": "", "typeRef": "Storage.UnsignedInt128AsBase16" }, { "name": "debugData", "type": "array", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingAggregatableDebugReportingData" }, { "name": "aggregationCoordinatorOrigin", "type": "string", "optional": true, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Storage.AttributionScopesData", [{ "name": "values", "type": "array", "optional": false, "description": "", "typeRef": "string" }, { "name": "limit", "type": "number", "optional": false, "description": "number instead of integer because not all uint32 can be represented by int", "typeRef": null }, { "name": "maxEventStates", "type": "number", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Storage.AttributionReportingNamedBudgetDef", [{ "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "budget", "type": "number", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Storage.AttributionReportingSourceRegistration", [{ "name": "time", "type": "number", "optional": false, "description": "", "typeRef": "Network.TimeSinceEpoch" }, { "name": "expiry", "type": "number", "optional": false, "description": "duration in seconds", "typeRef": null }, { "name": "triggerData", "type": "array", "optional": false, "description": "number instead of integer because not all uint32 can be represented by int", "typeRef": "number" }, { "name": "eventReportWindows", "type": "object", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingEventReportWindows" }, { "name": "aggregatableReportWindow", "type": "number", "optional": false, "description": "duration in seconds", "typeRef": null }, { "name": "type", "type": "string", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingSourceType" }, { "name": "sourceOrigin", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "reportingOrigin", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "destinationSites", "type": "array", "optional": false, "description": "", "typeRef": "string" }, { "name": "eventId", "type": "string", "optional": false, "description": "", "typeRef": "Storage.UnsignedInt64AsBase10" }, { "name": "priority", "type": "string", "optional": false, "description": "", "typeRef": "Storage.SignedInt64AsBase10" }, { "name": "filterData", "type": "array", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingFilterDataEntry" }, { "name": "aggregationKeys", "type": "array", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingAggregationKeysEntry" }, { "name": "debugKey", "type": "string", "optional": true, "description": "", "typeRef": "Storage.UnsignedInt64AsBase10" }, { "name": "triggerDataMatching", "type": "string", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingTriggerDataMatching" }, { "name": "destinationLimitPriority", "type": "string", "optional": false, "description": "", "typeRef": "Storage.SignedInt64AsBase10" }, { "name": "aggregatableDebugReportingConfig", "type": "object", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingAggregatableDebugReportingConfig" }, { "name": "scopesData", "type": "object", "optional": true, "description": "", "typeRef": "Storage.AttributionScopesData" }, { "name": "maxEventLevelReports", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "namedBudgets", "type": "array", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingNamedBudgetDef" }, { "name": "debugReporting", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "eventLevelEpsilon", "type": "number", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Storage.AttributionReportingAggregatableValueDictEntry", [{ "name": "key", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "value", "type": "number", "optional": false, "description": "number instead of integer because not all uint32 can be represented by int", "typeRef": null }, { "name": "filteringId", "type": "string", "optional": false, "description": "", "typeRef": "Storage.UnsignedInt64AsBase10" }]);
    inspectorBackend.registerType("Storage.AttributionReportingAggregatableValueEntry", [{ "name": "values", "type": "array", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingAggregatableValueDictEntry" }, { "name": "filters", "type": "object", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingFilterPair" }]);
    inspectorBackend.registerType("Storage.AttributionReportingEventTriggerData", [{ "name": "data", "type": "string", "optional": false, "description": "", "typeRef": "Storage.UnsignedInt64AsBase10" }, { "name": "priority", "type": "string", "optional": false, "description": "", "typeRef": "Storage.SignedInt64AsBase10" }, { "name": "dedupKey", "type": "string", "optional": true, "description": "", "typeRef": "Storage.UnsignedInt64AsBase10" }, { "name": "filters", "type": "object", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingFilterPair" }]);
    inspectorBackend.registerType("Storage.AttributionReportingAggregatableTriggerData", [{ "name": "keyPiece", "type": "string", "optional": false, "description": "", "typeRef": "Storage.UnsignedInt128AsBase16" }, { "name": "sourceKeys", "type": "array", "optional": false, "description": "", "typeRef": "string" }, { "name": "filters", "type": "object", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingFilterPair" }]);
    inspectorBackend.registerType("Storage.AttributionReportingAggregatableDedupKey", [{ "name": "dedupKey", "type": "string", "optional": true, "description": "", "typeRef": "Storage.UnsignedInt64AsBase10" }, { "name": "filters", "type": "object", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingFilterPair" }]);
    inspectorBackend.registerType("Storage.AttributionReportingNamedBudgetCandidate", [{ "name": "name", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "filters", "type": "object", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingFilterPair" }]);
    inspectorBackend.registerType("Storage.AttributionReportingTriggerRegistration", [{ "name": "filters", "type": "object", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingFilterPair" }, { "name": "debugKey", "type": "string", "optional": true, "description": "", "typeRef": "Storage.UnsignedInt64AsBase10" }, { "name": "aggregatableDedupKeys", "type": "array", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingAggregatableDedupKey" }, { "name": "eventTriggerData", "type": "array", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingEventTriggerData" }, { "name": "aggregatableTriggerData", "type": "array", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingAggregatableTriggerData" }, { "name": "aggregatableValues", "type": "array", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingAggregatableValueEntry" }, { "name": "aggregatableFilteringIdMaxBytes", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "debugReporting", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "aggregationCoordinatorOrigin", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "sourceRegistrationTimeConfig", "type": "string", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingSourceRegistrationTimeConfig" }, { "name": "triggerContextId", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "aggregatableDebugReportingConfig", "type": "object", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingAggregatableDebugReportingConfig" }, { "name": "scopes", "type": "array", "optional": false, "description": "", "typeRef": "string" }, { "name": "namedBudgets", "type": "array", "optional": false, "description": "", "typeRef": "Storage.AttributionReportingNamedBudgetCandidate" }]);
    inspectorBackend.registerType("Storage.RelatedWebsiteSet", [{ "name": "primarySites", "type": "array", "optional": false, "description": "The primary site of this set, along with the ccTLDs if there is any.", "typeRef": "string" }, { "name": "associatedSites", "type": "array", "optional": false, "description": "The associated sites of this set, along with the ccTLDs if there is any.", "typeRef": "string" }, { "name": "serviceSites", "type": "array", "optional": false, "description": "The service sites of this set, along with the ccTLDs if there is any.", "typeRef": "string" }]);
    // SystemInfo.
    inspectorBackend.registerEnum("SystemInfo.SubsamplingFormat", { Yuv420: "yuv420", Yuv422: "yuv422", Yuv444: "yuv444" });
    inspectorBackend.registerEnum("SystemInfo.ImageType", { Jpeg: "jpeg", Webp: "webp", Unknown: "unknown" });
    inspectorBackend.registerCommand("SystemInfo.getInfo", [], ["gpu", "modelName", "modelVersion", "commandLine"], "Returns information about the system.");
    inspectorBackend.registerCommand("SystemInfo.getFeatureState", [{ "name": "featureState", "type": "string", "optional": false, "description": "", "typeRef": null }], ["featureEnabled"], "Returns information about the feature state.");
    inspectorBackend.registerCommand("SystemInfo.getProcessInfo", [], ["processInfo"], "Returns information about all running processes.");
    inspectorBackend.registerType("SystemInfo.GPUDevice", [{ "name": "vendorId", "type": "number", "optional": false, "description": "PCI ID of the GPU vendor, if available; 0 otherwise.", "typeRef": null }, { "name": "deviceId", "type": "number", "optional": false, "description": "PCI ID of the GPU device, if available; 0 otherwise.", "typeRef": null }, { "name": "subSysId", "type": "number", "optional": true, "description": "Sub sys ID of the GPU, only available on Windows.", "typeRef": null }, { "name": "revision", "type": "number", "optional": true, "description": "Revision of the GPU, only available on Windows.", "typeRef": null }, { "name": "vendorString", "type": "string", "optional": false, "description": "String description of the GPU vendor, if the PCI ID is not available.", "typeRef": null }, { "name": "deviceString", "type": "string", "optional": false, "description": "String description of the GPU device, if the PCI ID is not available.", "typeRef": null }, { "name": "driverVendor", "type": "string", "optional": false, "description": "String description of the GPU driver vendor.", "typeRef": null }, { "name": "driverVersion", "type": "string", "optional": false, "description": "String description of the GPU driver version.", "typeRef": null }]);
    inspectorBackend.registerType("SystemInfo.Size", [{ "name": "width", "type": "number", "optional": false, "description": "Width in pixels.", "typeRef": null }, { "name": "height", "type": "number", "optional": false, "description": "Height in pixels.", "typeRef": null }]);
    inspectorBackend.registerType("SystemInfo.VideoDecodeAcceleratorCapability", [{ "name": "profile", "type": "string", "optional": false, "description": "Video codec profile that is supported, e.g. VP9 Profile 2.", "typeRef": null }, { "name": "maxResolution", "type": "object", "optional": false, "description": "Maximum video dimensions in pixels supported for this |profile|.", "typeRef": "SystemInfo.Size" }, { "name": "minResolution", "type": "object", "optional": false, "description": "Minimum video dimensions in pixels supported for this |profile|.", "typeRef": "SystemInfo.Size" }]);
    inspectorBackend.registerType("SystemInfo.VideoEncodeAcceleratorCapability", [{ "name": "profile", "type": "string", "optional": false, "description": "Video codec profile that is supported, e.g H264 Main.", "typeRef": null }, { "name": "maxResolution", "type": "object", "optional": false, "description": "Maximum video dimensions in pixels supported for this |profile|.", "typeRef": "SystemInfo.Size" }, { "name": "maxFramerateNumerator", "type": "number", "optional": false, "description": "Maximum encoding framerate in frames per second supported for this |profile|, as fraction's numerator and denominator, e.g. 24/1 fps, 24000/1001 fps, etc.", "typeRef": null }, { "name": "maxFramerateDenominator", "type": "number", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("SystemInfo.ImageDecodeAcceleratorCapability", [{ "name": "imageType", "type": "string", "optional": false, "description": "Image coded, e.g. Jpeg.", "typeRef": "SystemInfo.ImageType" }, { "name": "maxDimensions", "type": "object", "optional": false, "description": "Maximum supported dimensions of the image in pixels.", "typeRef": "SystemInfo.Size" }, { "name": "minDimensions", "type": "object", "optional": false, "description": "Minimum supported dimensions of the image in pixels.", "typeRef": "SystemInfo.Size" }, { "name": "subsamplings", "type": "array", "optional": false, "description": "Optional array of supported subsampling formats, e.g. 4:2:0, if known.", "typeRef": "SystemInfo.SubsamplingFormat" }]);
    inspectorBackend.registerType("SystemInfo.GPUInfo", [{ "name": "devices", "type": "array", "optional": false, "description": "The graphics devices on the system. Element 0 is the primary GPU.", "typeRef": "SystemInfo.GPUDevice" }, { "name": "auxAttributes", "type": "object", "optional": true, "description": "An optional dictionary of additional GPU related attributes.", "typeRef": null }, { "name": "featureStatus", "type": "object", "optional": true, "description": "An optional dictionary of graphics features and their status.", "typeRef": null }, { "name": "driverBugWorkarounds", "type": "array", "optional": false, "description": "An optional array of GPU driver bug workarounds.", "typeRef": "string" }, { "name": "videoDecoding", "type": "array", "optional": false, "description": "Supported accelerated video decoding capabilities.", "typeRef": "SystemInfo.VideoDecodeAcceleratorCapability" }, { "name": "videoEncoding", "type": "array", "optional": false, "description": "Supported accelerated video encoding capabilities.", "typeRef": "SystemInfo.VideoEncodeAcceleratorCapability" }, { "name": "imageDecoding", "type": "array", "optional": false, "description": "Supported accelerated image decoding capabilities.", "typeRef": "SystemInfo.ImageDecodeAcceleratorCapability" }]);
    inspectorBackend.registerType("SystemInfo.ProcessInfo", [{ "name": "type", "type": "string", "optional": false, "description": "Specifies process type.", "typeRef": null }, { "name": "id", "type": "number", "optional": false, "description": "Specifies process id.", "typeRef": null }, { "name": "cpuTime", "type": "number", "optional": false, "description": "Specifies cumulative CPU usage in seconds across all threads of the process since the process start.", "typeRef": null }]);
    // Target.
    inspectorBackend.registerEnum("Target.WindowState", { Normal: "normal", Minimized: "minimized", Maximized: "maximized", Fullscreen: "fullscreen" });
    inspectorBackend.registerEvent("Target.attachedToTarget", ["sessionId", "targetInfo", "waitingForDebugger"]);
    inspectorBackend.registerEvent("Target.detachedFromTarget", ["sessionId", "targetId"]);
    inspectorBackend.registerEvent("Target.receivedMessageFromTarget", ["sessionId", "message", "targetId"]);
    inspectorBackend.registerEvent("Target.targetCreated", ["targetInfo"]);
    inspectorBackend.registerEvent("Target.targetDestroyed", ["targetId"]);
    inspectorBackend.registerEvent("Target.targetCrashed", ["targetId", "status", "errorCode"]);
    inspectorBackend.registerEvent("Target.targetInfoChanged", ["targetInfo"]);
    inspectorBackend.registerCommand("Target.activateTarget", [{ "name": "targetId", "type": "string", "optional": false, "description": "", "typeRef": "Target.TargetID" }], [], "Activates (focuses) the target.");
    inspectorBackend.registerCommand("Target.attachToTarget", [{ "name": "targetId", "type": "string", "optional": false, "description": "", "typeRef": "Target.TargetID" }, { "name": "flatten", "type": "boolean", "optional": true, "description": "Enables \\\"flat\\\" access to the session via specifying sessionId attribute in the commands. We plan to make this the default, deprecate non-flattened mode, and eventually retire it. See crbug.com/991325.", "typeRef": null }], ["sessionId"], "Attaches to the target with given id.");
    inspectorBackend.registerCommand("Target.attachToBrowserTarget", [], ["sessionId"], "Attaches to the browser target, only uses flat sessionId mode.");
    inspectorBackend.registerCommand("Target.closeTarget", [{ "name": "targetId", "type": "string", "optional": false, "description": "", "typeRef": "Target.TargetID" }], ["success"], "Closes the target. If the target is a page that gets closed too.");
    inspectorBackend.registerCommand("Target.exposeDevToolsProtocol", [{ "name": "targetId", "type": "string", "optional": false, "description": "", "typeRef": "Target.TargetID" }, { "name": "bindingName", "type": "string", "optional": true, "description": "Binding name, 'cdp' if not specified.", "typeRef": null }, { "name": "inheritPermissions", "type": "boolean", "optional": true, "description": "If true, inherits the current root session's permissions (default: false).", "typeRef": null }], [], "Inject object to the target's main frame that provides a communication channel with browser target.  Injected object will be available as `window[bindingName]`.  The object has the following API: - `binding.send(json)` - a method to send messages over the remote debugging protocol - `binding.onmessage = json => handleMessage(json)` - a callback that will be called for the protocol notifications and command responses.");
    inspectorBackend.registerCommand("Target.createBrowserContext", [{ "name": "disposeOnDetach", "type": "boolean", "optional": true, "description": "If specified, disposes this context when debugging session disconnects.", "typeRef": null }, { "name": "proxyServer", "type": "string", "optional": true, "description": "Proxy server, similar to the one passed to --proxy-server", "typeRef": null }, { "name": "proxyBypassList", "type": "string", "optional": true, "description": "Proxy bypass list, similar to the one passed to --proxy-bypass-list", "typeRef": null }, { "name": "originsWithUniversalNetworkAccess", "type": "array", "optional": true, "description": "An optional list of origins to grant unlimited cross-origin access to. Parts of the URL other than those constituting origin are ignored.", "typeRef": "string" }], ["browserContextId"], "Creates a new empty BrowserContext. Similar to an incognito profile but you can have more than one.");
    inspectorBackend.registerCommand("Target.getBrowserContexts", [], ["browserContextIds"], "Returns all browser contexts created with `Target.createBrowserContext` method.");
    inspectorBackend.registerCommand("Target.createTarget", [{ "name": "url", "type": "string", "optional": false, "description": "The initial URL the page will be navigated to. An empty string indicates about:blank.", "typeRef": null }, { "name": "left", "type": "number", "optional": true, "description": "Frame left origin in DIP (requires newWindow to be true or headless shell).", "typeRef": null }, { "name": "top", "type": "number", "optional": true, "description": "Frame top origin in DIP (requires newWindow to be true or headless shell).", "typeRef": null }, { "name": "width", "type": "number", "optional": true, "description": "Frame width in DIP (requires newWindow to be true or headless shell).", "typeRef": null }, { "name": "height", "type": "number", "optional": true, "description": "Frame height in DIP (requires newWindow to be true or headless shell).", "typeRef": null }, { "name": "windowState", "type": "string", "optional": true, "description": "Frame window state (requires newWindow to be true or headless shell). Default is normal.", "typeRef": "Target.WindowState" }, { "name": "browserContextId", "type": "string", "optional": true, "description": "The browser context to create the page in.", "typeRef": "Browser.BrowserContextID" }, { "name": "enableBeginFrameControl", "type": "boolean", "optional": true, "description": "Whether BeginFrames for this target will be controlled via DevTools (headless shell only, not supported on MacOS yet, false by default).", "typeRef": null }, { "name": "newWindow", "type": "boolean", "optional": true, "description": "Whether to create a new Window or Tab (false by default, not supported by headless shell).", "typeRef": null }, { "name": "background", "type": "boolean", "optional": true, "description": "Whether to create the target in background or foreground (false by default, not supported by headless shell).", "typeRef": null }, { "name": "forTab", "type": "boolean", "optional": true, "description": "Whether to create the target of type \\\"tab\\\".", "typeRef": null }, { "name": "hidden", "type": "boolean", "optional": true, "description": "Whether to create a hidden target. The hidden target is observable via protocol, but not present in the tab UI strip. Cannot be created with `forTab: true`, `newWindow: true` or `background: false`. The life-time of the tab is limited to the life-time of the session.", "typeRef": null }], ["targetId"], "Creates a new page.");
    inspectorBackend.registerCommand("Target.detachFromTarget", [{ "name": "sessionId", "type": "string", "optional": true, "description": "Session to detach.", "typeRef": "Target.SessionID" }, { "name": "targetId", "type": "string", "optional": true, "description": "Deprecated.", "typeRef": "Target.TargetID" }], [], "Detaches session with given id.");
    inspectorBackend.registerCommand("Target.disposeBrowserContext", [{ "name": "browserContextId", "type": "string", "optional": false, "description": "", "typeRef": "Browser.BrowserContextID" }], [], "Deletes a BrowserContext. All the belonging pages will be closed without calling their beforeunload hooks.");
    inspectorBackend.registerCommand("Target.getTargetInfo", [{ "name": "targetId", "type": "string", "optional": true, "description": "", "typeRef": "Target.TargetID" }], ["targetInfo"], "Returns information about a target.");
    inspectorBackend.registerCommand("Target.getTargets", [{ "name": "filter", "type": "array", "optional": true, "description": "Only targets matching filter will be reported. If filter is not specified and target discovery is currently enabled, a filter used for target discovery is used for consistency.", "typeRef": "Target.TargetFilter" }], ["targetInfos"], "Retrieves a list of available targets.");
    inspectorBackend.registerCommand("Target.sendMessageToTarget", [{ "name": "message", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "sessionId", "type": "string", "optional": true, "description": "Identifier of the session.", "typeRef": "Target.SessionID" }, { "name": "targetId", "type": "string", "optional": true, "description": "Deprecated.", "typeRef": "Target.TargetID" }], [], "Sends protocol message over session with given id. Consider using flat mode instead; see commands attachToTarget, setAutoAttach, and crbug.com/991325.");
    inspectorBackend.registerCommand("Target.setAutoAttach", [{ "name": "autoAttach", "type": "boolean", "optional": false, "description": "Whether to auto-attach to related targets.", "typeRef": null }, { "name": "waitForDebuggerOnStart", "type": "boolean", "optional": false, "description": "Whether to pause new targets when attaching to them. Use `Runtime.runIfWaitingForDebugger` to run paused targets.", "typeRef": null }, { "name": "flatten", "type": "boolean", "optional": true, "description": "Enables \\\"flat\\\" access to the session via specifying sessionId attribute in the commands. We plan to make this the default, deprecate non-flattened mode, and eventually retire it. See crbug.com/991325.", "typeRef": null }, { "name": "filter", "type": "array", "optional": true, "description": "Only targets matching filter will be attached.", "typeRef": "Target.TargetFilter" }], [], "Controls whether to automatically attach to new targets which are considered to be directly related to this one (for example, iframes or workers). When turned on, attaches to all existing related targets as well. When turned off, automatically detaches from all currently attached targets. This also clears all targets added by `autoAttachRelated` from the list of targets to watch for creation of related targets. You might want to call this recursively for auto-attached targets to attach to all available targets.");
    inspectorBackend.registerCommand("Target.autoAttachRelated", [{ "name": "targetId", "type": "string", "optional": false, "description": "", "typeRef": "Target.TargetID" }, { "name": "waitForDebuggerOnStart", "type": "boolean", "optional": false, "description": "Whether to pause new targets when attaching to them. Use `Runtime.runIfWaitingForDebugger` to run paused targets.", "typeRef": null }, { "name": "filter", "type": "array", "optional": true, "description": "Only targets matching filter will be attached.", "typeRef": "Target.TargetFilter" }], [], "Adds the specified target to the list of targets that will be monitored for any related target creation (such as child frames, child workers and new versions of service worker) and reported through `attachedToTarget`. The specified target is also auto-attached. This cancels the effect of any previous `setAutoAttach` and is also cancelled by subsequent `setAutoAttach`. Only available at the Browser target.");
    inspectorBackend.registerCommand("Target.setDiscoverTargets", [{ "name": "discover", "type": "boolean", "optional": false, "description": "Whether to discover available targets.", "typeRef": null }, { "name": "filter", "type": "array", "optional": true, "description": "Only targets matching filter will be attached. If `discover` is false, `filter` must be omitted or empty.", "typeRef": "Target.TargetFilter" }], [], "Controls whether to discover available targets and notify via `targetCreated/targetInfoChanged/targetDestroyed` events.");
    inspectorBackend.registerCommand("Target.setRemoteLocations", [{ "name": "locations", "type": "array", "optional": false, "description": "List of remote locations.", "typeRef": "Target.RemoteLocation" }], [], "Enables target discovery for the specified locations, when `setDiscoverTargets` was set to `true`.");
    inspectorBackend.registerCommand("Target.openDevTools", [{ "name": "targetId", "type": "string", "optional": false, "description": "This can be the page or tab target ID.", "typeRef": "Target.TargetID" }], ["targetId"], "Opens a DevTools window for the target.");
    inspectorBackend.registerType("Target.TargetInfo", [{ "name": "targetId", "type": "string", "optional": false, "description": "", "typeRef": "Target.TargetID" }, { "name": "type", "type": "string", "optional": false, "description": "List of types: https://source.chromium.org/chromium/chromium/src/+/main:content/browser/devtools/devtools_agent_host_impl.cc?ss=chromium&q=f:devtools%20-f:out%20%22::kTypeTab%5B%5D%22", "typeRef": null }, { "name": "title", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "url", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "attached", "type": "boolean", "optional": false, "description": "Whether the target has an attached client.", "typeRef": null }, { "name": "openerId", "type": "string", "optional": true, "description": "Opener target Id", "typeRef": "Target.TargetID" }, { "name": "canAccessOpener", "type": "boolean", "optional": false, "description": "Whether the target has access to the originating window.", "typeRef": null }, { "name": "openerFrameId", "type": "string", "optional": true, "description": "Frame id of originating window (is only set if target has an opener).", "typeRef": "Page.FrameId" }, { "name": "parentFrameId", "type": "string", "optional": true, "description": "Id of the parent frame, only present for the \\\"iframe\\\" targets.", "typeRef": "Page.FrameId" }, { "name": "browserContextId", "type": "string", "optional": true, "description": "", "typeRef": "Browser.BrowserContextID" }, { "name": "subtype", "type": "string", "optional": true, "description": "Provides additional details for specific target types. For example, for the type of \\\"page\\\", this may be set to \\\"prerender\\\".", "typeRef": null }]);
    inspectorBackend.registerType("Target.FilterEntry", [{ "name": "exclude", "type": "boolean", "optional": true, "description": "If set, causes exclusion of matching targets from the list.", "typeRef": null }, { "name": "type", "type": "string", "optional": true, "description": "If not present, matches any type.", "typeRef": null }]);
    inspectorBackend.registerType("Target.TargetFilter", [{ "name": "TargetFilter", "type": "array", "optional": false, "description": "The entries in TargetFilter are matched sequentially against targets and the first entry that matches determines if the target is included or not, depending on the value of `exclude` field in the entry. If filter is not specified, the one assumed is [{type: \\\"browser\\\", exclude: true}, {type: \\\"tab\\\", exclude: true}, {}] (i.e. include everything but `browser` and `tab`).", "typeRef": "Target.FilterEntry" }]);
    inspectorBackend.registerType("Target.RemoteLocation", [{ "name": "host", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "port", "type": "number", "optional": false, "description": "", "typeRef": null }]);
    // Tethering.
    inspectorBackend.registerEvent("Tethering.accepted", ["port", "connectionId"]);
    inspectorBackend.registerCommand("Tethering.bind", [{ "name": "port", "type": "number", "optional": false, "description": "Port number to bind.", "typeRef": null }], [], "Request browser port binding.");
    inspectorBackend.registerCommand("Tethering.unbind", [{ "name": "port", "type": "number", "optional": false, "description": "Port number to unbind.", "typeRef": null }], [], "Request browser port unbinding.");
    // Tracing.
    inspectorBackend.registerEnum("Tracing.TraceConfigRecordMode", { RecordUntilFull: "recordUntilFull", RecordContinuously: "recordContinuously", RecordAsMuchAsPossible: "recordAsMuchAsPossible", EchoToConsole: "echoToConsole" });
    inspectorBackend.registerEnum("Tracing.StreamFormat", { Json: "json", Proto: "proto" });
    inspectorBackend.registerEnum("Tracing.StreamCompression", { None: "none", Gzip: "gzip" });
    inspectorBackend.registerEnum("Tracing.MemoryDumpLevelOfDetail", { Background: "background", Light: "light", Detailed: "detailed" });
    inspectorBackend.registerEnum("Tracing.TracingBackend", { Auto: "auto", Chrome: "chrome", System: "system" });
    inspectorBackend.registerEvent("Tracing.bufferUsage", ["percentFull", "eventCount", "value"]);
    inspectorBackend.registerEvent("Tracing.dataCollected", ["value"]);
    inspectorBackend.registerEvent("Tracing.tracingComplete", ["dataLossOccurred", "stream", "traceFormat", "streamCompression"]);
    inspectorBackend.registerCommand("Tracing.end", [], [], "Stop trace events collection.");
    inspectorBackend.registerCommand("Tracing.getCategories", [], ["categories"], "Gets supported tracing categories.");
    inspectorBackend.registerCommand("Tracing.recordClockSyncMarker", [{ "name": "syncId", "type": "string", "optional": false, "description": "The ID of this clock sync marker", "typeRef": null }], [], "Record a clock sync marker in the trace.");
    inspectorBackend.registerCommand("Tracing.requestMemoryDump", [{ "name": "deterministic", "type": "boolean", "optional": true, "description": "Enables more deterministic results by forcing garbage collection", "typeRef": null }, { "name": "levelOfDetail", "type": "string", "optional": true, "description": "Specifies level of details in memory dump. Defaults to \\\"detailed\\\".", "typeRef": "Tracing.MemoryDumpLevelOfDetail" }], ["dumpGuid", "success"], "Request a global memory dump.");
    inspectorBackend.registerEnum("Tracing.StartRequestTransferMode", { ReportEvents: "ReportEvents", ReturnAsStream: "ReturnAsStream" });
    inspectorBackend.registerCommand("Tracing.start", [{ "name": "categories", "type": "string", "optional": true, "description": "Category/tag filter", "typeRef": null }, { "name": "options", "type": "string", "optional": true, "description": "Tracing options", "typeRef": null }, { "name": "bufferUsageReportingInterval", "type": "number", "optional": true, "description": "If set, the agent will issue bufferUsage events at this interval, specified in milliseconds", "typeRef": null }, { "name": "transferMode", "type": "string", "optional": true, "description": "Whether to report trace events as series of dataCollected events or to save trace to a stream (defaults to `ReportEvents`).", "typeRef": "Tracing.StartRequestTransferMode" }, { "name": "streamFormat", "type": "string", "optional": true, "description": "Trace data format to use. This only applies when using `ReturnAsStream` transfer mode (defaults to `json`).", "typeRef": "Tracing.StreamFormat" }, { "name": "streamCompression", "type": "string", "optional": true, "description": "Compression format to use. This only applies when using `ReturnAsStream` transfer mode (defaults to `none`)", "typeRef": "Tracing.StreamCompression" }, { "name": "traceConfig", "type": "object", "optional": true, "description": "", "typeRef": "Tracing.TraceConfig" }, { "name": "perfettoConfig", "type": "string", "optional": true, "description": "Base64-encoded serialized perfetto.protos.TraceConfig protobuf message When specified, the parameters `categories`, `options`, `traceConfig` are ignored.", "typeRef": null }, { "name": "tracingBackend", "type": "string", "optional": true, "description": "Backend type (defaults to `auto`)", "typeRef": "Tracing.TracingBackend" }], [], "Start trace events collection.");
    inspectorBackend.registerType("Tracing.TraceConfig", [{ "name": "recordMode", "type": "string", "optional": true, "description": "Controls how the trace buffer stores data. The default is `recordUntilFull`.", "typeRef": null }, { "name": "traceBufferSizeInKb", "type": "number", "optional": true, "description": "Size of the trace buffer in kilobytes. If not specified or zero is passed, a default value of 200 MB would be used.", "typeRef": null }, { "name": "enableSampling", "type": "boolean", "optional": true, "description": "Turns on JavaScript stack sampling.", "typeRef": null }, { "name": "enableSystrace", "type": "boolean", "optional": true, "description": "Turns on system tracing.", "typeRef": null }, { "name": "enableArgumentFilter", "type": "boolean", "optional": true, "description": "Turns on argument filter.", "typeRef": null }, { "name": "includedCategories", "type": "array", "optional": true, "description": "Included category filters.", "typeRef": "string" }, { "name": "excludedCategories", "type": "array", "optional": true, "description": "Excluded category filters.", "typeRef": "string" }, { "name": "syntheticDelays", "type": "array", "optional": true, "description": "Configuration to synthesize the delays in tracing.", "typeRef": "string" }, { "name": "memoryDumpConfig", "type": "object", "optional": true, "description": "Configuration for memory dump triggers. Used only when \\\"memory-infra\\\" category is enabled.", "typeRef": "Tracing.MemoryDumpConfig" }]);
    // WebAudio.
    inspectorBackend.registerEnum("WebAudio.ContextType", { Realtime: "realtime", Offline: "offline" });
    inspectorBackend.registerEnum("WebAudio.ContextState", { Suspended: "suspended", Running: "running", Closed: "closed", Interrupted: "interrupted" });
    inspectorBackend.registerEnum("WebAudio.ChannelCountMode", { ClampedMax: "clamped-max", Explicit: "explicit", Max: "max" });
    inspectorBackend.registerEnum("WebAudio.ChannelInterpretation", { Discrete: "discrete", Speakers: "speakers" });
    inspectorBackend.registerEnum("WebAudio.AutomationRate", { ARate: "a-rate", KRate: "k-rate" });
    inspectorBackend.registerEvent("WebAudio.contextCreated", ["context"]);
    inspectorBackend.registerEvent("WebAudio.contextWillBeDestroyed", ["contextId"]);
    inspectorBackend.registerEvent("WebAudio.contextChanged", ["context"]);
    inspectorBackend.registerEvent("WebAudio.audioListenerCreated", ["listener"]);
    inspectorBackend.registerEvent("WebAudio.audioListenerWillBeDestroyed", ["contextId", "listenerId"]);
    inspectorBackend.registerEvent("WebAudio.audioNodeCreated", ["node"]);
    inspectorBackend.registerEvent("WebAudio.audioNodeWillBeDestroyed", ["contextId", "nodeId"]);
    inspectorBackend.registerEvent("WebAudio.audioParamCreated", ["param"]);
    inspectorBackend.registerEvent("WebAudio.audioParamWillBeDestroyed", ["contextId", "nodeId", "paramId"]);
    inspectorBackend.registerEvent("WebAudio.nodesConnected", ["contextId", "sourceId", "destinationId", "sourceOutputIndex", "destinationInputIndex"]);
    inspectorBackend.registerEvent("WebAudio.nodesDisconnected", ["contextId", "sourceId", "destinationId", "sourceOutputIndex", "destinationInputIndex"]);
    inspectorBackend.registerEvent("WebAudio.nodeParamConnected", ["contextId", "sourceId", "destinationId", "sourceOutputIndex"]);
    inspectorBackend.registerEvent("WebAudio.nodeParamDisconnected", ["contextId", "sourceId", "destinationId", "sourceOutputIndex"]);
    inspectorBackend.registerCommand("WebAudio.enable", [], [], "Enables the WebAudio domain and starts sending context lifetime events.");
    inspectorBackend.registerCommand("WebAudio.disable", [], [], "Disables the WebAudio domain.");
    inspectorBackend.registerCommand("WebAudio.getRealtimeData", [{ "name": "contextId", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.GraphObjectId" }], ["realtimeData"], "Fetch the realtime data from the registered contexts.");
    inspectorBackend.registerType("WebAudio.ContextRealtimeData", [{ "name": "currentTime", "type": "number", "optional": false, "description": "The current context time in second in BaseAudioContext.", "typeRef": null }, { "name": "renderCapacity", "type": "number", "optional": false, "description": "The time spent on rendering graph divided by render quantum duration, and multiplied by 100. 100 means the audio renderer reached the full capacity and glitch may occur.", "typeRef": null }, { "name": "callbackIntervalMean", "type": "number", "optional": false, "description": "A running mean of callback interval.", "typeRef": null }, { "name": "callbackIntervalVariance", "type": "number", "optional": false, "description": "A running variance of callback interval.", "typeRef": null }]);
    inspectorBackend.registerType("WebAudio.BaseAudioContext", [{ "name": "contextId", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.GraphObjectId" }, { "name": "contextType", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.ContextType" }, { "name": "contextState", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.ContextState" }, { "name": "realtimeData", "type": "object", "optional": true, "description": "", "typeRef": "WebAudio.ContextRealtimeData" }, { "name": "callbackBufferSize", "type": "number", "optional": false, "description": "Platform-dependent callback buffer size.", "typeRef": null }, { "name": "maxOutputChannelCount", "type": "number", "optional": false, "description": "Number of output channels supported by audio hardware in use.", "typeRef": null }, { "name": "sampleRate", "type": "number", "optional": false, "description": "Context sample rate.", "typeRef": null }]);
    inspectorBackend.registerType("WebAudio.AudioListener", [{ "name": "listenerId", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.GraphObjectId" }, { "name": "contextId", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.GraphObjectId" }]);
    inspectorBackend.registerType("WebAudio.AudioNode", [{ "name": "nodeId", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.GraphObjectId" }, { "name": "contextId", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.GraphObjectId" }, { "name": "nodeType", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.NodeType" }, { "name": "numberOfInputs", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "numberOfOutputs", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "channelCount", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "channelCountMode", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.ChannelCountMode" }, { "name": "channelInterpretation", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.ChannelInterpretation" }]);
    inspectorBackend.registerType("WebAudio.AudioParam", [{ "name": "paramId", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.GraphObjectId" }, { "name": "nodeId", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.GraphObjectId" }, { "name": "contextId", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.GraphObjectId" }, { "name": "paramType", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.ParamType" }, { "name": "rate", "type": "string", "optional": false, "description": "", "typeRef": "WebAudio.AutomationRate" }, { "name": "defaultValue", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "minValue", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "maxValue", "type": "number", "optional": false, "description": "", "typeRef": null }]);
    // WebAuthn.
    inspectorBackend.registerEnum("WebAuthn.AuthenticatorProtocol", { U2f: "u2f", Ctap2: "ctap2" });
    inspectorBackend.registerEnum("WebAuthn.Ctap2Version", { Ctap2_0: "ctap2_0", Ctap2_1: "ctap2_1" });
    inspectorBackend.registerEnum("WebAuthn.AuthenticatorTransport", { Usb: "usb", Nfc: "nfc", Ble: "ble", Cable: "cable", Internal: "internal" });
    inspectorBackend.registerEvent("WebAuthn.credentialAdded", ["authenticatorId", "credential"]);
    inspectorBackend.registerEvent("WebAuthn.credentialDeleted", ["authenticatorId", "credentialId"]);
    inspectorBackend.registerEvent("WebAuthn.credentialUpdated", ["authenticatorId", "credential"]);
    inspectorBackend.registerEvent("WebAuthn.credentialAsserted", ["authenticatorId", "credential"]);
    inspectorBackend.registerCommand("WebAuthn.enable", [{ "name": "enableUI", "type": "boolean", "optional": true, "description": "Whether to enable the WebAuthn user interface. Enabling the UI is recommended for debugging and demo purposes, as it is closer to the real experience. Disabling the UI is recommended for automated testing. Supported at the embedder's discretion if UI is available. Defaults to false.", "typeRef": null }], [], "Enable the WebAuthn domain and start intercepting credential storage and retrieval with a virtual authenticator.");
    inspectorBackend.registerCommand("WebAuthn.disable", [], [], "Disable the WebAuthn domain.");
    inspectorBackend.registerCommand("WebAuthn.addVirtualAuthenticator", [{ "name": "options", "type": "object", "optional": false, "description": "", "typeRef": "WebAuthn.VirtualAuthenticatorOptions" }], ["authenticatorId"], "Creates and adds a virtual authenticator.");
    inspectorBackend.registerCommand("WebAuthn.setResponseOverrideBits", [{ "name": "authenticatorId", "type": "string", "optional": false, "description": "", "typeRef": "WebAuthn.AuthenticatorId" }, { "name": "isBogusSignature", "type": "boolean", "optional": true, "description": "If isBogusSignature is set, overrides the signature in the authenticator response to be zero. Defaults to false.", "typeRef": null }, { "name": "isBadUV", "type": "boolean", "optional": true, "description": "If isBadUV is set, overrides the UV bit in the flags in the authenticator response to be zero. Defaults to false.", "typeRef": null }, { "name": "isBadUP", "type": "boolean", "optional": true, "description": "If isBadUP is set, overrides the UP bit in the flags in the authenticator response to be zero. Defaults to false.", "typeRef": null }], [], "Resets parameters isBogusSignature, isBadUV, isBadUP to false if they are not present.");
    inspectorBackend.registerCommand("WebAuthn.removeVirtualAuthenticator", [{ "name": "authenticatorId", "type": "string", "optional": false, "description": "", "typeRef": "WebAuthn.AuthenticatorId" }], [], "Removes the given authenticator.");
    inspectorBackend.registerCommand("WebAuthn.addCredential", [{ "name": "authenticatorId", "type": "string", "optional": false, "description": "", "typeRef": "WebAuthn.AuthenticatorId" }, { "name": "credential", "type": "object", "optional": false, "description": "", "typeRef": "WebAuthn.Credential" }], [], "Adds the credential to the specified authenticator.");
    inspectorBackend.registerCommand("WebAuthn.getCredential", [{ "name": "authenticatorId", "type": "string", "optional": false, "description": "", "typeRef": "WebAuthn.AuthenticatorId" }, { "name": "credentialId", "type": "string", "optional": false, "description": "", "typeRef": null }], ["credential"], "Returns a single credential stored in the given virtual authenticator that matches the credential ID.");
    inspectorBackend.registerCommand("WebAuthn.getCredentials", [{ "name": "authenticatorId", "type": "string", "optional": false, "description": "", "typeRef": "WebAuthn.AuthenticatorId" }], ["credentials"], "Returns all the credentials stored in the given virtual authenticator.");
    inspectorBackend.registerCommand("WebAuthn.removeCredential", [{ "name": "authenticatorId", "type": "string", "optional": false, "description": "", "typeRef": "WebAuthn.AuthenticatorId" }, { "name": "credentialId", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "Removes a credential from the authenticator.");
    inspectorBackend.registerCommand("WebAuthn.clearCredentials", [{ "name": "authenticatorId", "type": "string", "optional": false, "description": "", "typeRef": "WebAuthn.AuthenticatorId" }], [], "Clears all the credentials from the specified device.");
    inspectorBackend.registerCommand("WebAuthn.setUserVerified", [{ "name": "authenticatorId", "type": "string", "optional": false, "description": "", "typeRef": "WebAuthn.AuthenticatorId" }, { "name": "isUserVerified", "type": "boolean", "optional": false, "description": "", "typeRef": null }], [], "Sets whether User Verification succeeds or fails for an authenticator. The default is true.");
    inspectorBackend.registerCommand("WebAuthn.setAutomaticPresenceSimulation", [{ "name": "authenticatorId", "type": "string", "optional": false, "description": "", "typeRef": "WebAuthn.AuthenticatorId" }, { "name": "enabled", "type": "boolean", "optional": false, "description": "", "typeRef": null }], [], "Sets whether tests of user presence will succeed immediately (if true) or fail to resolve (if false) for an authenticator. The default is true.");
    inspectorBackend.registerCommand("WebAuthn.setCredentialProperties", [{ "name": "authenticatorId", "type": "string", "optional": false, "description": "", "typeRef": "WebAuthn.AuthenticatorId" }, { "name": "credentialId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "backupEligibility", "type": "boolean", "optional": true, "description": "", "typeRef": null }, { "name": "backupState", "type": "boolean", "optional": true, "description": "", "typeRef": null }], [], "Allows setting credential properties. https://w3c.github.io/webauthn/#sctn-automation-set-credential-properties");
    inspectorBackend.registerType("WebAuthn.VirtualAuthenticatorOptions", [{ "name": "protocol", "type": "string", "optional": false, "description": "", "typeRef": "WebAuthn.AuthenticatorProtocol" }, { "name": "ctap2Version", "type": "string", "optional": true, "description": "Defaults to ctap2_0. Ignored if |protocol| == u2f.", "typeRef": "WebAuthn.Ctap2Version" }, { "name": "transport", "type": "string", "optional": false, "description": "", "typeRef": "WebAuthn.AuthenticatorTransport" }, { "name": "hasResidentKey", "type": "boolean", "optional": true, "description": "Defaults to false.", "typeRef": null }, { "name": "hasUserVerification", "type": "boolean", "optional": true, "description": "Defaults to false.", "typeRef": null }, { "name": "hasLargeBlob", "type": "boolean", "optional": true, "description": "If set to true, the authenticator will support the largeBlob extension. https://w3c.github.io/webauthn#largeBlob Defaults to false.", "typeRef": null }, { "name": "hasCredBlob", "type": "boolean", "optional": true, "description": "If set to true, the authenticator will support the credBlob extension. https://fidoalliance.org/specs/fido-v2.1-rd-20201208/fido-client-to-authenticator-protocol-v2.1-rd-20201208.html#sctn-credBlob-extension Defaults to false.", "typeRef": null }, { "name": "hasMinPinLength", "type": "boolean", "optional": true, "description": "If set to true, the authenticator will support the minPinLength extension. https://fidoalliance.org/specs/fido-v2.1-ps-20210615/fido-client-to-authenticator-protocol-v2.1-ps-20210615.html#sctn-minpinlength-extension Defaults to false.", "typeRef": null }, { "name": "hasPrf", "type": "boolean", "optional": true, "description": "If set to true, the authenticator will support the prf extension. https://w3c.github.io/webauthn/#prf-extension Defaults to false.", "typeRef": null }, { "name": "automaticPresenceSimulation", "type": "boolean", "optional": true, "description": "If set to true, tests of user presence will succeed immediately. Otherwise, they will not be resolved. Defaults to true.", "typeRef": null }, { "name": "isUserVerified", "type": "boolean", "optional": true, "description": "Sets whether User Verification succeeds or fails for an authenticator. Defaults to false.", "typeRef": null }, { "name": "defaultBackupEligibility", "type": "boolean", "optional": true, "description": "Credentials created by this authenticator will have the backup eligibility (BE) flag set to this value. Defaults to false. https://w3c.github.io/webauthn/#sctn-credential-backup", "typeRef": null }, { "name": "defaultBackupState", "type": "boolean", "optional": true, "description": "Credentials created by this authenticator will have the backup state (BS) flag set to this value. Defaults to false. https://w3c.github.io/webauthn/#sctn-credential-backup", "typeRef": null }]);
    inspectorBackend.registerType("WebAuthn.Credential", [{ "name": "credentialId", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "isResidentCredential", "type": "boolean", "optional": false, "description": "", "typeRef": null }, { "name": "rpId", "type": "string", "optional": true, "description": "Relying Party ID the credential is scoped to. Must be set when adding a credential.", "typeRef": null }, { "name": "privateKey", "type": "string", "optional": false, "description": "The ECDSA P-256 private key in PKCS#8 format.", "typeRef": null }, { "name": "userHandle", "type": "string", "optional": true, "description": "An opaque byte sequence with a maximum size of 64 bytes mapping the credential to a specific user.", "typeRef": null }, { "name": "signCount", "type": "number", "optional": false, "description": "Signature counter. This is incremented by one for each successful assertion. See https://w3c.github.io/webauthn/#signature-counter", "typeRef": null }, { "name": "largeBlob", "type": "string", "optional": true, "description": "The large blob associated with the credential. See https://w3c.github.io/webauthn/#sctn-large-blob-extension", "typeRef": null }, { "name": "backupEligibility", "type": "boolean", "optional": true, "description": "Assertions returned by this credential will have the backup eligibility (BE) flag set to this value. Defaults to the authenticator's defaultBackupEligibility value.", "typeRef": null }, { "name": "backupState", "type": "boolean", "optional": true, "description": "Assertions returned by this credential will have the backup state (BS) flag set to this value. Defaults to the authenticator's defaultBackupState value.", "typeRef": null }, { "name": "userName", "type": "string", "optional": true, "description": "The credential's user.name property. Equivalent to empty if not set. https://w3c.github.io/webauthn/#dom-publickeycredentialentity-name", "typeRef": null }, { "name": "userDisplayName", "type": "string", "optional": true, "description": "The credential's user.displayName property. Equivalent to empty if not set. https://w3c.github.io/webauthn/#dom-publickeycredentialuserentity-displayname", "typeRef": null }]);
    // Debugger.
    inspectorBackend.registerEnum("Debugger.ScopeType", { Global: "global", Local: "local", With: "with", Closure: "closure", Catch: "catch", Block: "block", Script: "script", Eval: "eval", Module: "module", WasmExpressionStack: "wasm-expression-stack" });
    inspectorBackend.registerEnum("Debugger.BreakLocationType", { DebuggerStatement: "debuggerStatement", Call: "call", Return: "return" });
    inspectorBackend.registerEnum("Debugger.ScriptLanguage", { JavaScript: "JavaScript", WebAssembly: "WebAssembly" });
    inspectorBackend.registerEnum("Debugger.DebugSymbolsType", { SourceMap: "SourceMap", EmbeddedDWARF: "EmbeddedDWARF", ExternalDWARF: "ExternalDWARF" });
    inspectorBackend.registerEvent("Debugger.breakpointResolved", ["breakpointId", "location"]);
    inspectorBackend.registerEnum("Debugger.PausedEventReason", { Ambiguous: "ambiguous", Assert: "assert", CSPViolation: "CSPViolation", DebugCommand: "debugCommand", DOM: "DOM", EventListener: "EventListener", Exception: "exception", Instrumentation: "instrumentation", OOM: "OOM", Other: "other", PromiseRejection: "promiseRejection", XHR: "XHR", Step: "step" });
    inspectorBackend.registerEvent("Debugger.paused", ["callFrames", "reason", "data", "hitBreakpoints", "asyncStackTrace", "asyncStackTraceId", "asyncCallStackTraceId"]);
    inspectorBackend.registerEvent("Debugger.resumed", []);
    inspectorBackend.registerEvent("Debugger.scriptFailedToParse", ["scriptId", "url", "startLine", "startColumn", "endLine", "endColumn", "executionContextId", "hash", "buildId", "executionContextAuxData", "sourceMapURL", "hasSourceURL", "isModule", "length", "stackTrace", "codeOffset", "scriptLanguage", "embedderName"]);
    inspectorBackend.registerEvent("Debugger.scriptParsed", ["scriptId", "url", "startLine", "startColumn", "endLine", "endColumn", "executionContextId", "hash", "buildId", "executionContextAuxData", "isLiveEdit", "sourceMapURL", "hasSourceURL", "isModule", "length", "stackTrace", "codeOffset", "scriptLanguage", "debugSymbols", "embedderName", "resolvedBreakpoints"]);
    inspectorBackend.registerEnum("Debugger.ContinueToLocationRequestTargetCallFrames", { Any: "any", Current: "current" });
    inspectorBackend.registerCommand("Debugger.continueToLocation", [{ "name": "location", "type": "object", "optional": false, "description": "Location to continue to.", "typeRef": "Debugger.Location" }, { "name": "targetCallFrames", "type": "string", "optional": true, "description": "", "typeRef": "Debugger.ContinueToLocationRequestTargetCallFrames" }], [], "Continues execution until specific location is reached.");
    inspectorBackend.registerCommand("Debugger.disable", [], [], "Disables debugger for given page.");
    inspectorBackend.registerCommand("Debugger.enable", [{ "name": "maxScriptsCacheSize", "type": "number", "optional": true, "description": "The maximum size in bytes of collected scripts (not referenced by other heap objects) the debugger can hold. Puts no limit if parameter is omitted.", "typeRef": null }], ["debuggerId"], "Enables debugger for the given page. Clients should not assume that the debugging has been enabled until the result for this command is received.");
    inspectorBackend.registerCommand("Debugger.evaluateOnCallFrame", [{ "name": "callFrameId", "type": "string", "optional": false, "description": "Call frame identifier to evaluate on.", "typeRef": "Debugger.CallFrameId" }, { "name": "expression", "type": "string", "optional": false, "description": "Expression to evaluate.", "typeRef": null }, { "name": "objectGroup", "type": "string", "optional": true, "description": "String object group name to put result into (allows rapid releasing resulting object handles using `releaseObjectGroup`).", "typeRef": null }, { "name": "includeCommandLineAPI", "type": "boolean", "optional": true, "description": "Specifies whether command line API should be available to the evaluated expression, defaults to false.", "typeRef": null }, { "name": "silent", "type": "boolean", "optional": true, "description": "In silent mode exceptions thrown during evaluation are not reported and do not pause execution. Overrides `setPauseOnException` state.", "typeRef": null }, { "name": "returnByValue", "type": "boolean", "optional": true, "description": "Whether the result is expected to be a JSON object that should be sent by value.", "typeRef": null }, { "name": "generatePreview", "type": "boolean", "optional": true, "description": "Whether preview should be generated for the result.", "typeRef": null }, { "name": "throwOnSideEffect", "type": "boolean", "optional": true, "description": "Whether to throw an exception if side effect cannot be ruled out during evaluation.", "typeRef": null }, { "name": "timeout", "type": "number", "optional": true, "description": "Terminate execution after timing out (number of milliseconds).", "typeRef": "Runtime.TimeDelta" }], ["result", "exceptionDetails"], "Evaluates expression on a given call frame.");
    inspectorBackend.registerCommand("Debugger.getPossibleBreakpoints", [{ "name": "start", "type": "object", "optional": false, "description": "Start of range to search possible breakpoint locations in.", "typeRef": "Debugger.Location" }, { "name": "end", "type": "object", "optional": true, "description": "End of range to search possible breakpoint locations in (excluding). When not specified, end of scripts is used as end of range.", "typeRef": "Debugger.Location" }, { "name": "restrictToFunction", "type": "boolean", "optional": true, "description": "Only consider locations which are in the same (non-nested) function as start.", "typeRef": null }], ["locations"], "Returns possible locations for breakpoint. scriptId in start and end range locations should be the same.");
    inspectorBackend.registerCommand("Debugger.getScriptSource", [{ "name": "scriptId", "type": "string", "optional": false, "description": "Id of the script to get source for.", "typeRef": "Runtime.ScriptId" }], ["scriptSource", "bytecode"], "Returns source for the script with given id.");
    inspectorBackend.registerCommand("Debugger.disassembleWasmModule", [{ "name": "scriptId", "type": "string", "optional": false, "description": "Id of the script to disassemble", "typeRef": "Runtime.ScriptId" }], ["streamId", "totalNumberOfLines", "functionBodyOffsets", "chunk"], "");
    inspectorBackend.registerCommand("Debugger.nextWasmDisassemblyChunk", [{ "name": "streamId", "type": "string", "optional": false, "description": "", "typeRef": null }], ["chunk"], "Disassemble the next chunk of lines for the module corresponding to the stream. If disassembly is complete, this API will invalidate the streamId and return an empty chunk. Any subsequent calls for the now invalid stream will return errors.");
    inspectorBackend.registerCommand("Debugger.getWasmBytecode", [{ "name": "scriptId", "type": "string", "optional": false, "description": "Id of the Wasm script to get source for.", "typeRef": "Runtime.ScriptId" }], ["bytecode"], "This command is deprecated. Use getScriptSource instead.");
    inspectorBackend.registerCommand("Debugger.getStackTrace", [{ "name": "stackTraceId", "type": "object", "optional": false, "description": "", "typeRef": "Runtime.StackTraceId" }], ["stackTrace"], "Returns stack trace with given `stackTraceId`.");
    inspectorBackend.registerCommand("Debugger.pause", [], [], "Stops on the next JavaScript statement.");
    inspectorBackend.registerCommand("Debugger.pauseOnAsyncCall", [{ "name": "parentStackTraceId", "type": "object", "optional": false, "description": "Debugger will pause when async call with given stack trace is started.", "typeRef": "Runtime.StackTraceId" }], [], "");
    inspectorBackend.registerCommand("Debugger.removeBreakpoint", [{ "name": "breakpointId", "type": "string", "optional": false, "description": "", "typeRef": "Debugger.BreakpointId" }], [], "Removes JavaScript breakpoint.");
    inspectorBackend.registerEnum("Debugger.RestartFrameRequestMode", { StepInto: "StepInto" });
    inspectorBackend.registerCommand("Debugger.restartFrame", [{ "name": "callFrameId", "type": "string", "optional": false, "description": "Call frame identifier to evaluate on.", "typeRef": "Debugger.CallFrameId" }, { "name": "mode", "type": "string", "optional": true, "description": "The `mode` parameter must be present and set to 'StepInto', otherwise `restartFrame` will error out.", "typeRef": "Debugger.RestartFrameRequestMode" }], ["callFrames", "asyncStackTrace", "asyncStackTraceId"], "Restarts particular call frame from the beginning. The old, deprecated behavior of `restartFrame` is to stay paused and allow further CDP commands after a restart was scheduled. This can cause problems with restarting, so we now continue execution immediatly after it has been scheduled until we reach the beginning of the restarted frame.  To stay back-wards compatible, `restartFrame` now expects a `mode` parameter to be present. If the `mode` parameter is missing, `restartFrame` errors out.  The various return values are deprecated and `callFrames` is always empty. Use the call frames from the `Debugger#paused` events instead, that fires once V8 pauses at the beginning of the restarted function.");
    inspectorBackend.registerCommand("Debugger.resume", [{ "name": "terminateOnResume", "type": "boolean", "optional": true, "description": "Set to true to terminate execution upon resuming execution. In contrast to Runtime.terminateExecution, this will allows to execute further JavaScript (i.e. via evaluation) until execution of the paused code is actually resumed, at which point termination is triggered. If execution is currently not paused, this parameter has no effect.", "typeRef": null }], [], "Resumes JavaScript execution.");
    inspectorBackend.registerCommand("Debugger.searchInContent", [{ "name": "scriptId", "type": "string", "optional": false, "description": "Id of the script to search in.", "typeRef": "Runtime.ScriptId" }, { "name": "query", "type": "string", "optional": false, "description": "String to search for.", "typeRef": null }, { "name": "caseSensitive", "type": "boolean", "optional": true, "description": "If true, search is case sensitive.", "typeRef": null }, { "name": "isRegex", "type": "boolean", "optional": true, "description": "If true, treats string parameter as regex.", "typeRef": null }], ["result"], "Searches for given string in script content.");
    inspectorBackend.registerCommand("Debugger.setAsyncCallStackDepth", [{ "name": "maxDepth", "type": "number", "optional": false, "description": "Maximum depth of async call stacks. Setting to `0` will effectively disable collecting async call stacks (default).", "typeRef": null }], [], "Enables or disables async call stacks tracking.");
    inspectorBackend.registerCommand("Debugger.setBlackboxExecutionContexts", [{ "name": "uniqueIds", "type": "array", "optional": false, "description": "Array of execution context unique ids for the debugger to ignore.", "typeRef": "string" }], [], "Replace previous blackbox execution contexts with passed ones. Forces backend to skip stepping/pausing in scripts in these execution contexts. VM will try to leave blackboxed script by performing 'step in' several times, finally resorting to 'step out' if unsuccessful.");
    inspectorBackend.registerCommand("Debugger.setBlackboxPatterns", [{ "name": "patterns", "type": "array", "optional": false, "description": "Array of regexps that will be used to check script url for blackbox state.", "typeRef": "string" }, { "name": "skipAnonymous", "type": "boolean", "optional": true, "description": "If true, also ignore scripts with no source url.", "typeRef": null }], [], "Replace previous blackbox patterns with passed ones. Forces backend to skip stepping/pausing in scripts with url matching one of the patterns. VM will try to leave blackboxed script by performing 'step in' several times, finally resorting to 'step out' if unsuccessful.");
    inspectorBackend.registerCommand("Debugger.setBlackboxedRanges", [{ "name": "scriptId", "type": "string", "optional": false, "description": "Id of the script.", "typeRef": "Runtime.ScriptId" }, { "name": "positions", "type": "array", "optional": false, "description": "", "typeRef": "Debugger.ScriptPosition" }], [], "Makes backend skip steps in the script in blackboxed ranges. VM will try leave blacklisted scripts by performing 'step in' several times, finally resorting to 'step out' if unsuccessful. Positions array contains positions where blackbox state is changed. First interval isn't blackboxed. Array should be sorted.");
    inspectorBackend.registerCommand("Debugger.setBreakpoint", [{ "name": "location", "type": "object", "optional": false, "description": "Location to set breakpoint in.", "typeRef": "Debugger.Location" }, { "name": "condition", "type": "string", "optional": true, "description": "Expression to use as a breakpoint condition. When specified, debugger will only stop on the breakpoint if this expression evaluates to true.", "typeRef": null }], ["breakpointId", "actualLocation"], "Sets JavaScript breakpoint at a given location.");
    inspectorBackend.registerEnum("Debugger.SetInstrumentationBreakpointRequestInstrumentation", { BeforeScriptExecution: "beforeScriptExecution", BeforeScriptWithSourceMapExecution: "beforeScriptWithSourceMapExecution" });
    inspectorBackend.registerCommand("Debugger.setInstrumentationBreakpoint", [{ "name": "instrumentation", "type": "string", "optional": false, "description": "Instrumentation name.", "typeRef": "Debugger.SetInstrumentationBreakpointRequestInstrumentation" }], ["breakpointId"], "Sets instrumentation breakpoint.");
    inspectorBackend.registerCommand("Debugger.setBreakpointByUrl", [{ "name": "lineNumber", "type": "number", "optional": false, "description": "Line number to set breakpoint at.", "typeRef": null }, { "name": "url", "type": "string", "optional": true, "description": "URL of the resources to set breakpoint on.", "typeRef": null }, { "name": "urlRegex", "type": "string", "optional": true, "description": "Regex pattern for the URLs of the resources to set breakpoints on. Either `url` or `urlRegex` must be specified.", "typeRef": null }, { "name": "scriptHash", "type": "string", "optional": true, "description": "Script hash of the resources to set breakpoint on.", "typeRef": null }, { "name": "columnNumber", "type": "number", "optional": true, "description": "Offset in the line to set breakpoint at.", "typeRef": null }, { "name": "condition", "type": "string", "optional": true, "description": "Expression to use as a breakpoint condition. When specified, debugger will only stop on the breakpoint if this expression evaluates to true.", "typeRef": null }], ["breakpointId", "locations"], "Sets JavaScript breakpoint at given location specified either by URL or URL regex. Once this command is issued, all existing parsed scripts will have breakpoints resolved and returned in `locations` property. Further matching script parsing will result in subsequent `breakpointResolved` events issued. This logical breakpoint will survive page reloads.");
    inspectorBackend.registerCommand("Debugger.setBreakpointOnFunctionCall", [{ "name": "objectId", "type": "string", "optional": false, "description": "Function object id.", "typeRef": "Runtime.RemoteObjectId" }, { "name": "condition", "type": "string", "optional": true, "description": "Expression to use as a breakpoint condition. When specified, debugger will stop on the breakpoint if this expression evaluates to true.", "typeRef": null }], ["breakpointId"], "Sets JavaScript breakpoint before each call to the given function. If another function was created from the same source as a given one, calling it will also trigger the breakpoint.");
    inspectorBackend.registerCommand("Debugger.setBreakpointsActive", [{ "name": "active", "type": "boolean", "optional": false, "description": "New value for breakpoints active state.", "typeRef": null }], [], "Activates / deactivates all breakpoints on the page.");
    inspectorBackend.registerEnum("Debugger.SetPauseOnExceptionsRequestState", { None: "none", Caught: "caught", Uncaught: "uncaught", All: "all" });
    inspectorBackend.registerCommand("Debugger.setPauseOnExceptions", [{ "name": "state", "type": "string", "optional": false, "description": "Pause on exceptions mode.", "typeRef": "Debugger.SetPauseOnExceptionsRequestState" }], [], "Defines pause on exceptions state. Can be set to stop on all exceptions, uncaught exceptions, or caught exceptions, no exceptions. Initial pause on exceptions state is `none`.");
    inspectorBackend.registerCommand("Debugger.setReturnValue", [{ "name": "newValue", "type": "object", "optional": false, "description": "New return value.", "typeRef": "Runtime.CallArgument" }], [], "Changes return value in top frame. Available only at return break position.");
    inspectorBackend.registerCommand("Debugger.setScriptSource", [{ "name": "scriptId", "type": "string", "optional": false, "description": "Id of the script to edit.", "typeRef": "Runtime.ScriptId" }, { "name": "scriptSource", "type": "string", "optional": false, "description": "New content of the script.", "typeRef": null }, { "name": "dryRun", "type": "boolean", "optional": true, "description": "If true the change will not actually be applied. Dry run may be used to get result description without actually modifying the code.", "typeRef": null }, { "name": "allowTopFrameEditing", "type": "boolean", "optional": true, "description": "If true, then `scriptSource` is allowed to change the function on top of the stack as long as the top-most stack frame is the only activation of that function.", "typeRef": null }], ["callFrames", "stackChanged", "asyncStackTrace", "asyncStackTraceId", "status", "exceptionDetails"], "Edits JavaScript source live.  In general, functions that are currently on the stack can not be edited with a single exception: If the edited function is the top-most stack frame and that is the only activation of that function on the stack. In this case the live edit will be successful and a `Debugger.restartFrame` for the top-most function is automatically triggered.");
    inspectorBackend.registerCommand("Debugger.setSkipAllPauses", [{ "name": "skip", "type": "boolean", "optional": false, "description": "New value for skip pauses state.", "typeRef": null }], [], "Makes page not interrupt on any pauses (breakpoint, exception, dom exception etc).");
    inspectorBackend.registerCommand("Debugger.setVariableValue", [{ "name": "scopeNumber", "type": "number", "optional": false, "description": "0-based number of scope as was listed in scope chain. Only 'local', 'closure' and 'catch' scope types are allowed. Other scopes could be manipulated manually.", "typeRef": null }, { "name": "variableName", "type": "string", "optional": false, "description": "Variable name.", "typeRef": null }, { "name": "newValue", "type": "object", "optional": false, "description": "New variable value.", "typeRef": "Runtime.CallArgument" }, { "name": "callFrameId", "type": "string", "optional": false, "description": "Id of callframe that holds variable.", "typeRef": "Debugger.CallFrameId" }], [], "Changes value of variable in a callframe. Object-based scopes are not supported and must be mutated manually.");
    inspectorBackend.registerCommand("Debugger.stepInto", [{ "name": "breakOnAsyncCall", "type": "boolean", "optional": true, "description": "Debugger will pause on the execution of the first async task which was scheduled before next pause.", "typeRef": null }, { "name": "skipList", "type": "array", "optional": true, "description": "The skipList specifies location ranges that should be skipped on step into.", "typeRef": "Debugger.LocationRange" }], [], "Steps into the function call.");
    inspectorBackend.registerCommand("Debugger.stepOut", [], [], "Steps out of the function call.");
    inspectorBackend.registerCommand("Debugger.stepOver", [{ "name": "skipList", "type": "array", "optional": true, "description": "The skipList specifies location ranges that should be skipped on step over.", "typeRef": "Debugger.LocationRange" }], [], "Steps over the statement.");
    inspectorBackend.registerType("Debugger.Location", [{ "name": "scriptId", "type": "string", "optional": false, "description": "Script identifier as reported in the `Debugger.scriptParsed`.", "typeRef": "Runtime.ScriptId" }, { "name": "lineNumber", "type": "number", "optional": false, "description": "Line number in the script (0-based).", "typeRef": null }, { "name": "columnNumber", "type": "number", "optional": true, "description": "Column number in the script (0-based).", "typeRef": null }]);
    inspectorBackend.registerType("Debugger.ScriptPosition", [{ "name": "lineNumber", "type": "number", "optional": false, "description": "", "typeRef": null }, { "name": "columnNumber", "type": "number", "optional": false, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Debugger.LocationRange", [{ "name": "scriptId", "type": "string", "optional": false, "description": "", "typeRef": "Runtime.ScriptId" }, { "name": "start", "type": "object", "optional": false, "description": "", "typeRef": "Debugger.ScriptPosition" }, { "name": "end", "type": "object", "optional": false, "description": "", "typeRef": "Debugger.ScriptPosition" }]);
    inspectorBackend.registerType("Debugger.CallFrame", [{ "name": "callFrameId", "type": "string", "optional": false, "description": "Call frame identifier. This identifier is only valid while the virtual machine is paused.", "typeRef": "Debugger.CallFrameId" }, { "name": "functionName", "type": "string", "optional": false, "description": "Name of the JavaScript function called on this call frame.", "typeRef": null }, { "name": "functionLocation", "type": "object", "optional": true, "description": "Location in the source code.", "typeRef": "Debugger.Location" }, { "name": "location", "type": "object", "optional": false, "description": "Location in the source code.", "typeRef": "Debugger.Location" }, { "name": "url", "type": "string", "optional": false, "description": "JavaScript script name or url. Deprecated in favor of using the `location.scriptId` to resolve the URL via a previously sent `Debugger.scriptParsed` event.", "typeRef": null }, { "name": "scopeChain", "type": "array", "optional": false, "description": "Scope chain for this call frame.", "typeRef": "Debugger.Scope" }, { "name": "this", "type": "object", "optional": false, "description": "`this` object for this call frame.", "typeRef": "Runtime.RemoteObject" }, { "name": "returnValue", "type": "object", "optional": true, "description": "The value being returned, if the function is at return point.", "typeRef": "Runtime.RemoteObject" }, { "name": "canBeRestarted", "type": "boolean", "optional": true, "description": "Valid only while the VM is paused and indicates whether this frame can be restarted or not. Note that a `true` value here does not guarantee that Debugger#restartFrame with this CallFrameId will be successful, but it is very likely.", "typeRef": null }]);
    inspectorBackend.registerType("Debugger.Scope", [{ "name": "type", "type": "string", "optional": false, "description": "Scope type.", "typeRef": null }, { "name": "object", "type": "object", "optional": false, "description": "Object representing the scope. For `global` and `with` scopes it represents the actual object; for the rest of the scopes, it is artificial transient object enumerating scope variables as its properties.", "typeRef": "Runtime.RemoteObject" }, { "name": "name", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "startLocation", "type": "object", "optional": true, "description": "Location in the source code where scope starts", "typeRef": "Debugger.Location" }, { "name": "endLocation", "type": "object", "optional": true, "description": "Location in the source code where scope ends", "typeRef": "Debugger.Location" }]);
    inspectorBackend.registerType("Debugger.SearchMatch", [{ "name": "lineNumber", "type": "number", "optional": false, "description": "Line number in resource content.", "typeRef": null }, { "name": "lineContent", "type": "string", "optional": false, "description": "Line with match content.", "typeRef": null }]);
    inspectorBackend.registerType("Debugger.BreakLocation", [{ "name": "scriptId", "type": "string", "optional": false, "description": "Script identifier as reported in the `Debugger.scriptParsed`.", "typeRef": "Runtime.ScriptId" }, { "name": "lineNumber", "type": "number", "optional": false, "description": "Line number in the script (0-based).", "typeRef": null }, { "name": "columnNumber", "type": "number", "optional": true, "description": "Column number in the script (0-based).", "typeRef": null }, { "name": "type", "type": "string", "optional": true, "description": "", "typeRef": null }]);
    inspectorBackend.registerType("Debugger.WasmDisassemblyChunk", [{ "name": "lines", "type": "array", "optional": false, "description": "The next chunk of disassembled lines.", "typeRef": "string" }, { "name": "bytecodeOffsets", "type": "array", "optional": false, "description": "The bytecode offsets describing the start of each line.", "typeRef": "integer" }]);
    inspectorBackend.registerType("Debugger.DebugSymbols", [{ "name": "type", "type": "string", "optional": false, "description": "Type of the debug symbols.", "typeRef": null }, { "name": "externalURL", "type": "string", "optional": true, "description": "URL of the external symbol source.", "typeRef": null }]);
    inspectorBackend.registerType("Debugger.ResolvedBreakpoint", [{ "name": "breakpointId", "type": "string", "optional": false, "description": "Breakpoint unique identifier.", "typeRef": "Debugger.BreakpointId" }, { "name": "location", "type": "object", "optional": false, "description": "Actual breakpoint location.", "typeRef": "Debugger.Location" }]);
    // HeapProfiler.
    inspectorBackend.registerEvent("HeapProfiler.addHeapSnapshotChunk", ["chunk"]);
    inspectorBackend.registerEvent("HeapProfiler.heapStatsUpdate", ["statsUpdate"]);
    inspectorBackend.registerEvent("HeapProfiler.lastSeenObjectId", ["lastSeenObjectId", "timestamp"]);
    inspectorBackend.registerEvent("HeapProfiler.reportHeapSnapshotProgress", ["done", "total", "finished"]);
    inspectorBackend.registerEvent("HeapProfiler.resetProfiles", []);
    inspectorBackend.registerCommand("HeapProfiler.addInspectedHeapObject", [{ "name": "heapObjectId", "type": "string", "optional": false, "description": "Heap snapshot object id to be accessible by means of $x command line API.", "typeRef": "HeapProfiler.HeapSnapshotObjectId" }], [], "Enables console to refer to the node with given id via $x (see Command Line API for more details $x functions).");
    inspectorBackend.registerCommand("HeapProfiler.collectGarbage", [], [], "");
    inspectorBackend.registerCommand("HeapProfiler.disable", [], [], "");
    inspectorBackend.registerCommand("HeapProfiler.enable", [], [], "");
    inspectorBackend.registerCommand("HeapProfiler.getHeapObjectId", [{ "name": "objectId", "type": "string", "optional": false, "description": "Identifier of the object to get heap object id for.", "typeRef": "Runtime.RemoteObjectId" }], ["heapSnapshotObjectId"], "");
    inspectorBackend.registerCommand("HeapProfiler.getObjectByHeapObjectId", [{ "name": "objectId", "type": "string", "optional": false, "description": "", "typeRef": "HeapProfiler.HeapSnapshotObjectId" }, { "name": "objectGroup", "type": "string", "optional": true, "description": "Symbolic group name that can be used to release multiple objects.", "typeRef": null }], ["result"], "");
    inspectorBackend.registerCommand("HeapProfiler.getSamplingProfile", [], ["profile"], "");
    inspectorBackend.registerCommand("HeapProfiler.startSampling", [{ "name": "samplingInterval", "type": "number", "optional": true, "description": "Average sample interval in bytes. Poisson distribution is used for the intervals. The default value is 32768 bytes.", "typeRef": null }, { "name": "stackDepth", "type": "number", "optional": true, "description": "Maximum stack depth. The default value is 128.", "typeRef": null }, { "name": "includeObjectsCollectedByMajorGC", "type": "boolean", "optional": true, "description": "By default, the sampling heap profiler reports only objects which are still alive when the profile is returned via getSamplingProfile or stopSampling, which is useful for determining what functions contribute the most to steady-state memory usage. This flag instructs the sampling heap profiler to also include information about objects discarded by major GC, which will show which functions cause large temporary memory usage or long GC pauses.", "typeRef": null }, { "name": "includeObjectsCollectedByMinorGC", "type": "boolean", "optional": true, "description": "By default, the sampling heap profiler reports only objects which are still alive when the profile is returned via getSamplingProfile or stopSampling, which is useful for determining what functions contribute the most to steady-state memory usage. This flag instructs the sampling heap profiler to also include information about objects discarded by minor GC, which is useful when tuning a latency-sensitive application for minimal GC activity.", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("HeapProfiler.startTrackingHeapObjects", [{ "name": "trackAllocations", "type": "boolean", "optional": true, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("HeapProfiler.stopSampling", [], ["profile"], "");
    inspectorBackend.registerCommand("HeapProfiler.stopTrackingHeapObjects", [{ "name": "reportProgress", "type": "boolean", "optional": true, "description": "If true 'reportHeapSnapshotProgress' events will be generated while snapshot is being taken when the tracking is stopped.", "typeRef": null }, { "name": "treatGlobalObjectsAsRoots", "type": "boolean", "optional": true, "description": "Deprecated in favor of `exposeInternals`.", "typeRef": null }, { "name": "captureNumericValue", "type": "boolean", "optional": true, "description": "If true, numerical values are included in the snapshot", "typeRef": null }, { "name": "exposeInternals", "type": "boolean", "optional": true, "description": "If true, exposes internals of the snapshot.", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("HeapProfiler.takeHeapSnapshot", [{ "name": "reportProgress", "type": "boolean", "optional": true, "description": "If true 'reportHeapSnapshotProgress' events will be generated while snapshot is being taken.", "typeRef": null }, { "name": "treatGlobalObjectsAsRoots", "type": "boolean", "optional": true, "description": "If true, a raw snapshot without artificial roots will be generated. Deprecated in favor of `exposeInternals`.", "typeRef": null }, { "name": "captureNumericValue", "type": "boolean", "optional": true, "description": "If true, numerical values are included in the snapshot", "typeRef": null }, { "name": "exposeInternals", "type": "boolean", "optional": true, "description": "If true, exposes internals of the snapshot.", "typeRef": null }], [], "");
    inspectorBackend.registerType("HeapProfiler.SamplingHeapProfileNode", [{ "name": "callFrame", "type": "object", "optional": false, "description": "Function location.", "typeRef": "Runtime.CallFrame" }, { "name": "selfSize", "type": "number", "optional": false, "description": "Allocations size in bytes for the node excluding children.", "typeRef": null }, { "name": "id", "type": "number", "optional": false, "description": "Node id. Ids are unique across all profiles collected between startSampling and stopSampling.", "typeRef": null }, { "name": "children", "type": "array", "optional": false, "description": "Child nodes.", "typeRef": "HeapProfiler.SamplingHeapProfileNode" }]);
    inspectorBackend.registerType("HeapProfiler.SamplingHeapProfileSample", [{ "name": "size", "type": "number", "optional": false, "description": "Allocation size in bytes attributed to the sample.", "typeRef": null }, { "name": "nodeId", "type": "number", "optional": false, "description": "Id of the corresponding profile tree node.", "typeRef": null }, { "name": "ordinal", "type": "number", "optional": false, "description": "Time-ordered sample ordinal number. It is unique across all profiles retrieved between startSampling and stopSampling.", "typeRef": null }]);
    inspectorBackend.registerType("HeapProfiler.SamplingHeapProfile", [{ "name": "head", "type": "object", "optional": false, "description": "", "typeRef": "HeapProfiler.SamplingHeapProfileNode" }, { "name": "samples", "type": "array", "optional": false, "description": "", "typeRef": "HeapProfiler.SamplingHeapProfileSample" }]);
    // Profiler.
    inspectorBackend.registerEvent("Profiler.consoleProfileFinished", ["id", "location", "profile", "title"]);
    inspectorBackend.registerEvent("Profiler.consoleProfileStarted", ["id", "location", "title"]);
    inspectorBackend.registerEvent("Profiler.preciseCoverageDeltaUpdate", ["timestamp", "occasion", "result"]);
    inspectorBackend.registerCommand("Profiler.disable", [], [], "");
    inspectorBackend.registerCommand("Profiler.enable", [], [], "");
    inspectorBackend.registerCommand("Profiler.getBestEffortCoverage", [], ["result"], "Collect coverage data for the current isolate. The coverage data may be incomplete due to garbage collection.");
    inspectorBackend.registerCommand("Profiler.setSamplingInterval", [{ "name": "interval", "type": "number", "optional": false, "description": "New sampling interval in microseconds.", "typeRef": null }], [], "Changes CPU profiler sampling interval. Must be called before CPU profiles recording started.");
    inspectorBackend.registerCommand("Profiler.start", [], [], "");
    inspectorBackend.registerCommand("Profiler.startPreciseCoverage", [{ "name": "callCount", "type": "boolean", "optional": true, "description": "Collect accurate call counts beyond simple 'covered' or 'not covered'.", "typeRef": null }, { "name": "detailed", "type": "boolean", "optional": true, "description": "Collect block-based coverage.", "typeRef": null }, { "name": "allowTriggeredUpdates", "type": "boolean", "optional": true, "description": "Allow the backend to send updates on its own initiative", "typeRef": null }], ["timestamp"], "Enable precise code coverage. Coverage data for JavaScript executed before enabling precise code coverage may be incomplete. Enabling prevents running optimized code and resets execution counters.");
    inspectorBackend.registerCommand("Profiler.stop", [], ["profile"], "");
    inspectorBackend.registerCommand("Profiler.stopPreciseCoverage", [], [], "Disable precise code coverage. Disabling releases unnecessary execution count records and allows executing optimized code.");
    inspectorBackend.registerCommand("Profiler.takePreciseCoverage", [], ["result", "timestamp"], "Collect coverage data for the current isolate, and resets execution counters. Precise code coverage needs to have started.");
    inspectorBackend.registerType("Profiler.ProfileNode", [{ "name": "id", "type": "number", "optional": false, "description": "Unique id of the node.", "typeRef": null }, { "name": "callFrame", "type": "object", "optional": false, "description": "Function location.", "typeRef": "Runtime.CallFrame" }, { "name": "hitCount", "type": "number", "optional": true, "description": "Number of samples where this node was on top of the call stack.", "typeRef": null }, { "name": "children", "type": "array", "optional": true, "description": "Child node ids.", "typeRef": "integer" }, { "name": "deoptReason", "type": "string", "optional": true, "description": "The reason of being not optimized. The function may be deoptimized or marked as don't optimize.", "typeRef": null }, { "name": "positionTicks", "type": "array", "optional": true, "description": "An array of source position ticks.", "typeRef": "Profiler.PositionTickInfo" }]);
    inspectorBackend.registerType("Profiler.Profile", [{ "name": "nodes", "type": "array", "optional": false, "description": "The list of profile nodes. First item is the root node.", "typeRef": "Profiler.ProfileNode" }, { "name": "startTime", "type": "number", "optional": false, "description": "Profiling start timestamp in microseconds.", "typeRef": null }, { "name": "endTime", "type": "number", "optional": false, "description": "Profiling end timestamp in microseconds.", "typeRef": null }, { "name": "samples", "type": "array", "optional": true, "description": "Ids of samples top nodes.", "typeRef": "integer" }, { "name": "timeDeltas", "type": "array", "optional": true, "description": "Time intervals between adjacent samples in microseconds. The first delta is relative to the profile startTime.", "typeRef": "integer" }]);
    inspectorBackend.registerType("Profiler.PositionTickInfo", [{ "name": "line", "type": "number", "optional": false, "description": "Source line number (1-based).", "typeRef": null }, { "name": "ticks", "type": "number", "optional": false, "description": "Number of samples attributed to the source line.", "typeRef": null }]);
    inspectorBackend.registerType("Profiler.CoverageRange", [{ "name": "startOffset", "type": "number", "optional": false, "description": "JavaScript script source offset for the range start.", "typeRef": null }, { "name": "endOffset", "type": "number", "optional": false, "description": "JavaScript script source offset for the range end.", "typeRef": null }, { "name": "count", "type": "number", "optional": false, "description": "Collected execution count of the source range.", "typeRef": null }]);
    inspectorBackend.registerType("Profiler.FunctionCoverage", [{ "name": "functionName", "type": "string", "optional": false, "description": "JavaScript function name.", "typeRef": null }, { "name": "ranges", "type": "array", "optional": false, "description": "Source ranges inside the function with coverage data.", "typeRef": "Profiler.CoverageRange" }, { "name": "isBlockCoverage", "type": "boolean", "optional": false, "description": "Whether coverage data for this function has block granularity.", "typeRef": null }]);
    inspectorBackend.registerType("Profiler.ScriptCoverage", [{ "name": "scriptId", "type": "string", "optional": false, "description": "JavaScript script id.", "typeRef": "Runtime.ScriptId" }, { "name": "url", "type": "string", "optional": false, "description": "JavaScript script name or url.", "typeRef": null }, { "name": "functions", "type": "array", "optional": false, "description": "Functions contained in the script that has coverage data.", "typeRef": "Profiler.FunctionCoverage" }]);
    // Runtime.
    inspectorBackend.registerEnum("Runtime.SerializationOptionsSerialization", { Deep: "deep", Json: "json", IdOnly: "idOnly" });
    inspectorBackend.registerEnum("Runtime.DeepSerializedValueType", { Undefined: "undefined", Null: "null", String: "string", Number: "number", Boolean: "boolean", Bigint: "bigint", Regexp: "regexp", Date: "date", Symbol: "symbol", Array: "array", Object: "object", Function: "function", Map: "map", Set: "set", Weakmap: "weakmap", Weakset: "weakset", Error: "error", Proxy: "proxy", Promise: "promise", Typedarray: "typedarray", Arraybuffer: "arraybuffer", Node: "node", Window: "window", Generator: "generator" });
    inspectorBackend.registerEnum("Runtime.RemoteObjectType", { Object: "object", Function: "function", Undefined: "undefined", String: "string", Number: "number", Boolean: "boolean", Symbol: "symbol", Bigint: "bigint" });
    inspectorBackend.registerEnum("Runtime.RemoteObjectSubtype", { Array: "array", Null: "null", Node: "node", Regexp: "regexp", Date: "date", Map: "map", Set: "set", Weakmap: "weakmap", Weakset: "weakset", Iterator: "iterator", Generator: "generator", Error: "error", Proxy: "proxy", Promise: "promise", Typedarray: "typedarray", Arraybuffer: "arraybuffer", Dataview: "dataview", Webassemblymemory: "webassemblymemory", Wasmvalue: "wasmvalue", Trustedtype: "trustedtype" });
    inspectorBackend.registerEnum("Runtime.ObjectPreviewType", { Object: "object", Function: "function", Undefined: "undefined", String: "string", Number: "number", Boolean: "boolean", Symbol: "symbol", Bigint: "bigint" });
    inspectorBackend.registerEnum("Runtime.ObjectPreviewSubtype", { Array: "array", Null: "null", Node: "node", Regexp: "regexp", Date: "date", Map: "map", Set: "set", Weakmap: "weakmap", Weakset: "weakset", Iterator: "iterator", Generator: "generator", Error: "error", Proxy: "proxy", Promise: "promise", Typedarray: "typedarray", Arraybuffer: "arraybuffer", Dataview: "dataview", Webassemblymemory: "webassemblymemory", Wasmvalue: "wasmvalue", Trustedtype: "trustedtype" });
    inspectorBackend.registerEnum("Runtime.PropertyPreviewType", { Object: "object", Function: "function", Undefined: "undefined", String: "string", Number: "number", Boolean: "boolean", Symbol: "symbol", Accessor: "accessor", Bigint: "bigint" });
    inspectorBackend.registerEnum("Runtime.PropertyPreviewSubtype", { Array: "array", Null: "null", Node: "node", Regexp: "regexp", Date: "date", Map: "map", Set: "set", Weakmap: "weakmap", Weakset: "weakset", Iterator: "iterator", Generator: "generator", Error: "error", Proxy: "proxy", Promise: "promise", Typedarray: "typedarray", Arraybuffer: "arraybuffer", Dataview: "dataview", Webassemblymemory: "webassemblymemory", Wasmvalue: "wasmvalue", Trustedtype: "trustedtype" });
    inspectorBackend.registerEvent("Runtime.bindingCalled", ["name", "payload", "executionContextId"]);
    inspectorBackend.registerEnum("Runtime.ConsoleAPICalledEventType", { Log: "log", Debug: "debug", Info: "info", Error: "error", Warning: "warning", Dir: "dir", DirXML: "dirxml", Table: "table", Trace: "trace", Clear: "clear", StartGroup: "startGroup", StartGroupCollapsed: "startGroupCollapsed", EndGroup: "endGroup", Assert: "assert", Profile: "profile", ProfileEnd: "profileEnd", Count: "count", TimeEnd: "timeEnd" });
    inspectorBackend.registerEvent("Runtime.consoleAPICalled", ["type", "args", "executionContextId", "timestamp", "stackTrace", "context"]);
    inspectorBackend.registerEvent("Runtime.exceptionRevoked", ["reason", "exceptionId"]);
    inspectorBackend.registerEvent("Runtime.exceptionThrown", ["timestamp", "exceptionDetails"]);
    inspectorBackend.registerEvent("Runtime.executionContextCreated", ["context"]);
    inspectorBackend.registerEvent("Runtime.executionContextDestroyed", ["executionContextId", "executionContextUniqueId"]);
    inspectorBackend.registerEvent("Runtime.executionContextsCleared", []);
    inspectorBackend.registerEvent("Runtime.inspectRequested", ["object", "hints", "executionContextId"]);
    inspectorBackend.registerCommand("Runtime.awaitPromise", [{ "name": "promiseObjectId", "type": "string", "optional": false, "description": "Identifier of the promise.", "typeRef": "Runtime.RemoteObjectId" }, { "name": "returnByValue", "type": "boolean", "optional": true, "description": "Whether the result is expected to be a JSON object that should be sent by value.", "typeRef": null }, { "name": "generatePreview", "type": "boolean", "optional": true, "description": "Whether preview should be generated for the result.", "typeRef": null }], ["result", "exceptionDetails"], "Add handler to promise with given promise object id.");
    inspectorBackend.registerCommand("Runtime.callFunctionOn", [{ "name": "functionDeclaration", "type": "string", "optional": false, "description": "Declaration of the function to call.", "typeRef": null }, { "name": "objectId", "type": "string", "optional": true, "description": "Identifier of the object to call function on. Either objectId or executionContextId should be specified.", "typeRef": "Runtime.RemoteObjectId" }, { "name": "arguments", "type": "array", "optional": true, "description": "Call arguments. All call arguments must belong to the same JavaScript world as the target object.", "typeRef": "Runtime.CallArgument" }, { "name": "silent", "type": "boolean", "optional": true, "description": "In silent mode exceptions thrown during evaluation are not reported and do not pause execution. Overrides `setPauseOnException` state.", "typeRef": null }, { "name": "returnByValue", "type": "boolean", "optional": true, "description": "Whether the result is expected to be a JSON object which should be sent by value. Can be overriden by `serializationOptions`.", "typeRef": null }, { "name": "generatePreview", "type": "boolean", "optional": true, "description": "Whether preview should be generated for the result.", "typeRef": null }, { "name": "userGesture", "type": "boolean", "optional": true, "description": "Whether execution should be treated as initiated by user in the UI.", "typeRef": null }, { "name": "awaitPromise", "type": "boolean", "optional": true, "description": "Whether execution should `await` for resulting value and return once awaited promise is resolved.", "typeRef": null }, { "name": "executionContextId", "type": "number", "optional": true, "description": "Specifies execution context which global object will be used to call function on. Either executionContextId or objectId should be specified.", "typeRef": "Runtime.ExecutionContextId" }, { "name": "objectGroup", "type": "string", "optional": true, "description": "Symbolic group name that can be used to release multiple objects. If objectGroup is not specified and objectId is, objectGroup will be inherited from object.", "typeRef": null }, { "name": "throwOnSideEffect", "type": "boolean", "optional": true, "description": "Whether to throw an exception if side effect cannot be ruled out during evaluation.", "typeRef": null }, { "name": "uniqueContextId", "type": "string", "optional": true, "description": "An alternative way to specify the execution context to call function on. Compared to contextId that may be reused across processes, this is guaranteed to be system-unique, so it can be used to prevent accidental function call in context different than intended (e.g. as a result of navigation across process boundaries). This is mutually exclusive with `executionContextId`.", "typeRef": null }, { "name": "serializationOptions", "type": "object", "optional": true, "description": "Specifies the result serialization. If provided, overrides `generatePreview` and `returnByValue`.", "typeRef": "Runtime.SerializationOptions" }], ["result", "exceptionDetails"], "Calls function with given declaration on the given object. Object group of the result is inherited from the target object.");
    inspectorBackend.registerCommand("Runtime.compileScript", [{ "name": "expression", "type": "string", "optional": false, "description": "Expression to compile.", "typeRef": null }, { "name": "sourceURL", "type": "string", "optional": false, "description": "Source url to be set for the script.", "typeRef": null }, { "name": "persistScript", "type": "boolean", "optional": false, "description": "Specifies whether the compiled script should be persisted.", "typeRef": null }, { "name": "executionContextId", "type": "number", "optional": true, "description": "Specifies in which execution context to perform script run. If the parameter is omitted the evaluation will be performed in the context of the inspected page.", "typeRef": "Runtime.ExecutionContextId" }], ["scriptId", "exceptionDetails"], "Compiles expression.");
    inspectorBackend.registerCommand("Runtime.disable", [], [], "Disables reporting of execution contexts creation.");
    inspectorBackend.registerCommand("Runtime.discardConsoleEntries", [], [], "Discards collected exceptions and console API calls.");
    inspectorBackend.registerCommand("Runtime.enable", [], [], "Enables reporting of execution contexts creation by means of `executionContextCreated` event. When the reporting gets enabled the event will be sent immediately for each existing execution context.");
    inspectorBackend.registerCommand("Runtime.evaluate", [{ "name": "expression", "type": "string", "optional": false, "description": "Expression to evaluate.", "typeRef": null }, { "name": "objectGroup", "type": "string", "optional": true, "description": "Symbolic group name that can be used to release multiple objects.", "typeRef": null }, { "name": "includeCommandLineAPI", "type": "boolean", "optional": true, "description": "Determines whether Command Line API should be available during the evaluation.", "typeRef": null }, { "name": "silent", "type": "boolean", "optional": true, "description": "In silent mode exceptions thrown during evaluation are not reported and do not pause execution. Overrides `setPauseOnException` state.", "typeRef": null }, { "name": "contextId", "type": "number", "optional": true, "description": "Specifies in which execution context to perform evaluation. If the parameter is omitted the evaluation will be performed in the context of the inspected page. This is mutually exclusive with `uniqueContextId`, which offers an alternative way to identify the execution context that is more reliable in a multi-process environment.", "typeRef": "Runtime.ExecutionContextId" }, { "name": "returnByValue", "type": "boolean", "optional": true, "description": "Whether the result is expected to be a JSON object that should be sent by value.", "typeRef": null }, { "name": "generatePreview", "type": "boolean", "optional": true, "description": "Whether preview should be generated for the result.", "typeRef": null }, { "name": "userGesture", "type": "boolean", "optional": true, "description": "Whether execution should be treated as initiated by user in the UI.", "typeRef": null }, { "name": "awaitPromise", "type": "boolean", "optional": true, "description": "Whether execution should `await` for resulting value and return once awaited promise is resolved.", "typeRef": null }, { "name": "throwOnSideEffect", "type": "boolean", "optional": true, "description": "Whether to throw an exception if side effect cannot be ruled out during evaluation. This implies `disableBreaks` below.", "typeRef": null }, { "name": "timeout", "type": "number", "optional": true, "description": "Terminate execution after timing out (number of milliseconds).", "typeRef": "Runtime.TimeDelta" }, { "name": "disableBreaks", "type": "boolean", "optional": true, "description": "Disable breakpoints during execution.", "typeRef": null }, { "name": "replMode", "type": "boolean", "optional": true, "description": "Setting this flag to true enables `let` re-declaration and top-level `await`. Note that `let` variables can only be re-declared if they originate from `replMode` themselves.", "typeRef": null }, { "name": "allowUnsafeEvalBlockedByCSP", "type": "boolean", "optional": true, "description": "The Content Security Policy (CSP) for the target might block 'unsafe-eval' which includes eval(), Function(), setTimeout() and setInterval() when called with non-callable arguments. This flag bypasses CSP for this evaluation and allows unsafe-eval. Defaults to true.", "typeRef": null }, { "name": "uniqueContextId", "type": "string", "optional": true, "description": "An alternative way to specify the execution context to evaluate in. Compared to contextId that may be reused across processes, this is guaranteed to be system-unique, so it can be used to prevent accidental evaluation of the expression in context different than intended (e.g. as a result of navigation across process boundaries). This is mutually exclusive with `contextId`.", "typeRef": null }, { "name": "serializationOptions", "type": "object", "optional": true, "description": "Specifies the result serialization. If provided, overrides `generatePreview` and `returnByValue`.", "typeRef": "Runtime.SerializationOptions" }], ["result", "exceptionDetails"], "Evaluates expression on global object.");
    inspectorBackend.registerCommand("Runtime.getIsolateId", [], ["id"], "Returns the isolate id.");
    inspectorBackend.registerCommand("Runtime.getHeapUsage", [], ["usedSize", "totalSize", "embedderHeapUsedSize", "backingStorageSize"], "Returns the JavaScript heap usage. It is the total usage of the corresponding isolate not scoped to a particular Runtime.");
    inspectorBackend.registerCommand("Runtime.getProperties", [{ "name": "objectId", "type": "string", "optional": false, "description": "Identifier of the object to return properties for.", "typeRef": "Runtime.RemoteObjectId" }, { "name": "ownProperties", "type": "boolean", "optional": true, "description": "If true, returns properties belonging only to the element itself, not to its prototype chain.", "typeRef": null }, { "name": "accessorPropertiesOnly", "type": "boolean", "optional": true, "description": "If true, returns accessor properties (with getter/setter) only; internal properties are not returned either.", "typeRef": null }, { "name": "generatePreview", "type": "boolean", "optional": true, "description": "Whether preview should be generated for the results.", "typeRef": null }, { "name": "nonIndexedPropertiesOnly", "type": "boolean", "optional": true, "description": "If true, returns non-indexed properties only.", "typeRef": null }], ["result", "internalProperties", "privateProperties", "exceptionDetails"], "Returns properties of a given object. Object group of the result is inherited from the target object.");
    inspectorBackend.registerCommand("Runtime.globalLexicalScopeNames", [{ "name": "executionContextId", "type": "number", "optional": true, "description": "Specifies in which execution context to lookup global scope variables.", "typeRef": "Runtime.ExecutionContextId" }], ["names"], "Returns all let, const and class variables from global scope.");
    inspectorBackend.registerCommand("Runtime.queryObjects", [{ "name": "prototypeObjectId", "type": "string", "optional": false, "description": "Identifier of the prototype to return objects for.", "typeRef": "Runtime.RemoteObjectId" }, { "name": "objectGroup", "type": "string", "optional": true, "description": "Symbolic group name that can be used to release the results.", "typeRef": null }], ["objects"], "");
    inspectorBackend.registerCommand("Runtime.releaseObject", [{ "name": "objectId", "type": "string", "optional": false, "description": "Identifier of the object to release.", "typeRef": "Runtime.RemoteObjectId" }], [], "Releases remote object with given id.");
    inspectorBackend.registerCommand("Runtime.releaseObjectGroup", [{ "name": "objectGroup", "type": "string", "optional": false, "description": "Symbolic object group name.", "typeRef": null }], [], "Releases all remote objects that belong to a given group.");
    inspectorBackend.registerCommand("Runtime.runIfWaitingForDebugger", [], [], "Tells inspected instance to run if it was waiting for debugger to attach.");
    inspectorBackend.registerCommand("Runtime.runScript", [{ "name": "scriptId", "type": "string", "optional": false, "description": "Id of the script to run.", "typeRef": "Runtime.ScriptId" }, { "name": "executionContextId", "type": "number", "optional": true, "description": "Specifies in which execution context to perform script run. If the parameter is omitted the evaluation will be performed in the context of the inspected page.", "typeRef": "Runtime.ExecutionContextId" }, { "name": "objectGroup", "type": "string", "optional": true, "description": "Symbolic group name that can be used to release multiple objects.", "typeRef": null }, { "name": "silent", "type": "boolean", "optional": true, "description": "In silent mode exceptions thrown during evaluation are not reported and do not pause execution. Overrides `setPauseOnException` state.", "typeRef": null }, { "name": "includeCommandLineAPI", "type": "boolean", "optional": true, "description": "Determines whether Command Line API should be available during the evaluation.", "typeRef": null }, { "name": "returnByValue", "type": "boolean", "optional": true, "description": "Whether the result is expected to be a JSON object which should be sent by value.", "typeRef": null }, { "name": "generatePreview", "type": "boolean", "optional": true, "description": "Whether preview should be generated for the result.", "typeRef": null }, { "name": "awaitPromise", "type": "boolean", "optional": true, "description": "Whether execution should `await` for resulting value and return once awaited promise is resolved.", "typeRef": null }], ["result", "exceptionDetails"], "Runs script with given id in a given context.");
    inspectorBackend.registerCommand("Runtime.setAsyncCallStackDepth", [{ "name": "maxDepth", "type": "number", "optional": false, "description": "Maximum depth of async call stacks. Setting to `0` will effectively disable collecting async call stacks (default).", "typeRef": null }], [], "Enables or disables async call stacks tracking.");
    inspectorBackend.registerCommand("Runtime.setCustomObjectFormatterEnabled", [{ "name": "enabled", "type": "boolean", "optional": false, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("Runtime.setMaxCallStackSizeToCapture", [{ "name": "size", "type": "number", "optional": false, "description": "", "typeRef": null }], [], "");
    inspectorBackend.registerCommand("Runtime.terminateExecution", [], [], "Terminate current or next JavaScript execution. Will cancel the termination when the outer-most script execution ends.");
    inspectorBackend.registerCommand("Runtime.addBinding", [{ "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "executionContextId", "type": "number", "optional": true, "description": "If specified, the binding would only be exposed to the specified execution context. If omitted and `executionContextName` is not set, the binding is exposed to all execution contexts of the target. This parameter is mutually exclusive with `executionContextName`. Deprecated in favor of `executionContextName` due to an unclear use case and bugs in implementation (crbug.com/1169639). `executionContextId` will be removed in the future.", "typeRef": "Runtime.ExecutionContextId" }, { "name": "executionContextName", "type": "string", "optional": true, "description": "If specified, the binding is exposed to the executionContext with matching name, even for contexts created after the binding is added. See also `ExecutionContext.name` and `worldName` parameter to `Page.addScriptToEvaluateOnNewDocument`. This parameter is mutually exclusive with `executionContextId`.", "typeRef": null }], [], "If executionContextId is empty, adds binding with the given name on the global objects of all inspected contexts, including those created later, bindings survive reloads. Binding function takes exactly one argument, this argument should be string, in case of any other input, function throws an exception. Each binding function call produces Runtime.bindingCalled notification.");
    inspectorBackend.registerCommand("Runtime.removeBinding", [{ "name": "name", "type": "string", "optional": false, "description": "", "typeRef": null }], [], "This method does not remove binding function from global object but unsubscribes current runtime agent from Runtime.bindingCalled notifications.");
    inspectorBackend.registerCommand("Runtime.getExceptionDetails", [{ "name": "errorObjectId", "type": "string", "optional": false, "description": "The error object for which to resolve the exception details.", "typeRef": "Runtime.RemoteObjectId" }], ["exceptionDetails"], "This method tries to lookup and populate exception details for a JavaScript Error object. Note that the stackTrace portion of the resulting exceptionDetails will only be populated if the Runtime domain was enabled at the time when the Error was thrown.");
    inspectorBackend.registerType("Runtime.SerializationOptions", [{ "name": "serialization", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "maxDepth", "type": "number", "optional": true, "description": "Deep serialization depth. Default is full depth. Respected only in `deep` serialization mode.", "typeRef": null }, { "name": "additionalParameters", "type": "object", "optional": true, "description": "Embedder-specific parameters. For example if connected to V8 in Chrome these control DOM serialization via `maxNodeDepth: integer` and `includeShadowTree: \\\"none\\\" | \\\"open\\\" | \\\"all\\\"`. Values can be only of type string or integer.", "typeRef": null }]);
    inspectorBackend.registerType("Runtime.DeepSerializedValue", [{ "name": "type", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "value", "type": "any", "optional": true, "description": "", "typeRef": null }, { "name": "objectId", "type": "string", "optional": true, "description": "", "typeRef": null }, { "name": "weakLocalObjectReference", "type": "number", "optional": true, "description": "Set if value reference met more then once during serialization. In such case, value is provided only to one of the serialized values. Unique per value in the scope of one CDP call.", "typeRef": null }]);
    inspectorBackend.registerType("Runtime.RemoteObject", [{ "name": "type", "type": "string", "optional": false, "description": "Object type.", "typeRef": null }, { "name": "subtype", "type": "string", "optional": true, "description": "Object subtype hint. Specified for `object` type values only. NOTE: If you change anything here, make sure to also update `subtype` in `ObjectPreview` and `PropertyPreview` below.", "typeRef": null }, { "name": "className", "type": "string", "optional": true, "description": "Object class (constructor) name. Specified for `object` type values only.", "typeRef": null }, { "name": "value", "type": "any", "optional": true, "description": "Remote object value in case of primitive values or JSON values (if it was requested).", "typeRef": null }, { "name": "unserializableValue", "type": "string", "optional": true, "description": "Primitive value which can not be JSON-stringified does not have `value`, but gets this property.", "typeRef": "Runtime.UnserializableValue" }, { "name": "description", "type": "string", "optional": true, "description": "String representation of the object.", "typeRef": null }, { "name": "deepSerializedValue", "type": "object", "optional": true, "description": "Deep serialized value.", "typeRef": "Runtime.DeepSerializedValue" }, { "name": "objectId", "type": "string", "optional": true, "description": "Unique object identifier (for non-primitive values).", "typeRef": "Runtime.RemoteObjectId" }, { "name": "preview", "type": "object", "optional": true, "description": "Preview containing abbreviated property values. Specified for `object` type values only.", "typeRef": "Runtime.ObjectPreview" }, { "name": "customPreview", "type": "object", "optional": true, "description": "", "typeRef": "Runtime.CustomPreview" }]);
    inspectorBackend.registerType("Runtime.CustomPreview", [{ "name": "header", "type": "string", "optional": false, "description": "The JSON-stringified result of formatter.header(object, config) call. It contains json ML array that represents RemoteObject.", "typeRef": null }, { "name": "bodyGetterId", "type": "string", "optional": true, "description": "If formatter returns true as a result of formatter.hasBody call then bodyGetterId will contain RemoteObjectId for the function that returns result of formatter.body(object, config) call. The result value is json ML array.", "typeRef": "Runtime.RemoteObjectId" }]);
    inspectorBackend.registerType("Runtime.ObjectPreview", [{ "name": "type", "type": "string", "optional": false, "description": "Object type.", "typeRef": null }, { "name": "subtype", "type": "string", "optional": true, "description": "Object subtype hint. Specified for `object` type values only.", "typeRef": null }, { "name": "description", "type": "string", "optional": true, "description": "String representation of the object.", "typeRef": null }, { "name": "overflow", "type": "boolean", "optional": false, "description": "True iff some of the properties or entries of the original object did not fit.", "typeRef": null }, { "name": "properties", "type": "array", "optional": false, "description": "List of the properties.", "typeRef": "Runtime.PropertyPreview" }, { "name": "entries", "type": "array", "optional": true, "description": "List of the entries. Specified for `map` and `set` subtype values only.", "typeRef": "Runtime.EntryPreview" }]);
    inspectorBackend.registerType("Runtime.PropertyPreview", [{ "name": "name", "type": "string", "optional": false, "description": "Property name.", "typeRef": null }, { "name": "type", "type": "string", "optional": false, "description": "Object type. Accessor means that the property itself is an accessor property.", "typeRef": null }, { "name": "value", "type": "string", "optional": true, "description": "User-friendly property value string.", "typeRef": null }, { "name": "valuePreview", "type": "object", "optional": true, "description": "Nested value preview.", "typeRef": "Runtime.ObjectPreview" }, { "name": "subtype", "type": "string", "optional": true, "description": "Object subtype hint. Specified for `object` type values only.", "typeRef": null }]);
    inspectorBackend.registerType("Runtime.EntryPreview", [{ "name": "key", "type": "object", "optional": true, "description": "Preview of the key. Specified for map-like collection entries.", "typeRef": "Runtime.ObjectPreview" }, { "name": "value", "type": "object", "optional": false, "description": "Preview of the value.", "typeRef": "Runtime.ObjectPreview" }]);
    inspectorBackend.registerType("Runtime.PropertyDescriptor", [{ "name": "name", "type": "string", "optional": false, "description": "Property name or symbol description.", "typeRef": null }, { "name": "value", "type": "object", "optional": true, "description": "The value associated with the property.", "typeRef": "Runtime.RemoteObject" }, { "name": "writable", "type": "boolean", "optional": true, "description": "True if the value associated with the property may be changed (data descriptors only).", "typeRef": null }, { "name": "get", "type": "object", "optional": true, "description": "A function which serves as a getter for the property, or `undefined` if there is no getter (accessor descriptors only).", "typeRef": "Runtime.RemoteObject" }, { "name": "set", "type": "object", "optional": true, "description": "A function which serves as a setter for the property, or `undefined` if there is no setter (accessor descriptors only).", "typeRef": "Runtime.RemoteObject" }, { "name": "configurable", "type": "boolean", "optional": false, "description": "True if the type of this property descriptor may be changed and if the property may be deleted from the corresponding object.", "typeRef": null }, { "name": "enumerable", "type": "boolean", "optional": false, "description": "True if this property shows up during enumeration of the properties on the corresponding object.", "typeRef": null }, { "name": "wasThrown", "type": "boolean", "optional": true, "description": "True if the result was thrown during the evaluation.", "typeRef": null }, { "name": "isOwn", "type": "boolean", "optional": true, "description": "True if the property is owned for the object.", "typeRef": null }, { "name": "symbol", "type": "object", "optional": true, "description": "Property symbol object, if the property is of the `symbol` type.", "typeRef": "Runtime.RemoteObject" }]);
    inspectorBackend.registerType("Runtime.InternalPropertyDescriptor", [{ "name": "name", "type": "string", "optional": false, "description": "Conventional property name.", "typeRef": null }, { "name": "value", "type": "object", "optional": true, "description": "The value associated with the property.", "typeRef": "Runtime.RemoteObject" }]);
    inspectorBackend.registerType("Runtime.PrivatePropertyDescriptor", [{ "name": "name", "type": "string", "optional": false, "description": "Private property name.", "typeRef": null }, { "name": "value", "type": "object", "optional": true, "description": "The value associated with the private property.", "typeRef": "Runtime.RemoteObject" }, { "name": "get", "type": "object", "optional": true, "description": "A function which serves as a getter for the private property, or `undefined` if there is no getter (accessor descriptors only).", "typeRef": "Runtime.RemoteObject" }, { "name": "set", "type": "object", "optional": true, "description": "A function which serves as a setter for the private property, or `undefined` if there is no setter (accessor descriptors only).", "typeRef": "Runtime.RemoteObject" }]);
    inspectorBackend.registerType("Runtime.CallArgument", [{ "name": "value", "type": "any", "optional": true, "description": "Primitive value or serializable javascript object.", "typeRef": null }, { "name": "unserializableValue", "type": "string", "optional": true, "description": "Primitive value which can not be JSON-stringified.", "typeRef": "Runtime.UnserializableValue" }, { "name": "objectId", "type": "string", "optional": true, "description": "Remote object handle.", "typeRef": "Runtime.RemoteObjectId" }]);
    inspectorBackend.registerType("Runtime.ExecutionContextDescription", [{ "name": "id", "type": "number", "optional": false, "description": "Unique id of the execution context. It can be used to specify in which execution context script evaluation should be performed.", "typeRef": "Runtime.ExecutionContextId" }, { "name": "origin", "type": "string", "optional": false, "description": "Execution context origin.", "typeRef": null }, { "name": "name", "type": "string", "optional": false, "description": "Human readable name describing given context.", "typeRef": null }, { "name": "uniqueId", "type": "string", "optional": false, "description": "A system-unique execution context identifier. Unlike the id, this is unique across multiple processes, so can be reliably used to identify specific context while backend performs a cross-process navigation.", "typeRef": null }, { "name": "auxData", "type": "object", "optional": true, "description": "Embedder-specific auxiliary data likely matching {isDefault: boolean, type: 'default'|'isolated'|'worker', frameId: string}", "typeRef": null }]);
    inspectorBackend.registerType("Runtime.ExceptionDetails", [{ "name": "exceptionId", "type": "number", "optional": false, "description": "Exception id.", "typeRef": null }, { "name": "text", "type": "string", "optional": false, "description": "Exception text, which should be used together with exception object when available.", "typeRef": null }, { "name": "lineNumber", "type": "number", "optional": false, "description": "Line number of the exception location (0-based).", "typeRef": null }, { "name": "columnNumber", "type": "number", "optional": false, "description": "Column number of the exception location (0-based).", "typeRef": null }, { "name": "scriptId", "type": "string", "optional": true, "description": "Script ID of the exception location.", "typeRef": "Runtime.ScriptId" }, { "name": "url", "type": "string", "optional": true, "description": "URL of the exception location, to be used when the script was not reported.", "typeRef": null }, { "name": "stackTrace", "type": "object", "optional": true, "description": "JavaScript stack trace if available.", "typeRef": "Runtime.StackTrace" }, { "name": "exception", "type": "object", "optional": true, "description": "Exception object if available.", "typeRef": "Runtime.RemoteObject" }, { "name": "executionContextId", "type": "number", "optional": true, "description": "Identifier of the context where exception happened.", "typeRef": "Runtime.ExecutionContextId" }, { "name": "exceptionMetaData", "type": "object", "optional": true, "description": "Dictionary with entries of meta data that the client associated with this exception, such as information about associated network requests, etc.", "typeRef": null }]);
    inspectorBackend.registerType("Runtime.CallFrame", [{ "name": "functionName", "type": "string", "optional": false, "description": "JavaScript function name.", "typeRef": null }, { "name": "scriptId", "type": "string", "optional": false, "description": "JavaScript script id.", "typeRef": "Runtime.ScriptId" }, { "name": "url", "type": "string", "optional": false, "description": "JavaScript script name or url.", "typeRef": null }, { "name": "lineNumber", "type": "number", "optional": false, "description": "JavaScript script line number (0-based).", "typeRef": null }, { "name": "columnNumber", "type": "number", "optional": false, "description": "JavaScript script column number (0-based).", "typeRef": null }]);
    inspectorBackend.registerType("Runtime.StackTrace", [{ "name": "description", "type": "string", "optional": true, "description": "String label of this stack trace. For async traces this may be a name of the function that initiated the async call.", "typeRef": null }, { "name": "callFrames", "type": "array", "optional": false, "description": "JavaScript function name.", "typeRef": "Runtime.CallFrame" }, { "name": "parent", "type": "object", "optional": true, "description": "Asynchronous JavaScript stack trace that preceded this stack, if available.", "typeRef": "Runtime.StackTrace" }, { "name": "parentId", "type": "object", "optional": true, "description": "Asynchronous JavaScript stack trace that preceded this stack, if available.", "typeRef": "Runtime.StackTraceId" }]);
    inspectorBackend.registerType("Runtime.StackTraceId", [{ "name": "id", "type": "string", "optional": false, "description": "", "typeRef": null }, { "name": "debuggerId", "type": "string", "optional": true, "description": "", "typeRef": "Runtime.UniqueDebuggerId" }]);
    // Schema.
    inspectorBackend.registerCommand("Schema.getDomains", [], ["domains"], "Returns supported domains.");
    inspectorBackend.registerType("Schema.Domain", [{ "name": "name", "type": "string", "optional": false, "description": "Domain name.", "typeRef": null }, { "name": "version", "type": "string", "optional": false, "description": "Domain version.", "typeRef": null }]);
}
//# sourceMappingURL=InspectorBackendCommands.js.map