#include <cstdint>
#include "third_party/blink/renderer/platform/wtf/text/wtf_uchar.h"

namespace {

inline constexpr UChar kFastLineBreakMinChar = 0x21;
inline constexpr UChar kFastLineBreakMaxChar = 0xFF;

#define B(a, b, c, d, e, f, g, h) ((a) | ((b) << 1) | ((c) << 2) | ((d) << 3) | ((e) << 4) | ((f) << 5) | ((g) << 6) | ((h) << 7))

const uint8_t kFastLineBreakTable[223][28] = {
           /* ! " # $ % & ' (    ) * + , - . / 0    1 2 3 4 5 6 7 8    9 : ; < = > ? @    A B C D E F G H    I J K L M N O P    Q R S T U V W X    Y Z [ \ ] ^ _ `    a b c d e f g h    i j k l m n o p    q r s t u v w x    y z { | } ~7F80   8182838485868788   898A8B8C8D8E8F90   9192939495969798   999A9B9C9D9E9FA0   A1A2A3A4A5A6A7A8   A9AAABACADAEAFB0   B1B2B3B4B5B6B7B8   B9BABBBCBDBEBFC0   C1C2C3C4C5C6C7C8   C9CACBCCCDCECFD0   D1D2D3D4D5D6D7D8   D9DADBDCDDDEDFE0   E1E2E3E4E5E6E7E8   E9EAEBECEDEEEFF0   F1F2F3F4F5F6F7F8   F9FAFBFCFDFEFF */
/* 21 ! */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,1,1,1),B(1,1,0,1,0,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,0,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,0)},
/* 22 " */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 23 # */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 24 $ */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 25 % */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 26 & */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 27 ' */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 28 ( */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 29 ) */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 2A * */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 2B + */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 2C , */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 2D - */ {B(0,1,1,0,1,1,1,1),B(0,1,1,0,1,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,1,1,0,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,0,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,0,1,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,1),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 2E . */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 2F / */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,1,1,1),B(1,1,0,1,0,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,0,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,0)},
/* 30 0 */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 31 1 */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 32 2 */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 33 3 */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 34 4 */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 35 5 */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 36 6 */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 37 7 */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 38 8 */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 39 9 */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 3A : */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 3B ; */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 3C < */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 3D = */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 3E > */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 3F ? */ {B(0,0,1,1,1,1,0,1),B(0,1,1,0,1,0,0,1),B(1,1,1,1,1,1,1,1),B(1,0,0,1,1,1,0,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,0,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,0,1,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,1,1,1),B(1,1,0,1,0,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,0,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,0)},
/* 40 @ */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 41 A */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 42 B */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 43 C */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 44 D */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 45 E */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 46 F */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 47 G */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 48 H */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 49 I */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 4A J */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 4B K */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 4C L */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 4D M */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 4E N */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 4F O */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 50 P */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 51 Q */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 52 R */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 53 S */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 54 T */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 55 U */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 56 V */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 57 W */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 58 X */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 59 Y */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 5A Z */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 5B [ */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 5C \ */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 5D ] */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 5E ^ */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 5F _ */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 60 ` */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 61 a */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 62 b */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 63 c */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 64 d */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 65 e */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 66 f */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 67 g */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 68 h */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 69 i */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 6A j */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 6B k */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 6C l */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 6D m */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 6E n */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 6F o */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 70 p */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 71 q */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 72 r */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 73 s */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 74 t */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 75 u */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 76 v */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 77 w */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 78 x */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 79 y */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 7A z */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 7B { */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 7C | */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,1),B(1,1,1,1,1,1,1,1),B(1,1,0,1,0,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,0,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,0)},
/* 7D } */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,1,1,1),B(1,1,0,1,0,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,0,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,0)},
/* 7E ~ */ {B(0,0,0,0,0,0,0,1),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 7F   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 80   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 81   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 82   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 83   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 84   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 85   */ {B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,0)},
/* 86   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 87   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 88   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 89   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 8A   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 8B   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 8C   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 8D   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 8E   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 8F   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 90   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 91   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 92   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 93   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 94   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 95   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 96   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 97   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 98   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 99   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 9A   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 9B   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 9C   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 9D   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 9E   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* 9F   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* A0   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* A1   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* A2   */ {B(0,0,0,1,1,0,0,1),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* A3   */ {B(0,0,0,1,1,0,0,1),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* A4   */ {B(0,0,0,1,1,0,0,1),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* A5   */ {B(0,0,0,1,1,0,0,1),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* A6   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* A7   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* A8   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* A9   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* AA   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* AB   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* AC   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* AD   */ {B(0,0,1,1,1,1,0,1),B(0,1,1,0,0,0,0,1),B(1,1,1,1,1,1,1,1),B(1,0,0,1,1,1,0,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,0,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,0,0,1,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,1),B(1,1,1,1,1,1,1,1),B(1,1,0,1,0,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,0,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,1),B(1,1,1,1,1,1,1,0)},
/* AE   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* AF   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* B0   */ {B(0,0,0,1,1,0,0,1),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* B1   */ {B(0,0,0,1,1,0,0,1),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,1,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(1,1,1,1,1,0,0,0),B(0,0,0,0,0,0,0,1),B(1,0,0,1,0,0,0,0),B(0,0,0,0,0,0,1,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* B2   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* B3   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* B4   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* B5   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* B6   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* B7   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* B8   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* B9   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* BA   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* BB   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* BC   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* BD   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* BE   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* BF   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* C0   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* C1   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* C2   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* C3   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* C4   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* C5   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* C6   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* C7   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* C8   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* C9   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* CA   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* CB   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* CC   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* CD   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* CE   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* CF   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* D0   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* D1   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* D2   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* D3   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* D4   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* D5   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* D6   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* D7   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* D8   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* D9   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* DA   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* DB   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* DC   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* DD   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* DE   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* DF   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* E0   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* E1   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* E2   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* E3   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* E4   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* E5   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* E6   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* E7   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* E8   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* E9   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* EA   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* EB   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* EC   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* ED   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* EE   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* EF   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* F0   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* F1   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* F2   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* F3   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* F4   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* F5   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* F6   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* F7   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* F8   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* F9   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* FA   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* FB   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* FC   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* FD   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* FE   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
/* FF   */ {B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,1,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0),B(0,0,0,0,0,0,0,0)},
};

#undef B

template <typename T>
inline uint8_t GetFastLineBreak(T ch1, T ch2) {
  const T i2 = ch2 - kFastLineBreakMinChar;
  return kFastLineBreakTable[ch1 - kFastLineBreakMinChar][i2 / 8] & (1 << (i2 % 8));
}

}  // namespace
