
// Copyright 2024 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// This file is automatically generated. Do not edit. Just generate.
//
// Manually re-generate:
// $ ninja -C ... third_party/blink/renderer/core/sanitizer:generated

#include "third_party/blink/renderer/core/sanitizer/sanitizer_builtins.h"
#include "third_party/blink/renderer/core/sanitizer/sanitizer.h"

#include "third_party/blink/renderer/core/html_names.h"
#include "third_party/blink/renderer/core/mathml_names.h"
#include "third_party/blink/renderer/core/svg_names.h"
#include "third_party/blink/renderer/core/xlink_names.h"
#include "third_party/blink/renderer/core/xml_names.h"
#include "third_party/blink/renderer/core/xmlns_names.h"

namespace blink {
namespace sanitizer_generated_builtins {

Sanitizer* BuildBaselineConfig() {
Sanitizer* sanitizer = MakeGarbageCollected<Sanitizer>(
  /* elements */ HashSet<QualifiedName> {
  },
  /* removeElements */ HashSet<QualifiedName> {
    html_names::kScriptTag,
    svg_names::kScriptTag,
  },
  /* replaceWithChildrenElements */ HashSet<QualifiedName> {
  },
  /* attributes */ HashSet<QualifiedName> {
  },
  /* removeAttributes */ HashSet<QualifiedName> {
    html_names::kOnabortAttr,
    svg_names::kOnactivateAttr,
    html_names::kOnafterprintAttr,
    html_names::kOnanimationendAttr,
    html_names::kOnanimationiterationAttr,
    html_names::kOnanimationstartAttr,
    html_names::kOnauxclickAttr,
    html_names::kOnbeforecopyAttr,
    html_names::kOnbeforecutAttr,
    html_names::kOnbeforeinputAttr,
    html_names::kOnbeforepasteAttr,
    html_names::kOnbeforeprintAttr,
    html_names::kOnbeforetoggleAttr,
    html_names::kOnbeforeunloadAttr,
    svg_names::kOnbeginAttr,
    html_names::kOnblurAttr,
    html_names::kOncancelAttr,
    html_names::kOncanplayAttr,
    html_names::kOncanplaythroughAttr,
    html_names::kOnchangeAttr,
    html_names::kOnclickAttr,
    html_names::kOncloseAttr,
    html_names::kOncommandAttr,
    html_names::kOncontentvisibilityautostatechangeAttr,
    html_names::kOncontextlostAttr,
    html_names::kOncontextmenuAttr,
    html_names::kOncontextrestoredAttr,
    html_names::kOncopyAttr,
    html_names::kOncuechangeAttr,
    html_names::kOncutAttr,
    html_names::kOndblclickAttr,
    html_names::kOndismissAttr,
    html_names::kOndragAttr,
    html_names::kOndragendAttr,
    html_names::kOndragenterAttr,
    html_names::kOndragleaveAttr,
    html_names::kOndragoverAttr,
    html_names::kOndragstartAttr,
    html_names::kOndropAttr,
    html_names::kOndurationchangeAttr,
    html_names::kOnemptiedAttr,
    svg_names::kOnendAttr,
    html_names::kOnendedAttr,
    html_names::kOnerrorAttr,
    html_names::kOnfocusAttr,
    svg_names::kOnfocusinAttr,
    svg_names::kOnfocusoutAttr,
    html_names::kOnformdataAttr,
    html_names::kOngotpointercaptureAttr,
    html_names::kOnhashchangeAttr,
    html_names::kOninputAttr,
    html_names::kOninvalidAttr,
    html_names::kOnkeydownAttr,
    html_names::kOnkeypressAttr,
    html_names::kOnkeyupAttr,
    html_names::kOnlanguagechangeAttr,
    html_names::kOnloadAttr,
    html_names::kOnloadeddataAttr,
    html_names::kOnloadedmetadataAttr,
    html_names::kOnloadstartAttr,
    html_names::kOnlocationAttr,
    html_names::kOnlostpointercaptureAttr,
    html_names::kOnmessageAttr,
    html_names::kOnmessageerrorAttr,
    html_names::kOnmousedownAttr,
    html_names::kOnmouseenterAttr,
    html_names::kOnmouseleaveAttr,
    html_names::kOnmousemoveAttr,
    html_names::kOnmouseoutAttr,
    html_names::kOnmouseoverAttr,
    html_names::kOnmouseupAttr,
    html_names::kOnmousewheelAttr,
    html_names::kOnmoveAttr,
    html_names::kOnofflineAttr,
    html_names::kOnonlineAttr,
    html_names::kOnorientationchangeAttr,
    html_names::kOnoverscrollAttr,
    html_names::kOnpagehideAttr,
    html_names::kOnpageshowAttr,
    html_names::kOnpasteAttr,
    html_names::kOnpauseAttr,
    html_names::kOnplayAttr,
    html_names::kOnplayingAttr,
    html_names::kOnpointercancelAttr,
    html_names::kOnpointerdownAttr,
    html_names::kOnpointerenterAttr,
    html_names::kOnpointerleaveAttr,
    html_names::kOnpointermoveAttr,
    html_names::kOnpointeroutAttr,
    html_names::kOnpointeroverAttr,
    html_names::kOnpointerrawupdateAttr,
    html_names::kOnpointerupAttr,
    html_names::kOnpopstateAttr,
    html_names::kOnprogressAttr,
    html_names::kOnpromptactionAttr,
    html_names::kOnpromptdismissAttr,
    html_names::kOnratechangeAttr,
    svg_names::kOnrepeatAttr,
    html_names::kOnresetAttr,
    html_names::kOnresizeAttr,
    html_names::kOnresolveAttr,
    html_names::kOnscrollAttr,
    html_names::kOnscrollendAttr,
    html_names::kOnscrollsnapchangeAttr,
    html_names::kOnscrollsnapchangingAttr,
    html_names::kOnsearchAttr,
    html_names::kOnsecuritypolicyviolationAttr,
    html_names::kOnseekedAttr,
    html_names::kOnseekingAttr,
    html_names::kOnselectAttr,
    html_names::kOnselectionchangeAttr,
    html_names::kOnselectstartAttr,
    html_names::kOnshowAttr,
    html_names::kOnslotchangeAttr,
    html_names::kOnstalledAttr,
    html_names::kOnstorageAttr,
    html_names::kOnsubmitAttr,
    html_names::kOnsuspendAttr,
    html_names::kOntimeupdateAttr,
    html_names::kOntimezonechangeAttr,
    html_names::kOntoggleAttr,
    html_names::kOntouchcancelAttr,
    html_names::kOntouchendAttr,
    html_names::kOntouchmoveAttr,
    html_names::kOntouchstartAttr,
    html_names::kOntransitionendAttr,
    html_names::kOnunloadAttr,
    html_names::kOnvalidationstatuschangeAttr,
    html_names::kOnvolumechangeAttr,
    html_names::kOnwaitingAttr,
    html_names::kOnwebkitanimationendAttr,
    html_names::kOnwebkitanimationiterationAttr,
    html_names::kOnwebkitanimationstartAttr,
    html_names::kOnwebkitfullscreenchangeAttr,
    html_names::kOnwebkitfullscreenerrorAttr,
    html_names::kOnwebkittransitionendAttr,
    html_names::kOnwheelAttr,
  },
/* comments */ true,
/* dataAttributes */ true

);
return sanitizer;
}
}  // namespace sanitizer_generated_builtins
}  // namespace blink
