// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/network.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace Network {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Network";
const char Metainfo::commandPrefix[] = "Network.";
const char Metainfo::version[] = "1.3";

namespace ResourceTypeEnum {
const char Document[] = "Document";
const char Stylesheet[] = "Stylesheet";
const char Image[] = "Image";
const char Media[] = "Media";
const char Font[] = "Font";
const char Script[] = "Script";
const char TextTrack[] = "TextTrack";
const char XHR[] = "XHR";
const char Fetch[] = "Fetch";
const char Prefetch[] = "Prefetch";
const char EventSource[] = "EventSource";
const char WebSocket[] = "WebSocket";
const char Manifest[] = "Manifest";
const char SignedExchange[] = "SignedExchange";
const char Ping[] = "Ping";
const char CSPViolationReport[] = "CSPViolationReport";
const char Preflight[] = "Preflight";
const char FedCM[] = "FedCM";
const char Other[] = "Other";
} // namespace ResourceTypeEnum





namespace ErrorReasonEnum {
const char Failed[] = "Failed";
const char Aborted[] = "Aborted";
const char TimedOut[] = "TimedOut";
const char AccessDenied[] = "AccessDenied";
const char ConnectionClosed[] = "ConnectionClosed";
const char ConnectionReset[] = "ConnectionReset";
const char ConnectionRefused[] = "ConnectionRefused";
const char ConnectionAborted[] = "ConnectionAborted";
const char ConnectionFailed[] = "ConnectionFailed";
const char NameNotResolved[] = "NameNotResolved";
const char InternetDisconnected[] = "InternetDisconnected";
const char AddressUnreachable[] = "AddressUnreachable";
const char BlockedByClient[] = "BlockedByClient";
const char BlockedByResponse[] = "BlockedByResponse";
} // namespace ErrorReasonEnum





namespace ConnectionTypeEnum {
const char None[] = "none";
const char Cellular2g[] = "cellular2g";
const char Cellular3g[] = "cellular3g";
const char Cellular4g[] = "cellular4g";
const char Bluetooth[] = "bluetooth";
const char Ethernet[] = "ethernet";
const char Wifi[] = "wifi";
const char Wimax[] = "wimax";
const char Other[] = "other";
} // namespace ConnectionTypeEnum


namespace CookieSameSiteEnum {
const char Strict[] = "Strict";
const char Lax[] = "Lax";
const char None[] = "None";
} // namespace CookieSameSiteEnum


namespace CookiePriorityEnum {
const char Low[] = "Low";
const char Medium[] = "Medium";
const char High[] = "High";
} // namespace CookiePriorityEnum


namespace CookieSourceSchemeEnum {
const char Unset[] = "Unset";
const char NonSecure[] = "NonSecure";
const char Secure[] = "Secure";
} // namespace CookieSourceSchemeEnum


CRDTP_BEGIN_DESERIALIZER(ResourceTiming)
    CRDTP_DESERIALIZE_FIELD("connectEnd", m_connectEnd),
    CRDTP_DESERIALIZE_FIELD("connectStart", m_connectStart),
    CRDTP_DESERIALIZE_FIELD("dnsEnd", m_dnsEnd),
    CRDTP_DESERIALIZE_FIELD("dnsStart", m_dnsStart),
    CRDTP_DESERIALIZE_FIELD("proxyEnd", m_proxyEnd),
    CRDTP_DESERIALIZE_FIELD("proxyStart", m_proxyStart),
    CRDTP_DESERIALIZE_FIELD("pushEnd", m_pushEnd),
    CRDTP_DESERIALIZE_FIELD("pushStart", m_pushStart),
    CRDTP_DESERIALIZE_FIELD("receiveHeadersEnd", m_receiveHeadersEnd),
    CRDTP_DESERIALIZE_FIELD("receiveHeadersStart", m_receiveHeadersStart),
    CRDTP_DESERIALIZE_FIELD("requestTime", m_requestTime),
    CRDTP_DESERIALIZE_FIELD("sendEnd", m_sendEnd),
    CRDTP_DESERIALIZE_FIELD("sendStart", m_sendStart),
    CRDTP_DESERIALIZE_FIELD("sslEnd", m_sslEnd),
    CRDTP_DESERIALIZE_FIELD("sslStart", m_sslStart),
    CRDTP_DESERIALIZE_FIELD_OPT("workerCacheLookupStart", m_workerCacheLookupStart),
    CRDTP_DESERIALIZE_FIELD("workerFetchStart", m_workerFetchStart),
    CRDTP_DESERIALIZE_FIELD("workerReady", m_workerReady),
    CRDTP_DESERIALIZE_FIELD("workerRespondWithSettled", m_workerRespondWithSettled),
    CRDTP_DESERIALIZE_FIELD_OPT("workerRouterEvaluationStart", m_workerRouterEvaluationStart),
    CRDTP_DESERIALIZE_FIELD("workerStart", m_workerStart),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ResourceTiming)
    CRDTP_SERIALIZE_FIELD("requestTime", m_requestTime);
    CRDTP_SERIALIZE_FIELD("proxyStart", m_proxyStart);
    CRDTP_SERIALIZE_FIELD("proxyEnd", m_proxyEnd);
    CRDTP_SERIALIZE_FIELD("dnsStart", m_dnsStart);
    CRDTP_SERIALIZE_FIELD("dnsEnd", m_dnsEnd);
    CRDTP_SERIALIZE_FIELD("connectStart", m_connectStart);
    CRDTP_SERIALIZE_FIELD("connectEnd", m_connectEnd);
    CRDTP_SERIALIZE_FIELD("sslStart", m_sslStart);
    CRDTP_SERIALIZE_FIELD("sslEnd", m_sslEnd);
    CRDTP_SERIALIZE_FIELD("workerStart", m_workerStart);
    CRDTP_SERIALIZE_FIELD("workerReady", m_workerReady);
    CRDTP_SERIALIZE_FIELD("workerFetchStart", m_workerFetchStart);
    CRDTP_SERIALIZE_FIELD("workerRespondWithSettled", m_workerRespondWithSettled);
    CRDTP_SERIALIZE_FIELD("workerRouterEvaluationStart", m_workerRouterEvaluationStart);
    CRDTP_SERIALIZE_FIELD("workerCacheLookupStart", m_workerCacheLookupStart);
    CRDTP_SERIALIZE_FIELD("sendStart", m_sendStart);
    CRDTP_SERIALIZE_FIELD("sendEnd", m_sendEnd);
    CRDTP_SERIALIZE_FIELD("pushStart", m_pushStart);
    CRDTP_SERIALIZE_FIELD("pushEnd", m_pushEnd);
    CRDTP_SERIALIZE_FIELD("receiveHeadersStart", m_receiveHeadersStart);
    CRDTP_SERIALIZE_FIELD("receiveHeadersEnd", m_receiveHeadersEnd);
CRDTP_END_SERIALIZER();


namespace ResourcePriorityEnum {
const char VeryLow[] = "VeryLow";
const char Low[] = "Low";
const char Medium[] = "Medium";
const char High[] = "High";
const char VeryHigh[] = "VeryHigh";
} // namespace ResourcePriorityEnum


CRDTP_BEGIN_DESERIALIZER(PostDataEntry)
    CRDTP_DESERIALIZE_FIELD_OPT("bytes", m_bytes),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PostDataEntry)
    CRDTP_SERIALIZE_FIELD("bytes", m_bytes);
CRDTP_END_SERIALIZER();



const char* Request::ReferrerPolicyEnum::UnsafeUrl = "unsafe-url";
const char* Request::ReferrerPolicyEnum::NoReferrerWhenDowngrade = "no-referrer-when-downgrade";
const char* Request::ReferrerPolicyEnum::NoReferrer = "no-referrer";
const char* Request::ReferrerPolicyEnum::Origin = "origin";
const char* Request::ReferrerPolicyEnum::OriginWhenCrossOrigin = "origin-when-cross-origin";
const char* Request::ReferrerPolicyEnum::SameOrigin = "same-origin";
const char* Request::ReferrerPolicyEnum::StrictOrigin = "strict-origin";
const char* Request::ReferrerPolicyEnum::StrictOriginWhenCrossOrigin = "strict-origin-when-cross-origin";
CRDTP_BEGIN_DESERIALIZER(Request)
    CRDTP_DESERIALIZE_FIELD_OPT("hasPostData", m_hasPostData),
    CRDTP_DESERIALIZE_FIELD("headers", m_headers),
    CRDTP_DESERIALIZE_FIELD("initialPriority", m_initialPriority),
    CRDTP_DESERIALIZE_FIELD_OPT("isAdRelated", m_isAdRelated),
    CRDTP_DESERIALIZE_FIELD_OPT("isLinkPreload", m_isLinkPreload),
    CRDTP_DESERIALIZE_FIELD_OPT("isSameSite", m_isSameSite),
    CRDTP_DESERIALIZE_FIELD("method", m_method),
    CRDTP_DESERIALIZE_FIELD_OPT("mixedContentType", m_mixedContentType),
    CRDTP_DESERIALIZE_FIELD_OPT("postData", m_postData),
    CRDTP_DESERIALIZE_FIELD_OPT("postDataEntries", m_postDataEntries),
    CRDTP_DESERIALIZE_FIELD("referrerPolicy", m_referrerPolicy),
    CRDTP_DESERIALIZE_FIELD_OPT("trustTokenParams", m_trustTokenParams),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
    CRDTP_DESERIALIZE_FIELD_OPT("urlFragment", m_urlFragment),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Request)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("urlFragment", m_urlFragment);
    CRDTP_SERIALIZE_FIELD("method", m_method);
    CRDTP_SERIALIZE_FIELD("headers", m_headers);
    CRDTP_SERIALIZE_FIELD("postData", m_postData);
    CRDTP_SERIALIZE_FIELD("hasPostData", m_hasPostData);
    CRDTP_SERIALIZE_FIELD("postDataEntries", m_postDataEntries);
    CRDTP_SERIALIZE_FIELD("mixedContentType", m_mixedContentType);
    CRDTP_SERIALIZE_FIELD("initialPriority", m_initialPriority);
    CRDTP_SERIALIZE_FIELD("referrerPolicy", m_referrerPolicy);
    CRDTP_SERIALIZE_FIELD("isLinkPreload", m_isLinkPreload);
    CRDTP_SERIALIZE_FIELD("trustTokenParams", m_trustTokenParams);
    CRDTP_SERIALIZE_FIELD("isSameSite", m_isSameSite);
    CRDTP_SERIALIZE_FIELD("isAdRelated", m_isAdRelated);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SignedCertificateTimestamp)
    CRDTP_DESERIALIZE_FIELD("hashAlgorithm", m_hashAlgorithm),
    CRDTP_DESERIALIZE_FIELD("logDescription", m_logDescription),
    CRDTP_DESERIALIZE_FIELD("logId", m_logId),
    CRDTP_DESERIALIZE_FIELD("origin", m_origin),
    CRDTP_DESERIALIZE_FIELD("signatureAlgorithm", m_signatureAlgorithm),
    CRDTP_DESERIALIZE_FIELD("signatureData", m_signatureData),
    CRDTP_DESERIALIZE_FIELD("status", m_status),
    CRDTP_DESERIALIZE_FIELD("timestamp", m_timestamp),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SignedCertificateTimestamp)
    CRDTP_SERIALIZE_FIELD("status", m_status);
    CRDTP_SERIALIZE_FIELD("origin", m_origin);
    CRDTP_SERIALIZE_FIELD("logDescription", m_logDescription);
    CRDTP_SERIALIZE_FIELD("logId", m_logId);
    CRDTP_SERIALIZE_FIELD("timestamp", m_timestamp);
    CRDTP_SERIALIZE_FIELD("hashAlgorithm", m_hashAlgorithm);
    CRDTP_SERIALIZE_FIELD("signatureAlgorithm", m_signatureAlgorithm);
    CRDTP_SERIALIZE_FIELD("signatureData", m_signatureData);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SecurityDetails)
    CRDTP_DESERIALIZE_FIELD("certificateId", m_certificateId),
    CRDTP_DESERIALIZE_FIELD("certificateTransparencyCompliance", m_certificateTransparencyCompliance),
    CRDTP_DESERIALIZE_FIELD("cipher", m_cipher),
    CRDTP_DESERIALIZE_FIELD("encryptedClientHello", m_encryptedClientHello),
    CRDTP_DESERIALIZE_FIELD("issuer", m_issuer),
    CRDTP_DESERIALIZE_FIELD("keyExchange", m_keyExchange),
    CRDTP_DESERIALIZE_FIELD_OPT("keyExchangeGroup", m_keyExchangeGroup),
    CRDTP_DESERIALIZE_FIELD_OPT("mac", m_mac),
    CRDTP_DESERIALIZE_FIELD("protocol", m_protocol),
    CRDTP_DESERIALIZE_FIELD("sanList", m_sanList),
    CRDTP_DESERIALIZE_FIELD_OPT("serverSignatureAlgorithm", m_serverSignatureAlgorithm),
    CRDTP_DESERIALIZE_FIELD("signedCertificateTimestampList", m_signedCertificateTimestampList),
    CRDTP_DESERIALIZE_FIELD("subjectName", m_subjectName),
    CRDTP_DESERIALIZE_FIELD("validFrom", m_validFrom),
    CRDTP_DESERIALIZE_FIELD("validTo", m_validTo),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SecurityDetails)
    CRDTP_SERIALIZE_FIELD("protocol", m_protocol);
    CRDTP_SERIALIZE_FIELD("keyExchange", m_keyExchange);
    CRDTP_SERIALIZE_FIELD("keyExchangeGroup", m_keyExchangeGroup);
    CRDTP_SERIALIZE_FIELD("cipher", m_cipher);
    CRDTP_SERIALIZE_FIELD("mac", m_mac);
    CRDTP_SERIALIZE_FIELD("certificateId", m_certificateId);
    CRDTP_SERIALIZE_FIELD("subjectName", m_subjectName);
    CRDTP_SERIALIZE_FIELD("sanList", m_sanList);
    CRDTP_SERIALIZE_FIELD("issuer", m_issuer);
    CRDTP_SERIALIZE_FIELD("validFrom", m_validFrom);
    CRDTP_SERIALIZE_FIELD("validTo", m_validTo);
    CRDTP_SERIALIZE_FIELD("signedCertificateTimestampList", m_signedCertificateTimestampList);
    CRDTP_SERIALIZE_FIELD("certificateTransparencyCompliance", m_certificateTransparencyCompliance);
    CRDTP_SERIALIZE_FIELD("serverSignatureAlgorithm", m_serverSignatureAlgorithm);
    CRDTP_SERIALIZE_FIELD("encryptedClientHello", m_encryptedClientHello);
CRDTP_END_SERIALIZER();


namespace CertificateTransparencyComplianceEnum {
const char Unknown[] = "unknown";
const char NotCompliant[] = "not-compliant";
const char Compliant[] = "compliant";
} // namespace CertificateTransparencyComplianceEnum


namespace BlockedReasonEnum {
const char Other[] = "other";
const char Csp[] = "csp";
const char MixedContent[] = "mixed-content";
const char Origin[] = "origin";
const char Inspector[] = "inspector";
const char Integrity[] = "integrity";
const char SubresourceFilter[] = "subresource-filter";
const char ContentType[] = "content-type";
const char CoepFrameResourceNeedsCoepHeader[] = "coep-frame-resource-needs-coep-header";
const char CoopSandboxedIframeCannotNavigateToCoopPage[] = "coop-sandboxed-iframe-cannot-navigate-to-coop-page";
const char CorpNotSameOrigin[] = "corp-not-same-origin";
const char CorpNotSameOriginAfterDefaultedToSameOriginByCoep[] = "corp-not-same-origin-after-defaulted-to-same-origin-by-coep";
const char CorpNotSameOriginAfterDefaultedToSameOriginByDip[] = "corp-not-same-origin-after-defaulted-to-same-origin-by-dip";
const char CorpNotSameOriginAfterDefaultedToSameOriginByCoepAndDip[] = "corp-not-same-origin-after-defaulted-to-same-origin-by-coep-and-dip";
const char CorpNotSameSite[] = "corp-not-same-site";
const char SriMessageSignatureMismatch[] = "sri-message-signature-mismatch";
} // namespace BlockedReasonEnum


namespace CorsErrorEnum {
const char DisallowedByMode[] = "DisallowedByMode";
const char InvalidResponse[] = "InvalidResponse";
const char WildcardOriginNotAllowed[] = "WildcardOriginNotAllowed";
const char MissingAllowOriginHeader[] = "MissingAllowOriginHeader";
const char MultipleAllowOriginValues[] = "MultipleAllowOriginValues";
const char InvalidAllowOriginValue[] = "InvalidAllowOriginValue";
const char AllowOriginMismatch[] = "AllowOriginMismatch";
const char InvalidAllowCredentials[] = "InvalidAllowCredentials";
const char CorsDisabledScheme[] = "CorsDisabledScheme";
const char PreflightInvalidStatus[] = "PreflightInvalidStatus";
const char PreflightDisallowedRedirect[] = "PreflightDisallowedRedirect";
const char PreflightWildcardOriginNotAllowed[] = "PreflightWildcardOriginNotAllowed";
const char PreflightMissingAllowOriginHeader[] = "PreflightMissingAllowOriginHeader";
const char PreflightMultipleAllowOriginValues[] = "PreflightMultipleAllowOriginValues";
const char PreflightInvalidAllowOriginValue[] = "PreflightInvalidAllowOriginValue";
const char PreflightAllowOriginMismatch[] = "PreflightAllowOriginMismatch";
const char PreflightInvalidAllowCredentials[] = "PreflightInvalidAllowCredentials";
const char PreflightMissingAllowExternal[] = "PreflightMissingAllowExternal";
const char PreflightInvalidAllowExternal[] = "PreflightInvalidAllowExternal";
const char PreflightMissingAllowPrivateNetwork[] = "PreflightMissingAllowPrivateNetwork";
const char PreflightInvalidAllowPrivateNetwork[] = "PreflightInvalidAllowPrivateNetwork";
const char InvalidAllowMethodsPreflightResponse[] = "InvalidAllowMethodsPreflightResponse";
const char InvalidAllowHeadersPreflightResponse[] = "InvalidAllowHeadersPreflightResponse";
const char MethodDisallowedByPreflightResponse[] = "MethodDisallowedByPreflightResponse";
const char HeaderDisallowedByPreflightResponse[] = "HeaderDisallowedByPreflightResponse";
const char RedirectContainsCredentials[] = "RedirectContainsCredentials";
const char InsecurePrivateNetwork[] = "InsecurePrivateNetwork";
const char InvalidPrivateNetworkAccess[] = "InvalidPrivateNetworkAccess";
const char UnexpectedPrivateNetworkAccess[] = "UnexpectedPrivateNetworkAccess";
const char NoCorsRedirectModeNotFollow[] = "NoCorsRedirectModeNotFollow";
const char PreflightMissingPrivateNetworkAccessId[] = "PreflightMissingPrivateNetworkAccessId";
const char PreflightMissingPrivateNetworkAccessName[] = "PreflightMissingPrivateNetworkAccessName";
const char PrivateNetworkAccessPermissionUnavailable[] = "PrivateNetworkAccessPermissionUnavailable";
const char PrivateNetworkAccessPermissionDenied[] = "PrivateNetworkAccessPermissionDenied";
const char LocalNetworkAccessPermissionDenied[] = "LocalNetworkAccessPermissionDenied";
} // namespace CorsErrorEnum


CRDTP_BEGIN_DESERIALIZER(CorsErrorStatus)
    CRDTP_DESERIALIZE_FIELD("corsError", m_corsError),
    CRDTP_DESERIALIZE_FIELD("failedParameter", m_failedParameter),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CorsErrorStatus)
    CRDTP_SERIALIZE_FIELD("corsError", m_corsError);
    CRDTP_SERIALIZE_FIELD("failedParameter", m_failedParameter);
CRDTP_END_SERIALIZER();


namespace ServiceWorkerResponseSourceEnum {
const char CacheStorage[] = "cache-storage";
const char HttpCache[] = "http-cache";
const char FallbackCode[] = "fallback-code";
const char Network[] = "network";
} // namespace ServiceWorkerResponseSourceEnum



const char* TrustTokenParams::RefreshPolicyEnum::UseCached = "UseCached";
const char* TrustTokenParams::RefreshPolicyEnum::Refresh = "Refresh";
CRDTP_BEGIN_DESERIALIZER(TrustTokenParams)
    CRDTP_DESERIALIZE_FIELD_OPT("issuers", m_issuers),
    CRDTP_DESERIALIZE_FIELD("operation", m_operation),
    CRDTP_DESERIALIZE_FIELD("refreshPolicy", m_refreshPolicy),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(TrustTokenParams)
    CRDTP_SERIALIZE_FIELD("operation", m_operation);
    CRDTP_SERIALIZE_FIELD("refreshPolicy", m_refreshPolicy);
    CRDTP_SERIALIZE_FIELD("issuers", m_issuers);
CRDTP_END_SERIALIZER();


namespace TrustTokenOperationTypeEnum {
const char Issuance[] = "Issuance";
const char Redemption[] = "Redemption";
const char Signing[] = "Signing";
} // namespace TrustTokenOperationTypeEnum


namespace AlternateProtocolUsageEnum {
const char AlternativeJobWonWithoutRace[] = "alternativeJobWonWithoutRace";
const char AlternativeJobWonRace[] = "alternativeJobWonRace";
const char MainJobWonRace[] = "mainJobWonRace";
const char MappingMissing[] = "mappingMissing";
const char Broken[] = "broken";
const char DnsAlpnH3JobWonWithoutRace[] = "dnsAlpnH3JobWonWithoutRace";
const char DnsAlpnH3JobWonRace[] = "dnsAlpnH3JobWonRace";
const char UnspecifiedReason[] = "unspecifiedReason";
} // namespace AlternateProtocolUsageEnum


namespace ServiceWorkerRouterSourceEnum {
const char Network[] = "network";
const char Cache[] = "cache";
const char FetchEvent[] = "fetch-event";
const char RaceNetworkAndFetchHandler[] = "race-network-and-fetch-handler";
const char RaceNetworkAndCache[] = "race-network-and-cache";
} // namespace ServiceWorkerRouterSourceEnum


CRDTP_BEGIN_DESERIALIZER(ServiceWorkerRouterInfo)
    CRDTP_DESERIALIZE_FIELD_OPT("actualSourceType", m_actualSourceType),
    CRDTP_DESERIALIZE_FIELD_OPT("matchedSourceType", m_matchedSourceType),
    CRDTP_DESERIALIZE_FIELD_OPT("ruleIdMatched", m_ruleIdMatched),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ServiceWorkerRouterInfo)
    CRDTP_SERIALIZE_FIELD("ruleIdMatched", m_ruleIdMatched);
    CRDTP_SERIALIZE_FIELD("matchedSourceType", m_matchedSourceType);
    CRDTP_SERIALIZE_FIELD("actualSourceType", m_actualSourceType);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Response)
    CRDTP_DESERIALIZE_FIELD_OPT("alternateProtocolUsage", m_alternateProtocolUsage),
    CRDTP_DESERIALIZE_FIELD_OPT("cacheStorageCacheName", m_cacheStorageCacheName),
    CRDTP_DESERIALIZE_FIELD("charset", m_charset),
    CRDTP_DESERIALIZE_FIELD("connectionId", m_connectionId),
    CRDTP_DESERIALIZE_FIELD("connectionReused", m_connectionReused),
    CRDTP_DESERIALIZE_FIELD("encodedDataLength", m_encodedDataLength),
    CRDTP_DESERIALIZE_FIELD_OPT("fromDiskCache", m_fromDiskCache),
    CRDTP_DESERIALIZE_FIELD_OPT("fromEarlyHints", m_fromEarlyHints),
    CRDTP_DESERIALIZE_FIELD_OPT("fromPrefetchCache", m_fromPrefetchCache),
    CRDTP_DESERIALIZE_FIELD_OPT("fromServiceWorker", m_fromServiceWorker),
    CRDTP_DESERIALIZE_FIELD("headers", m_headers),
    CRDTP_DESERIALIZE_FIELD_OPT("headersText", m_headersText),
    CRDTP_DESERIALIZE_FIELD_OPT("isIpProtectionUsed", m_isIpProtectionUsed),
    CRDTP_DESERIALIZE_FIELD("mimeType", m_mimeType),
    CRDTP_DESERIALIZE_FIELD_OPT("protocol", m_protocol),
    CRDTP_DESERIALIZE_FIELD_OPT("remoteIPAddress", m_remoteIPAddress),
    CRDTP_DESERIALIZE_FIELD_OPT("remotePort", m_remotePort),
    CRDTP_DESERIALIZE_FIELD_OPT("requestHeaders", m_requestHeaders),
    CRDTP_DESERIALIZE_FIELD_OPT("requestHeadersText", m_requestHeadersText),
    CRDTP_DESERIALIZE_FIELD_OPT("responseTime", m_responseTime),
    CRDTP_DESERIALIZE_FIELD_OPT("securityDetails", m_securityDetails),
    CRDTP_DESERIALIZE_FIELD("securityState", m_securityState),
    CRDTP_DESERIALIZE_FIELD_OPT("serviceWorkerResponseSource", m_serviceWorkerResponseSource),
    CRDTP_DESERIALIZE_FIELD_OPT("serviceWorkerRouterInfo", m_serviceWorkerRouterInfo),
    CRDTP_DESERIALIZE_FIELD("status", m_status),
    CRDTP_DESERIALIZE_FIELD("statusText", m_statusText),
    CRDTP_DESERIALIZE_FIELD_OPT("timing", m_timing),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Response)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("status", m_status);
    CRDTP_SERIALIZE_FIELD("statusText", m_statusText);
    CRDTP_SERIALIZE_FIELD("headers", m_headers);
    CRDTP_SERIALIZE_FIELD("headersText", m_headersText);
    CRDTP_SERIALIZE_FIELD("mimeType", m_mimeType);
    CRDTP_SERIALIZE_FIELD("charset", m_charset);
    CRDTP_SERIALIZE_FIELD("requestHeaders", m_requestHeaders);
    CRDTP_SERIALIZE_FIELD("requestHeadersText", m_requestHeadersText);
    CRDTP_SERIALIZE_FIELD("connectionReused", m_connectionReused);
    CRDTP_SERIALIZE_FIELD("connectionId", m_connectionId);
    CRDTP_SERIALIZE_FIELD("remoteIPAddress", m_remoteIPAddress);
    CRDTP_SERIALIZE_FIELD("remotePort", m_remotePort);
    CRDTP_SERIALIZE_FIELD("fromDiskCache", m_fromDiskCache);
    CRDTP_SERIALIZE_FIELD("fromServiceWorker", m_fromServiceWorker);
    CRDTP_SERIALIZE_FIELD("fromPrefetchCache", m_fromPrefetchCache);
    CRDTP_SERIALIZE_FIELD("fromEarlyHints", m_fromEarlyHints);
    CRDTP_SERIALIZE_FIELD("serviceWorkerRouterInfo", m_serviceWorkerRouterInfo);
    CRDTP_SERIALIZE_FIELD("encodedDataLength", m_encodedDataLength);
    CRDTP_SERIALIZE_FIELD("timing", m_timing);
    CRDTP_SERIALIZE_FIELD("serviceWorkerResponseSource", m_serviceWorkerResponseSource);
    CRDTP_SERIALIZE_FIELD("responseTime", m_responseTime);
    CRDTP_SERIALIZE_FIELD("cacheStorageCacheName", m_cacheStorageCacheName);
    CRDTP_SERIALIZE_FIELD("protocol", m_protocol);
    CRDTP_SERIALIZE_FIELD("alternateProtocolUsage", m_alternateProtocolUsage);
    CRDTP_SERIALIZE_FIELD("securityState", m_securityState);
    CRDTP_SERIALIZE_FIELD("securityDetails", m_securityDetails);
    CRDTP_SERIALIZE_FIELD("isIpProtectionUsed", m_isIpProtectionUsed);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(WebSocketRequest)
    CRDTP_DESERIALIZE_FIELD("headers", m_headers),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(WebSocketRequest)
    CRDTP_SERIALIZE_FIELD("headers", m_headers);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(WebSocketResponse)
    CRDTP_DESERIALIZE_FIELD("headers", m_headers),
    CRDTP_DESERIALIZE_FIELD_OPT("headersText", m_headersText),
    CRDTP_DESERIALIZE_FIELD_OPT("requestHeaders", m_requestHeaders),
    CRDTP_DESERIALIZE_FIELD_OPT("requestHeadersText", m_requestHeadersText),
    CRDTP_DESERIALIZE_FIELD("status", m_status),
    CRDTP_DESERIALIZE_FIELD("statusText", m_statusText),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(WebSocketResponse)
    CRDTP_SERIALIZE_FIELD("status", m_status);
    CRDTP_SERIALIZE_FIELD("statusText", m_statusText);
    CRDTP_SERIALIZE_FIELD("headers", m_headers);
    CRDTP_SERIALIZE_FIELD("headersText", m_headersText);
    CRDTP_SERIALIZE_FIELD("requestHeaders", m_requestHeaders);
    CRDTP_SERIALIZE_FIELD("requestHeadersText", m_requestHeadersText);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(WebSocketFrame)
    CRDTP_DESERIALIZE_FIELD("mask", m_mask),
    CRDTP_DESERIALIZE_FIELD("opcode", m_opcode),
    CRDTP_DESERIALIZE_FIELD("payloadData", m_payloadData),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(WebSocketFrame)
    CRDTP_SERIALIZE_FIELD("opcode", m_opcode);
    CRDTP_SERIALIZE_FIELD("mask", m_mask);
    CRDTP_SERIALIZE_FIELD("payloadData", m_payloadData);
CRDTP_END_SERIALIZER();



const char* Initiator::TypeEnum::Parser = "parser";
const char* Initiator::TypeEnum::Script = "script";
const char* Initiator::TypeEnum::Preload = "preload";
const char* Initiator::TypeEnum::SignedExchange = "SignedExchange";
const char* Initiator::TypeEnum::Preflight = "preflight";
const char* Initiator::TypeEnum::FedCM = "FedCM";
const char* Initiator::TypeEnum::Other = "other";
CRDTP_BEGIN_DESERIALIZER(Initiator)
    CRDTP_DESERIALIZE_FIELD_OPT("columnNumber", m_columnNumber),
    CRDTP_DESERIALIZE_FIELD_OPT("lineNumber", m_lineNumber),
    CRDTP_DESERIALIZE_FIELD_OPT("requestId", m_requestId),
    CRDTP_DESERIALIZE_FIELD_OPT("stack", m_stack),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
    CRDTP_DESERIALIZE_FIELD_OPT("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Initiator)
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("stack", m_stack);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("lineNumber", m_lineNumber);
    CRDTP_SERIALIZE_FIELD("columnNumber", m_columnNumber);
    CRDTP_SERIALIZE_FIELD("requestId", m_requestId);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CookiePartitionKey)
    CRDTP_DESERIALIZE_FIELD("hasCrossSiteAncestor", m_hasCrossSiteAncestor),
    CRDTP_DESERIALIZE_FIELD("topLevelSite", m_topLevelSite),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CookiePartitionKey)
    CRDTP_SERIALIZE_FIELD("topLevelSite", m_topLevelSite);
    CRDTP_SERIALIZE_FIELD("hasCrossSiteAncestor", m_hasCrossSiteAncestor);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Cookie)
    CRDTP_DESERIALIZE_FIELD("domain", m_domain),
    CRDTP_DESERIALIZE_FIELD("expires", m_expires),
    CRDTP_DESERIALIZE_FIELD("httpOnly", m_httpOnly),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD_OPT("partitionKey", m_partitionKey),
    CRDTP_DESERIALIZE_FIELD_OPT("partitionKeyOpaque", m_partitionKeyOpaque),
    CRDTP_DESERIALIZE_FIELD("path", m_path),
    CRDTP_DESERIALIZE_FIELD("priority", m_priority),
    CRDTP_DESERIALIZE_FIELD("sameParty", m_sameParty),
    CRDTP_DESERIALIZE_FIELD_OPT("sameSite", m_sameSite),
    CRDTP_DESERIALIZE_FIELD("secure", m_secure),
    CRDTP_DESERIALIZE_FIELD("session", m_session),
    CRDTP_DESERIALIZE_FIELD("size", m_size),
    CRDTP_DESERIALIZE_FIELD("sourcePort", m_sourcePort),
    CRDTP_DESERIALIZE_FIELD("sourceScheme", m_sourceScheme),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Cookie)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("domain", m_domain);
    CRDTP_SERIALIZE_FIELD("path", m_path);
    CRDTP_SERIALIZE_FIELD("expires", m_expires);
    CRDTP_SERIALIZE_FIELD("size", m_size);
    CRDTP_SERIALIZE_FIELD("httpOnly", m_httpOnly);
    CRDTP_SERIALIZE_FIELD("secure", m_secure);
    CRDTP_SERIALIZE_FIELD("session", m_session);
    CRDTP_SERIALIZE_FIELD("sameSite", m_sameSite);
    CRDTP_SERIALIZE_FIELD("priority", m_priority);
    CRDTP_SERIALIZE_FIELD("sameParty", m_sameParty);
    CRDTP_SERIALIZE_FIELD("sourceScheme", m_sourceScheme);
    CRDTP_SERIALIZE_FIELD("sourcePort", m_sourcePort);
    CRDTP_SERIALIZE_FIELD("partitionKey", m_partitionKey);
    CRDTP_SERIALIZE_FIELD("partitionKeyOpaque", m_partitionKeyOpaque);
CRDTP_END_SERIALIZER();


namespace SetCookieBlockedReasonEnum {
const char SecureOnly[] = "SecureOnly";
const char SameSiteStrict[] = "SameSiteStrict";
const char SameSiteLax[] = "SameSiteLax";
const char SameSiteUnspecifiedTreatedAsLax[] = "SameSiteUnspecifiedTreatedAsLax";
const char SameSiteNoneInsecure[] = "SameSiteNoneInsecure";
const char UserPreferences[] = "UserPreferences";
const char ThirdPartyPhaseout[] = "ThirdPartyPhaseout";
const char ThirdPartyBlockedInFirstPartySet[] = "ThirdPartyBlockedInFirstPartySet";
const char SyntaxError[] = "SyntaxError";
const char SchemeNotSupported[] = "SchemeNotSupported";
const char OverwriteSecure[] = "OverwriteSecure";
const char InvalidDomain[] = "InvalidDomain";
const char InvalidPrefix[] = "InvalidPrefix";
const char UnknownError[] = "UnknownError";
const char SchemefulSameSiteStrict[] = "SchemefulSameSiteStrict";
const char SchemefulSameSiteLax[] = "SchemefulSameSiteLax";
const char SchemefulSameSiteUnspecifiedTreatedAsLax[] = "SchemefulSameSiteUnspecifiedTreatedAsLax";
const char SamePartyFromCrossPartyContext[] = "SamePartyFromCrossPartyContext";
const char SamePartyConflictsWithOtherAttributes[] = "SamePartyConflictsWithOtherAttributes";
const char NameValuePairExceedsMaxSize[] = "NameValuePairExceedsMaxSize";
const char DisallowedCharacter[] = "DisallowedCharacter";
const char NoCookieContent[] = "NoCookieContent";
} // namespace SetCookieBlockedReasonEnum


namespace CookieBlockedReasonEnum {
const char SecureOnly[] = "SecureOnly";
const char NotOnPath[] = "NotOnPath";
const char DomainMismatch[] = "DomainMismatch";
const char SameSiteStrict[] = "SameSiteStrict";
const char SameSiteLax[] = "SameSiteLax";
const char SameSiteUnspecifiedTreatedAsLax[] = "SameSiteUnspecifiedTreatedAsLax";
const char SameSiteNoneInsecure[] = "SameSiteNoneInsecure";
const char UserPreferences[] = "UserPreferences";
const char ThirdPartyPhaseout[] = "ThirdPartyPhaseout";
const char ThirdPartyBlockedInFirstPartySet[] = "ThirdPartyBlockedInFirstPartySet";
const char UnknownError[] = "UnknownError";
const char SchemefulSameSiteStrict[] = "SchemefulSameSiteStrict";
const char SchemefulSameSiteLax[] = "SchemefulSameSiteLax";
const char SchemefulSameSiteUnspecifiedTreatedAsLax[] = "SchemefulSameSiteUnspecifiedTreatedAsLax";
const char SamePartyFromCrossPartyContext[] = "SamePartyFromCrossPartyContext";
const char NameValuePairExceedsMaxSize[] = "NameValuePairExceedsMaxSize";
const char PortMismatch[] = "PortMismatch";
const char SchemeMismatch[] = "SchemeMismatch";
const char AnonymousContext[] = "AnonymousContext";
} // namespace CookieBlockedReasonEnum


namespace CookieExemptionReasonEnum {
const char None[] = "None";
const char UserSetting[] = "UserSetting";
const char TPCDMetadata[] = "TPCDMetadata";
const char TPCDDeprecationTrial[] = "TPCDDeprecationTrial";
const char TopLevelTPCDDeprecationTrial[] = "TopLevelTPCDDeprecationTrial";
const char TPCDHeuristics[] = "TPCDHeuristics";
const char EnterprisePolicy[] = "EnterprisePolicy";
const char StorageAccess[] = "StorageAccess";
const char TopLevelStorageAccess[] = "TopLevelStorageAccess";
const char Scheme[] = "Scheme";
const char SameSiteNoneCookiesInSandbox[] = "SameSiteNoneCookiesInSandbox";
} // namespace CookieExemptionReasonEnum


CRDTP_BEGIN_DESERIALIZER(BlockedSetCookieWithReason)
    CRDTP_DESERIALIZE_FIELD("blockedReasons", m_blockedReasons),
    CRDTP_DESERIALIZE_FIELD_OPT("cookie", m_cookie),
    CRDTP_DESERIALIZE_FIELD("cookieLine", m_cookieLine),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BlockedSetCookieWithReason)
    CRDTP_SERIALIZE_FIELD("blockedReasons", m_blockedReasons);
    CRDTP_SERIALIZE_FIELD("cookieLine", m_cookieLine);
    CRDTP_SERIALIZE_FIELD("cookie", m_cookie);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ExemptedSetCookieWithReason)
    CRDTP_DESERIALIZE_FIELD("cookie", m_cookie),
    CRDTP_DESERIALIZE_FIELD("cookieLine", m_cookieLine),
    CRDTP_DESERIALIZE_FIELD("exemptionReason", m_exemptionReason),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ExemptedSetCookieWithReason)
    CRDTP_SERIALIZE_FIELD("exemptionReason", m_exemptionReason);
    CRDTP_SERIALIZE_FIELD("cookieLine", m_cookieLine);
    CRDTP_SERIALIZE_FIELD("cookie", m_cookie);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(AssociatedCookie)
    CRDTP_DESERIALIZE_FIELD("blockedReasons", m_blockedReasons),
    CRDTP_DESERIALIZE_FIELD("cookie", m_cookie),
    CRDTP_DESERIALIZE_FIELD_OPT("exemptionReason", m_exemptionReason),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AssociatedCookie)
    CRDTP_SERIALIZE_FIELD("cookie", m_cookie);
    CRDTP_SERIALIZE_FIELD("blockedReasons", m_blockedReasons);
    CRDTP_SERIALIZE_FIELD("exemptionReason", m_exemptionReason);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(CookieParam)
    CRDTP_DESERIALIZE_FIELD_OPT("domain", m_domain),
    CRDTP_DESERIALIZE_FIELD_OPT("expires", m_expires),
    CRDTP_DESERIALIZE_FIELD_OPT("httpOnly", m_httpOnly),
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD_OPT("partitionKey", m_partitionKey),
    CRDTP_DESERIALIZE_FIELD_OPT("path", m_path),
    CRDTP_DESERIALIZE_FIELD_OPT("priority", m_priority),
    CRDTP_DESERIALIZE_FIELD_OPT("sameParty", m_sameParty),
    CRDTP_DESERIALIZE_FIELD_OPT("sameSite", m_sameSite),
    CRDTP_DESERIALIZE_FIELD_OPT("secure", m_secure),
    CRDTP_DESERIALIZE_FIELD_OPT("sourcePort", m_sourcePort),
    CRDTP_DESERIALIZE_FIELD_OPT("sourceScheme", m_sourceScheme),
    CRDTP_DESERIALIZE_FIELD_OPT("url", m_url),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(CookieParam)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("domain", m_domain);
    CRDTP_SERIALIZE_FIELD("path", m_path);
    CRDTP_SERIALIZE_FIELD("secure", m_secure);
    CRDTP_SERIALIZE_FIELD("httpOnly", m_httpOnly);
    CRDTP_SERIALIZE_FIELD("sameSite", m_sameSite);
    CRDTP_SERIALIZE_FIELD("expires", m_expires);
    CRDTP_SERIALIZE_FIELD("priority", m_priority);
    CRDTP_SERIALIZE_FIELD("sameParty", m_sameParty);
    CRDTP_SERIALIZE_FIELD("sourceScheme", m_sourceScheme);
    CRDTP_SERIALIZE_FIELD("sourcePort", m_sourcePort);
    CRDTP_SERIALIZE_FIELD("partitionKey", m_partitionKey);
CRDTP_END_SERIALIZER();



const char* AuthChallenge::SourceEnum::Server = "Server";
const char* AuthChallenge::SourceEnum::Proxy = "Proxy";
CRDTP_BEGIN_DESERIALIZER(AuthChallenge)
    CRDTP_DESERIALIZE_FIELD("origin", m_origin),
    CRDTP_DESERIALIZE_FIELD("realm", m_realm),
    CRDTP_DESERIALIZE_FIELD("scheme", m_scheme),
    CRDTP_DESERIALIZE_FIELD_OPT("source", m_source),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(AuthChallenge)
    CRDTP_SERIALIZE_FIELD("source", m_source);
    CRDTP_SERIALIZE_FIELD("origin", m_origin);
    CRDTP_SERIALIZE_FIELD("scheme", m_scheme);
    CRDTP_SERIALIZE_FIELD("realm", m_realm);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SignedExchangeSignature)
    CRDTP_DESERIALIZE_FIELD_OPT("certSha256", m_certSha256),
    CRDTP_DESERIALIZE_FIELD_OPT("certUrl", m_certUrl),
    CRDTP_DESERIALIZE_FIELD_OPT("certificates", m_certificates),
    CRDTP_DESERIALIZE_FIELD("date", m_date),
    CRDTP_DESERIALIZE_FIELD("expires", m_expires),
    CRDTP_DESERIALIZE_FIELD("integrity", m_integrity),
    CRDTP_DESERIALIZE_FIELD("label", m_label),
    CRDTP_DESERIALIZE_FIELD("signature", m_signature),
    CRDTP_DESERIALIZE_FIELD("validityUrl", m_validityUrl),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SignedExchangeSignature)
    CRDTP_SERIALIZE_FIELD("label", m_label);
    CRDTP_SERIALIZE_FIELD("signature", m_signature);
    CRDTP_SERIALIZE_FIELD("integrity", m_integrity);
    CRDTP_SERIALIZE_FIELD("certUrl", m_certUrl);
    CRDTP_SERIALIZE_FIELD("certSha256", m_certSha256);
    CRDTP_SERIALIZE_FIELD("validityUrl", m_validityUrl);
    CRDTP_SERIALIZE_FIELD("date", m_date);
    CRDTP_SERIALIZE_FIELD("expires", m_expires);
    CRDTP_SERIALIZE_FIELD("certificates", m_certificates);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SignedExchangeHeader)
    CRDTP_DESERIALIZE_FIELD("headerIntegrity", m_headerIntegrity),
    CRDTP_DESERIALIZE_FIELD("requestUrl", m_requestUrl),
    CRDTP_DESERIALIZE_FIELD("responseCode", m_responseCode),
    CRDTP_DESERIALIZE_FIELD("responseHeaders", m_responseHeaders),
    CRDTP_DESERIALIZE_FIELD("signatures", m_signatures),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SignedExchangeHeader)
    CRDTP_SERIALIZE_FIELD("requestUrl", m_requestUrl);
    CRDTP_SERIALIZE_FIELD("responseCode", m_responseCode);
    CRDTP_SERIALIZE_FIELD("responseHeaders", m_responseHeaders);
    CRDTP_SERIALIZE_FIELD("signatures", m_signatures);
    CRDTP_SERIALIZE_FIELD("headerIntegrity", m_headerIntegrity);
CRDTP_END_SERIALIZER();


namespace SignedExchangeErrorFieldEnum {
const char SignatureSig[] = "signatureSig";
const char SignatureIntegrity[] = "signatureIntegrity";
const char SignatureCertUrl[] = "signatureCertUrl";
const char SignatureCertSha256[] = "signatureCertSha256";
const char SignatureValidityUrl[] = "signatureValidityUrl";
const char SignatureTimestamps[] = "signatureTimestamps";
} // namespace SignedExchangeErrorFieldEnum


CRDTP_BEGIN_DESERIALIZER(SignedExchangeError)
    CRDTP_DESERIALIZE_FIELD_OPT("errorField", m_errorField),
    CRDTP_DESERIALIZE_FIELD("message", m_message),
    CRDTP_DESERIALIZE_FIELD_OPT("signatureIndex", m_signatureIndex),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SignedExchangeError)
    CRDTP_SERIALIZE_FIELD("message", m_message);
    CRDTP_SERIALIZE_FIELD("signatureIndex", m_signatureIndex);
    CRDTP_SERIALIZE_FIELD("errorField", m_errorField);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(SignedExchangeInfo)
    CRDTP_DESERIALIZE_FIELD_OPT("errors", m_errors),
    CRDTP_DESERIALIZE_FIELD("hasExtraInfo", m_hasExtraInfo),
    CRDTP_DESERIALIZE_FIELD_OPT("header", m_header),
    CRDTP_DESERIALIZE_FIELD("outerResponse", m_outerResponse),
    CRDTP_DESERIALIZE_FIELD_OPT("securityDetails", m_securityDetails),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(SignedExchangeInfo)
    CRDTP_SERIALIZE_FIELD("outerResponse", m_outerResponse);
    CRDTP_SERIALIZE_FIELD("hasExtraInfo", m_hasExtraInfo);
    CRDTP_SERIALIZE_FIELD("header", m_header);
    CRDTP_SERIALIZE_FIELD("securityDetails", m_securityDetails);
    CRDTP_SERIALIZE_FIELD("errors", m_errors);
CRDTP_END_SERIALIZER();


namespace ContentEncodingEnum {
const char Deflate[] = "deflate";
const char Gzip[] = "gzip";
const char Br[] = "br";
const char Zstd[] = "zstd";
} // namespace ContentEncodingEnum


CRDTP_BEGIN_DESERIALIZER(NetworkConditions)
    CRDTP_DESERIALIZE_FIELD_OPT("connectionType", m_connectionType),
    CRDTP_DESERIALIZE_FIELD("downloadThroughput", m_downloadThroughput),
    CRDTP_DESERIALIZE_FIELD("latency", m_latency),
    CRDTP_DESERIALIZE_FIELD_OPT("packetLoss", m_packetLoss),
    CRDTP_DESERIALIZE_FIELD_OPT("packetQueueLength", m_packetQueueLength),
    CRDTP_DESERIALIZE_FIELD_OPT("packetReordering", m_packetReordering),
    CRDTP_DESERIALIZE_FIELD("uploadThroughput", m_uploadThroughput),
    CRDTP_DESERIALIZE_FIELD("urlPattern", m_urlPattern),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(NetworkConditions)
    CRDTP_SERIALIZE_FIELD("urlPattern", m_urlPattern);
    CRDTP_SERIALIZE_FIELD("latency", m_latency);
    CRDTP_SERIALIZE_FIELD("downloadThroughput", m_downloadThroughput);
    CRDTP_SERIALIZE_FIELD("uploadThroughput", m_uploadThroughput);
    CRDTP_SERIALIZE_FIELD("connectionType", m_connectionType);
    CRDTP_SERIALIZE_FIELD("packetLoss", m_packetLoss);
    CRDTP_SERIALIZE_FIELD("packetQueueLength", m_packetQueueLength);
    CRDTP_SERIALIZE_FIELD("packetReordering", m_packetReordering);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(BlockPattern)
    CRDTP_DESERIALIZE_FIELD("block", m_block),
    CRDTP_DESERIALIZE_FIELD("urlPattern", m_urlPattern),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BlockPattern)
    CRDTP_SERIALIZE_FIELD("urlPattern", m_urlPattern);
    CRDTP_SERIALIZE_FIELD("block", m_block);
CRDTP_END_SERIALIZER();


namespace DirectSocketDnsQueryTypeEnum {
const char Ipv4[] = "ipv4";
const char Ipv6[] = "ipv6";
} // namespace DirectSocketDnsQueryTypeEnum


CRDTP_BEGIN_DESERIALIZER(DirectTCPSocketOptions)
    CRDTP_DESERIALIZE_FIELD_OPT("dnsQueryType", m_dnsQueryType),
    CRDTP_DESERIALIZE_FIELD_OPT("keepAliveDelay", m_keepAliveDelay),
    CRDTP_DESERIALIZE_FIELD("noDelay", m_noDelay),
    CRDTP_DESERIALIZE_FIELD_OPT("receiveBufferSize", m_receiveBufferSize),
    CRDTP_DESERIALIZE_FIELD_OPT("sendBufferSize", m_sendBufferSize),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DirectTCPSocketOptions)
    CRDTP_SERIALIZE_FIELD("noDelay", m_noDelay);
    CRDTP_SERIALIZE_FIELD("keepAliveDelay", m_keepAliveDelay);
    CRDTP_SERIALIZE_FIELD("sendBufferSize", m_sendBufferSize);
    CRDTP_SERIALIZE_FIELD("receiveBufferSize", m_receiveBufferSize);
    CRDTP_SERIALIZE_FIELD("dnsQueryType", m_dnsQueryType);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(DirectUDPSocketOptions)
    CRDTP_DESERIALIZE_FIELD_OPT("dnsQueryType", m_dnsQueryType),
    CRDTP_DESERIALIZE_FIELD_OPT("localAddr", m_localAddr),
    CRDTP_DESERIALIZE_FIELD_OPT("localPort", m_localPort),
    CRDTP_DESERIALIZE_FIELD_OPT("receiveBufferSize", m_receiveBufferSize),
    CRDTP_DESERIALIZE_FIELD_OPT("remoteAddr", m_remoteAddr),
    CRDTP_DESERIALIZE_FIELD_OPT("remotePort", m_remotePort),
    CRDTP_DESERIALIZE_FIELD_OPT("sendBufferSize", m_sendBufferSize),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DirectUDPSocketOptions)
    CRDTP_SERIALIZE_FIELD("remoteAddr", m_remoteAddr);
    CRDTP_SERIALIZE_FIELD("remotePort", m_remotePort);
    CRDTP_SERIALIZE_FIELD("localAddr", m_localAddr);
    CRDTP_SERIALIZE_FIELD("localPort", m_localPort);
    CRDTP_SERIALIZE_FIELD("dnsQueryType", m_dnsQueryType);
    CRDTP_SERIALIZE_FIELD("sendBufferSize", m_sendBufferSize);
    CRDTP_SERIALIZE_FIELD("receiveBufferSize", m_receiveBufferSize);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(DirectUDPMessage)
    CRDTP_DESERIALIZE_FIELD("data", m_data),
    CRDTP_DESERIALIZE_FIELD_OPT("remoteAddr", m_remoteAddr),
    CRDTP_DESERIALIZE_FIELD_OPT("remotePort", m_remotePort),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(DirectUDPMessage)
    CRDTP_SERIALIZE_FIELD("data", m_data);
    CRDTP_SERIALIZE_FIELD("remoteAddr", m_remoteAddr);
    CRDTP_SERIALIZE_FIELD("remotePort", m_remotePort);
CRDTP_END_SERIALIZER();


namespace PrivateNetworkRequestPolicyEnum {
const char Allow[] = "Allow";
const char BlockFromInsecureToMorePrivate[] = "BlockFromInsecureToMorePrivate";
const char WarnFromInsecureToMorePrivate[] = "WarnFromInsecureToMorePrivate";
const char PreflightBlock[] = "PreflightBlock";
const char PreflightWarn[] = "PreflightWarn";
const char PermissionBlock[] = "PermissionBlock";
const char PermissionWarn[] = "PermissionWarn";
} // namespace PrivateNetworkRequestPolicyEnum


namespace IPAddressSpaceEnum {
const char Loopback[] = "Loopback";
const char Local[] = "Local";
const char Public[] = "Public";
const char Unknown[] = "Unknown";
} // namespace IPAddressSpaceEnum


CRDTP_BEGIN_DESERIALIZER(ConnectTiming)
    CRDTP_DESERIALIZE_FIELD("requestTime", m_requestTime),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ConnectTiming)
    CRDTP_SERIALIZE_FIELD("requestTime", m_requestTime);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ClientSecurityState)
    CRDTP_DESERIALIZE_FIELD("initiatorIPAddressSpace", m_initiatorIPAddressSpace),
    CRDTP_DESERIALIZE_FIELD("initiatorIsSecureContext", m_initiatorIsSecureContext),
    CRDTP_DESERIALIZE_FIELD("privateNetworkRequestPolicy", m_privateNetworkRequestPolicy),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ClientSecurityState)
    CRDTP_SERIALIZE_FIELD("initiatorIsSecureContext", m_initiatorIsSecureContext);
    CRDTP_SERIALIZE_FIELD("initiatorIPAddressSpace", m_initiatorIPAddressSpace);
    CRDTP_SERIALIZE_FIELD("privateNetworkRequestPolicy", m_privateNetworkRequestPolicy);
CRDTP_END_SERIALIZER();


namespace ReportStatusEnum {
const char Queued[] = "Queued";
const char Pending[] = "Pending";
const char MarkedForRemoval[] = "MarkedForRemoval";
const char Success[] = "Success";
} // namespace ReportStatusEnum



CRDTP_BEGIN_DESERIALIZER(ReportingApiReport)
    CRDTP_DESERIALIZE_FIELD("body", m_body),
    CRDTP_DESERIALIZE_FIELD("completedAttempts", m_completedAttempts),
    CRDTP_DESERIALIZE_FIELD("depth", m_depth),
    CRDTP_DESERIALIZE_FIELD("destination", m_destination),
    CRDTP_DESERIALIZE_FIELD("id", m_id),
    CRDTP_DESERIALIZE_FIELD("initiatorUrl", m_initiatorUrl),
    CRDTP_DESERIALIZE_FIELD("status", m_status),
    CRDTP_DESERIALIZE_FIELD("timestamp", m_timestamp),
    CRDTP_DESERIALIZE_FIELD("type", m_type),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ReportingApiReport)
    CRDTP_SERIALIZE_FIELD("id", m_id);
    CRDTP_SERIALIZE_FIELD("initiatorUrl", m_initiatorUrl);
    CRDTP_SERIALIZE_FIELD("destination", m_destination);
    CRDTP_SERIALIZE_FIELD("type", m_type);
    CRDTP_SERIALIZE_FIELD("timestamp", m_timestamp);
    CRDTP_SERIALIZE_FIELD("depth", m_depth);
    CRDTP_SERIALIZE_FIELD("completedAttempts", m_completedAttempts);
    CRDTP_SERIALIZE_FIELD("body", m_body);
    CRDTP_SERIALIZE_FIELD("status", m_status);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(ReportingApiEndpoint)
    CRDTP_DESERIALIZE_FIELD("groupName", m_groupName),
    CRDTP_DESERIALIZE_FIELD("url", m_url),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(ReportingApiEndpoint)
    CRDTP_SERIALIZE_FIELD("url", m_url);
    CRDTP_SERIALIZE_FIELD("groupName", m_groupName);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


namespace TrustTokenOperationDone {
namespace StatusEnum {
const char* Ok = "Ok";
const char* InvalidArgument = "InvalidArgument";
const char* MissingIssuerKeys = "MissingIssuerKeys";
const char* FailedPrecondition = "FailedPrecondition";
const char* ResourceExhausted = "ResourceExhausted";
const char* AlreadyExists = "AlreadyExists";
const char* ResourceLimited = "ResourceLimited";
const char* Unauthorized = "Unauthorized";
const char* BadResponse = "BadResponse";
const char* InternalError = "InternalError";
const char* UnknownError = "UnknownError";
const char* FulfilledLocally = "FulfilledLocally";
const char* SiteIssuerLimit = "SiteIssuerLimit";
} // namespace StatusEnum
} // namespace TrustTokenOperationDone

// ------------- Frontend notifications.

void Frontend::dataReceived(const String& requestId, double timestamp, int dataLength, int encodedDataLength, std::optional<Binary> data)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("dataLength"), dataLength);
    serializer.AddField(crdtp::MakeSpan("encodedDataLength"), encodedDataLength);
    serializer.AddField(crdtp::MakeSpan("data"), data);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.dataReceived", serializer.Finish()));
}

void Frontend::eventSourceMessageReceived(const String& requestId, double timestamp, const String& eventName, const String& eventId, const String& data)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("eventName"), eventName);
    serializer.AddField(crdtp::MakeSpan("eventId"), eventId);
    serializer.AddField(crdtp::MakeSpan("data"), data);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.eventSourceMessageReceived", serializer.Finish()));
}

void Frontend::loadingFailed(const String& requestId, double timestamp, const String& type, const String& errorText, std::optional<bool> canceled, std::optional<String> blockedReason, std::unique_ptr<protocol::Network::CorsErrorStatus> corsErrorStatus)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("errorText"), errorText);
    serializer.AddField(crdtp::MakeSpan("canceled"), canceled);
    serializer.AddField(crdtp::MakeSpan("blockedReason"), blockedReason);
    serializer.AddField(crdtp::MakeSpan("corsErrorStatus"), corsErrorStatus);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.loadingFailed", serializer.Finish()));
}

void Frontend::loadingFinished(const String& requestId, double timestamp, double encodedDataLength)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("encodedDataLength"), encodedDataLength);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.loadingFinished", serializer.Finish()));
}

void Frontend::requestIntercepted(const String& interceptionId, std::unique_ptr<protocol::Network::Request> request, const String& frameId, const String& resourceType, bool isNavigationRequest, std::optional<bool> isDownload, std::optional<String> redirectUrl, std::unique_ptr<protocol::Network::AuthChallenge> authChallenge, std::optional<String> responseErrorReason, std::optional<int> responseStatusCode, std::unique_ptr<protocol::Network::Headers> responseHeaders, std::optional<String> requestId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("interceptionId"), interceptionId);
    serializer.AddField(crdtp::MakeSpan("request"), request);
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("resourceType"), resourceType);
    serializer.AddField(crdtp::MakeSpan("isNavigationRequest"), isNavigationRequest);
    serializer.AddField(crdtp::MakeSpan("isDownload"), isDownload);
    serializer.AddField(crdtp::MakeSpan("redirectUrl"), redirectUrl);
    serializer.AddField(crdtp::MakeSpan("authChallenge"), authChallenge);
    serializer.AddField(crdtp::MakeSpan("responseErrorReason"), responseErrorReason);
    serializer.AddField(crdtp::MakeSpan("responseStatusCode"), responseStatusCode);
    serializer.AddField(crdtp::MakeSpan("responseHeaders"), responseHeaders);
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.requestIntercepted", serializer.Finish()));
}

void Frontend::requestServedFromCache(const String& requestId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.requestServedFromCache", serializer.Finish()));
}

void Frontend::requestWillBeSent(const String& requestId, const String& loaderId, const String& documentURL, std::unique_ptr<protocol::Network::Request> request, double timestamp, double wallTime, std::unique_ptr<protocol::Network::Initiator> initiator, bool redirectHasExtraInfo, std::unique_ptr<protocol::Network::Response> redirectResponse, std::optional<String> type, std::optional<String> frameId, std::optional<bool> hasUserGesture)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("loaderId"), loaderId);
    serializer.AddField(crdtp::MakeSpan("documentURL"), documentURL);
    serializer.AddField(crdtp::MakeSpan("request"), request);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("wallTime"), wallTime);
    serializer.AddField(crdtp::MakeSpan("initiator"), initiator);
    serializer.AddField(crdtp::MakeSpan("redirectHasExtraInfo"), redirectHasExtraInfo);
    serializer.AddField(crdtp::MakeSpan("redirectResponse"), redirectResponse);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    serializer.AddField(crdtp::MakeSpan("hasUserGesture"), hasUserGesture);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.requestWillBeSent", serializer.Finish()));
}

void Frontend::resourceChangedPriority(const String& requestId, const String& newPriority, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("newPriority"), newPriority);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.resourceChangedPriority", serializer.Finish()));
}

void Frontend::signedExchangeReceived(const String& requestId, std::unique_ptr<protocol::Network::SignedExchangeInfo> info)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("info"), info);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.signedExchangeReceived", serializer.Finish()));
}

void Frontend::responseReceived(const String& requestId, const String& loaderId, double timestamp, const String& type, std::unique_ptr<protocol::Network::Response> response, bool hasExtraInfo, std::optional<String> frameId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("loaderId"), loaderId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("response"), response);
    serializer.AddField(crdtp::MakeSpan("hasExtraInfo"), hasExtraInfo);
    serializer.AddField(crdtp::MakeSpan("frameId"), frameId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.responseReceived", serializer.Finish()));
}

void Frontend::webSocketClosed(const String& requestId, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.webSocketClosed", serializer.Finish()));
}

void Frontend::webSocketCreated(const String& requestId, const String& url, std::unique_ptr<protocol::Network::Initiator> initiator)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("initiator"), initiator);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.webSocketCreated", serializer.Finish()));
}

void Frontend::webSocketFrameError(const String& requestId, double timestamp, const String& errorMessage)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("errorMessage"), errorMessage);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.webSocketFrameError", serializer.Finish()));
}

void Frontend::webSocketFrameReceived(const String& requestId, double timestamp, std::unique_ptr<protocol::Network::WebSocketFrame> response)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("response"), response);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.webSocketFrameReceived", serializer.Finish()));
}

void Frontend::webSocketFrameSent(const String& requestId, double timestamp, std::unique_ptr<protocol::Network::WebSocketFrame> response)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("response"), response);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.webSocketFrameSent", serializer.Finish()));
}

void Frontend::webSocketHandshakeResponseReceived(const String& requestId, double timestamp, std::unique_ptr<protocol::Network::WebSocketResponse> response)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("response"), response);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.webSocketHandshakeResponseReceived", serializer.Finish()));
}

void Frontend::webSocketWillSendHandshakeRequest(const String& requestId, double timestamp, double wallTime, std::unique_ptr<protocol::Network::WebSocketRequest> request)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("wallTime"), wallTime);
    serializer.AddField(crdtp::MakeSpan("request"), request);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.webSocketWillSendHandshakeRequest", serializer.Finish()));
}

void Frontend::webTransportCreated(const String& transportId, const String& url, double timestamp, std::unique_ptr<protocol::Network::Initiator> initiator)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("transportId"), transportId);
    serializer.AddField(crdtp::MakeSpan("url"), url);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("initiator"), initiator);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.webTransportCreated", serializer.Finish()));
}

void Frontend::webTransportConnectionEstablished(const String& transportId, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("transportId"), transportId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.webTransportConnectionEstablished", serializer.Finish()));
}

void Frontend::webTransportClosed(const String& transportId, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("transportId"), transportId);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.webTransportClosed", serializer.Finish()));
}

void Frontend::directTCPSocketCreated(const String& identifier, const String& remoteAddr, int remotePort, std::unique_ptr<protocol::Network::DirectTCPSocketOptions> options, double timestamp, std::unique_ptr<protocol::Network::Initiator> initiator)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("identifier"), identifier);
    serializer.AddField(crdtp::MakeSpan("remoteAddr"), remoteAddr);
    serializer.AddField(crdtp::MakeSpan("remotePort"), remotePort);
    serializer.AddField(crdtp::MakeSpan("options"), options);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("initiator"), initiator);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.directTCPSocketCreated", serializer.Finish()));
}

void Frontend::directTCPSocketOpened(const String& identifier, const String& remoteAddr, int remotePort, double timestamp, std::optional<String> localAddr, std::optional<int> localPort)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("identifier"), identifier);
    serializer.AddField(crdtp::MakeSpan("remoteAddr"), remoteAddr);
    serializer.AddField(crdtp::MakeSpan("remotePort"), remotePort);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("localAddr"), localAddr);
    serializer.AddField(crdtp::MakeSpan("localPort"), localPort);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.directTCPSocketOpened", serializer.Finish()));
}

void Frontend::directTCPSocketAborted(const String& identifier, const String& errorMessage, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("identifier"), identifier);
    serializer.AddField(crdtp::MakeSpan("errorMessage"), errorMessage);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.directTCPSocketAborted", serializer.Finish()));
}

void Frontend::directTCPSocketClosed(const String& identifier, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("identifier"), identifier);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.directTCPSocketClosed", serializer.Finish()));
}

void Frontend::directTCPSocketChunkSent(const String& identifier, const Binary& data, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("identifier"), identifier);
    serializer.AddField(crdtp::MakeSpan("data"), data);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.directTCPSocketChunkSent", serializer.Finish()));
}

void Frontend::directTCPSocketChunkReceived(const String& identifier, const Binary& data, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("identifier"), identifier);
    serializer.AddField(crdtp::MakeSpan("data"), data);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.directTCPSocketChunkReceived", serializer.Finish()));
}

void Frontend::directUDPSocketCreated(const String& identifier, std::unique_ptr<protocol::Network::DirectUDPSocketOptions> options, double timestamp, std::unique_ptr<protocol::Network::Initiator> initiator)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("identifier"), identifier);
    serializer.AddField(crdtp::MakeSpan("options"), options);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("initiator"), initiator);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.directUDPSocketCreated", serializer.Finish()));
}

void Frontend::directUDPSocketOpened(const String& identifier, const String& localAddr, int localPort, double timestamp, std::optional<String> remoteAddr, std::optional<int> remotePort)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("identifier"), identifier);
    serializer.AddField(crdtp::MakeSpan("localAddr"), localAddr);
    serializer.AddField(crdtp::MakeSpan("localPort"), localPort);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    serializer.AddField(crdtp::MakeSpan("remoteAddr"), remoteAddr);
    serializer.AddField(crdtp::MakeSpan("remotePort"), remotePort);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.directUDPSocketOpened", serializer.Finish()));
}

void Frontend::directUDPSocketAborted(const String& identifier, const String& errorMessage, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("identifier"), identifier);
    serializer.AddField(crdtp::MakeSpan("errorMessage"), errorMessage);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.directUDPSocketAborted", serializer.Finish()));
}

void Frontend::directUDPSocketClosed(const String& identifier, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("identifier"), identifier);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.directUDPSocketClosed", serializer.Finish()));
}

void Frontend::directUDPSocketChunkSent(const String& identifier, std::unique_ptr<protocol::Network::DirectUDPMessage> message, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("identifier"), identifier);
    serializer.AddField(crdtp::MakeSpan("message"), message);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.directUDPSocketChunkSent", serializer.Finish()));
}

void Frontend::directUDPSocketChunkReceived(const String& identifier, std::unique_ptr<protocol::Network::DirectUDPMessage> message, double timestamp)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("identifier"), identifier);
    serializer.AddField(crdtp::MakeSpan("message"), message);
    serializer.AddField(crdtp::MakeSpan("timestamp"), timestamp);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.directUDPSocketChunkReceived", serializer.Finish()));
}

void Frontend::requestWillBeSentExtraInfo(const String& requestId, std::unique_ptr<protocol::Array<protocol::Network::AssociatedCookie>> associatedCookies, std::unique_ptr<protocol::Network::Headers> headers, std::unique_ptr<protocol::Network::ConnectTiming> connectTiming, std::unique_ptr<protocol::Network::ClientSecurityState> clientSecurityState, std::optional<bool> siteHasCookieInOtherPartition, std::optional<String> appliedNetworkConditionsId)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("associatedCookies"), associatedCookies);
    serializer.AddField(crdtp::MakeSpan("headers"), headers);
    serializer.AddField(crdtp::MakeSpan("connectTiming"), connectTiming);
    serializer.AddField(crdtp::MakeSpan("clientSecurityState"), clientSecurityState);
    serializer.AddField(crdtp::MakeSpan("siteHasCookieInOtherPartition"), siteHasCookieInOtherPartition);
    serializer.AddField(crdtp::MakeSpan("appliedNetworkConditionsId"), appliedNetworkConditionsId);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.requestWillBeSentExtraInfo", serializer.Finish()));
}

void Frontend::responseReceivedExtraInfo(const String& requestId, std::unique_ptr<protocol::Array<protocol::Network::BlockedSetCookieWithReason>> blockedCookies, std::unique_ptr<protocol::Network::Headers> headers, const String& resourceIPAddressSpace, int statusCode, std::optional<String> headersText, std::unique_ptr<protocol::Network::CookiePartitionKey> cookiePartitionKey, std::optional<bool> cookiePartitionKeyOpaque, std::unique_ptr<protocol::Array<protocol::Network::ExemptedSetCookieWithReason>> exemptedCookies)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("blockedCookies"), blockedCookies);
    serializer.AddField(crdtp::MakeSpan("headers"), headers);
    serializer.AddField(crdtp::MakeSpan("resourceIPAddressSpace"), resourceIPAddressSpace);
    serializer.AddField(crdtp::MakeSpan("statusCode"), statusCode);
    serializer.AddField(crdtp::MakeSpan("headersText"), headersText);
    serializer.AddField(crdtp::MakeSpan("cookiePartitionKey"), cookiePartitionKey);
    serializer.AddField(crdtp::MakeSpan("cookiePartitionKeyOpaque"), cookiePartitionKeyOpaque);
    serializer.AddField(crdtp::MakeSpan("exemptedCookies"), exemptedCookies);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.responseReceivedExtraInfo", serializer.Finish()));
}

void Frontend::responseReceivedEarlyHints(const String& requestId, std::unique_ptr<protocol::Network::Headers> headers)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("headers"), headers);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.responseReceivedEarlyHints", serializer.Finish()));
}

void Frontend::trustTokenOperationDone(const String& status, const String& type, const String& requestId, std::optional<String> topLevelOrigin, std::optional<String> issuerOrigin, std::optional<int> issuedTokenCount)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("status"), status);
    serializer.AddField(crdtp::MakeSpan("type"), type);
    serializer.AddField(crdtp::MakeSpan("requestId"), requestId);
    serializer.AddField(crdtp::MakeSpan("topLevelOrigin"), topLevelOrigin);
    serializer.AddField(crdtp::MakeSpan("issuerOrigin"), issuerOrigin);
    serializer.AddField(crdtp::MakeSpan("issuedTokenCount"), issuedTokenCount);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.trustTokenOperationDone", serializer.Finish()));
}

void Frontend::policyUpdated()
{
    if (!frontend_channel_)
        return;
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.policyUpdated"));
}

void Frontend::reportingApiReportAdded(std::unique_ptr<protocol::Network::ReportingApiReport> report)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("report"), report);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.reportingApiReportAdded", serializer.Finish()));
}

void Frontend::reportingApiReportUpdated(std::unique_ptr<protocol::Network::ReportingApiReport> report)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("report"), report);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.reportingApiReportUpdated", serializer.Finish()));
}

void Frontend::reportingApiEndpointsChangedForOrigin(const String& origin, std::unique_ptr<protocol::Array<protocol::Network::ReportingApiEndpoint>> endpoints)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("origin"), origin);
    serializer.AddField(crdtp::MakeSpan("endpoints"), endpoints);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Network.reportingApiEndpointsChangedForOrigin", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void setAcceptedEncodings(const crdtp::Dispatchable& dispatchable);
    void clearAcceptedEncodingsOverride(const crdtp::Dispatchable& dispatchable);
    void canClearBrowserCache(const crdtp::Dispatchable& dispatchable);
    void canClearBrowserCookies(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
    void emulateNetworkConditions(const crdtp::Dispatchable& dispatchable);
    void emulateNetworkConditionsByRule(const crdtp::Dispatchable& dispatchable);
    void overrideNetworkState(const crdtp::Dispatchable& dispatchable);
    void enable(const crdtp::Dispatchable& dispatchable);
    void getCertificate(const crdtp::Dispatchable& dispatchable);
    void getResponseBody(const crdtp::Dispatchable& dispatchable);
    void getRequestPostData(const crdtp::Dispatchable& dispatchable);
    void replayXHR(const crdtp::Dispatchable& dispatchable);
    void searchInResponseBody(const crdtp::Dispatchable& dispatchable);
    void setBlockedURLs(const crdtp::Dispatchable& dispatchable);
    void setBypassServiceWorker(const crdtp::Dispatchable& dispatchable);
    void setCacheDisabled(const crdtp::Dispatchable& dispatchable);
    void setExtraHTTPHeaders(const crdtp::Dispatchable& dispatchable);
    void setAttachDebugStack(const crdtp::Dispatchable& dispatchable);
    void streamResourceContent(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("canClearBrowserCache"),
          &DomainDispatcherImpl::canClearBrowserCache
    },
    {
          crdtp::SpanFrom("canClearBrowserCookies"),
          &DomainDispatcherImpl::canClearBrowserCookies
    },
    {
          crdtp::SpanFrom("clearAcceptedEncodingsOverride"),
          &DomainDispatcherImpl::clearAcceptedEncodingsOverride
    },
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("emulateNetworkConditions"),
          &DomainDispatcherImpl::emulateNetworkConditions
    },
    {
          crdtp::SpanFrom("emulateNetworkConditionsByRule"),
          &DomainDispatcherImpl::emulateNetworkConditionsByRule
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    {
          crdtp::SpanFrom("getCertificate"),
          &DomainDispatcherImpl::getCertificate
    },
    {
          crdtp::SpanFrom("getRequestPostData"),
          &DomainDispatcherImpl::getRequestPostData
    },
    {
          crdtp::SpanFrom("getResponseBody"),
          &DomainDispatcherImpl::getResponseBody
    },
    {
          crdtp::SpanFrom("overrideNetworkState"),
          &DomainDispatcherImpl::overrideNetworkState
    },
    {
          crdtp::SpanFrom("replayXHR"),
          &DomainDispatcherImpl::replayXHR
    },
    {
          crdtp::SpanFrom("searchInResponseBody"),
          &DomainDispatcherImpl::searchInResponseBody
    },
    {
          crdtp::SpanFrom("setAcceptedEncodings"),
          &DomainDispatcherImpl::setAcceptedEncodings
    },
    {
          crdtp::SpanFrom("setAttachDebugStack"),
          &DomainDispatcherImpl::setAttachDebugStack
    },
    {
          crdtp::SpanFrom("setBlockedURLs"),
          &DomainDispatcherImpl::setBlockedURLs
    },
    {
          crdtp::SpanFrom("setBypassServiceWorker"),
          &DomainDispatcherImpl::setBypassServiceWorker
    },
    {
          crdtp::SpanFrom("setCacheDisabled"),
          &DomainDispatcherImpl::setCacheDisabled
    },
    {
          crdtp::SpanFrom("setExtraHTTPHeaders"),
          &DomainDispatcherImpl::setExtraHTTPHeaders
    },
    {
          crdtp::SpanFrom("streamResourceContent"),
          &DomainDispatcherImpl::streamResourceContent
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {

struct setAcceptedEncodingsParams : public crdtp::DeserializableProtocolObject<setAcceptedEncodingsParams> {
    std::unique_ptr<protocol::Array<String>> encodings;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setAcceptedEncodingsParams)
    CRDTP_DESERIALIZE_FIELD("encodings", encodings),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setAcceptedEncodings(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setAcceptedEncodingsParams params;
    if (!setAcceptedEncodingsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setAcceptedEncodings(std::move(params.encodings));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.setAcceptedEncodings"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::clearAcceptedEncodingsOverride(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->clearAcceptedEncodingsOverride();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.clearAcceptedEncodingsOverride"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::canClearBrowserCache(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    bool out_result;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->canClearBrowserCache(&out_result);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.canClearBrowserCache"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("result"), out_result);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::canClearBrowserCookies(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    // Declare output parameters.
    bool out_result;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->canClearBrowserCookies(&out_result);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.canClearBrowserCookies"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("result"), out_result);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct emulateNetworkConditionsParams : public crdtp::DeserializableProtocolObject<emulateNetworkConditionsParams> {
    bool offline;
    double latency;
    double downloadThroughput;
    double uploadThroughput;
    std::optional<String> connectionType;
    std::optional<double> packetLoss;
    std::optional<int> packetQueueLength;
    std::optional<bool> packetReordering;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(emulateNetworkConditionsParams)
    CRDTP_DESERIALIZE_FIELD_OPT("connectionType", connectionType),
    CRDTP_DESERIALIZE_FIELD("downloadThroughput", downloadThroughput),
    CRDTP_DESERIALIZE_FIELD("latency", latency),
    CRDTP_DESERIALIZE_FIELD("offline", offline),
    CRDTP_DESERIALIZE_FIELD_OPT("packetLoss", packetLoss),
    CRDTP_DESERIALIZE_FIELD_OPT("packetQueueLength", packetQueueLength),
    CRDTP_DESERIALIZE_FIELD_OPT("packetReordering", packetReordering),
    CRDTP_DESERIALIZE_FIELD("uploadThroughput", uploadThroughput),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::emulateNetworkConditions(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    emulateNetworkConditionsParams params;
    if (!emulateNetworkConditionsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->emulateNetworkConditions(params.offline, params.latency, params.downloadThroughput, params.uploadThroughput, std::move(params.connectionType), std::move(params.packetLoss), std::move(params.packetQueueLength), std::move(params.packetReordering));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.emulateNetworkConditions"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct emulateNetworkConditionsByRuleParams : public crdtp::DeserializableProtocolObject<emulateNetworkConditionsByRuleParams> {
    bool offline;
    std::unique_ptr<protocol::Array<protocol::Network::NetworkConditions>> matchedNetworkConditions;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(emulateNetworkConditionsByRuleParams)
    CRDTP_DESERIALIZE_FIELD("matchedNetworkConditions", matchedNetworkConditions),
    CRDTP_DESERIALIZE_FIELD("offline", offline),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::emulateNetworkConditionsByRule(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    emulateNetworkConditionsByRuleParams params;
    if (!emulateNetworkConditionsByRuleParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<String>> out_ruleIds;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->emulateNetworkConditionsByRule(params.offline, std::move(params.matchedNetworkConditions), &out_ruleIds);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.emulateNetworkConditionsByRule"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("ruleIds"), out_ruleIds);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct overrideNetworkStateParams : public crdtp::DeserializableProtocolObject<overrideNetworkStateParams> {
    bool offline;
    double latency;
    double downloadThroughput;
    double uploadThroughput;
    std::optional<String> connectionType;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(overrideNetworkStateParams)
    CRDTP_DESERIALIZE_FIELD_OPT("connectionType", connectionType),
    CRDTP_DESERIALIZE_FIELD("downloadThroughput", downloadThroughput),
    CRDTP_DESERIALIZE_FIELD("latency", latency),
    CRDTP_DESERIALIZE_FIELD("offline", offline),
    CRDTP_DESERIALIZE_FIELD("uploadThroughput", uploadThroughput),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::overrideNetworkState(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    overrideNetworkStateParams params;
    if (!overrideNetworkStateParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->overrideNetworkState(params.offline, params.latency, params.downloadThroughput, params.uploadThroughput, std::move(params.connectionType));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.overrideNetworkState"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct enableParams : public crdtp::DeserializableProtocolObject<enableParams> {
    std::optional<int> maxTotalBufferSize;
    std::optional<int> maxResourceBufferSize;
    std::optional<int> maxPostDataSize;
    std::optional<bool> reportDirectSocketTraffic;
    std::optional<bool> enableDurableMessages;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(enableParams)
    CRDTP_DESERIALIZE_FIELD_OPT("enableDurableMessages", enableDurableMessages),
    CRDTP_DESERIALIZE_FIELD_OPT("maxPostDataSize", maxPostDataSize),
    CRDTP_DESERIALIZE_FIELD_OPT("maxResourceBufferSize", maxResourceBufferSize),
    CRDTP_DESERIALIZE_FIELD_OPT("maxTotalBufferSize", maxTotalBufferSize),
    CRDTP_DESERIALIZE_FIELD_OPT("reportDirectSocketTraffic", reportDirectSocketTraffic),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    enableParams params;
    if (!enableParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable(std::move(params.maxTotalBufferSize), std::move(params.maxResourceBufferSize), std::move(params.maxPostDataSize), std::move(params.reportDirectSocketTraffic), std::move(params.enableDurableMessages));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct getCertificateParams : public crdtp::DeserializableProtocolObject<getCertificateParams> {
    String origin;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getCertificateParams)
    CRDTP_DESERIALIZE_FIELD("origin", origin),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getCertificate(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getCertificateParams params;
    if (!getCertificateParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<String>> out_tableNames;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->getCertificate(params.origin, &out_tableNames);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.getCertificate"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("tableNames"), out_tableNames);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

class GetResponseBodyCallbackImpl : public Backend::GetResponseBodyCallback, public DomainDispatcher::Callback {
public:
    GetResponseBodyCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Network.getResponseBody"), message) { }

    void sendSuccess(const String& body, bool base64Encoded) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("body"), body);
        serializer.AddField(crdtp::MakeSpan("base64Encoded"), base64Encoded);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct getResponseBodyParams : public crdtp::DeserializableProtocolObject<getResponseBodyParams> {
    String requestId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getResponseBodyParams)
    CRDTP_DESERIALIZE_FIELD("requestId", requestId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getResponseBody(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getResponseBodyParams params;
    if (!getResponseBodyParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->getResponseBody(params.requestId, std::make_unique<GetResponseBodyCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

class GetRequestPostDataCallbackImpl : public Backend::GetRequestPostDataCallback, public DomainDispatcher::Callback {
public:
    GetRequestPostDataCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("Network.getRequestPostData"), message) { }

    void sendSuccess(const String& postData) override
    {
        crdtp::ObjectSerializer serializer;
        serializer.AddField(crdtp::MakeSpan("postData"), postData);
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct getRequestPostDataParams : public crdtp::DeserializableProtocolObject<getRequestPostDataParams> {
    String requestId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(getRequestPostDataParams)
    CRDTP_DESERIALIZE_FIELD("requestId", requestId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::getRequestPostData(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    getRequestPostDataParams params;
    if (!getRequestPostDataParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    m_backend->getRequestPostData(params.requestId, std::make_unique<GetRequestPostDataCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct replayXHRParams : public crdtp::DeserializableProtocolObject<replayXHRParams> {
    String requestId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(replayXHRParams)
    CRDTP_DESERIALIZE_FIELD("requestId", requestId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::replayXHR(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    replayXHRParams params;
    if (!replayXHRParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->replayXHR(params.requestId);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.replayXHR"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct searchInResponseBodyParams : public crdtp::DeserializableProtocolObject<searchInResponseBodyParams> {
    String requestId;
    String query;
    std::optional<bool> caseSensitive;
    std::optional<bool> isRegex;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(searchInResponseBodyParams)
    CRDTP_DESERIALIZE_FIELD_OPT("caseSensitive", caseSensitive),
    CRDTP_DESERIALIZE_FIELD_OPT("isRegex", isRegex),
    CRDTP_DESERIALIZE_FIELD("query", query),
    CRDTP_DESERIALIZE_FIELD("requestId", requestId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::searchInResponseBody(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    searchInResponseBodyParams params;
    if (!searchInResponseBodyParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    std::unique_ptr<protocol::Array<v8_inspector::protocol::Debugger::API::SearchMatch>> out_result;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->searchInResponseBody(params.requestId, params.query, std::move(params.caseSensitive), std::move(params.isRegex), &out_result);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.searchInResponseBody"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("result"), out_result);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {

struct setBlockedURLsParams : public crdtp::DeserializableProtocolObject<setBlockedURLsParams> {
    std::unique_ptr<protocol::Array<protocol::Network::BlockPattern>> urlPatterns;
    std::unique_ptr<protocol::Array<String>> urls;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setBlockedURLsParams)
    CRDTP_DESERIALIZE_FIELD_OPT("urlPatterns", urlPatterns),
    CRDTP_DESERIALIZE_FIELD_OPT("urls", urls),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setBlockedURLs(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setBlockedURLsParams params;
    if (!setBlockedURLsParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setBlockedURLs(std::move(params.urlPatterns), std::move(params.urls));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.setBlockedURLs"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setBypassServiceWorkerParams : public crdtp::DeserializableProtocolObject<setBypassServiceWorkerParams> {
    bool bypass;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setBypassServiceWorkerParams)
    CRDTP_DESERIALIZE_FIELD("bypass", bypass),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setBypassServiceWorker(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setBypassServiceWorkerParams params;
    if (!setBypassServiceWorkerParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setBypassServiceWorker(params.bypass);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.setBypassServiceWorker"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setCacheDisabledParams : public crdtp::DeserializableProtocolObject<setCacheDisabledParams> {
    bool cacheDisabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setCacheDisabledParams)
    CRDTP_DESERIALIZE_FIELD("cacheDisabled", cacheDisabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setCacheDisabled(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setCacheDisabledParams params;
    if (!setCacheDisabledParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setCacheDisabled(params.cacheDisabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.setCacheDisabled"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setExtraHTTPHeadersParams : public crdtp::DeserializableProtocolObject<setExtraHTTPHeadersParams> {
    std::unique_ptr<protocol::Network::Headers> headers;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setExtraHTTPHeadersParams)
    CRDTP_DESERIALIZE_FIELD("headers", headers),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setExtraHTTPHeaders(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setExtraHTTPHeadersParams params;
    if (!setExtraHTTPHeadersParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setExtraHTTPHeaders(std::move(params.headers));
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.setExtraHTTPHeaders"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setAttachDebugStackParams : public crdtp::DeserializableProtocolObject<setAttachDebugStackParams> {
    bool enabled;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setAttachDebugStackParams)
    CRDTP_DESERIALIZE_FIELD("enabled", enabled),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setAttachDebugStack(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setAttachDebugStackParams params;
    if (!setAttachDebugStackParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->setAttachDebugStack(params.enabled);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.setAttachDebugStack"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct streamResourceContentParams : public crdtp::DeserializableProtocolObject<streamResourceContentParams> {
    String requestId;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(streamResourceContentParams)
    CRDTP_DESERIALIZE_FIELD("requestId", requestId),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::streamResourceContent(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    streamResourceContentParams params;
    if (!streamResourceContentParams::Deserialize(&deserializer, &params)) {
      ReportInvalidParams(dispatchable, deserializer);
      return;
    }
    // Declare output parameters.
    Binary out_bufferedData;

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->streamResourceContent(params.requestId, &out_bufferedData);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Network.streamResourceContent"), dispatchable.Serialized());
        return;
    }
      if (weak->get()) {
        std::unique_ptr<crdtp::Serializable> result;
        if (response.IsSuccess()) {
          crdtp::ObjectSerializer serializer;
          serializer.AddField(crdtp::MakeSpan("bufferedData"), out_bufferedData);
          result = serializer.Finish();
        } else {
          result = Serializable::From({});
        }
        weak->get()->sendResponse(dispatchable.CallId(), response, std::move(result));
      }
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
          { crdtp::SpanFrom("Network.setUserAgentOverride"), crdtp::SpanFrom("Emulation.setUserAgentOverride") },
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Network"), SortedRedirects(), std::move(dispatcher));
}

} // Network
} // namespace blink
} // namespace protocol
