// This file is generated by TypeBuilder_cpp.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "third_party/blink/renderer/core/inspector/protocol/media.h"

#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace blink {
namespace protocol {
namespace Media {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "Media";
const char Metainfo::commandPrefix[] = "Media.";
const char Metainfo::version[] = "1.3";




const char* PlayerMessage::LevelEnum::Error = "error";
const char* PlayerMessage::LevelEnum::Warning = "warning";
const char* PlayerMessage::LevelEnum::Info = "info";
const char* PlayerMessage::LevelEnum::Debug = "debug";
CRDTP_BEGIN_DESERIALIZER(PlayerMessage)
    CRDTP_DESERIALIZE_FIELD("level", m_level),
    CRDTP_DESERIALIZE_FIELD("message", m_message),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PlayerMessage)
    CRDTP_SERIALIZE_FIELD("level", m_level);
    CRDTP_SERIALIZE_FIELD("message", m_message);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(PlayerProperty)
    CRDTP_DESERIALIZE_FIELD("name", m_name),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PlayerProperty)
    CRDTP_SERIALIZE_FIELD("name", m_name);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(PlayerEvent)
    CRDTP_DESERIALIZE_FIELD("timestamp", m_timestamp),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PlayerEvent)
    CRDTP_SERIALIZE_FIELD("timestamp", m_timestamp);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(PlayerErrorSourceLocation)
    CRDTP_DESERIALIZE_FIELD("file", m_file),
    CRDTP_DESERIALIZE_FIELD("line", m_line),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PlayerErrorSourceLocation)
    CRDTP_SERIALIZE_FIELD("file", m_file);
    CRDTP_SERIALIZE_FIELD("line", m_line);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(PlayerError)
    CRDTP_DESERIALIZE_FIELD("cause", m_cause),
    CRDTP_DESERIALIZE_FIELD("code", m_code),
    CRDTP_DESERIALIZE_FIELD("data", m_data),
    CRDTP_DESERIALIZE_FIELD("errorType", m_errorType),
    CRDTP_DESERIALIZE_FIELD("stack", m_stack),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(PlayerError)
    CRDTP_SERIALIZE_FIELD("errorType", m_errorType);
    CRDTP_SERIALIZE_FIELD("code", m_code);
    CRDTP_SERIALIZE_FIELD("stack", m_stack);
    CRDTP_SERIALIZE_FIELD("cause", m_cause);
    CRDTP_SERIALIZE_FIELD("data", m_data);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(Player)
    CRDTP_DESERIALIZE_FIELD_OPT("domNodeId", m_domNodeId),
    CRDTP_DESERIALIZE_FIELD("playerId", m_playerId),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(Player)
    CRDTP_SERIALIZE_FIELD("playerId", m_playerId);
    CRDTP_SERIALIZE_FIELD("domNodeId", m_domNodeId);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::playerPropertiesChanged(const String& playerId, std::unique_ptr<protocol::Array<protocol::Media::PlayerProperty>> properties)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("playerId"), playerId);
    serializer.AddField(crdtp::MakeSpan("properties"), properties);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Media.playerPropertiesChanged", serializer.Finish()));
}

void Frontend::playerEventsAdded(const String& playerId, std::unique_ptr<protocol::Array<protocol::Media::PlayerEvent>> events)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("playerId"), playerId);
    serializer.AddField(crdtp::MakeSpan("events"), events);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Media.playerEventsAdded", serializer.Finish()));
}

void Frontend::playerMessagesLogged(const String& playerId, std::unique_ptr<protocol::Array<protocol::Media::PlayerMessage>> messages)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("playerId"), playerId);
    serializer.AddField(crdtp::MakeSpan("messages"), messages);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Media.playerMessagesLogged", serializer.Finish()));
}

void Frontend::playerErrorsRaised(const String& playerId, std::unique_ptr<protocol::Array<protocol::Media::PlayerError>> errors)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("playerId"), playerId);
    serializer.AddField(crdtp::MakeSpan("errors"), errors);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Media.playerErrorsRaised", serializer.Finish()));
}

void Frontend::playerCreated(std::unique_ptr<protocol::Media::Player> player)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("player"), player);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("Media.playerCreated", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void enable(const crdtp::Dispatchable& dispatchable);
    void disable(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("disable"),
          &DomainDispatcherImpl::disable
    },
    {
          crdtp::SpanFrom("enable"),
          &DomainDispatcherImpl::enable
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


namespace {


}  // namespace

void DomainDispatcherImpl::enable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->enable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Media.enable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {


}  // namespace

void DomainDispatcherImpl::disable(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.

    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->disable();
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("Media.disable"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("Media"), SortedRedirects(), std::move(dispatcher));
}

} // Media
} // namespace blink
} // namespace protocol
