// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_LayerTree_h
#define blink_protocol_LayerTree_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/dom.h"

namespace blink {
namespace protocol {
namespace LayerTree {
using LayerId = String;
using SnapshotId = String;
class ScrollRect;
class StickyPositionConstraint;
class PictureTile;
class Layer;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class CORE_EXPORT ScrollRect : public ::crdtp::ProtocolObject<ScrollRect> {
public:
    ~ScrollRect() override;  // Defined below

    protocol::DOM::Rect* getRect() { return m_rect.get(); }
    void setRect(std::unique_ptr<protocol::DOM::Rect> value);  // Defined below

    struct CORE_EXPORT TypeEnum {
        static const char* RepaintsOnScroll;
        static const char* TouchEventHandler;
        static const char* WheelEventHandler;
    }; // TypeEnum

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    template<int STATE>
    class ScrollRectBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            RectSet = 1 << 1,
            TypeSet = 1 << 2,
            AllFieldsSet = (RectSet | TypeSet | 0)};


        ScrollRectBuilder<STATE | RectSet>& setRect(std::unique_ptr<protocol::DOM::Rect> value);  // Defined below

        ScrollRectBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        std::unique_ptr<ScrollRect> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class ScrollRect;
        ScrollRectBuilder() : m_result(new ScrollRect()) { }

        template<int STEP> ScrollRectBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<ScrollRectBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::LayerTree::ScrollRect> m_result;
    };

    static ScrollRectBuilder<0> create()
    {
        return ScrollRectBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    ScrollRect();  // Defined below

    std::unique_ptr<protocol::DOM::Rect> m_rect;
    String m_type;
};


class CORE_EXPORT StickyPositionConstraint : public ::crdtp::ProtocolObject<StickyPositionConstraint> {
public:
    ~StickyPositionConstraint() override;  // Defined below

    protocol::DOM::Rect* getStickyBoxRect() { return m_stickyBoxRect.get(); }
    void setStickyBoxRect(std::unique_ptr<protocol::DOM::Rect> value);  // Defined below

    protocol::DOM::Rect* getContainingBlockRect() { return m_containingBlockRect.get(); }
    void setContainingBlockRect(std::unique_ptr<protocol::DOM::Rect> value);  // Defined below

    bool hasNearestLayerShiftingStickyBox() { return !!m_nearestLayerShiftingStickyBox; }
    String getNearestLayerShiftingStickyBox(const String& defaultValue) const {
       return m_nearestLayerShiftingStickyBox.value_or(defaultValue);
    }
    const std::optional<String>& getNearestLayerShiftingStickyBox() const {
       return m_nearestLayerShiftingStickyBox;
    }
    void setNearestLayerShiftingStickyBox(const String& value);  // Defined below

    bool hasNearestLayerShiftingContainingBlock() { return !!m_nearestLayerShiftingContainingBlock; }
    String getNearestLayerShiftingContainingBlock(const String& defaultValue) const {
       return m_nearestLayerShiftingContainingBlock.value_or(defaultValue);
    }
    const std::optional<String>& getNearestLayerShiftingContainingBlock() const {
       return m_nearestLayerShiftingContainingBlock;
    }
    void setNearestLayerShiftingContainingBlock(const String& value);  // Defined below

    template<int STATE>
    class StickyPositionConstraintBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            StickyBoxRectSet = 1 << 1,
            ContainingBlockRectSet = 1 << 2,
            AllFieldsSet = (StickyBoxRectSet | ContainingBlockRectSet | 0)};


        StickyPositionConstraintBuilder<STATE | StickyBoxRectSet>& setStickyBoxRect(std::unique_ptr<protocol::DOM::Rect> value);  // Defined below

        StickyPositionConstraintBuilder<STATE | ContainingBlockRectSet>& setContainingBlockRect(std::unique_ptr<protocol::DOM::Rect> value);  // Defined below

        StickyPositionConstraintBuilder<STATE>& setNearestLayerShiftingStickyBox(const String& value);  // Defined below

        StickyPositionConstraintBuilder<STATE>& setNearestLayerShiftingContainingBlock(const String& value);  // Defined below

        std::unique_ptr<StickyPositionConstraint> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class StickyPositionConstraint;
        StickyPositionConstraintBuilder() : m_result(new StickyPositionConstraint()) { }

        template<int STEP> StickyPositionConstraintBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<StickyPositionConstraintBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::LayerTree::StickyPositionConstraint> m_result;
    };

    static StickyPositionConstraintBuilder<0> create()
    {
        return StickyPositionConstraintBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    StickyPositionConstraint();  // Defined below

    std::unique_ptr<protocol::DOM::Rect> m_stickyBoxRect;
    std::unique_ptr<protocol::DOM::Rect> m_containingBlockRect;
    std::optional<String> m_nearestLayerShiftingStickyBox;
    std::optional<String> m_nearestLayerShiftingContainingBlock;
};


class CORE_EXPORT PictureTile : public ::crdtp::ProtocolObject<PictureTile> {
public:
    ~PictureTile() override;  // Defined below

    double getX() { return m_x; }
    void setX(double value);  // Defined below

    double getY() { return m_y; }
    void setY(double value);  // Defined below

    Binary getPicture() { return m_picture; }
    void setPicture(const Binary& value);  // Defined below

    template<int STATE>
    class PictureTileBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            XSet = 1 << 1,
            YSet = 1 << 2,
            PictureSet = 1 << 3,
            AllFieldsSet = (XSet | YSet | PictureSet | 0)};


        PictureTileBuilder<STATE | XSet>& setX(double value);  // Defined below

        PictureTileBuilder<STATE | YSet>& setY(double value);  // Defined below

        PictureTileBuilder<STATE | PictureSet>& setPicture(const Binary& value);  // Defined below

        std::unique_ptr<PictureTile> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class PictureTile;
        PictureTileBuilder() : m_result(new PictureTile()) { }

        template<int STEP> PictureTileBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<PictureTileBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::LayerTree::PictureTile> m_result;
    };

    static PictureTileBuilder<0> create()
    {
        return PictureTileBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    PictureTile();  // Defined below

    double m_x;
    double m_y;
    Binary m_picture;
};


class CORE_EXPORT Layer : public ::crdtp::ProtocolObject<Layer> {
public:
    ~Layer() override;  // Defined below

    String getLayerId() { return m_layerId; }
    void setLayerId(const String& value);  // Defined below

    bool hasParentLayerId() { return !!m_parentLayerId; }
    String getParentLayerId(const String& defaultValue) const {
       return m_parentLayerId.value_or(defaultValue);
    }
    const std::optional<String>& getParentLayerId() const {
       return m_parentLayerId;
    }
    void setParentLayerId(const String& value);  // Defined below

    bool hasBackendNodeId() { return !!m_backendNodeId; }
    int getBackendNodeId(int defaultValue) const {
       return m_backendNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getBackendNodeId() const {
       return m_backendNodeId;
    }
    void setBackendNodeId(int value);  // Defined below

    double getOffsetX() { return m_offsetX; }
    void setOffsetX(double value);  // Defined below

    double getOffsetY() { return m_offsetY; }
    void setOffsetY(double value);  // Defined below

    double getWidth() { return m_width; }
    void setWidth(double value);  // Defined below

    double getHeight() { return m_height; }
    void setHeight(double value);  // Defined below

    bool hasTransform() { return !!m_transform; }
    protocol::Array<double>* getTransform(protocol::Array<double>* defaultValue) {
       return m_transform ? m_transform.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<double>>& getTransform() const {
       return m_transform;
    }
    void setTransform(std::unique_ptr<protocol::Array<double>> value);  // Defined below

    bool hasAnchorX() { return !!m_anchorX; }
    double getAnchorX(double defaultValue) const {
       return m_anchorX.value_or(defaultValue);
    }
    const std::optional<double>& getAnchorX() const {
       return m_anchorX;
    }
    void setAnchorX(double value);  // Defined below

    bool hasAnchorY() { return !!m_anchorY; }
    double getAnchorY(double defaultValue) const {
       return m_anchorY.value_or(defaultValue);
    }
    const std::optional<double>& getAnchorY() const {
       return m_anchorY;
    }
    void setAnchorY(double value);  // Defined below

    bool hasAnchorZ() { return !!m_anchorZ; }
    double getAnchorZ(double defaultValue) const {
       return m_anchorZ.value_or(defaultValue);
    }
    const std::optional<double>& getAnchorZ() const {
       return m_anchorZ;
    }
    void setAnchorZ(double value);  // Defined below

    int getPaintCount() { return m_paintCount; }
    void setPaintCount(int value);  // Defined below

    bool getDrawsContent() { return m_drawsContent; }
    void setDrawsContent(bool value);  // Defined below

    bool hasInvisible() { return !!m_invisible; }
    bool getInvisible(bool defaultValue) const {
       return m_invisible.value_or(defaultValue);
    }
    const std::optional<bool>& getInvisible() const {
       return m_invisible;
    }
    void setInvisible(bool value);  // Defined below

    bool hasScrollRects() { return !!m_scrollRects; }
    protocol::Array<protocol::LayerTree::ScrollRect>* getScrollRects(protocol::Array<protocol::LayerTree::ScrollRect>* defaultValue) {
       return m_scrollRects ? m_scrollRects.get() : defaultValue;
    }
    const std::unique_ptr<protocol::Array<protocol::LayerTree::ScrollRect>>& getScrollRects() const {
       return m_scrollRects;
    }
    void setScrollRects(std::unique_ptr<protocol::Array<protocol::LayerTree::ScrollRect>> value);  // Defined below

    bool hasStickyPositionConstraint() { return !!m_stickyPositionConstraint; }
    protocol::LayerTree::StickyPositionConstraint* getStickyPositionConstraint(protocol::LayerTree::StickyPositionConstraint* defaultValue) {
       return m_stickyPositionConstraint ? m_stickyPositionConstraint.get() : defaultValue;
    }
    const std::unique_ptr<protocol::LayerTree::StickyPositionConstraint>& getStickyPositionConstraint() const {
       return m_stickyPositionConstraint;
    }
    void setStickyPositionConstraint(std::unique_ptr<protocol::LayerTree::StickyPositionConstraint> value);  // Defined below

    template<int STATE>
    class LayerBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            LayerIdSet = 1 << 1,
            OffsetXSet = 1 << 2,
            OffsetYSet = 1 << 3,
            WidthSet = 1 << 4,
            HeightSet = 1 << 5,
            PaintCountSet = 1 << 6,
            DrawsContentSet = 1 << 7,
            AllFieldsSet = (LayerIdSet | OffsetXSet | OffsetYSet | WidthSet | HeightSet | PaintCountSet | DrawsContentSet | 0)};


        LayerBuilder<STATE | LayerIdSet>& setLayerId(const String& value);  // Defined below

        LayerBuilder<STATE>& setParentLayerId(const String& value);  // Defined below

        LayerBuilder<STATE>& setBackendNodeId(int value);  // Defined below

        LayerBuilder<STATE | OffsetXSet>& setOffsetX(double value);  // Defined below

        LayerBuilder<STATE | OffsetYSet>& setOffsetY(double value);  // Defined below

        LayerBuilder<STATE | WidthSet>& setWidth(double value);  // Defined below

        LayerBuilder<STATE | HeightSet>& setHeight(double value);  // Defined below

        LayerBuilder<STATE>& setTransform(std::unique_ptr<protocol::Array<double>> value);  // Defined below

        LayerBuilder<STATE>& setAnchorX(double value);  // Defined below

        LayerBuilder<STATE>& setAnchorY(double value);  // Defined below

        LayerBuilder<STATE>& setAnchorZ(double value);  // Defined below

        LayerBuilder<STATE | PaintCountSet>& setPaintCount(int value);  // Defined below

        LayerBuilder<STATE | DrawsContentSet>& setDrawsContent(bool value);  // Defined below

        LayerBuilder<STATE>& setInvisible(bool value);  // Defined below

        LayerBuilder<STATE>& setScrollRects(std::unique_ptr<protocol::Array<protocol::LayerTree::ScrollRect>> value);  // Defined below

        LayerBuilder<STATE>& setStickyPositionConstraint(std::unique_ptr<protocol::LayerTree::StickyPositionConstraint> value);  // Defined below

        std::unique_ptr<Layer> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class Layer;
        LayerBuilder() : m_result(new Layer()) { }

        template<int STEP> LayerBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<LayerBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::LayerTree::Layer> m_result;
    };

    static LayerBuilder<0> create()
    {
        return LayerBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    Layer();  // Defined below

    String m_layerId;
    std::optional<String> m_parentLayerId;
    std::optional<int> m_backendNodeId;
    double m_offsetX;
    double m_offsetY;
    double m_width;
    double m_height;
    std::unique_ptr<protocol::Array<double>> m_transform;
    std::optional<double> m_anchorX;
    std::optional<double> m_anchorY;
    std::optional<double> m_anchorZ;
    int m_paintCount;
    bool m_drawsContent;
    std::optional<bool> m_invisible;
    std::unique_ptr<protocol::Array<protocol::LayerTree::ScrollRect>> m_scrollRects;
    std::unique_ptr<protocol::LayerTree::StickyPositionConstraint> m_stickyPositionConstraint;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline ScrollRect::~ScrollRect() = default;
inline void ScrollRect::setRect(std::unique_ptr<protocol::DOM::Rect> value) { m_rect = std::move(value); }
inline void ScrollRect::setType(const String& value) { m_type = value; }

template<int STATE>
inline ScrollRect::ScrollRectBuilder<STATE | ScrollRect::ScrollRectBuilder<STATE>::RectSet>&
ScrollRect::ScrollRectBuilder<STATE>::setRect(std::unique_ptr<protocol::DOM::Rect> value) {
  static_assert(!(STATE & RectSet), "property rect should not be set yet");
  m_result->setRect(std::move(value));
  return castState<RectSet>();
}
template<int STATE>
inline ScrollRect::ScrollRectBuilder<STATE | ScrollRect::ScrollRectBuilder<STATE>::TypeSet>&
ScrollRect::ScrollRectBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}

inline ScrollRect::ScrollRect() {
}
inline StickyPositionConstraint::~StickyPositionConstraint() = default;
inline void StickyPositionConstraint::setStickyBoxRect(std::unique_ptr<protocol::DOM::Rect> value) { m_stickyBoxRect = std::move(value); }
inline void StickyPositionConstraint::setContainingBlockRect(std::unique_ptr<protocol::DOM::Rect> value) { m_containingBlockRect = std::move(value); }
inline void StickyPositionConstraint::setNearestLayerShiftingStickyBox(const String& value) { m_nearestLayerShiftingStickyBox = value; }
inline void StickyPositionConstraint::setNearestLayerShiftingContainingBlock(const String& value) { m_nearestLayerShiftingContainingBlock = value; }

template<int STATE>
inline StickyPositionConstraint::StickyPositionConstraintBuilder<STATE | StickyPositionConstraint::StickyPositionConstraintBuilder<STATE>::StickyBoxRectSet>&
StickyPositionConstraint::StickyPositionConstraintBuilder<STATE>::setStickyBoxRect(std::unique_ptr<protocol::DOM::Rect> value) {
  static_assert(!(STATE & StickyBoxRectSet), "property stickyBoxRect should not be set yet");
  m_result->setStickyBoxRect(std::move(value));
  return castState<StickyBoxRectSet>();
}
template<int STATE>
inline StickyPositionConstraint::StickyPositionConstraintBuilder<STATE | StickyPositionConstraint::StickyPositionConstraintBuilder<STATE>::ContainingBlockRectSet>&
StickyPositionConstraint::StickyPositionConstraintBuilder<STATE>::setContainingBlockRect(std::unique_ptr<protocol::DOM::Rect> value) {
  static_assert(!(STATE & ContainingBlockRectSet), "property containingBlockRect should not be set yet");
  m_result->setContainingBlockRect(std::move(value));
  return castState<ContainingBlockRectSet>();
}
template<int STATE>
inline StickyPositionConstraint::StickyPositionConstraintBuilder<STATE>& StickyPositionConstraint::StickyPositionConstraintBuilder<STATE>::setNearestLayerShiftingStickyBox(const String& value) {
  m_result->setNearestLayerShiftingStickyBox(value);
  return *this;
}
template<int STATE>
inline StickyPositionConstraint::StickyPositionConstraintBuilder<STATE>& StickyPositionConstraint::StickyPositionConstraintBuilder<STATE>::setNearestLayerShiftingContainingBlock(const String& value) {
  m_result->setNearestLayerShiftingContainingBlock(value);
  return *this;
}

inline StickyPositionConstraint::StickyPositionConstraint() {
}
inline PictureTile::~PictureTile() = default;
inline void PictureTile::setX(double value) { m_x = value; }
inline void PictureTile::setY(double value) { m_y = value; }
inline void PictureTile::setPicture(const Binary& value) { m_picture = value; }

template<int STATE>
inline PictureTile::PictureTileBuilder<STATE | PictureTile::PictureTileBuilder<STATE>::XSet>&
PictureTile::PictureTileBuilder<STATE>::setX(double value) {
  static_assert(!(STATE & XSet), "property x should not be set yet");
  m_result->setX(value);
  return castState<XSet>();
}
template<int STATE>
inline PictureTile::PictureTileBuilder<STATE | PictureTile::PictureTileBuilder<STATE>::YSet>&
PictureTile::PictureTileBuilder<STATE>::setY(double value) {
  static_assert(!(STATE & YSet), "property y should not be set yet");
  m_result->setY(value);
  return castState<YSet>();
}
template<int STATE>
inline PictureTile::PictureTileBuilder<STATE | PictureTile::PictureTileBuilder<STATE>::PictureSet>&
PictureTile::PictureTileBuilder<STATE>::setPicture(const Binary& value) {
  static_assert(!(STATE & PictureSet), "property picture should not be set yet");
  m_result->setPicture(value);
  return castState<PictureSet>();
}

inline PictureTile::PictureTile() {
  m_x = 0;
  m_y = 0;
}
inline Layer::~Layer() = default;
inline void Layer::setLayerId(const String& value) { m_layerId = value; }
inline void Layer::setParentLayerId(const String& value) { m_parentLayerId = value; }
inline void Layer::setBackendNodeId(int value) { m_backendNodeId = value; }
inline void Layer::setOffsetX(double value) { m_offsetX = value; }
inline void Layer::setOffsetY(double value) { m_offsetY = value; }
inline void Layer::setWidth(double value) { m_width = value; }
inline void Layer::setHeight(double value) { m_height = value; }
inline void Layer::setTransform(std::unique_ptr<protocol::Array<double>> value) { m_transform = std::move(value); }
inline void Layer::setAnchorX(double value) { m_anchorX = value; }
inline void Layer::setAnchorY(double value) { m_anchorY = value; }
inline void Layer::setAnchorZ(double value) { m_anchorZ = value; }
inline void Layer::setPaintCount(int value) { m_paintCount = value; }
inline void Layer::setDrawsContent(bool value) { m_drawsContent = value; }
inline void Layer::setInvisible(bool value) { m_invisible = value; }
inline void Layer::setScrollRects(std::unique_ptr<protocol::Array<protocol::LayerTree::ScrollRect>> value) { m_scrollRects = std::move(value); }
inline void Layer::setStickyPositionConstraint(std::unique_ptr<protocol::LayerTree::StickyPositionConstraint> value) { m_stickyPositionConstraint = std::move(value); }

template<int STATE>
inline Layer::LayerBuilder<STATE | Layer::LayerBuilder<STATE>::LayerIdSet>&
Layer::LayerBuilder<STATE>::setLayerId(const String& value) {
  static_assert(!(STATE & LayerIdSet), "property layerId should not be set yet");
  m_result->setLayerId(value);
  return castState<LayerIdSet>();
}
template<int STATE>
inline Layer::LayerBuilder<STATE>& Layer::LayerBuilder<STATE>::setParentLayerId(const String& value) {
  m_result->setParentLayerId(value);
  return *this;
}
template<int STATE>
inline Layer::LayerBuilder<STATE>& Layer::LayerBuilder<STATE>::setBackendNodeId(int value) {
  m_result->setBackendNodeId(value);
  return *this;
}
template<int STATE>
inline Layer::LayerBuilder<STATE | Layer::LayerBuilder<STATE>::OffsetXSet>&
Layer::LayerBuilder<STATE>::setOffsetX(double value) {
  static_assert(!(STATE & OffsetXSet), "property offsetX should not be set yet");
  m_result->setOffsetX(value);
  return castState<OffsetXSet>();
}
template<int STATE>
inline Layer::LayerBuilder<STATE | Layer::LayerBuilder<STATE>::OffsetYSet>&
Layer::LayerBuilder<STATE>::setOffsetY(double value) {
  static_assert(!(STATE & OffsetYSet), "property offsetY should not be set yet");
  m_result->setOffsetY(value);
  return castState<OffsetYSet>();
}
template<int STATE>
inline Layer::LayerBuilder<STATE | Layer::LayerBuilder<STATE>::WidthSet>&
Layer::LayerBuilder<STATE>::setWidth(double value) {
  static_assert(!(STATE & WidthSet), "property width should not be set yet");
  m_result->setWidth(value);
  return castState<WidthSet>();
}
template<int STATE>
inline Layer::LayerBuilder<STATE | Layer::LayerBuilder<STATE>::HeightSet>&
Layer::LayerBuilder<STATE>::setHeight(double value) {
  static_assert(!(STATE & HeightSet), "property height should not be set yet");
  m_result->setHeight(value);
  return castState<HeightSet>();
}
template<int STATE>
inline Layer::LayerBuilder<STATE>& Layer::LayerBuilder<STATE>::setTransform(std::unique_ptr<protocol::Array<double>> value) {
  m_result->setTransform(std::move(value));
  return *this;
}
template<int STATE>
inline Layer::LayerBuilder<STATE>& Layer::LayerBuilder<STATE>::setAnchorX(double value) {
  m_result->setAnchorX(value);
  return *this;
}
template<int STATE>
inline Layer::LayerBuilder<STATE>& Layer::LayerBuilder<STATE>::setAnchorY(double value) {
  m_result->setAnchorY(value);
  return *this;
}
template<int STATE>
inline Layer::LayerBuilder<STATE>& Layer::LayerBuilder<STATE>::setAnchorZ(double value) {
  m_result->setAnchorZ(value);
  return *this;
}
template<int STATE>
inline Layer::LayerBuilder<STATE | Layer::LayerBuilder<STATE>::PaintCountSet>&
Layer::LayerBuilder<STATE>::setPaintCount(int value) {
  static_assert(!(STATE & PaintCountSet), "property paintCount should not be set yet");
  m_result->setPaintCount(value);
  return castState<PaintCountSet>();
}
template<int STATE>
inline Layer::LayerBuilder<STATE | Layer::LayerBuilder<STATE>::DrawsContentSet>&
Layer::LayerBuilder<STATE>::setDrawsContent(bool value) {
  static_assert(!(STATE & DrawsContentSet), "property drawsContent should not be set yet");
  m_result->setDrawsContent(value);
  return castState<DrawsContentSet>();
}
template<int STATE>
inline Layer::LayerBuilder<STATE>& Layer::LayerBuilder<STATE>::setInvisible(bool value) {
  m_result->setInvisible(value);
  return *this;
}
template<int STATE>
inline Layer::LayerBuilder<STATE>& Layer::LayerBuilder<STATE>::setScrollRects(std::unique_ptr<protocol::Array<protocol::LayerTree::ScrollRect>> value) {
  m_result->setScrollRects(std::move(value));
  return *this;
}
template<int STATE>
inline Layer::LayerBuilder<STATE>& Layer::LayerBuilder<STATE>::setStickyPositionConstraint(std::unique_ptr<protocol::LayerTree::StickyPositionConstraint> value) {
  m_result->setStickyPositionConstraint(std::move(value));
  return *this;
}

inline Layer::Layer() {
  m_offsetX = 0;
  m_offsetY = 0;
  m_width = 0;
  m_height = 0;
  m_paintCount = 0;
  m_drawsContent = false;
}

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse compositingReasons(const String& in_layerId, std::unique_ptr<protocol::Array<String>>* out_compositingReasons, std::unique_ptr<protocol::Array<String>>* out_compositingReasonIds) = 0;
    virtual DispatchResponse disable() = 0;
    virtual DispatchResponse enable() = 0;
    virtual DispatchResponse loadSnapshot(std::unique_ptr<protocol::Array<protocol::LayerTree::PictureTile>> in_tiles, String* out_snapshotId) = 0;
    virtual DispatchResponse makeSnapshot(const String& in_layerId, String* out_snapshotId) = 0;
    virtual DispatchResponse profileSnapshot(const String& in_snapshotId, std::optional<int> in_minRepeatCount, std::optional<double> in_minDuration, std::unique_ptr<protocol::DOM::Rect> in_clipRect, std::unique_ptr<protocol::Array<protocol::Array<double>>>* out_timings) = 0;
    virtual DispatchResponse releaseSnapshot(const String& in_snapshotId) = 0;
    virtual DispatchResponse replaySnapshot(const String& in_snapshotId, std::optional<int> in_fromStep, std::optional<int> in_toStep, std::optional<double> in_scale, String* out_dataURL) = 0;
    virtual DispatchResponse snapshotCommandLog(const String& in_snapshotId, std::unique_ptr<protocol::Array<protocol::DictionaryValue>>* out_commandLog) = 0;

};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void layerPainted(const String& layerId, std::unique_ptr<protocol::DOM::Rect> clip);
    void layerTreeDidChange(std::unique_ptr<protocol::Array<protocol::LayerTree::Layer>> layers = {});

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace LayerTree
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_LayerTree_h)
