// This file is generated by TypeBuilder_h.template.

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef blink_protocol_DOMDebugger_h
#define blink_protocol_DOMDebugger_h

#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/core/inspector/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.
#include "third_party/blink/renderer/core/inspector/protocol/dom.h"
#include "third_party/blink/renderer/core/inspector/protocol/runtime.h"

namespace blink {
namespace protocol {
namespace DOMDebugger {
using DOMBreakpointType = String;
using CSPViolationType = String;
class EventListener;

// ------------- Forward and enum declarations.

namespace DOMBreakpointTypeEnum {
CORE_EXPORT extern const char SubtreeModified[];
CORE_EXPORT extern const char AttributeModified[];
CORE_EXPORT extern const char NodeRemoved[];
} // namespace DOMBreakpointTypeEnum

namespace CSPViolationTypeEnum {
CORE_EXPORT extern const char TrustedtypeSinkViolation[];
CORE_EXPORT extern const char TrustedtypePolicyViolation[];
} // namespace CSPViolationTypeEnum

// ------------- Type and builder declarations.

class CORE_EXPORT EventListener : public ::crdtp::ProtocolObject<EventListener> {
public:
    ~EventListener() override;  // Defined below

    String getType() { return m_type; }
    void setType(const String& value);  // Defined below

    bool getUseCapture() { return m_useCapture; }
    void setUseCapture(bool value);  // Defined below

    bool getPassive() { return m_passive; }
    void setPassive(bool value);  // Defined below

    bool getOnce() { return m_once; }
    void setOnce(bool value);  // Defined below

    String getScriptId() { return m_scriptId; }
    void setScriptId(const String& value);  // Defined below

    int getLineNumber() { return m_lineNumber; }
    void setLineNumber(int value);  // Defined below

    int getColumnNumber() { return m_columnNumber; }
    void setColumnNumber(int value);  // Defined below

    bool hasHandler() { return !!m_handler; }
    v8_inspector::protocol::Runtime::API::RemoteObject* getHandler(v8_inspector::protocol::Runtime::API::RemoteObject* defaultValue) {
       return m_handler ? m_handler.get() : defaultValue;
    }
    const std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject>& getHandler() const {
       return m_handler;
    }
    void setHandler(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value);  // Defined below

    bool hasOriginalHandler() { return !!m_originalHandler; }
    v8_inspector::protocol::Runtime::API::RemoteObject* getOriginalHandler(v8_inspector::protocol::Runtime::API::RemoteObject* defaultValue) {
       return m_originalHandler ? m_originalHandler.get() : defaultValue;
    }
    const std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject>& getOriginalHandler() const {
       return m_originalHandler;
    }
    void setOriginalHandler(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value);  // Defined below

    bool hasBackendNodeId() { return !!m_backendNodeId; }
    int getBackendNodeId(int defaultValue) const {
       return m_backendNodeId.value_or(defaultValue);
    }
    const std::optional<int>& getBackendNodeId() const {
       return m_backendNodeId;
    }
    void setBackendNodeId(int value);  // Defined below

    template<int STATE>
    class EventListenerBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TypeSet = 1 << 1,
            UseCaptureSet = 1 << 2,
            PassiveSet = 1 << 3,
            OnceSet = 1 << 4,
            ScriptIdSet = 1 << 5,
            LineNumberSet = 1 << 6,
            ColumnNumberSet = 1 << 7,
            AllFieldsSet = (TypeSet | UseCaptureSet | PassiveSet | OnceSet | ScriptIdSet | LineNumberSet | ColumnNumberSet | 0)};


        EventListenerBuilder<STATE | TypeSet>& setType(const String& value);  // Defined below

        EventListenerBuilder<STATE | UseCaptureSet>& setUseCapture(bool value);  // Defined below

        EventListenerBuilder<STATE | PassiveSet>& setPassive(bool value);  // Defined below

        EventListenerBuilder<STATE | OnceSet>& setOnce(bool value);  // Defined below

        EventListenerBuilder<STATE | ScriptIdSet>& setScriptId(const String& value);  // Defined below

        EventListenerBuilder<STATE | LineNumberSet>& setLineNumber(int value);  // Defined below

        EventListenerBuilder<STATE | ColumnNumberSet>& setColumnNumber(int value);  // Defined below

        EventListenerBuilder<STATE>& setHandler(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value);  // Defined below

        EventListenerBuilder<STATE>& setOriginalHandler(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value);  // Defined below

        EventListenerBuilder<STATE>& setBackendNodeId(int value);  // Defined below

        std::unique_ptr<EventListener> build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class EventListener;
        EventListenerBuilder() : m_result(new EventListener()) { }

        template<int STEP> EventListenerBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<EventListenerBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::DOMDebugger::EventListener> m_result;
    };

    static EventListenerBuilder<0> create()
    {
        return EventListenerBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    EventListener();  // Defined below

    String m_type;
    bool m_useCapture;
    bool m_passive;
    bool m_once;
    String m_scriptId;
    int m_lineNumber;
    int m_columnNumber;
    std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> m_handler;
    std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> m_originalHandler;
    std::optional<int> m_backendNodeId;
};


// ------------- Type and builder method definitions.
//
// These methods separate from the type declaration because of
// https://github.com/llvm/llvm-project/issues/59966. The DevTools protocol has
// mutually recursive types, so we cannot simply reorder the types.
inline EventListener::~EventListener() = default;
inline void EventListener::setType(const String& value) { m_type = value; }
inline void EventListener::setUseCapture(bool value) { m_useCapture = value; }
inline void EventListener::setPassive(bool value) { m_passive = value; }
inline void EventListener::setOnce(bool value) { m_once = value; }
inline void EventListener::setScriptId(const String& value) { m_scriptId = value; }
inline void EventListener::setLineNumber(int value) { m_lineNumber = value; }
inline void EventListener::setColumnNumber(int value) { m_columnNumber = value; }
inline void EventListener::setHandler(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value) { m_handler = std::move(value); }
inline void EventListener::setOriginalHandler(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value) { m_originalHandler = std::move(value); }
inline void EventListener::setBackendNodeId(int value) { m_backendNodeId = value; }

template<int STATE>
inline EventListener::EventListenerBuilder<STATE | EventListener::EventListenerBuilder<STATE>::TypeSet>&
EventListener::EventListenerBuilder<STATE>::setType(const String& value) {
  static_assert(!(STATE & TypeSet), "property type should not be set yet");
  m_result->setType(value);
  return castState<TypeSet>();
}
template<int STATE>
inline EventListener::EventListenerBuilder<STATE | EventListener::EventListenerBuilder<STATE>::UseCaptureSet>&
EventListener::EventListenerBuilder<STATE>::setUseCapture(bool value) {
  static_assert(!(STATE & UseCaptureSet), "property useCapture should not be set yet");
  m_result->setUseCapture(value);
  return castState<UseCaptureSet>();
}
template<int STATE>
inline EventListener::EventListenerBuilder<STATE | EventListener::EventListenerBuilder<STATE>::PassiveSet>&
EventListener::EventListenerBuilder<STATE>::setPassive(bool value) {
  static_assert(!(STATE & PassiveSet), "property passive should not be set yet");
  m_result->setPassive(value);
  return castState<PassiveSet>();
}
template<int STATE>
inline EventListener::EventListenerBuilder<STATE | EventListener::EventListenerBuilder<STATE>::OnceSet>&
EventListener::EventListenerBuilder<STATE>::setOnce(bool value) {
  static_assert(!(STATE & OnceSet), "property once should not be set yet");
  m_result->setOnce(value);
  return castState<OnceSet>();
}
template<int STATE>
inline EventListener::EventListenerBuilder<STATE | EventListener::EventListenerBuilder<STATE>::ScriptIdSet>&
EventListener::EventListenerBuilder<STATE>::setScriptId(const String& value) {
  static_assert(!(STATE & ScriptIdSet), "property scriptId should not be set yet");
  m_result->setScriptId(value);
  return castState<ScriptIdSet>();
}
template<int STATE>
inline EventListener::EventListenerBuilder<STATE | EventListener::EventListenerBuilder<STATE>::LineNumberSet>&
EventListener::EventListenerBuilder<STATE>::setLineNumber(int value) {
  static_assert(!(STATE & LineNumberSet), "property lineNumber should not be set yet");
  m_result->setLineNumber(value);
  return castState<LineNumberSet>();
}
template<int STATE>
inline EventListener::EventListenerBuilder<STATE | EventListener::EventListenerBuilder<STATE>::ColumnNumberSet>&
EventListener::EventListenerBuilder<STATE>::setColumnNumber(int value) {
  static_assert(!(STATE & ColumnNumberSet), "property columnNumber should not be set yet");
  m_result->setColumnNumber(value);
  return castState<ColumnNumberSet>();
}
template<int STATE>
inline EventListener::EventListenerBuilder<STATE>& EventListener::EventListenerBuilder<STATE>::setHandler(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value) {
  m_result->setHandler(std::move(value));
  return *this;
}
template<int STATE>
inline EventListener::EventListenerBuilder<STATE>& EventListener::EventListenerBuilder<STATE>::setOriginalHandler(std::unique_ptr<v8_inspector::protocol::Runtime::API::RemoteObject> value) {
  m_result->setOriginalHandler(std::move(value));
  return *this;
}
template<int STATE>
inline EventListener::EventListenerBuilder<STATE>& EventListener::EventListenerBuilder<STATE>::setBackendNodeId(int value) {
  m_result->setBackendNodeId(value);
  return *this;
}

inline EventListener::EventListener() {
  m_useCapture = false;
  m_passive = false;
  m_once = false;
  m_lineNumber = 0;
  m_columnNumber = 0;
}

// ------------- Backend interface.

class CORE_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse getEventListeners(const String& in_objectId, std::optional<int> in_depth, std::optional<bool> in_pierce, std::unique_ptr<protocol::Array<protocol::DOMDebugger::EventListener>>* out_listeners) = 0;
    virtual DispatchResponse removeDOMBreakpoint(int in_nodeId, const String& in_type) = 0;
    virtual DispatchResponse removeEventListenerBreakpoint(const String& in_eventName, std::optional<String> in_targetName) = 0;
    virtual DispatchResponse removeXHRBreakpoint(const String& in_url) = 0;
    virtual DispatchResponse setBreakOnCSPViolation(std::unique_ptr<protocol::Array<String>> in_violationTypes) = 0;
    virtual DispatchResponse setDOMBreakpoint(int in_nodeId, const String& in_type) = 0;
    virtual DispatchResponse setEventListenerBreakpoint(const String& in_eventName, std::optional<String> in_targetName) = 0;
    virtual DispatchResponse setXHRBreakpoint(const String& in_url) = 0;

    virtual DispatchResponse disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CORE_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CORE_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CORE_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace DOMDebugger
} // namespace blink
} // namespace protocol

#endif // !defined(blink_protocol_DOMDebugger_h)
