// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_RENDERER_CORE_CSS_CSS_PROPERTY_NAMES_H_
#define THIRD_PARTY_BLINK_RENDERER_CORE_CSS_CSS_PROPERTY_NAMES_H_

#include <stddef.h>

#include "base/check_op.h"
#include "third_party/blink/public/mojom/use_counter/metrics/css_property_id.mojom-blink-forward.h"
#include "third_party/blink/renderer/core/core_export.h"
#include "third_party/blink/renderer/platform/wtf/allocator/allocator.h"
#include "third_party/blink/renderer/platform/wtf/forward.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/hash_traits.h"

namespace blink {

class ExecutionContext;

enum class CSSPropertyID {
    kInvalid = 0,
    kVariable = 1,
    kColorScheme = 2,
    kForcedColorAdjust = 3,
    kMaskImage = 4,
    kMathDepth = 5,
    kPosition = 6,
    kPositionAnchor = 7,
    kTextSizeAdjust = 8,
    kInternalVisitedColor = 9,
    kAppearance = 10,
    kColor = 11,
    kDirection = 12,
    kFontFamily = 13,
    kFontFeatureSettings = 14,
    kFontKerning = 15,
    kFontLanguageOverride = 16,
    kFontOpticalSizing = 17,
    kFontPalette = 18,
    kFontSize = 19,
    kFontSizeAdjust = 20,
    kFontStretch = 21,
    kFontStyle = 22,
    kFontSynthesisSmallCaps = 23,
    kFontSynthesisStyle = 24,
    kFontSynthesisWeight = 25,
    kFontVariantAlternates = 26,
    kFontVariantCaps = 27,
    kFontVariantEastAsian = 28,
    kFontVariantEmoji = 29,
    kFontVariantLigatures = 30,
    kFontVariantNumeric = 31,
    kFontVariantPosition = 32,
    kFontVariationSettings = 33,
    kFontWeight = 34,
    kPositionArea = 35,
    kTextOrientation = 36,
    kTextRendering = 37,
    kTextSpacingTrim = 38,
    kWebkitFontSmoothing = 39,
    kWebkitLocale = 40,
    kWebkitTextOrientation = 41,
    kWebkitWritingMode = 42,
    kWritingMode = 43,
    kZoom = 44,
    kInternalForcedVisitedColor = 45,
    kInternalVisitedBackgroundColor = 46,
    kInternalVisitedBorderBlockEndColor = 47,
    kInternalVisitedBorderBlockStartColor = 48,
    kInternalVisitedBorderBottomColor = 49,
    kInternalVisitedBorderInlineEndColor = 50,
    kInternalVisitedBorderInlineStartColor = 51,
    kInternalVisitedBorderLeftColor = 52,
    kInternalVisitedBorderRightColor = 53,
    kInternalVisitedBorderTopColor = 54,
    kInternalVisitedCaretColor = 55,
    kInternalVisitedColumnRuleColor = 56,
    kInternalVisitedFill = 57,
    kInternalVisitedOutlineColor = 58,
    kInternalVisitedStroke = 59,
    kInternalVisitedTextDecorationColor = 60,
    kInternalVisitedTextEmphasisColor = 61,
    kInternalVisitedTextFillColor = 62,
    kInternalVisitedTextStrokeColor = 63,
    kAccentColor = 64,
    kAdditiveSymbols = 65,
    kAlignContent = 66,
    kAlignItems = 67,
    kAlignSelf = 68,
    kAlignmentBaseline = 69,
    kAll = 70,
    kAnchorName = 71,
    kAnchorScope = 72,
    kAnimationComposition = 73,
    kAnimationDelay = 74,
    kAnimationDirection = 75,
    kAnimationDuration = 76,
    kAnimationFillMode = 77,
    kAnimationIterationCount = 78,
    kAnimationName = 79,
    kAnimationPlayState = 80,
    kAnimationRangeEnd = 81,
    kAnimationRangeStart = 82,
    kAnimationTimeline = 83,
    kAnimationTimingFunction = 84,
    kAnimationTrigger = 85,
    kAppRegion = 86,
    kAscentOverride = 87,
    kAspectRatio = 88,
    kBackdropFilter = 89,
    kBackfaceVisibility = 90,
    kBackgroundAttachment = 91,
    kBackgroundBlendMode = 92,
    kBackgroundClip = 93,
    kBackgroundColor = 94,
    kBackgroundImage = 95,
    kBackgroundOrigin = 96,
    kBackgroundPositionX = 97,
    kBackgroundPositionY = 98,
    kBackgroundRepeat = 99,
    kBackgroundSize = 100,
    kBasePalette = 101,
    kBaselineShift = 102,
    kBaselineSource = 103,
    kBlockEllipsis = 104,
    kBlockSize = 105,
    kBorderBlockEndColor = 106,
    kBorderBlockEndStyle = 107,
    kBorderBlockEndWidth = 108,
    kBorderBlockStartColor = 109,
    kBorderBlockStartStyle = 110,
    kBorderBlockStartWidth = 111,
    kBorderBottomColor = 112,
    kBorderBottomLeftRadius = 113,
    kBorderBottomRightRadius = 114,
    kBorderBottomStyle = 115,
    kBorderBottomWidth = 116,
    kBorderCollapse = 117,
    kBorderEndEndRadius = 118,
    kBorderEndStartRadius = 119,
    kBorderImageOutset = 120,
    kBorderImageRepeat = 121,
    kBorderImageSlice = 122,
    kBorderImageSource = 123,
    kBorderImageWidth = 124,
    kBorderInlineEndColor = 125,
    kBorderInlineEndStyle = 126,
    kBorderInlineEndWidth = 127,
    kBorderInlineStartColor = 128,
    kBorderInlineStartStyle = 129,
    kBorderInlineStartWidth = 130,
    kBorderLeftColor = 131,
    kBorderLeftStyle = 132,
    kBorderLeftWidth = 133,
    kBorderRightColor = 134,
    kBorderRightStyle = 135,
    kBorderRightWidth = 136,
    kBorderShape = 137,
    kBorderStartEndRadius = 138,
    kBorderStartStartRadius = 139,
    kBorderTopColor = 140,
    kBorderTopLeftRadius = 141,
    kBorderTopRightRadius = 142,
    kBorderTopStyle = 143,
    kBorderTopWidth = 144,
    kBottom = 145,
    kBoxDecorationBreak = 146,
    kBoxShadow = 147,
    kBoxSizing = 148,
    kBreakAfter = 149,
    kBreakBefore = 150,
    kBreakInside = 151,
    kBufferedRendering = 152,
    kCaptionSide = 153,
    kCaretAnimation = 154,
    kCaretColor = 155,
    kCaretShape = 156,
    kClear = 157,
    kClip = 158,
    kClipPath = 159,
    kClipRule = 160,
    kColorInterpolation = 161,
    kColorInterpolationFilters = 162,
    kColorRendering = 163,
    kColumnCount = 164,
    kColumnFill = 165,
    kColumnGap = 166,
    kColumnHeight = 167,
    kColumnRuleBreak = 168,
    kColumnRuleColor = 169,
    kColumnRuleOutset = 170,
    kColumnRuleStyle = 171,
    kColumnRuleVisibilityItems = 172,
    kColumnRuleWidth = 173,
    kColumnSpan = 174,
    kColumnWidth = 175,
    kColumnWrap = 176,
    kContain = 177,
    kContainIntrinsicBlockSize = 178,
    kContainIntrinsicHeight = 179,
    kContainIntrinsicInlineSize = 180,
    kContainIntrinsicWidth = 181,
    kContainerName = 182,
    kContainerType = 183,
    kContent = 184,
    kContentVisibility = 185,
    kContinue = 186,
    kCornerBottomLeftShape = 187,
    kCornerBottomRightShape = 188,
    kCornerEndEndShape = 189,
    kCornerEndStartShape = 190,
    kCornerStartEndShape = 191,
    kCornerStartStartShape = 192,
    kCornerTopLeftShape = 193,
    kCornerTopRightShape = 194,
    kCounterIncrement = 195,
    kCounterReset = 196,
    kCounterSet = 197,
    kCursor = 198,
    kCx = 199,
    kCy = 200,
    kD = 201,
    kDescentOverride = 202,
    kDisplay = 203,
    kDominantBaseline = 204,
    kDynamicRangeLimit = 205,
    kEmptyCells = 206,
    kFallback = 207,
    kFieldSizing = 208,
    kFill = 209,
    kFillOpacity = 210,
    kFillRule = 211,
    kFilter = 212,
    kFlexBasis = 213,
    kFlexDirection = 214,
    kFlexGrow = 215,
    kFlexShrink = 216,
    kFlexWrap = 217,
    kFloat = 218,
    kFloodColor = 219,
    kFloodOpacity = 220,
    kFontDisplay = 221,
    kGapRuleOverlap = 222,
    kGridAutoColumns = 223,
    kGridAutoFlow = 224,
    kGridAutoRows = 225,
    kGridColumnEnd = 226,
    kGridColumnStart = 227,
    kGridRowEnd = 228,
    kGridRowStart = 229,
    kGridTemplateAreas = 230,
    kGridTemplateColumns = 231,
    kGridTemplateRows = 232,
    kHeight = 233,
    kHyphenateCharacter = 234,
    kHyphenateLimitChars = 235,
    kHyphens = 236,
    kImageOrientation = 237,
    kImageRendering = 238,
    kInherits = 239,
    kInitialLetter = 240,
    kInitialValue = 241,
    kInlineSize = 242,
    kInsetBlockEnd = 243,
    kInsetBlockStart = 244,
    kInsetInlineEnd = 245,
    kInsetInlineStart = 246,
    kInteractivity = 247,
    kInterestDelayEnd = 248,
    kInterestDelayStart = 249,
    kInternalAlignContentBlock = 250,
    kInternalEmptyLineHeight = 251,
    kInternalFontSizeDelta = 252,
    kInternalForcedBackgroundColor = 253,
    kInternalForcedBorderColor = 254,
    kInternalForcedColor = 255,
    kInternalForcedOutlineColor = 256,
    kInterpolateSize = 257,
    kIsolation = 258,
    kItemTolerance = 259,
    kJustifyContent = 260,
    kJustifyItems = 261,
    kJustifySelf = 262,
    kLeft = 263,
    kLetterSpacing = 264,
    kLightingColor = 265,
    kLineBreak = 266,
    kLineGapOverride = 267,
    kLineHeight = 268,
    kListStyleImage = 269,
    kListStylePosition = 270,
    kListStyleType = 271,
    kMarginBlockEnd = 272,
    kMarginBlockStart = 273,
    kMarginBottom = 274,
    kMarginInlineEnd = 275,
    kMarginInlineStart = 276,
    kMarginLeft = 277,
    kMarginRight = 278,
    kMarginTop = 279,
    kMarkerEnd = 280,
    kMarkerMid = 281,
    kMarkerStart = 282,
    kMaskClip = 283,
    kMaskComposite = 284,
    kMaskMode = 285,
    kMaskOrigin = 286,
    kMaskRepeat = 287,
    kMaskSize = 288,
    kMaskType = 289,
    kMasonryDirection = 290,
    kMasonryFill = 291,
    kMathShift = 292,
    kMathStyle = 293,
    kMaxBlockSize = 294,
    kMaxHeight = 295,
    kMaxInlineSize = 296,
    kMaxLines = 297,
    kMaxWidth = 298,
    kMinBlockSize = 299,
    kMinHeight = 300,
    kMinInlineSize = 301,
    kMinWidth = 302,
    kMixBlendMode = 303,
    kNavigation = 304,
    kNegative = 305,
    kObjectFit = 306,
    kObjectPosition = 307,
    kObjectViewBox = 308,
    kOffsetAnchor = 309,
    kOffsetDistance = 310,
    kOffsetPath = 311,
    kOffsetPosition = 312,
    kOffsetRotate = 313,
    kOpacity = 314,
    kOrder = 315,
    kOriginTrialTestProperty = 316,
    kOrphans = 317,
    kOutlineColor = 318,
    kOutlineOffset = 319,
    kOutlineStyle = 320,
    kOutlineWidth = 321,
    kOverflowAnchor = 322,
    kOverflowBlock = 323,
    kOverflowClipMargin = 324,
    kOverflowInline = 325,
    kOverflowWrap = 326,
    kOverflowX = 327,
    kOverflowY = 328,
    kOverlay = 329,
    kOverrideColors = 330,
    kOverscrollArea = 331,
    kOverscrollBehaviorBlock = 332,
    kOverscrollBehaviorInline = 333,
    kOverscrollBehaviorX = 334,
    kOverscrollBehaviorY = 335,
    kOverscrollPosition = 336,
    kPad = 337,
    kPaddingBlockEnd = 338,
    kPaddingBlockStart = 339,
    kPaddingBottom = 340,
    kPaddingInlineEnd = 341,
    kPaddingInlineStart = 342,
    kPaddingLeft = 343,
    kPaddingRight = 344,
    kPaddingTop = 345,
    kPage = 346,
    kPageOrientation = 347,
    kPaintOrder = 348,
    kPerspective = 349,
    kPerspectiveOrigin = 350,
    kPointerEvents = 351,
    kPositionTryFallbacks = 352,
    kPositionTryOrder = 353,
    kPositionVisibility = 354,
    kPrefix = 355,
    kPrintColorAdjust = 356,
    kQuotes = 357,
    kR = 358,
    kRange = 359,
    kReadingFlow = 360,
    kReadingOrder = 361,
    kResize = 362,
    kResult = 363,
    kRight = 364,
    kRotate = 365,
    kRowGap = 366,
    kRowRuleBreak = 367,
    kRowRuleColor = 368,
    kRowRuleOutset = 369,
    kRowRuleStyle = 370,
    kRowRuleVisibilityItems = 371,
    kRowRuleWidth = 372,
    kRubyAlign = 373,
    kRubyOverhang = 374,
    kRubyPosition = 375,
    kRx = 376,
    kRy = 377,
    kScale = 378,
    kScrollBehavior = 379,
    kScrollInitialTarget = 380,
    kScrollMarginBlockEnd = 381,
    kScrollMarginBlockStart = 382,
    kScrollMarginBottom = 383,
    kScrollMarginInlineEnd = 384,
    kScrollMarginInlineStart = 385,
    kScrollMarginLeft = 386,
    kScrollMarginRight = 387,
    kScrollMarginTop = 388,
    kScrollMarkerGroup = 389,
    kScrollPaddingBlockEnd = 390,
    kScrollPaddingBlockStart = 391,
    kScrollPaddingBottom = 392,
    kScrollPaddingInlineEnd = 393,
    kScrollPaddingInlineStart = 394,
    kScrollPaddingLeft = 395,
    kScrollPaddingRight = 396,
    kScrollPaddingTop = 397,
    kScrollSnapAlign = 398,
    kScrollSnapStop = 399,
    kScrollSnapType = 400,
    kScrollStartBlock = 401,
    kScrollStartInline = 402,
    kScrollStartX = 403,
    kScrollStartY = 404,
    kScrollTargetGroup = 405,
    kScrollTimelineAxis = 406,
    kScrollTimelineName = 407,
    kScrollbarColor = 408,
    kScrollbarGutter = 409,
    kScrollbarWidth = 410,
    kShapeImageThreshold = 411,
    kShapeMargin = 412,
    kShapeOutside = 413,
    kShapeRendering = 414,
    kSize = 415,
    kSizeAdjust = 416,
    kSpeak = 417,
    kSpeakAs = 418,
    kSrc = 419,
    kStopColor = 420,
    kStopOpacity = 421,
    kStroke = 422,
    kStrokeDasharray = 423,
    kStrokeDashoffset = 424,
    kStrokeLinecap = 425,
    kStrokeLinejoin = 426,
    kStrokeMiterlimit = 427,
    kStrokeOpacity = 428,
    kStrokeWidth = 429,
    kSuffix = 430,
    kSymbols = 431,
    kSyntax = 432,
    kSystem = 433,
    kTabSize = 434,
    kTableLayout = 435,
    kTextAlign = 436,
    kTextAlignLast = 437,
    kTextAnchor = 438,
    kTextAutospace = 439,
    kTextBoxEdge = 440,
    kTextBoxTrim = 441,
    kTextCombineUpright = 442,
    kTextDecorationColor = 443,
    kTextDecorationLine = 444,
    kTextDecorationSkipInk = 445,
    kTextDecorationStyle = 446,
    kTextDecorationThickness = 447,
    kTextEmphasisColor = 448,
    kTextEmphasisPosition = 449,
    kTextEmphasisStyle = 450,
    kTextGrow = 451,
    kTextIndent = 452,
    kTextJustify = 453,
    kTextOverflow = 454,
    kTextShadow = 455,
    kTextShrink = 456,
    kTextTransform = 457,
    kTextUnderlineOffset = 458,
    kTextUnderlinePosition = 459,
    kTextWrapMode = 460,
    kTextWrapStyle = 461,
    kTimelineScope = 462,
    kTimelineTriggerExitRangeEnd = 463,
    kTimelineTriggerExitRangeStart = 464,
    kTimelineTriggerName = 465,
    kTimelineTriggerRangeEnd = 466,
    kTimelineTriggerRangeStart = 467,
    kTimelineTriggerSource = 468,
    kTop = 469,
    kTouchAction = 470,
    kTransform = 471,
    kTransformBox = 472,
    kTransformOrigin = 473,
    kTransformStyle = 474,
    kTransitionBehavior = 475,
    kTransitionDelay = 476,
    kTransitionDuration = 477,
    kTransitionProperty = 478,
    kTransitionTimingFunction = 479,
    kTranslate = 480,
    kTypes = 481,
    kUnicodeBidi = 482,
    kUnicodeRange = 483,
    kUserSelect = 484,
    kVectorEffect = 485,
    kVerticalAlign = 486,
    kViewTimelineAxis = 487,
    kViewTimelineInset = 488,
    kViewTimelineName = 489,
    kViewTransitionClass = 490,
    kViewTransitionGroup = 491,
    kViewTransitionName = 492,
    kVisibility = 493,
    kWebkitBorderHorizontalSpacing = 494,
    kWebkitBorderImage = 495,
    kWebkitBorderVerticalSpacing = 496,
    kWebkitBoxAlign = 497,
    kWebkitBoxDecorationBreak = 498,
    kWebkitBoxDirection = 499,
    kWebkitBoxFlex = 500,
    kWebkitBoxOrdinalGroup = 501,
    kWebkitBoxOrient = 502,
    kWebkitBoxPack = 503,
    kWebkitBoxReflect = 504,
    kWebkitLineBreak = 505,
    kWebkitLineClamp = 506,
    kWebkitMaskBoxImageOutset = 507,
    kWebkitMaskBoxImageRepeat = 508,
    kWebkitMaskBoxImageSlice = 509,
    kWebkitMaskBoxImageSource = 510,
    kWebkitMaskBoxImageWidth = 511,
    kWebkitMaskPositionX = 512,
    kWebkitMaskPositionY = 513,
    kWebkitPerspectiveOriginX = 514,
    kWebkitPerspectiveOriginY = 515,
    kWebkitRtlOrdering = 516,
    kWebkitRubyPosition = 517,
    kWebkitTapHighlightColor = 518,
    kWebkitTextCombine = 519,
    kWebkitTextDecorationsInEffect = 520,
    kWebkitTextFillColor = 521,
    kWebkitTextSecurity = 522,
    kWebkitTextStrokeColor = 523,
    kWebkitTextStrokeWidth = 524,
    kWebkitTransformOriginX = 525,
    kWebkitTransformOriginY = 526,
    kWebkitTransformOriginZ = 527,
    kWebkitUserDrag = 528,
    kWebkitUserModify = 529,
    kWhiteSpaceCollapse = 530,
    kWidows = 531,
    kWidth = 532,
    kWillChange = 533,
    kWordBreak = 534,
    kWordSpacing = 535,
    kX = 536,
    kY = 537,
    kZIndex = 538,
    kAlternativeWebkitLineClamp = 539,
    kAnimation = 540,
    kAnimationRange = 541,
    kBackground = 542,
    kBackgroundPosition = 543,
    kBorder = 544,
    kBorderBlock = 545,
    kBorderBlockColor = 546,
    kBorderBlockEnd = 547,
    kBorderBlockStart = 548,
    kBorderBlockStyle = 549,
    kBorderBlockWidth = 550,
    kBorderBottom = 551,
    kBorderColor = 552,
    kBorderImage = 553,
    kBorderInline = 554,
    kBorderInlineColor = 555,
    kBorderInlineEnd = 556,
    kBorderInlineStart = 557,
    kBorderInlineStyle = 558,
    kBorderInlineWidth = 559,
    kBorderLeft = 560,
    kBorderRadius = 561,
    kBorderRight = 562,
    kBorderSpacing = 563,
    kBorderStyle = 564,
    kBorderTop = 565,
    kBorderWidth = 566,
    kColumnRule = 567,
    kColumns = 568,
    kContainIntrinsicSize = 569,
    kContainer = 570,
    kCornerBlockEndShape = 571,
    kCornerBlockStartShape = 572,
    kCornerBottomShape = 573,
    kCornerInlineEndShape = 574,
    kCornerInlineStartShape = 575,
    kCornerLeftShape = 576,
    kCornerRightShape = 577,
    kCornerShape = 578,
    kCornerTopShape = 579,
    kCorners = 580,
    kFlex = 581,
    kFlexFlow = 582,
    kFont = 583,
    kFontSynthesis = 584,
    kFontVariant = 585,
    kGap = 586,
    kGrid = 587,
    kGridArea = 588,
    kGridColumn = 589,
    kGridRow = 590,
    kGridTemplate = 591,
    kInset = 592,
    kInsetBlock = 593,
    kInsetInline = 594,
    kInterestDelay = 595,
    kLineClamp = 596,
    kListStyle = 597,
    kMargin = 598,
    kMarginBlock = 599,
    kMarginInline = 600,
    kMarker = 601,
    kMask = 602,
    kMaskPosition = 603,
    kMasonry = 604,
    kMasonryFlow = 605,
    kOffset = 606,
    kOutline = 607,
    kOverflow = 608,
    kOverscrollBehavior = 609,
    kPadding = 610,
    kPaddingBlock = 611,
    kPaddingInline = 612,
    kPageBreakAfter = 613,
    kPageBreakBefore = 614,
    kPageBreakInside = 615,
    kPlaceContent = 616,
    kPlaceItems = 617,
    kPlaceSelf = 618,
    kPositionTry = 619,
    kRowRule = 620,
    kRule = 621,
    kRuleBreak = 622,
    kRuleColor = 623,
    kRuleOutset = 624,
    kRuleStyle = 625,
    kRuleWidth = 626,
    kScrollMargin = 627,
    kScrollMarginBlock = 628,
    kScrollMarginInline = 629,
    kScrollPadding = 630,
    kScrollPaddingBlock = 631,
    kScrollPaddingInline = 632,
    kScrollStart = 633,
    kScrollTimeline = 634,
    kTextBox = 635,
    kTextDecoration = 636,
    kTextEmphasis = 637,
    kTextSpacing = 638,
    kTextWrap = 639,
    kTimelineTrigger = 640,
    kTransition = 641,
    kViewTimeline = 642,
    kWebkitColumnBreakAfter = 643,
    kWebkitColumnBreakBefore = 644,
    kWebkitColumnBreakInside = 645,
    kWebkitMaskBoxImage = 646,
    kWebkitTextStroke = 647,
    kWhiteSpace = 648,
    kAliasWebkitAppearance = 649,
    kAliasWebkitAppRegion = 650,
    kAliasWebkitMaskClip = 651,
    kAliasWebkitMaskComposite = 652,
    kAliasWebkitMaskImage = 653,
    kAliasWebkitMaskOrigin = 654,
    kAliasWebkitMaskRepeat = 655,
    kAliasWebkitMaskSize = 656,
    kAliasWebkitBorderEndColor = 657,
    kAliasWebkitBorderEndStyle = 658,
    kAliasWebkitBorderEndWidth = 659,
    kAliasWebkitBorderStartColor = 660,
    kAliasWebkitBorderStartStyle = 661,
    kAliasWebkitBorderStartWidth = 662,
    kAliasWebkitBorderBeforeColor = 663,
    kAliasWebkitBorderBeforeStyle = 664,
    kAliasWebkitBorderBeforeWidth = 665,
    kAliasWebkitBorderAfterColor = 666,
    kAliasWebkitBorderAfterStyle = 667,
    kAliasWebkitBorderAfterWidth = 668,
    kAliasWebkitMarginEnd = 669,
    kAliasWebkitMarginStart = 670,
    kAliasWebkitMarginBefore = 671,
    kAliasWebkitMarginAfter = 672,
    kAliasWebkitPaddingEnd = 673,
    kAliasWebkitPaddingStart = 674,
    kAliasWebkitPaddingBefore = 675,
    kAliasWebkitPaddingAfter = 676,
    kAliasWebkitLogicalWidth = 677,
    kAliasWebkitLogicalHeight = 678,
    kAliasWebkitMinLogicalWidth = 679,
    kAliasWebkitMinLogicalHeight = 680,
    kAliasWebkitMaxLogicalWidth = 681,
    kAliasWebkitMaxLogicalHeight = 682,
    kAliasWebkitPrintColorAdjust = 683,
    kAliasWebkitBorderAfter = 684,
    kAliasWebkitBorderBefore = 685,
    kAliasWebkitBorderEnd = 686,
    kAliasWebkitBorderStart = 687,
    kAliasWebkitMask = 688,
    kAliasWebkitMaskPosition = 689,
    kAliasEpubCaptionSide = 690,
    kAliasEpubTextCombine = 691,
    kAliasEpubTextEmphasis = 692,
    kAliasEpubTextEmphasisColor = 693,
    kAliasEpubTextEmphasisStyle = 694,
    kAliasEpubTextOrientation = 695,
    kAliasEpubTextTransform = 696,
    kAliasEpubWordBreak = 697,
    kAliasEpubWritingMode = 698,
    kAliasWebkitAlignContent = 699,
    kAliasWebkitAlignItems = 700,
    kAliasWebkitAlignSelf = 701,
    kAliasWebkitAnimation = 702,
    kAliasWebkitAnimationDelay = 703,
    kAliasWebkitAnimationDirection = 704,
    kAliasWebkitAnimationDuration = 705,
    kAliasWebkitAnimationFillMode = 706,
    kAliasWebkitAnimationIterationCount = 707,
    kAliasWebkitAnimationName = 708,
    kAliasWebkitAnimationPlayState = 709,
    kAliasWebkitAnimationTimingFunction = 710,
    kAliasWebkitBackfaceVisibility = 711,
    kAliasWebkitBackgroundClip = 712,
    kAliasWebkitBackgroundOrigin = 713,
    kAliasWebkitBackgroundSize = 714,
    kAliasWebkitBorderBottomLeftRadius = 715,
    kAliasWebkitBorderBottomRightRadius = 716,
    kAliasWebkitBorderRadius = 717,
    kAliasWebkitBorderTopLeftRadius = 718,
    kAliasWebkitBorderTopRightRadius = 719,
    kAliasWebkitBoxShadow = 720,
    kAliasWebkitBoxSizing = 721,
    kAliasWebkitClipPath = 722,
    kAliasWebkitColumnCount = 723,
    kAliasWebkitColumnGap = 724,
    kAliasWebkitColumnRule = 725,
    kAliasWebkitColumnRuleColor = 726,
    kAliasWebkitColumnRuleStyle = 727,
    kAliasWebkitColumnRuleWidth = 728,
    kAliasWebkitColumnSpan = 729,
    kAliasWebkitColumnWidth = 730,
    kAliasWebkitColumns = 731,
    kAliasWebkitFilter = 732,
    kAliasWebkitFlex = 733,
    kAliasWebkitFlexBasis = 734,
    kAliasWebkitFlexDirection = 735,
    kAliasWebkitFlexFlow = 736,
    kAliasWebkitFlexGrow = 737,
    kAliasWebkitFlexShrink = 738,
    kAliasWebkitFlexWrap = 739,
    kAliasWebkitFontFeatureSettings = 740,
    kAliasWebkitHyphenateCharacter = 741,
    kAliasWebkitJustifyContent = 742,
    kAliasWebkitOpacity = 743,
    kAliasWebkitOrder = 744,
    kAliasWebkitPerspective = 745,
    kAliasWebkitPerspectiveOrigin = 746,
    kAliasWebkitShapeImageThreshold = 747,
    kAliasWebkitShapeMargin = 748,
    kAliasWebkitShapeOutside = 749,
    kAliasWebkitTextEmphasis = 750,
    kAliasWebkitTextEmphasisColor = 751,
    kAliasWebkitTextEmphasisPosition = 752,
    kAliasWebkitTextEmphasisStyle = 753,
    kAliasWebkitTextSizeAdjust = 754,
    kAliasWebkitTransform = 755,
    kAliasWebkitTransformOrigin = 756,
    kAliasWebkitTransformStyle = 757,
    kAliasWebkitTransition = 758,
    kAliasWebkitTransitionDelay = 759,
    kAliasWebkitTransitionDuration = 760,
    kAliasWebkitTransitionProperty = 761,
    kAliasWebkitTransitionTimingFunction = 762,
    kAliasWebkitUserSelect = 763,
    kAliasWordWrap = 764,
    kAliasGridColumnGap = 765,
    kAliasGridRowGap = 766,
    kAliasGridGap = 767,
};

const CSSPropertyID kCSSPropertyAliasList[] = {
    CSSPropertyID::kAliasWebkitAppearance,
    CSSPropertyID::kAliasWebkitAppRegion,
    CSSPropertyID::kAliasWebkitMaskClip,
    CSSPropertyID::kAliasWebkitMaskComposite,
    CSSPropertyID::kAliasWebkitMaskImage,
    CSSPropertyID::kAliasWebkitMaskOrigin,
    CSSPropertyID::kAliasWebkitMaskRepeat,
    CSSPropertyID::kAliasWebkitMaskSize,
    CSSPropertyID::kAliasWebkitBorderEndColor,
    CSSPropertyID::kAliasWebkitBorderEndStyle,
    CSSPropertyID::kAliasWebkitBorderEndWidth,
    CSSPropertyID::kAliasWebkitBorderStartColor,
    CSSPropertyID::kAliasWebkitBorderStartStyle,
    CSSPropertyID::kAliasWebkitBorderStartWidth,
    CSSPropertyID::kAliasWebkitBorderBeforeColor,
    CSSPropertyID::kAliasWebkitBorderBeforeStyle,
    CSSPropertyID::kAliasWebkitBorderBeforeWidth,
    CSSPropertyID::kAliasWebkitBorderAfterColor,
    CSSPropertyID::kAliasWebkitBorderAfterStyle,
    CSSPropertyID::kAliasWebkitBorderAfterWidth,
    CSSPropertyID::kAliasWebkitMarginEnd,
    CSSPropertyID::kAliasWebkitMarginStart,
    CSSPropertyID::kAliasWebkitMarginBefore,
    CSSPropertyID::kAliasWebkitMarginAfter,
    CSSPropertyID::kAliasWebkitPaddingEnd,
    CSSPropertyID::kAliasWebkitPaddingStart,
    CSSPropertyID::kAliasWebkitPaddingBefore,
    CSSPropertyID::kAliasWebkitPaddingAfter,
    CSSPropertyID::kAliasWebkitLogicalWidth,
    CSSPropertyID::kAliasWebkitLogicalHeight,
    CSSPropertyID::kAliasWebkitMinLogicalWidth,
    CSSPropertyID::kAliasWebkitMinLogicalHeight,
    CSSPropertyID::kAliasWebkitMaxLogicalWidth,
    CSSPropertyID::kAliasWebkitMaxLogicalHeight,
    CSSPropertyID::kAliasWebkitPrintColorAdjust,
    CSSPropertyID::kAliasWebkitBorderAfter,
    CSSPropertyID::kAliasWebkitBorderBefore,
    CSSPropertyID::kAliasWebkitBorderEnd,
    CSSPropertyID::kAliasWebkitBorderStart,
    CSSPropertyID::kAliasWebkitMask,
    CSSPropertyID::kAliasWebkitMaskPosition,
    CSSPropertyID::kAliasEpubCaptionSide,
    CSSPropertyID::kAliasEpubTextCombine,
    CSSPropertyID::kAliasEpubTextEmphasis,
    CSSPropertyID::kAliasEpubTextEmphasisColor,
    CSSPropertyID::kAliasEpubTextEmphasisStyle,
    CSSPropertyID::kAliasEpubTextOrientation,
    CSSPropertyID::kAliasEpubTextTransform,
    CSSPropertyID::kAliasEpubWordBreak,
    CSSPropertyID::kAliasEpubWritingMode,
    CSSPropertyID::kAliasWebkitAlignContent,
    CSSPropertyID::kAliasWebkitAlignItems,
    CSSPropertyID::kAliasWebkitAlignSelf,
    CSSPropertyID::kAliasWebkitAnimation,
    CSSPropertyID::kAliasWebkitAnimationDelay,
    CSSPropertyID::kAliasWebkitAnimationDirection,
    CSSPropertyID::kAliasWebkitAnimationDuration,
    CSSPropertyID::kAliasWebkitAnimationFillMode,
    CSSPropertyID::kAliasWebkitAnimationIterationCount,
    CSSPropertyID::kAliasWebkitAnimationName,
    CSSPropertyID::kAliasWebkitAnimationPlayState,
    CSSPropertyID::kAliasWebkitAnimationTimingFunction,
    CSSPropertyID::kAliasWebkitBackfaceVisibility,
    CSSPropertyID::kAliasWebkitBackgroundClip,
    CSSPropertyID::kAliasWebkitBackgroundOrigin,
    CSSPropertyID::kAliasWebkitBackgroundSize,
    CSSPropertyID::kAliasWebkitBorderBottomLeftRadius,
    CSSPropertyID::kAliasWebkitBorderBottomRightRadius,
    CSSPropertyID::kAliasWebkitBorderRadius,
    CSSPropertyID::kAliasWebkitBorderTopLeftRadius,
    CSSPropertyID::kAliasWebkitBorderTopRightRadius,
    CSSPropertyID::kAliasWebkitBoxShadow,
    CSSPropertyID::kAliasWebkitBoxSizing,
    CSSPropertyID::kAliasWebkitClipPath,
    CSSPropertyID::kAliasWebkitColumnCount,
    CSSPropertyID::kAliasWebkitColumnGap,
    CSSPropertyID::kAliasWebkitColumnRule,
    CSSPropertyID::kAliasWebkitColumnRuleColor,
    CSSPropertyID::kAliasWebkitColumnRuleStyle,
    CSSPropertyID::kAliasWebkitColumnRuleWidth,
    CSSPropertyID::kAliasWebkitColumnSpan,
    CSSPropertyID::kAliasWebkitColumnWidth,
    CSSPropertyID::kAliasWebkitColumns,
    CSSPropertyID::kAliasWebkitFilter,
    CSSPropertyID::kAliasWebkitFlex,
    CSSPropertyID::kAliasWebkitFlexBasis,
    CSSPropertyID::kAliasWebkitFlexDirection,
    CSSPropertyID::kAliasWebkitFlexFlow,
    CSSPropertyID::kAliasWebkitFlexGrow,
    CSSPropertyID::kAliasWebkitFlexShrink,
    CSSPropertyID::kAliasWebkitFlexWrap,
    CSSPropertyID::kAliasWebkitFontFeatureSettings,
    CSSPropertyID::kAliasWebkitHyphenateCharacter,
    CSSPropertyID::kAliasWebkitJustifyContent,
    CSSPropertyID::kAliasWebkitOpacity,
    CSSPropertyID::kAliasWebkitOrder,
    CSSPropertyID::kAliasWebkitPerspective,
    CSSPropertyID::kAliasWebkitPerspectiveOrigin,
    CSSPropertyID::kAliasWebkitShapeImageThreshold,
    CSSPropertyID::kAliasWebkitShapeMargin,
    CSSPropertyID::kAliasWebkitShapeOutside,
    CSSPropertyID::kAliasWebkitTextEmphasis,
    CSSPropertyID::kAliasWebkitTextEmphasisColor,
    CSSPropertyID::kAliasWebkitTextEmphasisPosition,
    CSSPropertyID::kAliasWebkitTextEmphasisStyle,
    CSSPropertyID::kAliasWebkitTextSizeAdjust,
    CSSPropertyID::kAliasWebkitTransform,
    CSSPropertyID::kAliasWebkitTransformOrigin,
    CSSPropertyID::kAliasWebkitTransformStyle,
    CSSPropertyID::kAliasWebkitTransition,
    CSSPropertyID::kAliasWebkitTransitionDelay,
    CSSPropertyID::kAliasWebkitTransitionDuration,
    CSSPropertyID::kAliasWebkitTransitionProperty,
    CSSPropertyID::kAliasWebkitTransitionTimingFunction,
    CSSPropertyID::kAliasWebkitUserSelect,
    CSSPropertyID::kAliasWordWrap,
    CSSPropertyID::kAliasGridColumnGap,
    CSSPropertyID::kAliasGridRowGap,
    CSSPropertyID::kAliasGridGap,
};

const CSSPropertyID kCSSComputableProperties[] = {
    CSSPropertyID::kAccentColor,
    CSSPropertyID::kAlignContent,
    CSSPropertyID::kAlignItems,
    CSSPropertyID::kAlignSelf,
    CSSPropertyID::kAlignmentBaseline,
    CSSPropertyID::kAnchorName,
    CSSPropertyID::kAnchorScope,
    CSSPropertyID::kAnimationComposition,
    CSSPropertyID::kAnimationDelay,
    CSSPropertyID::kAnimationDirection,
    CSSPropertyID::kAnimationDuration,
    CSSPropertyID::kAnimationFillMode,
    CSSPropertyID::kAnimationIterationCount,
    CSSPropertyID::kAnimationName,
    CSSPropertyID::kAnimationPlayState,
    CSSPropertyID::kAnimationRangeEnd,
    CSSPropertyID::kAnimationRangeStart,
    CSSPropertyID::kAnimationTimeline,
    CSSPropertyID::kAnimationTimingFunction,
    CSSPropertyID::kAnimationTrigger,
    CSSPropertyID::kAppRegion,
    CSSPropertyID::kAppearance,
    CSSPropertyID::kBackdropFilter,
    CSSPropertyID::kBackfaceVisibility,
    CSSPropertyID::kBackgroundAttachment,
    CSSPropertyID::kBackgroundBlendMode,
    CSSPropertyID::kBackgroundClip,
    CSSPropertyID::kBackgroundColor,
    CSSPropertyID::kBackgroundImage,
    CSSPropertyID::kBackgroundOrigin,
    CSSPropertyID::kBackgroundPosition,
    CSSPropertyID::kBackgroundRepeat,
    CSSPropertyID::kBackgroundSize,
    CSSPropertyID::kBaselineShift,
    CSSPropertyID::kBaselineSource,
    CSSPropertyID::kBlockEllipsis,
    CSSPropertyID::kBlockSize,
    CSSPropertyID::kBorderBlockEndColor,
    CSSPropertyID::kBorderBlockEndStyle,
    CSSPropertyID::kBorderBlockEndWidth,
    CSSPropertyID::kBorderBlockStartColor,
    CSSPropertyID::kBorderBlockStartStyle,
    CSSPropertyID::kBorderBlockStartWidth,
    CSSPropertyID::kBorderBottomColor,
    CSSPropertyID::kBorderBottomLeftRadius,
    CSSPropertyID::kBorderBottomRightRadius,
    CSSPropertyID::kBorderBottomStyle,
    CSSPropertyID::kBorderBottomWidth,
    CSSPropertyID::kBorderCollapse,
    CSSPropertyID::kBorderEndEndRadius,
    CSSPropertyID::kBorderEndStartRadius,
    CSSPropertyID::kBorderImageOutset,
    CSSPropertyID::kBorderImageRepeat,
    CSSPropertyID::kBorderImageSlice,
    CSSPropertyID::kBorderImageSource,
    CSSPropertyID::kBorderImageWidth,
    CSSPropertyID::kBorderInlineEndColor,
    CSSPropertyID::kBorderInlineEndStyle,
    CSSPropertyID::kBorderInlineEndWidth,
    CSSPropertyID::kBorderInlineStartColor,
    CSSPropertyID::kBorderInlineStartStyle,
    CSSPropertyID::kBorderInlineStartWidth,
    CSSPropertyID::kBorderLeftColor,
    CSSPropertyID::kBorderLeftStyle,
    CSSPropertyID::kBorderLeftWidth,
    CSSPropertyID::kBorderRightColor,
    CSSPropertyID::kBorderRightStyle,
    CSSPropertyID::kBorderRightWidth,
    CSSPropertyID::kBorderShape,
    CSSPropertyID::kBorderStartEndRadius,
    CSSPropertyID::kBorderStartStartRadius,
    CSSPropertyID::kBorderTopColor,
    CSSPropertyID::kBorderTopLeftRadius,
    CSSPropertyID::kBorderTopRightRadius,
    CSSPropertyID::kBorderTopStyle,
    CSSPropertyID::kBorderTopWidth,
    CSSPropertyID::kBottom,
    CSSPropertyID::kBoxDecorationBreak,
    CSSPropertyID::kBoxShadow,
    CSSPropertyID::kBoxSizing,
    CSSPropertyID::kBreakAfter,
    CSSPropertyID::kBreakBefore,
    CSSPropertyID::kBreakInside,
    CSSPropertyID::kBufferedRendering,
    CSSPropertyID::kCaptionSide,
    CSSPropertyID::kCaretAnimation,
    CSSPropertyID::kCaretColor,
    CSSPropertyID::kCaretShape,
    CSSPropertyID::kClear,
    CSSPropertyID::kClip,
    CSSPropertyID::kClipPath,
    CSSPropertyID::kClipRule,
    CSSPropertyID::kColor,
    CSSPropertyID::kColorInterpolation,
    CSSPropertyID::kColorInterpolationFilters,
    CSSPropertyID::kColorRendering,
    CSSPropertyID::kColumnCount,
    CSSPropertyID::kColumnGap,
    CSSPropertyID::kColumnHeight,
    CSSPropertyID::kColumnRuleBreak,
    CSSPropertyID::kColumnRuleColor,
    CSSPropertyID::kColumnRuleOutset,
    CSSPropertyID::kColumnRuleStyle,
    CSSPropertyID::kColumnRuleVisibilityItems,
    CSSPropertyID::kColumnRuleWidth,
    CSSPropertyID::kColumnSpan,
    CSSPropertyID::kColumnWidth,
    CSSPropertyID::kColumnWrap,
    CSSPropertyID::kContainIntrinsicBlockSize,
    CSSPropertyID::kContainIntrinsicHeight,
    CSSPropertyID::kContainIntrinsicInlineSize,
    CSSPropertyID::kContainIntrinsicSize,
    CSSPropertyID::kContainIntrinsicWidth,
    CSSPropertyID::kContainerName,
    CSSPropertyID::kContainerType,
    CSSPropertyID::kContent,
    CSSPropertyID::kContinue,
    CSSPropertyID::kCornerBottomLeftShape,
    CSSPropertyID::kCornerBottomRightShape,
    CSSPropertyID::kCornerEndEndShape,
    CSSPropertyID::kCornerEndStartShape,
    CSSPropertyID::kCornerStartEndShape,
    CSSPropertyID::kCornerStartStartShape,
    CSSPropertyID::kCornerTopLeftShape,
    CSSPropertyID::kCornerTopRightShape,
    CSSPropertyID::kCursor,
    CSSPropertyID::kCx,
    CSSPropertyID::kCy,
    CSSPropertyID::kD,
    CSSPropertyID::kDirection,
    CSSPropertyID::kDisplay,
    CSSPropertyID::kDominantBaseline,
    CSSPropertyID::kDynamicRangeLimit,
    CSSPropertyID::kEmptyCells,
    CSSPropertyID::kFieldSizing,
    CSSPropertyID::kFill,
    CSSPropertyID::kFillOpacity,
    CSSPropertyID::kFillRule,
    CSSPropertyID::kFilter,
    CSSPropertyID::kFlexBasis,
    CSSPropertyID::kFlexDirection,
    CSSPropertyID::kFlexGrow,
    CSSPropertyID::kFlexShrink,
    CSSPropertyID::kFlexWrap,
    CSSPropertyID::kFloat,
    CSSPropertyID::kFloodColor,
    CSSPropertyID::kFloodOpacity,
    CSSPropertyID::kFontFamily,
    CSSPropertyID::kFontKerning,
    CSSPropertyID::kFontLanguageOverride,
    CSSPropertyID::kFontOpticalSizing,
    CSSPropertyID::kFontPalette,
    CSSPropertyID::kFontSize,
    CSSPropertyID::kFontSizeAdjust,
    CSSPropertyID::kFontStretch,
    CSSPropertyID::kFontStyle,
    CSSPropertyID::kFontSynthesisSmallCaps,
    CSSPropertyID::kFontSynthesisStyle,
    CSSPropertyID::kFontSynthesisWeight,
    CSSPropertyID::kFontVariant,
    CSSPropertyID::kFontVariantAlternates,
    CSSPropertyID::kFontVariantCaps,
    CSSPropertyID::kFontVariantEastAsian,
    CSSPropertyID::kFontVariantEmoji,
    CSSPropertyID::kFontVariantLigatures,
    CSSPropertyID::kFontVariantNumeric,
    CSSPropertyID::kFontVariantPosition,
    CSSPropertyID::kFontWeight,
    CSSPropertyID::kGapRuleOverlap,
    CSSPropertyID::kGridAutoColumns,
    CSSPropertyID::kGridAutoFlow,
    CSSPropertyID::kGridAutoRows,
    CSSPropertyID::kGridColumnEnd,
    CSSPropertyID::kGridColumnStart,
    CSSPropertyID::kGridRowEnd,
    CSSPropertyID::kGridRowStart,
    CSSPropertyID::kGridTemplateAreas,
    CSSPropertyID::kGridTemplateColumns,
    CSSPropertyID::kGridTemplateRows,
    CSSPropertyID::kHeight,
    CSSPropertyID::kHyphenateCharacter,
    CSSPropertyID::kHyphenateLimitChars,
    CSSPropertyID::kHyphens,
    CSSPropertyID::kImageOrientation,
    CSSPropertyID::kImageRendering,
    CSSPropertyID::kInitialLetter,
    CSSPropertyID::kInlineSize,
    CSSPropertyID::kInsetBlockEnd,
    CSSPropertyID::kInsetBlockStart,
    CSSPropertyID::kInsetInlineEnd,
    CSSPropertyID::kInsetInlineStart,
    CSSPropertyID::kInteractivity,
    CSSPropertyID::kInterestDelayEnd,
    CSSPropertyID::kInterestDelayStart,
    CSSPropertyID::kInterpolateSize,
    CSSPropertyID::kIsolation,
    CSSPropertyID::kItemTolerance,
    CSSPropertyID::kJustifyContent,
    CSSPropertyID::kJustifyItems,
    CSSPropertyID::kJustifySelf,
    CSSPropertyID::kLeft,
    CSSPropertyID::kLetterSpacing,
    CSSPropertyID::kLightingColor,
    CSSPropertyID::kLineBreak,
    CSSPropertyID::kLineHeight,
    CSSPropertyID::kListStyleImage,
    CSSPropertyID::kListStylePosition,
    CSSPropertyID::kListStyleType,
    CSSPropertyID::kMarginBlockEnd,
    CSSPropertyID::kMarginBlockStart,
    CSSPropertyID::kMarginBottom,
    CSSPropertyID::kMarginInlineEnd,
    CSSPropertyID::kMarginInlineStart,
    CSSPropertyID::kMarginLeft,
    CSSPropertyID::kMarginRight,
    CSSPropertyID::kMarginTop,
    CSSPropertyID::kMarkerEnd,
    CSSPropertyID::kMarkerMid,
    CSSPropertyID::kMarkerStart,
    CSSPropertyID::kMaskClip,
    CSSPropertyID::kMaskComposite,
    CSSPropertyID::kMaskImage,
    CSSPropertyID::kMaskMode,
    CSSPropertyID::kMaskOrigin,
    CSSPropertyID::kMaskPosition,
    CSSPropertyID::kMaskRepeat,
    CSSPropertyID::kMaskSize,
    CSSPropertyID::kMaskType,
    CSSPropertyID::kMasonryDirection,
    CSSPropertyID::kMasonryFill,
    CSSPropertyID::kMathDepth,
    CSSPropertyID::kMathShift,
    CSSPropertyID::kMathStyle,
    CSSPropertyID::kMaxBlockSize,
    CSSPropertyID::kMaxHeight,
    CSSPropertyID::kMaxInlineSize,
    CSSPropertyID::kMaxLines,
    CSSPropertyID::kMaxWidth,
    CSSPropertyID::kMinBlockSize,
    CSSPropertyID::kMinHeight,
    CSSPropertyID::kMinInlineSize,
    CSSPropertyID::kMinWidth,
    CSSPropertyID::kMixBlendMode,
    CSSPropertyID::kObjectFit,
    CSSPropertyID::kObjectPosition,
    CSSPropertyID::kObjectViewBox,
    CSSPropertyID::kOffsetAnchor,
    CSSPropertyID::kOffsetDistance,
    CSSPropertyID::kOffsetPath,
    CSSPropertyID::kOffsetPosition,
    CSSPropertyID::kOffsetRotate,
    CSSPropertyID::kOpacity,
    CSSPropertyID::kOrder,
    CSSPropertyID::kOrphans,
    CSSPropertyID::kOutlineColor,
    CSSPropertyID::kOutlineOffset,
    CSSPropertyID::kOutlineStyle,
    CSSPropertyID::kOutlineWidth,
    CSSPropertyID::kOverflowAnchor,
    CSSPropertyID::kOverflowBlock,
    CSSPropertyID::kOverflowClipMargin,
    CSSPropertyID::kOverflowInline,
    CSSPropertyID::kOverflowWrap,
    CSSPropertyID::kOverflowX,
    CSSPropertyID::kOverflowY,
    CSSPropertyID::kOverlay,
    CSSPropertyID::kOverscrollArea,
    CSSPropertyID::kOverscrollBehaviorBlock,
    CSSPropertyID::kOverscrollBehaviorInline,
    CSSPropertyID::kOverscrollPosition,
    CSSPropertyID::kPaddingBlockEnd,
    CSSPropertyID::kPaddingBlockStart,
    CSSPropertyID::kPaddingBottom,
    CSSPropertyID::kPaddingInlineEnd,
    CSSPropertyID::kPaddingInlineStart,
    CSSPropertyID::kPaddingLeft,
    CSSPropertyID::kPaddingRight,
    CSSPropertyID::kPaddingTop,
    CSSPropertyID::kPaintOrder,
    CSSPropertyID::kPerspective,
    CSSPropertyID::kPerspectiveOrigin,
    CSSPropertyID::kPointerEvents,
    CSSPropertyID::kPosition,
    CSSPropertyID::kPositionAnchor,
    CSSPropertyID::kPositionArea,
    CSSPropertyID::kPositionTryFallbacks,
    CSSPropertyID::kPositionTryOrder,
    CSSPropertyID::kPositionVisibility,
    CSSPropertyID::kPrintColorAdjust,
    CSSPropertyID::kR,
    CSSPropertyID::kReadingFlow,
    CSSPropertyID::kReadingOrder,
    CSSPropertyID::kResize,
    CSSPropertyID::kRight,
    CSSPropertyID::kRotate,
    CSSPropertyID::kRowGap,
    CSSPropertyID::kRowRuleBreak,
    CSSPropertyID::kRowRuleColor,
    CSSPropertyID::kRowRuleOutset,
    CSSPropertyID::kRowRuleStyle,
    CSSPropertyID::kRowRuleVisibilityItems,
    CSSPropertyID::kRowRuleWidth,
    CSSPropertyID::kRubyAlign,
    CSSPropertyID::kRubyOverhang,
    CSSPropertyID::kRubyPosition,
    CSSPropertyID::kRx,
    CSSPropertyID::kRy,
    CSSPropertyID::kScale,
    CSSPropertyID::kScrollBehavior,
    CSSPropertyID::kScrollInitialTarget,
    CSSPropertyID::kScrollMarginBlockEnd,
    CSSPropertyID::kScrollMarginBlockStart,
    CSSPropertyID::kScrollMarginInlineEnd,
    CSSPropertyID::kScrollMarginInlineStart,
    CSSPropertyID::kScrollMarkerGroup,
    CSSPropertyID::kScrollPaddingBlockEnd,
    CSSPropertyID::kScrollPaddingBlockStart,
    CSSPropertyID::kScrollPaddingInlineEnd,
    CSSPropertyID::kScrollPaddingInlineStart,
    CSSPropertyID::kScrollStartBlock,
    CSSPropertyID::kScrollStartInline,
    CSSPropertyID::kScrollStartX,
    CSSPropertyID::kScrollStartY,
    CSSPropertyID::kScrollTargetGroup,
    CSSPropertyID::kScrollTimelineAxis,
    CSSPropertyID::kScrollTimelineName,
    CSSPropertyID::kScrollbarColor,
    CSSPropertyID::kScrollbarGutter,
    CSSPropertyID::kScrollbarWidth,
    CSSPropertyID::kShapeImageThreshold,
    CSSPropertyID::kShapeMargin,
    CSSPropertyID::kShapeOutside,
    CSSPropertyID::kShapeRendering,
    CSSPropertyID::kSpeak,
    CSSPropertyID::kStopColor,
    CSSPropertyID::kStopOpacity,
    CSSPropertyID::kStroke,
    CSSPropertyID::kStrokeDasharray,
    CSSPropertyID::kStrokeDashoffset,
    CSSPropertyID::kStrokeLinecap,
    CSSPropertyID::kStrokeLinejoin,
    CSSPropertyID::kStrokeMiterlimit,
    CSSPropertyID::kStrokeOpacity,
    CSSPropertyID::kStrokeWidth,
    CSSPropertyID::kTabSize,
    CSSPropertyID::kTableLayout,
    CSSPropertyID::kTextAlign,
    CSSPropertyID::kTextAlignLast,
    CSSPropertyID::kTextAnchor,
    CSSPropertyID::kTextAutospace,
    CSSPropertyID::kTextBoxEdge,
    CSSPropertyID::kTextBoxTrim,
    CSSPropertyID::kTextDecoration,
    CSSPropertyID::kTextDecorationColor,
    CSSPropertyID::kTextDecorationLine,
    CSSPropertyID::kTextDecorationSkipInk,
    CSSPropertyID::kTextDecorationStyle,
    CSSPropertyID::kTextEmphasisColor,
    CSSPropertyID::kTextEmphasisPosition,
    CSSPropertyID::kTextEmphasisStyle,
    CSSPropertyID::kTextGrow,
    CSSPropertyID::kTextIndent,
    CSSPropertyID::kTextJustify,
    CSSPropertyID::kTextOverflow,
    CSSPropertyID::kTextRendering,
    CSSPropertyID::kTextShadow,
    CSSPropertyID::kTextShrink,
    CSSPropertyID::kTextSizeAdjust,
    CSSPropertyID::kTextSpacingTrim,
    CSSPropertyID::kTextTransform,
    CSSPropertyID::kTextUnderlinePosition,
    CSSPropertyID::kTextWrapMode,
    CSSPropertyID::kTextWrapStyle,
    CSSPropertyID::kTimelineScope,
    CSSPropertyID::kTimelineTriggerExitRangeEnd,
    CSSPropertyID::kTimelineTriggerExitRangeStart,
    CSSPropertyID::kTimelineTriggerName,
    CSSPropertyID::kTimelineTriggerRangeEnd,
    CSSPropertyID::kTimelineTriggerRangeStart,
    CSSPropertyID::kTimelineTriggerSource,
    CSSPropertyID::kTop,
    CSSPropertyID::kTouchAction,
    CSSPropertyID::kTransform,
    CSSPropertyID::kTransformOrigin,
    CSSPropertyID::kTransformStyle,
    CSSPropertyID::kTransitionBehavior,
    CSSPropertyID::kTransitionDelay,
    CSSPropertyID::kTransitionDuration,
    CSSPropertyID::kTransitionProperty,
    CSSPropertyID::kTransitionTimingFunction,
    CSSPropertyID::kTranslate,
    CSSPropertyID::kUnicodeBidi,
    CSSPropertyID::kUserSelect,
    CSSPropertyID::kVectorEffect,
    CSSPropertyID::kVerticalAlign,
    CSSPropertyID::kViewTimelineAxis,
    CSSPropertyID::kViewTimelineInset,
    CSSPropertyID::kViewTimelineName,
    CSSPropertyID::kViewTransitionClass,
    CSSPropertyID::kViewTransitionGroup,
    CSSPropertyID::kViewTransitionName,
    CSSPropertyID::kVisibility,
    CSSPropertyID::kWhiteSpaceCollapse,
    CSSPropertyID::kWidows,
    CSSPropertyID::kWidth,
    CSSPropertyID::kWillChange,
    CSSPropertyID::kWordBreak,
    CSSPropertyID::kWordSpacing,
    CSSPropertyID::kWritingMode,
    CSSPropertyID::kX,
    CSSPropertyID::kY,
    CSSPropertyID::kZIndex,
    CSSPropertyID::kZoom,
    CSSPropertyID::kWebkitBorderHorizontalSpacing,
    CSSPropertyID::kWebkitBorderImage,
    CSSPropertyID::kWebkitBorderVerticalSpacing,
    CSSPropertyID::kWebkitBoxAlign,
    CSSPropertyID::kWebkitBoxDecorationBreak,
    CSSPropertyID::kWebkitBoxDirection,
    CSSPropertyID::kWebkitBoxFlex,
    CSSPropertyID::kWebkitBoxOrdinalGroup,
    CSSPropertyID::kWebkitBoxOrient,
    CSSPropertyID::kWebkitBoxPack,
    CSSPropertyID::kWebkitBoxReflect,
    CSSPropertyID::kWebkitFontSmoothing,
    CSSPropertyID::kWebkitLineBreak,
    CSSPropertyID::kWebkitLineClamp,
    CSSPropertyID::kWebkitLocale,
    CSSPropertyID::kWebkitMaskBoxImage,
    CSSPropertyID::kWebkitMaskBoxImageOutset,
    CSSPropertyID::kWebkitMaskBoxImageRepeat,
    CSSPropertyID::kWebkitMaskBoxImageSlice,
    CSSPropertyID::kWebkitMaskBoxImageSource,
    CSSPropertyID::kWebkitMaskBoxImageWidth,
    CSSPropertyID::kWebkitRtlOrdering,
    CSSPropertyID::kWebkitTapHighlightColor,
    CSSPropertyID::kWebkitTextCombine,
    CSSPropertyID::kWebkitTextDecorationsInEffect,
    CSSPropertyID::kWebkitTextFillColor,
    CSSPropertyID::kWebkitTextOrientation,
    CSSPropertyID::kWebkitTextSecurity,
    CSSPropertyID::kWebkitTextStrokeColor,
    CSSPropertyID::kWebkitTextStrokeWidth,
    CSSPropertyID::kWebkitUserDrag,
    CSSPropertyID::kWebkitUserModify,
    CSSPropertyID::kWebkitWritingMode,
};

inline constexpr CSSPropertyID kCSSIncludesCurrentColorProperties[] = {
      CSSPropertyID::kMaskImage,
    CSSPropertyID::kAccentColor,
    CSSPropertyID::kBackdropFilter,
    CSSPropertyID::kBackgroundColor,
    CSSPropertyID::kBackgroundImage,
    CSSPropertyID::kBorderBottomColor,
    CSSPropertyID::kBorderImageSource,
    CSSPropertyID::kBorderLeftColor,
    CSSPropertyID::kBorderRightColor,
    CSSPropertyID::kBorderTopColor,
    CSSPropertyID::kBoxShadow,
    CSSPropertyID::kCaretColor,
    CSSPropertyID::kColumnRuleColor,
    CSSPropertyID::kFill,
    CSSPropertyID::kFilter,
    CSSPropertyID::kFloodColor,
    CSSPropertyID::kLightingColor,
    CSSPropertyID::kListStyleImage,
    CSSPropertyID::kOutlineColor,
    CSSPropertyID::kRowRuleColor,
    CSSPropertyID::kStopColor,
    CSSPropertyID::kStroke,
    CSSPropertyID::kTextDecorationColor,
    CSSPropertyID::kTextEmphasisColor,
    CSSPropertyID::kTextShadow,
    CSSPropertyID::kWebkitBoxReflect,
    CSSPropertyID::kWebkitMaskBoxImageSource,
    CSSPropertyID::kWebkitTapHighlightColor,
    CSSPropertyID::kWebkitTextStrokeColor,
};

// The lowest CSSPropertyID excluding kInvalid and kVariable.
const int kIntFirstCSSProperty = 2;
const CSSPropertyID kFirstCSSProperty =
    static_cast<CSSPropertyID>(kIntFirstCSSProperty);

// The number of unresolved CSS properties excluding kInvalid and kVariable.
const int kNumCSSProperties = 766;

// The highest resolved CSSPropertyID.
const int kIntLastCSSProperty = 648;
const CSSPropertyID kLastCSSProperty =
    static_cast<CSSPropertyID>(kIntLastCSSProperty);

// The highest unresolved CSSPropertyID.
const CSSPropertyID kLastUnresolvedCSSProperty =
    static_cast<CSSPropertyID>(767);

const CSSPropertyID kFirstHighPriorityCSSProperty = kFirstCSSProperty;
const CSSPropertyID kLastHighPriorityCSSProperty = CSSPropertyID::kZoom;

// 1 + <The highest unresolved CSSPropertyID>.
const int kNumCSSPropertyIDs = static_cast<int>(kLastUnresolvedCSSProperty) + 1;

const size_t kMaxCSSPropertyNameLength = 48;
constexpr size_t kCSSPropertyIDBitLength = 10;
constexpr size_t kMaxShorthandExpansion = 19;

static_assert((static_cast<size_t>(1) << kCSSPropertyIDBitLength) >
                  static_cast<size_t>(kLastUnresolvedCSSProperty),
              "kCSSPropertyIDBitLength has enough bits");

// These are basically just change-detector tests, so that we do not
// accidentally add new high-priority properties or break the code generator.
static_assert(CSSPropertyID::kColorScheme == kFirstHighPriorityCSSProperty);
static_assert(CSSPropertyID::kZoom == kLastHighPriorityCSSProperty);
static_assert((static_cast<int>(kLastHighPriorityCSSProperty) -
               static_cast<int>(kFirstHighPriorityCSSProperty)) == 42,
              "There should a low number of high-priority properties");

inline int GetCSSPropertyIDIndex(CSSPropertyID id) {
    DCHECK_GE(id, kFirstCSSProperty);
    DCHECK_LE(id, kLastCSSProperty);
    return static_cast<int>(id) - kIntFirstCSSProperty;
}

constexpr bool IsHighPriority(CSSPropertyID id) {
  return id >= kFirstHighPriorityCSSProperty &&
      id <= kLastHighPriorityCSSProperty;
}

inline bool IsCSSPropertyIDWithName(CSSPropertyID id)
{
    return id >= kFirstCSSProperty && id <= kLastUnresolvedCSSProperty;
}

inline bool IsValidCSSPropertyID(CSSPropertyID id)
{
    return id != CSSPropertyID::kInvalid;
}

inline CSSPropertyID ConvertToCSSPropertyID(int value)
{
    DCHECK_GE(value, static_cast<int>(CSSPropertyID::kInvalid));
    DCHECK_LE(value, kIntLastCSSProperty);
    return static_cast<CSSPropertyID>(value);
}

int CORE_EXPORT ResolveCSSPropertyAlias(int value);

inline bool IsPropertyAlias(CSSPropertyID id) {
  return static_cast<int>(id) >= 649;
}

inline CSSPropertyID ResolveCSSPropertyID(CSSPropertyID id)
{
  int int_id = static_cast<int>(id);
  if (IsPropertyAlias(id))
    int_id = ResolveCSSPropertyAlias(int_id);
  return ConvertToCSSPropertyID(int_id);
}

CSSPropertyID CORE_EXPORT CssPropertyID(const ExecutionContext*,
                                        const String&);

class CSSPropertyIDList {
  STACK_ALLOCATED();

 public:
  class Iterator {
    STACK_ALLOCATED();
   public:
    Iterator(int id) : id_(id) {}
    CSSPropertyID operator*() const { return ConvertToCSSPropertyID(id_); }
    Iterator& operator++() {
      id_++;
      return *this;
    }
    bool operator!=(const Iterator& i) const { return id_ != i.id_; }

   private:
    int id_;
  };
  Iterator begin() const { return Iterator(kIntFirstCSSProperty); }
  Iterator end() const { return Iterator(kIntLastCSSProperty + 1); }
};

mojom::blink::CSSSampleId CORE_EXPORT GetCSSSampleId(CSSPropertyID id);

}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_CORE_CSS_CSS_PROPERTY_NAMES_H_
