// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WRITER_CREATE_OPTIONS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WRITER_CREATE_OPTIONS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_writer_create_core_options.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/heap/member.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

namespace blink {

class AbortSignal;
class ExceptionState;
class V8CreateMonitorCallback;

class MODULES_EXPORT WriterCreateOptions : public WriterCreateCoreOptions {
  
  public:
static WriterCreateOptions* Create() {
  return MakeGarbageCollected<WriterCreateOptions>();
}
static WriterCreateOptions* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<WriterCreateOptions>(isolate);
}
static WriterCreateOptions* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  WriterCreateOptions();
explicit  WriterCreateOptions(v8::Isolate* isolate);

bool hasMonitor() const {
  return has_monitor_;
}
V8CreateMonitorCallback* monitor() const {
  DCHECK(hasMonitor());
return member_monitor_.Get();
}
V8CreateMonitorCallback* getMonitorOr(V8CreateMonitorCallback* fallback_value) const {
  if (!hasMonitor()) {
  return fallback_value;
}
return member_monitor_.Get();
}
void setMonitor(V8CreateMonitorCallback* value) {
  member_monitor_ = value;
has_monitor_ = true;
DCHECK(member_monitor_);
}

bool hasSharedContext() const {
  return has_shared_context_;
}
const String& sharedContext() const {
  DCHECK(hasSharedContext());
return member_shared_context_;
}
String getSharedContextOr(const String& fallback_value) const;
String getSharedContextOr(String&& fallback_value) const;
void setSharedContext(const String& value);
void setSharedContext(String&& value);

bool hasSignal() const {
  return has_signal_;
}
AbortSignal* signal() const {
  DCHECK(hasSignal());
return member_signal_.Get();
}
AbortSignal* getSignalOr(AbortSignal* fallback_value) const {
  if (!hasSignal()) {
  return fallback_value;
}
return member_signal_.Get();
}
void setSignal(AbortSignal* value) {
  member_signal_ = value;
has_signal_ = true;
DCHECK(member_signal_);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = WriterCreateCoreOptions::kTotalPropertyCount;
static constexpr size_t kOwnPropertyCount = 3;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_monitor_ = false;
bool has_shared_context_ = false;
bool has_signal_ = false;

Member<V8CreateMonitorCallback> member_monitor_;
String member_shared_context_;
Member<AbortSignal> member_signal_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_WRITER_CREATE_OPTIONS_H_
