// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_rendering_context_webgpu.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_canvas_element_hit_test_region.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_canvas_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_image_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_video_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_bitmap.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_offscreen_canvas.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_predefined_color_space.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_htmlcanvaselement_offscreencanvas.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_frame.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_active_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_context_attributes.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_framebuffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_program.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_renderbuffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_shader.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_shader_precision_format.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_texture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_uniform_location.h"
#include "third_party/blink/renderer/core/dom/element.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/dactyloscoper.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/core/html/canvas/html_canvas_element.h"
#include "third_party/blink/renderer/core/html/canvas/image_data.h"
#include "third_party/blink/renderer/core/html/html_image_element.h"
#include "third_party/blink/renderer/core/html/media/html_video_element.h"
#include "third_party/blink/renderer/core/imagebitmap/image_bitmap.h"
#include "third_party/blink/renderer/core/offscreencanvas/offscreen_canvas.h"
#include "third_party/blink/renderer/modules/webcodecs/video_frame.h"
#include "third_party/blink/renderer/modules/webgl/webgl_active_info.h"
#include "third_party/blink/renderer/modules/webgl/webgl_buffer.h"
#include "third_party/blink/renderer/modules/webgl/webgl_framebuffer.h"
#include "third_party/blink/renderer/modules/webgl/webgl_program.h"
#include "third_party/blink/renderer/modules/webgl/webgl_renderbuffer.h"
#include "third_party/blink/renderer/modules/webgl/webgl_rendering_context_webgpu.h"
#include "third_party/blink/renderer/modules/webgl/webgl_shader.h"
#include "third_party/blink/renderer/modules/webgl/webgl_shader_precision_format.h"
#include "third_party/blink/renderer/modules/webgl/webgl_texture.h"
#include "third_party/blink/renderer/modules/webgl/webgl_uniform_location.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



bool V8WebGLRenderingContextWebGPU::IsExposed(ExecutionContext* execution_context) {
  
return (execution_context->IsWindow() || execution_context->IsWorkerGlobalScope()) && RuntimeEnabledFeatures::WebGLOnWebGPUEnabled();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8WebGLRenderingContextWebGPU::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8WebGLRenderingContextWebGPU::InstallInterfaceTemplate,
    V8WebGLRenderingContextWebGPU::InstallContextDependentProperties,
    "WebGLRenderingContextWebGPU",
    nullptr,
    V8WebGLRenderingContextWebGPU::kThisTag,
    V8WebGLRenderingContextWebGPU::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& WebGLRenderingContextWebGPU::wrapper_type_info_ =
    V8WebGLRenderingContextWebGPU::wrapper_type_info_;

// [ActiveScriptWrappable]
static_assert(
    std::is_base_of<ActiveScriptWrappableBase, WebGLRenderingContextWebGPU>::value,
    "WebGLRenderingContextWebGPU does not inherit from ActiveScriptWrappable<> despite "
    "the IDL has [ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_webgl_rendering_context_webgpu {


void CanvasAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_canvas_Getter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.canvas.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getHTMLOrOffscreenCanvas();
static_assert(bindings::IsReturnTypeCompatible<V8UnionHTMLCanvasElementOrOffscreenCanvas, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<V8UnionHTMLCanvasElementOrOffscreenCanvas>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}



void DrawingBufferWidthAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_drawingBufferWidth_Getter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.drawingBufferWidth.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->drawingBufferWidth();
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
}



void DrawingBufferHeightAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_drawingBufferHeight_Getter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.drawingBufferHeight.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->drawingBufferHeight();
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
}



void DrawingBufferFormatAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_drawingBufferFormat_Getter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.drawingBufferFormat.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->drawingBufferFormat();
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}



void DrawingBufferColorSpaceAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_drawingBufferColorSpace_Getter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.drawingBufferColorSpace.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->drawingBufferColorSpace(script_state);
static_assert(bindings::IsReturnTypeCompatible<V8PredefinedColorSpace, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void DrawingBufferColorSpaceAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_drawingBufferColorSpace_Setter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.drawingBufferColorSpace.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
// https://webidl.spec.whatwg.org/#dfn-attribute-setter
// step 4.6.1. Let S be ? ToString(V).
const auto&& arg1_value_string =
    NativeValueTraits<IDLString>::NativeValue(
        isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
// step 4.6.2. If S is not one of the enumeration's values, then return
//   undefined.
const auto arg1_value_maybe_enum = V8PredefinedColorSpace::Create(arg1_value_string);
if (!arg1_value_maybe_enum) {
  bindings::ReportInvalidEnumSetToAttribute(
      isolate, arg1_value_string, "PredefinedColorSpace", exception_state);
  return;  // Return undefined.
}
const auto arg1_value = arg1_value_maybe_enum.value();

blink_receiver->setDrawingBufferColorSpace(script_state, arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


void UnpackColorSpaceAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_unpackColorSpace_Getter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.unpackColorSpace.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->unpackColorSpace(script_state);
static_assert(bindings::IsReturnTypeCompatible<V8PredefinedColorSpace, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void UnpackColorSpaceAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_unpackColorSpace_Setter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.unpackColorSpace.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
// https://webidl.spec.whatwg.org/#dfn-attribute-setter
// step 4.6.1. Let S be ? ToString(V).
const auto&& arg1_value_string =
    NativeValueTraits<IDLString>::NativeValue(
        isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
// step 4.6.2. If S is not one of the enumeration's values, then return
//   undefined.
const auto arg1_value_maybe_enum = V8PredefinedColorSpace::Create(arg1_value_string);
if (!arg1_value_maybe_enum) {
  bindings::ReportInvalidEnumSetToAttribute(
      isolate, arg1_value_string, "PredefinedColorSpace", exception_state);
  return;  // Return undefined.
}
const auto arg1_value = arg1_value_maybe_enum.value();

blink_receiver->setUnpackColorSpace(script_state, arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void ActiveTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_activeTexture");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.activeTexture");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_texture = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->activeTexture(arg1_texture);

}

void AttachShaderOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_attachShader");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.attachShader");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_shader = NativeValueTraits<WebGLShader>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->attachShader(arg1_program, arg2_shader);

}

void BindAttribLocationOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_bindAttribLocation");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.bindAttribLocation");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindAttribLocation(arg1_program, arg2_index, arg3_name);

}

void BindBufferOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_target, v8::Local<v8::Value> v8_arg2_buffer, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_target = v8_arg1_target;
ExceptionState exception_state(isolate);
auto&& arg2_buffer = NativeValueTraits<IDLNullable<WebGLBuffer>>::ArgumentValue(isolate, 1, v8_arg2_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindBuffer(arg1_target, arg2_buffer);
}

void BindBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_bindBuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.bindBuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_buffer = NativeValueTraits<IDLNullable<WebGLBuffer>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindBuffer(arg1_target, arg2_buffer);

}

void BindFramebufferOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_target, v8::Local<v8::Value> v8_arg2_framebuffer, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_target = v8_arg1_target;
ExceptionState exception_state(isolate);
auto&& arg2_framebuffer = NativeValueTraits<IDLNullable<WebGLFramebuffer>>::ArgumentValue(isolate, 1, v8_arg2_framebuffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindFramebuffer(arg1_target, arg2_framebuffer);
}

void BindFramebufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_bindFramebuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.bindFramebuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_framebuffer = NativeValueTraits<IDLNullable<WebGLFramebuffer>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindFramebuffer(arg1_target, arg2_framebuffer);

}

void BindRenderbufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_bindRenderbuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.bindRenderbuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_renderbuffer = NativeValueTraits<IDLNullable<WebGLRenderbuffer>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindRenderbuffer(arg1_target, arg2_renderbuffer);

}

void BindTextureOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_target, v8::Local<v8::Value> v8_arg2_texture, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_target = v8_arg1_target;
ExceptionState exception_state(isolate);
auto&& arg2_texture = NativeValueTraits<IDLNullable<WebGLTexture>>::ArgumentValue(isolate, 1, v8_arg2_texture, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindTexture(arg1_target, arg2_texture);
}

void BindTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_bindTexture");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.bindTexture");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_texture = NativeValueTraits<IDLNullable<WebGLTexture>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindTexture(arg1_target, arg2_texture);

}

void BlendColorOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_blendColor");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.blendColor");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_red = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_green = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_blue = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_alpha = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->blendColor(arg1_red, arg2_green, arg3_blue, arg4_alpha);

}

void BlendEquationOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_blendEquation");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.blendEquation");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->blendEquation(arg1_mode);

}

void BlendEquationSeparateOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_blendEquationSeparate");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.blendEquationSeparate");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode_rgb = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_mode_alpha = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->blendEquationSeparate(arg1_mode_rgb, arg2_mode_alpha);

}

void BlendFuncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_blendFunc");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.blendFunc");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sfactor = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_dfactor = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->blendFunc(arg1_sfactor, arg2_dfactor);

}

void BlendFuncSeparateOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_blendFuncSeparate");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.blendFuncSeparate");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_src_rgb = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_dst_rgb = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_alpha = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_dst_alpha = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->blendFuncSeparate(arg1_src_rgb, arg2_dst_rgb, arg3_src_alpha, arg4_dst_alpha);

}

void BufferDataOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_size = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_usage = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bufferData(arg1_target, arg2_size, arg3_usage);

}

void BufferDataOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_usage = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bufferData(arg1_target, arg2_data, arg3_usage);

}

void BufferDataOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_data = NativeValueTraits<IDLNullable<IDLBufferSourceTypeNoSizeLimit<DOMArrayBufferBase>>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_usage = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bufferData(arg1_target, arg2_data, arg3_usage);

}

void BufferDataOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_bufferData");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.bufferData");


const int arg_count = std::min(info.Length(), 3);
if (arg_count == 3) {
  if (info[1]->IsNullOrUndefined()) {
  return BufferDataOperationOverload3(info);
}
if (info[1]->IsObject()) {
  if (info[1]->IsArrayBuffer() || info[1]->IsSharedArrayBuffer()) {
  return BufferDataOperationOverload3(info);
}
if (info[1]->IsArrayBufferView()) {
  return BufferDataOperationOverload2(info);
}
}
if (info[1]->IsNumber()) {
  return BufferDataOperationOverload1(info);
}
return BufferDataOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void BufferSubDataOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_bufferSubData");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.bufferSubData");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_data = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowShared, void>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bufferSubData(arg1_target, arg2_offset, arg3_data);

}

void CheckFramebufferStatusOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_checkFramebufferStatus");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.checkFramebufferStatus");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->checkFramebufferStatus(arg1_target);
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}

void ClearOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_mask, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_mask = v8_arg1_mask;
blink_receiver->clear(arg1_mask);
}

void ClearOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_clear");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.clear");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mask = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->clear(arg1_mask);

}

void ClearColorOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, float v8_arg1_red, float v8_arg2_green, float v8_arg3_blue, float v8_arg4_alpha, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_red = v8_arg1_red;
auto&& arg2_green = v8_arg2_green;
auto&& arg3_blue = v8_arg3_blue;
auto&& arg4_alpha = v8_arg4_alpha;
blink_receiver->clearColor(arg1_red, arg2_green, arg3_blue, arg4_alpha);
}

void ClearColorOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_clearColor");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.clearColor");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_red = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_green = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_blue = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_alpha = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->clearColor(arg1_red, arg2_green, arg3_blue, arg4_alpha);

}

void ClearDepthOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, float v8_arg1_depth, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_depth = v8_arg1_depth;
blink_receiver->clearDepth(arg1_depth);
}

void ClearDepthOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_clearDepth");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.clearDepth");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_depth = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->clearDepth(arg1_depth);

}

void ClearStencilOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, int32_t v8_arg1_s, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_s = v8_arg1_s;
blink_receiver->clearStencil(arg1_s);
}

void ClearStencilOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_clearStencil");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.clearStencil");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_s = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->clearStencil(arg1_s);

}

void ColorMaskOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, bool v8_arg1_red, bool v8_arg2_green, bool v8_arg3_blue, bool v8_arg4_alpha, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_red = v8_arg1_red;
auto&& arg2_green = v8_arg2_green;
auto&& arg3_blue = v8_arg3_blue;
auto&& arg4_alpha = v8_arg4_alpha;
blink_receiver->colorMask(arg1_red, arg2_green, arg3_blue, arg4_alpha);
}

void ColorMaskOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_colorMask");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.colorMask");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_red = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_green = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_blue = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_alpha = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->colorMask(arg1_red, arg2_green, arg3_blue, arg4_alpha);

}

void CompileShaderOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_compileShader");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.compileShader");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_shader = NativeValueTraits<WebGLShader>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->compileShader(arg1_shader);

}

void CompressedTexImage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_compressedTexImage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.compressedTexImage2D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->compressedTexImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_data);

}

void CompressedTexSubImage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_compressedTexSubImage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.compressedTexSubImage2D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 8) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(8, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->compressedTexSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_data);

}

void CopyTexImage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_copyTexImage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.copyTexImage2D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 8) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(8, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->copyTexImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_x, arg5_y, arg6_width, arg7_height, arg8_border);

}

void CopyTexSubImage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_copyTexSubImage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.copyTexSubImage2D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 8) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(8, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->copyTexSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_x, arg6_y, arg7_width, arg8_height);

}

void CreateBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_createBuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.createBuffer");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->createBuffer();
static_assert(bindings::IsReturnTypeCompatible<WebGLBuffer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateFramebufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_createFramebuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.createFramebuffer");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->createFramebuffer();
static_assert(bindings::IsReturnTypeCompatible<WebGLFramebuffer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateProgramOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_createProgram");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.createProgram");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->createProgram();
static_assert(bindings::IsReturnTypeCompatible<WebGLProgram, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateRenderbufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_createRenderbuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.createRenderbuffer");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->createRenderbuffer();
static_assert(bindings::IsReturnTypeCompatible<WebGLRenderbuffer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateShaderOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_createShader");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.createShader");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createShader(arg1_type);
static_assert(bindings::IsReturnTypeCompatible<WebGLShader, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_createTexture");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.createTexture");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->createTexture();
static_assert(bindings::IsReturnTypeCompatible<WebGLTexture, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CullFaceOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_cullFace");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.cullFace");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->cullFace(arg1_mode);

}

void DeleteBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_deleteBuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.deleteBuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<IDLNullable<WebGLBuffer>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteBuffer(arg1_buffer);

}

void DeleteFramebufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_deleteFramebuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.deleteFramebuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_framebuffer = NativeValueTraits<IDLNullable<WebGLFramebuffer>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteFramebuffer(arg1_framebuffer);

}

void DeleteProgramOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_deleteProgram");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.deleteProgram");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<IDLNullable<WebGLProgram>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteProgram(arg1_program);

}

void DeleteRenderbufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_deleteRenderbuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.deleteRenderbuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_renderbuffer = NativeValueTraits<IDLNullable<WebGLRenderbuffer>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteRenderbuffer(arg1_renderbuffer);

}

void DeleteShaderOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_deleteShader");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.deleteShader");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_shader = NativeValueTraits<IDLNullable<WebGLShader>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteShader(arg1_shader);

}

void DeleteTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_deleteTexture");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.deleteTexture");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_texture = NativeValueTraits<IDLNullable<WebGLTexture>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteTexture(arg1_texture);

}

void DepthFuncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_depthFunc");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.depthFunc");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_func = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->depthFunc(arg1_func);

}

void DepthMaskOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_depthMask");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.depthMask");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_flag = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->depthMask(arg1_flag);

}

void DepthRangeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_depthRange");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.depthRange");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_z_near = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_z_far = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->depthRange(arg1_z_near, arg2_z_far);

}

void DetachShaderOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_detachShader");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.detachShader");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_shader = NativeValueTraits<WebGLShader>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->detachShader(arg1_program, arg2_shader);

}

void DisableOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_disable");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.disable");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_cap = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->disable(arg1_cap);

}

void DisableVertexAttribArrayOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
blink_receiver->disableVertexAttribArray(arg1_index);
}

void DisableVertexAttribArrayOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_disableVertexAttribArray");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.disableVertexAttribArray");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->disableVertexAttribArray(arg1_index);

}

void DrawArraysOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_mode, int32_t v8_arg2_first, int32_t v8_arg3_count, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_mode = v8_arg1_mode;
auto&& arg2_first = v8_arg2_first;
auto&& arg3_count = v8_arg3_count;
blink_receiver->drawArrays(arg1_mode, arg2_first, arg3_count);
}

void DrawArraysOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_drawArrays");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.drawArrays");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_first = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_count = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawArrays(arg1_mode, arg2_first, arg3_count);

}

void DrawElementsOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_mode, int32_t v8_arg2_count, uint32_t v8_arg3_type, int64_t v8_arg4_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_mode = v8_arg1_mode;
auto&& arg2_count = v8_arg2_count;
auto&& arg3_type = v8_arg3_type;
auto&& arg4_offset = v8_arg4_offset;
blink_receiver->drawElements(arg1_mode, arg2_count, arg3_type, arg4_offset);
}

void DrawElementsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_drawElements");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.drawElements");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_count = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawElements(arg1_mode, arg2_count, arg3_type, arg4_offset);

}

void DrawingBufferStorageOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_drawingBufferStorage");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.drawingBufferStorage");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sizedformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawingBufferStorage(arg1_sizedformat, arg2_width, arg3_height);

}

void EnableOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_enable");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.enable");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_cap = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->enable(arg1_cap);

}

void EnableVertexAttribArrayOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
blink_receiver->enableVertexAttribArray(arg1_index);
}

void EnableVertexAttribArrayOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_enableVertexAttribArray");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.enableVertexAttribArray");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->enableVertexAttribArray(arg1_index);

}

void FinishOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_finish");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.finish");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->finish();

}

void FlushOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_flush");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.flush");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->flush();

}

void FramebufferRenderbufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_framebufferRenderbuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.framebufferRenderbuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_attachment = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_renderbuffertarget = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_renderbuffer = NativeValueTraits<IDLNullable<WebGLRenderbuffer>>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->framebufferRenderbuffer(arg1_target, arg2_attachment, arg3_renderbuffertarget, arg4_renderbuffer);

}

void FramebufferTexture2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_framebufferTexture2D");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.framebufferTexture2D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_attachment = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_textarget = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_texture = NativeValueTraits<IDLNullable<WebGLTexture>>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->framebufferTexture2D(arg1_target, arg2_attachment, arg3_textarget, arg4_texture, arg5_level);

}

void FrontFaceOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_frontFace");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.frontFace");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->frontFace(arg1_mode);

}

void GenerateMipmapOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_generateMipmap");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.generateMipmap");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->generateMipmap(arg1_target);

}

void GetActiveAttribOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getActiveAttrib");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getActiveAttrib");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getActiveAttrib(arg1_program, arg2_index);
static_assert(bindings::IsReturnTypeCompatible<WebGLActiveInfo, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void GetActiveUniformOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getActiveUniform");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getActiveUniform");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getActiveUniform(arg1_program, arg2_index);
static_assert(bindings::IsReturnTypeCompatible<WebGLActiveInfo, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void GetAttachedShadersOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getAttachedShaders");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getAttachedShaders");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getAttachedShaders(arg1_program);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLSequence<WebGLShader>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<IDLSequence<WebGLShader>>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void GetAttribLocationOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getAttribLocation");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getAttribLocation");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getAttribLocation(arg1_program, arg2_name);
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
}

void GetBufferParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getBufferParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getBufferParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getBufferParameter(script_state, arg1_target, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetContextAttributesOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getContextAttributes");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getContextAttributes");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getContextAttributes();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<WebGLContextAttributes>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<WebGLContextAttributes>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void GetErrorOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getError");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getError");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getError();
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}

void GetExtensionOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getExtension");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getExtension");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGLRenderingContextWebGPU.getExtension", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8WebGLRenderingContextWebGPU_GetExtension_Method);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
decltype(NativeValueTraits<IDLString>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_name;
if (info[0]->IsString()) [[likely]] {
  arg1_name.Init(isolate, info[0].As<v8::String>());
} else {
  ExceptionState exception_state(isolate);
arg1_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->getExtension(script_state, arg1_name);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLObject>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetFramebufferAttachmentParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getFramebufferAttachmentParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getFramebufferAttachmentParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_attachment = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getFramebufferAttachmentParameter(script_state, arg1_target, arg2_attachment, arg3_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getParameter");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGLRenderingContextWebGPU.getParameter", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kWebGLRenderingContextGetParameter);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getParameter(script_state, arg1_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetProgramInfoLogOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getProgramInfoLog");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getProgramInfoLog");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getProgramInfoLog(arg1_program);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void GetProgramParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getProgramParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getProgramParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getProgramParameter(script_state, arg1_program, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetRenderbufferParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getRenderbufferParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getRenderbufferParameter");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGLRenderingContextWebGPU.getRenderbufferParameter", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kWebGLRenderingContextGetRenderbufferParameter);


if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getRenderbufferParameter(script_state, arg1_target, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetShaderInfoLogOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getShaderInfoLog");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getShaderInfoLog");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_shader = NativeValueTraits<WebGLShader>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getShaderInfoLog(arg1_shader);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void GetShaderParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getShaderParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getShaderParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_shader = NativeValueTraits<WebGLShader>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getShaderParameter(script_state, arg1_shader, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetShaderPrecisionFormatOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getShaderPrecisionFormat");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getShaderPrecisionFormat");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGLRenderingContextWebGPU.getShaderPrecisionFormat", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kWebGLRenderingContextGetShaderPrecisionFormat);


if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_shadertype = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_precisiontype = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getShaderPrecisionFormat(arg1_shadertype, arg2_precisiontype);
static_assert(bindings::IsReturnTypeCompatible<WebGLShaderPrecisionFormat, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void GetShaderSourceOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getShaderSource");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getShaderSource");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_shader = NativeValueTraits<WebGLShader>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getShaderSource(arg1_shader);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void GetSupportedExtensionsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getSupportedExtensions");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getSupportedExtensions");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGLRenderingContextWebGPU.getSupportedExtensions", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8WebGLRenderingContextWebGPU_GetSupportedExtensions_Method);




v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getSupportedExtensions();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLSequence<IDLString>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<IDLSequence<IDLString>>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kV8WebGLRenderingContextWebGPU_GetSupportedExtensions_Method, return_value);
}

void GetTexParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getTexParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getTexParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getTexParameter(script_state, arg1_target, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetUniformOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getUniform");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getUniform");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_location = NativeValueTraits<WebGLUniformLocation>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getUniform(script_state, arg1_program, arg2_location);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetUniformLocationOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getUniformLocation");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getUniformLocation");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getUniformLocation(arg1_program, arg2_name);
static_assert(bindings::IsReturnTypeCompatible<WebGLUniformLocation, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void GetVertexAttribOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getVertexAttrib");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getVertexAttrib");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getVertexAttrib(script_state, arg1_index, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetVertexAttribOffsetOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_getVertexAttribOffset");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.getVertexAttribOffset");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getVertexAttribOffset(arg1_index, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLLongLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int64_t>());
}

void HintOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_hint");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.hint");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->hint(arg1_target, arg2_mode);

}

void InitAsyncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_initAsync");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.initAsync");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8WebGLRenderingContextWebGPU::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}





WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->initAsync(script_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUndefined>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void IsBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_isBuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.isBuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<IDLNullable<WebGLBuffer>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isBuffer(arg1_buffer);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsContextLostOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_isContextLost");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.isContextLost");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->isContextLost();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsEnabledOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_isEnabled");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.isEnabled");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_cap = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isEnabled(arg1_cap);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsFramebufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_isFramebuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.isFramebuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_framebuffer = NativeValueTraits<IDLNullable<WebGLFramebuffer>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isFramebuffer(arg1_framebuffer);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsProgramOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_isProgram");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.isProgram");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<IDLNullable<WebGLProgram>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isProgram(arg1_program);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsRenderbufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_isRenderbuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.isRenderbuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_renderbuffer = NativeValueTraits<IDLNullable<WebGLRenderbuffer>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isRenderbuffer(arg1_renderbuffer);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsShaderOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_isShader");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.isShader");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_shader = NativeValueTraits<IDLNullable<WebGLShader>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isShader(arg1_shader);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_isTexture");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.isTexture");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_texture = NativeValueTraits<IDLNullable<WebGLTexture>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isTexture(arg1_texture);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void LineWidthOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_lineWidth");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.lineWidth");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_width = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->lineWidth(arg1_width);

}

void LinkProgramOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_linkProgram");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.linkProgram");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->linkProgram(arg1_program);

}

void MakeXRCompatibleOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_makeXRCompatible");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.makeXRCompatible");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8WebGLRenderingContextWebGPU::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGLRenderingContextWebGPU.makeXRCompatible", info);
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kWebGLRenderingContextMakeXRCompatible);




WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "WebGLRenderingContextWebGPU";
const char* const property_name = "makeXRCompatible";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& return_value = blink_receiver->makeXRCompatible(script_state, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUndefined>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void PixelStoreiOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_pixelStorei");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.pixelStorei");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_param = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->pixelStorei(arg1_pname, arg2_param);

}

void PolygonOffsetOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_polygonOffset");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.polygonOffset");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_factor = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_units = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->polygonOffset(arg1_factor, arg2_units);

}

void ReadPixelsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_readPixels");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.readPixels");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGLRenderingContextWebGPU.readPixels", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_pixels = NativeValueTraits<IDLNullable<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->readPixels(arg1_x, arg2_y, arg3_width, arg4_height, arg5_format, arg6_type, arg7_pixels);

}

void RenderbufferStorageOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_renderbufferStorage");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.renderbufferStorage");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_internalformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->renderbufferStorage(arg1_target, arg2_internalformat, arg3_width, arg4_height);

}

void SampleCoverageOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_sampleCoverage");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.sampleCoverage");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_invert = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->sampleCoverage(arg1_value, arg2_invert);

}

void ScissorOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, int32_t v8_arg1_x, int32_t v8_arg2_y, int32_t v8_arg3_width, int32_t v8_arg4_height, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_width = v8_arg3_width;
auto&& arg4_height = v8_arg4_height;
blink_receiver->scissor(arg1_x, arg2_y, arg3_width, arg4_height);
}

void ScissorOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_scissor");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.scissor");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->scissor(arg1_x, arg2_y, arg3_width, arg4_height);

}

void SetHitTestRegionsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_setHitTestRegions");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.setHitTestRegions");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_hit_test_regions = NativeValueTraits<IDLSequence<CanvasElementHitTestRegion>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setHitTestRegions(std::move(arg1_hit_test_regions), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void ShaderSourceOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_shaderSource");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.shaderSource");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_shader = NativeValueTraits<WebGLShader>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_string = NativeValueTraits<IDLString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->shaderSource(arg1_shader, arg2_string);

}

void StencilFuncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_stencilFunc");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.stencilFunc");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_func = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_ref = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_mask = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->stencilFunc(arg1_func, arg2_ref, arg3_mask);

}

void StencilFuncSeparateOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_stencilFuncSeparate");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.stencilFuncSeparate");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_face = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_func = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_ref = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_mask = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->stencilFuncSeparate(arg1_face, arg2_func, arg3_ref, arg4_mask);

}

void StencilMaskOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_stencilMask");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.stencilMask");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mask = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->stencilMask(arg1_mask);

}

void StencilMaskSeparateOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_stencilMaskSeparate");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.stencilMaskSeparate");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_face = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_mask = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->stencilMaskSeparate(arg1_face, arg2_mask);

}

void StencilOpOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_stencilOp");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.stencilOp");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_fail = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_zfail = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_zpass = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->stencilOp(arg1_fail, arg2_zfail, arg3_zpass);

}

void StencilOpSeparateOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_stencilOpSeparate");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.stencilOpSeparate");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_face = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_fail = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_zfail = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_zpass = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->stencilOpSeparate(arg1_face, arg2_fail, arg3_zfail, arg4_zpass);

}

void TexElement2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_texElement2D");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.texElement2D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_element = NativeValueTraits<Element>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texElement2D(arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_element, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexElementImage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_texElementImage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.texElementImage2D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_element = NativeValueTraits<Element>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texElementImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_element, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_pixels = NativeValueTraits<IDLNullable<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_format, arg8_type, arg9_pixels);

}

void TexImage2DOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_pixels = NativeValueTraits<ImageData>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_pixels);

}

void TexImage2DOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_image = NativeValueTraits<HTMLImageElement>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_image, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload4(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_canvas = NativeValueTraits<HTMLCanvasElement>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload5(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_offscreen_canvas = NativeValueTraits<OffscreenCanvas>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_offscreen_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload6(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_video = NativeValueTraits<HTMLVideoElement>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_video, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload7(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_bitmap = NativeValueTraits<ImageBitmap>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_bitmap, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload8(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_frame = NativeValueTraits<VideoFrame>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_frame, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_texImage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.texImage2D");


const int arg_count = std::min(info.Length(), 9);
v8::Isolate* isolate = info.GetIsolate();
do {  // Dummy loop for use of 'break'.
  if (arg_count == 9) {
  return TexImage2DOperationOverload1(info);
}
if (arg_count == 6) {
  if (info[5]->IsObject()) {
  if (V8HTMLVideoElement::HasInstance(isolate, info[5])) {
  return TexImage2DOperationOverload6(info);
}
if (V8HTMLImageElement::HasInstance(isolate, info[5])) {
  return TexImage2DOperationOverload3(info);
}
if (V8HTMLCanvasElement::HasInstance(isolate, info[5])) {
  return TexImage2DOperationOverload4(info);
}
if (V8OffscreenCanvas::HasInstance(isolate, info[5])) {
  return TexImage2DOperationOverload5(info);
}
if (V8VideoFrame::HasInstance(isolate, info[5])) {
  return TexImage2DOperationOverload8(info);
}
if (V8ImageData::HasInstance(isolate, info[5])) {
  return TexImage2DOperationOverload2(info);
}
if (V8ImageBitmap::HasInstance(isolate, info[5])) {
  return TexImage2DOperationOverload7(info);
}
}
break;
}
} while (false);

if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void TexParameterfOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_texParameterf");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.texParameterf");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_param = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texParameterf(arg1_target, arg2_pname, arg3_param);

}

void TexParameteriOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_texParameteri");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.texParameteri");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_param = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texParameteri(arg1_target, arg2_pname, arg3_param);

}

void TexSubImage2DOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_pixels = NativeValueTraits<IDLNullable<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_type, arg9_pixels);

}

void TexSubImage2DOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_pixels = NativeValueTraits<ImageData>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_format, arg6_type, arg7_pixels);

}

void TexSubImage2DOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_image = NativeValueTraits<HTMLImageElement>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_format, arg6_type, arg7_image, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload4(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_canvas = NativeValueTraits<HTMLCanvasElement>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_format, arg6_type, arg7_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload5(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_offscreen_canvas = NativeValueTraits<OffscreenCanvas>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_format, arg6_type, arg7_offscreen_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload6(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_video = NativeValueTraits<HTMLVideoElement>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_format, arg6_type, arg7_video, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload7(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_bitmap = NativeValueTraits<ImageBitmap>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_format, arg6_type, arg7_bitmap, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload8(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_frame = NativeValueTraits<VideoFrame>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_format, arg6_type, arg7_frame, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_texSubImage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.texSubImage2D");


const int arg_count = std::min(info.Length(), 9);
v8::Isolate* isolate = info.GetIsolate();
do {  // Dummy loop for use of 'break'.
  if (arg_count == 9) {
  return TexSubImage2DOperationOverload1(info);
}
if (arg_count == 7) {
  if (info[6]->IsObject()) {
  if (V8HTMLVideoElement::HasInstance(isolate, info[6])) {
  return TexSubImage2DOperationOverload6(info);
}
if (V8HTMLImageElement::HasInstance(isolate, info[6])) {
  return TexSubImage2DOperationOverload3(info);
}
if (V8HTMLCanvasElement::HasInstance(isolate, info[6])) {
  return TexSubImage2DOperationOverload4(info);
}
if (V8OffscreenCanvas::HasInstance(isolate, info[6])) {
  return TexSubImage2DOperationOverload5(info);
}
if (V8VideoFrame::HasInstance(isolate, info[6])) {
  return TexSubImage2DOperationOverload8(info);
}
if (V8ImageData::HasInstance(isolate, info[6])) {
  return TexSubImage2DOperationOverload2(info);
}
if (V8ImageBitmap::HasInstance(isolate, info[6])) {
  return TexSubImage2DOperationOverload7(info);
}
}
break;
}
} while (false);

if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void Uniform1FOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, float v8_arg2_x, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
blink_receiver->uniform1f(arg1_location, arg2_x);
}

void Uniform1FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform1f");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform1f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform1f(arg1_location, arg2_x);

}

void Uniform1FvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform1fv(arg1_location, arg2_v);
}

void Uniform1FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform1fv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform1fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform1fv(arg1_location, arg2_v);

}

void Uniform1IOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, int32_t v8_arg2_x, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
blink_receiver->uniform1i(arg1_location, arg2_x);
}

void Uniform1IOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform1i");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform1i");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform1i(arg1_location, arg2_x);

}

void Uniform1IvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform1iv(arg1_location, arg2_v);
}

void Uniform1IvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform1iv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform1iv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform1iv(arg1_location, arg2_v);

}

void Uniform2FOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, float v8_arg2_x, float v8_arg3_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
blink_receiver->uniform2f(arg1_location, arg2_x, arg3_y);
}

void Uniform2FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform2f");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform2f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform2f(arg1_location, arg2_x, arg3_y);

}

void Uniform2FvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform2fv(arg1_location, arg2_v);
}

void Uniform2FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform2fv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform2fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform2fv(arg1_location, arg2_v);

}

void Uniform2IOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, int32_t v8_arg2_x, int32_t v8_arg3_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
blink_receiver->uniform2i(arg1_location, arg2_x, arg3_y);
}

void Uniform2IOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform2i");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform2i");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform2i(arg1_location, arg2_x, arg3_y);

}

void Uniform2IvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform2iv(arg1_location, arg2_v);
}

void Uniform2IvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform2iv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform2iv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform2iv(arg1_location, arg2_v);

}

void Uniform3FOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, float v8_arg2_x, float v8_arg3_y, float v8_arg4_z, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
auto&& arg4_z = v8_arg4_z;
blink_receiver->uniform3f(arg1_location, arg2_x, arg3_y, arg4_z);
}

void Uniform3FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform3f");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform3f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_z = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform3f(arg1_location, arg2_x, arg3_y, arg4_z);

}

void Uniform3FvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform3fv(arg1_location, arg2_v);
}

void Uniform3FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform3fv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform3fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform3fv(arg1_location, arg2_v);

}

void Uniform3IOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, int32_t v8_arg2_x, int32_t v8_arg3_y, int32_t v8_arg4_z, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
auto&& arg4_z = v8_arg4_z;
blink_receiver->uniform3i(arg1_location, arg2_x, arg3_y, arg4_z);
}

void Uniform3IOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform3i");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform3i");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_z = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform3i(arg1_location, arg2_x, arg3_y, arg4_z);

}

void Uniform3IvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform3iv(arg1_location, arg2_v);
}

void Uniform3IvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform3iv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform3iv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform3iv(arg1_location, arg2_v);

}

void Uniform4FOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, float v8_arg2_x, float v8_arg3_y, float v8_arg4_z, float v8_arg5_w, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
auto&& arg4_z = v8_arg4_z;
auto&& arg5_w = v8_arg5_w;
blink_receiver->uniform4f(arg1_location, arg2_x, arg3_y, arg4_z, arg5_w);
}

void Uniform4FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform4f");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform4f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_z = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_w = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform4f(arg1_location, arg2_x, arg3_y, arg4_z, arg5_w);

}

void Uniform4FvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform4fv(arg1_location, arg2_v);
}

void Uniform4FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform4fv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform4fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform4fv(arg1_location, arg2_v);

}

void Uniform4IOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, int32_t v8_arg2_x, int32_t v8_arg3_y, int32_t v8_arg4_z, int32_t v8_arg5_w, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
auto&& arg4_z = v8_arg4_z;
auto&& arg5_w = v8_arg5_w;
blink_receiver->uniform4i(arg1_location, arg2_x, arg3_y, arg4_z, arg5_w);
}

void Uniform4IOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform4i");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform4i");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_z = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_w = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform4i(arg1_location, arg2_x, arg3_y, arg4_z, arg5_w);

}

void Uniform4IvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform4iv(arg1_location, arg2_v);
}

void Uniform4IvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniform4iv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniform4iv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform4iv(arg1_location, arg2_v);

}

void UniformMatrix2FvOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_array, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_array, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniformMatrix2fv(arg1_location, arg2_transpose, arg3_array);
}

void UniformMatrix2FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniformMatrix2fv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniformMatrix2fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniformMatrix2fv(arg1_location, arg2_transpose, arg3_array);

}

void UniformMatrix3FvOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_array, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_array, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniformMatrix3fv(arg1_location, arg2_transpose, arg3_array);
}

void UniformMatrix3FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniformMatrix3fv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniformMatrix3fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniformMatrix3fv(arg1_location, arg2_transpose, arg3_array);

}

void UniformMatrix4FvOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_array, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_array, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniformMatrix4fv(arg1_location, arg2_transpose, arg3_array);
}

void UniformMatrix4FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_uniformMatrix4fv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.uniformMatrix4fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniformMatrix4fv(arg1_location, arg2_transpose, arg3_array);

}

void UseProgramOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_useProgram");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.useProgram");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<IDLNullable<WebGLProgram>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->useProgram(arg1_program);

}

void ValidateProgramOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_validateProgram");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.validateProgram");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->validateProgram(arg1_program);

}

void VertexAttrib1FOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, float v8_arg2_x, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
auto&& arg2_x = v8_arg2_x;
blink_receiver->vertexAttrib1f(arg1_indx, arg2_x);
}

void VertexAttrib1FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_vertexAttrib1f");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.vertexAttrib1f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib1f(arg1_indx, arg2_x);

}

void VertexAttrib1FvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, v8::Local<v8::Value> v8_arg2_values, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
ExceptionState exception_state(isolate);
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_values, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib1fv(arg1_indx, arg2_values);
}

void VertexAttrib1FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_vertexAttrib1fv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.vertexAttrib1fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib1fv(arg1_indx, arg2_values);

}

void VertexAttrib2FOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, float v8_arg2_x, float v8_arg3_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
blink_receiver->vertexAttrib2f(arg1_indx, arg2_x, arg3_y);
}

void VertexAttrib2FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_vertexAttrib2f");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.vertexAttrib2f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib2f(arg1_indx, arg2_x, arg3_y);

}

void VertexAttrib2FvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, v8::Local<v8::Value> v8_arg2_values, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
ExceptionState exception_state(isolate);
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_values, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib2fv(arg1_indx, arg2_values);
}

void VertexAttrib2FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_vertexAttrib2fv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.vertexAttrib2fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib2fv(arg1_indx, arg2_values);

}

void VertexAttrib3FOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, float v8_arg2_x, float v8_arg3_y, float v8_arg4_z, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
auto&& arg4_z = v8_arg4_z;
blink_receiver->vertexAttrib3f(arg1_indx, arg2_x, arg3_y, arg4_z);
}

void VertexAttrib3FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_vertexAttrib3f");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.vertexAttrib3f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_z = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib3f(arg1_indx, arg2_x, arg3_y, arg4_z);

}

void VertexAttrib3FvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, v8::Local<v8::Value> v8_arg2_values, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
ExceptionState exception_state(isolate);
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_values, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib3fv(arg1_indx, arg2_values);
}

void VertexAttrib3FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_vertexAttrib3fv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.vertexAttrib3fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib3fv(arg1_indx, arg2_values);

}

void VertexAttrib4FOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, float v8_arg2_x, float v8_arg3_y, float v8_arg4_z, float v8_arg5_w, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
auto&& arg4_z = v8_arg4_z;
auto&& arg5_w = v8_arg5_w;
blink_receiver->vertexAttrib4f(arg1_indx, arg2_x, arg3_y, arg4_z, arg5_w);
}

void VertexAttrib4FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_vertexAttrib4f");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.vertexAttrib4f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_z = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_w = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib4f(arg1_indx, arg2_x, arg3_y, arg4_z, arg5_w);

}

void VertexAttrib4FvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, v8::Local<v8::Value> v8_arg2_values, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
ExceptionState exception_state(isolate);
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_values, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib4fv(arg1_indx, arg2_values);
}

void VertexAttrib4FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_vertexAttrib4fv");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.vertexAttrib4fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib4fv(arg1_indx, arg2_values);

}

void VertexAttribPointerOperationNoAllocDirectCallArg6(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, int32_t v8_arg2_size, uint32_t v8_arg3_type, bool v8_arg4_normalized, int32_t v8_arg5_stride, int64_t v8_arg6_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
auto&& arg2_size = v8_arg2_size;
auto&& arg3_type = v8_arg3_type;
auto&& arg4_normalized = v8_arg4_normalized;
auto&& arg5_stride = v8_arg5_stride;
auto&& arg6_offset = v8_arg6_offset;
blink_receiver->vertexAttribPointer(arg1_indx, arg2_size, arg3_type, arg4_normalized, arg5_stride, arg6_offset);
}

void VertexAttribPointerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_vertexAttribPointer");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.vertexAttribPointer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_size = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_normalized = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_stride = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttribPointer(arg1_indx, arg2_size, arg3_type, arg4_normalized, arg5_stride, arg6_offset);

}

void ViewportOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, int32_t v8_arg1_x, int32_t v8_arg2_y, int32_t v8_arg3_width, int32_t v8_arg4_height, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_width = v8_arg3_width;
auto&& arg4_height = v8_arg4_height;
blink_receiver->viewport(arg1_x, arg2_y, arg3_width, arg4_height);
}

void ViewportOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGLRenderingContextWebGPU_viewport");
BLINK_BINDINGS_TRACE_EVENT("WebGLRenderingContextWebGPU.viewport");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGLRenderingContextWebGPU* blink_receiver = V8WebGLRenderingContextWebGPU::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->viewport(arg1_x, arg2_y, arg3_width, arg4_height);

}


}  // namespace v8_webgl_rendering_context_webgpu

using namespace v8_webgl_rendering_context_webgpu;

}  // namespace 

void V8WebGLRenderingContextWebGPU::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8WebGLRenderingContextWebGPU::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8WebGLRenderingContextWebGPU::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"canvas", CanvasAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"drawingBufferWidth", DrawingBufferWidthAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"drawingBufferHeight", DrawingBufferHeightAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"drawingBufferColorSpace", DrawingBufferColorSpaceAttributeGetCallback, DrawingBufferColorSpaceAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"unpackColorSpace", UnpackColorSpaceAttributeGetCallback, UnpackColorSpaceAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGLRenderingContextWebGPU", kAttributeTable);
}



{
  static const IDLMemberInstaller::ConstantValueConfig kConstantValueTable[] = {
{"DEPTH_BUFFER_BIT", V8WebGLRenderingContextWebGPU::Constant::kDepthBufferBit},
{"STENCIL_BUFFER_BIT", V8WebGLRenderingContextWebGPU::Constant::kStencilBufferBit},
{"COLOR_BUFFER_BIT", V8WebGLRenderingContextWebGPU::Constant::kColorBufferBit},
{"POINTS", V8WebGLRenderingContextWebGPU::Constant::kPoints},
{"LINES", V8WebGLRenderingContextWebGPU::Constant::kLines},
{"LINE_LOOP", V8WebGLRenderingContextWebGPU::Constant::kLineLoop},
{"LINE_STRIP", V8WebGLRenderingContextWebGPU::Constant::kLineStrip},
{"TRIANGLES", V8WebGLRenderingContextWebGPU::Constant::kTriangles},
{"TRIANGLE_STRIP", V8WebGLRenderingContextWebGPU::Constant::kTriangleStrip},
{"TRIANGLE_FAN", V8WebGLRenderingContextWebGPU::Constant::kTriangleFan},
{"ZERO", V8WebGLRenderingContextWebGPU::Constant::kZero},
{"ONE", V8WebGLRenderingContextWebGPU::Constant::kOne},
{"SRC_COLOR", V8WebGLRenderingContextWebGPU::Constant::kSrcColor},
{"ONE_MINUS_SRC_COLOR", V8WebGLRenderingContextWebGPU::Constant::kOneMinusSrcColor},
{"SRC_ALPHA", V8WebGLRenderingContextWebGPU::Constant::kSrcAlpha},
{"ONE_MINUS_SRC_ALPHA", V8WebGLRenderingContextWebGPU::Constant::kOneMinusSrcAlpha},
{"DST_ALPHA", V8WebGLRenderingContextWebGPU::Constant::kDstAlpha},
{"ONE_MINUS_DST_ALPHA", V8WebGLRenderingContextWebGPU::Constant::kOneMinusDstAlpha},
{"DST_COLOR", V8WebGLRenderingContextWebGPU::Constant::kDstColor},
{"ONE_MINUS_DST_COLOR", V8WebGLRenderingContextWebGPU::Constant::kOneMinusDstColor},
{"SRC_ALPHA_SATURATE", V8WebGLRenderingContextWebGPU::Constant::kSrcAlphaSaturate},
{"FUNC_ADD", V8WebGLRenderingContextWebGPU::Constant::kFuncAdd},
{"BLEND_EQUATION", V8WebGLRenderingContextWebGPU::Constant::kBlendEquation},
{"BLEND_EQUATION_RGB", V8WebGLRenderingContextWebGPU::Constant::kBlendEquationRgb},
{"BLEND_EQUATION_ALPHA", V8WebGLRenderingContextWebGPU::Constant::kBlendEquationAlpha},
{"FUNC_SUBTRACT", V8WebGLRenderingContextWebGPU::Constant::kFuncSubtract},
{"FUNC_REVERSE_SUBTRACT", V8WebGLRenderingContextWebGPU::Constant::kFuncReverseSubtract},
{"BLEND_DST_RGB", V8WebGLRenderingContextWebGPU::Constant::kBlendDstRgb},
{"BLEND_SRC_RGB", V8WebGLRenderingContextWebGPU::Constant::kBlendSrcRgb},
{"BLEND_DST_ALPHA", V8WebGLRenderingContextWebGPU::Constant::kBlendDstAlpha},
{"BLEND_SRC_ALPHA", V8WebGLRenderingContextWebGPU::Constant::kBlendSrcAlpha},
{"CONSTANT_COLOR", V8WebGLRenderingContextWebGPU::Constant::kConstantColor},
{"ONE_MINUS_CONSTANT_COLOR", V8WebGLRenderingContextWebGPU::Constant::kOneMinusConstantColor},
{"CONSTANT_ALPHA", V8WebGLRenderingContextWebGPU::Constant::kConstantAlpha},
{"ONE_MINUS_CONSTANT_ALPHA", V8WebGLRenderingContextWebGPU::Constant::kOneMinusConstantAlpha},
{"BLEND_COLOR", V8WebGLRenderingContextWebGPU::Constant::kBlendColor},
{"ARRAY_BUFFER", V8WebGLRenderingContextWebGPU::Constant::kArrayBuffer},
{"ELEMENT_ARRAY_BUFFER", V8WebGLRenderingContextWebGPU::Constant::kElementArrayBuffer},
{"ARRAY_BUFFER_BINDING", V8WebGLRenderingContextWebGPU::Constant::kArrayBufferBinding},
{"ELEMENT_ARRAY_BUFFER_BINDING", V8WebGLRenderingContextWebGPU::Constant::kElementArrayBufferBinding},
{"STREAM_DRAW", V8WebGLRenderingContextWebGPU::Constant::kStreamDraw},
{"STATIC_DRAW", V8WebGLRenderingContextWebGPU::Constant::kStaticDraw},
{"DYNAMIC_DRAW", V8WebGLRenderingContextWebGPU::Constant::kDynamicDraw},
{"BUFFER_SIZE", V8WebGLRenderingContextWebGPU::Constant::kBufferSize},
{"BUFFER_USAGE", V8WebGLRenderingContextWebGPU::Constant::kBufferUsage},
{"CURRENT_VERTEX_ATTRIB", V8WebGLRenderingContextWebGPU::Constant::kCurrentVertexAttrib},
{"FRONT", V8WebGLRenderingContextWebGPU::Constant::kFront},
{"BACK", V8WebGLRenderingContextWebGPU::Constant::kBack},
{"FRONT_AND_BACK", V8WebGLRenderingContextWebGPU::Constant::kFrontAndBack},
{"TEXTURE_2D", V8WebGLRenderingContextWebGPU::Constant::kTexture2d},
{"CULL_FACE", V8WebGLRenderingContextWebGPU::Constant::kCullFace},
{"BLEND", V8WebGLRenderingContextWebGPU::Constant::kBlend},
{"DITHER", V8WebGLRenderingContextWebGPU::Constant::kDither},
{"STENCIL_TEST", V8WebGLRenderingContextWebGPU::Constant::kStencilTest},
{"DEPTH_TEST", V8WebGLRenderingContextWebGPU::Constant::kDepthTest},
{"SCISSOR_TEST", V8WebGLRenderingContextWebGPU::Constant::kScissorTest},
{"POLYGON_OFFSET_FILL", V8WebGLRenderingContextWebGPU::Constant::kPolygonOffsetFill},
{"SAMPLE_ALPHA_TO_COVERAGE", V8WebGLRenderingContextWebGPU::Constant::kSampleAlphaToCoverage},
{"SAMPLE_COVERAGE", V8WebGLRenderingContextWebGPU::Constant::kSampleCoverage},
{"NO_ERROR", V8WebGLRenderingContextWebGPU::Constant::kNoError},
{"INVALID_ENUM", V8WebGLRenderingContextWebGPU::Constant::kInvalidEnum},
{"INVALID_VALUE", V8WebGLRenderingContextWebGPU::Constant::kInvalidValue},
{"INVALID_OPERATION", V8WebGLRenderingContextWebGPU::Constant::kInvalidOperation},
{"OUT_OF_MEMORY", V8WebGLRenderingContextWebGPU::Constant::kOutOfMemory},
{"CW", V8WebGLRenderingContextWebGPU::Constant::kCw},
{"CCW", V8WebGLRenderingContextWebGPU::Constant::kCcw},
{"LINE_WIDTH", V8WebGLRenderingContextWebGPU::Constant::kLineWidth},
{"ALIASED_POINT_SIZE_RANGE", V8WebGLRenderingContextWebGPU::Constant::kAliasedPointSizeRange},
{"ALIASED_LINE_WIDTH_RANGE", V8WebGLRenderingContextWebGPU::Constant::kAliasedLineWidthRange},
{"CULL_FACE_MODE", V8WebGLRenderingContextWebGPU::Constant::kCullFaceMode},
{"FRONT_FACE", V8WebGLRenderingContextWebGPU::Constant::kFrontFace},
{"DEPTH_RANGE", V8WebGLRenderingContextWebGPU::Constant::kDepthRange},
{"DEPTH_WRITEMASK", V8WebGLRenderingContextWebGPU::Constant::kDepthWritemask},
{"DEPTH_CLEAR_VALUE", V8WebGLRenderingContextWebGPU::Constant::kDepthClearValue},
{"DEPTH_FUNC", V8WebGLRenderingContextWebGPU::Constant::kDepthFunc},
{"STENCIL_CLEAR_VALUE", V8WebGLRenderingContextWebGPU::Constant::kStencilClearValue},
{"STENCIL_FUNC", V8WebGLRenderingContextWebGPU::Constant::kStencilFunc},
{"STENCIL_FAIL", V8WebGLRenderingContextWebGPU::Constant::kStencilFail},
{"STENCIL_PASS_DEPTH_FAIL", V8WebGLRenderingContextWebGPU::Constant::kStencilPassDepthFail},
{"STENCIL_PASS_DEPTH_PASS", V8WebGLRenderingContextWebGPU::Constant::kStencilPassDepthPass},
{"STENCIL_REF", V8WebGLRenderingContextWebGPU::Constant::kStencilRef},
{"STENCIL_VALUE_MASK", V8WebGLRenderingContextWebGPU::Constant::kStencilValueMask},
{"STENCIL_WRITEMASK", V8WebGLRenderingContextWebGPU::Constant::kStencilWritemask},
{"STENCIL_BACK_FUNC", V8WebGLRenderingContextWebGPU::Constant::kStencilBackFunc},
{"STENCIL_BACK_FAIL", V8WebGLRenderingContextWebGPU::Constant::kStencilBackFail},
{"STENCIL_BACK_PASS_DEPTH_FAIL", V8WebGLRenderingContextWebGPU::Constant::kStencilBackPassDepthFail},
{"STENCIL_BACK_PASS_DEPTH_PASS", V8WebGLRenderingContextWebGPU::Constant::kStencilBackPassDepthPass},
{"STENCIL_BACK_REF", V8WebGLRenderingContextWebGPU::Constant::kStencilBackRef},
{"STENCIL_BACK_VALUE_MASK", V8WebGLRenderingContextWebGPU::Constant::kStencilBackValueMask},
{"STENCIL_BACK_WRITEMASK", V8WebGLRenderingContextWebGPU::Constant::kStencilBackWritemask},
{"VIEWPORT", V8WebGLRenderingContextWebGPU::Constant::kViewport},
{"SCISSOR_BOX", V8WebGLRenderingContextWebGPU::Constant::kScissorBox},
{"COLOR_CLEAR_VALUE", V8WebGLRenderingContextWebGPU::Constant::kColorClearValue},
{"COLOR_WRITEMASK", V8WebGLRenderingContextWebGPU::Constant::kColorWritemask},
{"UNPACK_ALIGNMENT", V8WebGLRenderingContextWebGPU::Constant::kUnpackAlignment},
{"PACK_ALIGNMENT", V8WebGLRenderingContextWebGPU::Constant::kPackAlignment},
{"MAX_TEXTURE_SIZE", V8WebGLRenderingContextWebGPU::Constant::kMaxTextureSize},
{"MAX_VIEWPORT_DIMS", V8WebGLRenderingContextWebGPU::Constant::kMaxViewportDims},
{"SUBPIXEL_BITS", V8WebGLRenderingContextWebGPU::Constant::kSubpixelBits},
{"RED_BITS", V8WebGLRenderingContextWebGPU::Constant::kRedBits},
{"GREEN_BITS", V8WebGLRenderingContextWebGPU::Constant::kGreenBits},
{"BLUE_BITS", V8WebGLRenderingContextWebGPU::Constant::kBlueBits},
{"ALPHA_BITS", V8WebGLRenderingContextWebGPU::Constant::kAlphaBits},
{"DEPTH_BITS", V8WebGLRenderingContextWebGPU::Constant::kDepthBits},
{"STENCIL_BITS", V8WebGLRenderingContextWebGPU::Constant::kStencilBits},
{"POLYGON_OFFSET_UNITS", V8WebGLRenderingContextWebGPU::Constant::kPolygonOffsetUnits},
{"POLYGON_OFFSET_FACTOR", V8WebGLRenderingContextWebGPU::Constant::kPolygonOffsetFactor},
{"TEXTURE_BINDING_2D", V8WebGLRenderingContextWebGPU::Constant::kTextureBinding2d},
{"SAMPLE_BUFFERS", V8WebGLRenderingContextWebGPU::Constant::kSampleBuffers},
{"SAMPLES", V8WebGLRenderingContextWebGPU::Constant::kSamples},
{"SAMPLE_COVERAGE_VALUE", V8WebGLRenderingContextWebGPU::Constant::kSampleCoverageValue},
{"SAMPLE_COVERAGE_INVERT", V8WebGLRenderingContextWebGPU::Constant::kSampleCoverageInvert},
{"COMPRESSED_TEXTURE_FORMATS", V8WebGLRenderingContextWebGPU::Constant::kCompressedTextureFormats},
{"DONT_CARE", V8WebGLRenderingContextWebGPU::Constant::kDontCare},
{"FASTEST", V8WebGLRenderingContextWebGPU::Constant::kFastest},
{"NICEST", V8WebGLRenderingContextWebGPU::Constant::kNicest},
{"GENERATE_MIPMAP_HINT", V8WebGLRenderingContextWebGPU::Constant::kGenerateMipmapHint},
{"BYTE", V8WebGLRenderingContextWebGPU::Constant::kByte},
{"UNSIGNED_BYTE", V8WebGLRenderingContextWebGPU::Constant::kUnsignedByte},
{"SHORT", V8WebGLRenderingContextWebGPU::Constant::kShort},
{"UNSIGNED_SHORT", V8WebGLRenderingContextWebGPU::Constant::kUnsignedShort},
{"INT", V8WebGLRenderingContextWebGPU::Constant::kInt},
{"UNSIGNED_INT", V8WebGLRenderingContextWebGPU::Constant::kUnsignedInt},
{"FLOAT", V8WebGLRenderingContextWebGPU::Constant::kFloat},
{"DEPTH_COMPONENT", V8WebGLRenderingContextWebGPU::Constant::kDepthComponent},
{"ALPHA", V8WebGLRenderingContextWebGPU::Constant::kAlpha},
{"RGB", V8WebGLRenderingContextWebGPU::Constant::kRgb},
{"RGBA", V8WebGLRenderingContextWebGPU::Constant::kRgba},
{"LUMINANCE", V8WebGLRenderingContextWebGPU::Constant::kLuminance},
{"LUMINANCE_ALPHA", V8WebGLRenderingContextWebGPU::Constant::kLuminanceAlpha},
{"UNSIGNED_SHORT_4_4_4_4", V8WebGLRenderingContextWebGPU::Constant::kUnsignedShort4444},
{"UNSIGNED_SHORT_5_5_5_1", V8WebGLRenderingContextWebGPU::Constant::kUnsignedShort5551},
{"UNSIGNED_SHORT_5_6_5", V8WebGLRenderingContextWebGPU::Constant::kUnsignedShort565},
{"FRAGMENT_SHADER", V8WebGLRenderingContextWebGPU::Constant::kFragmentShader},
{"VERTEX_SHADER", V8WebGLRenderingContextWebGPU::Constant::kVertexShader},
{"MAX_VERTEX_ATTRIBS", V8WebGLRenderingContextWebGPU::Constant::kMaxVertexAttribs},
{"MAX_VERTEX_UNIFORM_VECTORS", V8WebGLRenderingContextWebGPU::Constant::kMaxVertexUniformVectors},
{"MAX_VARYING_VECTORS", V8WebGLRenderingContextWebGPU::Constant::kMaxVaryingVectors},
{"MAX_COMBINED_TEXTURE_IMAGE_UNITS", V8WebGLRenderingContextWebGPU::Constant::kMaxCombinedTextureImageUnits},
{"MAX_VERTEX_TEXTURE_IMAGE_UNITS", V8WebGLRenderingContextWebGPU::Constant::kMaxVertexTextureImageUnits},
{"MAX_TEXTURE_IMAGE_UNITS", V8WebGLRenderingContextWebGPU::Constant::kMaxTextureImageUnits},
{"MAX_FRAGMENT_UNIFORM_VECTORS", V8WebGLRenderingContextWebGPU::Constant::kMaxFragmentUniformVectors},
{"SHADER_TYPE", V8WebGLRenderingContextWebGPU::Constant::kShaderType},
{"DELETE_STATUS", V8WebGLRenderingContextWebGPU::Constant::kDeleteStatus},
{"LINK_STATUS", V8WebGLRenderingContextWebGPU::Constant::kLinkStatus},
{"VALIDATE_STATUS", V8WebGLRenderingContextWebGPU::Constant::kValidateStatus},
{"ATTACHED_SHADERS", V8WebGLRenderingContextWebGPU::Constant::kAttachedShaders},
{"ACTIVE_UNIFORMS", V8WebGLRenderingContextWebGPU::Constant::kActiveUniforms},
{"ACTIVE_ATTRIBUTES", V8WebGLRenderingContextWebGPU::Constant::kActiveAttributes},
{"SHADING_LANGUAGE_VERSION", V8WebGLRenderingContextWebGPU::Constant::kShadingLanguageVersion},
{"CURRENT_PROGRAM", V8WebGLRenderingContextWebGPU::Constant::kCurrentProgram},
{"NEVER", V8WebGLRenderingContextWebGPU::Constant::kNever},
{"LESS", V8WebGLRenderingContextWebGPU::Constant::kLess},
{"EQUAL", V8WebGLRenderingContextWebGPU::Constant::kEqual},
{"LEQUAL", V8WebGLRenderingContextWebGPU::Constant::kLequal},
{"GREATER", V8WebGLRenderingContextWebGPU::Constant::kGreater},
{"NOTEQUAL", V8WebGLRenderingContextWebGPU::Constant::kNotequal},
{"GEQUAL", V8WebGLRenderingContextWebGPU::Constant::kGequal},
{"ALWAYS", V8WebGLRenderingContextWebGPU::Constant::kAlways},
{"KEEP", V8WebGLRenderingContextWebGPU::Constant::kKeep},
{"REPLACE", V8WebGLRenderingContextWebGPU::Constant::kReplace},
{"INCR", V8WebGLRenderingContextWebGPU::Constant::kIncr},
{"DECR", V8WebGLRenderingContextWebGPU::Constant::kDecr},
{"INVERT", V8WebGLRenderingContextWebGPU::Constant::kInvert},
{"INCR_WRAP", V8WebGLRenderingContextWebGPU::Constant::kIncrWrap},
{"DECR_WRAP", V8WebGLRenderingContextWebGPU::Constant::kDecrWrap},
{"VENDOR", V8WebGLRenderingContextWebGPU::Constant::kVendor},
{"RENDERER", V8WebGLRenderingContextWebGPU::Constant::kRenderer},
{"VERSION", V8WebGLRenderingContextWebGPU::Constant::kVersion},
{"NEAREST", V8WebGLRenderingContextWebGPU::Constant::kNearest},
{"LINEAR", V8WebGLRenderingContextWebGPU::Constant::kLinear},
{"NEAREST_MIPMAP_NEAREST", V8WebGLRenderingContextWebGPU::Constant::kNearestMipmapNearest},
{"LINEAR_MIPMAP_NEAREST", V8WebGLRenderingContextWebGPU::Constant::kLinearMipmapNearest},
{"NEAREST_MIPMAP_LINEAR", V8WebGLRenderingContextWebGPU::Constant::kNearestMipmapLinear},
{"LINEAR_MIPMAP_LINEAR", V8WebGLRenderingContextWebGPU::Constant::kLinearMipmapLinear},
{"TEXTURE_MAG_FILTER", V8WebGLRenderingContextWebGPU::Constant::kTextureMagFilter},
{"TEXTURE_MIN_FILTER", V8WebGLRenderingContextWebGPU::Constant::kTextureMinFilter},
{"TEXTURE_WRAP_S", V8WebGLRenderingContextWebGPU::Constant::kTextureWrapS},
{"TEXTURE_WRAP_T", V8WebGLRenderingContextWebGPU::Constant::kTextureWrapT},
{"TEXTURE", V8WebGLRenderingContextWebGPU::Constant::kTexture},
{"TEXTURE_CUBE_MAP", V8WebGLRenderingContextWebGPU::Constant::kTextureCubeMap},
{"TEXTURE_BINDING_CUBE_MAP", V8WebGLRenderingContextWebGPU::Constant::kTextureBindingCubeMap},
{"TEXTURE_CUBE_MAP_POSITIVE_X", V8WebGLRenderingContextWebGPU::Constant::kTextureCubeMapPositiveX},
{"TEXTURE_CUBE_MAP_NEGATIVE_X", V8WebGLRenderingContextWebGPU::Constant::kTextureCubeMapNegativeX},
{"TEXTURE_CUBE_MAP_POSITIVE_Y", V8WebGLRenderingContextWebGPU::Constant::kTextureCubeMapPositiveY},
{"TEXTURE_CUBE_MAP_NEGATIVE_Y", V8WebGLRenderingContextWebGPU::Constant::kTextureCubeMapNegativeY},
{"TEXTURE_CUBE_MAP_POSITIVE_Z", V8WebGLRenderingContextWebGPU::Constant::kTextureCubeMapPositiveZ},
{"TEXTURE_CUBE_MAP_NEGATIVE_Z", V8WebGLRenderingContextWebGPU::Constant::kTextureCubeMapNegativeZ},
{"MAX_CUBE_MAP_TEXTURE_SIZE", V8WebGLRenderingContextWebGPU::Constant::kMaxCubeMapTextureSize},
{"TEXTURE0", V8WebGLRenderingContextWebGPU::Constant::kTexture0},
{"TEXTURE1", V8WebGLRenderingContextWebGPU::Constant::kTexture1},
{"TEXTURE2", V8WebGLRenderingContextWebGPU::Constant::kTexture2},
{"TEXTURE3", V8WebGLRenderingContextWebGPU::Constant::kTexture3},
{"TEXTURE4", V8WebGLRenderingContextWebGPU::Constant::kTexture4},
{"TEXTURE5", V8WebGLRenderingContextWebGPU::Constant::kTexture5},
{"TEXTURE6", V8WebGLRenderingContextWebGPU::Constant::kTexture6},
{"TEXTURE7", V8WebGLRenderingContextWebGPU::Constant::kTexture7},
{"TEXTURE8", V8WebGLRenderingContextWebGPU::Constant::kTexture8},
{"TEXTURE9", V8WebGLRenderingContextWebGPU::Constant::kTexture9},
{"TEXTURE10", V8WebGLRenderingContextWebGPU::Constant::kTexture10},
{"TEXTURE11", V8WebGLRenderingContextWebGPU::Constant::kTexture11},
{"TEXTURE12", V8WebGLRenderingContextWebGPU::Constant::kTexture12},
{"TEXTURE13", V8WebGLRenderingContextWebGPU::Constant::kTexture13},
{"TEXTURE14", V8WebGLRenderingContextWebGPU::Constant::kTexture14},
{"TEXTURE15", V8WebGLRenderingContextWebGPU::Constant::kTexture15},
{"TEXTURE16", V8WebGLRenderingContextWebGPU::Constant::kTexture16},
{"TEXTURE17", V8WebGLRenderingContextWebGPU::Constant::kTexture17},
{"TEXTURE18", V8WebGLRenderingContextWebGPU::Constant::kTexture18},
{"TEXTURE19", V8WebGLRenderingContextWebGPU::Constant::kTexture19},
{"TEXTURE20", V8WebGLRenderingContextWebGPU::Constant::kTexture20},
{"TEXTURE21", V8WebGLRenderingContextWebGPU::Constant::kTexture21},
{"TEXTURE22", V8WebGLRenderingContextWebGPU::Constant::kTexture22},
{"TEXTURE23", V8WebGLRenderingContextWebGPU::Constant::kTexture23},
{"TEXTURE24", V8WebGLRenderingContextWebGPU::Constant::kTexture24},
{"TEXTURE25", V8WebGLRenderingContextWebGPU::Constant::kTexture25},
{"TEXTURE26", V8WebGLRenderingContextWebGPU::Constant::kTexture26},
{"TEXTURE27", V8WebGLRenderingContextWebGPU::Constant::kTexture27},
{"TEXTURE28", V8WebGLRenderingContextWebGPU::Constant::kTexture28},
{"TEXTURE29", V8WebGLRenderingContextWebGPU::Constant::kTexture29},
{"TEXTURE30", V8WebGLRenderingContextWebGPU::Constant::kTexture30},
{"TEXTURE31", V8WebGLRenderingContextWebGPU::Constant::kTexture31},
{"ACTIVE_TEXTURE", V8WebGLRenderingContextWebGPU::Constant::kActiveTexture},
{"REPEAT", V8WebGLRenderingContextWebGPU::Constant::kRepeat},
{"CLAMP_TO_EDGE", V8WebGLRenderingContextWebGPU::Constant::kClampToEdge},
{"MIRRORED_REPEAT", V8WebGLRenderingContextWebGPU::Constant::kMirroredRepeat},
{"FLOAT_VEC2", V8WebGLRenderingContextWebGPU::Constant::kFloatVec2},
{"FLOAT_VEC3", V8WebGLRenderingContextWebGPU::Constant::kFloatVec3},
{"FLOAT_VEC4", V8WebGLRenderingContextWebGPU::Constant::kFloatVec4},
{"INT_VEC2", V8WebGLRenderingContextWebGPU::Constant::kIntVec2},
{"INT_VEC3", V8WebGLRenderingContextWebGPU::Constant::kIntVec3},
{"INT_VEC4", V8WebGLRenderingContextWebGPU::Constant::kIntVec4},
{"BOOL", V8WebGLRenderingContextWebGPU::Constant::kBool},
{"BOOL_VEC2", V8WebGLRenderingContextWebGPU::Constant::kBoolVec2},
{"BOOL_VEC3", V8WebGLRenderingContextWebGPU::Constant::kBoolVec3},
{"BOOL_VEC4", V8WebGLRenderingContextWebGPU::Constant::kBoolVec4},
{"FLOAT_MAT2", V8WebGLRenderingContextWebGPU::Constant::kFloatMat2},
{"FLOAT_MAT3", V8WebGLRenderingContextWebGPU::Constant::kFloatMat3},
{"FLOAT_MAT4", V8WebGLRenderingContextWebGPU::Constant::kFloatMat4},
{"SAMPLER_2D", V8WebGLRenderingContextWebGPU::Constant::kSampler2d},
{"SAMPLER_CUBE", V8WebGLRenderingContextWebGPU::Constant::kSamplerCube},
{"VERTEX_ATTRIB_ARRAY_ENABLED", V8WebGLRenderingContextWebGPU::Constant::kVertexAttribArrayEnabled},
{"VERTEX_ATTRIB_ARRAY_SIZE", V8WebGLRenderingContextWebGPU::Constant::kVertexAttribArraySize},
{"VERTEX_ATTRIB_ARRAY_STRIDE", V8WebGLRenderingContextWebGPU::Constant::kVertexAttribArrayStride},
{"VERTEX_ATTRIB_ARRAY_TYPE", V8WebGLRenderingContextWebGPU::Constant::kVertexAttribArrayType},
{"VERTEX_ATTRIB_ARRAY_NORMALIZED", V8WebGLRenderingContextWebGPU::Constant::kVertexAttribArrayNormalized},
{"VERTEX_ATTRIB_ARRAY_POINTER", V8WebGLRenderingContextWebGPU::Constant::kVertexAttribArrayPointer},
{"VERTEX_ATTRIB_ARRAY_BUFFER_BINDING", V8WebGLRenderingContextWebGPU::Constant::kVertexAttribArrayBufferBinding},
{"IMPLEMENTATION_COLOR_READ_TYPE", V8WebGLRenderingContextWebGPU::Constant::kImplementationColorReadType},
{"IMPLEMENTATION_COLOR_READ_FORMAT", V8WebGLRenderingContextWebGPU::Constant::kImplementationColorReadFormat},
{"COMPILE_STATUS", V8WebGLRenderingContextWebGPU::Constant::kCompileStatus},
{"LOW_FLOAT", V8WebGLRenderingContextWebGPU::Constant::kLowFloat},
{"MEDIUM_FLOAT", V8WebGLRenderingContextWebGPU::Constant::kMediumFloat},
{"HIGH_FLOAT", V8WebGLRenderingContextWebGPU::Constant::kHighFloat},
{"LOW_INT", V8WebGLRenderingContextWebGPU::Constant::kLowInt},
{"MEDIUM_INT", V8WebGLRenderingContextWebGPU::Constant::kMediumInt},
{"HIGH_INT", V8WebGLRenderingContextWebGPU::Constant::kHighInt},
{"FRAMEBUFFER", V8WebGLRenderingContextWebGPU::Constant::kFramebuffer},
{"RENDERBUFFER", V8WebGLRenderingContextWebGPU::Constant::kRenderbuffer},
{"RGBA4", V8WebGLRenderingContextWebGPU::Constant::kRgba4},
{"RGB5_A1", V8WebGLRenderingContextWebGPU::Constant::kRgb5A1},
{"RGB565", V8WebGLRenderingContextWebGPU::Constant::kRgb565},
{"DEPTH_COMPONENT16", V8WebGLRenderingContextWebGPU::Constant::kDepthComponent16},
{"STENCIL_INDEX8", V8WebGLRenderingContextWebGPU::Constant::kStencilIndex8},
{"DEPTH_STENCIL", V8WebGLRenderingContextWebGPU::Constant::kDepthStencil},
{"RENDERBUFFER_WIDTH", V8WebGLRenderingContextWebGPU::Constant::kRenderbufferWidth},
{"RENDERBUFFER_HEIGHT", V8WebGLRenderingContextWebGPU::Constant::kRenderbufferHeight},
{"RENDERBUFFER_INTERNAL_FORMAT", V8WebGLRenderingContextWebGPU::Constant::kRenderbufferInternalFormat},
{"RENDERBUFFER_RED_SIZE", V8WebGLRenderingContextWebGPU::Constant::kRenderbufferRedSize},
{"RENDERBUFFER_GREEN_SIZE", V8WebGLRenderingContextWebGPU::Constant::kRenderbufferGreenSize},
{"RENDERBUFFER_BLUE_SIZE", V8WebGLRenderingContextWebGPU::Constant::kRenderbufferBlueSize},
{"RENDERBUFFER_ALPHA_SIZE", V8WebGLRenderingContextWebGPU::Constant::kRenderbufferAlphaSize},
{"RENDERBUFFER_DEPTH_SIZE", V8WebGLRenderingContextWebGPU::Constant::kRenderbufferDepthSize},
{"RENDERBUFFER_STENCIL_SIZE", V8WebGLRenderingContextWebGPU::Constant::kRenderbufferStencilSize},
{"FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE", V8WebGLRenderingContextWebGPU::Constant::kFramebufferAttachmentObjectType},
{"FRAMEBUFFER_ATTACHMENT_OBJECT_NAME", V8WebGLRenderingContextWebGPU::Constant::kFramebufferAttachmentObjectName},
{"FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL", V8WebGLRenderingContextWebGPU::Constant::kFramebufferAttachmentTextureLevel},
{"FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE", V8WebGLRenderingContextWebGPU::Constant::kFramebufferAttachmentTextureCubeMapFace},
{"COLOR_ATTACHMENT0", V8WebGLRenderingContextWebGPU::Constant::kColorAttachment0},
{"DEPTH_ATTACHMENT", V8WebGLRenderingContextWebGPU::Constant::kDepthAttachment},
{"STENCIL_ATTACHMENT", V8WebGLRenderingContextWebGPU::Constant::kStencilAttachment},
{"DEPTH_STENCIL_ATTACHMENT", V8WebGLRenderingContextWebGPU::Constant::kDepthStencilAttachment},
{"NONE", V8WebGLRenderingContextWebGPU::Constant::kNone},
{"FRAMEBUFFER_COMPLETE", V8WebGLRenderingContextWebGPU::Constant::kFramebufferComplete},
{"FRAMEBUFFER_INCOMPLETE_ATTACHMENT", V8WebGLRenderingContextWebGPU::Constant::kFramebufferIncompleteAttachment},
{"FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT", V8WebGLRenderingContextWebGPU::Constant::kFramebufferIncompleteMissingAttachment},
{"FRAMEBUFFER_INCOMPLETE_DIMENSIONS", V8WebGLRenderingContextWebGPU::Constant::kFramebufferIncompleteDimensions},
{"FRAMEBUFFER_UNSUPPORTED", V8WebGLRenderingContextWebGPU::Constant::kFramebufferUnsupported},
{"FRAMEBUFFER_BINDING", V8WebGLRenderingContextWebGPU::Constant::kFramebufferBinding},
{"RENDERBUFFER_BINDING", V8WebGLRenderingContextWebGPU::Constant::kRenderbufferBinding},
{"MAX_RENDERBUFFER_SIZE", V8WebGLRenderingContextWebGPU::Constant::kMaxRenderbufferSize},
{"INVALID_FRAMEBUFFER_OPERATION", V8WebGLRenderingContextWebGPU::Constant::kInvalidFramebufferOperation},
{"UNPACK_FLIP_Y_WEBGL", V8WebGLRenderingContextWebGPU::Constant::kUnpackFlipYWebgl},
{"UNPACK_PREMULTIPLY_ALPHA_WEBGL", V8WebGLRenderingContextWebGPU::Constant::kUnpackPremultiplyAlphaWebgl},
{"CONTEXT_LOST_WEBGL", V8WebGLRenderingContextWebGPU::Constant::kContextLostWebgl},
{"UNPACK_COLORSPACE_CONVERSION_WEBGL", V8WebGLRenderingContextWebGPU::Constant::kUnpackColorspaceConversionWebgl},
{"BROWSER_DEFAULT_WEBGL", V8WebGLRenderingContextWebGPU::Constant::kBrowserDefaultWebgl},
};
IDLMemberInstaller::InstallConstants(isolate, world, instance_template, prototype_template, interface_template, signature, kConstantValueTable);
}



{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"activeTexture", ActiveTextureOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"attachShader", AttachShaderOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"bindAttribLocation", BindAttribLocationOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"bindRenderbuffer", BindRenderbufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"blendColor", BlendColorOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"blendEquation", BlendEquationOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"blendEquationSeparate", BlendEquationSeparateOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"blendFunc", BlendFuncOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"blendFuncSeparate", BlendFuncSeparateOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"bufferData", BufferDataOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"bufferSubData", BufferSubDataOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"checkFramebufferStatus", CheckFramebufferStatusOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"compileShader", CompileShaderOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"compressedTexImage2D", CompressedTexImage2DOperationCallback, 7, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"compressedTexSubImage2D", CompressedTexSubImage2DOperationCallback, 8, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"copyTexImage2D", CopyTexImage2DOperationCallback, 8, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"copyTexSubImage2D", CopyTexSubImage2DOperationCallback, 8, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createBuffer", CreateBufferOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createFramebuffer", CreateFramebufferOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createProgram", CreateProgramOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createRenderbuffer", CreateRenderbufferOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createShader", CreateShaderOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createTexture", CreateTextureOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"cullFace", CullFaceOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteBuffer", DeleteBufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteFramebuffer", DeleteFramebufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteProgram", DeleteProgramOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteRenderbuffer", DeleteRenderbufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteShader", DeleteShaderOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteTexture", DeleteTextureOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"depthFunc", DepthFuncOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"depthMask", DepthMaskOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"depthRange", DepthRangeOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"detachShader", DetachShaderOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"disable", DisableOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"enable", EnableOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"finish", FinishOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"flush", FlushOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"framebufferRenderbuffer", FramebufferRenderbufferOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"framebufferTexture2D", FramebufferTexture2DOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"frontFace", FrontFaceOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"generateMipmap", GenerateMipmapOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getActiveAttrib", GetActiveAttribOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getActiveUniform", GetActiveUniformOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getAttachedShaders", GetAttachedShadersOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getAttribLocation", GetAttribLocationOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getBufferParameter", GetBufferParameterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getContextAttributes", GetContextAttributesOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getError", GetErrorOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getExtension", GetExtensionOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getFramebufferAttachmentParameter", GetFramebufferAttachmentParameterOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getParameter", GetParameterOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getProgramInfoLog", GetProgramInfoLogOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getProgramParameter", GetProgramParameterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getRenderbufferParameter", GetRenderbufferParameterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getShaderInfoLog", GetShaderInfoLogOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getShaderParameter", GetShaderParameterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getShaderPrecisionFormat", GetShaderPrecisionFormatOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getShaderSource", GetShaderSourceOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getSupportedExtensions", GetSupportedExtensionsOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getTexParameter", GetTexParameterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getUniform", GetUniformOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getUniformLocation", GetUniformLocationOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getVertexAttrib", GetVertexAttribOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getVertexAttribOffset", GetVertexAttribOffsetOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"hint", HintOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"initAsync", InitAsyncOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isBuffer", IsBufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isContextLost", IsContextLostOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isEnabled", IsEnabledOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isFramebuffer", IsFramebufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isProgram", IsProgramOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isRenderbuffer", IsRenderbufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isShader", IsShaderOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isTexture", IsTextureOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"lineWidth", LineWidthOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"linkProgram", LinkProgramOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"pixelStorei", PixelStoreiOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"polygonOffset", PolygonOffsetOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"readPixels", ReadPixelsOperationCallback, 7, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"renderbufferStorage", RenderbufferStorageOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"sampleCoverage", SampleCoverageOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"shaderSource", ShaderSourceOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stencilFunc", StencilFuncOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stencilFuncSeparate", StencilFuncSeparateOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stencilMask", StencilMaskOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stencilMaskSeparate", StencilMaskSeparateOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stencilOp", StencilOpOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stencilOpSeparate", StencilOpSeparateOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texImage2D", TexImage2DOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texParameterf", TexParameterfOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texParameteri", TexParameteriOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texSubImage2D", TexSubImage2DOperationCallback, 7, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"useProgram", UseProgramOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"validateProgram", ValidateProgramOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGLRenderingContextWebGPU", kOperationTable);
}


{
  static const v8::CFunction kNoAllocDirectCallOverloadsOfBindBuffer[] = {
v8::CFunctionBuilder().Fn(BindBufferOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfBindFramebuffer[] = {
v8::CFunctionBuilder().Fn(BindFramebufferOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfBindTexture[] = {
v8::CFunctionBuilder().Fn(BindTextureOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClear[] = {
v8::CFunctionBuilder().Fn(ClearOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClearColor[] = {
v8::CFunctionBuilder().Fn(ClearColorOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClearDepth[] = {
v8::CFunctionBuilder().Fn(ClearDepthOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClearStencil[] = {
v8::CFunctionBuilder().Fn(ClearStencilOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfColorMask[] = {
v8::CFunctionBuilder().Fn(ColorMaskOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDisableVertexAttribArray[] = {
v8::CFunctionBuilder().Fn(DisableVertexAttribArrayOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDrawArrays[] = {
v8::CFunctionBuilder().Fn(DrawArraysOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDrawElements[] = {
v8::CFunctionBuilder().Fn(DrawElementsOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfEnableVertexAttribArray[] = {
v8::CFunctionBuilder().Fn(EnableVertexAttribArrayOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfScissor[] = {
v8::CFunctionBuilder().Fn(ScissorOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform1F[] = {
v8::CFunctionBuilder().Fn(Uniform1FOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform1Fv[] = {
v8::CFunctionBuilder().Fn(Uniform1FvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform1I[] = {
v8::CFunctionBuilder().Fn(Uniform1IOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform1Iv[] = {
v8::CFunctionBuilder().Fn(Uniform1IvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform2F[] = {
v8::CFunctionBuilder().Fn(Uniform2FOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform2Fv[] = {
v8::CFunctionBuilder().Fn(Uniform2FvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform2I[] = {
v8::CFunctionBuilder().Fn(Uniform2IOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform2Iv[] = {
v8::CFunctionBuilder().Fn(Uniform2IvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform3F[] = {
v8::CFunctionBuilder().Fn(Uniform3FOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform3Fv[] = {
v8::CFunctionBuilder().Fn(Uniform3FvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform3I[] = {
v8::CFunctionBuilder().Fn(Uniform3IOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform3Iv[] = {
v8::CFunctionBuilder().Fn(Uniform3IvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform4F[] = {
v8::CFunctionBuilder().Fn(Uniform4FOperationNoAllocDirectCallArg5).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform4Fv[] = {
v8::CFunctionBuilder().Fn(Uniform4FvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform4I[] = {
v8::CFunctionBuilder().Fn(Uniform4IOperationNoAllocDirectCallArg5).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform4Iv[] = {
v8::CFunctionBuilder().Fn(Uniform4IvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniformMatrix2Fv[] = {
v8::CFunctionBuilder().Fn(UniformMatrix2FvOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniformMatrix3Fv[] = {
v8::CFunctionBuilder().Fn(UniformMatrix3FvOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniformMatrix4Fv[] = {
v8::CFunctionBuilder().Fn(UniformMatrix4FvOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib1F[] = {
v8::CFunctionBuilder().Fn(VertexAttrib1FOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib1Fv[] = {
v8::CFunctionBuilder().Fn(VertexAttrib1FvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib2F[] = {
v8::CFunctionBuilder().Fn(VertexAttrib2FOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib2Fv[] = {
v8::CFunctionBuilder().Fn(VertexAttrib2FvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib3F[] = {
v8::CFunctionBuilder().Fn(VertexAttrib3FOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib3Fv[] = {
v8::CFunctionBuilder().Fn(VertexAttrib3FvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib4F[] = {
v8::CFunctionBuilder().Fn(VertexAttrib4FOperationNoAllocDirectCallArg5).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib4Fv[] = {
v8::CFunctionBuilder().Fn(VertexAttrib4FvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttribPointer[] = {
v8::CFunctionBuilder().Fn(VertexAttribPointerOperationNoAllocDirectCallArg6).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfViewport[] = {
v8::CFunctionBuilder().Fn(ViewportOperationNoAllocDirectCallArg4).Build(),
};

static const IDLMemberInstaller::NoAllocDirectCallOperationConfig kOperationTable[] = {
{{"bindBuffer", BindBufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfBindBuffer, std::size(kNoAllocDirectCallOverloadsOfBindBuffer)}, 
{{"bindFramebuffer", BindFramebufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfBindFramebuffer, std::size(kNoAllocDirectCallOverloadsOfBindFramebuffer)}, 
{{"bindTexture", BindTextureOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfBindTexture, std::size(kNoAllocDirectCallOverloadsOfBindTexture)}, 
{{"clear", ClearOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClear, std::size(kNoAllocDirectCallOverloadsOfClear)}, 
{{"clearColor", ClearColorOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClearColor, std::size(kNoAllocDirectCallOverloadsOfClearColor)}, 
{{"clearDepth", ClearDepthOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClearDepth, std::size(kNoAllocDirectCallOverloadsOfClearDepth)}, 
{{"clearStencil", ClearStencilOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClearStencil, std::size(kNoAllocDirectCallOverloadsOfClearStencil)}, 
{{"colorMask", ColorMaskOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfColorMask, std::size(kNoAllocDirectCallOverloadsOfColorMask)}, 
{{"disableVertexAttribArray", DisableVertexAttribArrayOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDisableVertexAttribArray, std::size(kNoAllocDirectCallOverloadsOfDisableVertexAttribArray)}, 
{{"drawArrays", DrawArraysOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDrawArrays, std::size(kNoAllocDirectCallOverloadsOfDrawArrays)}, 
{{"drawElements", DrawElementsOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDrawElements, std::size(kNoAllocDirectCallOverloadsOfDrawElements)}, 
{{"enableVertexAttribArray", EnableVertexAttribArrayOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfEnableVertexAttribArray, std::size(kNoAllocDirectCallOverloadsOfEnableVertexAttribArray)}, 
{{"scissor", ScissorOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfScissor, std::size(kNoAllocDirectCallOverloadsOfScissor)}, 
{{"uniform1f", Uniform1FOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform1F, std::size(kNoAllocDirectCallOverloadsOfUniform1F)}, 
{{"uniform1fv", Uniform1FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform1Fv, std::size(kNoAllocDirectCallOverloadsOfUniform1Fv)}, 
{{"uniform1i", Uniform1IOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform1I, std::size(kNoAllocDirectCallOverloadsOfUniform1I)}, 
{{"uniform1iv", Uniform1IvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform1Iv, std::size(kNoAllocDirectCallOverloadsOfUniform1Iv)}, 
{{"uniform2f", Uniform2FOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform2F, std::size(kNoAllocDirectCallOverloadsOfUniform2F)}, 
{{"uniform2fv", Uniform2FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform2Fv, std::size(kNoAllocDirectCallOverloadsOfUniform2Fv)}, 
{{"uniform2i", Uniform2IOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform2I, std::size(kNoAllocDirectCallOverloadsOfUniform2I)}, 
{{"uniform2iv", Uniform2IvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform2Iv, std::size(kNoAllocDirectCallOverloadsOfUniform2Iv)}, 
{{"uniform3f", Uniform3FOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform3F, std::size(kNoAllocDirectCallOverloadsOfUniform3F)}, 
{{"uniform3fv", Uniform3FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform3Fv, std::size(kNoAllocDirectCallOverloadsOfUniform3Fv)}, 
{{"uniform3i", Uniform3IOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform3I, std::size(kNoAllocDirectCallOverloadsOfUniform3I)}, 
{{"uniform3iv", Uniform3IvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform3Iv, std::size(kNoAllocDirectCallOverloadsOfUniform3Iv)}, 
{{"uniform4f", Uniform4FOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform4F, std::size(kNoAllocDirectCallOverloadsOfUniform4F)}, 
{{"uniform4fv", Uniform4FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform4Fv, std::size(kNoAllocDirectCallOverloadsOfUniform4Fv)}, 
{{"uniform4i", Uniform4IOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform4I, std::size(kNoAllocDirectCallOverloadsOfUniform4I)}, 
{{"uniform4iv", Uniform4IvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform4Iv, std::size(kNoAllocDirectCallOverloadsOfUniform4Iv)}, 
{{"uniformMatrix2fv", UniformMatrix2FvOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniformMatrix2Fv, std::size(kNoAllocDirectCallOverloadsOfUniformMatrix2Fv)}, 
{{"uniformMatrix3fv", UniformMatrix3FvOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniformMatrix3Fv, std::size(kNoAllocDirectCallOverloadsOfUniformMatrix3Fv)}, 
{{"uniformMatrix4fv", UniformMatrix4FvOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniformMatrix4Fv, std::size(kNoAllocDirectCallOverloadsOfUniformMatrix4Fv)}, 
{{"vertexAttrib1f", VertexAttrib1FOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib1F, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib1F)}, 
{{"vertexAttrib1fv", VertexAttrib1FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib1Fv, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib1Fv)}, 
{{"vertexAttrib2f", VertexAttrib2FOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib2F, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib2F)}, 
{{"vertexAttrib2fv", VertexAttrib2FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib2Fv, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib2Fv)}, 
{{"vertexAttrib3f", VertexAttrib3FOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib3F, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib3F)}, 
{{"vertexAttrib3fv", VertexAttrib3FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib3Fv, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib3Fv)}, 
{{"vertexAttrib4f", VertexAttrib4FOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib4F, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib4F)}, 
{{"vertexAttrib4fv", VertexAttrib4FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib4Fv, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib4Fv)}, 
{{"vertexAttribPointer", VertexAttribPointerOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttribPointer, std::size(kNoAllocDirectCallOverloadsOfVertexAttribPointer)}, 
{{"viewport", ViewportOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfViewport, std::size(kNoAllocDirectCallOverloadsOfViewport)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGLRenderingContextWebGPU", kOperationTable);
}


}

void V8WebGLRenderingContextWebGPU::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::WebGLDrawingBufferStorageEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"drawingBufferFormat", DrawingBufferFormatAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGLRenderingContextWebGPU", kAttributeTable);
}


if (RuntimeEnabledFeatures::WebGLDrawingBufferStorageEnabled()) {
  static const IDLMemberInstaller::ConstantValueConfig kConstantValueTable[] = {
{"RGB8", V8WebGLRenderingContextWebGPU::Constant::kRgb8},
{"RGBA8", V8WebGLRenderingContextWebGPU::Constant::kRgba8},
};
IDLMemberInstaller::InstallConstants(isolate, world, instance_template, prototype_template, interface_template, signature, kConstantValueTable);
}


if (RuntimeEnabledFeatures::WebGLDrawingBufferStorageEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"drawingBufferStorage", DrawingBufferStorageOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGLRenderingContextWebGPU", kOperationTable);
}
if (RuntimeEnabledFeatures::CanvasDrawElementEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"setHitTestRegions", SetHitTestRegionsOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texElement2D", TexElement2DOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texElementImage2D", TexElementImage2DOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGLRenderingContextWebGPU", kOperationTable);
}


}

void V8WebGLRenderingContextWebGPU::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;





v8::Isolate* isolate = v8::Isolate::GetCurrent();
ScriptState* script_state = ScriptState::From(isolate, context);
ExecutionContext* execution_context = ToExecutionContext(script_state);
const bool is_in_secure_context = execution_context->IsSecureContext();
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebXREnabled())) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"makeXRCompatible", MakeXRCompatibleOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "WebGLRenderingContextWebGPU", kOperationTable);
}


}


}  // namespace blink
