// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl2_rendering_context.h"

#include "third_party/blink/public/mojom/origin_trials/origin_trial_feature.mojom-shared.h"
#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/is_return_type_compatible.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_canvas_element_hit_test_region.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_canvas_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_image_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_html_video_element.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_bitmap.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_image_data.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_offscreen_canvas.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_predefined_color_space.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_set_return_value_for_core.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_arraybuffer_arraybufferview.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_union_htmlcanvaselement_offscreencanvas.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_frame.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_active_info.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_buffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_context_attributes.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_framebuffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_program.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_query.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_renderbuffer.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_sampler.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_shader.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_shader_precision_format.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_sync.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_texture.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_transform_feedback.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_uniform_location.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_webgl_vertex_array_object.h"
#include "third_party/blink/renderer/core/dom/element.h"
#include "third_party/blink/renderer/core/execution_context/execution_context.h"
#include "third_party/blink/renderer/core/frame/dactyloscoper.h"
#include "third_party/blink/renderer/core/frame/web_feature.h"
#include "third_party/blink/renderer/core/html/canvas/html_canvas_element.h"
#include "third_party/blink/renderer/core/html/canvas/image_data.h"
#include "third_party/blink/renderer/core/html/html_image_element.h"
#include "third_party/blink/renderer/core/html/media/html_video_element.h"
#include "third_party/blink/renderer/core/imagebitmap/image_bitmap.h"
#include "third_party/blink/renderer/core/offscreencanvas/offscreen_canvas.h"
#include "third_party/blink/renderer/modules/webcodecs/video_frame.h"
#include "third_party/blink/renderer/modules/webgl/webgl2_rendering_context.h"
#include "third_party/blink/renderer/modules/webgl/webgl_active_info.h"
#include "third_party/blink/renderer/modules/webgl/webgl_buffer.h"
#include "third_party/blink/renderer/modules/webgl/webgl_framebuffer.h"
#include "third_party/blink/renderer/modules/webgl/webgl_program.h"
#include "third_party/blink/renderer/modules/webgl/webgl_query.h"
#include "third_party/blink/renderer/modules/webgl/webgl_renderbuffer.h"
#include "third_party/blink/renderer/modules/webgl/webgl_sampler.h"
#include "third_party/blink/renderer/modules/webgl/webgl_shader.h"
#include "third_party/blink/renderer/modules/webgl/webgl_shader_precision_format.h"
#include "third_party/blink/renderer/modules/webgl/webgl_sync.h"
#include "third_party/blink/renderer/modules/webgl/webgl_texture.h"
#include "third_party/blink/renderer/modules/webgl/webgl_transform_feedback.h"
#include "third_party/blink/renderer/modules/webgl/webgl_uniform_location.h"
#include "third_party/blink/renderer/modules/webgl/webgl_vertex_array_object.h"
#include "third_party/blink/renderer/platform/bindings/active_script_wrappable_base.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/idl_member_installer.h"
#include "third_party/blink/renderer/platform/bindings/runtime_call_stats.h"
#include "third_party/blink/renderer/platform/bindings/v8_binding.h"
#include "third_party/blink/renderer/platform/bindings/wrapper_type_info.h"
#include "third_party/blink/renderer/platform/instrumentation/use_counter.h"

namespace blink {



bool V8WebGL2RenderingContext::IsExposed(ExecutionContext* execution_context) {
  
return execution_context->IsWindow() || execution_context->IsWorkerGlobalScope();
}

// Construction of WrapperTypeInfo may require non-trivial initialization due
// to cross-component address resolution in order to load the pointer to the
// parent interface's WrapperTypeInfo.  We ignore this issue because the issue
// happens only on component builds and the official release builds
// (statically-linked builds) are never affected by this issue.
#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wglobal-constructors"
#endif

const WrapperTypeInfo V8WebGL2RenderingContext::wrapper_type_info_{
    {gin::kEmbedderBlink},
    V8WebGL2RenderingContext::InstallInterfaceTemplate,
    V8WebGL2RenderingContext::InstallContextDependentProperties,
    "WebGL2RenderingContext",
    nullptr,
    V8WebGL2RenderingContext::kThisTag,
    V8WebGL2RenderingContext::kMaxSubclassTag,
    WrapperTypeInfo::kWrapperTypeObjectPrototype,
    WrapperTypeInfo::kObjectClassId,
    WrapperTypeInfo::kIdlInterface,
    false,
};

#if defined(COMPONENT_BUILD) && defined(WIN32) && defined(__clang__)
#pragma clang diagnostic pop
#endif

const WrapperTypeInfo& WebGL2RenderingContext::wrapper_type_info_ =
    V8WebGL2RenderingContext::wrapper_type_info_;

// [ActiveScriptWrappable]
static_assert(
    std::is_base_of<ActiveScriptWrappableBase, WebGL2RenderingContext>::value,
    "WebGL2RenderingContext does not inherit from ActiveScriptWrappable<> despite "
    "the IDL has [ActiveScriptWrappable] extended attribute.");

namespace  {

namespace v8_webgl2_rendering_context {


void CanvasAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_canvas_Getter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.canvas.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getHTMLOrOffscreenCanvas();
static_assert(bindings::IsReturnTypeCompatible<V8UnionHTMLCanvasElementOrOffscreenCanvas, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<V8UnionHTMLCanvasElementOrOffscreenCanvas>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}



void DrawingBufferWidthAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_drawingBufferWidth_Getter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.drawingBufferWidth.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->drawingBufferWidth();
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
}



void DrawingBufferHeightAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_drawingBufferHeight_Getter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.drawingBufferHeight.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->drawingBufferHeight();
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
}



void DrawingBufferFormatAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_drawingBufferFormat_Getter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.drawingBufferFormat.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->drawingBufferFormat();
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}



void DrawingBufferColorSpaceAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_drawingBufferColorSpace_Getter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.drawingBufferColorSpace.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->drawingBufferColorSpace(script_state);
static_assert(bindings::IsReturnTypeCompatible<V8PredefinedColorSpace, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void DrawingBufferColorSpaceAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_drawingBufferColorSpace_Setter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.drawingBufferColorSpace.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
// https://webidl.spec.whatwg.org/#dfn-attribute-setter
// step 4.6.1. Let S be ? ToString(V).
const auto&& arg1_value_string =
    NativeValueTraits<IDLString>::NativeValue(
        isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
// step 4.6.2. If S is not one of the enumeration's values, then return
//   undefined.
const auto arg1_value_maybe_enum = V8PredefinedColorSpace::Create(arg1_value_string);
if (!arg1_value_maybe_enum) {
  bindings::ReportInvalidEnumSetToAttribute(
      isolate, arg1_value_string, "PredefinedColorSpace", exception_state);
  return;  // Return undefined.
}
const auto arg1_value = arg1_value_maybe_enum.value();

blink_receiver->setDrawingBufferColorSpace(script_state, arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}


void UnpackColorSpaceAttributeGetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_unpackColorSpace_Getter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.unpackColorSpace.get");



v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
auto&& return_value = blink_receiver->unpackColorSpace(script_state);
static_assert(bindings::IsReturnTypeCompatible<V8PredefinedColorSpace, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNonNullable);
}

void UnpackColorSpaceAttributeSetCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_unpackColorSpace_Setter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.unpackColorSpace.set");


v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
v8::Local<v8::Value> v8_property_value = info[0];
ExceptionState exception_state(isolate);
// https://webidl.spec.whatwg.org/#dfn-attribute-setter
// step 4.6.1. Let S be ? ToString(V).
const auto&& arg1_value_string =
    NativeValueTraits<IDLString>::NativeValue(
        isolate, v8_property_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
// step 4.6.2. If S is not one of the enumeration's values, then return
//   undefined.
const auto arg1_value_maybe_enum = V8PredefinedColorSpace::Create(arg1_value_string);
if (!arg1_value_maybe_enum) {
  bindings::ReportInvalidEnumSetToAttribute(
      isolate, arg1_value_string, "PredefinedColorSpace", exception_state);
  return;  // Return undefined.
}
const auto arg1_value = arg1_value_maybe_enum.value();

blink_receiver->setUnpackColorSpace(script_state, arg1_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void ActiveTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_activeTexture");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.activeTexture");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_texture = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->activeTexture(arg1_texture);

}

void AttachShaderOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_attachShader");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.attachShader");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_shader = NativeValueTraits<WebGLShader>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->attachShader(arg1_program, arg2_shader);

}

void BeginQueryOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_beginQuery");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.beginQuery");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_query = NativeValueTraits<WebGLQuery>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->beginQuery(arg1_target, arg2_query);

}

void BeginTransformFeedbackOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_beginTransformFeedback");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.beginTransformFeedback");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_primitive_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->beginTransformFeedback(arg1_primitive_mode);

}

void BindAttribLocationOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_bindAttribLocation");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.bindAttribLocation");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindAttribLocation(arg1_program, arg2_index, arg3_name);

}

void BindBufferOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_target, v8::Local<v8::Value> v8_arg2_buffer, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_target = v8_arg1_target;
ExceptionState exception_state(isolate);
auto&& arg2_buffer = NativeValueTraits<IDLNullable<WebGLBuffer>>::ArgumentValue(isolate, 1, v8_arg2_buffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindBuffer(arg1_target, arg2_buffer);
}

void BindBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_bindBuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.bindBuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_buffer = NativeValueTraits<IDLNullable<WebGLBuffer>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindBuffer(arg1_target, arg2_buffer);

}

void BindBufferBaseOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_bindBufferBase");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.bindBufferBase");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_buffer = NativeValueTraits<IDLNullable<WebGLBuffer>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindBufferBase(arg1_target, arg2_index, arg3_buffer);

}

void BindBufferRangeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_bindBufferRange");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.bindBufferRange");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_buffer = NativeValueTraits<IDLNullable<WebGLBuffer>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_size = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindBufferRange(arg1_target, arg2_index, arg3_buffer, arg4_offset, arg5_size);

}

void BindFramebufferOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_target, v8::Local<v8::Value> v8_arg2_framebuffer, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_target = v8_arg1_target;
ExceptionState exception_state(isolate);
auto&& arg2_framebuffer = NativeValueTraits<IDLNullable<WebGLFramebuffer>>::ArgumentValue(isolate, 1, v8_arg2_framebuffer, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindFramebuffer(arg1_target, arg2_framebuffer);
}

void BindFramebufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_bindFramebuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.bindFramebuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_framebuffer = NativeValueTraits<IDLNullable<WebGLFramebuffer>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindFramebuffer(arg1_target, arg2_framebuffer);

}

void BindRenderbufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_bindRenderbuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.bindRenderbuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_renderbuffer = NativeValueTraits<IDLNullable<WebGLRenderbuffer>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindRenderbuffer(arg1_target, arg2_renderbuffer);

}

void BindSamplerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_bindSampler");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.bindSampler");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_unit = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_sampler = NativeValueTraits<IDLNullable<WebGLSampler>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindSampler(arg1_unit, arg2_sampler);

}

void BindTextureOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_target, v8::Local<v8::Value> v8_arg2_texture, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_target = v8_arg1_target;
ExceptionState exception_state(isolate);
auto&& arg2_texture = NativeValueTraits<IDLNullable<WebGLTexture>>::ArgumentValue(isolate, 1, v8_arg2_texture, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindTexture(arg1_target, arg2_texture);
}

void BindTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_bindTexture");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.bindTexture");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_texture = NativeValueTraits<IDLNullable<WebGLTexture>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindTexture(arg1_target, arg2_texture);

}

void BindTransformFeedbackOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_bindTransformFeedback");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.bindTransformFeedback");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_feedback = NativeValueTraits<IDLNullable<WebGLTransformFeedback>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindTransformFeedback(arg1_target, arg2_feedback);

}

void BindVertexArrayOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_bindVertexArray");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.bindVertexArray");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_vertex_array = NativeValueTraits<IDLNullable<WebGLVertexArrayObject>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bindVertexArray(arg1_vertex_array);

}

void BlendColorOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_blendColor");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.blendColor");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_red = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_green = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_blue = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_alpha = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->blendColor(arg1_red, arg2_green, arg3_blue, arg4_alpha);

}

void BlendEquationOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_blendEquation");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.blendEquation");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->blendEquation(arg1_mode);

}

void BlendEquationSeparateOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_blendEquationSeparate");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.blendEquationSeparate");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode_rgb = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_mode_alpha = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->blendEquationSeparate(arg1_mode_rgb, arg2_mode_alpha);

}

void BlendFuncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_blendFunc");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.blendFunc");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sfactor = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_dfactor = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->blendFunc(arg1_sfactor, arg2_dfactor);

}

void BlendFuncSeparateOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_blendFuncSeparate");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.blendFuncSeparate");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_src_rgb = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_dst_rgb = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_alpha = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_dst_alpha = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->blendFuncSeparate(arg1_src_rgb, arg2_dst_rgb, arg3_src_alpha, arg4_dst_alpha);

}

void BlitFramebufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_blitFramebuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.blitFramebuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_src_x_0 = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_src_y_0 = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_x_1 = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_y_1 = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_dst_x_0 = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_dst_y_0 = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_dst_x_1 = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_dst_y_1 = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_mask = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_filter = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->blitFramebuffer(arg1_src_x_0, arg2_src_y_0, arg3_src_x_1, arg4_src_y_1, arg5_dst_x_0, arg6_dst_y_0, arg7_dst_x_1, arg8_dst_y_1, arg9_mask, arg10_filter);

}

void BufferDataOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_size = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_usage = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bufferData(arg1_target, arg2_size, arg3_usage);

}

void BufferDataOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_usage = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bufferData(arg1_target, arg2_data, arg3_usage);

}

void BufferDataOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_data = NativeValueTraits<IDLNullable<IDLBufferSourceTypeNoSizeLimit<DOMArrayBufferBase>>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_usage = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bufferData(arg1_target, arg2_data, arg3_usage);

}

void BufferDataOperationOverload4(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_src_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_usage = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_length{0};
if (!info[4]->IsUndefined()) {
  arg5_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->bufferData(arg1_target, arg2_src_data, arg3_usage, arg4_src_offset, arg5_length);

}

void BufferDataOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_bufferData");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.bufferData");


const int arg_count = std::min(info.Length(), 5);
if (arg_count == 5) {
  return BufferDataOperationOverload4(info);
}
if (arg_count == 4) {
  return BufferDataOperationOverload4(info);
}
if (arg_count == 3) {
  if (info[1]->IsNullOrUndefined()) {
  return BufferDataOperationOverload3(info);
}
if (info[1]->IsObject()) {
  if (info[1]->IsArrayBuffer() || info[1]->IsSharedArrayBuffer()) {
  return BufferDataOperationOverload3(info);
}
if (info[1]->IsArrayBufferView()) {
  return BufferDataOperationOverload2(info);
}
}
if (info[1]->IsNumber()) {
  return BufferDataOperationOverload1(info);
}
return BufferDataOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void BufferSubDataOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_data = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowShared, void>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->bufferSubData(arg1_target, arg2_offset, arg3_data);

}

void BufferSubDataOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_dst_byte_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_length{0};
if (!info[4]->IsUndefined()) {
  arg5_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->bufferSubData(arg1_target, arg2_dst_byte_offset, arg3_src_data, arg4_src_offset, arg5_length);

}

void BufferSubDataOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_bufferSubData");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.bufferSubData");


const int arg_count = std::min(info.Length(), 5);
if (arg_count == 5) {
  return BufferSubDataOperationOverload2(info);
}
if (arg_count == 4) {
  return BufferSubDataOperationOverload2(info);
}
if (arg_count == 3) {
  return BufferSubDataOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void CheckFramebufferStatusOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_checkFramebufferStatus");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.checkFramebufferStatus");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->checkFramebufferStatus(arg1_target);
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}

void ClearOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_mask, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_mask = v8_arg1_mask;
blink_receiver->clear(arg1_mask);
}

void ClearOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_clear");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.clear");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mask = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->clear(arg1_mask);

}

void ClearBufferfiOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_buffer, int32_t v8_arg2_drawbuffer, float v8_arg3_depth, int32_t v8_arg4_stencil, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_buffer = v8_arg1_buffer;
auto&& arg2_drawbuffer = v8_arg2_drawbuffer;
auto&& arg3_depth = v8_arg3_depth;
auto&& arg4_stencil = v8_arg4_stencil;
blink_receiver->clearBufferfi(arg1_buffer, arg2_drawbuffer, arg3_depth, arg4_stencil);
}

void ClearBufferfiOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_clearBufferfi");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.clearBufferfi");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_drawbuffer = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_depth = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_stencil = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->clearBufferfi(arg1_buffer, arg2_drawbuffer, arg3_depth, arg4_stencil);

}

void ClearBufferfvOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_buffer, int32_t v8_arg2_drawbuffer, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_buffer = v8_arg1_buffer;
auto&& arg2_drawbuffer = v8_arg2_drawbuffer;
ExceptionState exception_state(isolate);
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
blink_receiver->clearBufferfv(arg1_buffer, arg2_drawbuffer, arg3_value, arg4_src_offset);
}

void ClearBufferfvOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_buffer, int32_t v8_arg2_drawbuffer, v8::Local<v8::Value> v8_arg3_value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_buffer = v8_arg1_buffer;
auto&& arg2_drawbuffer = v8_arg2_drawbuffer;
ExceptionState exception_state(isolate);
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset{0};
blink_receiver->clearBufferfv(arg1_buffer, arg2_drawbuffer, arg3_value, arg4_src_offset);
}

void ClearBufferfvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_clearBufferfv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.clearBufferfv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_drawbuffer = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_offset{0};
if (!info[3]->IsUndefined()) {
  arg4_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->clearBufferfv(arg1_buffer, arg2_drawbuffer, arg3_value, arg4_src_offset);

}

void ClearBufferivOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_buffer, int32_t v8_arg2_drawbuffer, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_buffer = v8_arg1_buffer;
auto&& arg2_drawbuffer = v8_arg2_drawbuffer;
ExceptionState exception_state(isolate);
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
blink_receiver->clearBufferiv(arg1_buffer, arg2_drawbuffer, arg3_value, arg4_src_offset);
}

void ClearBufferivOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_buffer, int32_t v8_arg2_drawbuffer, v8::Local<v8::Value> v8_arg3_value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_buffer = v8_arg1_buffer;
auto&& arg2_drawbuffer = v8_arg2_drawbuffer;
ExceptionState exception_state(isolate);
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset{0};
blink_receiver->clearBufferiv(arg1_buffer, arg2_drawbuffer, arg3_value, arg4_src_offset);
}

void ClearBufferivOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_clearBufferiv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.clearBufferiv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_drawbuffer = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_offset{0};
if (!info[3]->IsUndefined()) {
  arg4_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->clearBufferiv(arg1_buffer, arg2_drawbuffer, arg3_value, arg4_src_offset);

}

void ClearBufferuivOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_buffer, int32_t v8_arg2_drawbuffer, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_buffer = v8_arg1_buffer;
auto&& arg2_drawbuffer = v8_arg2_drawbuffer;
ExceptionState exception_state(isolate);
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
blink_receiver->clearBufferuiv(arg1_buffer, arg2_drawbuffer, arg3_value, arg4_src_offset);
}

void ClearBufferuivOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_buffer, int32_t v8_arg2_drawbuffer, v8::Local<v8::Value> v8_arg3_value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_buffer = v8_arg1_buffer;
auto&& arg2_drawbuffer = v8_arg2_drawbuffer;
ExceptionState exception_state(isolate);
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset{0};
blink_receiver->clearBufferuiv(arg1_buffer, arg2_drawbuffer, arg3_value, arg4_src_offset);
}

void ClearBufferuivOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_clearBufferuiv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.clearBufferuiv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_drawbuffer = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_offset{0};
if (!info[3]->IsUndefined()) {
  arg4_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->clearBufferuiv(arg1_buffer, arg2_drawbuffer, arg3_value, arg4_src_offset);

}

void ClearColorOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, float v8_arg1_red, float v8_arg2_green, float v8_arg3_blue, float v8_arg4_alpha, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_red = v8_arg1_red;
auto&& arg2_green = v8_arg2_green;
auto&& arg3_blue = v8_arg3_blue;
auto&& arg4_alpha = v8_arg4_alpha;
blink_receiver->clearColor(arg1_red, arg2_green, arg3_blue, arg4_alpha);
}

void ClearColorOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_clearColor");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.clearColor");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_red = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_green = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_blue = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_alpha = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->clearColor(arg1_red, arg2_green, arg3_blue, arg4_alpha);

}

void ClearDepthOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, float v8_arg1_depth, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_depth = v8_arg1_depth;
blink_receiver->clearDepth(arg1_depth);
}

void ClearDepthOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_clearDepth");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.clearDepth");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_depth = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->clearDepth(arg1_depth);

}

void ClearStencilOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, int32_t v8_arg1_s, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_s = v8_arg1_s;
blink_receiver->clearStencil(arg1_s);
}

void ClearStencilOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_clearStencil");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.clearStencil");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_s = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->clearStencil(arg1_s);

}

void ClientWaitSyncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_clientWaitSync");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.clientWaitSync");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sync = NativeValueTraits<WebGLSync>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_flags = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_timeout = NativeValueTraits<IDLUnsignedLongLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->clientWaitSync(arg1_sync, arg2_flags, arg3_timeout);
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}

void ColorMaskOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, bool v8_arg1_red, bool v8_arg2_green, bool v8_arg3_blue, bool v8_arg4_alpha, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_red = v8_arg1_red;
auto&& arg2_green = v8_arg2_green;
auto&& arg3_blue = v8_arg3_blue;
auto&& arg4_alpha = v8_arg4_alpha;
blink_receiver->colorMask(arg1_red, arg2_green, arg3_blue, arg4_alpha);
}

void ColorMaskOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_colorMask");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.colorMask");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_red = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_green = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_blue = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_alpha = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->colorMask(arg1_red, arg2_green, arg3_blue, arg4_alpha);

}

void CompileShaderOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_compileShader");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.compileShader");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_shader = NativeValueTraits<WebGLShader>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->compileShader(arg1_shader);

}

void CompressedTexImage2DOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->compressedTexImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_data);

}

void CompressedTexImage2DOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 8) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(8, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg9_src_length_override{0};
if (!info[8]->IsUndefined()) {
  arg9_src_length_override = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->compressedTexImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_data, arg8_src_offset, arg9_src_length_override);

}

void CompressedTexImage2DOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 8) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(8, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_image_size = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->compressedTexImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_image_size, arg8_offset);

}

void CompressedTexImage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_compressedTexImage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.compressedTexImage2D");


const int arg_count = std::min(info.Length(), 9);
if (arg_count == 9) {
  return CompressedTexImage2DOperationOverload2(info);
}
if (arg_count == 8) {
  if (info[6]->IsObject()) {
  if (info[6]->IsArrayBufferView()) {
  return CompressedTexImage2DOperationOverload2(info);
}
}
if (info[6]->IsNumber()) {
  return CompressedTexImage2DOperationOverload3(info);
}
return CompressedTexImage2DOperationOverload3(info);
}
if (arg_count == 7) {
  return CompressedTexImage2DOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void CompressedTexImage3DOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 8) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(8, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg9_src_offset{0};
if (!info[8]->IsUndefined()) {
  arg9_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg10_src_length_override{0};
if (!info[9]->IsUndefined()) {
  arg10_src_length_override = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->compressedTexImage3D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_depth, arg7_border, arg8_data, arg9_src_offset, arg10_src_length_override);

}

void CompressedTexImage3DOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_image_size = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->compressedTexImage3D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_depth, arg7_border, arg8_image_size, arg9_offset);

}

void CompressedTexImage3DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_compressedTexImage3D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.compressedTexImage3D");


const int arg_count = std::min(info.Length(), 10);
if (arg_count == 10) {
  return CompressedTexImage3DOperationOverload1(info);
}
if (arg_count == 9) {
  if (info[7]->IsObject()) {
  if (info[7]->IsArrayBufferView()) {
  return CompressedTexImage3DOperationOverload1(info);
}
}
if (info[7]->IsNumber()) {
  return CompressedTexImage3DOperationOverload2(info);
}
return CompressedTexImage3DOperationOverload2(info);
}
if (arg_count == 8) {
  return CompressedTexImage3DOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 8) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(8, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void CompressedTexSubImage2DOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 8) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(8, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->compressedTexSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_data);

}

void CompressedTexSubImage2DOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg10_src_length_override{0};
if (!info[9]->IsUndefined()) {
  arg10_src_length_override = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->compressedTexSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_data, arg9_src_offset, arg10_src_length_override);

}

void CompressedTexSubImage2DOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_image_size = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->compressedTexSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_image_size, arg9_offset);

}

void CompressedTexSubImage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_compressedTexSubImage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.compressedTexSubImage2D");


const int arg_count = std::min(info.Length(), 10);
if (arg_count == 10) {
  return CompressedTexSubImage2DOperationOverload2(info);
}
if (arg_count == 9) {
  if (info[7]->IsObject()) {
  if (info[7]->IsArrayBufferView()) {
  return CompressedTexSubImage2DOperationOverload2(info);
}
}
if (info[7]->IsNumber()) {
  return CompressedTexSubImage2DOperationOverload3(info);
}
return CompressedTexSubImage2DOperationOverload3(info);
}
if (arg_count == 8) {
  return CompressedTexSubImage2DOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 8) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(8, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void CompressedTexSubImage3DOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_zoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg11_src_offset{0};
if (!info[10]->IsUndefined()) {
  arg11_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 10, info[10], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg12_src_length_override{0};
if (!info[11]->IsUndefined()) {
  arg12_src_length_override = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 11, info[11], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->compressedTexSubImage3D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_zoffset, arg6_width, arg7_height, arg8_depth, arg9_format, arg10_data, arg11_src_offset, arg12_src_length_override);

}

void CompressedTexSubImage3DOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 11) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(11, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_zoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_image_size = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg11_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 10, info[10], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->compressedTexSubImage3D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_zoffset, arg6_width, arg7_height, arg8_depth, arg9_format, arg10_image_size, arg11_offset);

}

void CompressedTexSubImage3DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_compressedTexSubImage3D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.compressedTexSubImage3D");


const int arg_count = std::min(info.Length(), 12);
if (arg_count == 12) {
  return CompressedTexSubImage3DOperationOverload1(info);
}
if (arg_count == 11) {
  if (info[9]->IsObject()) {
  if (info[9]->IsArrayBufferView()) {
  return CompressedTexSubImage3DOperationOverload1(info);
}
}
if (info[9]->IsNumber()) {
  return CompressedTexSubImage3DOperationOverload2(info);
}
return CompressedTexSubImage3DOperationOverload2(info);
}
if (arg_count == 10) {
  return CompressedTexSubImage3DOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void CopyBufferSubDataOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_copyBufferSubData");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.copyBufferSubData");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_read_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_write_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_read_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_write_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_size = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->copyBufferSubData(arg1_read_target, arg2_write_target, arg3_read_offset, arg4_write_offset, arg5_size);

}

void CopyTexImage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_copyTexImage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.copyTexImage2D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 8) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(8, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->copyTexImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_x, arg5_y, arg6_width, arg7_height, arg8_border);

}

void CopyTexSubImage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_copyTexSubImage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.copyTexSubImage2D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 8) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(8, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->copyTexSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_x, arg6_y, arg7_width, arg8_height);

}

void CopyTexSubImage3DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_copyTexSubImage3D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.copyTexSubImage3D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_zoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->copyTexSubImage3D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_zoffset, arg6_x, arg7_y, arg8_width, arg9_height);

}

void CreateBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_createBuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.createBuffer");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->createBuffer();
static_assert(bindings::IsReturnTypeCompatible<WebGLBuffer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateFramebufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_createFramebuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.createFramebuffer");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->createFramebuffer();
static_assert(bindings::IsReturnTypeCompatible<WebGLFramebuffer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateProgramOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_createProgram");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.createProgram");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->createProgram();
static_assert(bindings::IsReturnTypeCompatible<WebGLProgram, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateQueryOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_createQuery");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.createQuery");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->createQuery();
static_assert(bindings::IsReturnTypeCompatible<WebGLQuery, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateRenderbufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_createRenderbuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.createRenderbuffer");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->createRenderbuffer();
static_assert(bindings::IsReturnTypeCompatible<WebGLRenderbuffer, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateSamplerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_createSampler");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.createSampler");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->createSampler();
static_assert(bindings::IsReturnTypeCompatible<WebGLSampler, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateShaderOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_createShader");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.createShader");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->createShader(arg1_type);
static_assert(bindings::IsReturnTypeCompatible<WebGLShader, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_createTexture");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.createTexture");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->createTexture();
static_assert(bindings::IsReturnTypeCompatible<WebGLTexture, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateTransformFeedbackOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_createTransformFeedback");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.createTransformFeedback");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->createTransformFeedback();
static_assert(bindings::IsReturnTypeCompatible<WebGLTransformFeedback, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CreateVertexArrayOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_createVertexArray");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.createVertexArray");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->createVertexArray();
static_assert(bindings::IsReturnTypeCompatible<WebGLVertexArrayObject, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void CullFaceOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_cullFace");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.cullFace");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->cullFace(arg1_mode);

}

void DeleteBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_deleteBuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.deleteBuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<IDLNullable<WebGLBuffer>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteBuffer(arg1_buffer);

}

void DeleteFramebufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_deleteFramebuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.deleteFramebuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_framebuffer = NativeValueTraits<IDLNullable<WebGLFramebuffer>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteFramebuffer(arg1_framebuffer);

}

void DeleteProgramOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_deleteProgram");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.deleteProgram");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<IDLNullable<WebGLProgram>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteProgram(arg1_program);

}

void DeleteQueryOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_deleteQuery");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.deleteQuery");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_query = NativeValueTraits<IDLNullable<WebGLQuery>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteQuery(arg1_query);

}

void DeleteRenderbufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_deleteRenderbuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.deleteRenderbuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_renderbuffer = NativeValueTraits<IDLNullable<WebGLRenderbuffer>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteRenderbuffer(arg1_renderbuffer);

}

void DeleteSamplerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_deleteSampler");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.deleteSampler");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sampler = NativeValueTraits<IDLNullable<WebGLSampler>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteSampler(arg1_sampler);

}

void DeleteShaderOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_deleteShader");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.deleteShader");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_shader = NativeValueTraits<IDLNullable<WebGLShader>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteShader(arg1_shader);

}

void DeleteSyncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_deleteSync");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.deleteSync");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sync = NativeValueTraits<IDLNullable<WebGLSync>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteSync(arg1_sync);

}

void DeleteTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_deleteTexture");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.deleteTexture");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_texture = NativeValueTraits<IDLNullable<WebGLTexture>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteTexture(arg1_texture);

}

void DeleteTransformFeedbackOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_deleteTransformFeedback");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.deleteTransformFeedback");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_feedback = NativeValueTraits<IDLNullable<WebGLTransformFeedback>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteTransformFeedback(arg1_feedback);

}

void DeleteVertexArrayOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_deleteVertexArray");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.deleteVertexArray");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_vertex_array = NativeValueTraits<IDLNullable<WebGLVertexArrayObject>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->deleteVertexArray(arg1_vertex_array);

}

void DepthFuncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_depthFunc");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.depthFunc");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_func = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->depthFunc(arg1_func);

}

void DepthMaskOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_depthMask");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.depthMask");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_flag = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->depthMask(arg1_flag);

}

void DepthRangeOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_depthRange");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.depthRange");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_z_near = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_z_far = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->depthRange(arg1_z_near, arg2_z_far);

}

void DetachShaderOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_detachShader");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.detachShader");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_shader = NativeValueTraits<WebGLShader>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->detachShader(arg1_program, arg2_shader);

}

void DisableOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_disable");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.disable");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_cap = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->disable(arg1_cap);

}

void DisableVertexAttribArrayOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
blink_receiver->disableVertexAttribArray(arg1_index);
}

void DisableVertexAttribArrayOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_disableVertexAttribArray");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.disableVertexAttribArray");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->disableVertexAttribArray(arg1_index);

}

void DrawArraysOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_mode, int32_t v8_arg2_first, int32_t v8_arg3_count, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_mode = v8_arg1_mode;
auto&& arg2_first = v8_arg2_first;
auto&& arg3_count = v8_arg3_count;
blink_receiver->drawArrays(arg1_mode, arg2_first, arg3_count);
}

void DrawArraysOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_drawArrays");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.drawArrays");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_first = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_count = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawArrays(arg1_mode, arg2_first, arg3_count);

}

void DrawArraysInstancedOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_drawArraysInstanced");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.drawArraysInstanced");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_first = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_count = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_instance_count = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawArraysInstanced(arg1_mode, arg2_first, arg3_count, arg4_instance_count);

}

void DrawBuffersOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_buffers, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffers = NativeValueTraits<IDLSequence<IDLUnsignedLong>>::ArgumentValue(isolate, 0, v8_arg1_buffers, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawBuffers(arg1_buffers);
}

void DrawBuffersOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_drawBuffers");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.drawBuffers");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffers = NativeValueTraits<IDLSequence<IDLUnsignedLong>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawBuffers(std::move(arg1_buffers));

}

void DrawElementsOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_mode, int32_t v8_arg2_count, uint32_t v8_arg3_type, int64_t v8_arg4_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_mode = v8_arg1_mode;
auto&& arg2_count = v8_arg2_count;
auto&& arg3_type = v8_arg3_type;
auto&& arg4_offset = v8_arg4_offset;
blink_receiver->drawElements(arg1_mode, arg2_count, arg3_type, arg4_offset);
}

void DrawElementsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_drawElements");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.drawElements");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_count = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawElements(arg1_mode, arg2_count, arg3_type, arg4_offset);

}

void DrawElementsInstancedOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_drawElementsInstanced");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.drawElementsInstanced");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_count = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_instance_count = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawElementsInstanced(arg1_mode, arg2_count, arg3_type, arg4_offset, arg5_instance_count);

}

void DrawRangeElementsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_drawRangeElements");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.drawRangeElements");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_start = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_end = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_count = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawRangeElements(arg1_mode, arg2_start, arg3_end, arg4_count, arg5_type, arg6_offset);

}

void DrawingBufferStorageOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_drawingBufferStorage");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.drawingBufferStorage");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sizedformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->drawingBufferStorage(arg1_sizedformat, arg2_width, arg3_height);

}

void EnableOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_enable");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.enable");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_cap = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->enable(arg1_cap);

}

void EnableVertexAttribArrayOperationNoAllocDirectCallArg1(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
blink_receiver->enableVertexAttribArray(arg1_index);
}

void EnableVertexAttribArrayOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_enableVertexAttribArray");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.enableVertexAttribArray");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->enableVertexAttribArray(arg1_index);

}

void EndQueryOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_endQuery");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.endQuery");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->endQuery(arg1_target);

}

void EndTransformFeedbackOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_endTransformFeedback");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.endTransformFeedback");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->endTransformFeedback();

}

void FenceSyncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_fenceSync");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.fenceSync");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_condition = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_flags = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->fenceSync(arg1_condition, arg2_flags);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<WebGLSync>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void FinishOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_finish");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.finish");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->finish();

}

void FlushOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_flush");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.flush");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->flush();

}

void FramebufferRenderbufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_framebufferRenderbuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.framebufferRenderbuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_attachment = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_renderbuffertarget = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_renderbuffer = NativeValueTraits<IDLNullable<WebGLRenderbuffer>>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->framebufferRenderbuffer(arg1_target, arg2_attachment, arg3_renderbuffertarget, arg4_renderbuffer);

}

void FramebufferTexture2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_framebufferTexture2D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.framebufferTexture2D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_attachment = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_textarget = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_texture = NativeValueTraits<IDLNullable<WebGLTexture>>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->framebufferTexture2D(arg1_target, arg2_attachment, arg3_textarget, arg4_texture, arg5_level);

}

void FramebufferTextureLayerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_framebufferTextureLayer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.framebufferTextureLayer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_attachment = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_texture = NativeValueTraits<IDLNullable<WebGLTexture>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_layer = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->framebufferTextureLayer(arg1_target, arg2_attachment, arg3_texture, arg4_level, arg5_layer);

}

void FrontFaceOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_frontFace");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.frontFace");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->frontFace(arg1_mode);

}

void GenerateMipmapOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_generateMipmap");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.generateMipmap");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->generateMipmap(arg1_target);

}

void GetActiveAttribOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getActiveAttrib");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getActiveAttrib");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getActiveAttrib(arg1_program, arg2_index);
static_assert(bindings::IsReturnTypeCompatible<WebGLActiveInfo, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void GetActiveUniformOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getActiveUniform");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getActiveUniform");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getActiveUniform(arg1_program, arg2_index);
static_assert(bindings::IsReturnTypeCompatible<WebGLActiveInfo, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void GetActiveUniformBlockNameOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getActiveUniformBlockName");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getActiveUniformBlockName");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_uniform_block_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getActiveUniformBlockName(arg1_program, arg2_uniform_block_index);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void GetActiveUniformBlockParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getActiveUniformBlockParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getActiveUniformBlockParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_uniform_block_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getActiveUniformBlockParameter(script_state, arg1_program, arg2_uniform_block_index, arg3_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetActiveUniformsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getActiveUniforms");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getActiveUniforms");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_uniform_indices = NativeValueTraits<IDLSequence<IDLUnsignedLong>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getActiveUniforms(script_state, arg1_program, std::move(arg2_uniform_indices), arg3_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetAttachedShadersOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getAttachedShaders");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getAttachedShaders");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getAttachedShaders(arg1_program);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLSequence<WebGLShader>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<IDLSequence<WebGLShader>>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void GetAttribLocationOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getAttribLocation");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getAttribLocation");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getAttribLocation(arg1_program, arg2_name);
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
}

void GetBufferParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getBufferParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getBufferParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getBufferParameter(script_state, arg1_target, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetBufferSubDataOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getBufferSubData");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getBufferSubData");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_src_byte_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_dst_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLLongLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_dst_offset{0};
if (!info[3]->IsUndefined()) {
  arg4_dst_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_length{0};
if (!info[4]->IsUndefined()) {
  arg5_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->getBufferSubData(arg1_target, arg2_src_byte_offset, arg3_dst_data, arg4_dst_offset, arg5_length);

}

void GetContextAttributesOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getContextAttributes");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getContextAttributes");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getContextAttributes();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<WebGLContextAttributes>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<WebGLContextAttributes>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void GetErrorOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getError");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getError");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getError();
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}

void GetExtensionOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getExtension");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getExtension");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGL2RenderingContext.getExtension", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8WebGL2RenderingContext_GetExtension_Method);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
decltype(NativeValueTraits<IDLString>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg1_name;
if (info[0]->IsString()) [[likely]] {
  arg1_name.Init(isolate, info[0].As<v8::String>());
} else {
  ExceptionState exception_state(isolate);
arg1_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
auto&& return_value = blink_receiver->getExtension(script_state, arg1_name);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLObject>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetFragDataLocationOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getFragDataLocation");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getFragDataLocation");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getFragDataLocation(arg1_program, arg2_name);
static_assert(bindings::IsReturnTypeCompatible<IDLLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int32_t>());
}

void GetFramebufferAttachmentParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getFramebufferAttachmentParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getFramebufferAttachmentParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_attachment = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getFramebufferAttachmentParameter(script_state, arg1_target, arg2_attachment, arg3_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetIndexedParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getIndexedParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getIndexedParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getIndexedParameter(script_state, arg1_target, arg2_index);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetInternalformatParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getInternalformatParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getInternalformatParameter");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGL2RenderingContext.getInternalformatParameter", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kWebGL2RenderingContextGetInternalFormatParameter);


if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_internalformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getInternalformatParameter(script_state, arg1_target, arg2_internalformat, arg3_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getParameter");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGL2RenderingContext.getParameter", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kWebGLRenderingContextGetParameter);


if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getParameter(script_state, arg1_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetProgramInfoLogOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getProgramInfoLog");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getProgramInfoLog");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getProgramInfoLog(arg1_program);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void GetProgramParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getProgramParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getProgramParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getProgramParameter(script_state, arg1_program, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetQueryOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getQuery");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getQuery");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getQuery(script_state, arg1_target, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetQueryParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getQueryParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getQueryParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_query = NativeValueTraits<WebGLQuery>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getQueryParameter(script_state, arg1_query, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetRenderbufferParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getRenderbufferParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getRenderbufferParameter");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGL2RenderingContext.getRenderbufferParameter", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kWebGLRenderingContextGetRenderbufferParameter);


if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getRenderbufferParameter(script_state, arg1_target, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetSamplerParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getSamplerParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getSamplerParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_sampler = NativeValueTraits<WebGLSampler>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getSamplerParameter(script_state, arg1_sampler, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetShaderInfoLogOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getShaderInfoLog");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getShaderInfoLog");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_shader = NativeValueTraits<WebGLShader>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getShaderInfoLog(arg1_shader);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void GetShaderParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getShaderParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getShaderParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_shader = NativeValueTraits<WebGLShader>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getShaderParameter(script_state, arg1_shader, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetShaderPrecisionFormatOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getShaderPrecisionFormat");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getShaderPrecisionFormat");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGL2RenderingContext.getShaderPrecisionFormat", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kWebGLRenderingContextGetShaderPrecisionFormat);


if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_shadertype = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_precisiontype = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getShaderPrecisionFormat(arg1_shadertype, arg2_precisiontype);
static_assert(bindings::IsReturnTypeCompatible<WebGLShaderPrecisionFormat, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void GetShaderSourceOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getShaderSource");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getShaderSource");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_shader = NativeValueTraits<WebGLShader>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getShaderSource(arg1_shader);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLString>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, isolate, bindings::V8ReturnValue::kNullable);
}

void GetSupportedExtensionsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getSupportedExtensions");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getSupportedExtensions");


// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGL2RenderingContext.getSupportedExtensions", info);
v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kV8WebGL2RenderingContext_GetSupportedExtensions_Method);




v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->getSupportedExtensions();
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLSequence<IDLString>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<IDLSequence<IDLString>>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
// [HighEntropy=Direct]
Dactyloscoper::RecordDirectSurface(current_execution_context, WebFeature::kV8WebGL2RenderingContext_GetSupportedExtensions_Method, return_value);
}

void GetSyncParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getSyncParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getSyncParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_sync = NativeValueTraits<WebGLSync>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getSyncParameter(script_state, arg1_sync, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetTexParameterOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getTexParameter");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getTexParameter");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getTexParameter(script_state, arg1_target, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetTransformFeedbackVaryingOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getTransformFeedbackVarying");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getTransformFeedbackVarying");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getTransformFeedbackVarying(arg1_program, arg2_index);
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<WebGLActiveInfo>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void GetUniformOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getUniform");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getUniform");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_location = NativeValueTraits<WebGLUniformLocation>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getUniform(script_state, arg1_program, arg2_location);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetUniformBlockIndexOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getUniformBlockIndex");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getUniformBlockIndex");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_uniform_block_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getUniformBlockIndex(arg1_program, arg2_uniform_block_name);
static_assert(bindings::IsReturnTypeCompatible<IDLUnsignedLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<uint32_t>());
}

void GetUniformIndicesOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getUniformIndices");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getUniformIndices");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_uniform_names = NativeValueTraits<IDLSequence<IDLString>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getUniformIndices(arg1_program, std::move(arg2_uniform_names));
static_assert(bindings::IsReturnTypeCompatible<IDLNullable<IDLSequence<IDLUnsignedLong>>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
v8::Local<v8::Value> v8_return_value = ToV8Traits<IDLNullable<IDLSequence<IDLUnsignedLong>>>::ToV8(script_state, return_value);
bindings::V8SetReturnValue(info, v8_return_value);
}

void GetUniformLocationOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getUniformLocation");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getUniformLocation");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_name = NativeValueTraits<IDLString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getUniformLocation(arg1_program, arg2_name);
static_assert(bindings::IsReturnTypeCompatible<WebGLUniformLocation, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, blink_receiver);
}

void GetVertexAttribOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getVertexAttrib");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getVertexAttrib");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getVertexAttrib(script_state, arg1_index, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLAny, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value);
}

void GetVertexAttribOffsetOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_getVertexAttribOffset");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.getVertexAttribOffset");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->getVertexAttribOffset(arg1_index, arg2_pname);
static_assert(bindings::IsReturnTypeCompatible<IDLLongLong, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<int64_t>());
}

void HintOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_hint");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.hint");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->hint(arg1_target, arg2_mode);

}

void InvalidateFramebufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_invalidateFramebuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.invalidateFramebuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_attachments = NativeValueTraits<IDLSequence<IDLUnsignedLong>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->invalidateFramebuffer(arg1_target, std::move(arg2_attachments));

}

void InvalidateSubFramebufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_invalidateSubFramebuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.invalidateSubFramebuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_attachments = NativeValueTraits<IDLSequence<IDLUnsignedLong>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->invalidateSubFramebuffer(arg1_target, std::move(arg2_attachments), arg3_x, arg4_y, arg5_width, arg6_height);

}

void IsBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_isBuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.isBuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_buffer = NativeValueTraits<IDLNullable<WebGLBuffer>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isBuffer(arg1_buffer);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsContextLostOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_isContextLost");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.isContextLost");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& return_value = blink_receiver->isContextLost();
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsEnabledOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_isEnabled");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.isEnabled");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_cap = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isEnabled(arg1_cap);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsFramebufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_isFramebuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.isFramebuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_framebuffer = NativeValueTraits<IDLNullable<WebGLFramebuffer>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isFramebuffer(arg1_framebuffer);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsProgramOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_isProgram");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.isProgram");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<IDLNullable<WebGLProgram>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isProgram(arg1_program);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsQueryOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_isQuery");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.isQuery");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_query = NativeValueTraits<IDLNullable<WebGLQuery>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isQuery(arg1_query);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsRenderbufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_isRenderbuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.isRenderbuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_renderbuffer = NativeValueTraits<IDLNullable<WebGLRenderbuffer>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isRenderbuffer(arg1_renderbuffer);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsSamplerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_isSampler");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.isSampler");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sampler = NativeValueTraits<IDLNullable<WebGLSampler>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isSampler(arg1_sampler);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsShaderOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_isShader");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.isShader");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_shader = NativeValueTraits<IDLNullable<WebGLShader>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isShader(arg1_shader);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsSyncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_isSync");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.isSync");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sync = NativeValueTraits<IDLNullable<WebGLSync>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isSync(arg1_sync);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsTextureOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_isTexture");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.isTexture");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_texture = NativeValueTraits<IDLNullable<WebGLTexture>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isTexture(arg1_texture);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsTransformFeedbackOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_isTransformFeedback");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.isTransformFeedback");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_feedback = NativeValueTraits<IDLNullable<WebGLTransformFeedback>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isTransformFeedback(arg1_feedback);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void IsVertexArrayOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_isVertexArray");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.isVertexArray");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_vertex_array = NativeValueTraits<IDLNullable<WebGLVertexArrayObject>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& return_value = blink_receiver->isVertexArray(arg1_vertex_array);
static_assert(bindings::IsReturnTypeCompatible<IDLBoolean, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
bindings::V8SetReturnValue(info, return_value, bindings::V8ReturnValue::PrimitiveType<bool>());
}

void LineWidthOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_lineWidth");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.lineWidth");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_width = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->lineWidth(arg1_width);

}

void LinkProgramOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_linkProgram");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.linkProgram");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->linkProgram(arg1_program);

}

void MakeXRCompatibleOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_makeXRCompatible");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.makeXRCompatible");
// Promise returning function: Convert a TypeError to a reject promise.
ExceptionToRejectPromiseScope reject_promise_scope(info);

v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
if (!V8WebGL2RenderingContext::HasInstance(isolate, v8_receiver)) {
  V8ThrowException::ThrowTypeError(isolate, "Illegal invocation");
return;
}

// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGL2RenderingContext.makeXRCompatible", info);
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
ScriptState* current_script_state = ScriptState::From(isolate, current_context);
ExecutionContext* current_execution_context = ToExecutionContext(current_script_state);
// [Measure], [MeasureAs]
UseCounter::Count(current_execution_context, WebFeature::kWebGLRenderingContextMakeXRCompatible);




WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
const v8::ExceptionContext exception_context_type = v8::ExceptionContext::kOperation;
const char* const class_like_name = "WebGL2RenderingContext";
const char* const property_name = "makeXRCompatible";
ExceptionState exception_state(isolate, ExceptionContext(exception_context_type, class_like_name, property_name));
auto&& return_value = blink_receiver->makeXRCompatible(script_state, exception_state);
static_assert(bindings::IsReturnTypeCompatible<IDLPromise<IDLUndefined>, std::remove_cvref_t<decltype(return_value)>>, "Return type from native call is incompatible to the type specified in IDL");
if (exception_state.HadException()) [[unlikely]] {
  return;
}
bindings::V8SetReturnValue(info, return_value);
}

void PauseTransformFeedbackOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_pauseTransformFeedback");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.pauseTransformFeedback");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->pauseTransformFeedback();

}

void PixelStoreiOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_pixelStorei");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.pixelStorei");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_param = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->pixelStorei(arg1_pname, arg2_param);

}

void PolygonOffsetOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_polygonOffset");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.polygonOffset");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_factor = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_units = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->polygonOffset(arg1_factor, arg2_units);

}

void ReadBufferOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_readBuffer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.readBuffer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->readBuffer(arg1_mode);

}

void ReadPixelsOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  
// [HighEntropy]
const Dactyloscoper::HighEntropyTracer  high_entropy_tracer("WebGL2RenderingContext.readPixels", info);


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_pixels = NativeValueTraits<IDLNullable<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->readPixels(arg1_x, arg2_y, arg3_width, arg4_height, arg5_format, arg6_type, arg7_pixels);

}

void ReadPixelsOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 8) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(8, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_dst_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->readPixels(arg1_x, arg2_y, arg3_width, arg4_height, arg5_format, arg6_type, arg7_dst_data, arg8_offset);

}

void ReadPixelsOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->readPixels(arg1_x, arg2_y, arg3_width, arg4_height, arg5_format, arg6_type, arg7_offset);

}

void ReadPixelsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_readPixels");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.readPixels");


const int arg_count = std::min(info.Length(), 8);
if (arg_count == 8) {
  return ReadPixelsOperationOverload2(info);
}
if (arg_count == 7) {
  if (info[6]->IsNullOrUndefined()) {
  return ReadPixelsOperationOverload1(info);
}
if (info[6]->IsObject()) {
  if (info[6]->IsArrayBufferView()) {
  return ReadPixelsOperationOverload1(info);
}
}
if (info[6]->IsNumber()) {
  return ReadPixelsOperationOverload3(info);
}
return ReadPixelsOperationOverload3(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void RenderbufferStorageOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_renderbufferStorage");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.renderbufferStorage");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_internalformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->renderbufferStorage(arg1_target, arg2_internalformat, arg3_width, arg4_height);

}

void RenderbufferStorageMultisampleOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_renderbufferStorageMultisample");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.renderbufferStorageMultisample");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_samples = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->renderbufferStorageMultisample(arg1_target, arg2_samples, arg3_internalformat, arg4_width, arg5_height);

}

void ResumeTransformFeedbackOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_resumeTransformFeedback");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.resumeTransformFeedback");






v8::Isolate* isolate = info.GetIsolate();
v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
blink_receiver->resumeTransformFeedback();

}

void SampleCoverageOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_sampleCoverage");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.sampleCoverage");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_value = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_invert = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->sampleCoverage(arg1_value, arg2_invert);

}

void SamplerParameterfOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_samplerParameterf");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.samplerParameterf");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sampler = NativeValueTraits<WebGLSampler>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_param = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->samplerParameterf(arg1_sampler, arg2_pname, arg3_param);

}

void SamplerParameteriOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_samplerParameteri");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.samplerParameteri");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sampler = NativeValueTraits<WebGLSampler>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_param = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->samplerParameteri(arg1_sampler, arg2_pname, arg3_param);

}

void ScissorOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, int32_t v8_arg1_x, int32_t v8_arg2_y, int32_t v8_arg3_width, int32_t v8_arg4_height, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_width = v8_arg3_width;
auto&& arg4_height = v8_arg4_height;
blink_receiver->scissor(arg1_x, arg2_y, arg3_width, arg4_height);
}

void ScissorOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_scissor");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.scissor");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->scissor(arg1_x, arg2_y, arg3_width, arg4_height);

}

void SetHitTestRegionsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_setHitTestRegions");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.setHitTestRegions");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_hit_test_regions = NativeValueTraits<IDLSequence<CanvasElementHitTestRegion>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->setHitTestRegions(std::move(arg1_hit_test_regions), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void ShaderSourceOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_shaderSource");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.shaderSource");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_shader = NativeValueTraits<WebGLShader>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_string = NativeValueTraits<IDLString>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->shaderSource(arg1_shader, arg2_string);

}

void StencilFuncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_stencilFunc");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.stencilFunc");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_func = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_ref = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_mask = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->stencilFunc(arg1_func, arg2_ref, arg3_mask);

}

void StencilFuncSeparateOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_stencilFuncSeparate");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.stencilFuncSeparate");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_face = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_func = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_ref = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_mask = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->stencilFuncSeparate(arg1_face, arg2_func, arg3_ref, arg4_mask);

}

void StencilMaskOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_stencilMask");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.stencilMask");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_mask = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->stencilMask(arg1_mask);

}

void StencilMaskSeparateOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_stencilMaskSeparate");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.stencilMaskSeparate");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_face = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_mask = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->stencilMaskSeparate(arg1_face, arg2_mask);

}

void StencilOpOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_stencilOp");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.stencilOp");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_fail = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_zfail = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_zpass = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->stencilOp(arg1_fail, arg2_zfail, arg3_zpass);

}

void StencilOpSeparateOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_stencilOpSeparate");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.stencilOpSeparate");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_face = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_fail = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_zfail = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_zpass = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->stencilOpSeparate(arg1_face, arg2_fail, arg3_zfail, arg4_zpass);

}

void TexElement2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_texElement2D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.texElement2D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_element = NativeValueTraits<Element>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texElement2D(arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_element, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexElementImage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_texElementImage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.texElementImage2D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_element = NativeValueTraits<Element>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texElementImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_element, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_pixels = NativeValueTraits<IDLNullable<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_format, arg8_type, arg9_pixels);

}

void TexImage2DOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_pixels = NativeValueTraits<ImageData>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_pixels);

}

void TexImage2DOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_image = NativeValueTraits<HTMLImageElement>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_image, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload4(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_canvas = NativeValueTraits<HTMLCanvasElement>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload5(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_offscreen_canvas = NativeValueTraits<OffscreenCanvas>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_offscreen_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload6(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_video = NativeValueTraits<HTMLVideoElement>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_video, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload7(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_bitmap = NativeValueTraits<ImageBitmap>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_bitmap, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload8(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_frame = NativeValueTraits<VideoFrame>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_format, arg5_type, arg6_frame, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload9(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_format, arg8_type, arg9_offset);

}

void TexImage2DOperationOverload10(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_data = NativeValueTraits<ImageData>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_format, arg8_type, arg9_data);

}

void TexImage2DOperationOverload11(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_image = NativeValueTraits<HTMLImageElement>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_format, arg8_type, arg9_image, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload12(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_canvas = NativeValueTraits<HTMLCanvasElement>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_format, arg8_type, arg9_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload13(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_offscreen_canvas = NativeValueTraits<OffscreenCanvas>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_format, arg8_type, arg9_offscreen_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload14(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_video = NativeValueTraits<HTMLVideoElement>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_format, arg8_type, arg9_video, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload15(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_frame = NativeValueTraits<VideoFrame>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_format, arg8_type, arg9_frame, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload16(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_bitmap = NativeValueTraits<ImageBitmap>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_format, arg8_type, arg9_bitmap, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage2DOperationOverload17(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_src_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_src_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage2D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_border, arg7_format, arg8_type, arg9_src_data, arg10_src_offset);

}

void TexImage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_texImage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.texImage2D");


const int arg_count = std::min(info.Length(), 10);
v8::Isolate* isolate = info.GetIsolate();
do {  // Dummy loop for use of 'break'.
  if (arg_count == 10) {
  return TexImage2DOperationOverload17(info);
}
if (arg_count == 9) {
  if (info[8]->IsNullOrUndefined()) {
  return TexImage2DOperationOverload1(info);
}
if (info[8]->IsObject()) {
  if (V8HTMLVideoElement::HasInstance(isolate, info[8])) {
  return TexImage2DOperationOverload14(info);
}
if (V8HTMLImageElement::HasInstance(isolate, info[8])) {
  return TexImage2DOperationOverload11(info);
}
if (V8HTMLCanvasElement::HasInstance(isolate, info[8])) {
  return TexImage2DOperationOverload12(info);
}
if (V8OffscreenCanvas::HasInstance(isolate, info[8])) {
  return TexImage2DOperationOverload13(info);
}
if (V8VideoFrame::HasInstance(isolate, info[8])) {
  return TexImage2DOperationOverload15(info);
}
if (V8ImageData::HasInstance(isolate, info[8])) {
  return TexImage2DOperationOverload10(info);
}
if (V8ImageBitmap::HasInstance(isolate, info[8])) {
  return TexImage2DOperationOverload16(info);
}
if (info[8]->IsArrayBufferView()) {
  return TexImage2DOperationOverload1(info);
}
}
if (info[8]->IsNumber()) {
  return TexImage2DOperationOverload9(info);
}
return TexImage2DOperationOverload9(info);
}
if (arg_count == 6) {
  if (info[5]->IsObject()) {
  if (V8HTMLVideoElement::HasInstance(isolate, info[5])) {
  return TexImage2DOperationOverload6(info);
}
if (V8HTMLImageElement::HasInstance(isolate, info[5])) {
  return TexImage2DOperationOverload3(info);
}
if (V8HTMLCanvasElement::HasInstance(isolate, info[5])) {
  return TexImage2DOperationOverload4(info);
}
if (V8OffscreenCanvas::HasInstance(isolate, info[5])) {
  return TexImage2DOperationOverload5(info);
}
if (V8VideoFrame::HasInstance(isolate, info[5])) {
  return TexImage2DOperationOverload8(info);
}
if (V8ImageData::HasInstance(isolate, info[5])) {
  return TexImage2DOperationOverload2(info);
}
if (V8ImageBitmap::HasInstance(isolate, info[5])) {
  return TexImage2DOperationOverload7(info);
}
}
break;
}
} while (false);

if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void TexImage3DOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage3D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_depth, arg7_border, arg8_format, arg9_type, arg10_offset);

}

void TexImage3DOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_data = NativeValueTraits<ImageData>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage3D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_depth, arg7_border, arg8_format, arg9_type, arg10_data);

}

void TexImage3DOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_image = NativeValueTraits<HTMLImageElement>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage3D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_depth, arg7_border, arg8_format, arg9_type, arg10_image, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage3DOperationOverload4(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_canvas = NativeValueTraits<HTMLCanvasElement>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage3D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_depth, arg7_border, arg8_format, arg9_type, arg10_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage3DOperationOverload5(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_offscreen_canvas = NativeValueTraits<OffscreenCanvas>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage3D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_depth, arg7_border, arg8_format, arg9_type, arg10_offscreen_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage3DOperationOverload6(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_video = NativeValueTraits<HTMLVideoElement>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage3D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_depth, arg7_border, arg8_format, arg9_type, arg10_video, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage3DOperationOverload7(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_frame = NativeValueTraits<VideoFrame>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage3D(script_state, arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_depth, arg7_border, arg8_format, arg9_type, arg10_frame, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage3DOperationOverload8(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_bitmap = NativeValueTraits<ImageBitmap>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage3D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_depth, arg7_border, arg8_format, arg9_type, arg10_bitmap, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexImage3DOperationOverload9(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_pixels = NativeValueTraits<IDLNullable<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage3D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_depth, arg7_border, arg8_format, arg9_type, arg10_pixels);

}

void TexImage3DOperationOverload10(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 11) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(11, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_border = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_pixels = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg11_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 10, info[10], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texImage3D(arg1_target, arg2_level, arg3_internalformat, arg4_width, arg5_height, arg6_depth, arg7_border, arg8_format, arg9_type, arg10_pixels, arg11_src_offset);

}

void TexImage3DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_texImage3D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.texImage3D");


const int arg_count = std::min(info.Length(), 11);
if (arg_count == 11) {
  return TexImage3DOperationOverload10(info);
}
v8::Isolate* isolate = info.GetIsolate();
if (arg_count == 10) {
  if (info[9]->IsNullOrUndefined()) {
  return TexImage3DOperationOverload9(info);
}
if (info[9]->IsObject()) {
  if (V8HTMLVideoElement::HasInstance(isolate, info[9])) {
  return TexImage3DOperationOverload6(info);
}
if (V8HTMLImageElement::HasInstance(isolate, info[9])) {
  return TexImage3DOperationOverload3(info);
}
if (V8HTMLCanvasElement::HasInstance(isolate, info[9])) {
  return TexImage3DOperationOverload4(info);
}
if (V8OffscreenCanvas::HasInstance(isolate, info[9])) {
  return TexImage3DOperationOverload5(info);
}
if (V8VideoFrame::HasInstance(isolate, info[9])) {
  return TexImage3DOperationOverload7(info);
}
if (V8ImageData::HasInstance(isolate, info[9])) {
  return TexImage3DOperationOverload2(info);
}
if (V8ImageBitmap::HasInstance(isolate, info[9])) {
  return TexImage3DOperationOverload8(info);
}
if (info[9]->IsArrayBufferView()) {
  return TexImage3DOperationOverload9(info);
}
}
if (info[9]->IsNumber()) {
  return TexImage3DOperationOverload1(info);
}
return TexImage3DOperationOverload1(info);
}

if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void TexParameterfOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_texParameterf");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.texParameterf");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_param = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texParameterf(arg1_target, arg2_pname, arg3_param);

}

void TexParameteriOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_texParameteri");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.texParameteri");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_pname = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_param = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texParameteri(arg1_target, arg2_pname, arg3_param);

}

void TexStorage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_texStorage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.texStorage2D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_levels = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texStorage2D(arg1_target, arg2_levels, arg3_internalformat, arg4_width, arg5_height);

}

void TexStorage3DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_texStorage3D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.texStorage3D");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_levels = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_internalformat = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texStorage3D(arg1_target, arg2_levels, arg3_internalformat, arg4_width, arg5_height, arg6_depth);

}

void TexSubImage2DOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_pixels = NativeValueTraits<IDLNullable<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_type, arg9_pixels);

}

void TexSubImage2DOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_pixels = NativeValueTraits<ImageData>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_format, arg6_type, arg7_pixels);

}

void TexSubImage2DOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_image = NativeValueTraits<HTMLImageElement>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_format, arg6_type, arg7_image, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload4(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_canvas = NativeValueTraits<HTMLCanvasElement>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_format, arg6_type, arg7_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload5(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_offscreen_canvas = NativeValueTraits<OffscreenCanvas>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_format, arg6_type, arg7_offscreen_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload6(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_video = NativeValueTraits<HTMLVideoElement>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_format, arg6_type, arg7_video, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload7(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_bitmap = NativeValueTraits<ImageBitmap>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_format, arg6_type, arg7_bitmap, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload8(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_frame = NativeValueTraits<VideoFrame>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_format, arg6_type, arg7_frame, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload9(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_type, arg9_offset);

}

void TexSubImage2DOperationOverload10(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_data = NativeValueTraits<ImageData>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_type, arg9_data);

}

void TexSubImage2DOperationOverload11(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_image = NativeValueTraits<HTMLImageElement>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_type, arg9_image, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload12(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_canvas = NativeValueTraits<HTMLCanvasElement>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_type, arg9_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload13(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_offscreen_canvas = NativeValueTraits<OffscreenCanvas>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_type, arg9_offscreen_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload14(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_video = NativeValueTraits<HTMLVideoElement>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_type, arg9_video, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload15(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_frame = NativeValueTraits<VideoFrame>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_type, arg9_frame, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload16(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 9) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(9, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_bitmap = NativeValueTraits<ImageBitmap>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_type, arg9_bitmap, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage2DOperationOverload17(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 10) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(10, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_src_data = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_src_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage2D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_width, arg6_height, arg7_format, arg8_type, arg9_src_data, arg10_src_offset);

}

void TexSubImage2DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_texSubImage2D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.texSubImage2D");


const int arg_count = std::min(info.Length(), 10);
v8::Isolate* isolate = info.GetIsolate();
do {  // Dummy loop for use of 'break'.
  if (arg_count == 10) {
  return TexSubImage2DOperationOverload17(info);
}
if (arg_count == 9) {
  if (info[8]->IsNullOrUndefined()) {
  return TexSubImage2DOperationOverload1(info);
}
if (info[8]->IsObject()) {
  if (V8HTMLVideoElement::HasInstance(isolate, info[8])) {
  return TexSubImage2DOperationOverload14(info);
}
if (V8HTMLImageElement::HasInstance(isolate, info[8])) {
  return TexSubImage2DOperationOverload11(info);
}
if (V8HTMLCanvasElement::HasInstance(isolate, info[8])) {
  return TexSubImage2DOperationOverload12(info);
}
if (V8OffscreenCanvas::HasInstance(isolate, info[8])) {
  return TexSubImage2DOperationOverload13(info);
}
if (V8VideoFrame::HasInstance(isolate, info[8])) {
  return TexSubImage2DOperationOverload15(info);
}
if (V8ImageData::HasInstance(isolate, info[8])) {
  return TexSubImage2DOperationOverload10(info);
}
if (V8ImageBitmap::HasInstance(isolate, info[8])) {
  return TexSubImage2DOperationOverload16(info);
}
if (info[8]->IsArrayBufferView()) {
  return TexSubImage2DOperationOverload1(info);
}
}
if (info[8]->IsNumber()) {
  return TexSubImage2DOperationOverload9(info);
}
return TexSubImage2DOperationOverload9(info);
}
if (arg_count == 7) {
  if (info[6]->IsObject()) {
  if (V8HTMLVideoElement::HasInstance(isolate, info[6])) {
  return TexSubImage2DOperationOverload6(info);
}
if (V8HTMLImageElement::HasInstance(isolate, info[6])) {
  return TexSubImage2DOperationOverload3(info);
}
if (V8HTMLCanvasElement::HasInstance(isolate, info[6])) {
  return TexSubImage2DOperationOverload4(info);
}
if (V8OffscreenCanvas::HasInstance(isolate, info[6])) {
  return TexSubImage2DOperationOverload5(info);
}
if (V8VideoFrame::HasInstance(isolate, info[6])) {
  return TexSubImage2DOperationOverload8(info);
}
if (V8ImageData::HasInstance(isolate, info[6])) {
  return TexSubImage2DOperationOverload2(info);
}
if (V8ImageBitmap::HasInstance(isolate, info[6])) {
  return TexSubImage2DOperationOverload7(info);
}
}
break;
}
} while (false);

if (info.Length() < 7) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(7, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void TexSubImage3DOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 11) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(11, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_zoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg11_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 10, info[10], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage3D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_zoffset, arg6_width, arg7_height, arg8_depth, arg9_format, arg10_type, arg11_offset);

}

void TexSubImage3DOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 11) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(11, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_zoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg11_data = NativeValueTraits<ImageData>::ArgumentValue(isolate, 10, info[10], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage3D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_zoffset, arg6_width, arg7_height, arg8_depth, arg9_format, arg10_type, arg11_data);

}

void TexSubImage3DOperationOverload3(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 11) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(11, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_zoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg11_image = NativeValueTraits<HTMLImageElement>::ArgumentValue(isolate, 10, info[10], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage3D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_zoffset, arg6_width, arg7_height, arg8_depth, arg9_format, arg10_type, arg11_image, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage3DOperationOverload4(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 11) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(11, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_zoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg11_canvas = NativeValueTraits<HTMLCanvasElement>::ArgumentValue(isolate, 10, info[10], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage3D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_zoffset, arg6_width, arg7_height, arg8_depth, arg9_format, arg10_type, arg11_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage3DOperationOverload5(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 11) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(11, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_zoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg11_offscreen_canvas = NativeValueTraits<OffscreenCanvas>::ArgumentValue(isolate, 10, info[10], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage3D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_zoffset, arg6_width, arg7_height, arg8_depth, arg9_format, arg10_type, arg11_offscreen_canvas, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage3DOperationOverload6(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 11) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(11, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_zoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg11_video = NativeValueTraits<HTMLVideoElement>::ArgumentValue(isolate, 10, info[10], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage3D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_zoffset, arg6_width, arg7_height, arg8_depth, arg9_format, arg10_type, arg11_video, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage3DOperationOverload7(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 11) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(11, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ScriptState* receiver_script_state = ScriptState::ForRelevantRealm(isolate, v8_receiver);
ScriptState* script_state = receiver_script_state;
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_zoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg11_frame = NativeValueTraits<VideoFrame>::ArgumentValue(isolate, 10, info[10], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage3D(script_state, arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_zoffset, arg6_width, arg7_height, arg8_depth, arg9_format, arg10_type, arg11_frame, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage3DOperationOverload8(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 11) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(11, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_zoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg11_bitmap = NativeValueTraits<ImageBitmap>::ArgumentValue(isolate, 10, info[10], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->texSubImage3D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_zoffset, arg6_width, arg7_height, arg8_depth, arg9_format, arg10_type, arg11_bitmap, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}

}

void TexSubImage3DOperationOverload9(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 11) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(11, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_target = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_level = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_xoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_yoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_zoffset = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg7_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 6, info[6], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg8_depth = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 7, info[7], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg9_format = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 8, info[8], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg10_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 9, info[9], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg11_pixels = NativeValueTraits<IDLBufferSourceTypeNoSizeLimit<MaybeShared<DOMArrayBufferView>>>::ArgumentValue(isolate, 10, info[10], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg12_src_offset{0};
if (!info[11]->IsUndefined()) {
  arg12_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 11, info[11], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->texSubImage3D(arg1_target, arg2_level, arg3_xoffset, arg4_yoffset, arg5_zoffset, arg6_width, arg7_height, arg8_depth, arg9_format, arg10_type, arg11_pixels, arg12_src_offset);

}

void TexSubImage3DOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_texSubImage3D");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.texSubImage3D");


const int arg_count = std::min(info.Length(), 12);
if (arg_count == 12) {
  return TexSubImage3DOperationOverload9(info);
}
v8::Isolate* isolate = info.GetIsolate();
if (arg_count == 11) {
  if (info[10]->IsObject()) {
  if (V8HTMLVideoElement::HasInstance(isolate, info[10])) {
  return TexSubImage3DOperationOverload6(info);
}
if (V8HTMLImageElement::HasInstance(isolate, info[10])) {
  return TexSubImage3DOperationOverload3(info);
}
if (V8HTMLCanvasElement::HasInstance(isolate, info[10])) {
  return TexSubImage3DOperationOverload4(info);
}
if (V8OffscreenCanvas::HasInstance(isolate, info[10])) {
  return TexSubImage3DOperationOverload5(info);
}
if (V8VideoFrame::HasInstance(isolate, info[10])) {
  return TexSubImage3DOperationOverload7(info);
}
if (V8ImageData::HasInstance(isolate, info[10])) {
  return TexSubImage3DOperationOverload2(info);
}
if (V8ImageBitmap::HasInstance(isolate, info[10])) {
  return TexSubImage3DOperationOverload8(info);
}
if (info[10]->IsArrayBufferView()) {
  return TexSubImage3DOperationOverload9(info);
}
}
if (info[10]->IsNumber()) {
  return TexSubImage3DOperationOverload1(info);
}
return TexSubImage3DOperationOverload1(info);
}

if (info.Length() < 11) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(11, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void TransformFeedbackVaryingsOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_transformFeedbackVaryings");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.transformFeedbackVaryings");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_varyings = NativeValueTraits<IDLSequence<IDLString>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_buffer_mode = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->transformFeedbackVaryings(arg1_program, std::move(arg2_varyings), arg3_buffer_mode);

}

void Uniform1FOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, float v8_arg2_x, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
blink_receiver->uniform1f(arg1_location, arg2_x);
}

void Uniform1FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform1f");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform1f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform1f(arg1_location, arg2_x);

}

void Uniform1FvOperationNoAllocDirectCallOverload1Arg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform1fv(arg1_location, arg2_v);
}

void Uniform1FvOperationNoAllocDirectCallOverload2Arg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, uint32_t v8_arg4_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length = v8_arg4_src_length;
blink_receiver->uniform1fv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform1FvOperationNoAllocDirectCallOverload2Arg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length{0};
blink_receiver->uniform1fv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform1FvOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform1fv(arg1_location, arg2_v);

}

void Uniform1FvOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_length{0};
if (!info[3]->IsUndefined()) {
  arg4_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniform1fv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);

}

void Uniform1FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform1fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform1fv");


const int arg_count = std::min(info.Length(), 4);
if (arg_count == 4) {
  return Uniform1FvOperationOverload2(info);
}
if (arg_count == 3) {
  return Uniform1FvOperationOverload2(info);
}
if (arg_count == 2) {
  return Uniform1FvOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void Uniform1IOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, int32_t v8_arg2_x, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
blink_receiver->uniform1i(arg1_location, arg2_x);
}

void Uniform1IOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform1i");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform1i");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform1i(arg1_location, arg2_x);

}

void Uniform1IvOperationNoAllocDirectCallOverload1Arg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform1iv(arg1_location, arg2_v);
}

void Uniform1IvOperationNoAllocDirectCallOverload2Arg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, uint32_t v8_arg4_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length = v8_arg4_src_length;
blink_receiver->uniform1iv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform1IvOperationNoAllocDirectCallOverload2Arg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length{0};
blink_receiver->uniform1iv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform1IvOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform1iv(arg1_location, arg2_v);

}

void Uniform1IvOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_length{0};
if (!info[3]->IsUndefined()) {
  arg4_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniform1iv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);

}

void Uniform1IvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform1iv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform1iv");


const int arg_count = std::min(info.Length(), 4);
if (arg_count == 4) {
  return Uniform1IvOperationOverload2(info);
}
if (arg_count == 3) {
  return Uniform1IvOperationOverload2(info);
}
if (arg_count == 2) {
  return Uniform1IvOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void Uniform1UiOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform1ui");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform1ui");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v0 = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform1ui(arg1_location, arg2_v0);

}

void Uniform1UivOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, uint32_t v8_arg4_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length = v8_arg4_src_length;
blink_receiver->uniform1uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform1UivOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length{0};
blink_receiver->uniform1uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform1UivOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset{0};
auto&& arg4_src_length{0};
blink_receiver->uniform1uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform1UivOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform1uiv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform1uiv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_src_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_length{0};
if (!info[3]->IsUndefined()) {
  arg4_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniform1uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);

}

void Uniform2FOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, float v8_arg2_x, float v8_arg3_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
blink_receiver->uniform2f(arg1_location, arg2_x, arg3_y);
}

void Uniform2FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform2f");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform2f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform2f(arg1_location, arg2_x, arg3_y);

}

void Uniform2FvOperationNoAllocDirectCallOverload1Arg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform2fv(arg1_location, arg2_v);
}

void Uniform2FvOperationNoAllocDirectCallOverload2Arg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, uint32_t v8_arg4_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length = v8_arg4_src_length;
blink_receiver->uniform2fv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform2FvOperationNoAllocDirectCallOverload2Arg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length{0};
blink_receiver->uniform2fv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform2FvOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform2fv(arg1_location, arg2_v);

}

void Uniform2FvOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_length{0};
if (!info[3]->IsUndefined()) {
  arg4_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniform2fv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);

}

void Uniform2FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform2fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform2fv");


const int arg_count = std::min(info.Length(), 4);
if (arg_count == 4) {
  return Uniform2FvOperationOverload2(info);
}
if (arg_count == 3) {
  return Uniform2FvOperationOverload2(info);
}
if (arg_count == 2) {
  return Uniform2FvOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void Uniform2IOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, int32_t v8_arg2_x, int32_t v8_arg3_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
blink_receiver->uniform2i(arg1_location, arg2_x, arg3_y);
}

void Uniform2IOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform2i");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform2i");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform2i(arg1_location, arg2_x, arg3_y);

}

void Uniform2IvOperationNoAllocDirectCallOverload1Arg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform2iv(arg1_location, arg2_v);
}

void Uniform2IvOperationNoAllocDirectCallOverload2Arg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, uint32_t v8_arg4_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length = v8_arg4_src_length;
blink_receiver->uniform2iv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform2IvOperationNoAllocDirectCallOverload2Arg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length{0};
blink_receiver->uniform2iv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform2IvOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform2iv(arg1_location, arg2_v);

}

void Uniform2IvOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_length{0};
if (!info[3]->IsUndefined()) {
  arg4_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniform2iv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);

}

void Uniform2IvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform2iv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform2iv");


const int arg_count = std::min(info.Length(), 4);
if (arg_count == 4) {
  return Uniform2IvOperationOverload2(info);
}
if (arg_count == 3) {
  return Uniform2IvOperationOverload2(info);
}
if (arg_count == 2) {
  return Uniform2IvOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void Uniform2UiOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform2ui");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform2ui");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v0 = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_v_1 = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform2ui(arg1_location, arg2_v0, arg3_v_1);

}

void Uniform2UivOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, uint32_t v8_arg4_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length = v8_arg4_src_length;
blink_receiver->uniform2uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform2UivOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length{0};
blink_receiver->uniform2uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform2UivOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset{0};
auto&& arg4_src_length{0};
blink_receiver->uniform2uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform2UivOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform2uiv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform2uiv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_src_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_length{0};
if (!info[3]->IsUndefined()) {
  arg4_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniform2uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);

}

void Uniform3FOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, float v8_arg2_x, float v8_arg3_y, float v8_arg4_z, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
auto&& arg4_z = v8_arg4_z;
blink_receiver->uniform3f(arg1_location, arg2_x, arg3_y, arg4_z);
}

void Uniform3FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform3f");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform3f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_z = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform3f(arg1_location, arg2_x, arg3_y, arg4_z);

}

void Uniform3FvOperationNoAllocDirectCallOverload1Arg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform3fv(arg1_location, arg2_v);
}

void Uniform3FvOperationNoAllocDirectCallOverload2Arg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, uint32_t v8_arg4_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length = v8_arg4_src_length;
blink_receiver->uniform3fv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform3FvOperationNoAllocDirectCallOverload2Arg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length{0};
blink_receiver->uniform3fv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform3FvOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform3fv(arg1_location, arg2_v);

}

void Uniform3FvOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_length{0};
if (!info[3]->IsUndefined()) {
  arg4_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniform3fv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);

}

void Uniform3FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform3fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform3fv");


const int arg_count = std::min(info.Length(), 4);
if (arg_count == 4) {
  return Uniform3FvOperationOverload2(info);
}
if (arg_count == 3) {
  return Uniform3FvOperationOverload2(info);
}
if (arg_count == 2) {
  return Uniform3FvOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void Uniform3IOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, int32_t v8_arg2_x, int32_t v8_arg3_y, int32_t v8_arg4_z, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
auto&& arg4_z = v8_arg4_z;
blink_receiver->uniform3i(arg1_location, arg2_x, arg3_y, arg4_z);
}

void Uniform3IOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform3i");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform3i");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_z = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform3i(arg1_location, arg2_x, arg3_y, arg4_z);

}

void Uniform3IvOperationNoAllocDirectCallOverload1Arg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform3iv(arg1_location, arg2_v);
}

void Uniform3IvOperationNoAllocDirectCallOverload2Arg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, uint32_t v8_arg4_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length = v8_arg4_src_length;
blink_receiver->uniform3iv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform3IvOperationNoAllocDirectCallOverload2Arg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length{0};
blink_receiver->uniform3iv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform3IvOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform3iv(arg1_location, arg2_v);

}

void Uniform3IvOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_length{0};
if (!info[3]->IsUndefined()) {
  arg4_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniform3iv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);

}

void Uniform3IvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform3iv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform3iv");


const int arg_count = std::min(info.Length(), 4);
if (arg_count == 4) {
  return Uniform3IvOperationOverload2(info);
}
if (arg_count == 3) {
  return Uniform3IvOperationOverload2(info);
}
if (arg_count == 2) {
  return Uniform3IvOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void Uniform3UiOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform3ui");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform3ui");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v0 = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_v_1 = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_v_2 = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform3ui(arg1_location, arg2_v0, arg3_v_1, arg4_v_2);

}

void Uniform3UivOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, uint32_t v8_arg4_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length = v8_arg4_src_length;
blink_receiver->uniform3uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform3UivOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length{0};
blink_receiver->uniform3uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform3UivOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset{0};
auto&& arg4_src_length{0};
blink_receiver->uniform3uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform3UivOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform3uiv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform3uiv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_src_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_length{0};
if (!info[3]->IsUndefined()) {
  arg4_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniform3uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);

}

void Uniform4FOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, float v8_arg2_x, float v8_arg3_y, float v8_arg4_z, float v8_arg5_w, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
auto&& arg4_z = v8_arg4_z;
auto&& arg5_w = v8_arg5_w;
blink_receiver->uniform4f(arg1_location, arg2_x, arg3_y, arg4_z, arg5_w);
}

void Uniform4FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform4f");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform4f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_z = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_w = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform4f(arg1_location, arg2_x, arg3_y, arg4_z, arg5_w);

}

void Uniform4FvOperationNoAllocDirectCallOverload1Arg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform4fv(arg1_location, arg2_v);
}

void Uniform4FvOperationNoAllocDirectCallOverload2Arg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, uint32_t v8_arg4_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length = v8_arg4_src_length;
blink_receiver->uniform4fv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform4FvOperationNoAllocDirectCallOverload2Arg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length{0};
blink_receiver->uniform4fv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform4FvOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform4fv(arg1_location, arg2_v);

}

void Uniform4FvOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_length{0};
if (!info[3]->IsUndefined()) {
  arg4_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniform4fv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);

}

void Uniform4FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform4fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform4fv");


const int arg_count = std::min(info.Length(), 4);
if (arg_count == 4) {
  return Uniform4FvOperationOverload2(info);
}
if (arg_count == 3) {
  return Uniform4FvOperationOverload2(info);
}
if (arg_count == 2) {
  return Uniform4FvOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void Uniform4IOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, int32_t v8_arg2_x, int32_t v8_arg3_y, int32_t v8_arg4_z, int32_t v8_arg5_w, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
auto&& arg4_z = v8_arg4_z;
auto&& arg5_w = v8_arg5_w;
blink_receiver->uniform4i(arg1_location, arg2_x, arg3_y, arg4_z, arg5_w);
}

void Uniform4IOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform4i");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform4i");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_z = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_w = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform4i(arg1_location, arg2_x, arg3_y, arg4_z, arg5_w);

}

void Uniform4IvOperationNoAllocDirectCallOverload1Arg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform4iv(arg1_location, arg2_v);
}

void Uniform4IvOperationNoAllocDirectCallOverload2Arg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, uint32_t v8_arg4_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length = v8_arg4_src_length;
blink_receiver->uniform4iv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform4IvOperationNoAllocDirectCallOverload2Arg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length{0};
blink_receiver->uniform4iv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform4IvOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform4iv(arg1_location, arg2_v);

}

void Uniform4IvOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_length{0};
if (!info[3]->IsUndefined()) {
  arg4_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniform4iv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);

}

void Uniform4IvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform4iv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform4iv");


const int arg_count = std::min(info.Length(), 4);
if (arg_count == 4) {
  return Uniform4IvOperationOverload2(info);
}
if (arg_count == 3) {
  return Uniform4IvOperationOverload2(info);
}
if (arg_count == 2) {
  return Uniform4IvOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void Uniform4UiOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform4ui");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform4ui");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v0 = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_v_1 = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_v_2 = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_v_3 = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniform4ui(arg1_location, arg2_v0, arg3_v_1, arg4_v_2, arg5_v_3);

}

void Uniform4UivOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, uint32_t v8_arg4_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length = v8_arg4_src_length;
blink_receiver->uniform4uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform4UivOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, uint32_t v8_arg3_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset = v8_arg3_src_offset;
auto&& arg4_src_length{0};
blink_receiver->uniform4uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform4UivOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_src_offset{0};
auto&& arg4_src_length{0};
blink_receiver->uniform4uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);
}

void Uniform4UivOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniform4uiv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniform4uiv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg3_src_offset{0};
if (!info[2]->IsUndefined()) {
  arg3_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_length{0};
if (!info[3]->IsUndefined()) {
  arg4_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniform4uiv(arg1_location, arg2_v, arg3_src_offset, arg4_src_length);

}

void UniformBlockBindingOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniformBlockBinding");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniformBlockBinding");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_uniform_block_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_uniform_block_binding = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniformBlockBinding(arg1_program, arg2_uniform_block_index, arg3_uniform_block_binding);

}

void UniformMatrix2FvOperationNoAllocDirectCallOverload1Arg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_array, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_array, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniformMatrix2fv(arg1_location, arg2_transpose, arg3_array);
}

void UniformMatrix2FvOperationNoAllocDirectCallOverload2Arg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_array, uint32_t v8_arg4_src_offset, uint32_t v8_arg5_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_array, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length = v8_arg5_src_length;
blink_receiver->uniformMatrix2fv(arg1_location, arg2_transpose, arg3_array, arg4_src_offset, arg5_src_length);
}

void UniformMatrix2FvOperationNoAllocDirectCallOverload2Arg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_array, uint32_t v8_arg4_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_array, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix2fv(arg1_location, arg2_transpose, arg3_array, arg4_src_offset, arg5_src_length);
}

void UniformMatrix2FvOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniformMatrix2fv(arg1_location, arg2_transpose, arg3_array);

}

void UniformMatrix2FvOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_src_length{0};
if (!info[4]->IsUndefined()) {
  arg5_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniformMatrix2fv(arg1_location, arg2_transpose, arg3_array, arg4_src_offset, arg5_src_length);

}

void UniformMatrix2FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniformMatrix2fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniformMatrix2fv");


const int arg_count = std::min(info.Length(), 5);
if (arg_count == 5) {
  return UniformMatrix2FvOperationOverload2(info);
}
if (arg_count == 4) {
  return UniformMatrix2FvOperationOverload2(info);
}
if (arg_count == 3) {
  return UniformMatrix2FvOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void UniformMatrix2X3FvOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, uint32_t v8_arg5_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length = v8_arg5_src_length;
blink_receiver->uniformMatrix2x3fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix2X3FvOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix2x3fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix2X3FvOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset{0};
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix2x3fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix2X3FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniformMatrix2x3fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniformMatrix2x3fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_offset{0};
if (!info[3]->IsUndefined()) {
  arg4_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_src_length{0};
if (!info[4]->IsUndefined()) {
  arg5_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniformMatrix2x3fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);

}

void UniformMatrix2X4FvOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, uint32_t v8_arg5_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length = v8_arg5_src_length;
blink_receiver->uniformMatrix2x4fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix2X4FvOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix2x4fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix2X4FvOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset{0};
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix2x4fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix2X4FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniformMatrix2x4fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniformMatrix2x4fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_offset{0};
if (!info[3]->IsUndefined()) {
  arg4_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_src_length{0};
if (!info[4]->IsUndefined()) {
  arg5_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniformMatrix2x4fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);

}

void UniformMatrix3FvOperationNoAllocDirectCallOverload1Arg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_array, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_array, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniformMatrix3fv(arg1_location, arg2_transpose, arg3_array);
}

void UniformMatrix3FvOperationNoAllocDirectCallOverload2Arg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_array, uint32_t v8_arg4_src_offset, uint32_t v8_arg5_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_array, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length = v8_arg5_src_length;
blink_receiver->uniformMatrix3fv(arg1_location, arg2_transpose, arg3_array, arg4_src_offset, arg5_src_length);
}

void UniformMatrix3FvOperationNoAllocDirectCallOverload2Arg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_array, uint32_t v8_arg4_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_array, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix3fv(arg1_location, arg2_transpose, arg3_array, arg4_src_offset, arg5_src_length);
}

void UniformMatrix3FvOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniformMatrix3fv(arg1_location, arg2_transpose, arg3_array);

}

void UniformMatrix3FvOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_src_length{0};
if (!info[4]->IsUndefined()) {
  arg5_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniformMatrix3fv(arg1_location, arg2_transpose, arg3_array, arg4_src_offset, arg5_src_length);

}

void UniformMatrix3FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniformMatrix3fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniformMatrix3fv");


const int arg_count = std::min(info.Length(), 5);
if (arg_count == 5) {
  return UniformMatrix3FvOperationOverload2(info);
}
if (arg_count == 4) {
  return UniformMatrix3FvOperationOverload2(info);
}
if (arg_count == 3) {
  return UniformMatrix3FvOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void UniformMatrix3X2FvOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, uint32_t v8_arg5_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length = v8_arg5_src_length;
blink_receiver->uniformMatrix3x2fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix3X2FvOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix3x2fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix3X2FvOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset{0};
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix3x2fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix3X2FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniformMatrix3x2fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniformMatrix3x2fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_offset{0};
if (!info[3]->IsUndefined()) {
  arg4_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_src_length{0};
if (!info[4]->IsUndefined()) {
  arg5_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniformMatrix3x2fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);

}

void UniformMatrix3X4FvOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, uint32_t v8_arg5_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length = v8_arg5_src_length;
blink_receiver->uniformMatrix3x4fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix3X4FvOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix3x4fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix3X4FvOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset{0};
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix3x4fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix3X4FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniformMatrix3x4fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniformMatrix3x4fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_offset{0};
if (!info[3]->IsUndefined()) {
  arg4_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_src_length{0};
if (!info[4]->IsUndefined()) {
  arg5_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniformMatrix3x4fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);

}

void UniformMatrix4FvOperationNoAllocDirectCallOverload1Arg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_array, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_array, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniformMatrix4fv(arg1_location, arg2_transpose, arg3_array);
}

void UniformMatrix4FvOperationNoAllocDirectCallOverload2Arg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_array, uint32_t v8_arg4_src_offset, uint32_t v8_arg5_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_array, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length = v8_arg5_src_length;
blink_receiver->uniformMatrix4fv(arg1_location, arg2_transpose, arg3_array, arg4_src_offset, arg5_src_length);
}

void UniformMatrix4FvOperationNoAllocDirectCallOverload2Arg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_array, uint32_t v8_arg4_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_array, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix4fv(arg1_location, arg2_transpose, arg3_array, arg4_src_offset, arg5_src_length);
}

void UniformMatrix4FvOperationOverload1(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->uniformMatrix4fv(arg1_location, arg2_transpose, arg3_array);

}

void UniformMatrix4FvOperationOverload2(const v8::FunctionCallbackInfo<v8::Value>& info) {
  


v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_array = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_src_length{0};
if (!info[4]->IsUndefined()) {
  arg5_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniformMatrix4fv(arg1_location, arg2_transpose, arg3_array, arg4_src_offset, arg5_src_length);

}

void UniformMatrix4FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniformMatrix4fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniformMatrix4fv");


const int arg_count = std::min(info.Length(), 5);
if (arg_count == 5) {
  return UniformMatrix4FvOperationOverload2(info);
}
if (arg_count == 4) {
  return UniformMatrix4FvOperationOverload2(info);
}
if (arg_count == 3) {
  return UniformMatrix4FvOperationOverload1(info);
}

v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}
V8ThrowException::ThrowTypeError(isolate, "Overload resolution failed.");
return;
}

void UniformMatrix4X2FvOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, uint32_t v8_arg5_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length = v8_arg5_src_length;
blink_receiver->uniformMatrix4x2fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix4X2FvOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix4x2fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix4X2FvOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset{0};
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix4x2fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix4X2FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniformMatrix4x2fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniformMatrix4x2fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_offset{0};
if (!info[3]->IsUndefined()) {
  arg4_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_src_length{0};
if (!info[4]->IsUndefined()) {
  arg5_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniformMatrix4x2fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);

}

void UniformMatrix4X3FvOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, uint32_t v8_arg5_src_length, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length = v8_arg5_src_length;
blink_receiver->uniformMatrix4x3fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix4X3FvOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, uint32_t v8_arg4_src_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset = v8_arg4_src_offset;
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix4x3fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix4X3FvOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, v8::Local<v8::Value> v8_arg1_location, bool v8_arg2_transpose, v8::Local<v8::Value> v8_arg3_value, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);


v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, v8_arg1_location, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = v8_arg2_transpose;
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, v8_arg3_value, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_src_offset{0};
auto&& arg5_src_length{0};
blink_receiver->uniformMatrix4x3fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);
}

void UniformMatrix4X3FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_uniformMatrix4x3fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.uniformMatrix4x3fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_location = NativeValueTraits<IDLNullable<WebGLUniformLocation>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_transpose = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_value = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg4_src_offset{0};
if (!info[3]->IsUndefined()) {
  arg4_src_offset = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
decltype(NativeValueTraits<IDLUnsignedLong>::NativeValue(std::declval<v8::Isolate*>(), std::declval<v8::Local<v8::Value>>(), std::declval<ExceptionState&>())) arg5_src_length{0};
if (!info[4]->IsUndefined()) {
  arg5_src_length = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
}
blink_receiver->uniformMatrix4x3fv(arg1_location, arg2_transpose, arg3_value, arg4_src_offset, arg5_src_length);

}

void UseProgramOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_useProgram");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.useProgram");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<IDLNullable<WebGLProgram>>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->useProgram(arg1_program);

}

void ValidateProgramOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_validateProgram");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.validateProgram");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 1) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(1, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_program = NativeValueTraits<WebGLProgram>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->validateProgram(arg1_program);

}

void VertexAttrib1FOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, float v8_arg2_x, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
auto&& arg2_x = v8_arg2_x;
blink_receiver->vertexAttrib1f(arg1_indx, arg2_x);
}

void VertexAttrib1FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttrib1f");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttrib1f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib1f(arg1_indx, arg2_x);

}

void VertexAttrib1FvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, v8::Local<v8::Value> v8_arg2_values, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
ExceptionState exception_state(isolate);
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_values, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib1fv(arg1_indx, arg2_values);
}

void VertexAttrib1FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttrib1fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttrib1fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib1fv(arg1_indx, arg2_values);

}

void VertexAttrib2FOperationNoAllocDirectCallArg3(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, float v8_arg2_x, float v8_arg3_y, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
blink_receiver->vertexAttrib2f(arg1_indx, arg2_x, arg3_y);
}

void VertexAttrib2FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttrib2f");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttrib2f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib2f(arg1_indx, arg2_x, arg3_y);

}

void VertexAttrib2FvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, v8::Local<v8::Value> v8_arg2_values, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
ExceptionState exception_state(isolate);
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_values, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib2fv(arg1_indx, arg2_values);
}

void VertexAttrib2FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttrib2fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttrib2fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib2fv(arg1_indx, arg2_values);

}

void VertexAttrib3FOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, float v8_arg2_x, float v8_arg3_y, float v8_arg4_z, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
auto&& arg4_z = v8_arg4_z;
blink_receiver->vertexAttrib3f(arg1_indx, arg2_x, arg3_y, arg4_z);
}

void VertexAttrib3FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttrib3f");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttrib3f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_z = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib3f(arg1_indx, arg2_x, arg3_y, arg4_z);

}

void VertexAttrib3FvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, v8::Local<v8::Value> v8_arg2_values, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
ExceptionState exception_state(isolate);
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_values, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib3fv(arg1_indx, arg2_values);
}

void VertexAttrib3FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttrib3fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttrib3fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib3fv(arg1_indx, arg2_values);

}

void VertexAttrib4FOperationNoAllocDirectCallArg5(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, float v8_arg2_x, float v8_arg3_y, float v8_arg4_z, float v8_arg5_w, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
auto&& arg2_x = v8_arg2_x;
auto&& arg3_y = v8_arg3_y;
auto&& arg4_z = v8_arg4_z;
auto&& arg5_w = v8_arg5_w;
blink_receiver->vertexAttrib4f(arg1_indx, arg2_x, arg3_y, arg4_z, arg5_w);
}

void VertexAttrib4FOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttrib4f");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttrib4f");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_z = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_w = NativeValueTraits<IDLUnrestrictedFloat>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib4f(arg1_indx, arg2_x, arg3_y, arg4_z, arg5_w);

}

void VertexAttrib4FvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, v8::Local<v8::Value> v8_arg2_values, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
ExceptionState exception_state(isolate);
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, v8_arg2_values, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib4fv(arg1_indx, arg2_values);
}

void VertexAttrib4FvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttrib4fv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttrib4fv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_values = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, float>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttrib4fv(arg1_indx, arg2_values);

}

void VertexAttribDivisorOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttribDivisor");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttribDivisor");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_divisor = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttribDivisor(arg1_index, arg2_divisor);

}

void VertexAttribI4IOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttribI4i");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttribI4i");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_z = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_w = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttribI4i(arg1_index, arg2_x, arg3_y, arg4_z, arg5_w);

}

void VertexAttribI4IvOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
ExceptionState exception_state(isolate);
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttribI4iv(arg1_index, arg2_v);
}

void VertexAttribI4IvOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttribI4iv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttribI4iv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, int32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttribI4iv(arg1_index, arg2_v);

}

void VertexAttribI4UiOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttribI4ui");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttribI4ui");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_x = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_y = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_z = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_w = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttribI4ui(arg1_index, arg2_x, arg3_y, arg4_z, arg5_w);

}

void VertexAttribI4UivOperationNoAllocDirectCallArg2(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_index, v8::Local<v8::Value> v8_arg2_v, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::HandleScope handle_scope(isolate);

v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_index = v8_arg1_index;
ExceptionState exception_state(isolate);
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, v8_arg2_v, exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttribI4uiv(arg1_index, arg2_v);
}

void VertexAttribI4UivOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttribI4uiv");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttribI4uiv");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 2) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(2, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_v = NativeValueTraits<PassAsSpan<PassAsSpanMarkerBase::Flags::kAllowSequence | PassAsSpanMarkerBase::Flags::kAllowShared, uint32_t>>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttribI4uiv(arg1_index, arg2_v);

}

void VertexAttribIPointerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttribIPointer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttribIPointer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 5) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(5, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_index = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_size = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_stride = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttribIPointer(arg1_index, arg2_size, arg3_type, arg4_stride, arg5_offset);

}

void VertexAttribPointerOperationNoAllocDirectCallArg6(v8::Local<v8::Object> v8_arg0_receiver, uint32_t v8_arg1_indx, int32_t v8_arg2_size, uint32_t v8_arg3_type, bool v8_arg4_normalized, int32_t v8_arg5_stride, int64_t v8_arg6_offset, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_indx = v8_arg1_indx;
auto&& arg2_size = v8_arg2_size;
auto&& arg3_type = v8_arg3_type;
auto&& arg4_normalized = v8_arg4_normalized;
auto&& arg5_stride = v8_arg5_stride;
auto&& arg6_offset = v8_arg6_offset;
blink_receiver->vertexAttribPointer(arg1_indx, arg2_size, arg3_type, arg4_normalized, arg5_stride, arg6_offset);
}

void VertexAttribPointerOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_vertexAttribPointer");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.vertexAttribPointer");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 6) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(6, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_indx = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_size = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_type = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_normalized = NativeValueTraits<IDLBoolean>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg5_stride = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 4, info[4], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg6_offset = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 5, info[5], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->vertexAttribPointer(arg1_indx, arg2_size, arg3_type, arg4_normalized, arg5_stride, arg6_offset);

}

void ViewportOperationNoAllocDirectCallArg4(v8::Local<v8::Object> v8_arg0_receiver, int32_t v8_arg1_x, int32_t v8_arg2_y, int32_t v8_arg3_width, int32_t v8_arg4_height, v8::FastApiCallbackOptions& v8_arg_callback_options) {
  v8::Isolate* isolate = v8_arg_callback_options.isolate;
v8::Local<v8::Object> v8_receiver = v8_arg0_receiver;
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
auto&& arg1_x = v8_arg1_x;
auto&& arg2_y = v8_arg2_y;
auto&& arg3_width = v8_arg3_width;
auto&& arg4_height = v8_arg4_height;
blink_receiver->viewport(arg1_x, arg2_y, arg3_width, arg4_height);
}

void ViewportOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_viewport");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.viewport");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 4) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(4, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_x = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_y = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_width = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg4_height = NativeValueTraits<IDLLong>::ArgumentValue(isolate, 3, info[3], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->viewport(arg1_x, arg2_y, arg3_width, arg4_height);

}

void WaitSyncOperationCallback(const v8::FunctionCallbackInfo<v8::Value>& info) {
  RUNTIME_CALL_TIMER_SCOPE_DISABLED_BY_DEFAULT(info.GetIsolate(), "Blink_WebGL2RenderingContext_waitSync");
BLINK_BINDINGS_TRACE_EVENT("WebGL2RenderingContext.waitSync");




v8::Isolate* isolate = info.GetIsolate();
if (info.Length() < 3) [[unlikely]] {
  V8ThrowException::ThrowTypeError(isolate, ExceptionMessages::NotEnoughArguments(3, info.Length()));
return;
}


v8::Local<v8::Object> v8_receiver = info.This();
WebGL2RenderingContext* blink_receiver = V8WebGL2RenderingContext::ToWrappableUnsafe(isolate, v8_receiver);
ExceptionState exception_state(isolate);
auto&& arg1_sync = NativeValueTraits<WebGLSync>::ArgumentValue(isolate, 0, info[0], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg2_flags = NativeValueTraits<IDLUnsignedLong>::ArgumentValue(isolate, 1, info[1], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
auto&& arg3_timeout = NativeValueTraits<IDLLongLong>::ArgumentValue(isolate, 2, info[2], exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return;
}
blink_receiver->waitSync(arg1_sync, arg2_flags, arg3_timeout);

}


}  // namespace v8_webgl2_rendering_context

using namespace v8_webgl2_rendering_context;

}  // namespace 

void V8WebGL2RenderingContext::InstallInterfaceTemplate(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::Template> interface_template) {
  const WrapperTypeInfo* const wrapper_type_info = V8WebGL2RenderingContext::GetWrapperTypeInfo();
v8::Local<v8::FunctionTemplate> interface_function_template = interface_template.As<v8::FunctionTemplate>();
v8::Local<v8::ObjectTemplate> instance_template = interface_function_template->InstanceTemplate();
v8::Local<v8::ObjectTemplate> prototype_template = interface_function_template->PrototypeTemplate();
v8::Local<v8::FunctionTemplate> parent_interface_template;
bindings::SetupIDLInterfaceTemplate(isolate, wrapper_type_info, instance_template, prototype_template, interface_function_template, parent_interface_template);






InstallUnconditionalProperties(isolate, world, instance_template, prototype_template, interface_template);
InstallContextIndependentProperties(isolate, world, instance_template, prototype_template, interface_template);
}

void V8WebGL2RenderingContext::InstallUnconditionalProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
{
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"canvas", CanvasAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"drawingBufferWidth", DrawingBufferWidthAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"drawingBufferHeight", DrawingBufferHeightAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"drawingBufferColorSpace", DrawingBufferColorSpaceAttributeGetCallback, DrawingBufferColorSpaceAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
{"unpackColorSpace", UnpackColorSpaceAttributeGetCallback, UnpackColorSpaceAttributeSetCallback, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGL2RenderingContext", kAttributeTable);
}



{
  static const IDLMemberInstaller::ConstantValueConfig kConstantValueTable[] = {
{"DEPTH_BUFFER_BIT", V8WebGL2RenderingContext::Constant::kDepthBufferBit},
{"STENCIL_BUFFER_BIT", V8WebGL2RenderingContext::Constant::kStencilBufferBit},
{"COLOR_BUFFER_BIT", V8WebGL2RenderingContext::Constant::kColorBufferBit},
{"POINTS", V8WebGL2RenderingContext::Constant::kPoints},
{"LINES", V8WebGL2RenderingContext::Constant::kLines},
{"LINE_LOOP", V8WebGL2RenderingContext::Constant::kLineLoop},
{"LINE_STRIP", V8WebGL2RenderingContext::Constant::kLineStrip},
{"TRIANGLES", V8WebGL2RenderingContext::Constant::kTriangles},
{"TRIANGLE_STRIP", V8WebGL2RenderingContext::Constant::kTriangleStrip},
{"TRIANGLE_FAN", V8WebGL2RenderingContext::Constant::kTriangleFan},
{"ZERO", V8WebGL2RenderingContext::Constant::kZero},
{"ONE", V8WebGL2RenderingContext::Constant::kOne},
{"SRC_COLOR", V8WebGL2RenderingContext::Constant::kSrcColor},
{"ONE_MINUS_SRC_COLOR", V8WebGL2RenderingContext::Constant::kOneMinusSrcColor},
{"SRC_ALPHA", V8WebGL2RenderingContext::Constant::kSrcAlpha},
{"ONE_MINUS_SRC_ALPHA", V8WebGL2RenderingContext::Constant::kOneMinusSrcAlpha},
{"DST_ALPHA", V8WebGL2RenderingContext::Constant::kDstAlpha},
{"ONE_MINUS_DST_ALPHA", V8WebGL2RenderingContext::Constant::kOneMinusDstAlpha},
{"DST_COLOR", V8WebGL2RenderingContext::Constant::kDstColor},
{"ONE_MINUS_DST_COLOR", V8WebGL2RenderingContext::Constant::kOneMinusDstColor},
{"SRC_ALPHA_SATURATE", V8WebGL2RenderingContext::Constant::kSrcAlphaSaturate},
{"FUNC_ADD", V8WebGL2RenderingContext::Constant::kFuncAdd},
{"BLEND_EQUATION", V8WebGL2RenderingContext::Constant::kBlendEquation},
{"BLEND_EQUATION_RGB", V8WebGL2RenderingContext::Constant::kBlendEquationRgb},
{"BLEND_EQUATION_ALPHA", V8WebGL2RenderingContext::Constant::kBlendEquationAlpha},
{"FUNC_SUBTRACT", V8WebGL2RenderingContext::Constant::kFuncSubtract},
{"FUNC_REVERSE_SUBTRACT", V8WebGL2RenderingContext::Constant::kFuncReverseSubtract},
{"BLEND_DST_RGB", V8WebGL2RenderingContext::Constant::kBlendDstRgb},
{"BLEND_SRC_RGB", V8WebGL2RenderingContext::Constant::kBlendSrcRgb},
{"BLEND_DST_ALPHA", V8WebGL2RenderingContext::Constant::kBlendDstAlpha},
{"BLEND_SRC_ALPHA", V8WebGL2RenderingContext::Constant::kBlendSrcAlpha},
{"CONSTANT_COLOR", V8WebGL2RenderingContext::Constant::kConstantColor},
{"ONE_MINUS_CONSTANT_COLOR", V8WebGL2RenderingContext::Constant::kOneMinusConstantColor},
{"CONSTANT_ALPHA", V8WebGL2RenderingContext::Constant::kConstantAlpha},
{"ONE_MINUS_CONSTANT_ALPHA", V8WebGL2RenderingContext::Constant::kOneMinusConstantAlpha},
{"BLEND_COLOR", V8WebGL2RenderingContext::Constant::kBlendColor},
{"ARRAY_BUFFER", V8WebGL2RenderingContext::Constant::kArrayBuffer},
{"ELEMENT_ARRAY_BUFFER", V8WebGL2RenderingContext::Constant::kElementArrayBuffer},
{"ARRAY_BUFFER_BINDING", V8WebGL2RenderingContext::Constant::kArrayBufferBinding},
{"ELEMENT_ARRAY_BUFFER_BINDING", V8WebGL2RenderingContext::Constant::kElementArrayBufferBinding},
{"STREAM_DRAW", V8WebGL2RenderingContext::Constant::kStreamDraw},
{"STATIC_DRAW", V8WebGL2RenderingContext::Constant::kStaticDraw},
{"DYNAMIC_DRAW", V8WebGL2RenderingContext::Constant::kDynamicDraw},
{"BUFFER_SIZE", V8WebGL2RenderingContext::Constant::kBufferSize},
{"BUFFER_USAGE", V8WebGL2RenderingContext::Constant::kBufferUsage},
{"CURRENT_VERTEX_ATTRIB", V8WebGL2RenderingContext::Constant::kCurrentVertexAttrib},
{"FRONT", V8WebGL2RenderingContext::Constant::kFront},
{"BACK", V8WebGL2RenderingContext::Constant::kBack},
{"FRONT_AND_BACK", V8WebGL2RenderingContext::Constant::kFrontAndBack},
{"TEXTURE_2D", V8WebGL2RenderingContext::Constant::kTexture2d},
{"CULL_FACE", V8WebGL2RenderingContext::Constant::kCullFace},
{"BLEND", V8WebGL2RenderingContext::Constant::kBlend},
{"DITHER", V8WebGL2RenderingContext::Constant::kDither},
{"STENCIL_TEST", V8WebGL2RenderingContext::Constant::kStencilTest},
{"DEPTH_TEST", V8WebGL2RenderingContext::Constant::kDepthTest},
{"SCISSOR_TEST", V8WebGL2RenderingContext::Constant::kScissorTest},
{"POLYGON_OFFSET_FILL", V8WebGL2RenderingContext::Constant::kPolygonOffsetFill},
{"SAMPLE_ALPHA_TO_COVERAGE", V8WebGL2RenderingContext::Constant::kSampleAlphaToCoverage},
{"SAMPLE_COVERAGE", V8WebGL2RenderingContext::Constant::kSampleCoverage},
{"NO_ERROR", V8WebGL2RenderingContext::Constant::kNoError},
{"INVALID_ENUM", V8WebGL2RenderingContext::Constant::kInvalidEnum},
{"INVALID_VALUE", V8WebGL2RenderingContext::Constant::kInvalidValue},
{"INVALID_OPERATION", V8WebGL2RenderingContext::Constant::kInvalidOperation},
{"OUT_OF_MEMORY", V8WebGL2RenderingContext::Constant::kOutOfMemory},
{"CW", V8WebGL2RenderingContext::Constant::kCw},
{"CCW", V8WebGL2RenderingContext::Constant::kCcw},
{"LINE_WIDTH", V8WebGL2RenderingContext::Constant::kLineWidth},
{"ALIASED_POINT_SIZE_RANGE", V8WebGL2RenderingContext::Constant::kAliasedPointSizeRange},
{"ALIASED_LINE_WIDTH_RANGE", V8WebGL2RenderingContext::Constant::kAliasedLineWidthRange},
{"CULL_FACE_MODE", V8WebGL2RenderingContext::Constant::kCullFaceMode},
{"FRONT_FACE", V8WebGL2RenderingContext::Constant::kFrontFace},
{"DEPTH_RANGE", V8WebGL2RenderingContext::Constant::kDepthRange},
{"DEPTH_WRITEMASK", V8WebGL2RenderingContext::Constant::kDepthWritemask},
{"DEPTH_CLEAR_VALUE", V8WebGL2RenderingContext::Constant::kDepthClearValue},
{"DEPTH_FUNC", V8WebGL2RenderingContext::Constant::kDepthFunc},
{"STENCIL_CLEAR_VALUE", V8WebGL2RenderingContext::Constant::kStencilClearValue},
{"STENCIL_FUNC", V8WebGL2RenderingContext::Constant::kStencilFunc},
{"STENCIL_FAIL", V8WebGL2RenderingContext::Constant::kStencilFail},
{"STENCIL_PASS_DEPTH_FAIL", V8WebGL2RenderingContext::Constant::kStencilPassDepthFail},
{"STENCIL_PASS_DEPTH_PASS", V8WebGL2RenderingContext::Constant::kStencilPassDepthPass},
{"STENCIL_REF", V8WebGL2RenderingContext::Constant::kStencilRef},
{"STENCIL_VALUE_MASK", V8WebGL2RenderingContext::Constant::kStencilValueMask},
{"STENCIL_WRITEMASK", V8WebGL2RenderingContext::Constant::kStencilWritemask},
{"STENCIL_BACK_FUNC", V8WebGL2RenderingContext::Constant::kStencilBackFunc},
{"STENCIL_BACK_FAIL", V8WebGL2RenderingContext::Constant::kStencilBackFail},
{"STENCIL_BACK_PASS_DEPTH_FAIL", V8WebGL2RenderingContext::Constant::kStencilBackPassDepthFail},
{"STENCIL_BACK_PASS_DEPTH_PASS", V8WebGL2RenderingContext::Constant::kStencilBackPassDepthPass},
{"STENCIL_BACK_REF", V8WebGL2RenderingContext::Constant::kStencilBackRef},
{"STENCIL_BACK_VALUE_MASK", V8WebGL2RenderingContext::Constant::kStencilBackValueMask},
{"STENCIL_BACK_WRITEMASK", V8WebGL2RenderingContext::Constant::kStencilBackWritemask},
{"VIEWPORT", V8WebGL2RenderingContext::Constant::kViewport},
{"SCISSOR_BOX", V8WebGL2RenderingContext::Constant::kScissorBox},
{"COLOR_CLEAR_VALUE", V8WebGL2RenderingContext::Constant::kColorClearValue},
{"COLOR_WRITEMASK", V8WebGL2RenderingContext::Constant::kColorWritemask},
{"UNPACK_ALIGNMENT", V8WebGL2RenderingContext::Constant::kUnpackAlignment},
{"PACK_ALIGNMENT", V8WebGL2RenderingContext::Constant::kPackAlignment},
{"MAX_TEXTURE_SIZE", V8WebGL2RenderingContext::Constant::kMaxTextureSize},
{"MAX_VIEWPORT_DIMS", V8WebGL2RenderingContext::Constant::kMaxViewportDims},
{"SUBPIXEL_BITS", V8WebGL2RenderingContext::Constant::kSubpixelBits},
{"RED_BITS", V8WebGL2RenderingContext::Constant::kRedBits},
{"GREEN_BITS", V8WebGL2RenderingContext::Constant::kGreenBits},
{"BLUE_BITS", V8WebGL2RenderingContext::Constant::kBlueBits},
{"ALPHA_BITS", V8WebGL2RenderingContext::Constant::kAlphaBits},
{"DEPTH_BITS", V8WebGL2RenderingContext::Constant::kDepthBits},
{"STENCIL_BITS", V8WebGL2RenderingContext::Constant::kStencilBits},
{"POLYGON_OFFSET_UNITS", V8WebGL2RenderingContext::Constant::kPolygonOffsetUnits},
{"POLYGON_OFFSET_FACTOR", V8WebGL2RenderingContext::Constant::kPolygonOffsetFactor},
{"TEXTURE_BINDING_2D", V8WebGL2RenderingContext::Constant::kTextureBinding2d},
{"SAMPLE_BUFFERS", V8WebGL2RenderingContext::Constant::kSampleBuffers},
{"SAMPLES", V8WebGL2RenderingContext::Constant::kSamples},
{"SAMPLE_COVERAGE_VALUE", V8WebGL2RenderingContext::Constant::kSampleCoverageValue},
{"SAMPLE_COVERAGE_INVERT", V8WebGL2RenderingContext::Constant::kSampleCoverageInvert},
{"COMPRESSED_TEXTURE_FORMATS", V8WebGL2RenderingContext::Constant::kCompressedTextureFormats},
{"DONT_CARE", V8WebGL2RenderingContext::Constant::kDontCare},
{"FASTEST", V8WebGL2RenderingContext::Constant::kFastest},
{"NICEST", V8WebGL2RenderingContext::Constant::kNicest},
{"GENERATE_MIPMAP_HINT", V8WebGL2RenderingContext::Constant::kGenerateMipmapHint},
{"BYTE", V8WebGL2RenderingContext::Constant::kByte},
{"UNSIGNED_BYTE", V8WebGL2RenderingContext::Constant::kUnsignedByte},
{"SHORT", V8WebGL2RenderingContext::Constant::kShort},
{"UNSIGNED_SHORT", V8WebGL2RenderingContext::Constant::kUnsignedShort},
{"INT", V8WebGL2RenderingContext::Constant::kInt},
{"UNSIGNED_INT", V8WebGL2RenderingContext::Constant::kUnsignedInt},
{"FLOAT", V8WebGL2RenderingContext::Constant::kFloat},
{"DEPTH_COMPONENT", V8WebGL2RenderingContext::Constant::kDepthComponent},
{"ALPHA", V8WebGL2RenderingContext::Constant::kAlpha},
{"RGB", V8WebGL2RenderingContext::Constant::kRgb},
{"RGBA", V8WebGL2RenderingContext::Constant::kRgba},
{"LUMINANCE", V8WebGL2RenderingContext::Constant::kLuminance},
{"LUMINANCE_ALPHA", V8WebGL2RenderingContext::Constant::kLuminanceAlpha},
{"UNSIGNED_SHORT_4_4_4_4", V8WebGL2RenderingContext::Constant::kUnsignedShort4444},
{"UNSIGNED_SHORT_5_5_5_1", V8WebGL2RenderingContext::Constant::kUnsignedShort5551},
{"UNSIGNED_SHORT_5_6_5", V8WebGL2RenderingContext::Constant::kUnsignedShort565},
{"FRAGMENT_SHADER", V8WebGL2RenderingContext::Constant::kFragmentShader},
{"VERTEX_SHADER", V8WebGL2RenderingContext::Constant::kVertexShader},
{"MAX_VERTEX_ATTRIBS", V8WebGL2RenderingContext::Constant::kMaxVertexAttribs},
{"MAX_VERTEX_UNIFORM_VECTORS", V8WebGL2RenderingContext::Constant::kMaxVertexUniformVectors},
{"MAX_VARYING_VECTORS", V8WebGL2RenderingContext::Constant::kMaxVaryingVectors},
{"MAX_COMBINED_TEXTURE_IMAGE_UNITS", V8WebGL2RenderingContext::Constant::kMaxCombinedTextureImageUnits},
{"MAX_VERTEX_TEXTURE_IMAGE_UNITS", V8WebGL2RenderingContext::Constant::kMaxVertexTextureImageUnits},
{"MAX_TEXTURE_IMAGE_UNITS", V8WebGL2RenderingContext::Constant::kMaxTextureImageUnits},
{"MAX_FRAGMENT_UNIFORM_VECTORS", V8WebGL2RenderingContext::Constant::kMaxFragmentUniformVectors},
{"SHADER_TYPE", V8WebGL2RenderingContext::Constant::kShaderType},
{"DELETE_STATUS", V8WebGL2RenderingContext::Constant::kDeleteStatus},
{"LINK_STATUS", V8WebGL2RenderingContext::Constant::kLinkStatus},
{"VALIDATE_STATUS", V8WebGL2RenderingContext::Constant::kValidateStatus},
{"ATTACHED_SHADERS", V8WebGL2RenderingContext::Constant::kAttachedShaders},
{"ACTIVE_UNIFORMS", V8WebGL2RenderingContext::Constant::kActiveUniforms},
{"ACTIVE_ATTRIBUTES", V8WebGL2RenderingContext::Constant::kActiveAttributes},
{"SHADING_LANGUAGE_VERSION", V8WebGL2RenderingContext::Constant::kShadingLanguageVersion},
{"CURRENT_PROGRAM", V8WebGL2RenderingContext::Constant::kCurrentProgram},
{"NEVER", V8WebGL2RenderingContext::Constant::kNever},
{"LESS", V8WebGL2RenderingContext::Constant::kLess},
{"EQUAL", V8WebGL2RenderingContext::Constant::kEqual},
{"LEQUAL", V8WebGL2RenderingContext::Constant::kLequal},
{"GREATER", V8WebGL2RenderingContext::Constant::kGreater},
{"NOTEQUAL", V8WebGL2RenderingContext::Constant::kNotequal},
{"GEQUAL", V8WebGL2RenderingContext::Constant::kGequal},
{"ALWAYS", V8WebGL2RenderingContext::Constant::kAlways},
{"KEEP", V8WebGL2RenderingContext::Constant::kKeep},
{"REPLACE", V8WebGL2RenderingContext::Constant::kReplace},
{"INCR", V8WebGL2RenderingContext::Constant::kIncr},
{"DECR", V8WebGL2RenderingContext::Constant::kDecr},
{"INVERT", V8WebGL2RenderingContext::Constant::kInvert},
{"INCR_WRAP", V8WebGL2RenderingContext::Constant::kIncrWrap},
{"DECR_WRAP", V8WebGL2RenderingContext::Constant::kDecrWrap},
{"VENDOR", V8WebGL2RenderingContext::Constant::kVendor},
{"RENDERER", V8WebGL2RenderingContext::Constant::kRenderer},
{"VERSION", V8WebGL2RenderingContext::Constant::kVersion},
{"NEAREST", V8WebGL2RenderingContext::Constant::kNearest},
{"LINEAR", V8WebGL2RenderingContext::Constant::kLinear},
{"NEAREST_MIPMAP_NEAREST", V8WebGL2RenderingContext::Constant::kNearestMipmapNearest},
{"LINEAR_MIPMAP_NEAREST", V8WebGL2RenderingContext::Constant::kLinearMipmapNearest},
{"NEAREST_MIPMAP_LINEAR", V8WebGL2RenderingContext::Constant::kNearestMipmapLinear},
{"LINEAR_MIPMAP_LINEAR", V8WebGL2RenderingContext::Constant::kLinearMipmapLinear},
{"TEXTURE_MAG_FILTER", V8WebGL2RenderingContext::Constant::kTextureMagFilter},
{"TEXTURE_MIN_FILTER", V8WebGL2RenderingContext::Constant::kTextureMinFilter},
{"TEXTURE_WRAP_S", V8WebGL2RenderingContext::Constant::kTextureWrapS},
{"TEXTURE_WRAP_T", V8WebGL2RenderingContext::Constant::kTextureWrapT},
{"TEXTURE", V8WebGL2RenderingContext::Constant::kTexture},
{"TEXTURE_CUBE_MAP", V8WebGL2RenderingContext::Constant::kTextureCubeMap},
{"TEXTURE_BINDING_CUBE_MAP", V8WebGL2RenderingContext::Constant::kTextureBindingCubeMap},
{"TEXTURE_CUBE_MAP_POSITIVE_X", V8WebGL2RenderingContext::Constant::kTextureCubeMapPositiveX},
{"TEXTURE_CUBE_MAP_NEGATIVE_X", V8WebGL2RenderingContext::Constant::kTextureCubeMapNegativeX},
{"TEXTURE_CUBE_MAP_POSITIVE_Y", V8WebGL2RenderingContext::Constant::kTextureCubeMapPositiveY},
{"TEXTURE_CUBE_MAP_NEGATIVE_Y", V8WebGL2RenderingContext::Constant::kTextureCubeMapNegativeY},
{"TEXTURE_CUBE_MAP_POSITIVE_Z", V8WebGL2RenderingContext::Constant::kTextureCubeMapPositiveZ},
{"TEXTURE_CUBE_MAP_NEGATIVE_Z", V8WebGL2RenderingContext::Constant::kTextureCubeMapNegativeZ},
{"MAX_CUBE_MAP_TEXTURE_SIZE", V8WebGL2RenderingContext::Constant::kMaxCubeMapTextureSize},
{"TEXTURE0", V8WebGL2RenderingContext::Constant::kTexture0},
{"TEXTURE1", V8WebGL2RenderingContext::Constant::kTexture1},
{"TEXTURE2", V8WebGL2RenderingContext::Constant::kTexture2},
{"TEXTURE3", V8WebGL2RenderingContext::Constant::kTexture3},
{"TEXTURE4", V8WebGL2RenderingContext::Constant::kTexture4},
{"TEXTURE5", V8WebGL2RenderingContext::Constant::kTexture5},
{"TEXTURE6", V8WebGL2RenderingContext::Constant::kTexture6},
{"TEXTURE7", V8WebGL2RenderingContext::Constant::kTexture7},
{"TEXTURE8", V8WebGL2RenderingContext::Constant::kTexture8},
{"TEXTURE9", V8WebGL2RenderingContext::Constant::kTexture9},
{"TEXTURE10", V8WebGL2RenderingContext::Constant::kTexture10},
{"TEXTURE11", V8WebGL2RenderingContext::Constant::kTexture11},
{"TEXTURE12", V8WebGL2RenderingContext::Constant::kTexture12},
{"TEXTURE13", V8WebGL2RenderingContext::Constant::kTexture13},
{"TEXTURE14", V8WebGL2RenderingContext::Constant::kTexture14},
{"TEXTURE15", V8WebGL2RenderingContext::Constant::kTexture15},
{"TEXTURE16", V8WebGL2RenderingContext::Constant::kTexture16},
{"TEXTURE17", V8WebGL2RenderingContext::Constant::kTexture17},
{"TEXTURE18", V8WebGL2RenderingContext::Constant::kTexture18},
{"TEXTURE19", V8WebGL2RenderingContext::Constant::kTexture19},
{"TEXTURE20", V8WebGL2RenderingContext::Constant::kTexture20},
{"TEXTURE21", V8WebGL2RenderingContext::Constant::kTexture21},
{"TEXTURE22", V8WebGL2RenderingContext::Constant::kTexture22},
{"TEXTURE23", V8WebGL2RenderingContext::Constant::kTexture23},
{"TEXTURE24", V8WebGL2RenderingContext::Constant::kTexture24},
{"TEXTURE25", V8WebGL2RenderingContext::Constant::kTexture25},
{"TEXTURE26", V8WebGL2RenderingContext::Constant::kTexture26},
{"TEXTURE27", V8WebGL2RenderingContext::Constant::kTexture27},
{"TEXTURE28", V8WebGL2RenderingContext::Constant::kTexture28},
{"TEXTURE29", V8WebGL2RenderingContext::Constant::kTexture29},
{"TEXTURE30", V8WebGL2RenderingContext::Constant::kTexture30},
{"TEXTURE31", V8WebGL2RenderingContext::Constant::kTexture31},
{"ACTIVE_TEXTURE", V8WebGL2RenderingContext::Constant::kActiveTexture},
{"REPEAT", V8WebGL2RenderingContext::Constant::kRepeat},
{"CLAMP_TO_EDGE", V8WebGL2RenderingContext::Constant::kClampToEdge},
{"MIRRORED_REPEAT", V8WebGL2RenderingContext::Constant::kMirroredRepeat},
{"FLOAT_VEC2", V8WebGL2RenderingContext::Constant::kFloatVec2},
{"FLOAT_VEC3", V8WebGL2RenderingContext::Constant::kFloatVec3},
{"FLOAT_VEC4", V8WebGL2RenderingContext::Constant::kFloatVec4},
{"INT_VEC2", V8WebGL2RenderingContext::Constant::kIntVec2},
{"INT_VEC3", V8WebGL2RenderingContext::Constant::kIntVec3},
{"INT_VEC4", V8WebGL2RenderingContext::Constant::kIntVec4},
{"BOOL", V8WebGL2RenderingContext::Constant::kBool},
{"BOOL_VEC2", V8WebGL2RenderingContext::Constant::kBoolVec2},
{"BOOL_VEC3", V8WebGL2RenderingContext::Constant::kBoolVec3},
{"BOOL_VEC4", V8WebGL2RenderingContext::Constant::kBoolVec4},
{"FLOAT_MAT2", V8WebGL2RenderingContext::Constant::kFloatMat2},
{"FLOAT_MAT3", V8WebGL2RenderingContext::Constant::kFloatMat3},
{"FLOAT_MAT4", V8WebGL2RenderingContext::Constant::kFloatMat4},
{"SAMPLER_2D", V8WebGL2RenderingContext::Constant::kSampler2d},
{"SAMPLER_CUBE", V8WebGL2RenderingContext::Constant::kSamplerCube},
{"VERTEX_ATTRIB_ARRAY_ENABLED", V8WebGL2RenderingContext::Constant::kVertexAttribArrayEnabled},
{"VERTEX_ATTRIB_ARRAY_SIZE", V8WebGL2RenderingContext::Constant::kVertexAttribArraySize},
{"VERTEX_ATTRIB_ARRAY_STRIDE", V8WebGL2RenderingContext::Constant::kVertexAttribArrayStride},
{"VERTEX_ATTRIB_ARRAY_TYPE", V8WebGL2RenderingContext::Constant::kVertexAttribArrayType},
{"VERTEX_ATTRIB_ARRAY_NORMALIZED", V8WebGL2RenderingContext::Constant::kVertexAttribArrayNormalized},
{"VERTEX_ATTRIB_ARRAY_POINTER", V8WebGL2RenderingContext::Constant::kVertexAttribArrayPointer},
{"VERTEX_ATTRIB_ARRAY_BUFFER_BINDING", V8WebGL2RenderingContext::Constant::kVertexAttribArrayBufferBinding},
{"IMPLEMENTATION_COLOR_READ_TYPE", V8WebGL2RenderingContext::Constant::kImplementationColorReadType},
{"IMPLEMENTATION_COLOR_READ_FORMAT", V8WebGL2RenderingContext::Constant::kImplementationColorReadFormat},
{"COMPILE_STATUS", V8WebGL2RenderingContext::Constant::kCompileStatus},
{"LOW_FLOAT", V8WebGL2RenderingContext::Constant::kLowFloat},
{"MEDIUM_FLOAT", V8WebGL2RenderingContext::Constant::kMediumFloat},
{"HIGH_FLOAT", V8WebGL2RenderingContext::Constant::kHighFloat},
{"LOW_INT", V8WebGL2RenderingContext::Constant::kLowInt},
{"MEDIUM_INT", V8WebGL2RenderingContext::Constant::kMediumInt},
{"HIGH_INT", V8WebGL2RenderingContext::Constant::kHighInt},
{"FRAMEBUFFER", V8WebGL2RenderingContext::Constant::kFramebuffer},
{"RENDERBUFFER", V8WebGL2RenderingContext::Constant::kRenderbuffer},
{"RGBA4", V8WebGL2RenderingContext::Constant::kRgba4},
{"RGB5_A1", V8WebGL2RenderingContext::Constant::kRgb5A1},
{"RGB565", V8WebGL2RenderingContext::Constant::kRgb565},
{"DEPTH_COMPONENT16", V8WebGL2RenderingContext::Constant::kDepthComponent16},
{"STENCIL_INDEX8", V8WebGL2RenderingContext::Constant::kStencilIndex8},
{"DEPTH_STENCIL", V8WebGL2RenderingContext::Constant::kDepthStencil},
{"RENDERBUFFER_WIDTH", V8WebGL2RenderingContext::Constant::kRenderbufferWidth},
{"RENDERBUFFER_HEIGHT", V8WebGL2RenderingContext::Constant::kRenderbufferHeight},
{"RENDERBUFFER_INTERNAL_FORMAT", V8WebGL2RenderingContext::Constant::kRenderbufferInternalFormat},
{"RENDERBUFFER_RED_SIZE", V8WebGL2RenderingContext::Constant::kRenderbufferRedSize},
{"RENDERBUFFER_GREEN_SIZE", V8WebGL2RenderingContext::Constant::kRenderbufferGreenSize},
{"RENDERBUFFER_BLUE_SIZE", V8WebGL2RenderingContext::Constant::kRenderbufferBlueSize},
{"RENDERBUFFER_ALPHA_SIZE", V8WebGL2RenderingContext::Constant::kRenderbufferAlphaSize},
{"RENDERBUFFER_DEPTH_SIZE", V8WebGL2RenderingContext::Constant::kRenderbufferDepthSize},
{"RENDERBUFFER_STENCIL_SIZE", V8WebGL2RenderingContext::Constant::kRenderbufferStencilSize},
{"FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE", V8WebGL2RenderingContext::Constant::kFramebufferAttachmentObjectType},
{"FRAMEBUFFER_ATTACHMENT_OBJECT_NAME", V8WebGL2RenderingContext::Constant::kFramebufferAttachmentObjectName},
{"FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL", V8WebGL2RenderingContext::Constant::kFramebufferAttachmentTextureLevel},
{"FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE", V8WebGL2RenderingContext::Constant::kFramebufferAttachmentTextureCubeMapFace},
{"COLOR_ATTACHMENT0", V8WebGL2RenderingContext::Constant::kColorAttachment0},
{"DEPTH_ATTACHMENT", V8WebGL2RenderingContext::Constant::kDepthAttachment},
{"STENCIL_ATTACHMENT", V8WebGL2RenderingContext::Constant::kStencilAttachment},
{"DEPTH_STENCIL_ATTACHMENT", V8WebGL2RenderingContext::Constant::kDepthStencilAttachment},
{"NONE", V8WebGL2RenderingContext::Constant::kNone},
{"FRAMEBUFFER_COMPLETE", V8WebGL2RenderingContext::Constant::kFramebufferComplete},
{"FRAMEBUFFER_INCOMPLETE_ATTACHMENT", V8WebGL2RenderingContext::Constant::kFramebufferIncompleteAttachment},
{"FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT", V8WebGL2RenderingContext::Constant::kFramebufferIncompleteMissingAttachment},
{"FRAMEBUFFER_INCOMPLETE_DIMENSIONS", V8WebGL2RenderingContext::Constant::kFramebufferIncompleteDimensions},
{"FRAMEBUFFER_UNSUPPORTED", V8WebGL2RenderingContext::Constant::kFramebufferUnsupported},
{"FRAMEBUFFER_BINDING", V8WebGL2RenderingContext::Constant::kFramebufferBinding},
{"RENDERBUFFER_BINDING", V8WebGL2RenderingContext::Constant::kRenderbufferBinding},
{"MAX_RENDERBUFFER_SIZE", V8WebGL2RenderingContext::Constant::kMaxRenderbufferSize},
{"INVALID_FRAMEBUFFER_OPERATION", V8WebGL2RenderingContext::Constant::kInvalidFramebufferOperation},
{"UNPACK_FLIP_Y_WEBGL", V8WebGL2RenderingContext::Constant::kUnpackFlipYWebgl},
{"UNPACK_PREMULTIPLY_ALPHA_WEBGL", V8WebGL2RenderingContext::Constant::kUnpackPremultiplyAlphaWebgl},
{"CONTEXT_LOST_WEBGL", V8WebGL2RenderingContext::Constant::kContextLostWebgl},
{"UNPACK_COLORSPACE_CONVERSION_WEBGL", V8WebGL2RenderingContext::Constant::kUnpackColorspaceConversionWebgl},
{"BROWSER_DEFAULT_WEBGL", V8WebGL2RenderingContext::Constant::kBrowserDefaultWebgl},
{"READ_BUFFER", V8WebGL2RenderingContext::Constant::kReadBuffer},
{"UNPACK_ROW_LENGTH", V8WebGL2RenderingContext::Constant::kUnpackRowLength},
{"UNPACK_SKIP_ROWS", V8WebGL2RenderingContext::Constant::kUnpackSkipRows},
{"UNPACK_SKIP_PIXELS", V8WebGL2RenderingContext::Constant::kUnpackSkipPixels},
{"PACK_ROW_LENGTH", V8WebGL2RenderingContext::Constant::kPackRowLength},
{"PACK_SKIP_ROWS", V8WebGL2RenderingContext::Constant::kPackSkipRows},
{"PACK_SKIP_PIXELS", V8WebGL2RenderingContext::Constant::kPackSkipPixels},
{"COLOR", V8WebGL2RenderingContext::Constant::kColor},
{"DEPTH", V8WebGL2RenderingContext::Constant::kDepth},
{"STENCIL", V8WebGL2RenderingContext::Constant::kStencil},
{"RED", V8WebGL2RenderingContext::Constant::kRed},
{"RGB8", V8WebGL2RenderingContext::Constant::kRgb8},
{"RGBA8", V8WebGL2RenderingContext::Constant::kRgba8},
{"RGB10_A2", V8WebGL2RenderingContext::Constant::kRgb10A2},
{"TEXTURE_BINDING_3D", V8WebGL2RenderingContext::Constant::kTextureBinding3d},
{"UNPACK_SKIP_IMAGES", V8WebGL2RenderingContext::Constant::kUnpackSkipImages},
{"UNPACK_IMAGE_HEIGHT", V8WebGL2RenderingContext::Constant::kUnpackImageHeight},
{"TEXTURE_3D", V8WebGL2RenderingContext::Constant::kTexture3d},
{"TEXTURE_WRAP_R", V8WebGL2RenderingContext::Constant::kTextureWrapR},
{"MAX_3D_TEXTURE_SIZE", V8WebGL2RenderingContext::Constant::kMax3dTextureSize},
{"UNSIGNED_INT_2_10_10_10_REV", V8WebGL2RenderingContext::Constant::kUnsignedInt2101010Rev},
{"MAX_ELEMENTS_VERTICES", V8WebGL2RenderingContext::Constant::kMaxElementsVertices},
{"MAX_ELEMENTS_INDICES", V8WebGL2RenderingContext::Constant::kMaxElementsIndices},
{"TEXTURE_MIN_LOD", V8WebGL2RenderingContext::Constant::kTextureMinLod},
{"TEXTURE_MAX_LOD", V8WebGL2RenderingContext::Constant::kTextureMaxLod},
{"TEXTURE_BASE_LEVEL", V8WebGL2RenderingContext::Constant::kTextureBaseLevel},
{"TEXTURE_MAX_LEVEL", V8WebGL2RenderingContext::Constant::kTextureMaxLevel},
{"MIN", V8WebGL2RenderingContext::Constant::kMin},
{"MAX", V8WebGL2RenderingContext::Constant::kMax},
{"DEPTH_COMPONENT24", V8WebGL2RenderingContext::Constant::kDepthComponent24},
{"MAX_TEXTURE_LOD_BIAS", V8WebGL2RenderingContext::Constant::kMaxTextureLodBias},
{"TEXTURE_COMPARE_MODE", V8WebGL2RenderingContext::Constant::kTextureCompareMode},
{"TEXTURE_COMPARE_FUNC", V8WebGL2RenderingContext::Constant::kTextureCompareFunc},
{"CURRENT_QUERY", V8WebGL2RenderingContext::Constant::kCurrentQuery},
{"QUERY_RESULT", V8WebGL2RenderingContext::Constant::kQueryResult},
{"QUERY_RESULT_AVAILABLE", V8WebGL2RenderingContext::Constant::kQueryResultAvailable},
{"STREAM_READ", V8WebGL2RenderingContext::Constant::kStreamRead},
{"STREAM_COPY", V8WebGL2RenderingContext::Constant::kStreamCopy},
{"STATIC_READ", V8WebGL2RenderingContext::Constant::kStaticRead},
{"STATIC_COPY", V8WebGL2RenderingContext::Constant::kStaticCopy},
{"DYNAMIC_READ", V8WebGL2RenderingContext::Constant::kDynamicRead},
{"DYNAMIC_COPY", V8WebGL2RenderingContext::Constant::kDynamicCopy},
{"MAX_DRAW_BUFFERS", V8WebGL2RenderingContext::Constant::kMaxDrawBuffers},
{"DRAW_BUFFER0", V8WebGL2RenderingContext::Constant::kDrawBuffer0},
{"DRAW_BUFFER1", V8WebGL2RenderingContext::Constant::kDrawBuffer1},
{"DRAW_BUFFER2", V8WebGL2RenderingContext::Constant::kDrawBuffer2},
{"DRAW_BUFFER3", V8WebGL2RenderingContext::Constant::kDrawBuffer3},
{"DRAW_BUFFER4", V8WebGL2RenderingContext::Constant::kDrawBuffer4},
{"DRAW_BUFFER5", V8WebGL2RenderingContext::Constant::kDrawBuffer5},
{"DRAW_BUFFER6", V8WebGL2RenderingContext::Constant::kDrawBuffer6},
{"DRAW_BUFFER7", V8WebGL2RenderingContext::Constant::kDrawBuffer7},
{"DRAW_BUFFER8", V8WebGL2RenderingContext::Constant::kDrawBuffer8},
{"DRAW_BUFFER9", V8WebGL2RenderingContext::Constant::kDrawBuffer9},
{"DRAW_BUFFER10", V8WebGL2RenderingContext::Constant::kDrawBuffer10},
{"DRAW_BUFFER11", V8WebGL2RenderingContext::Constant::kDrawBuffer11},
{"DRAW_BUFFER12", V8WebGL2RenderingContext::Constant::kDrawBuffer12},
{"DRAW_BUFFER13", V8WebGL2RenderingContext::Constant::kDrawBuffer13},
{"DRAW_BUFFER14", V8WebGL2RenderingContext::Constant::kDrawBuffer14},
{"DRAW_BUFFER15", V8WebGL2RenderingContext::Constant::kDrawBuffer15},
{"MAX_FRAGMENT_UNIFORM_COMPONENTS", V8WebGL2RenderingContext::Constant::kMaxFragmentUniformComponents},
{"MAX_VERTEX_UNIFORM_COMPONENTS", V8WebGL2RenderingContext::Constant::kMaxVertexUniformComponents},
{"SAMPLER_3D", V8WebGL2RenderingContext::Constant::kSampler3d},
{"SAMPLER_2D_SHADOW", V8WebGL2RenderingContext::Constant::kSampler2dShadow},
{"FRAGMENT_SHADER_DERIVATIVE_HINT", V8WebGL2RenderingContext::Constant::kFragmentShaderDerivativeHint},
{"PIXEL_PACK_BUFFER", V8WebGL2RenderingContext::Constant::kPixelPackBuffer},
{"PIXEL_UNPACK_BUFFER", V8WebGL2RenderingContext::Constant::kPixelUnpackBuffer},
{"PIXEL_PACK_BUFFER_BINDING", V8WebGL2RenderingContext::Constant::kPixelPackBufferBinding},
{"PIXEL_UNPACK_BUFFER_BINDING", V8WebGL2RenderingContext::Constant::kPixelUnpackBufferBinding},
{"FLOAT_MAT2x3", V8WebGL2RenderingContext::Constant::kFloatMat2X3},
{"FLOAT_MAT2x4", V8WebGL2RenderingContext::Constant::kFloatMat2X4},
{"FLOAT_MAT3x2", V8WebGL2RenderingContext::Constant::kFloatMat3X2},
{"FLOAT_MAT3x4", V8WebGL2RenderingContext::Constant::kFloatMat3X4},
{"FLOAT_MAT4x2", V8WebGL2RenderingContext::Constant::kFloatMat4X2},
{"FLOAT_MAT4x3", V8WebGL2RenderingContext::Constant::kFloatMat4X3},
{"SRGB", V8WebGL2RenderingContext::Constant::kSRGB},
{"SRGB8", V8WebGL2RenderingContext::Constant::kSRGB8},
{"SRGB8_ALPHA8", V8WebGL2RenderingContext::Constant::kSRGB8Alpha8},
{"COMPARE_REF_TO_TEXTURE", V8WebGL2RenderingContext::Constant::kCompareRefToTexture},
{"RGBA32F", V8WebGL2RenderingContext::Constant::kRgba32F},
{"RGB32F", V8WebGL2RenderingContext::Constant::kRgb32F},
{"RGBA16F", V8WebGL2RenderingContext::Constant::kRgba16F},
{"RGB16F", V8WebGL2RenderingContext::Constant::kRgb16F},
{"VERTEX_ATTRIB_ARRAY_INTEGER", V8WebGL2RenderingContext::Constant::kVertexAttribArrayInteger},
{"MAX_ARRAY_TEXTURE_LAYERS", V8WebGL2RenderingContext::Constant::kMaxArrayTextureLayers},
{"MIN_PROGRAM_TEXEL_OFFSET", V8WebGL2RenderingContext::Constant::kMinProgramTexelOffset},
{"MAX_PROGRAM_TEXEL_OFFSET", V8WebGL2RenderingContext::Constant::kMaxProgramTexelOffset},
{"MAX_VARYING_COMPONENTS", V8WebGL2RenderingContext::Constant::kMaxVaryingComponents},
{"TEXTURE_2D_ARRAY", V8WebGL2RenderingContext::Constant::kTexture2dArray},
{"TEXTURE_BINDING_2D_ARRAY", V8WebGL2RenderingContext::Constant::kTextureBinding2dArray},
{"R11F_G11F_B10F", V8WebGL2RenderingContext::Constant::kR11FG11FB10F},
{"UNSIGNED_INT_10F_11F_11F_REV", V8WebGL2RenderingContext::Constant::kUnsignedInt10F11F11FRev},
{"RGB9_E5", V8WebGL2RenderingContext::Constant::kRgb9E5},
{"UNSIGNED_INT_5_9_9_9_REV", V8WebGL2RenderingContext::Constant::kUnsignedInt5999Rev},
{"TRANSFORM_FEEDBACK_BUFFER_MODE", V8WebGL2RenderingContext::Constant::kTransformFeedbackBufferMode},
{"MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS", V8WebGL2RenderingContext::Constant::kMaxTransformFeedbackSeparateComponents},
{"TRANSFORM_FEEDBACK_VARYINGS", V8WebGL2RenderingContext::Constant::kTransformFeedbackVaryings},
{"TRANSFORM_FEEDBACK_BUFFER_START", V8WebGL2RenderingContext::Constant::kTransformFeedbackBufferStart},
{"TRANSFORM_FEEDBACK_BUFFER_SIZE", V8WebGL2RenderingContext::Constant::kTransformFeedbackBufferSize},
{"TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN", V8WebGL2RenderingContext::Constant::kTransformFeedbackPrimitivesWritten},
{"RASTERIZER_DISCARD", V8WebGL2RenderingContext::Constant::kRasterizerDiscard},
{"MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS", V8WebGL2RenderingContext::Constant::kMaxTransformFeedbackInterleavedComponents},
{"MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS", V8WebGL2RenderingContext::Constant::kMaxTransformFeedbackSeparateAttribs},
{"INTERLEAVED_ATTRIBS", V8WebGL2RenderingContext::Constant::kInterleavedAttribs},
{"SEPARATE_ATTRIBS", V8WebGL2RenderingContext::Constant::kSeparateAttribs},
{"TRANSFORM_FEEDBACK_BUFFER", V8WebGL2RenderingContext::Constant::kTransformFeedbackBuffer},
{"TRANSFORM_FEEDBACK_BUFFER_BINDING", V8WebGL2RenderingContext::Constant::kTransformFeedbackBufferBinding},
{"RGBA32UI", V8WebGL2RenderingContext::Constant::kRgba32Ui},
{"RGB32UI", V8WebGL2RenderingContext::Constant::kRgb32Ui},
{"RGBA16UI", V8WebGL2RenderingContext::Constant::kRgba16Ui},
{"RGB16UI", V8WebGL2RenderingContext::Constant::kRgb16Ui},
{"RGBA8UI", V8WebGL2RenderingContext::Constant::kRgba8Ui},
{"RGB8UI", V8WebGL2RenderingContext::Constant::kRgb8Ui},
{"RGBA32I", V8WebGL2RenderingContext::Constant::kRgba32I},
{"RGB32I", V8WebGL2RenderingContext::Constant::kRgb32I},
{"RGBA16I", V8WebGL2RenderingContext::Constant::kRgba16I},
{"RGB16I", V8WebGL2RenderingContext::Constant::kRgb16I},
{"RGBA8I", V8WebGL2RenderingContext::Constant::kRgba8I},
{"RGB8I", V8WebGL2RenderingContext::Constant::kRgb8I},
{"RED_INTEGER", V8WebGL2RenderingContext::Constant::kRedInteger},
{"RGB_INTEGER", V8WebGL2RenderingContext::Constant::kRgbInteger},
{"RGBA_INTEGER", V8WebGL2RenderingContext::Constant::kRgbaInteger},
{"SAMPLER_2D_ARRAY", V8WebGL2RenderingContext::Constant::kSampler2dArray},
{"SAMPLER_2D_ARRAY_SHADOW", V8WebGL2RenderingContext::Constant::kSampler2dArrayShadow},
{"SAMPLER_CUBE_SHADOW", V8WebGL2RenderingContext::Constant::kSamplerCubeShadow},
{"UNSIGNED_INT_VEC2", V8WebGL2RenderingContext::Constant::kUnsignedIntVec2},
{"UNSIGNED_INT_VEC3", V8WebGL2RenderingContext::Constant::kUnsignedIntVec3},
{"UNSIGNED_INT_VEC4", V8WebGL2RenderingContext::Constant::kUnsignedIntVec4},
{"INT_SAMPLER_2D", V8WebGL2RenderingContext::Constant::kIntSampler2d},
{"INT_SAMPLER_3D", V8WebGL2RenderingContext::Constant::kIntSampler3d},
{"INT_SAMPLER_CUBE", V8WebGL2RenderingContext::Constant::kIntSamplerCube},
{"INT_SAMPLER_2D_ARRAY", V8WebGL2RenderingContext::Constant::kIntSampler2dArray},
{"UNSIGNED_INT_SAMPLER_2D", V8WebGL2RenderingContext::Constant::kUnsignedIntSampler2d},
{"UNSIGNED_INT_SAMPLER_3D", V8WebGL2RenderingContext::Constant::kUnsignedIntSampler3d},
{"UNSIGNED_INT_SAMPLER_CUBE", V8WebGL2RenderingContext::Constant::kUnsignedIntSamplerCube},
{"UNSIGNED_INT_SAMPLER_2D_ARRAY", V8WebGL2RenderingContext::Constant::kUnsignedIntSampler2dArray},
{"DEPTH_COMPONENT32F", V8WebGL2RenderingContext::Constant::kDepthComponent32F},
{"DEPTH32F_STENCIL8", V8WebGL2RenderingContext::Constant::kDepth32FStencil8},
{"FLOAT_32_UNSIGNED_INT_24_8_REV", V8WebGL2RenderingContext::Constant::kFloat32UnsignedInt248Rev},
{"FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING", V8WebGL2RenderingContext::Constant::kFramebufferAttachmentColorEncoding},
{"FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE", V8WebGL2RenderingContext::Constant::kFramebufferAttachmentComponentType},
{"FRAMEBUFFER_ATTACHMENT_RED_SIZE", V8WebGL2RenderingContext::Constant::kFramebufferAttachmentRedSize},
{"FRAMEBUFFER_ATTACHMENT_GREEN_SIZE", V8WebGL2RenderingContext::Constant::kFramebufferAttachmentGreenSize},
{"FRAMEBUFFER_ATTACHMENT_BLUE_SIZE", V8WebGL2RenderingContext::Constant::kFramebufferAttachmentBlueSize},
{"FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE", V8WebGL2RenderingContext::Constant::kFramebufferAttachmentAlphaSize},
{"FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE", V8WebGL2RenderingContext::Constant::kFramebufferAttachmentDepthSize},
{"FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE", V8WebGL2RenderingContext::Constant::kFramebufferAttachmentStencilSize},
{"FRAMEBUFFER_DEFAULT", V8WebGL2RenderingContext::Constant::kFramebufferDefault},
{"UNSIGNED_INT_24_8", V8WebGL2RenderingContext::Constant::kUnsignedInt248},
{"DEPTH24_STENCIL8", V8WebGL2RenderingContext::Constant::kDepth24Stencil8},
{"UNSIGNED_NORMALIZED", V8WebGL2RenderingContext::Constant::kUnsignedNormalized},
{"DRAW_FRAMEBUFFER_BINDING", V8WebGL2RenderingContext::Constant::kDrawFramebufferBinding},
{"READ_FRAMEBUFFER", V8WebGL2RenderingContext::Constant::kReadFramebuffer},
{"DRAW_FRAMEBUFFER", V8WebGL2RenderingContext::Constant::kDrawFramebuffer},
{"READ_FRAMEBUFFER_BINDING", V8WebGL2RenderingContext::Constant::kReadFramebufferBinding},
{"RENDERBUFFER_SAMPLES", V8WebGL2RenderingContext::Constant::kRenderbufferSamples},
{"FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER", V8WebGL2RenderingContext::Constant::kFramebufferAttachmentTextureLayer},
{"MAX_COLOR_ATTACHMENTS", V8WebGL2RenderingContext::Constant::kMaxColorAttachments},
{"COLOR_ATTACHMENT1", V8WebGL2RenderingContext::Constant::kColorAttachment1},
{"COLOR_ATTACHMENT2", V8WebGL2RenderingContext::Constant::kColorAttachment2},
{"COLOR_ATTACHMENT3", V8WebGL2RenderingContext::Constant::kColorAttachment3},
{"COLOR_ATTACHMENT4", V8WebGL2RenderingContext::Constant::kColorAttachment4},
{"COLOR_ATTACHMENT5", V8WebGL2RenderingContext::Constant::kColorAttachment5},
{"COLOR_ATTACHMENT6", V8WebGL2RenderingContext::Constant::kColorAttachment6},
{"COLOR_ATTACHMENT7", V8WebGL2RenderingContext::Constant::kColorAttachment7},
{"COLOR_ATTACHMENT8", V8WebGL2RenderingContext::Constant::kColorAttachment8},
{"COLOR_ATTACHMENT9", V8WebGL2RenderingContext::Constant::kColorAttachment9},
{"COLOR_ATTACHMENT10", V8WebGL2RenderingContext::Constant::kColorAttachment10},
{"COLOR_ATTACHMENT11", V8WebGL2RenderingContext::Constant::kColorAttachment11},
{"COLOR_ATTACHMENT12", V8WebGL2RenderingContext::Constant::kColorAttachment12},
{"COLOR_ATTACHMENT13", V8WebGL2RenderingContext::Constant::kColorAttachment13},
{"COLOR_ATTACHMENT14", V8WebGL2RenderingContext::Constant::kColorAttachment14},
{"COLOR_ATTACHMENT15", V8WebGL2RenderingContext::Constant::kColorAttachment15},
{"FRAMEBUFFER_INCOMPLETE_MULTISAMPLE", V8WebGL2RenderingContext::Constant::kFramebufferIncompleteMultisample},
{"MAX_SAMPLES", V8WebGL2RenderingContext::Constant::kMaxSamples},
{"HALF_FLOAT", V8WebGL2RenderingContext::Constant::kHalfFloat},
{"RG", V8WebGL2RenderingContext::Constant::kRg},
{"RG_INTEGER", V8WebGL2RenderingContext::Constant::kRgInteger},
{"R8", V8WebGL2RenderingContext::Constant::kR8},
{"RG8", V8WebGL2RenderingContext::Constant::kRg8},
{"R16F", V8WebGL2RenderingContext::Constant::kR16F},
{"R32F", V8WebGL2RenderingContext::Constant::kR32F},
{"RG16F", V8WebGL2RenderingContext::Constant::kRg16F},
{"RG32F", V8WebGL2RenderingContext::Constant::kRg32F},
{"R8I", V8WebGL2RenderingContext::Constant::kR8I},
{"R8UI", V8WebGL2RenderingContext::Constant::kR8Ui},
{"R16I", V8WebGL2RenderingContext::Constant::kR16I},
{"R16UI", V8WebGL2RenderingContext::Constant::kR16Ui},
{"R32I", V8WebGL2RenderingContext::Constant::kR32I},
{"R32UI", V8WebGL2RenderingContext::Constant::kR32Ui},
{"RG8I", V8WebGL2RenderingContext::Constant::kRg8I},
{"RG8UI", V8WebGL2RenderingContext::Constant::kRg8Ui},
{"RG16I", V8WebGL2RenderingContext::Constant::kRg16I},
{"RG16UI", V8WebGL2RenderingContext::Constant::kRg16Ui},
{"RG32I", V8WebGL2RenderingContext::Constant::kRg32I},
{"RG32UI", V8WebGL2RenderingContext::Constant::kRg32Ui},
{"VERTEX_ARRAY_BINDING", V8WebGL2RenderingContext::Constant::kVertexArrayBinding},
{"R8_SNORM", V8WebGL2RenderingContext::Constant::kR8Snorm},
{"RG8_SNORM", V8WebGL2RenderingContext::Constant::kRg8Snorm},
{"RGB8_SNORM", V8WebGL2RenderingContext::Constant::kRgb8Snorm},
{"RGBA8_SNORM", V8WebGL2RenderingContext::Constant::kRgba8Snorm},
{"SIGNED_NORMALIZED", V8WebGL2RenderingContext::Constant::kSignedNormalized},
{"COPY_READ_BUFFER", V8WebGL2RenderingContext::Constant::kCopyReadBuffer},
{"COPY_WRITE_BUFFER", V8WebGL2RenderingContext::Constant::kCopyWriteBuffer},
{"COPY_READ_BUFFER_BINDING", V8WebGL2RenderingContext::Constant::kCopyReadBufferBinding},
{"COPY_WRITE_BUFFER_BINDING", V8WebGL2RenderingContext::Constant::kCopyWriteBufferBinding},
{"UNIFORM_BUFFER", V8WebGL2RenderingContext::Constant::kUniformBuffer},
{"UNIFORM_BUFFER_BINDING", V8WebGL2RenderingContext::Constant::kUniformBufferBinding},
{"UNIFORM_BUFFER_START", V8WebGL2RenderingContext::Constant::kUniformBufferStart},
{"UNIFORM_BUFFER_SIZE", V8WebGL2RenderingContext::Constant::kUniformBufferSize},
{"MAX_VERTEX_UNIFORM_BLOCKS", V8WebGL2RenderingContext::Constant::kMaxVertexUniformBlocks},
{"MAX_FRAGMENT_UNIFORM_BLOCKS", V8WebGL2RenderingContext::Constant::kMaxFragmentUniformBlocks},
{"MAX_COMBINED_UNIFORM_BLOCKS", V8WebGL2RenderingContext::Constant::kMaxCombinedUniformBlocks},
{"MAX_UNIFORM_BUFFER_BINDINGS", V8WebGL2RenderingContext::Constant::kMaxUniformBufferBindings},
{"MAX_UNIFORM_BLOCK_SIZE", V8WebGL2RenderingContext::Constant::kMaxUniformBlockSize},
{"MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS", V8WebGL2RenderingContext::Constant::kMaxCombinedVertexUniformComponents},
{"MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS", V8WebGL2RenderingContext::Constant::kMaxCombinedFragmentUniformComponents},
{"UNIFORM_BUFFER_OFFSET_ALIGNMENT", V8WebGL2RenderingContext::Constant::kUniformBufferOffsetAlignment},
{"ACTIVE_UNIFORM_BLOCKS", V8WebGL2RenderingContext::Constant::kActiveUniformBlocks},
{"UNIFORM_TYPE", V8WebGL2RenderingContext::Constant::kUniformType},
{"UNIFORM_SIZE", V8WebGL2RenderingContext::Constant::kUniformSize},
{"UNIFORM_BLOCK_INDEX", V8WebGL2RenderingContext::Constant::kUniformBlockIndex},
{"UNIFORM_OFFSET", V8WebGL2RenderingContext::Constant::kUniformOffset},
{"UNIFORM_ARRAY_STRIDE", V8WebGL2RenderingContext::Constant::kUniformArrayStride},
{"UNIFORM_MATRIX_STRIDE", V8WebGL2RenderingContext::Constant::kUniformMatrixStride},
{"UNIFORM_IS_ROW_MAJOR", V8WebGL2RenderingContext::Constant::kUniformIsRowMajor},
{"UNIFORM_BLOCK_BINDING", V8WebGL2RenderingContext::Constant::kUniformBlockBinding},
{"UNIFORM_BLOCK_DATA_SIZE", V8WebGL2RenderingContext::Constant::kUniformBlockDataSize},
{"UNIFORM_BLOCK_ACTIVE_UNIFORMS", V8WebGL2RenderingContext::Constant::kUniformBlockActiveUniforms},
{"UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES", V8WebGL2RenderingContext::Constant::kUniformBlockActiveUniformIndices},
{"UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER", V8WebGL2RenderingContext::Constant::kUniformBlockReferencedByVertexShader},
{"UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER", V8WebGL2RenderingContext::Constant::kUniformBlockReferencedByFragmentShader},
{"INVALID_INDEX", V8WebGL2RenderingContext::Constant::kInvalidIndex},
{"MAX_VERTEX_OUTPUT_COMPONENTS", V8WebGL2RenderingContext::Constant::kMaxVertexOutputComponents},
{"MAX_FRAGMENT_INPUT_COMPONENTS", V8WebGL2RenderingContext::Constant::kMaxFragmentInputComponents},
{"MAX_SERVER_WAIT_TIMEOUT", V8WebGL2RenderingContext::Constant::kMaxServerWaitTimeout},
{"OBJECT_TYPE", V8WebGL2RenderingContext::Constant::kObjectType},
{"SYNC_CONDITION", V8WebGL2RenderingContext::Constant::kSyncCondition},
{"SYNC_STATUS", V8WebGL2RenderingContext::Constant::kSyncStatus},
{"SYNC_FLAGS", V8WebGL2RenderingContext::Constant::kSyncFlags},
{"SYNC_FENCE", V8WebGL2RenderingContext::Constant::kSyncFence},
{"SYNC_GPU_COMMANDS_COMPLETE", V8WebGL2RenderingContext::Constant::kSyncGpuCommandsComplete},
{"UNSIGNALED", V8WebGL2RenderingContext::Constant::kUnsignaled},
{"SIGNALED", V8WebGL2RenderingContext::Constant::kSignaled},
{"ALREADY_SIGNALED", V8WebGL2RenderingContext::Constant::kAlreadySignaled},
{"TIMEOUT_EXPIRED", V8WebGL2RenderingContext::Constant::kTimeoutExpired},
{"CONDITION_SATISFIED", V8WebGL2RenderingContext::Constant::kConditionSatisfied},
{"WAIT_FAILED", V8WebGL2RenderingContext::Constant::kWaitFailed},
{"SYNC_FLUSH_COMMANDS_BIT", V8WebGL2RenderingContext::Constant::kSyncFlushCommandsBit},
{"VERTEX_ATTRIB_ARRAY_DIVISOR", V8WebGL2RenderingContext::Constant::kVertexAttribArrayDivisor},
{"ANY_SAMPLES_PASSED", V8WebGL2RenderingContext::Constant::kAnySamplesPassed},
{"ANY_SAMPLES_PASSED_CONSERVATIVE", V8WebGL2RenderingContext::Constant::kAnySamplesPassedConservative},
{"SAMPLER_BINDING", V8WebGL2RenderingContext::Constant::kSamplerBinding},
{"RGB10_A2UI", V8WebGL2RenderingContext::Constant::kRgb10A2Ui},
{"INT_2_10_10_10_REV", V8WebGL2RenderingContext::Constant::kInt2101010Rev},
{"TRANSFORM_FEEDBACK", V8WebGL2RenderingContext::Constant::kTransformFeedback},
{"TRANSFORM_FEEDBACK_PAUSED", V8WebGL2RenderingContext::Constant::kTransformFeedbackPaused},
{"TRANSFORM_FEEDBACK_ACTIVE", V8WebGL2RenderingContext::Constant::kTransformFeedbackActive},
{"TRANSFORM_FEEDBACK_BINDING", V8WebGL2RenderingContext::Constant::kTransformFeedbackBinding},
{"TEXTURE_IMMUTABLE_FORMAT", V8WebGL2RenderingContext::Constant::kTextureImmutableFormat},
{"MAX_ELEMENT_INDEX", V8WebGL2RenderingContext::Constant::kMaxElementIndex},
{"TEXTURE_IMMUTABLE_LEVELS", V8WebGL2RenderingContext::Constant::kTextureImmutableLevels},
{"TIMEOUT_IGNORED", V8WebGL2RenderingContext::Constant::kTimeoutIgnored},
{"MAX_CLIENT_WAIT_TIMEOUT_WEBGL", V8WebGL2RenderingContext::Constant::kMaxClientWaitTimeoutWebgl},
};
IDLMemberInstaller::InstallConstants(isolate, world, instance_template, prototype_template, interface_template, signature, kConstantValueTable);
}



{
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"activeTexture", ActiveTextureOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"attachShader", AttachShaderOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"beginQuery", BeginQueryOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"beginTransformFeedback", BeginTransformFeedbackOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"bindAttribLocation", BindAttribLocationOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"bindBufferBase", BindBufferBaseOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"bindBufferRange", BindBufferRangeOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"bindRenderbuffer", BindRenderbufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"bindSampler", BindSamplerOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"bindTransformFeedback", BindTransformFeedbackOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"bindVertexArray", BindVertexArrayOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"blendColor", BlendColorOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"blendEquation", BlendEquationOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"blendEquationSeparate", BlendEquationSeparateOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"blendFunc", BlendFuncOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"blendFuncSeparate", BlendFuncSeparateOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"blitFramebuffer", BlitFramebufferOperationCallback, 10, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"bufferData", BufferDataOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"bufferSubData", BufferSubDataOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"checkFramebufferStatus", CheckFramebufferStatusOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"clientWaitSync", ClientWaitSyncOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"compileShader", CompileShaderOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"compressedTexImage2D", CompressedTexImage2DOperationCallback, 7, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"compressedTexImage3D", CompressedTexImage3DOperationCallback, 8, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"compressedTexSubImage2D", CompressedTexSubImage2DOperationCallback, 8, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"compressedTexSubImage3D", CompressedTexSubImage3DOperationCallback, 10, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"copyBufferSubData", CopyBufferSubDataOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"copyTexImage2D", CopyTexImage2DOperationCallback, 8, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"copyTexSubImage2D", CopyTexSubImage2DOperationCallback, 8, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"copyTexSubImage3D", CopyTexSubImage3DOperationCallback, 9, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createBuffer", CreateBufferOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createFramebuffer", CreateFramebufferOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createProgram", CreateProgramOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createQuery", CreateQueryOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createRenderbuffer", CreateRenderbufferOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createSampler", CreateSamplerOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createShader", CreateShaderOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createTexture", CreateTextureOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createTransformFeedback", CreateTransformFeedbackOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"createVertexArray", CreateVertexArrayOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"cullFace", CullFaceOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteBuffer", DeleteBufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteFramebuffer", DeleteFramebufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteProgram", DeleteProgramOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteQuery", DeleteQueryOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteRenderbuffer", DeleteRenderbufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteSampler", DeleteSamplerOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteShader", DeleteShaderOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteSync", DeleteSyncOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteTexture", DeleteTextureOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteTransformFeedback", DeleteTransformFeedbackOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"deleteVertexArray", DeleteVertexArrayOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"depthFunc", DepthFuncOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"depthMask", DepthMaskOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"depthRange", DepthRangeOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"detachShader", DetachShaderOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"disable", DisableOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"drawArraysInstanced", DrawArraysInstancedOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"drawElementsInstanced", DrawElementsInstancedOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"drawRangeElements", DrawRangeElementsOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"enable", EnableOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"endQuery", EndQueryOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"endTransformFeedback", EndTransformFeedbackOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"fenceSync", FenceSyncOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"finish", FinishOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"flush", FlushOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"framebufferRenderbuffer", FramebufferRenderbufferOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"framebufferTexture2D", FramebufferTexture2DOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"framebufferTextureLayer", FramebufferTextureLayerOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"frontFace", FrontFaceOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"generateMipmap", GenerateMipmapOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getActiveAttrib", GetActiveAttribOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getActiveUniform", GetActiveUniformOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getActiveUniformBlockName", GetActiveUniformBlockNameOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getActiveUniformBlockParameter", GetActiveUniformBlockParameterOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getActiveUniforms", GetActiveUniformsOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getAttachedShaders", GetAttachedShadersOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getAttribLocation", GetAttribLocationOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getBufferParameter", GetBufferParameterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getBufferSubData", GetBufferSubDataOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getContextAttributes", GetContextAttributesOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getError", GetErrorOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getExtension", GetExtensionOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getFragDataLocation", GetFragDataLocationOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getFramebufferAttachmentParameter", GetFramebufferAttachmentParameterOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getIndexedParameter", GetIndexedParameterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getInternalformatParameter", GetInternalformatParameterOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getParameter", GetParameterOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getProgramInfoLog", GetProgramInfoLogOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getProgramParameter", GetProgramParameterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getQuery", GetQueryOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getQueryParameter", GetQueryParameterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getRenderbufferParameter", GetRenderbufferParameterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getSamplerParameter", GetSamplerParameterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getShaderInfoLog", GetShaderInfoLogOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getShaderParameter", GetShaderParameterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getShaderPrecisionFormat", GetShaderPrecisionFormatOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getShaderSource", GetShaderSourceOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getSupportedExtensions", GetSupportedExtensionsOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getSyncParameter", GetSyncParameterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getTexParameter", GetTexParameterOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getTransformFeedbackVarying", GetTransformFeedbackVaryingOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getUniform", GetUniformOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getUniformBlockIndex", GetUniformBlockIndexOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getUniformIndices", GetUniformIndicesOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getUniformLocation", GetUniformLocationOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getVertexAttrib", GetVertexAttribOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"getVertexAttribOffset", GetVertexAttribOffsetOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"hint", HintOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"invalidateFramebuffer", InvalidateFramebufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"invalidateSubFramebuffer", InvalidateSubFramebufferOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isBuffer", IsBufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isContextLost", IsContextLostOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isEnabled", IsEnabledOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isFramebuffer", IsFramebufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isProgram", IsProgramOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isQuery", IsQueryOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isRenderbuffer", IsRenderbufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isSampler", IsSamplerOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isShader", IsShaderOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isSync", IsSyncOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isTexture", IsTextureOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isTransformFeedback", IsTransformFeedbackOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"isVertexArray", IsVertexArrayOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"lineWidth", LineWidthOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"linkProgram", LinkProgramOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"pauseTransformFeedback", PauseTransformFeedbackOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"pixelStorei", PixelStoreiOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"polygonOffset", PolygonOffsetOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"readBuffer", ReadBufferOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"readPixels", ReadPixelsOperationCallback, 7, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"renderbufferStorage", RenderbufferStorageOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"renderbufferStorageMultisample", RenderbufferStorageMultisampleOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"resumeTransformFeedback", ResumeTransformFeedbackOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"sampleCoverage", SampleCoverageOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"samplerParameterf", SamplerParameterfOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"samplerParameteri", SamplerParameteriOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"shaderSource", ShaderSourceOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stencilFunc", StencilFuncOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stencilFuncSeparate", StencilFuncSeparateOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stencilMask", StencilMaskOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stencilMaskSeparate", StencilMaskSeparateOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stencilOp", StencilOpOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"stencilOpSeparate", StencilOpSeparateOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texImage2D", TexImage2DOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texImage3D", TexImage3DOperationCallback, 10, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texParameterf", TexParameterfOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texParameteri", TexParameteriOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texStorage2D", TexStorage2DOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texStorage3D", TexStorage3DOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texSubImage2D", TexSubImage2DOperationCallback, 7, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texSubImage3D", TexSubImage3DOperationCallback, 11, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"transformFeedbackVaryings", TransformFeedbackVaryingsOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"uniform1ui", Uniform1UiOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"uniform2ui", Uniform2UiOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"uniform3ui", Uniform3UiOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"uniform4ui", Uniform4UiOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"uniformBlockBinding", UniformBlockBindingOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"useProgram", UseProgramOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"validateProgram", ValidateProgramOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"vertexAttribDivisor", VertexAttribDivisorOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"vertexAttribI4i", VertexAttribI4IOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"vertexAttribI4ui", VertexAttribI4UiOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"vertexAttribIPointer", VertexAttribIPointerOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"waitSync", WaitSyncOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGL2RenderingContext", kOperationTable);
}


{
  static const v8::CFunction kNoAllocDirectCallOverloadsOfBindBuffer[] = {
v8::CFunctionBuilder().Fn(BindBufferOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfBindFramebuffer[] = {
v8::CFunctionBuilder().Fn(BindFramebufferOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfBindTexture[] = {
v8::CFunctionBuilder().Fn(BindTextureOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClear[] = {
v8::CFunctionBuilder().Fn(ClearOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClearBufferfi[] = {
v8::CFunctionBuilder().Fn(ClearBufferfiOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClearBufferfv[] = {
v8::CFunctionBuilder().Fn(ClearBufferfvOperationNoAllocDirectCallArg4).Build(),
v8::CFunctionBuilder().Fn(ClearBufferfvOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClearBufferiv[] = {
v8::CFunctionBuilder().Fn(ClearBufferivOperationNoAllocDirectCallArg4).Build(),
v8::CFunctionBuilder().Fn(ClearBufferivOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClearBufferuiv[] = {
v8::CFunctionBuilder().Fn(ClearBufferuivOperationNoAllocDirectCallArg4).Build(),
v8::CFunctionBuilder().Fn(ClearBufferuivOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClearColor[] = {
v8::CFunctionBuilder().Fn(ClearColorOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClearDepth[] = {
v8::CFunctionBuilder().Fn(ClearDepthOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfClearStencil[] = {
v8::CFunctionBuilder().Fn(ClearStencilOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfColorMask[] = {
v8::CFunctionBuilder().Fn(ColorMaskOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDisableVertexAttribArray[] = {
v8::CFunctionBuilder().Fn(DisableVertexAttribArrayOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDrawArrays[] = {
v8::CFunctionBuilder().Fn(DrawArraysOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDrawBuffers[] = {
v8::CFunctionBuilder().Fn(DrawBuffersOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfDrawElements[] = {
v8::CFunctionBuilder().Fn(DrawElementsOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfEnableVertexAttribArray[] = {
v8::CFunctionBuilder().Fn(EnableVertexAttribArrayOperationNoAllocDirectCallArg1).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfScissor[] = {
v8::CFunctionBuilder().Fn(ScissorOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform1F[] = {
v8::CFunctionBuilder().Fn(Uniform1FOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform1Fv[] = {
v8::CFunctionBuilder().Fn(Uniform1FvOperationNoAllocDirectCallOverload1Arg2).Build(),
v8::CFunctionBuilder().Fn(Uniform1FvOperationNoAllocDirectCallOverload2Arg4).Build(),
v8::CFunctionBuilder().Fn(Uniform1FvOperationNoAllocDirectCallOverload2Arg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform1I[] = {
v8::CFunctionBuilder().Fn(Uniform1IOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform1Iv[] = {
v8::CFunctionBuilder().Fn(Uniform1IvOperationNoAllocDirectCallOverload1Arg2).Build(),
v8::CFunctionBuilder().Fn(Uniform1IvOperationNoAllocDirectCallOverload2Arg4).Build(),
v8::CFunctionBuilder().Fn(Uniform1IvOperationNoAllocDirectCallOverload2Arg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform1Uiv[] = {
v8::CFunctionBuilder().Fn(Uniform1UivOperationNoAllocDirectCallArg4).Build(),
v8::CFunctionBuilder().Fn(Uniform1UivOperationNoAllocDirectCallArg3).Build(),
v8::CFunctionBuilder().Fn(Uniform1UivOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform2F[] = {
v8::CFunctionBuilder().Fn(Uniform2FOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform2Fv[] = {
v8::CFunctionBuilder().Fn(Uniform2FvOperationNoAllocDirectCallOverload1Arg2).Build(),
v8::CFunctionBuilder().Fn(Uniform2FvOperationNoAllocDirectCallOverload2Arg4).Build(),
v8::CFunctionBuilder().Fn(Uniform2FvOperationNoAllocDirectCallOverload2Arg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform2I[] = {
v8::CFunctionBuilder().Fn(Uniform2IOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform2Iv[] = {
v8::CFunctionBuilder().Fn(Uniform2IvOperationNoAllocDirectCallOverload1Arg2).Build(),
v8::CFunctionBuilder().Fn(Uniform2IvOperationNoAllocDirectCallOverload2Arg4).Build(),
v8::CFunctionBuilder().Fn(Uniform2IvOperationNoAllocDirectCallOverload2Arg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform2Uiv[] = {
v8::CFunctionBuilder().Fn(Uniform2UivOperationNoAllocDirectCallArg4).Build(),
v8::CFunctionBuilder().Fn(Uniform2UivOperationNoAllocDirectCallArg3).Build(),
v8::CFunctionBuilder().Fn(Uniform2UivOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform3F[] = {
v8::CFunctionBuilder().Fn(Uniform3FOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform3Fv[] = {
v8::CFunctionBuilder().Fn(Uniform3FvOperationNoAllocDirectCallOverload1Arg2).Build(),
v8::CFunctionBuilder().Fn(Uniform3FvOperationNoAllocDirectCallOverload2Arg4).Build(),
v8::CFunctionBuilder().Fn(Uniform3FvOperationNoAllocDirectCallOverload2Arg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform3I[] = {
v8::CFunctionBuilder().Fn(Uniform3IOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform3Iv[] = {
v8::CFunctionBuilder().Fn(Uniform3IvOperationNoAllocDirectCallOverload1Arg2).Build(),
v8::CFunctionBuilder().Fn(Uniform3IvOperationNoAllocDirectCallOverload2Arg4).Build(),
v8::CFunctionBuilder().Fn(Uniform3IvOperationNoAllocDirectCallOverload2Arg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform3Uiv[] = {
v8::CFunctionBuilder().Fn(Uniform3UivOperationNoAllocDirectCallArg4).Build(),
v8::CFunctionBuilder().Fn(Uniform3UivOperationNoAllocDirectCallArg3).Build(),
v8::CFunctionBuilder().Fn(Uniform3UivOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform4F[] = {
v8::CFunctionBuilder().Fn(Uniform4FOperationNoAllocDirectCallArg5).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform4Fv[] = {
v8::CFunctionBuilder().Fn(Uniform4FvOperationNoAllocDirectCallOverload1Arg2).Build(),
v8::CFunctionBuilder().Fn(Uniform4FvOperationNoAllocDirectCallOverload2Arg4).Build(),
v8::CFunctionBuilder().Fn(Uniform4FvOperationNoAllocDirectCallOverload2Arg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform4I[] = {
v8::CFunctionBuilder().Fn(Uniform4IOperationNoAllocDirectCallArg5).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform4Iv[] = {
v8::CFunctionBuilder().Fn(Uniform4IvOperationNoAllocDirectCallOverload1Arg2).Build(),
v8::CFunctionBuilder().Fn(Uniform4IvOperationNoAllocDirectCallOverload2Arg4).Build(),
v8::CFunctionBuilder().Fn(Uniform4IvOperationNoAllocDirectCallOverload2Arg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniform4Uiv[] = {
v8::CFunctionBuilder().Fn(Uniform4UivOperationNoAllocDirectCallArg4).Build(),
v8::CFunctionBuilder().Fn(Uniform4UivOperationNoAllocDirectCallArg3).Build(),
v8::CFunctionBuilder().Fn(Uniform4UivOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniformMatrix2Fv[] = {
v8::CFunctionBuilder().Fn(UniformMatrix2FvOperationNoAllocDirectCallOverload1Arg3).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix2FvOperationNoAllocDirectCallOverload2Arg5).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix2FvOperationNoAllocDirectCallOverload2Arg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniformMatrix2X3Fv[] = {
v8::CFunctionBuilder().Fn(UniformMatrix2X3FvOperationNoAllocDirectCallArg5).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix2X3FvOperationNoAllocDirectCallArg4).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix2X3FvOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniformMatrix2X4Fv[] = {
v8::CFunctionBuilder().Fn(UniformMatrix2X4FvOperationNoAllocDirectCallArg5).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix2X4FvOperationNoAllocDirectCallArg4).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix2X4FvOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniformMatrix3Fv[] = {
v8::CFunctionBuilder().Fn(UniformMatrix3FvOperationNoAllocDirectCallOverload1Arg3).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix3FvOperationNoAllocDirectCallOverload2Arg5).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix3FvOperationNoAllocDirectCallOverload2Arg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniformMatrix3X2Fv[] = {
v8::CFunctionBuilder().Fn(UniformMatrix3X2FvOperationNoAllocDirectCallArg5).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix3X2FvOperationNoAllocDirectCallArg4).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix3X2FvOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniformMatrix3X4Fv[] = {
v8::CFunctionBuilder().Fn(UniformMatrix3X4FvOperationNoAllocDirectCallArg5).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix3X4FvOperationNoAllocDirectCallArg4).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix3X4FvOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniformMatrix4Fv[] = {
v8::CFunctionBuilder().Fn(UniformMatrix4FvOperationNoAllocDirectCallOverload1Arg3).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix4FvOperationNoAllocDirectCallOverload2Arg5).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix4FvOperationNoAllocDirectCallOverload2Arg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniformMatrix4X2Fv[] = {
v8::CFunctionBuilder().Fn(UniformMatrix4X2FvOperationNoAllocDirectCallArg5).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix4X2FvOperationNoAllocDirectCallArg4).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix4X2FvOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfUniformMatrix4X3Fv[] = {
v8::CFunctionBuilder().Fn(UniformMatrix4X3FvOperationNoAllocDirectCallArg5).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix4X3FvOperationNoAllocDirectCallArg4).Build(),
v8::CFunctionBuilder().Fn(UniformMatrix4X3FvOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib1F[] = {
v8::CFunctionBuilder().Fn(VertexAttrib1FOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib1Fv[] = {
v8::CFunctionBuilder().Fn(VertexAttrib1FvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib2F[] = {
v8::CFunctionBuilder().Fn(VertexAttrib2FOperationNoAllocDirectCallArg3).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib2Fv[] = {
v8::CFunctionBuilder().Fn(VertexAttrib2FvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib3F[] = {
v8::CFunctionBuilder().Fn(VertexAttrib3FOperationNoAllocDirectCallArg4).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib3Fv[] = {
v8::CFunctionBuilder().Fn(VertexAttrib3FvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib4F[] = {
v8::CFunctionBuilder().Fn(VertexAttrib4FOperationNoAllocDirectCallArg5).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttrib4Fv[] = {
v8::CFunctionBuilder().Fn(VertexAttrib4FvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttribI4Iv[] = {
v8::CFunctionBuilder().Fn(VertexAttribI4IvOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttribI4Uiv[] = {
v8::CFunctionBuilder().Fn(VertexAttribI4UivOperationNoAllocDirectCallArg2).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfVertexAttribPointer[] = {
v8::CFunctionBuilder().Fn(VertexAttribPointerOperationNoAllocDirectCallArg6).Build(),
};
static const v8::CFunction kNoAllocDirectCallOverloadsOfViewport[] = {
v8::CFunctionBuilder().Fn(ViewportOperationNoAllocDirectCallArg4).Build(),
};

static const IDLMemberInstaller::NoAllocDirectCallOperationConfig kOperationTable[] = {
{{"bindBuffer", BindBufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfBindBuffer, std::size(kNoAllocDirectCallOverloadsOfBindBuffer)}, 
{{"bindFramebuffer", BindFramebufferOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfBindFramebuffer, std::size(kNoAllocDirectCallOverloadsOfBindFramebuffer)}, 
{{"bindTexture", BindTextureOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfBindTexture, std::size(kNoAllocDirectCallOverloadsOfBindTexture)}, 
{{"clear", ClearOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClear, std::size(kNoAllocDirectCallOverloadsOfClear)}, 
{{"clearBufferfi", ClearBufferfiOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClearBufferfi, std::size(kNoAllocDirectCallOverloadsOfClearBufferfi)}, 
{{"clearBufferfv", ClearBufferfvOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClearBufferfv, std::size(kNoAllocDirectCallOverloadsOfClearBufferfv)}, 
{{"clearBufferiv", ClearBufferivOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClearBufferiv, std::size(kNoAllocDirectCallOverloadsOfClearBufferiv)}, 
{{"clearBufferuiv", ClearBufferuivOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClearBufferuiv, std::size(kNoAllocDirectCallOverloadsOfClearBufferuiv)}, 
{{"clearColor", ClearColorOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClearColor, std::size(kNoAllocDirectCallOverloadsOfClearColor)}, 
{{"clearDepth", ClearDepthOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClearDepth, std::size(kNoAllocDirectCallOverloadsOfClearDepth)}, 
{{"clearStencil", ClearStencilOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfClearStencil, std::size(kNoAllocDirectCallOverloadsOfClearStencil)}, 
{{"colorMask", ColorMaskOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfColorMask, std::size(kNoAllocDirectCallOverloadsOfColorMask)}, 
{{"disableVertexAttribArray", DisableVertexAttribArrayOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDisableVertexAttribArray, std::size(kNoAllocDirectCallOverloadsOfDisableVertexAttribArray)}, 
{{"drawArrays", DrawArraysOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDrawArrays, std::size(kNoAllocDirectCallOverloadsOfDrawArrays)}, 
{{"drawBuffers", DrawBuffersOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDrawBuffers, std::size(kNoAllocDirectCallOverloadsOfDrawBuffers)}, 
{{"drawElements", DrawElementsOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfDrawElements, std::size(kNoAllocDirectCallOverloadsOfDrawElements)}, 
{{"enableVertexAttribArray", EnableVertexAttribArrayOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfEnableVertexAttribArray, std::size(kNoAllocDirectCallOverloadsOfEnableVertexAttribArray)}, 
{{"scissor", ScissorOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfScissor, std::size(kNoAllocDirectCallOverloadsOfScissor)}, 
{{"uniform1f", Uniform1FOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform1F, std::size(kNoAllocDirectCallOverloadsOfUniform1F)}, 
{{"uniform1fv", Uniform1FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform1Fv, std::size(kNoAllocDirectCallOverloadsOfUniform1Fv)}, 
{{"uniform1i", Uniform1IOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform1I, std::size(kNoAllocDirectCallOverloadsOfUniform1I)}, 
{{"uniform1iv", Uniform1IvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform1Iv, std::size(kNoAllocDirectCallOverloadsOfUniform1Iv)}, 
{{"uniform1uiv", Uniform1UivOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform1Uiv, std::size(kNoAllocDirectCallOverloadsOfUniform1Uiv)}, 
{{"uniform2f", Uniform2FOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform2F, std::size(kNoAllocDirectCallOverloadsOfUniform2F)}, 
{{"uniform2fv", Uniform2FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform2Fv, std::size(kNoAllocDirectCallOverloadsOfUniform2Fv)}, 
{{"uniform2i", Uniform2IOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform2I, std::size(kNoAllocDirectCallOverloadsOfUniform2I)}, 
{{"uniform2iv", Uniform2IvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform2Iv, std::size(kNoAllocDirectCallOverloadsOfUniform2Iv)}, 
{{"uniform2uiv", Uniform2UivOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform2Uiv, std::size(kNoAllocDirectCallOverloadsOfUniform2Uiv)}, 
{{"uniform3f", Uniform3FOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform3F, std::size(kNoAllocDirectCallOverloadsOfUniform3F)}, 
{{"uniform3fv", Uniform3FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform3Fv, std::size(kNoAllocDirectCallOverloadsOfUniform3Fv)}, 
{{"uniform3i", Uniform3IOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform3I, std::size(kNoAllocDirectCallOverloadsOfUniform3I)}, 
{{"uniform3iv", Uniform3IvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform3Iv, std::size(kNoAllocDirectCallOverloadsOfUniform3Iv)}, 
{{"uniform3uiv", Uniform3UivOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform3Uiv, std::size(kNoAllocDirectCallOverloadsOfUniform3Uiv)}, 
{{"uniform4f", Uniform4FOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform4F, std::size(kNoAllocDirectCallOverloadsOfUniform4F)}, 
{{"uniform4fv", Uniform4FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform4Fv, std::size(kNoAllocDirectCallOverloadsOfUniform4Fv)}, 
{{"uniform4i", Uniform4IOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform4I, std::size(kNoAllocDirectCallOverloadsOfUniform4I)}, 
{{"uniform4iv", Uniform4IvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform4Iv, std::size(kNoAllocDirectCallOverloadsOfUniform4Iv)}, 
{{"uniform4uiv", Uniform4UivOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniform4Uiv, std::size(kNoAllocDirectCallOverloadsOfUniform4Uiv)}, 
{{"uniformMatrix2fv", UniformMatrix2FvOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniformMatrix2Fv, std::size(kNoAllocDirectCallOverloadsOfUniformMatrix2Fv)}, 
{{"uniformMatrix2x3fv", UniformMatrix2X3FvOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniformMatrix2X3Fv, std::size(kNoAllocDirectCallOverloadsOfUniformMatrix2X3Fv)}, 
{{"uniformMatrix2x4fv", UniformMatrix2X4FvOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniformMatrix2X4Fv, std::size(kNoAllocDirectCallOverloadsOfUniformMatrix2X4Fv)}, 
{{"uniformMatrix3fv", UniformMatrix3FvOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniformMatrix3Fv, std::size(kNoAllocDirectCallOverloadsOfUniformMatrix3Fv)}, 
{{"uniformMatrix3x2fv", UniformMatrix3X2FvOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniformMatrix3X2Fv, std::size(kNoAllocDirectCallOverloadsOfUniformMatrix3X2Fv)}, 
{{"uniformMatrix3x4fv", UniformMatrix3X4FvOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniformMatrix3X4Fv, std::size(kNoAllocDirectCallOverloadsOfUniformMatrix3X4Fv)}, 
{{"uniformMatrix4fv", UniformMatrix4FvOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniformMatrix4Fv, std::size(kNoAllocDirectCallOverloadsOfUniformMatrix4Fv)}, 
{{"uniformMatrix4x2fv", UniformMatrix4X2FvOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniformMatrix4X2Fv, std::size(kNoAllocDirectCallOverloadsOfUniformMatrix4X2Fv)}, 
{{"uniformMatrix4x3fv", UniformMatrix4X3FvOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfUniformMatrix4X3Fv, std::size(kNoAllocDirectCallOverloadsOfUniformMatrix4X3Fv)}, 
{{"vertexAttrib1f", VertexAttrib1FOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib1F, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib1F)}, 
{{"vertexAttrib1fv", VertexAttrib1FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib1Fv, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib1Fv)}, 
{{"vertexAttrib2f", VertexAttrib2FOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib2F, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib2F)}, 
{{"vertexAttrib2fv", VertexAttrib2FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib2Fv, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib2Fv)}, 
{{"vertexAttrib3f", VertexAttrib3FOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib3F, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib3F)}, 
{{"vertexAttrib3fv", VertexAttrib3FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib3Fv, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib3Fv)}, 
{{"vertexAttrib4f", VertexAttrib4FOperationCallback, 5, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib4F, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib4F)}, 
{{"vertexAttrib4fv", VertexAttrib4FvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttrib4Fv, std::size(kNoAllocDirectCallOverloadsOfVertexAttrib4Fv)}, 
{{"vertexAttribI4iv", VertexAttribI4IvOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttribI4Iv, std::size(kNoAllocDirectCallOverloadsOfVertexAttribI4Iv)}, 
{{"vertexAttribI4uiv", VertexAttribI4UivOperationCallback, 2, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttribI4Uiv, std::size(kNoAllocDirectCallOverloadsOfVertexAttribI4Uiv)}, 
{{"vertexAttribPointer", VertexAttribPointerOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfVertexAttribPointer, std::size(kNoAllocDirectCallOverloadsOfVertexAttribPointer)}, 
{{"viewport", ViewportOperationCallback, 4, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, kNoAllocDirectCallOverloadsOfViewport, std::size(kNoAllocDirectCallOverloadsOfViewport)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGL2RenderingContext", kOperationTable);
}


}

void V8WebGL2RenderingContext::InstallContextIndependentProperties(v8::Isolate* isolate, const DOMWrapperWorld& world, v8::Local<v8::ObjectTemplate> instance_template, v8::Local<v8::ObjectTemplate> prototype_template, v8::Local<v8::Template> interface_template) {
  using bindings::IDLMemberInstaller;

v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
if (RuntimeEnabledFeatures::WebGLDrawingBufferStorageEnabled()) {
  
static const IDLMemberInstaller::AttributeConfig kAttributeTable[] = {
{"drawingBufferFormat", DrawingBufferFormatAttributeGetCallback, nullptr, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasNoSideEffect), unsigned(V8PrivateProperty::CachedAccessor::kNone)},
};
IDLMemberInstaller::InstallAttributes(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGL2RenderingContext", kAttributeTable);
}




if (RuntimeEnabledFeatures::WebGLDrawingBufferStorageEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"drawingBufferStorage", DrawingBufferStorageOperationCallback, 3, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGL2RenderingContext", kOperationTable);
}
if (RuntimeEnabledFeatures::CanvasDrawElementEnabled()) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"setHitTestRegions", SetHitTestRegionsOperationCallback, 1, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texElement2D", TexElement2DOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
{"texElementImage2D", TexElementImage2DOperationCallback, 6, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
IDLMemberInstaller::InstallOperations(isolate, world, instance_template, prototype_template, interface_template, signature, "WebGL2RenderingContext", kOperationTable);
}


}

void V8WebGL2RenderingContext::InstallContextDependentProperties(v8::Local<v8::Context> context, const DOMWrapperWorld& world, v8::Local<v8::Object> instance_object, v8::Local<v8::Object> prototype_object, v8::Local<v8::Object> interface_object, v8::Local<v8::Template> interface_template, FeatureSelector feature_selector) {
  using bindings::IDLMemberInstaller;





v8::Isolate* isolate = v8::Isolate::GetCurrent();
ScriptState* script_state = ScriptState::From(isolate, context);
ExecutionContext* execution_context = ToExecutionContext(script_state);
const bool is_in_secure_context = execution_context->IsSecureContext();
if (is_in_secure_context && (feature_selector.IsAll() && RuntimeEnabledFeatures::WebXREnabled())) {
  static const IDLMemberInstaller::OperationConfig kOperationTable[] = {
{"makeXRCompatible", MakeXRCompatibleOperationCallback, 0, unsigned(v8::None), unsigned(IDLMemberInstaller::FlagLocation::kPrototype), unsigned(IDLMemberInstaller::FlagWorld::kAllWorlds), unsigned(IDLMemberInstaller::FlagReceiverCheck::kDoNotCheck), unsigned(IDLMemberInstaller::FlagCrossOriginCheck::kCheck), unsigned(v8::SideEffectType::kHasSideEffect)}, 
};
v8::Local<v8::Signature> signature = v8::Local<v8::Signature>::Cast(interface_template);
IDLMemberInstaller::InstallOperations(isolate, world, instance_object, prototype_object, interface_object, signature, "WebGL2RenderingContext", kOperationTable);
}


}


}  // namespace blink
