// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_web_print_job_attributes.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"jobName",
"jobPages",
"jobPagesCompleted",
"jobState",
};


}  // namespace 

WebPrintJobAttributes* WebPrintJobAttributes::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  WebPrintJobAttributes* dictionary = MakeGarbageCollected<WebPrintJobAttributes>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "WebPrintJobAttributes";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 WebPrintJobAttributes::WebPrintJobAttributes() {
  
}

 WebPrintJobAttributes::WebPrintJobAttributes(v8::Isolate* isolate) {
  
}



String WebPrintJobAttributes::getJobNameOr(const String& fallback_value) const {
  if (!hasJobName()) {
  return fallback_value;
}
return member_job_name_;
}

String WebPrintJobAttributes::getJobNameOr(String&& fallback_value) const {
  if (!hasJobName()) {
  return std::move(fallback_value);
}
return member_job_name_;
}

void WebPrintJobAttributes::setJobName(const String& value) {
  member_job_name_ = value;
has_job_name_ = true;
}

void WebPrintJobAttributes::setJobName(String&& value) {
  member_job_name_ = std::move(value);
has_job_name_ = true;
}
























void WebPrintJobAttributes::Trace(Visitor* visitor) const {
  bindings::DictionaryBase::Trace(visitor);
}

void WebPrintJobAttributes::FillTemplateProperties(Vector<std::string_view>& properties) const {
  static_assert(std::size(kOwnPropertyNames) == kOwnPropertyCount);
properties.AppendRange(std::cbegin(kOwnPropertyNames), std::cend(kOwnPropertyNames));
DCHECK_EQ(properties.size(), kTotalPropertyCount);
}

void WebPrintJobAttributes::FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const {
  CHECK_EQ(kOwnPropertyCount, values.size());
if (hasJobName()) {
  values[0] = ToV8Traits<IDLUSVString>::ToV8(script_state, member_job_name_);
DCHECK(!values[0].IsEmpty());
}
if (hasJobPages()) {
  values[1] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_job_pages_);
DCHECK(!values[1].IsEmpty());
}
if (hasJobPagesCompleted()) {
  values[2] = ToV8Traits<IDLUnsignedLong>::ToV8(script_state, member_job_pages_completed_);
DCHECK(!values[2].IsEmpty());
}
if (hasJobState()) {
  values[3] = ToV8Traits<V8WebPrintJobState>::ToV8(script_state, member_job_state_);
DCHECK(!values[3].IsEmpty());
}
}

const void* WebPrintJobAttributes::TemplateKey() const {
  static const void *s_key = &s_key;
return s_key;
}

v8::Local<v8::Object> WebPrintJobAttributes::FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const {
  v8::MaybeLocal<v8::Value> values[kTotalPropertyCount];
FillValuesImpl(script_state, values);
return dict_template->NewInstance(script_state->GetContext(), values);
}

void WebPrintJobAttributes::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "WebPrintJobAttributes";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("jobName");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<IDLUSVString, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_job_name_, member_job_name_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("jobPages");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_job_pages_, member_job_pages_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("jobPagesCompleted");
if (!bindings::GetDictionaryMemberFromV8Object<IDLUnsignedLong, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_job_pages_completed_, member_job_pages_completed_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("jobState");
if (!bindings::GetDictionaryMemberFromV8Object<V8WebPrintJobState, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_job_state_, member_job_state_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> WebPrintJobAttributes::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
