// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIEW_OR_CLICK_COUNTS_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIEW_OR_CLICK_COUNTS_H_

#include "base/containers/span.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT ViewOrClickCounts : public bindings::DictionaryBase {
  
  public:
static ViewOrClickCounts* Create() {
  return MakeGarbageCollected<ViewOrClickCounts>();
}
static ViewOrClickCounts* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<ViewOrClickCounts>(isolate);
}
static ViewOrClickCounts* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  ViewOrClickCounts();
explicit  ViewOrClickCounts(v8::Isolate* isolate);

bool hasPast30Days() const {
  return has_past_30_days_;
}
int32_t past30Days() const {
  DCHECK(hasPast30Days());
return member_past_30_days_;
}
int32_t getPast30DaysOr(int32_t fallback_value) const {
  if (!hasPast30Days()) {
  return fallback_value;
}
return member_past_30_days_;
}
void setPast30Days(int32_t value) {
  member_past_30_days_ = value;
has_past_30_days_ = true;
}

bool hasPast90Days() const {
  return has_past_90_days_;
}
int32_t past90Days() const {
  DCHECK(hasPast90Days());
return member_past_90_days_;
}
int32_t getPast90DaysOr(int32_t fallback_value) const {
  if (!hasPast90Days()) {
  return fallback_value;
}
return member_past_90_days_;
}
void setPast90Days(int32_t value) {
  member_past_90_days_ = value;
has_past_90_days_ = true;
}

bool hasPastDay() const {
  return has_past_day_;
}
int32_t pastDay() const {
  DCHECK(hasPastDay());
return member_past_day_;
}
int32_t getPastDayOr(int32_t fallback_value) const {
  if (!hasPastDay()) {
  return fallback_value;
}
return member_past_day_;
}
void setPastDay(int32_t value) {
  member_past_day_ = value;
has_past_day_ = true;
}

bool hasPastHour() const {
  return has_past_hour_;
}
int32_t pastHour() const {
  DCHECK(hasPastHour());
return member_past_hour_;
}
int32_t getPastHourOr(int32_t fallback_value) const {
  if (!hasPastHour()) {
  return fallback_value;
}
return member_past_hour_;
}
void setPastHour(int32_t value) {
  member_past_hour_ = value;
has_past_hour_ = true;
}

bool hasPastWeek() const {
  return has_past_week_;
}
int32_t pastWeek() const {
  DCHECK(hasPastWeek());
return member_past_week_;
}
int32_t getPastWeekOr(int32_t fallback_value) const {
  if (!hasPastWeek()) {
  return fallback_value;
}
return member_past_week_;
}
void setPastWeek(int32_t value) {
  member_past_week_ = value;
has_past_week_ = true;
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 5;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);

bool has_past_30_days_ = false;
bool has_past_90_days_ = false;
bool has_past_day_ = false;
bool has_past_hour_ = false;
bool has_past_week_ = false;

int32_t member_past_30_days_;
int32_t member_past_90_days_;
int32_t member_past_day_;
int32_t member_past_hour_;
int32_t member_past_week_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIEW_OR_CLICK_COUNTS_H_
