// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_video_frame_copy_to_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/core/v8/v8_dom_rect_init.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_plane_layout.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"colorSpace",
"format",
"layout",
"rect",
};


}  // namespace 

VideoFrameCopyToOptions* VideoFrameCopyToOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  VideoFrameCopyToOptions* dictionary = MakeGarbageCollected<VideoFrameCopyToOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "VideoFrameCopyToOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 VideoFrameCopyToOptions::VideoFrameCopyToOptions() {
  
}

 VideoFrameCopyToOptions::VideoFrameCopyToOptions(v8::Isolate* isolate) {
  
}

















HeapVector<Member<PlaneLayout>> VideoFrameCopyToOptions::getLayoutOr(const HeapVector<Member<PlaneLayout>>& fallback_value) const {
  if (!hasLayout()) {
  return fallback_value;
}
return member_layout_;
}

HeapVector<Member<PlaneLayout>> VideoFrameCopyToOptions::getLayoutOr(HeapVector<Member<PlaneLayout>>&& fallback_value) const {
  if (!hasLayout()) {
  return std::move(fallback_value);
}
return member_layout_;
}

void VideoFrameCopyToOptions::setLayout(const HeapVector<Member<PlaneLayout>>& value) {
  member_layout_ = value;
has_layout_ = true;
}

void VideoFrameCopyToOptions::setLayout(HeapVector<Member<PlaneLayout>>&& value) {
  member_layout_ = std::move(value);
has_layout_ = true;
}










void VideoFrameCopyToOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_layout_);
visitor->Trace(member_rect_);
bindings::InputDictionaryBase::Trace(visitor);
}

void VideoFrameCopyToOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "VideoFrameCopyToOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("colorSpace");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<V8PredefinedColorSpace, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_color_space_, member_color_space_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("format");
if (!bindings::GetDictionaryMemberFromV8Object<V8VideoPixelFormat, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_format_, member_format_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("layout");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<PlaneLayout>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_layout_, member_layout_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("rect");
if (!bindings::GetDictionaryMemberFromV8Object<DOMRectInit, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), has_rect_, member_rect_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> VideoFrameCopyToOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
