// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#include "third_party/blink/renderer/bindings/modules/v8/v8_video_encoder_encode_options.h"

#include "third_party/blink/renderer/bindings/core/v8/generated_code_helper.h"
#include "third_party/blink/renderer/bindings/core/v8/native_value_traits_impl.h"
#include "third_party/blink/renderer/bindings/core/v8/to_v8_traits.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_encoder_encode_options_for_av_1.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_encoder_encode_options_for_avc.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_encoder_encode_options_for_hevc.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_encoder_encode_options_for_vp_9.h"
#include "third_party/blink/renderer/modules/webcodecs/video_encoder_buffer.h"
#include "third_party/blink/renderer/platform/bindings/exception_messages.h"
#include "third_party/blink/renderer/platform/bindings/exception_state.h"
#include "third_party/blink/renderer/platform/bindings/v8_per_isolate_data.h"

namespace blink {



namespace  {

const std::string_view kOwnPropertyNames[] = {
"av1",
"avc",
"hevc",
"keyFrame",
"referenceBuffers",
"updateBuffer",
"vp9",
};


}  // namespace 

VideoEncoderEncodeOptions* VideoEncoderEncodeOptions::Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state) {
  VideoEncoderEncodeOptions* dictionary = MakeGarbageCollected<VideoEncoderEncodeOptions>(isolate);
if (v8_value->IsNullOrUndefined()) {
  return dictionary;
}
if (!v8_value->IsObject()) {
  const char* const class_like_name = "VideoEncoderEncodeOptions";
exception_state.ThrowTypeError(ExceptionMessages::ValueNotOfType(class_like_name));
return nullptr;
}
dictionary->FillMembersFromV8Object(isolate, v8_value.As<v8::Object>(), exception_state);
if (exception_state.HadException()) [[unlikely]] {
  return nullptr;
}
return dictionary;
}

 VideoEncoderEncodeOptions::VideoEncoderEncodeOptions() {
  
}

 VideoEncoderEncodeOptions::VideoEncoderEncodeOptions(v8::Isolate* isolate) {
  
}





























HeapVector<Member<VideoEncoderBuffer>> VideoEncoderEncodeOptions::getReferenceBuffersOr(const HeapVector<Member<VideoEncoderBuffer>>& fallback_value) const {
  if (!hasReferenceBuffers()) {
  return fallback_value;
}
return member_reference_buffers_;
}

HeapVector<Member<VideoEncoderBuffer>> VideoEncoderEncodeOptions::getReferenceBuffersOr(HeapVector<Member<VideoEncoderBuffer>>&& fallback_value) const {
  if (!hasReferenceBuffers()) {
  return std::move(fallback_value);
}
return member_reference_buffers_;
}

void VideoEncoderEncodeOptions::setReferenceBuffers(const HeapVector<Member<VideoEncoderBuffer>>& value) {
  member_reference_buffers_ = value;
has_reference_buffers_ = true;
}

void VideoEncoderEncodeOptions::setReferenceBuffers(HeapVector<Member<VideoEncoderBuffer>>&& value) {
  member_reference_buffers_ = std::move(value);
has_reference_buffers_ = true;
}

















void VideoEncoderEncodeOptions::Trace(Visitor* visitor) const {
  visitor->Trace(member_av_1_);
visitor->Trace(member_avc_);
visitor->Trace(member_hevc_);
visitor->Trace(member_reference_buffers_);
visitor->Trace(member_update_buffer_);
visitor->Trace(member_vp_9_);
bindings::InputDictionaryBase::Trace(visitor);
}

void VideoEncoderEncodeOptions::FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state) {
  TryRethrowScope rethrow_scope(isolate, exception_state);
const char* const class_like_name = "VideoEncoderEncodeOptions";
DictionaryConversionContext dictionary_from_v8_context(isolate, class_like_name);
dictionary_from_v8_context.SetCurrentPropertyName("av1");
constexpr bool is_optional = false;
v8::Local<v8::Context> current_context = isolate->GetCurrentContext();
const auto& v8_own_member_names = GetV8OwnMemberNames(isolate);
if (!bindings::GetDictionaryMemberFromV8Object<VideoEncoderEncodeOptionsForAv1, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[0].Get(isolate), has_av_1_, member_av_1_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("avc");
if (!bindings::GetDictionaryMemberFromV8Object<VideoEncoderEncodeOptionsForAvc, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[1].Get(isolate), has_avc_, member_avc_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("hevc");
if (!bindings::GetDictionaryMemberFromV8Object<VideoEncoderEncodeOptionsForHevc, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[2].Get(isolate), has_hevc_, member_hevc_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("keyFrame");
bool fallback_presence_var;
if (!bindings::GetDictionaryMemberFromV8Object<IDLBoolean, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[3].Get(isolate), fallback_presence_var, member_key_frame_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("referenceBuffers");
if (!bindings::GetDictionaryMemberFromV8Object<IDLSequence<VideoEncoderBuffer>, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[4].Get(isolate), has_reference_buffers_, member_reference_buffers_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("updateBuffer");
if (!bindings::GetDictionaryMemberFromV8Object<VideoEncoderBuffer, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[5].Get(isolate), has_update_buffer_, member_update_buffer_, class_like_name, exception_state)) {
  return;
}
dictionary_from_v8_context.SetCurrentPropertyName("vp9");
if (!bindings::GetDictionaryMemberFromV8Object<VideoEncoderEncodeOptionsForVp9, is_optional>(isolate, current_context, v8_dictionary, v8_own_member_names[6].Get(isolate), has_vp_9_, member_vp_9_, class_like_name, exception_state)) {
  return;
}
}

const base::span<const v8::Eternal<v8::Name>> VideoEncoderEncodeOptions::GetV8OwnMemberNames(v8::Isolate* isolate) {
  return V8PerIsolateData::From(isolate)->FindOrCreateEternalNameCache(kOwnPropertyNames, kOwnPropertyNames);
}


}  // namespace blink
