// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

// DO NOT EDIT: This file is auto-generated by
// //third_party/blink/renderer/bindings/scripts/generate_bindings.py
//
// Use the GN flag `blink_enable_generated_code_formatting=true` to enable
// formatting of the generated files.

#ifndef THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_COLOR_SPACE_INIT_H_
#define THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_COLOR_SPACE_INIT_H_

#include <optional>

#include "base/containers/span.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_color_primaries.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_matrix_coefficients.h"
#include "third_party/blink/renderer/bindings/modules/v8/v8_video_transfer_characteristics.h"
#include "third_party/blink/renderer/modules/modules_export.h"
#include "third_party/blink/renderer/platform/bindings/dictionary_base.h"

namespace blink {

class ExceptionState;

class MODULES_EXPORT VideoColorSpaceInit : public bindings::DictionaryBase {
  
  public:
static VideoColorSpaceInit* Create() {
  return MakeGarbageCollected<VideoColorSpaceInit>();
}
static VideoColorSpaceInit* Create(v8::Isolate* isolate) {
  return MakeGarbageCollected<VideoColorSpaceInit>(isolate);
}
static VideoColorSpaceInit* Create(v8::Isolate* isolate, v8::Local<v8::Value> v8_value, ExceptionState& exception_state);

explicit  VideoColorSpaceInit();
explicit  VideoColorSpaceInit(v8::Isolate* isolate);

bool hasFullRange() const {
  return true;
}
const std::optional<bool>& fullRange() const {
  return member_full_range_;
}
void setFullRange(const std::optional<bool>& value) {
  member_full_range_ = value;
}
void setFullRange(bool value) {
  member_full_range_ = value;
}

bool hasMatrix() const {
  return true;
}
const std::optional<V8VideoMatrixCoefficients>& matrix() const {
  return member_matrix_;
}
void setMatrix(const std::optional<V8VideoMatrixCoefficients>& value) {
  member_matrix_ = value;
}
void setMatrix(V8VideoMatrixCoefficients value) {
  member_matrix_ = value;
}
void setMatrix(V8VideoMatrixCoefficients::Enum value) {
  member_matrix_ = V8VideoMatrixCoefficients(value);
}

bool hasPrimaries() const {
  return true;
}
const std::optional<V8VideoColorPrimaries>& primaries() const {
  return member_primaries_;
}
void setPrimaries(const std::optional<V8VideoColorPrimaries>& value) {
  member_primaries_ = value;
}
void setPrimaries(V8VideoColorPrimaries value) {
  member_primaries_ = value;
}
void setPrimaries(V8VideoColorPrimaries::Enum value) {
  member_primaries_ = V8VideoColorPrimaries(value);
}

bool hasTransfer() const {
  return true;
}
const std::optional<V8VideoTransferCharacteristics>& transfer() const {
  return member_transfer_;
}
void setTransfer(const std::optional<V8VideoTransferCharacteristics>& value) {
  member_transfer_ = value;
}
void setTransfer(V8VideoTransferCharacteristics value) {
  member_transfer_ = value;
}
void setTransfer(V8VideoTransferCharacteristics::Enum value) {
  member_transfer_ = V8VideoTransferCharacteristics(value);
}


void Trace(Visitor* visitor) const override;


  protected:
static constexpr size_t kBasePropertyCount = 0;
static constexpr size_t kOwnPropertyCount = 4;
static constexpr size_t kTotalPropertyCount = kBasePropertyCount + kOwnPropertyCount;
void FillTemplateProperties(Vector<std::string_view>& properties) const override;
void FillValuesImpl(ScriptState* script_state, base::span<v8::MaybeLocal<v8::Value>> values) const;


void FillMembersFromV8Object(v8::Isolate* isolate, v8::Local<v8::Object> v8_dictionary, ExceptionState& exception_state);


  private:
const void* TemplateKey() const override;
v8::Local<v8::Object> FillValues(ScriptState* script_state, v8::Local<v8::DictionaryTemplate> dict_template) const override;
static const base::span<const v8::Eternal<v8::Name>> GetV8OwnMemberNames(v8::Isolate* isolate);



std::optional<bool> member_full_range_;
std::optional<V8VideoMatrixCoefficients> member_matrix_;
std::optional<V8VideoColorPrimaries> member_primaries_;
std::optional<V8VideoTransferCharacteristics> member_transfer_;


  
};


}  // namespace blink

#endif  // THIRD_PARTY_BLINK_RENDERER_BINDINGS_MODULES_V8_V8_VIDEO_COLOR_SPACE_INIT_H_
